#include "SettingsMapper.h"

#define PREPMAP(x) sm[#x]=SettingsManager::x;
 
SettingsMapper* SettingsMapper::inst = 0;
using boost::any_cast;

boost::any SettingsMapper::getSetting(const string& skey)
{
  int key = sm[skey];
   if(key >= SettingsManager::STR_FIRST && key < SettingsManager::STR_LAST) 
     return SettingsManager::getInstance()->get((SettingsManager::StrSetting)key);
   else if(key >= SettingsManager::INT_FIRST && key < SettingsManager::INT_LAST)
     return SettingsManager::getInstance()->get((SettingsManager::IntSetting)key);
   else if(key >= SettingsManager::INT64_FIRST && key < SettingsManager::INT64_LAST)
     return SettingsManager::getInstance()->get((SettingsManager::Int64Setting)key);
}

void SettingsMapper::setSetting(const string& skey,const boost::any& value)
{
  int key = sm[skey];
   if(key >= SettingsManager::STR_FIRST && key < SettingsManager::STR_LAST) 
     SettingsManager::getInstance()->set((SettingsManager::StrSetting)key,any_cast<string>(value));
   else if(key >= SettingsManager::INT_FIRST && key < SettingsManager::INT_LAST)
     SettingsManager::getInstance()->set((SettingsManager::IntSetting)key,any_cast<int>(value));
   else if(key >= SettingsManager::INT64_FIRST && key < SettingsManager::INT64_LAST)
     SettingsManager::getInstance()->set((SettingsManager::Int64Setting)key,any_cast<int64_t>(value));
}

SettingsMapper::SettingsMapper()
{
  // HEHE
  // The secret map
  PREPMAP(CONNECTION);
  PREPMAP(DESCRIPTION);
  PREPMAP(DOWNLOAD_DIRECTORY);
  PREPMAP(EMAIL);
  PREPMAP(NICK);
  PREPMAP(SERVER);
  PREPMAP(TEXT_FONT);
  PREPMAP(MAINFRAME_ORDER);
  PREPMAP(MAINFRAME_WIDTHS);
  PREPMAP(HUBFRAME_ORDER);
  PREPMAP(HUBFRAME_WIDTHS);
  PREPMAP(LANGUAGE_FILE);
  PREPMAP(SEARCHFRAME_ORDER);
  PREPMAP(SEARCHFRAME_WIDTHS);
  PREPMAP(FAVORITESFRAME_ORDER);
  PREPMAP(FAVORITESFRAME_WIDTHS);
  PREPMAP(HUBLIST_SERVERS);
  PREPMAP(QUEUEFRAME_ORDER);
  PREPMAP(QUEUEFRAME_WIDTHS);
  PREPMAP(PUBLICHUBSFRAME_ORDER);
  PREPMAP(PUBLICHUBSFRAME_WIDTHS);
  PREPMAP(USERSFRAME_ORDER);
  PREPMAP(USERSFRAME_WIDTHS);
  PREPMAP(HTTP_PROXY);
  PREPMAP(LOG_DIRECTORY);
  PREPMAP(NOTEPAD_TEXT);
  PREPMAP(LOG_FORMAT_POST_DOWNLOAD);
  PREPMAP(LOG_FORMAT_POST_UPLOAD);
  PREPMAP(LOG_FORMAT_MAIN_CHAT);
  PREPMAP(LOG_FORMAT_PRIVATE_CHAT);
  PREPMAP(FINISHED_ORDER);
  PREPMAP(FINISHED_WIDTHS);
  PREPMAP(TEMP_DOWNLOAD_DIRECTORY);
  PREPMAP(BIND_ADDRESS);
  PREPMAP(SOCKS_SERVER);
  PREPMAP(SOCKS_USER);
  PREPMAP(SOCKS_PASSWORD);
  PREPMAP(CONFIG_VERSION);
  PREPMAP(DEFAULT_AWAY_MESSAGE);
  PREPMAP(TIME_STAMPS_FORMAT);
  PREPMAP(ADLSEARCHFRAME_ORDER);
  PREPMAP(ADLSEARCHFRAME_WIDTHS);
  PREPMAP(FINISHED_UL_WIDTHS);
  PREPMAP(FINISHED_UL_ORDER);
  PREPMAP(CLIENT_ID);
  PREPMAP(SPYFRAME_WIDTHS);
  PREPMAP(SPYFRAME_ORDER);
  PREPMAP(LOG_FILE_MAIN_CHAT);
  PREPMAP(LOG_FILE_PRIVATE_CHAT);
  PREPMAP(LOG_FILE_STATUS);
  PREPMAP(LOG_FILE_UPLOAD);
  PREPMAP(LOG_FILE_DOWNLOAD);
  PREPMAP(LOG_FILE_SYSTEM);
  PREPMAP(LOG_FORMAT_SYSTEM);
  PREPMAP(LOG_FORMAT_STATUS);
  PREPMAP(DIRECTORLISTINGFRAME_ORDER);
  PREPMAP(DIRECTORLISTINGFRAME_WIDTHS);
  
  // Ints
  PREPMAP(CONNECTION_TYPE);PREPMAP( IN_PORT);PREPMAP( SLOTS);PREPMAP( ROLLBACK);PREPMAP( AUTO_FOLLOW);PREPMAP( CLEAR_SEARCH);
  PREPMAP(BACKGROUND_COLOR);PREPMAP( TEXT_COLOR);PREPMAP( USE_OEM_MONOFONT);PREPMAP( SHARE_HIDDEN);PREPMAP( FILTER_MESSAGES);PREPMAP( MINIMIZE_TRAY);
  PREPMAP(AUTO_SEARCH);PREPMAP( TIME_STAMPS);PREPMAP( CONFIRM_EXIT);PREPMAP( IGNORE_OFFLINE);PREPMAP( POPUP_OFFLINE);PREPMAP(LIST_DUPES);PREPMAP( BUFFER_SIZE);
PREPMAP( DOWNLOAD_SLOTS);PREPMAP( MAX_DOWNLOAD_SPEED);PREPMAP( LOG_MAIN_CHAT);PREPMAP( LOG_PRIVATE_CHAT);
PREPMAP(LOG_DOWNLOADS);PREPMAP( LOG_UPLOADS);PREPMAP( STATUS_IN_CHAT);PREPMAP( SHOW_JOINS);PREPMAP( PRIVATE_MESSAGE_BEEP);PREPMAP( PRIVATE_MESSAGE_BEEP_OPEN);
PREPMAP(USE_SYSTEM_ICONS);PREPMAP( POPUP_PMS);PREPMAP( MIN_UPLOAD_SPEED);PREPMAP( GET_USER_INFO);PREPMAP( URL_HANDLER);PREPMAP( MAIN_WINDOW_STATE);
 PREPMAP(MAIN_WINDOW_SIZE_X);PREPMAP( MAIN_WINDOW_SIZE_Y);PREPMAP( MAIN_WINDOW_POS_X);PREPMAP( MAIN_WINDOW_POS_Y);PREPMAP( AUTO_AWAY);
 PREPMAP(SMALL_SEND_BUFFER);PREPMAP( SOCKS_PORT);PREPMAP( SOCKS_RESOLVE);PREPMAP( KEEP_LISTS);PREPMAP( AUTO_KICK);PREPMAP( QUEUEFRAME_SHOW_TREE);
 PREPMAP(COMPRESS_TRANSFERS);PREPMAP( SHOW_PROGRESS_BARS);PREPMAP( SFV_CHECK);PREPMAP( MAX_TAB_ROWS);PREPMAP( AUTO_UPDATE_LIST);
 PREPMAP(MAX_COMPRESSION);PREPMAP( FINISHED_DIRTY);PREPMAP( QUEUE_DIRTY);PREPMAP( TAB_DIRTY);PREPMAP( ANTI_FRAG);PREPMAP( MDI_MAXIMIZED);PREPMAP( NO_AWAYMSG_TO_BOTS);
 PREPMAP(SKIP_ZERO_BYTE);PREPMAP( ADLS_BREAK_ON_FIRST);PREPMAP( TAB_COMPLETION);PREPMAP(HUB_USER_COMMANDS);PREPMAP( AUTO_SEARCH_AUTO_MATCH);PREPMAP( UPLOAD_BAR_COLOR);
 PREPMAP( DOWNLOAD_BAR_COLOR);PREPMAP( LOG_SYSTEM);PREPMAP(LOG_FILELIST_TRANSFERS);PREPMAP( SEND_UNKNOWN_COMMANDS);PREPMAP( MAX_HASH_SPEED);PREPMAP( OPEN_USER_CMD_HELP);
PREPMAP(GET_USER_COUNTRY);PREPMAP( FAV_SHOW_JOINS);PREPMAP( LOG_STATUS_MESSAGES);PREPMAP( SHOW_STATUSBAR);
 PREPMAP(
		SHOW_TOOLBAR);PREPMAP( SHOW_TRANSFERVIEW);PREPMAP( POPUNDER_PM);PREPMAP( POPUNDER_FILELIST);PREPMAP( MAGNET_ASK);PREPMAP( MAGNET_ACTION);PREPMAP( MAGNET_REGISTER);PREPMAP(
		ADD_FINISHED_INSTANTLY);PREPMAP( SETTINGS_USE_UPNP);PREPMAP( DONT_DL_ALREADY_SHARED);PREPMAP( SETTINGS_USE_CTRL_FOR_LINE_HISTORY);PREPMAP( CONFIRM_HUB_REMOVAL);PREPMAP( 
		SETTINGS_OPEN_NEW_WINDOW);PREPMAP( UDP_PORT);PREPMAP( SEARCH_ONLY_TTH);PREPMAP( SHOW_LAST_LINES_LOG);PREPMAP( CONFIRM_ITEM_REMOVAL);PREPMAP(
		ADVANCED_RESUME);PREPMAP( ADC_DEBUG);PREPMAP( TOGGLE_ACTIVE_WINDOW);PREPMAP( SEARCH_HISTORY);PREPMAP( SET_MINISLOT_SIZE);PREPMAP(
		PRIO_HIGHEST_SIZE);PREPMAP( PRIO_HIGH_SIZE);PREPMAP( PRIO_NORMAL_SIZE);PREPMAP( PRIO_LOW_SIZE);PREPMAP( PRIO_LOWEST);PREPMAP( 
		OPEN_PUBLIC);PREPMAP( OPEN_FAVORITE_HUBS);PREPMAP( OPEN_FAVORITE_USERS);PREPMAP( OPEN_QUEUE);PREPMAP( OPEN_FINISHED_DOWNLOADS);PREPMAP( 
		OPEN_FINISHED_UPLOADS);PREPMAP( OPEN_SEARCH_SPY);PREPMAP( OPEN_NETWORK_STATISTICS);PREPMAP( OPEN_NOTEPAD);

 // Int64
 PREPMAP(TOTAL_UPLOAD);
 PREPMAP(TOTAL_DOWNLOAD);
}
