/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009 Alexis Megas, 
** Gunther van Dooble, and the Dooble Team. 
** All rights reserved.
**
**
** License: GPL2 only: 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://dooble.net/projects/dooble
**   http://dooble.sf.net
**   http://www.getadooble.com
****************************************************************************/


#include <QMenu>
#include <QTabBar>

#include "dtabwidget.h"

dtabwidget::dtabwidget(QWidget *parent):QTabWidget(parent)
{
  selectedTabIndex = -1;
  setStyleSheet("QTabWidget::tab-bar {"
		"alignment: left; "
		"}");
  tabBar()->setStyleSheet
    ("QTabBar::tear {"
     "image: none; "
     "}");
  tabBar()->setContextMenuPolicy(Qt::CustomContextMenu);
  connect(tabBar(), SIGNAL(customContextMenuRequested(const QPoint &)),
	  SLOT(slotShowContextMenu(const QPoint &)));
#if QT_VERSION >= 0x040500
  setMovable(true);
  setTabsClosable(true);
  connect(this,
	  SIGNAL(tabCloseRequested(int)),
	  this,
	  SLOT(slotCloseTab(int)));
#endif
}

dtabwidget::~dtabwidget()
{
}

void dtabwidget::slotShowContextMenu(const QPoint &point)
{
  selectedTabIndex = tabBar()->tabAt(point);

  if(selectedTabIndex > -1)
    {
      if(tabData(selectedTabIndex).toString() != "Desktop")
	{
	  QMenu menu(this);

	  menu.addAction(tr("Close Ta&b"),
			 this, SLOT(slotCloseTab(void)));
	  menu.actions()[0]->setEnabled(count() != 1);
	  menu.addAction(tr("New &Tab"),
			 this, SLOT(slotCreateTab(void)));
	  menu.addAction(tr("Open In &New Window"),
			 this, SLOT(slotOpenInNewWindow(void)));
	  menu.actions()[2]->setEnabled(count() > 1);
	  menu.exec(tabBar()->mapToGlobal(point));
	}
      else
	{
	  QMenu menu(this);

	  menu.addAction(tr("Close Ta&b"),
			 this, SLOT(slotCloseTab(void)));
	  menu.actions()[0]->setEnabled(count() != 1);
	  menu.addAction(tr("New &Tab"),
			 this, SLOT(slotCreateTab(void)));
	  menu.exec(tabBar()->mapToGlobal(point));
	}
    }
}

#if QT_VERSION >= 0x040500
void dtabwidget::slotCloseTab(int index)
{
  selectedTabIndex = index;
  emit closeTabSignal(selectedTabIndex);
}
#endif

void dtabwidget::slotCloseTab(void)
{
  emit closeTabSignal(selectedTabIndex);
}

void dtabwidget::slotCreateTab(void)
{
  emit createTabSignal();
}

void dtabwidget::slotOpenInNewWindow(void)
{
  emit openInNewWindowSignal(selectedTabIndex);
  removeTab(selectedTabIndex);
}

void dtabwidget::tabRemoved(int index)
{
  Q_UNUSED(index);
}

void dtabwidget::setTabData(const int index, const QVariant &data)
{
  tabBar()->setTabData(index, data);
}

QVariant dtabwidget::tabData(const int index)
{
  return tabBar()->tabData(index);
}
