/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;

class TokenMapper {
    private ArrayList functionBracePositions = new ArrayList();
    private ArrayList replacedTokens = new ArrayList();
    private static ObjArray funcObjects = new ObjArray();
    private static ArrayList functionVarMappings = new ArrayList();
    public int functionNum = 0;
    private int parentScope = 0;
    private int lastTokenCount = 0;

    TokenMapper() {
    }

    public static void reset() {
        funcObjects = new ObjArray();
        functionVarMappings = new ArrayList();
    }

    private String getMappedToken(String token, boolean hasNewMapping) {
        String newToken = null;
        HashMap tokens = null;
        String blank = new String("");
        int localScope = this.functionBracePositions.size() - 1;
        String oldToken = this.getPreviousTokenMapping(token, hasNewMapping);
        if (!oldToken.equalsIgnoreCase(blank)) {
            return oldToken;
        }
        if (hasNewMapping || this.isInScopeChain(token)) {
            ++this.lastTokenCount;
            newToken = new String("_" + Integer.toHexString(this.lastTokenCount));
            if (newToken.length() >= token.length()) {
                newToken = token;
            }
            tokens = hasNewMapping ? (HashMap)this.replacedTokens.get(localScope) : (HashMap)this.replacedTokens.get(this.parentScope);
            tokens.put(token, newToken);
            return newToken;
        }
        return token;
    }

    private boolean isInScopeChain(String token) {
        int scope = this.functionBracePositions.size();
        HashMap chainedScopeVars = (HashMap)functionVarMappings.get(this.functionNum);
        if (!chainedScopeVars.isEmpty()) {
            for (int i = scope; i > 0; --i) {
                if (!chainedScopeVars.containsKey(new Integer(i))) continue;
                this.parentScope = i - 1;
                List<String> temp = Arrays.asList((String[])chainedScopeVars.get(new Integer(i)));
                if (temp.indexOf(token) == -1) continue;
                return true;
            }
        }
        return false;
    }

    private String getPreviousTokenMapping(String token, boolean hasNewMapping) {
        String result = new String("");
        int scope = this.replacedTokens.size() - 1;
        if (scope < 0) {
            return result;
        }
        if (hasNewMapping) {
            HashMap tokens = (HashMap)this.replacedTokens.get(scope);
            if (tokens.containsKey(token)) {
                result = (String)tokens.get(token);
                return result;
            }
        } else {
            for (int i = scope; i > -1; --i) {
                HashMap tokens = (HashMap)this.replacedTokens.get(i);
                if (!tokens.containsKey(token)) continue;
                result = (String)tokens.get(token);
                return result;
            }
        }
        return result;
    }

    private void collectFunctionMappings(ScriptOrFnNode parseTree) {
        int level = -1;
        TokenMapper.collectFuncNodes(parseTree, level);
    }

    private static void collectFuncNodes(ScriptOrFnNode parseTree, int level) {
        functionVarMappings.add(new HashMap());
        HashMap bindingNames = (HashMap)functionVarMappings.get(functionVarMappings.size() - 1);
        bindingNames.put(new Integer(++level), parseTree.getParamAndVarNames());
        funcObjects.add(parseTree);
        int nestedCount = parseTree.getFunctionCount();
        for (int i = 0; i != nestedCount; ++i) {
            TokenMapper.collectFuncNodes(parseTree.getFunctionNode(i), level);
            bindingNames = (HashMap)functionVarMappings.get(functionVarMappings.size() - 1);
            bindingNames.put(new Integer(level), parseTree.getParamAndVarNames());
        }
    }

    public int sourceCompress(String encodedSource, int offset, boolean asQuotedString, StringBuffer sb, int prevToken, boolean inArgsList, int currentLevel, ScriptOrFnNode parseTree) {
        boolean hasNewMapping = false;
        if (functionVarMappings.isEmpty()) {
            this.collectFunctionMappings(parseTree);
        }
        int length = encodedSource.charAt(offset);
        ++offset;
        if ((0x8000 & length) != 0) {
            length = (Short.MAX_VALUE & length) << 16 | encodedSource.charAt(offset);
            ++offset;
        }
        if (sb != null) {
            String str = encodedSource.substring(offset, offset + length);
            String sourceStr = new String(str);
            if (prevToken == 118 || inArgsList) {
                hasNewMapping = true;
            }
            if ((this.functionBracePositions.size() > 0 && currentLevel >= (Integer)this.functionBracePositions.get(this.functionBracePositions.size() - 1) || inArgsList) && prevToken != 104) {
                str = this.getMappedToken(str, hasNewMapping);
            }
            if (!inArgsList && asQuotedString && (prevToken == 81 || prevToken == 85)) {
                str = sourceStr;
            }
            if (!asQuotedString) {
                sb.append(str);
            } else {
                sb.append('\"');
                sb.append(ScriptRuntime.escapeString(str));
                sb.append('\"');
            }
        }
        return offset + length;
    }

    public void enterNestingLevel(int braceNesting) {
        this.functionBracePositions.add(new Integer(braceNesting + 1));
        this.replacedTokens.add(new HashMap());
    }

    public void leaveNestingLevel(int braceNesting) {
        Integer bn = new Integer(braceNesting);
        if (this.functionBracePositions.contains(bn) && this.replacedTokens.size() > 0) {
            int scopedSize = this.replacedTokens.size();
            this.replacedTokens.remove(scopedSize - 1);
            this.functionBracePositions.remove(bn);
        }
    }
}

