
! Copyright (C) 2021 J. K. Dewhurst, S. Sharma and E. K. U. Gross.
! This file is distributed under the terms of the GNU General Public License.
! See the file COPYING for license details.

subroutine getxnorm(iq,xnorm)
use modmain
use modphonon
implicit none
! arguments
integer, intent(in) :: iq
real(8), intent(out) :: xnorm(nbph)
! local variables
integer recl,nbph_
real(8) vql_(3),t1
! find the record length
inquire(iolength=recl) vql_,nbph_,xnorm
!$OMP CRITICAL(u334)
open(334,file='XNORM.OUT',form='UNFORMATTED',access='DIRECT',recl=recl)
read(334,rec=iq) vql_,nbph_,xnorm
!$OMP END CRITICAL(u334)
t1=abs(vql(1,iq)-vql_(1))+abs(vql(2,iq)-vql_(2))+abs(vql(3,iq)-vql_(3))
if (t1.gt.epslat) then
  write(*,*)
  write(*,'("Error(getxnorm): differing vectors for q-point ",I8)') iq
  write(*,'(" current   : ",3G18.10)') vql(:,iq)
  write(*,'(" XNORM.OUT : ",3G18.10)') vql_
  write(*,*)
  stop
end if
if (nbph.ne.nbph_) then
  write(*,*)
  write(*,'("Error(getxnorm): differing nbph for q-point ",I8)') iq
  write(*,'(" current   : ",I8)') nbph
  write(*,'(" XNORM.OUT : ",I8)') nbph_
  write(*,*)
  stop
end if
end subroutine

