// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file appendable.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__APPENDABLE_HPP
#define FAST_DDS_GENERATED__APPENDABLE_HPP

#include <cstdint>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>
#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(APPENDABLE_SOURCE)
#define APPENDABLE_DllAPI __declspec( dllexport )
#else
#define APPENDABLE_DllAPI __declspec( dllimport )
#endif // APPENDABLE_SOURCE
#else
#define APPENDABLE_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define APPENDABLE_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure AppendableShortStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableShortStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableShortStruct that will be copied.
     */
    eProsima_user_DllExport AppendableShortStruct(
            const AppendableShortStruct& x)
    {
                    m_var_short = x.m_var_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableShortStruct that will be copied.
     */
    eProsima_user_DllExport AppendableShortStruct(
            AppendableShortStruct&& x) noexcept
    {
        m_var_short = x.m_var_short;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableShortStruct that will be copied.
     */
    eProsima_user_DllExport AppendableShortStruct& operator =(
            const AppendableShortStruct& x)
    {

                    m_var_short = x.m_var_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableShortStruct that will be copied.
     */
    eProsima_user_DllExport AppendableShortStruct& operator =(
            AppendableShortStruct&& x) noexcept
    {

        m_var_short = x.m_var_short;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableShortStruct& x) const
    {
        return (m_var_short == x.m_var_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableShortStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_short
     * @param _var_short New value for member var_short
     */
    eProsima_user_DllExport void var_short(
            int16_t _var_short)
    {
        m_var_short = _var_short;
    }

    /*!
     * @brief This function returns the value of member var_short
     * @return Value of member var_short
     */
    eProsima_user_DllExport int16_t var_short() const
    {
        return m_var_short;
    }

    /*!
     * @brief This function returns a reference to member var_short
     * @return Reference to member var_short
     */
    eProsima_user_DllExport int16_t& var_short()
    {
        return m_var_short;
    }



private:

    int16_t m_var_short{0};

};
/*!
 * @brief This class represents the structure AppendableUShortStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableUShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableUShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableUShortStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableUShortStruct that will be copied.
     */
    eProsima_user_DllExport AppendableUShortStruct(
            const AppendableUShortStruct& x)
    {
                    m_var_ushort = x.m_var_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableUShortStruct that will be copied.
     */
    eProsima_user_DllExport AppendableUShortStruct(
            AppendableUShortStruct&& x) noexcept
    {
        m_var_ushort = x.m_var_ushort;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableUShortStruct that will be copied.
     */
    eProsima_user_DllExport AppendableUShortStruct& operator =(
            const AppendableUShortStruct& x)
    {

                    m_var_ushort = x.m_var_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableUShortStruct that will be copied.
     */
    eProsima_user_DllExport AppendableUShortStruct& operator =(
            AppendableUShortStruct&& x) noexcept
    {

        m_var_ushort = x.m_var_ushort;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableUShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableUShortStruct& x) const
    {
        return (m_var_ushort == x.m_var_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableUShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableUShortStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ushort
     * @param _var_ushort New value for member var_ushort
     */
    eProsima_user_DllExport void var_ushort(
            uint16_t _var_ushort)
    {
        m_var_ushort = _var_ushort;
    }

    /*!
     * @brief This function returns the value of member var_ushort
     * @return Value of member var_ushort
     */
    eProsima_user_DllExport uint16_t var_ushort() const
    {
        return m_var_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_ushort
     * @return Reference to member var_ushort
     */
    eProsima_user_DllExport uint16_t& var_ushort()
    {
        return m_var_ushort;
    }



private:

    uint16_t m_var_ushort{0};

};
/*!
 * @brief This class represents the structure AppendableLongStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableLongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableLongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableLongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableLongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableLongStruct(
            const AppendableLongStruct& x)
    {
                    m_var_long = x.m_var_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableLongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableLongStruct(
            AppendableLongStruct&& x) noexcept
    {
        m_var_long = x.m_var_long;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableLongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableLongStruct& operator =(
            const AppendableLongStruct& x)
    {

                    m_var_long = x.m_var_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableLongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableLongStruct& operator =(
            AppendableLongStruct&& x) noexcept
    {

        m_var_long = x.m_var_long;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableLongStruct& x) const
    {
        return (m_var_long == x.m_var_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableLongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_long
     * @param _var_long New value for member var_long
     */
    eProsima_user_DllExport void var_long(
            int32_t _var_long)
    {
        m_var_long = _var_long;
    }

    /*!
     * @brief This function returns the value of member var_long
     * @return Value of member var_long
     */
    eProsima_user_DllExport int32_t var_long() const
    {
        return m_var_long;
    }

    /*!
     * @brief This function returns a reference to member var_long
     * @return Reference to member var_long
     */
    eProsima_user_DllExport int32_t& var_long()
    {
        return m_var_long;
    }



private:

    int32_t m_var_long{0};

};
/*!
 * @brief This class represents the structure AppendableULongStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableULongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableULongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableULongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableULongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableULongStruct(
            const AppendableULongStruct& x)
    {
                    m_var_ulong = x.m_var_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableULongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableULongStruct(
            AppendableULongStruct&& x) noexcept
    {
        m_var_ulong = x.m_var_ulong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableULongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableULongStruct& operator =(
            const AppendableULongStruct& x)
    {

                    m_var_ulong = x.m_var_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableULongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableULongStruct& operator =(
            AppendableULongStruct&& x) noexcept
    {

        m_var_ulong = x.m_var_ulong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableULongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableULongStruct& x) const
    {
        return (m_var_ulong == x.m_var_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableULongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableULongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ulong
     * @param _var_ulong New value for member var_ulong
     */
    eProsima_user_DllExport void var_ulong(
            uint32_t _var_ulong)
    {
        m_var_ulong = _var_ulong;
    }

    /*!
     * @brief This function returns the value of member var_ulong
     * @return Value of member var_ulong
     */
    eProsima_user_DllExport uint32_t var_ulong() const
    {
        return m_var_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_ulong
     * @return Reference to member var_ulong
     */
    eProsima_user_DllExport uint32_t& var_ulong()
    {
        return m_var_ulong;
    }



private:

    uint32_t m_var_ulong{0};

};
/*!
 * @brief This class represents the structure AppendableLongLongStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableLongLongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableLongLongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableLongLongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableLongLongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableLongLongStruct(
            const AppendableLongLongStruct& x)
    {
                    m_var_longlong = x.m_var_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableLongLongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableLongLongStruct(
            AppendableLongLongStruct&& x) noexcept
    {
        m_var_longlong = x.m_var_longlong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableLongLongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableLongLongStruct& operator =(
            const AppendableLongLongStruct& x)
    {

                    m_var_longlong = x.m_var_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableLongLongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableLongLongStruct& operator =(
            AppendableLongLongStruct&& x) noexcept
    {

        m_var_longlong = x.m_var_longlong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableLongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableLongLongStruct& x) const
    {
        return (m_var_longlong == x.m_var_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableLongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableLongLongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_longlong
     * @param _var_longlong New value for member var_longlong
     */
    eProsima_user_DllExport void var_longlong(
            int64_t _var_longlong)
    {
        m_var_longlong = _var_longlong;
    }

    /*!
     * @brief This function returns the value of member var_longlong
     * @return Value of member var_longlong
     */
    eProsima_user_DllExport int64_t var_longlong() const
    {
        return m_var_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_longlong
     * @return Reference to member var_longlong
     */
    eProsima_user_DllExport int64_t& var_longlong()
    {
        return m_var_longlong;
    }



private:

    int64_t m_var_longlong{0};

};
/*!
 * @brief This class represents the structure AppendableULongLongStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableULongLongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableULongLongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableULongLongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableULongLongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableULongLongStruct(
            const AppendableULongLongStruct& x)
    {
                    m_var_ulonglong = x.m_var_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableULongLongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableULongLongStruct(
            AppendableULongLongStruct&& x) noexcept
    {
        m_var_ulonglong = x.m_var_ulonglong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableULongLongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableULongLongStruct& operator =(
            const AppendableULongLongStruct& x)
    {

                    m_var_ulonglong = x.m_var_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableULongLongStruct that will be copied.
     */
    eProsima_user_DllExport AppendableULongLongStruct& operator =(
            AppendableULongLongStruct&& x) noexcept
    {

        m_var_ulonglong = x.m_var_ulonglong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableULongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableULongLongStruct& x) const
    {
        return (m_var_ulonglong == x.m_var_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableULongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableULongLongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ulonglong
     * @param _var_ulonglong New value for member var_ulonglong
     */
    eProsima_user_DllExport void var_ulonglong(
            uint64_t _var_ulonglong)
    {
        m_var_ulonglong = _var_ulonglong;
    }

    /*!
     * @brief This function returns the value of member var_ulonglong
     * @return Value of member var_ulonglong
     */
    eProsima_user_DllExport uint64_t var_ulonglong() const
    {
        return m_var_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_ulonglong
     * @return Reference to member var_ulonglong
     */
    eProsima_user_DllExport uint64_t& var_ulonglong()
    {
        return m_var_ulonglong;
    }



private:

    uint64_t m_var_ulonglong{0};

};
/*!
 * @brief This class represents the structure AppendableFloatStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableFloatStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableFloatStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableFloatStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableFloatStruct that will be copied.
     */
    eProsima_user_DllExport AppendableFloatStruct(
            const AppendableFloatStruct& x)
    {
                    m_var_float = x.m_var_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableFloatStruct that will be copied.
     */
    eProsima_user_DllExport AppendableFloatStruct(
            AppendableFloatStruct&& x) noexcept
    {
        m_var_float = x.m_var_float;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableFloatStruct that will be copied.
     */
    eProsima_user_DllExport AppendableFloatStruct& operator =(
            const AppendableFloatStruct& x)
    {

                    m_var_float = x.m_var_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableFloatStruct that will be copied.
     */
    eProsima_user_DllExport AppendableFloatStruct& operator =(
            AppendableFloatStruct&& x) noexcept
    {

        m_var_float = x.m_var_float;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableFloatStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableFloatStruct& x) const
    {
        return (m_var_float == x.m_var_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableFloatStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableFloatStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_float
     * @param _var_float New value for member var_float
     */
    eProsima_user_DllExport void var_float(
            float _var_float)
    {
        m_var_float = _var_float;
    }

    /*!
     * @brief This function returns the value of member var_float
     * @return Value of member var_float
     */
    eProsima_user_DllExport float var_float() const
    {
        return m_var_float;
    }

    /*!
     * @brief This function returns a reference to member var_float
     * @return Reference to member var_float
     */
    eProsima_user_DllExport float& var_float()
    {
        return m_var_float;
    }



private:

    float m_var_float{0.0};

};
/*!
 * @brief This class represents the structure AppendableDoubleStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableDoubleStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableDoubleStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableDoubleStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableDoubleStruct that will be copied.
     */
    eProsima_user_DllExport AppendableDoubleStruct(
            const AppendableDoubleStruct& x)
    {
                    m_var_double = x.m_var_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableDoubleStruct that will be copied.
     */
    eProsima_user_DllExport AppendableDoubleStruct(
            AppendableDoubleStruct&& x) noexcept
    {
        m_var_double = x.m_var_double;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableDoubleStruct that will be copied.
     */
    eProsima_user_DllExport AppendableDoubleStruct& operator =(
            const AppendableDoubleStruct& x)
    {

                    m_var_double = x.m_var_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableDoubleStruct that will be copied.
     */
    eProsima_user_DllExport AppendableDoubleStruct& operator =(
            AppendableDoubleStruct&& x) noexcept
    {

        m_var_double = x.m_var_double;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableDoubleStruct& x) const
    {
        return (m_var_double == x.m_var_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableDoubleStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_double
     * @param _var_double New value for member var_double
     */
    eProsima_user_DllExport void var_double(
            double _var_double)
    {
        m_var_double = _var_double;
    }

    /*!
     * @brief This function returns the value of member var_double
     * @return Value of member var_double
     */
    eProsima_user_DllExport double var_double() const
    {
        return m_var_double;
    }

    /*!
     * @brief This function returns a reference to member var_double
     * @return Reference to member var_double
     */
    eProsima_user_DllExport double& var_double()
    {
        return m_var_double;
    }



private:

    double m_var_double{0.0};

};
/*!
 * @brief This class represents the structure AppendableLongDoubleStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableLongDoubleStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableLongDoubleStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableLongDoubleStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport AppendableLongDoubleStruct(
            const AppendableLongDoubleStruct& x)
    {
                    m_var_longdouble = x.m_var_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport AppendableLongDoubleStruct(
            AppendableLongDoubleStruct&& x) noexcept
    {
        m_var_longdouble = x.m_var_longdouble;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport AppendableLongDoubleStruct& operator =(
            const AppendableLongDoubleStruct& x)
    {

                    m_var_longdouble = x.m_var_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport AppendableLongDoubleStruct& operator =(
            AppendableLongDoubleStruct&& x) noexcept
    {

        m_var_longdouble = x.m_var_longdouble;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableLongDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableLongDoubleStruct& x) const
    {
        return (m_var_longdouble == x.m_var_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableLongDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableLongDoubleStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_longdouble
     * @param _var_longdouble New value for member var_longdouble
     */
    eProsima_user_DllExport void var_longdouble(
            long double _var_longdouble)
    {
        m_var_longdouble = _var_longdouble;
    }

    /*!
     * @brief This function returns the value of member var_longdouble
     * @return Value of member var_longdouble
     */
    eProsima_user_DllExport long double var_longdouble() const
    {
        return m_var_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_longdouble
     * @return Reference to member var_longdouble
     */
    eProsima_user_DllExport long double& var_longdouble()
    {
        return m_var_longdouble;
    }



private:

    long double m_var_longdouble{0.0};

};
/*!
 * @brief This class represents the structure AppendableBooleanStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableBooleanStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableBooleanStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableBooleanStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableBooleanStruct that will be copied.
     */
    eProsima_user_DllExport AppendableBooleanStruct(
            const AppendableBooleanStruct& x)
    {
                    m_var_boolean = x.m_var_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableBooleanStruct that will be copied.
     */
    eProsima_user_DllExport AppendableBooleanStruct(
            AppendableBooleanStruct&& x) noexcept
    {
        m_var_boolean = x.m_var_boolean;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableBooleanStruct that will be copied.
     */
    eProsima_user_DllExport AppendableBooleanStruct& operator =(
            const AppendableBooleanStruct& x)
    {

                    m_var_boolean = x.m_var_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableBooleanStruct that will be copied.
     */
    eProsima_user_DllExport AppendableBooleanStruct& operator =(
            AppendableBooleanStruct&& x) noexcept
    {

        m_var_boolean = x.m_var_boolean;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableBooleanStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableBooleanStruct& x) const
    {
        return (m_var_boolean == x.m_var_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableBooleanStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableBooleanStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_boolean
     * @param _var_boolean New value for member var_boolean
     */
    eProsima_user_DllExport void var_boolean(
            bool _var_boolean)
    {
        m_var_boolean = _var_boolean;
    }

    /*!
     * @brief This function returns the value of member var_boolean
     * @return Value of member var_boolean
     */
    eProsima_user_DllExport bool var_boolean() const
    {
        return m_var_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_boolean
     * @return Reference to member var_boolean
     */
    eProsima_user_DllExport bool& var_boolean()
    {
        return m_var_boolean;
    }



private:

    bool m_var_boolean{false};

};
/*!
 * @brief This class represents the structure AppendableOctetStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableOctetStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableOctetStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableOctetStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableOctetStruct that will be copied.
     */
    eProsima_user_DllExport AppendableOctetStruct(
            const AppendableOctetStruct& x)
    {
                    m_var_octet = x.m_var_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableOctetStruct that will be copied.
     */
    eProsima_user_DllExport AppendableOctetStruct(
            AppendableOctetStruct&& x) noexcept
    {
        m_var_octet = x.m_var_octet;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableOctetStruct that will be copied.
     */
    eProsima_user_DllExport AppendableOctetStruct& operator =(
            const AppendableOctetStruct& x)
    {

                    m_var_octet = x.m_var_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableOctetStruct that will be copied.
     */
    eProsima_user_DllExport AppendableOctetStruct& operator =(
            AppendableOctetStruct&& x) noexcept
    {

        m_var_octet = x.m_var_octet;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableOctetStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableOctetStruct& x) const
    {
        return (m_var_octet == x.m_var_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableOctetStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableOctetStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_octet
     * @param _var_octet New value for member var_octet
     */
    eProsima_user_DllExport void var_octet(
            uint8_t _var_octet)
    {
        m_var_octet = _var_octet;
    }

    /*!
     * @brief This function returns the value of member var_octet
     * @return Value of member var_octet
     */
    eProsima_user_DllExport uint8_t var_octet() const
    {
        return m_var_octet;
    }

    /*!
     * @brief This function returns a reference to member var_octet
     * @return Reference to member var_octet
     */
    eProsima_user_DllExport uint8_t& var_octet()
    {
        return m_var_octet;
    }



private:

    uint8_t m_var_octet{0};

};
/*!
 * @brief This class represents the structure AppendableCharStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableCharStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableCharStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableCharStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableCharStruct that will be copied.
     */
    eProsima_user_DllExport AppendableCharStruct(
            const AppendableCharStruct& x)
    {
                    m_var_char8 = x.m_var_char8;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableCharStruct that will be copied.
     */
    eProsima_user_DllExport AppendableCharStruct(
            AppendableCharStruct&& x) noexcept
    {
        m_var_char8 = x.m_var_char8;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableCharStruct that will be copied.
     */
    eProsima_user_DllExport AppendableCharStruct& operator =(
            const AppendableCharStruct& x)
    {

                    m_var_char8 = x.m_var_char8;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableCharStruct that will be copied.
     */
    eProsima_user_DllExport AppendableCharStruct& operator =(
            AppendableCharStruct&& x) noexcept
    {

        m_var_char8 = x.m_var_char8;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableCharStruct& x) const
    {
        return (m_var_char8 == x.m_var_char8);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableCharStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_char8
     * @param _var_char8 New value for member var_char8
     */
    eProsima_user_DllExport void var_char8(
            char _var_char8)
    {
        m_var_char8 = _var_char8;
    }

    /*!
     * @brief This function returns the value of member var_char8
     * @return Value of member var_char8
     */
    eProsima_user_DllExport char var_char8() const
    {
        return m_var_char8;
    }

    /*!
     * @brief This function returns a reference to member var_char8
     * @return Reference to member var_char8
     */
    eProsima_user_DllExport char& var_char8()
    {
        return m_var_char8;
    }



private:

    char m_var_char8{0};

};
/*!
 * @brief This class represents the structure AppendableWCharStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableWCharStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableWCharStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableWCharStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableWCharStruct that will be copied.
     */
    eProsima_user_DllExport AppendableWCharStruct(
            const AppendableWCharStruct& x)
    {
                    m_var_char16 = x.m_var_char16;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableWCharStruct that will be copied.
     */
    eProsima_user_DllExport AppendableWCharStruct(
            AppendableWCharStruct&& x) noexcept
    {
        m_var_char16 = x.m_var_char16;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableWCharStruct that will be copied.
     */
    eProsima_user_DllExport AppendableWCharStruct& operator =(
            const AppendableWCharStruct& x)
    {

                    m_var_char16 = x.m_var_char16;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableWCharStruct that will be copied.
     */
    eProsima_user_DllExport AppendableWCharStruct& operator =(
            AppendableWCharStruct&& x) noexcept
    {

        m_var_char16 = x.m_var_char16;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableWCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableWCharStruct& x) const
    {
        return (m_var_char16 == x.m_var_char16);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableWCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableWCharStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_char16
     * @param _var_char16 New value for member var_char16
     */
    eProsima_user_DllExport void var_char16(
            wchar_t _var_char16)
    {
        m_var_char16 = _var_char16;
    }

    /*!
     * @brief This function returns the value of member var_char16
     * @return Value of member var_char16
     */
    eProsima_user_DllExport wchar_t var_char16() const
    {
        return m_var_char16;
    }

    /*!
     * @brief This function returns a reference to member var_char16
     * @return Reference to member var_char16
     */
    eProsima_user_DllExport wchar_t& var_char16()
    {
        return m_var_char16;
    }



private:

    wchar_t m_var_char16{0};

};
/*!
 * @brief This class represents the structure AppendableUnionStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableUnionStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableUnionStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableUnionStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableUnionStruct that will be copied.
     */
    eProsima_user_DllExport AppendableUnionStruct(
            const AppendableUnionStruct& x)
    {
                    m_var_union = x.m_var_union;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableUnionStruct that will be copied.
     */
    eProsima_user_DllExport AppendableUnionStruct(
            AppendableUnionStruct&& x) noexcept
    {
        m_var_union = std::move(x.m_var_union);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableUnionStruct that will be copied.
     */
    eProsima_user_DllExport AppendableUnionStruct& operator =(
            const AppendableUnionStruct& x)
    {

                    m_var_union = x.m_var_union;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableUnionStruct that will be copied.
     */
    eProsima_user_DllExport AppendableUnionStruct& operator =(
            AppendableUnionStruct&& x) noexcept
    {

        m_var_union = std::move(x.m_var_union);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableUnionStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableUnionStruct& x) const
    {
        return (m_var_union == x.m_var_union);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableUnionStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableUnionStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union
     * @param _var_union New value to be copied in member var_union
     */
    eProsima_user_DllExport void var_union(
            const InnerUnionHelper& _var_union)
    {
        m_var_union = _var_union;
    }

    /*!
     * @brief This function moves the value in member var_union
     * @param _var_union New value to be moved in member var_union
     */
    eProsima_user_DllExport void var_union(
            InnerUnionHelper&& _var_union)
    {
        m_var_union = std::move(_var_union);
    }

    /*!
     * @brief This function returns a constant reference to member var_union
     * @return Constant reference to member var_union
     */
    eProsima_user_DllExport const InnerUnionHelper& var_union() const
    {
        return m_var_union;
    }

    /*!
     * @brief This function returns a reference to member var_union
     * @return Reference to member var_union
     */
    eProsima_user_DllExport InnerUnionHelper& var_union()
    {
        return m_var_union;
    }



private:

    InnerUnionHelper m_var_union;

};
/*!
 * @brief This class represents the structure AppendableEmptyStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableEmptyStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableEmptyStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableEmptyStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableEmptyStruct that will be copied.
     */
    eProsima_user_DllExport AppendableEmptyStruct(
            const AppendableEmptyStruct& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableEmptyStruct that will be copied.
     */
    eProsima_user_DllExport AppendableEmptyStruct(
            AppendableEmptyStruct&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableEmptyStruct that will be copied.
     */
    eProsima_user_DllExport AppendableEmptyStruct& operator =(
            const AppendableEmptyStruct& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableEmptyStruct that will be copied.
     */
    eProsima_user_DllExport AppendableEmptyStruct& operator =(
            AppendableEmptyStruct&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableEmptyStruct& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableEmptyStruct& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure AppendableEmptyInheritanceStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableEmptyInheritanceStruct : public AppendableEmptyStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableEmptyInheritanceStruct()
        : AppendableEmptyStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableEmptyInheritanceStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport AppendableEmptyInheritanceStruct(
            const AppendableEmptyInheritanceStruct& x)
        : AppendableEmptyStruct(x)
    {
                    m_var_str = x.m_var_str;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport AppendableEmptyInheritanceStruct(
            AppendableEmptyInheritanceStruct&& x) noexcept
        : AppendableEmptyStruct(std::move(x))

    {
        m_var_str = std::move(x.m_var_str);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport AppendableEmptyInheritanceStruct& operator =(
            const AppendableEmptyInheritanceStruct& x)
    {
        AppendableEmptyStruct::operator =(x);

                    m_var_str = x.m_var_str;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport AppendableEmptyInheritanceStruct& operator =(
            AppendableEmptyInheritanceStruct&& x) noexcept
    {
        AppendableEmptyStruct::operator =(std::move(x));

        m_var_str = std::move(x.m_var_str);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableEmptyInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableEmptyInheritanceStruct& x) const
    {
        if (AppendableEmptyStruct::operator !=(x))
                {
                    return false;
                }
        return (m_var_str == x.m_var_str);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableEmptyInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableEmptyInheritanceStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_str
     * @param _var_str New value to be copied in member var_str
     */
    eProsima_user_DllExport void var_str(
            const std::string& _var_str)
    {
        m_var_str = _var_str;
    }

    /*!
     * @brief This function moves the value in member var_str
     * @param _var_str New value to be moved in member var_str
     */
    eProsima_user_DllExport void var_str(
            std::string&& _var_str)
    {
        m_var_str = std::move(_var_str);
    }

    /*!
     * @brief This function returns a constant reference to member var_str
     * @return Constant reference to member var_str
     */
    eProsima_user_DllExport const std::string& var_str() const
    {
        return m_var_str;
    }

    /*!
     * @brief This function returns a reference to member var_str
     * @return Reference to member var_str
     */
    eProsima_user_DllExport std::string& var_str()
    {
        return m_var_str;
    }



private:

    std::string m_var_str;

};
/*!
 * @brief This class represents the structure AppendableInheritanceStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableInheritanceStruct : public AppendableShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableInheritanceStruct()
        : AppendableShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableInheritanceStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport AppendableInheritanceStruct(
            const AppendableInheritanceStruct& x)
        : AppendableShortStruct(x)
    {
                    m_var_str = x.m_var_str;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport AppendableInheritanceStruct(
            AppendableInheritanceStruct&& x) noexcept
        : AppendableShortStruct(std::move(x))

    {
        m_var_str = std::move(x.m_var_str);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport AppendableInheritanceStruct& operator =(
            const AppendableInheritanceStruct& x)
    {
        AppendableShortStruct::operator =(x);

                    m_var_str = x.m_var_str;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport AppendableInheritanceStruct& operator =(
            AppendableInheritanceStruct&& x) noexcept
    {
        AppendableShortStruct::operator =(std::move(x));

        m_var_str = std::move(x.m_var_str);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableInheritanceStruct& x) const
    {
        if (AppendableShortStruct::operator !=(x))
                {
                    return false;
                }
        return (m_var_str == x.m_var_str);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableInheritanceStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_str
     * @param _var_str New value to be copied in member var_str
     */
    eProsima_user_DllExport void var_str(
            const std::string& _var_str)
    {
        m_var_str = _var_str;
    }

    /*!
     * @brief This function moves the value in member var_str
     * @param _var_str New value to be moved in member var_str
     */
    eProsima_user_DllExport void var_str(
            std::string&& _var_str)
    {
        m_var_str = std::move(_var_str);
    }

    /*!
     * @brief This function returns a constant reference to member var_str
     * @return Constant reference to member var_str
     */
    eProsima_user_DllExport const std::string& var_str() const
    {
        return m_var_str;
    }

    /*!
     * @brief This function returns a reference to member var_str
     * @return Reference to member var_str
     */
    eProsima_user_DllExport std::string& var_str()
    {
        return m_var_str;
    }



private:

    std::string m_var_str;

};
/*!
 * @brief This class represents the structure AppendableInheritanceEmptyStruct defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableInheritanceEmptyStruct : public AppendableShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableInheritanceEmptyStruct()
        : AppendableShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableInheritanceEmptyStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableInheritanceEmptyStruct that will be copied.
     */
    eProsima_user_DllExport AppendableInheritanceEmptyStruct(
            const AppendableInheritanceEmptyStruct& x)
        : AppendableShortStruct(x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableInheritanceEmptyStruct that will be copied.
     */
    eProsima_user_DllExport AppendableInheritanceEmptyStruct(
            AppendableInheritanceEmptyStruct&& x) noexcept
        : AppendableShortStruct(std::move(x))

    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableInheritanceEmptyStruct that will be copied.
     */
    eProsima_user_DllExport AppendableInheritanceEmptyStruct& operator =(
            const AppendableInheritanceEmptyStruct& x)
    {
        AppendableShortStruct::operator =(x);

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableInheritanceEmptyStruct that will be copied.
     */
    eProsima_user_DllExport AppendableInheritanceEmptyStruct& operator =(
            AppendableInheritanceEmptyStruct&& x) noexcept
    {
        AppendableShortStruct::operator =(std::move(x));

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableInheritanceEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableInheritanceEmptyStruct& x) const
    {
        if (AppendableShortStruct::operator !=(x))
                {
                    return false;
                }
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableInheritanceEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableInheritanceEmptyStruct& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure AppendableExtensibilityInheritance defined by the user in the IDL file.
 * @ingroup appendable
 */
class AppendableExtensibilityInheritance : public AppendableShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableExtensibilityInheritance()
        : AppendableShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableExtensibilityInheritance()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableExtensibilityInheritance that will be copied.
     */
    eProsima_user_DllExport AppendableExtensibilityInheritance(
            const AppendableExtensibilityInheritance& x)
        : AppendableShortStruct(x)
    {
                    m_var_long = x.m_var_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableExtensibilityInheritance that will be copied.
     */
    eProsima_user_DllExport AppendableExtensibilityInheritance(
            AppendableExtensibilityInheritance&& x) noexcept
        : AppendableShortStruct(std::move(x))

    {
        m_var_long = x.m_var_long;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableExtensibilityInheritance that will be copied.
     */
    eProsima_user_DllExport AppendableExtensibilityInheritance& operator =(
            const AppendableExtensibilityInheritance& x)
    {
        AppendableShortStruct::operator =(x);

                    m_var_long = x.m_var_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableExtensibilityInheritance that will be copied.
     */
    eProsima_user_DllExport AppendableExtensibilityInheritance& operator =(
            AppendableExtensibilityInheritance&& x) noexcept
    {
        AppendableShortStruct::operator =(std::move(x));

        m_var_long = x.m_var_long;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableExtensibilityInheritance object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableExtensibilityInheritance& x) const
    {
        if (AppendableShortStruct::operator !=(x))
                {
                    return false;
                }
        return (m_var_long == x.m_var_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableExtensibilityInheritance object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableExtensibilityInheritance& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_long
     * @param _var_long New value for member var_long
     */
    eProsima_user_DllExport void var_long(
            int32_t _var_long)
    {
        m_var_long = _var_long;
    }

    /*!
     * @brief This function returns the value of member var_long
     * @return Value of member var_long
     */
    eProsima_user_DllExport int32_t var_long() const
    {
        return m_var_long;
    }

    /*!
     * @brief This function returns a reference to member var_long
     * @return Reference to member var_long
     */
    eProsima_user_DllExport int32_t& var_long()
    {
        return m_var_long;
    }



private:

    int32_t m_var_long{0};

};

#endif // _FAST_DDS_GENERATED_APPENDABLE_HPP_


