/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SELECTED_NAME_HPP_INCLUDED
#define __SELECTED_NAME_HPP_INCLUDED

#include "frontend/ast/PrefixedName.hpp"

namespace ast {

class SelectedName : public PrefixedName {
public:
	//! c'tor
	/** @param n identifier of the name
	 *  @param pre prefix of the name
	 *  @param cands candidate symbols
	 *  @param loc corresponding location
	 */
	SelectedName(
		std::string *n,
		Expression *pre,
		std::list<Symbol*> cands,
		Location loc
		) :	PrefixedName(n, pre, cands, loc) {}


	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name);
		stream << this->prefix << '.' << *this->name;
	}
	
protected:
	//! d'tor
	virtual ~SelectedName() {}
};

}; /* namespace ast */

#endif /* __SELECTED_NAME_HPP_INCLUDED */
