/*
 * $Id: chipset.c,v 1.11 2009-01-28 14:37:55 potyra Exp $
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "build_config.h"

#include "compiler.h"
#include "assert.h"
#include "io.h"

#ifdef CONFIG_PCI_SUPPORT

#define PCI_ADDR(bus,dev,func)	(((unsigned long)(bus) << 16 ) \
		| ((unsigned long)(dev) << 11) \
		| ((unsigned long)(func) << 8))

#define PCICONF_ADDR	0x0cf8
#define PCICONF_DATA	0x0cfc

#if defined(INIT_RM)

CODE16;

static unsigned long
pci_confsp_readl(
	unsigned char bus,
	unsigned char unit,
	unsigned char fn,
	unsigned char reg
)
{
	assert(! (reg & 3));

	outl((PCI_ADDR(bus, unit, fn) | (1 << 31) | (reg & ~0)), PCICONF_ADDR);
	return inl(PCICONF_DATA + (reg & 0));
}

static void
pci_confsp_writel(
	unsigned char bus,
	unsigned char unit,
	unsigned char fn,
	unsigned char reg,
	unsigned long value
)
{
	assert(! (reg & 3));

	outl((PCI_ADDR(bus, unit, fn) | (1 << 31) | (reg & ~0)), PCICONF_ADDR);
	outl(value, PCICONF_DATA + (reg & 0));
}

#define PAM_WRITEABLE	2
#define PAM_READABLE	1

static void
pci_pamset(unsigned long addr, unsigned char mode)
{
	int pamreg;
	int high_nibble;
	int tmpr;
	int bit_shift;

#if 0
	assert(0xc0000 <= addr && addr <= 0xfffff); 
	assert(mode <= 16);
#endif
	if (0xf0000 <= addr && addr <= 0xfffff) {
		/* BIOS Area */
		pamreg = 0x59;
		high_nibble = 1;
	} else {
		int range;

		range = (addr - 0xC0000UL) / 0x4000;
		pamreg = 0x5a + (range / 2);
		high_nibble = range % 2;
	}

	tmpr = pci_confsp_readl(0, 0, 0, (unsigned char) (pamreg & ~3));
	bit_shift = 8 * (pamreg & 3) + 4 * high_nibble;  
	tmpr &= ~(0xfL << bit_shift);
	tmpr |= mode << bit_shift;
	pci_confsp_writel(0, 0, 0, (unsigned char) (pamreg & ~3), tmpr);
}

void
chipset_bios_readonly(void)
{
	uint32_t addr;

	for (addr = 0xe0000; addr < 0x100000; addr += 0x4000) {
		pci_pamset(addr, PAM_READABLE);
	}
}

void
chipset_bios_readwrite(void)
{
	uint32_t addr;

	for (addr = 0xe0000; addr < 0x100000; addr += 0x4000) {
		pci_pamset(addr, PAM_WRITEABLE | PAM_READABLE);
	}
}

#endif /* INIT_RM */

#endif /* CONFIG_PCI_SUPPORT */
