/* This file is "#include"d from dos-video.c and svga-video.c */

typedef struct {
  uint8 p;
  uint8 i;
  uint8 v;
} vgareg;

vgareg v256x224_103[25] =
{
        { 0xc2, 0x0, 0xe7},
        { 0xd4, 0x0, 0x45},
        { 0xd4, 0x1, 0x3f},
        { 0xd4, 0x2, 0x40},
        { 0xd4, 0x3, 0x86},
        { 0xd4, 0x4, 0x3f},
        { 0xd4, 0x5, 0x10},
        { 0xd4, 0x6, 0xcd},
        { 0xd4, 0x7, 0x1f},
        { 0xd4, 0x8, 0x0},
        { 0xd4, 0x9, 0x41},
        { 0xd4, 0x10, 0xc0},
        { 0xd4, 0x11, 0xac},
        { 0xd4, 0x12, 0xbf},
        { 0xd4, 0x13, 0x20},
        { 0xd4, 0x14, 0x40},    //
        { 0xd4, 0x15, 0xe7},
        { 0xd4, 0x16, 0x06},    //
        { 0xd4, 0x17, 0xa3},
        { 0xc4, 0x1, 0x1},
        { 0xc4, 0x4, 0xe},      //
        { 0xce, 0x5, 0x40},
        { 0xce, 0x6, 0x5},
        { 0xc0, 0x10, 0x41},
        { 0xc0, 0x13, 0x0},
};

vgareg v256x240[25] =
{
        { 0xc2, 0x0, 0xe3},
        { 0xd4, 0x0, 0x4f},
        { 0xd4, 0x1, 0x3f},
        { 0xd4, 0x2, 0x40},
        { 0xd4, 0x3, 0x92},
        { 0xd4, 0x4, 0x44},
        { 0xd4, 0x5, 0x10},
        { 0xd4, 0x6, 0x0a},
        { 0xd4, 0x7, 0x3e},
        { 0xd4, 0x8, 0x00},
        { 0xd4, 0x9, 0x41},
        { 0xd4, 0x10, 0xea},
        { 0xd4, 0x11, 0xac},
        { 0xd4, 0x12, 0xdf},
        { 0xd4, 0x13, 0x20},
        { 0xd4, 0x14, 0x40},
        { 0xd4, 0x15, 0xe7},
        { 0xd4, 0x16, 0x06},
        { 0xd4, 0x17, 0xa3},
        { 0xc4, 0x1, 0x1},
        { 0xc4, 0x4, 0xe},
        { 0xce, 0x5, 0x40},
        { 0xce, 0x6, 0x5},
        { 0xc0, 0x10, 0x41},
        { 0xc0, 0x13, 0x0}
};

vgareg v256x224S[25] =
{
        { 0xc2, 0x0, 0xe3},
        { 0xd4, 0x0, 0x5f},
        { 0xd4, 0x1, 0x3f},
        { 0xd4, 0x2, 0x40},
        { 0xd4, 0x3, 0x82},
        { 0xd4, 0x4, 0x4e},
        { 0xd4, 0x5, 0x96},
        { 0xd4, 0x6, 0x5},
        { 0xd4, 0x7, 0x1},
        { 0xd4, 0x8, 0x0},
        { 0xd4, 0x9, 0x40},
        { 0xd4, 0x10, 0xea},
        { 0xd4, 0x11, 0xac},
        { 0xd4, 0x12, 0xdf},
        { 0xd4, 0x13, 0x20},
        { 0xd4, 0x14, 0x40},
        { 0xd4, 0x15, 0xe7},
        { 0xd4, 0x16, 0x0},
        { 0xd4, 0x17, 0xe3},
        { 0xc4, 0x1, 0x1},
        { 0xc4, 0x4, 0xe},
        { 0xce, 0x5, 0x40},
        { 0xce, 0x6, 0x5},
        { 0xc0, 0x10, 0x41},
        { 0xc0, 0x13, 0x0}
};

vgareg v256x256[25] =
{
        { 0xc2, 0x0, 0xe7},
        { 0xd4, 0x0, 0x5f},
        { 0xd4, 0x1, 0x3f},
        { 0xd4, 0x2, 0x40},
        { 0xd4, 0x3, 0x82},
        { 0xd4, 0x4, 0x4a},
        { 0xd4, 0x5, 0x9a},
        { 0xd4, 0x6, 0x23},
        { 0xd4, 0x7, 0xb2},
        { 0xd4, 0x8, 0x0},
        { 0xd4, 0x9, 0x61},
        { 0xd4, 0x10, 0xa},
        { 0xd4, 0x11, 0xac},
        { 0xd4, 0x12, 0xff},
        { 0xd4, 0x13, 0x20},
        { 0xd4, 0x14, 0x40},
        { 0xd4, 0x15, 0x7},
        { 0xd4, 0x16, 0x1a},
        { 0xd4, 0x17, 0xa3},
        { 0xc4, 0x1, 0x1},
        { 0xc4, 0x4, 0xe},
        { 0xce, 0x5, 0x40},
        { 0xce, 0x6, 0x5},
        { 0xc0, 0x10, 0x41},
        { 0xc0, 0x13, 0x0}
};

vgareg v256x256S[25] =
{
  { 0xc2, 0x00, 0xe7},{ 0xd4, 0x00, 0x5F},{ 0xd4, 0x01, 0x3f},
  { 0xd4, 0x02, 0x40},{ 0xd4, 0x03, 0x82},{ 0xd4, 0x04, 0x4a},
  { 0xd4, 0x05, 0x9a},{ 0xd4, 0x06, 0x25},{ 0xd4, 0x07, 0x15},
  { 0xd4, 0x08, 0x00},{ 0xd4, 0x09, 0x60},{ 0xd4, 0x10, 0x0a},
  { 0xd4, 0x11, 0xac},{ 0xd4, 0x12, 0xff},{ 0xd4, 0x13, 0x20},
  { 0xd4, 0x14, 0x40},{ 0xd4, 0x15, 0x07},{ 0xd4, 0x16, 0x1a},
  { 0xd4, 0x17, 0xa3},{ 0xc4, 0x01, 0x01},{ 0xc4, 0x04, 0x0e},
  { 0xce, 0x05, 0x40},{ 0xce, 0x06, 0x05},{ 0xc0, 0x10, 0x41},
  { 0xc0, 0x13, 0x00}
};

static void VGAPortSet(vgareg R)
{
  int p,i,v;

  p=0x300|R.p;
  i=R.i;
  v=R.v;

  switch(p)
  {
    case 0x3C0: inportb(0x3DA);
                outportb(0x3C0,i);
                outportb(0x3C0,v);
                break;
    case 0x3C2:
    case 0x3C3:
    default:    outportb(p, v);
                break;
    case 0x3C4: if(i==1)
                {
                 outportw(0x3c4,0x100);
                 outportw(0x3c4,(v<<8)|1);
                 outportw(0x3c4,0x300);
                 break;
                }
    case 0x3CE:
    case 0x3D4: outportw(p,i|(v<<8));
                break;
  }
}

