/*
 * FCML - Free Code Manipulation Library.
 * Copyright (C) 2010-2024 Slawomir Wojtasiak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <fcml_assembler.h>
#include "instructions_p_t.h"
#include "instructions_base_t.h"

fcml_bool fcml_tf_instructions_p_suite_init(void) {
    return FCML_TRUE;
}

fcml_bool fcml_tf_instructions_p_suite_cleanup(void) {
    return FCML_TRUE;
}

void fcml_tf_instruction_PABS(void) {

    FCML_I64( "pabsb mm0,mmword ptr [rax]", 0x0F, 0x38, 0x1C, 0x00 );
    FCML_I32( "pabsb mm0,mm1", 0x0F, 0x38, 0x1C, 0xC1 );
    FCML_I64( "pabsw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x1D, 0x00 );
    FCML_I32( "pabsw mm0,mm1", 0x0F, 0x38, 0x1D, 0xC1 );
    FCML_I64( "pabsd mm0,mmword ptr [rax]", 0x0F, 0x38, 0x1E, 0x00 );
    FCML_I32( "pabsd mm0,mm1", 0x0F, 0x38, 0x1E, 0xC1 );
    FCML_I64( "pabsb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x1C, 0x00 );
    FCML_I32( "pabsb xmm0,xmm1", 0x66, 0x0F, 0x38, 0x1C, 0xC1 );
    FCML_I64( "pabsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x1D, 0x00 );
    FCML_I32( "pabsw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x1D, 0xC1 );
    FCML_I64( "pabsd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x1E, 0x00 );
    FCML_I32( "pabsd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x1E, 0xC1 );
    FCML_A64( "pabsb (%rax),%mm0", 0x0f, 0x38, 0x1c, 0x00 );
    FCML_A64( "pabsb %mm1,%mm0", 0x0f, 0x38, 0x1c, 0xc1 );
    FCML_A64( "pabsw (%rax),%mm0", 0x0f, 0x38, 0x1d, 0x00 );
    FCML_A64( "pabsw %mm1,%mm0", 0x0f, 0x38, 0x1d, 0xc1 );
    FCML_A64( "pabsd (%rax),%mm0", 0x0f, 0x38, 0x1e, 0x00 );
    FCML_A64( "pabsd %mm1,%mm0", 0x0f, 0x38, 0x1e, 0xc1 );
    FCML_A64( "pabsb (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x1c, 0x00 );
    FCML_A64( "pabsb %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x1c, 0xc1 );
    FCML_A64( "pabsw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x1d, 0x00 );
    FCML_A64( "pabsw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x1d, 0xc1 );
    FCML_A64( "pabsd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x1e, 0x00 );
    FCML_A64( "pabsd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x1e, 0xc1 );
    FCML_A64( "pabsb (%rax),%mm0", 0x0f, 0x38, 0x1c, 0x00 );
    FCML_A64( "pabsb %mm1,%mm0", 0x0f, 0x38, 0x1c, 0xc1 );
    FCML_A64( "pabsb (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x1c, 0x00 );
    FCML_A64( "pabsb %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x1c, 0xc1 );

    FCML_I64_M("vpabsb xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x1c, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x1c, 0x00));
    FCML_I32_M("vpabsb xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x1c, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x1c, 0xc1));
    FCML_I64_M("vpabsw xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x1d, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x1d, 0x00));
    FCML_I32_M("vpabsw xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x1d, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x1d, 0xc1));
    FCML_I64_M("vpabsd xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x1e, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x1e, 0x00));
    FCML_I32_M("vpabsd xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x1e, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x1e, 0xc1));
    FCML_I64_M("vpabsb ymm0,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x1c, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x1c, 0x00));
    FCML_I32_M("vpabsb ymm0,ymm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x1c, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x1c, 0xc1));
    FCML_I64_M("vpabsw ymm0,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x1d, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x1d, 0x00));
    FCML_I32_M("vpabsw ymm0,ymm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x1d, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x1d, 0xc1));
    FCML_I64_M("vpabsd ymm0,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x1e, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x1e, 0x00));
    FCML_I32_M("vpabsd ymm0,ymm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x1e, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x1e, 0xc1));
    FCML_A64_M("vpabsb (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x1c, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x1c, 0x00));
    FCML_A64_M("vpabsb %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x1c, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x1c, 0xc1));
    FCML_A64_M("vpabsw (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x1d, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x1d, 0x00));
    FCML_A64_M("vpabsw %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x1d, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x1d, 0xc1));
    FCML_A64_M("vpabsd (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x1e, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x1e, 0x00));
    FCML_A64_M("vpabsd %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x1e, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x1e, 0xc1));
    FCML_A64_M("vpabsb (%rax),%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x1c, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x1c, 0x00));
    FCML_A64_M("vpabsb %ymm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x1c, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x1c, 0xc1));
    FCML_A64_M("vpabsw (%rax),%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x1d, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x1d, 0x00));
    FCML_A64_M("vpabsw %ymm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x1d, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x1d, 0xc1));
    FCML_A64_M("vpabsd (%rax),%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x1e, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x1e, 0x00));
    FCML_A64_M("vpabsd %ymm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x1e, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x1e, 0xc1));
    FCML_A64_M("vpabsb (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x1c, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x1c, 0x00));
    FCML_A64_M("vpabsb %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x1c, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x1c, 0xc1));
    FCML_A64_M("vpabsb (%rax),%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x1c, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x1c, 0x00));
    FCML_A64_M("vpabsb %ymm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x1c, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x1c, 0xc1));

    FCML_A64("vpabsb 0x0000000000000040(%rax),%xmm0{%k5}{z}", 0x62, 0xf2, 0x7d, 0x8d, 0x1c, 0x40, 0x04);
    FCML_A64("vpabsw 0x0000000000000040(%rax),%xmm0{%k6}{z}", 0x62, 0xf2, 0x7d, 0x8e, 0x1d, 0x40, 0x04);
    FCML_A64("vpabsd 0x0000000000000040(%rax),%xmm0{%k2}{z}", 0x62, 0xf2, 0x7d, 0x8a, 0x1e, 0x40, 0x04);
    FCML_A64("vpabsq 0x0000000000000040(%rax),%zmm0{%k1}{z}", 0x62, 0xf2, 0xfd, 0xc9, 0x1f, 0x40, 0x01);
}

void fcml_tf_instruction_PACKSS(void) {

    FCML_I64( "packsswb mm0,mmword ptr [rax]", 0x0F, 0x63, 0x00 );
    FCML_I32( "packsswb mm0,mm1", 0x0F, 0x63, 0xC1 );

    FCML_I64( "packssdw mm0,mmword ptr [rax]", 0x0F, 0x6B, 0x00 );
    FCML_I32( "packssdw mm0,mm1", 0x0F, 0x6B, 0xC1 );

    FCML_I64( "packsswb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x63, 0x00 );
    FCML_I32( "packsswb xmm0,xmm1", 0x66, 0x0F, 0x63, 0xC1 );
    FCML_I64( "packssdw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x6b, 0x00 );
    FCML_I32( "packssdw xmm0,xmm1", 0x66, 0x0F, 0x6b, 0xC1 );

    FCML_A64( "packsswb (%rax),%mm0", 0x0f, 0x63, 0x00 );
    FCML_A64( "packsswb %mm1,%mm0", 0x0f, 0x63, 0xc1 );
    FCML_A64( "packssdw (%rax),%mm0", 0x0f, 0x6b, 0x00 );
    FCML_A64( "packssdw %mm1,%mm0", 0x0f, 0x6b, 0xc1 );
    FCML_A64( "packsswb (%rax),%xmm0", 0x66, 0x0f, 0x63, 0x00 );
    FCML_A64( "packsswb %xmm1,%xmm0", 0x66, 0x0f, 0x63, 0xc1 );

    FCML_I64_M("vpacksswb xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x63, 0x00), FCML_MI(0xc5, 0xe1, 0x63, 0x00));
    FCML_I32_M("vpacksswb xmm0,xmm3,xmm1", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x63, 0xc1), FCML_MI(0xc5, 0xe1, 0x63, 0xc1));
    FCML_I64_M("vpackssdw xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x6b, 0x00), FCML_MI(0xc5, 0xe1, 0x6b, 0x00));
    FCML_I32_M("vpackssdw xmm0,xmm3,xmm1", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x6b, 0xc1), FCML_MI(0xc5, 0xe1, 0x6b, 0xc1));
    FCML_I64_M("vpacksswb ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x63, 0x00), FCML_MI(0xc5, 0xe5, 0x63, 0x00));
    FCML_I64_M("vpackssdw ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x6b, 0x00), FCML_MI(0xc5, 0xe5, 0x6b, 0x00));
    FCML_I32_M("vpacksswb ymm0,ymm3,ymm1", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x63, 0xc1), FCML_MI(0xc5, 0xe5, 0x63, 0xc1));
    FCML_I32_M("vpackssdw ymm0,ymm3,ymm1", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x6b, 0xc1), FCML_MI(0xc5, 0xe5, 0x6b, 0xc1));
    FCML_A64_M("vpacksswb (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x63, 0x00), FCML_MI(0xc5, 0xe1, 0x63, 0x00));
    FCML_A64_M("vpacksswb %xmm1,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x63, 0xc1), FCML_MI(0xc5, 0xe1, 0x63, 0xc1));
    FCML_A64_M("vpacksswb (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x63, 0x00), FCML_MI(0xc5, 0xe5, 0x63, 0x00));
    FCML_A64_M("vpackssdw %ymm1,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x6b, 0xc1), FCML_MI(0xc5, 0xe5, 0x6b, 0xc1));

    FCML_A64("vpacksswb 0x0000000000000040(%rax),%xmm5,%xmm0{%k5}{z}", 0x62, 0xf1, 0x55, 0x8d, 0x63, 0x40, 0x04);
    FCML_A64("vpackssdw 0x0000000000000040(%rax),%xmm7,%xmm0{%k6}{z}", 0x62, 0xf1, 0x45, 0x8e, 0x6b, 0x40, 0x04);
}

void fcml_tf_instruction_PACKUSD(void) {

    FCML_I64( "packusdw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x2B, 0x00 );
    FCML_I32( "packusdw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x2B, 0xC1 );
    FCML_A64( "packusdw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x2b, 0x00 );
    FCML_A64( "packusdw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x2b, 0xc1 );

    FCML_I64_M("vpackusdw xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x2b, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x2b, 0x00));
    FCML_I32_M("vpackusdw xmm0,xmm3,xmm1", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x2b, 0xc1), FCML_MI(0xc4, 0xe2, 0x61, 0x2b, 0xc1));
    FCML_I64_M("vpackusdw ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x2b, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0x2b, 0x00));
    FCML_I32_M("vpackusdw ymm0,ymm3,ymm1", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x2b, 0xc1), FCML_MI(0xc4, 0xe2, 0x65, 0x2b, 0xc1));
    FCML_A64_M("vpackusdw (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x2b, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x2b, 0x00));
    FCML_A64_M("vpackusdw %xmm1,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x2b, 0xc1), FCML_MI(0xc4, 0xe2, 0x61, 0x2b, 0xc1));
    FCML_A64_M("vpackusdw (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x2b, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0x2b, 0x00));
    FCML_A64_M("vpackusdw %ymm1,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x2b, 0xc1), FCML_MI(0xc4, 0xe2, 0x65, 0x2b, 0xc1));

    FCML_A64("vpackusdw 0x0000000000000040(%rax),%xmm5,%xmm0{%k5}{z}", 0x62, 0xf2, 0x55, 0x8d, 0x2b, 0x40, 0x04);
}

void fcml_tf_instruction_PACKUSW(void) {
    FCML_I64( "packuswb mm0,mmword ptr [rax]", 0x0F, 0x67, 0x00 );
    FCML_I32( "packuswb mm0,mm1", 0x0F, 0x67, 0xC1 );
    FCML_I64( "packuswb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x67, 0x00 );
    FCML_I32( "packuswb xmm0,xmm1", 0x66, 0x0F, 0x67, 0xC1 );
    FCML_A64( "packuswb (%rax),%mm0", 0x0f, 0x67, 0x00 );
    FCML_A64( "packuswb %mm1,%mm0", 0x0f, 0x67, 0xc1 );
    FCML_A64( "packuswb (%rax),%xmm0", 0x66, 0x0f, 0x67, 0x00 );
    FCML_A64( "packuswb %xmm1,%xmm0", 0x66, 0x0f, 0x67, 0xc1 );

    FCML_I64_M("vpackuswb xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x67, 0x00), FCML_MI(0xc5, 0xe1, 0x67, 0x00));
    FCML_I32_M("vpackuswb xmm0,xmm3,xmm1", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x67, 0xc1), FCML_MI(0xc5, 0xe1, 0x67, 0xc1));
    FCML_I64_M("vpackuswb ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x67, 0x00), FCML_MI(0xc5, 0xe5, 0x67, 0x00));
    FCML_I32_M("vpackuswb ymm0,ymm3,ymm1", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x67, 0xc1), FCML_MI(0xc5, 0xe5, 0x67, 0xc1));
    FCML_A64_M("vpackuswb (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x67, 0x00), FCML_MI(0xc5, 0xe1, 0x67, 0x00));
    FCML_A64_M("vpackuswb %xmm1,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x67, 0xc1), FCML_MI(0xc5, 0xe1, 0x67, 0xc1));
    FCML_A64_M("vpackuswb (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x67, 0x00), FCML_MI(0xc5, 0xe5, 0x67, 0x00));
    FCML_A64_M("vpackuswb %ymm1,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x67, 0xc1), FCML_MI(0xc5, 0xe5, 0x67, 0xc1));

    FCML_A64("vpackuswb 0x0000000000000040(%rax),%xmm5,%xmm0{%k5}{z}", 0x62, 0xf1, 0x55, 0x8d, 0x67, 0x40, 0x04);
}

void fcml_tf_instruction_PADD(void) {
    FCML_I64( "paddb mm0,mmword ptr [rax]", 0x0F, 0xFC, 0x00 );
    FCML_I32( "paddb mm0,mm1", 0x0F, 0xFC, 0xC1 );
    FCML_I64( "paddw mm0,mmword ptr [rax]", 0x0F, 0xFD, 0x00 );
    FCML_I32( "paddw mm0,mm1", 0x0F, 0xFD, 0xC1 );
    FCML_I64( "paddd mm0,mmword ptr [rax]", 0x0F, 0xFE, 0x00 );
    FCML_I32( "paddd mm0,mm1", 0x0F, 0xFE, 0xC1 );

    FCML_I64( "paddb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xFC, 0x00 );
    FCML_I32( "paddb xmm0,xmm1", 0x66, 0x0F, 0xFC, 0xC1 );
    FCML_I64( "paddw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xFD, 0x00 );
    FCML_I32( "paddw xmm0,xmm1", 0x66, 0x0F, 0xFD, 0xC1 );
    FCML_I64( "paddd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xFE, 0x00 );
    FCML_I32( "paddd xmm0,xmm1", 0x66, 0x0F, 0xFE, 0xC1 );

    FCML_A64( "paddb (%rax),%mm0", 0x0f, 0xfc, 0x00 );
    FCML_A64( "paddb %mm1,%mm0", 0x0f, 0xfc, 0xc1 );
    FCML_A64( "paddw (%rax),%mm0", 0x0f, 0xfd, 0x00 );
    FCML_A64( "paddw %mm1,%mm0", 0x0f, 0xfd, 0xc1 );
    FCML_A64( "paddd (%rax),%mm0", 0x0f, 0xfe, 0x00 );
    FCML_A64( "paddd %mm1,%mm0", 0x0f, 0xfe, 0xc1 );
    FCML_A64( "paddb (%rax),%xmm0", 0x66, 0x0f, 0xfc, 0x00 );
    FCML_A64( "paddb %xmm1,%xmm0", 0x66, 0x0f, 0xfc, 0xc1 );
    FCML_A64( "paddw (%rax),%xmm0", 0x66, 0x0f, 0xfd, 0x00 );
    FCML_A64( "paddw %xmm1,%xmm0", 0x66, 0x0f, 0xfd, 0xc1 );
    FCML_A64( "paddd (%rax),%xmm0", 0x66, 0x0f, 0xfe, 0x00 );
    FCML_A64( "paddd %xmm1,%xmm0", 0x66, 0x0f, 0xfe, 0xc1 );

    FCML_I64_M("vpaddb xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xfc, 0x00), FCML_MI(0xc5, 0xf9, 0xfc, 0x00));
    FCML_I32_M("vpaddb xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xfc, 0xc1), FCML_MI(0xc5, 0xf9, 0xfc, 0xc1));
    FCML_I64_M("vpaddw xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xfd, 0x00), FCML_MI(0xc5, 0xf9, 0xfd, 0x00));
    FCML_I32_M("vpaddw xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xfd, 0xc1), FCML_MI(0xc5, 0xf9, 0xfd, 0xc1));
    FCML_I64_M("vpaddd xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xfe, 0x00), FCML_MI(0xc5, 0xf9, 0xfe, 0x00));
    FCML_I32_M("vpaddd xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xfe, 0xc1), FCML_MI(0xc5, 0xf9, 0xfe, 0xc1));
    FCML_I64_M("vpaddb ymm0,ymm0,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xfc, 0x00), FCML_MI(0xc5, 0xfd, 0xfc, 0x00));
    FCML_I32_M("vpaddb ymm0,ymm0,ymm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xfc, 0xc1), FCML_MI(0xc5, 0xfd, 0xfc, 0xc1));
    FCML_I64_M("vpaddw ymm0,ymm0,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xfd, 0x00), FCML_MI(0xc5, 0xfd, 0xfd, 0x00));
    FCML_I32_M("vpaddw ymm0,ymm0,ymm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xfd, 0xc1), FCML_MI(0xc5, 0xfd, 0xfd, 0xc1));
    FCML_I64_M("vpaddd ymm0,ymm0,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xfe, 0x00), FCML_MI(0xc5, 0xfd, 0xfe, 0x00));
    FCML_I32_M("vpaddd ymm0,ymm0,ymm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xfe, 0xc1), FCML_MI(0xc5, 0xfd, 0xfe, 0xc1));
    FCML_I64_M("vpaddq ymm0,ymm0,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x28, 0xd4, 0x00), FCML_MI(0xc5, 0xfd, 0xd4, 0x00));
    FCML_I32_M("vpaddq ymm0,ymm0,ymm1", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x28, 0xd4, 0xc1), FCML_MI(0xc5, 0xfd, 0xd4, 0xc1));
    FCML_A64_M("vpaddb (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xfc, 0x00), FCML_MI(0xc5, 0xf9, 0xfc, 0x00));
    FCML_A64_M("vpaddb %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xfc, 0xc1), FCML_MI(0xc5, 0xf9, 0xfc, 0xc1));
    FCML_A64_M("vpaddw (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xfd, 0x00), FCML_MI(0xc5, 0xf9, 0xfd, 0x00));
    FCML_A64_M("vpaddw %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xfd, 0xc1), FCML_MI(0xc5, 0xf9, 0xfd, 0xc1));
    FCML_A64_M("vpaddd (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xfe, 0x00), FCML_MI(0xc5, 0xf9, 0xfe, 0x00));
    FCML_A64_M("vpaddd %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xfe, 0xc1), FCML_MI(0xc5, 0xf9, 0xfe, 0xc1));
    FCML_A64_M("vpaddb (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xfc, 0x00), FCML_MI(0xc5, 0xfd, 0xfc, 0x00));
    FCML_A64_M("vpaddb %ymm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xfc, 0xc1), FCML_MI(0xc5, 0xfd, 0xfc, 0xc1));
    FCML_A64_M("vpaddw (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xfd, 0x00), FCML_MI(0xc5, 0xfd, 0xfd, 0x00));
    FCML_A64_M("vpaddw %ymm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xfd, 0xc1), FCML_MI(0xc5, 0xfd, 0xfd, 0xc1));
    FCML_A64_M("vpaddd (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xfe, 0x00), FCML_MI(0xc5, 0xfd, 0xfe, 0x00));
    FCML_A64_M("vpaddd %ymm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xfe, 0xc1), FCML_MI(0xc5, 0xfd, 0xfe, 0xc1));
    FCML_A64_M("vpaddq (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x28, 0xd4, 0x00), FCML_MI(0xc5, 0xfd, 0xd4, 0x00));
    FCML_A64_M("vpaddq %ymm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x28, 0xd4, 0xc1), FCML_MI(0xc5, 0xfd, 0xd4, 0xc1));

    FCML_A64("vpaddb 0x0000000000000040(%rax),%xmm0,%xmm0{%k2}{z}", 0x62, 0xf1, 0x7d, 0x8a, 0xfc, 0x40, 0x04);
    FCML_A64("vpaddw 0x0000000000000040(%rax),%xmm0,%xmm0{%k2}{z}", 0x62, 0xf1, 0x7d, 0x8a, 0xfd, 0x40, 0x04);
    FCML_A64("vpaddd 0x0000000000000040(%rax),%xmm0,%xmm0{%k2}{z}", 0x62, 0xf1, 0x7d, 0x8a, 0xfe, 0x40, 0x04);
    FCML_A64("vpaddd 0x0000000000000020(%rax){1to4},%xmm0,%xmm0{%k2}{z}", 0x62, 0xf1, 0x7d, 0x9a, 0xfe, 0x40, 0x08);
}

void fcml_tf_instruction_PADDS(void) {

    FCML_I64( "paddsb mm0,mmword ptr [rax]", 0x0F, 0xEC, 0x00 );
    FCML_I32( "paddsb mm0,mm1", 0x0F, 0xEC, 0xC1 );

    FCML_I64( "paddsw mm0,mmword ptr [rax]", 0x0F, 0xED, 0x00 );
    FCML_I32( "paddsw mm0,mm1", 0x0F, 0xED, 0xC1 );

    FCML_I64( "paddsb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xEC, 0x00 );
    FCML_I32( "paddsb xmm0,xmm1", 0x66, 0x0F, 0xEC, 0xC1 );

    FCML_I64( "paddsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xED, 0x00 );
    FCML_I32( "paddsw xmm0,xmm1", 0x66, 0x0F, 0xED, 0xC1 );

    FCML_A64( "paddsb (%rax),%mm0", 0x0f, 0xec, 0x00 );
    FCML_A64( "paddsb %mm1,%mm0", 0x0f, 0xec, 0xc1 );
    FCML_A64( "paddsw (%rax),%mm0", 0x0f, 0xed, 0x00 );
    FCML_A64( "paddsw %mm1,%mm0", 0x0f, 0xed, 0xc1 );
    FCML_A64( "paddsb (%rax),%xmm0", 0x66, 0x0f, 0xec, 0x00 );
    FCML_A64( "paddsb %xmm1,%xmm0", 0x66, 0x0f, 0xec, 0xc1 );
    FCML_A64( "paddsw (%rax),%xmm0", 0x66, 0x0f, 0xed, 0x00 );
    FCML_A64( "paddsw %xmm1,%xmm0", 0x66, 0x0f, 0xed, 0xc1 );

    FCML_I64_M("vpaddsb xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xec, 0x00), FCML_MI(0xc5, 0xf9, 0xec, 0x00));
    FCML_I32_M("vpaddsb xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xec, 0xc1), FCML_MI(0xc5, 0xf9, 0xec, 0xc1));
    FCML_I64_M("vpaddsw xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xed, 0x00), FCML_MI(0xc5, 0xf9, 0xed, 0x00));
    FCML_I32_M("vpaddsw xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xed, 0xc1), FCML_MI(0xc5, 0xf9, 0xed, 0xc1));
    FCML_I64_M("vpaddsb ymm0,ymm0,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xec, 0x00), FCML_MI(0xc5, 0xfd, 0xec, 0x00));
    FCML_I32_M("vpaddsb ymm0,ymm0,ymm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xec, 0xc1), FCML_MI(0xc5, 0xfd, 0xec, 0xc1));
    FCML_I64_M("vpaddsw ymm0,ymm0,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xed, 0x00), FCML_MI(0xc5, 0xfd, 0xed, 0x00));
    FCML_I32_M("vpaddsw ymm0,ymm0,ymm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xed, 0xc1), FCML_MI(0xc5, 0xfd, 0xed, 0xc1));
    FCML_A64_M("vpaddsb (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xec, 0x00), FCML_MI(0xc5, 0xf9, 0xec, 0x00));
    FCML_A64_M("vpaddsb %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xec, 0xc1), FCML_MI(0xc5, 0xf9, 0xec, 0xc1));
    FCML_A64_M("vpaddsw (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xed, 0x00), FCML_MI(0xc5, 0xf9, 0xed, 0x00));
    FCML_A64_M("vpaddsw %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xed, 0xc1), FCML_MI(0xc5, 0xf9, 0xed, 0xc1));
    FCML_A64_M("vpaddsb (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xec, 0x00), FCML_MI(0xc5, 0xfd, 0xec, 0x00));
    FCML_A64_M("vpaddsb %ymm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xec, 0xc1), FCML_MI(0xc5, 0xfd, 0xec, 0xc1));
    FCML_A64_M("vpaddsw (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xed, 0x00), FCML_MI(0xc5, 0xfd, 0xed, 0x00));
    FCML_A64_M("vpaddsw %ymm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xed, 0xc1), FCML_MI(0xc5, 0xfd, 0xed, 0xc1));

    FCML_A64("vpaddsw 0x0000000000000040(%rax),%ymm0,%ymm0{%k1}{z}", 0x62, 0xf1, 0x7d, 0xa9, 0xed, 0x40, 0x02);
    FCML_A64("vpaddsw 0x0000000000000040(%rax),%ymm0,%ymm0{%k3}{z}", 0x62, 0xf1, 0x7d, 0xab, 0xed, 0x40, 0x02);
}

void fcml_tf_instruction_PADDUS(void) {

    FCML_I64( "paddusb mm0,mmword ptr [rax]", 0x0F, 0xDC, 0x00 );
    FCML_I32( "paddusb mm0,mm1", 0x0F, 0xDC, 0xC1 );

    FCML_I64( "paddusw mm0,mmword ptr [rax]", 0x0F, 0xDD, 0x00 );
    FCML_I32( "paddusw mm0,mm1", 0x0F, 0xDD, 0xC1 );

    FCML_I64( "paddusb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xDC, 0x00 );
    FCML_I32( "paddusb xmm0,xmm1", 0x66, 0x0F, 0xDC, 0xC1 );

    FCML_I64( "paddusw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xDD, 0x00 );
    FCML_I32( "paddusw xmm0,xmm1", 0x66, 0x0F, 0xDD, 0xC1 );

    FCML_A64( "paddusb (%rax),%mm0", 0x0f, 0xdc, 0x00 );
    FCML_A64( "paddusb %mm1,%mm0", 0x0f, 0xdc, 0xc1 );
    FCML_A64( "paddusw (%rax),%mm0", 0x0f, 0xdd, 0x00 );
    FCML_A64( "paddusw %mm1,%mm0", 0x0f, 0xdd, 0xc1 );
    FCML_A64( "paddusb (%rax),%xmm0", 0x66, 0x0f, 0xdc, 0x00 );
    FCML_A64( "paddusb %xmm1,%xmm0", 0x66, 0x0f, 0xdc, 0xc1 );
    FCML_A64( "paddusw (%rax),%xmm0", 0x66, 0x0f, 0xdd, 0x00 );
    FCML_A64( "paddusw %xmm1,%xmm0", 0x66, 0x0f, 0xdd, 0xc1 );

    FCML_I64_M("vpaddusb xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xdc, 0x00), FCML_MI(0xc5, 0xf9, 0xdc, 0x00));
    FCML_I32_M("vpaddusb xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xdc, 0xc1), FCML_MI(0xc5, 0xf9, 0xdc, 0xc1));
    FCML_I64_M("vpaddusw xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xdd, 0x00), FCML_MI(0xc5, 0xf9, 0xdd, 0x00));
    FCML_I32_M("vpaddusw xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xdd, 0xc1), FCML_MI(0xc5, 0xf9, 0xdd, 0xc1));
    FCML_I64_M("vpaddusb ymm0,ymm0,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xdc, 0x00), FCML_MI(0xc5, 0xfd, 0xdc, 0x00));
    FCML_I32_M("vpaddusb ymm0,ymm0,ymm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xdc, 0xc1), FCML_MI(0xc5, 0xfd, 0xdc, 0xc1));
    FCML_I64_M("vpaddusw ymm0,ymm0,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xdd, 0x00), FCML_MI(0xc5, 0xfd, 0xdd, 0x00));
    FCML_I32_M("vpaddusw ymm0,ymm0,ymm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xdd, 0xc1), FCML_MI(0xc5, 0xfd, 0xdd, 0xc1));
    FCML_A64_M("vpaddusb (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xdc, 0x00), FCML_MI(0xc5, 0xf9, 0xdc, 0x00));
    FCML_A64_M("vpaddusb %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xdc, 0xc1), FCML_MI(0xc5, 0xf9, 0xdc, 0xc1));
    FCML_A64_M("vpaddusw (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xdd, 0x00), FCML_MI(0xc5, 0xf9, 0xdd, 0x00));
    FCML_A64_M("vpaddusw %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xdd, 0xc1), FCML_MI(0xc5, 0xf9, 0xdd, 0xc1));
    FCML_A64_M("vpaddusb (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xdc, 0x00), FCML_MI(0xc5, 0xfd, 0xdc, 0x00));
    FCML_A64_M("vpaddusb %ymm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xdc, 0xc1), FCML_MI(0xc5, 0xfd, 0xdc, 0xc1));
    FCML_A64_M("vpaddusw (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xdd, 0x00), FCML_MI(0xc5, 0xfd, 0xdd, 0x00));
    FCML_A64_M("vpaddusw %ymm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xdd, 0xc1), FCML_MI(0xc5, 0xfd, 0xdd, 0xc1));

    FCML_A64("vpaddusb 0x0000000000000040(%rax),%zmm0,%zmm0{%k1}{z}", 0x62, 0xf1, 0x7d, 0xc9, 0xdc, 0x40, 0x01);
    FCML_A64("vpaddusw 0x0000000000000040(%rax),%zmm0,%zmm0{%k3}{z}", 0x62, 0xf1, 0x7d, 0xcb, 0xdd, 0x40, 0x01);
}

/* TODO: There is one test for all VADDx instructions, it looks like a duplicate. */
void fcml_tf_instruction_PADDQ(void) {

    FCML_I64( "paddq mm0,mmword ptr [rax]", 0x0F, 0xD4, 0x00 );
    FCML_I32( "paddq mm0,mm1", 0x0F, 0xD4, 0xC1 );

    FCML_I64( "paddq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xD4, 0x00 );
    FCML_I32( "paddq xmm0,xmm1", 0x66, 0x0F, 0xD4, 0xC1 );

    FCML_I64_D( "vpaddq xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE1, 0x79, 0xD4, 0x00 );
    FCML_I32_D( "vpaddq xmm0,xmm0,xmm1", 0xC4, 0xE1, 0x79, 0xD4, 0xC1 );

    FCML_A64( "paddq (%rax),%mm0", 0x0f, 0xd4, 0x00 );
    FCML_A64( "paddq %mm1,%mm0", 0x0f, 0xd4, 0xc1 );
    FCML_A64( "paddq (%rax),%xmm0", 0x66, 0x0f, 0xd4, 0x00 );
    FCML_A64( "paddq %xmm1,%xmm0", 0x66, 0x0f, 0xd4, 0xc1 );

    FCML_I64_M("vpaddq xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0xd4, 0x00), FCML_MI(0xc5, 0xf9, 0xd4, 0x00));
    FCML_I32_M("vpaddq xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0xd4, 0xc1), FCML_MI(0xc5, 0xf9, 0xd4, 0xc1));
    FCML_A64_M("vpaddq (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0xd4, 0x00), FCML_MI(0xc5, 0xf9, 0xd4, 0x00));
    FCML_A64_M("vpaddq %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0xd4, 0xc1), FCML_MI(0xc5, 0xf9, 0xd4, 0xc1));
    FCML_A64_M("vpaddq (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0xd4, 0x00), FCML_MI(0xc5, 0xf9, 0xd4, 0x00));
    FCML_A64_M("vpaddq %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0xd4, 0xc1), FCML_MI(0xc5, 0xf9, 0xd4, 0xc1));

    FCML_A64("vpaddq 0x0000000000000040(%rax),%xmm0,%xmm0{%k2}{z}", 0x62, 0xf1, 0xfd, 0x8a, 0xd4, 0x40, 0x04);
    FCML_A64("vpaddq 0x0000000000000020(%rax){1to2},%xmm0,%xmm0{%k2}{z}", 0x62, 0xf1, 0xfd, 0x9a, 0xd4, 0x40, 0x04);
}

void fcml_tf_instruction_PALIGNR(void) {

    FCML_I64( "palignr mm0,mmword ptr [rax],0ffh", 0x0F, 0x3A, 0x0F, 0x00, 0xFF );
    FCML_I32( "palignr mm0,mm1,0ffh", 0x0F, 0x3A, 0x0F, 0xC1, 0xFF );

    FCML_I64( "palignr xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x0F, 0x00, 0xFF );
    FCML_I32( "palignr xmm0,xmm1,0ffh", 0x66, 0x0F, 0x3A, 0x0F, 0xC1, 0xFF );

    FCML_A64( "palignr $0xff,(%rax),%mm0", 0x0f, 0x3a, 0x0f, 0x00, 0xff );
    FCML_A64( "palignr $0xff,%mm1,%mm0", 0x0f, 0x3a, 0x0f, 0xc1, 0xff );
    FCML_A64( "palignr $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x0f, 0x00, 0xff );
    FCML_A64( "palignr $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x3a, 0x0f, 0xc1, 0xff );

    FCML_I64_M("vpalignr xmm0,xmm0,xmmword ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x0f, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x0f, 0x00, 0xff));
    FCML_I32_M("vpalignr xmm0,xmm0,xmm1,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x0f, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x0f, 0xc1, 0xff));
    FCML_I64_M("vpalignr ymm0,ymm0,ymmword ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x28, 0x0f, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x7d, 0x0f, 0x00, 0xff));
    FCML_I32_M("vpalignr ymm0,ymm0,ymm1,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x28, 0x0f, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x7d, 0x0f, 0xc1, 0xff));
    FCML_A64_M("vpalignr $0xff,(%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x0f, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x0f, 0x00, 0xff));
    FCML_A64_M("vpalignr $0xff,%xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x0f, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x0f, 0xc1, 0xff));
    FCML_A64_M("vpalignr $0xff,(%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x28, 0x0f, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x7d, 0x0f, 0x00, 0xff));
    FCML_A64_M("vpalignr $0xff,%ymm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x28, 0x0f, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x7d, 0x0f, 0xc1, 0xff));
    FCML_A64("vpalignr $0xff,0x0000000000000040(%rax),%zmm0,%zmm0{%k1}{z}", 0x62, 0xf3, 0x7d, 0xc9, 0x0f, 0x40, 0x01, 0xff);
}

void fcml_tf_instruction_PAND(void) {

    FCML_I64( "pand mm0,mmword ptr [rax]", 0x0F, 0xDB, 0x00 );
    FCML_I32( "pand mm0,mm1", 0x0F, 0xDB, 0xC1 );

    FCML_I64( "pand xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xDB, 0x00 );
    FCML_I32( "pand xmm0,xmm1", 0x66, 0x0F, 0xDB, 0xC1 );

    FCML_I64( "vpand xmm0,xmm2,xmmword ptr [rax]", 0xc5, 0xe9, 0xdb, 0x00 );
    FCML_I32( "vpand xmm0,xmm2,xmm1", 0xc5, 0xe9, 0xdb, 0xc1 );

    FCML_I64( "vpand ymm0,ymm2,ymmword ptr [rax]", 0xc5, 0xed, 0xdb, 0x00 );
    FCML_I32( "vpand ymm0,ymm2,ymm1", 0xc5, 0xed, 0xdb, 0xc1 );

    FCML_A64( "pand (%rax),%mm0", 0x0f, 0xdb, 0x00 );
    FCML_A64( "pand %mm1,%mm0", 0x0f, 0xdb, 0xc1 );
    FCML_A64( "pand (%rax),%xmm0", 0x66, 0x0f, 0xdb, 0x00 );
    FCML_A64( "pand %xmm1,%xmm0", 0x66, 0x0f, 0xdb, 0xc1 );
    FCML_A64( "vpand (%rax),%xmm2,%xmm0", 0xc5, 0xe9, 0xdb, 0x00 );
    FCML_A64( "vpand %xmm1,%xmm2,%xmm0", 0xc5, 0xe9, 0xdb, 0xc1 );
    FCML_A64( "vpand (%rax),%ymm2,%ymm0", 0xc5, 0xed, 0xdb, 0x00 );
    FCML_A64( "vpand %ymm1,%ymm2,%ymm0", 0xc5, 0xed, 0xdb, 0xc1 );
}

void fcml_tf_instruction_VPANDD(void) {
    FCML_A64("vpandd (%rax),%xmm2,%xmm0", 0x62, 0xf1, 0x6d, 0x08, 0xdb, 0x00);
    FCML_A64("vpandd %xmm5,%xmm2,%xmm0", 0x62, 0xf1, 0x6d, 0x08, 0xdb, 0xc5);
    FCML_A64("vpandd (%rax),%ymm2,%ymm0", 0x62, 0xf1, 0x6d, 0x28, 0xdb, 0x00);
    FCML_A64("vpandd %ymm5,%ymm2,%ymm0", 0x62, 0xf1, 0x6d, 0x28, 0xdb, 0xc5);
    FCML_A64("vpandd (%rax),%zmm2,%zmm0", 0x62, 0xf1, 0x6d, 0x48, 0xdb, 0x00);
    FCML_A64("vpandd %zmm5,%zmm2,%zmm0", 0x62, 0xf1, 0x6d, 0x48, 0xdb, 0xc5);
    FCML_A64("vpandd 0x0000000000000040(%rax),%zmm2,%zmm0{%k2}{z}", 0x62, 0xf1, 0x6d, 0xca, 0xdb, 0x40, 0x01);
    FCML_A64("vpandd 0x0000000000000004(%rax){1to16},%zmm2,%zmm0{%k2}{z}", 0x62, 0xf1, 0x6d, 0xDA, 0xdb, 0x40, 0x01);

    FCML_I64("vpandd zmm0{k2}{z},zmm2,dword ptr [rax+0000000000000004h]{1to16}", 0x62, 0xf1, 0x6d, 0xDA, 0xdb, 0x40, 0x01);
}

void fcml_tf_instruction_VPANDQ(void) {
    FCML_A64("vpandq (%rax),%xmm2,%xmm0", 0x62, 0xf1, 0xED, 0x08, 0xdb, 0x00);
    FCML_A64("vpandq %xmm5,%xmm2,%xmm0", 0x62, 0xf1, 0xED, 0x08, 0xdb, 0xc5);
    FCML_A64("vpandq (%rax),%ymm2,%ymm0", 0x62, 0xf1, 0xED, 0x28, 0xdb, 0x00);
    FCML_A64("vpandq %ymm5,%ymm2,%ymm0", 0x62, 0xf1, 0xED, 0x28, 0xdb, 0xc5);
    FCML_A64("vpandq (%rax),%zmm2,%zmm0", 0x62, 0xf1, 0xED, 0x48, 0xdb, 0x00);
    FCML_A64("vpandq %zmm5,%zmm2,%zmm0", 0x62, 0xf1, 0xED, 0x48, 0xdb, 0xc5);
    FCML_A64("vpandq 0x0000000000000040(%rax),%zmm2,%zmm0{%k2}{z}", 0x62, 0xf1, 0xED, 0xca, 0xdb, 0x40, 0x01);
    FCML_A64("vpandq 0x0000000000000008(%rax){1to8},%zmm2,%zmm0{%k2}{z}", 0x62, 0xf1, 0xED, 0xDA, 0xdb, 0x40, 0x01);

    FCML_I64("vpandq zmm0{k2}{z},zmm2,mmword ptr [rax+0000000000000008h]{1to8}", 0x62, 0xf1, 0xED, 0xDA, 0xdb, 0x40, 0x01);
}

void fcml_tf_instruction_PANDN(void) {

    FCML_I64( "pandn mm0,mmword ptr [rax]", 0x0F, 0xDF, 0x00 );
    FCML_I32( "pandn mm0,mm1", 0x0F, 0xDF, 0xC1 );

    FCML_I64( "pandn xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xDF, 0x00 );
    FCML_I32( "pandn xmm0,xmm1", 0x66, 0x0F, 0xDF, 0xC1 );

    FCML_I64( "vpandn xmm0,xmm2,xmmword ptr [rax]", 0xc5, 0xe9, 0xdf, 0x00 );
    FCML_I32( "vpandn xmm0,xmm2,xmm1", 0xc5, 0xe9, 0xdf, 0xc1 );

    FCML_I64( "vpandn ymm0,ymm2,ymmword ptr [rax]", 0xc5, 0xed, 0xdf, 0x00 );
    FCML_I32( "vpandn ymm0,ymm2,ymm1", 0xc5, 0xed, 0xdf, 0xc1 );

    FCML_A64( "pandn (%rax),%mm0", 0x0f, 0xdf, 0x00 );
    FCML_A64( "pandn %mm1,%mm0", 0x0f, 0xdf, 0xc1 );
    FCML_A64( "pandn (%rax),%xmm0", 0x66, 0x0f, 0xdf, 0x00 );
    FCML_A64( "pandn %xmm1,%xmm0", 0x66, 0x0f, 0xdf, 0xc1 );
    FCML_A64( "vpandn (%rax),%xmm2,%xmm0", 0xc5, 0xe9, 0xdf, 0x00 );
    FCML_A64( "vpandn %xmm1,%xmm2,%xmm0", 0xc5, 0xe9, 0xdf, 0xc1 );
    FCML_A64( "vpandn (%rax),%ymm2,%ymm0", 0xc5, 0xed, 0xdf, 0x00 );
    FCML_A64( "vpandn %ymm1,%ymm2,%ymm0", 0xc5, 0xed, 0xdf, 0xc1 );

}

void fcml_tf_instruction_VPANDND(void) {
    FCML_A64("vpandnd (%rax),%xmm2,%xmm0", 0x62, 0xf1, 0x6d, 0x08, 0xdf, 0x00);
    FCML_A64("vpandnd %xmm5,%xmm2,%xmm0", 0x62, 0xf1, 0x6d, 0x08, 0xdf, 0xc5);
    FCML_A64("vpandnd (%rax),%ymm2,%ymm0", 0x62, 0xf1, 0x6d, 0x28, 0xdf, 0x00);
    FCML_A64("vpandnd %ymm5,%ymm2,%ymm0", 0x62, 0xf1, 0x6d, 0x28, 0xdf, 0xc5);
    FCML_A64("vpandnd (%rax),%zmm2,%zmm0", 0x62, 0xf1, 0x6d, 0x48, 0xdf, 0x00);
    FCML_A64("vpandnd %zmm5,%zmm2,%zmm0", 0x62, 0xf1, 0x6d, 0x48, 0xdf, 0xc5);
    FCML_A64("vpandnd 0x0000000000000040(%rax),%zmm2,%zmm0{%k2}{z}", 0x62, 0xf1, 0x6d, 0xca, 0xdf, 0x40, 0x01);
    FCML_A64("vpandnd 0x0000000000000004(%rax){1to16},%zmm2,%zmm0{%k2}{z}", 0x62, 0xf1, 0x6d, 0xDA, 0xdf, 0x40, 0x01);

    FCML_I64("vpandnd zmm0{k2}{z},zmm2,dword ptr [rax+0000000000000004h]{1to16}", 0x62, 0xf1, 0x6d, 0xDA, 0xdf, 0x40, 0x01);
}

void fcml_tf_instruction_VPANDNQ(void) {
    FCML_A64("vpandnq (%rax),%xmm2,%xmm0", 0x62, 0xf1, 0xED, 0x08, 0xdf, 0x00);
    FCML_A64("vpandnq %xmm5,%xmm2,%xmm0", 0x62, 0xf1, 0xED, 0x08, 0xdf, 0xc5);
    FCML_A64("vpandnq (%rax),%ymm2,%ymm0", 0x62, 0xf1, 0xED, 0x28, 0xdf, 0x00);
    FCML_A64("vpandnq %ymm5,%ymm2,%ymm0", 0x62, 0xf1, 0xED, 0x28, 0xdf, 0xc5);
    FCML_A64("vpandnq (%rax),%zmm2,%zmm0", 0x62, 0xf1, 0xED, 0x48, 0xdf, 0x00);
    FCML_A64("vpandnq %zmm5,%zmm2,%zmm0", 0x62, 0xf1, 0xED, 0x48, 0xdf, 0xc5);
    FCML_A64("vpandnq 0x0000000000000040(%rax),%zmm2,%zmm0{%k2}{z}", 0x62, 0xf1, 0xED, 0xca, 0xdf, 0x40, 0x01);
    FCML_A64("vpandnq 0x0000000000000008(%rax){1to8},%zmm2,%zmm0{%k2}{z}", 0x62, 0xf1, 0xED, 0xDA, 0xdf, 0x40, 0x01);

    FCML_I64("vpandnq zmm0{k2}{z},zmm2,mmword ptr [rax+0000000000000008h]{1to8}", 0x62, 0xf1, 0xED, 0xDA, 0xdf, 0x40, 0x01);
}

void fcml_tf_instruction_PAUSE(void) {
    FCML_I3264( "pause", 0xF3, 0x90 );
    FCML_A64( "pause", 0xf3, 0x90 );
}

void fcml_tf_instruction_PAVGB(void) {

    FCML_I64( "pavgb mm0,mmword ptr [rax]", 0x0F, 0xE0, 0x00 );
    FCML_I32( "pavgb mm0,mm1", 0x0F, 0xE0, 0xC1 );

    FCML_I64( "pavgw mm0,mmword ptr [rax]", 0x0F, 0xE3, 0x00 );
    FCML_I32( "pavgw mm0,mm1", 0x0F, 0xE3, 0xC1 );

    FCML_I64( "pavgb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE0, 0x00 );
    FCML_I32( "pavgb xmm0,xmm1", 0x66, 0x0F, 0xE0, 0xC1 );

    FCML_I64( "pavgw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE3, 0x00 );
    FCML_I32( "pavgw xmm0,xmm1", 0x66, 0x0F, 0xE3, 0xC1 );

    FCML_A64( "pavgb (%rax),%mm0", 0x0f, 0xe0, 0x00 );
    FCML_A64( "pavgb %mm1,%mm0", 0x0f, 0xe0, 0xc1 );
    FCML_A64( "pavgw (%rax),%mm0", 0x0f, 0xe3, 0x00 );
    FCML_A64( "pavgw %mm1,%mm0", 0x0f, 0xe3, 0xc1 );
    FCML_A64( "pavgb (%rax),%xmm0", 0x66, 0x0f, 0xe0, 0x00 );
    FCML_A64( "pavgb %xmm1,%xmm0", 0x66, 0x0f, 0xe0, 0xc1 );
    FCML_A64( "pavgw (%rax),%xmm0", 0x66, 0x0f, 0xe3, 0x00 );
    FCML_A64( "pavgw %xmm1,%xmm0", 0x66, 0x0f, 0xe3, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpavgb (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe0, 0x38), FCML_MI(0xc5, 0x41, 0xe0, 0x38));
    FCML_I64_M("vpavgb xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe0, 0x38), FCML_MI(0xc5, 0x41, 0xe0, 0x38));
    FCML_A32_M("vpavgb (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xe0, 0x38), FCML_MI(0xc5, 0xc9, 0xe0, 0x38));
    FCML_I32_M("vpavgb xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xe0, 0x38), FCML_MI(0xc5, 0xc9, 0xe0, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpavgb (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe0, 0x38), FCML_MI(0xc5, 0x45, 0xe0, 0x38));
    FCML_I64_M("vpavgb ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe0, 0x38), FCML_MI(0xc5, 0x45, 0xe0, 0x38));
    FCML_A32_M("vpavgb (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xe0, 0x38), FCML_MI(0xc5, 0xd5, 0xe0, 0x38));
    FCML_I32_M("vpavgb ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xe0, 0x38), FCML_MI(0xc5, 0xd5, 0xe0, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpavgb (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xe0, 0x38);
    FCML_I64("vpavgb zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xe0, 0x38);
    FCML_A32("vpavgb (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xe0, 0x38);
    FCML_I32("vpavgb zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xe0, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpavgb %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe0, 0xf9), FCML_MI(0xc5, 0x41, 0xe0, 0xf9));
    FCML_I64_M("vpavgb xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe0, 0xf9), FCML_MI(0xc5, 0x41, 0xe0, 0xf9));
    FCML_A32_M("vpavgb %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe0, 0xf9), FCML_MI(0xc5, 0xe9, 0xe0, 0xf9));
    FCML_I32_M("vpavgb xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe0, 0xf9), FCML_MI(0xc5, 0xe9, 0xe0, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpavgb %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe0, 0xf6), FCML_MI(0xc5, 0x45, 0xe0, 0xf6));
    FCML_I64_M("vpavgb ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe0, 0xf6), FCML_MI(0xc5, 0x45, 0xe0, 0xf6));
    FCML_A32_M("vpavgb %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xe0, 0xf5), FCML_MI(0xc5, 0xe5, 0xe0, 0xf5));
    FCML_I32_M("vpavgb ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xe0, 0xf5), FCML_MI(0xc5, 0xe5, 0xe0, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpavgb %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xe0, 0xf4);
    FCML_I64("vpavgb zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xe0, 0xf4);
    FCML_A32("vpavgb %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xe0, 0xf4);
    FCML_I32("vpavgb zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xe0, 0xf4);
    /* disp8 */
    FCML_I32("vpavgb zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xe0, 0x4c, 0x24, 0x08);
    FCML_A32("vpavgb 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xe0, 0x4c, 0x24, 0x08);
    FCML_I64("vpavgb zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xe0, 0x4c, 0x24, 0x08);
    FCML_A64("vpavgb 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xe0, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpavgb ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe0, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe0, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpavgb 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe0, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe0, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpavgb ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe0, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe0, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpavgb 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe0, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe0, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpavgb xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe0, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe0, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpavgb 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe0, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe0, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpavgb xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe0, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe0, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpavgb 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe0, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe0, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k} */
    FCML_A64("vpavgb (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xe0, 0x14, 0x01);
    FCML_I64("vpavgb xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xe0, 0x14, 0x01);
    FCML_A32("vpavgb (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xe0, 0x14, 0x01);
    FCML_I32("vpavgb xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xe0, 0x14, 0x01);
    FCML_A64("vpavgb (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xe0, 0x14, 0x01);
    FCML_I64("vpavgb ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xe0, 0x14, 0x01);
    FCML_A32("vpavgb (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xe0, 0x14, 0x01);
    FCML_I32("vpavgb ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xe0, 0x14, 0x01);
    FCML_A64("vpavgb (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xe0, 0x14, 0x01);
    FCML_I64("vpavgb zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xe0, 0x14, 0x01);
    FCML_A32("vpavgb (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xe0, 0x14, 0x01);
    FCML_I32("vpavgb zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xe0, 0x14, 0x01);
    /* {k}{z} */
    FCML_A64("vpavgb (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xe0, 0x14, 0x01);
    FCML_I64("vpavgb xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xe0, 0x14, 0x01);
    FCML_A32("vpavgb (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xe0, 0x14, 0x01);
    FCML_I32("vpavgb xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xe0, 0x14, 0x01);
    FCML_A64("vpavgb (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xe0, 0x14, 0x01);
    FCML_I64("vpavgb ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xe0, 0x14, 0x01);
    FCML_A32("vpavgb (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xe0, 0x14, 0x01);
    FCML_I32("vpavgb ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xe0, 0x14, 0x01);
    FCML_A64("vpavgb (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xe0, 0x14, 0x01);
    FCML_I64("vpavgb zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xe0, 0x14, 0x01);
    FCML_A32("vpavgb (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xe0, 0x14, 0x01);
    FCML_I32("vpavgb zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xe0, 0x14, 0x01);

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpavgw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe3, 0x38), FCML_MI(0xc5, 0x41, 0xe3, 0x38));
    FCML_I64_M("vpavgw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe3, 0x38), FCML_MI(0xc5, 0x41, 0xe3, 0x38));
    FCML_A32_M("vpavgw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xe3, 0x38), FCML_MI(0xc5, 0xc9, 0xe3, 0x38));
    FCML_I32_M("vpavgw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xe3, 0x38), FCML_MI(0xc5, 0xc9, 0xe3, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpavgw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe3, 0x38), FCML_MI(0xc5, 0x45, 0xe3, 0x38));
    FCML_I64_M("vpavgw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe3, 0x38), FCML_MI(0xc5, 0x45, 0xe3, 0x38));
    FCML_A32_M("vpavgw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xe3, 0x38), FCML_MI(0xc5, 0xd5, 0xe3, 0x38));
    FCML_I32_M("vpavgw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xe3, 0x38), FCML_MI(0xc5, 0xd5, 0xe3, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpavgw (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xe3, 0x38);
    FCML_I64("vpavgw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xe3, 0x38);
    FCML_A32("vpavgw (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xe3, 0x38);
    FCML_I32("vpavgw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xe3, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpavgw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe3, 0xf9), FCML_MI(0xc5, 0x41, 0xe3, 0xf9));
    FCML_I64_M("vpavgw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe3, 0xf9), FCML_MI(0xc5, 0x41, 0xe3, 0xf9));
    FCML_A32_M("vpavgw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe3, 0xf9), FCML_MI(0xc5, 0xe9, 0xe3, 0xf9));
    FCML_I32_M("vpavgw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe3, 0xf9), FCML_MI(0xc5, 0xe9, 0xe3, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpavgw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe3, 0xf6), FCML_MI(0xc5, 0x45, 0xe3, 0xf6));
    FCML_I64_M("vpavgw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe3, 0xf6), FCML_MI(0xc5, 0x45, 0xe3, 0xf6));
    FCML_A32_M("vpavgw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xe3, 0xf5), FCML_MI(0xc5, 0xe5, 0xe3, 0xf5));
    FCML_I32_M("vpavgw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xe3, 0xf5), FCML_MI(0xc5, 0xe5, 0xe3, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpavgw %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xe3, 0xf4);
    FCML_I64("vpavgw zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xe3, 0xf4);
    FCML_A32("vpavgw %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xe3, 0xf4);
    FCML_I32("vpavgw zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xe3, 0xf4);
    /* disp8 */
    FCML_I32("vpavgw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xe3, 0x4c, 0x24, 0x08);
    FCML_A32("vpavgw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xe3, 0x4c, 0x24, 0x08);
    FCML_I64("vpavgw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xe3, 0x4c, 0x24, 0x08);
    FCML_A64("vpavgw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xe3, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpavgw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe3, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe3, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpavgw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe3, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe3, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpavgw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe3, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe3, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpavgw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe3, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe3, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpavgw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe3, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe3, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpavgw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe3, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe3, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpavgw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe3, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe3, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpavgw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe3, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe3, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k} */
    FCML_A64("vpavgw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xe3, 0x14, 0x01);
    FCML_I64("vpavgw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xe3, 0x14, 0x01);
    FCML_A32("vpavgw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xe3, 0x14, 0x01);
    FCML_I32("vpavgw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xe3, 0x14, 0x01);
    FCML_A64("vpavgw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xe3, 0x14, 0x01);
    FCML_I64("vpavgw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xe3, 0x14, 0x01);
    FCML_A32("vpavgw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xe3, 0x14, 0x01);
    FCML_I32("vpavgw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xe3, 0x14, 0x01);
    FCML_A64("vpavgw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xe3, 0x14, 0x01);
    FCML_I64("vpavgw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xe3, 0x14, 0x01);
    FCML_A32("vpavgw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xe3, 0x14, 0x01);
    FCML_I32("vpavgw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xe3, 0x14, 0x01);
    /* {k}{z} */
    FCML_A64("vpavgw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xe3, 0x14, 0x01);
    FCML_I64("vpavgw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xe3, 0x14, 0x01);
    FCML_A32("vpavgw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xe3, 0x14, 0x01);
    FCML_I32("vpavgw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xe3, 0x14, 0x01);
    FCML_A64("vpavgw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xe3, 0x14, 0x01);
    FCML_I64("vpavgw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xe3, 0x14, 0x01);
    FCML_A32("vpavgw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xe3, 0x14, 0x01);
    FCML_I32("vpavgw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xe3, 0x14, 0x01);
    FCML_A64("vpavgw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xe3, 0x14, 0x01);
    FCML_I64("vpavgw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xe3, 0x14, 0x01);
    FCML_A32("vpavgw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xe3, 0x14, 0x01);
    FCML_I32("vpavgw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xe3, 0x14, 0x01);
}

void fcml_tf_instruction_PBLENDVB(void) {

    FCML_I32( "pblendvb xmm2,xmmword ptr [ecx+eax],xmm0", 0x66, 0x0f, 0x38, 0x10, 0x14, 0x01 );
    FCML_I64( "pblendvb xmm2,xmmword ptr [rcx+rax],xmm0", 0x66, 0x0F, 0x38, 0x10, 0x14, 0x01 );

    FCML_I32( "vpblendvb xmm2,xmm7,xmmword ptr [ecx+eax],xmm2", 0xc4, 0xe3, 0x41, 0x4c, 0x14, 0x01, 0x20 );
    FCML_I32( "vpblendvb xmm2,xmm2,xmmword ptr [ecx+eax],xmm2", 0xc4, 0xe3, 0x69, 0x4c, 0x14, 0x01, 0x20 );
    FCML_I64( "vpblendvb xmm2,xmm2,xmmword ptr [r9+rax],xmm10", 0xC4, 0xC3, 0x69, 0x4C, 0x14, 0x01, 0xA0 );

    FCML_I32( "vpblendvb ymm2,ymm7,ymmword ptr [ecx+eax],ymm2", 0xc4, 0xe3, 0x45, 0x4c, 0x14, 0x01, 0x20 );
    FCML_I64( "vpblendvb ymm2,ymm2,ymmword ptr [r9+rax],ymm10", 0xC4, 0xC3, 0x6D, 0x4C, 0x14, 0x01, 0xA0 );

    FCML_A64( "pblendvb %xmm0,(%rcx,%rax),%xmm2", 0x66, 0x0f, 0x38, 0x10, 0x14, 0x01 );
    FCML_A64( "pblendvb %xmm0,(%rcx,%rax),%xmm2", 0x66, 0x0f, 0x38, 0x10, 0x14, 0x01 );
    FCML_A64( "vpblendvb %xmm2,(%rcx,%rax),%xmm7,%xmm2", 0xc4, 0xe3, 0x41, 0x4c, 0x14, 0x01, 0x20 );
    FCML_A64( "vpblendvb %xmm2,(%rcx,%rax),%xmm2,%xmm2", 0xc4, 0xe3, 0x69, 0x4c, 0x14, 0x01, 0x20 );
    FCML_A64( "vpblendvb %xmm10,(%r9,%rax),%xmm2,%xmm2", 0xc4, 0xc3, 0x69, 0x4c, 0x14, 0x01, 0xa0 );
    FCML_A64( "vpblendvb %ymm2,(%rcx,%rax),%ymm7,%ymm2", 0xc4, 0xe3, 0x45, 0x4c, 0x14, 0x01, 0x20 );
    FCML_A64( "vpblendvb %ymm10,(%r9,%rax),%ymm2,%ymm2", 0xc4, 0xc3, 0x6d, 0x4c, 0x14, 0x01, 0xa0 );
}

void fcml_tf_instruction_PBLENDW(void) {

    FCML_I64( "pblendw xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x0E, 0x00, 0xFF );
    FCML_I32( "pblendw xmm0,xmm1,0ffh", 0x66, 0x0F, 0x3A, 0x0E, 0xC1, 0xFF );

    FCML_I64( "vpblendw xmm0,xmm0,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x0E, 0x00, 0xFF );
    FCML_I32( "vpblendw xmm0,xmm0,xmm1,0ffh", 0xC4, 0xE3, 0x79, 0x0E, 0xC1, 0xFF );

    FCML_I64( "vpblendw ymm0,ymm0,ymmword ptr [rax],0ffh", 0xC4, 0xE3, 0x7D, 0x0E, 0x00, 0xFF );
    FCML_I32( "vpblendw ymm0,ymm0,ymm1,0ffh", 0xC4, 0xE3, 0x7D, 0x0E, 0xC1, 0xFF );

    FCML_A64( "pblendw $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x0e, 0x00, 0xff );
    FCML_A64( "pblendw $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x3a, 0x0e, 0xc1, 0xff );
    FCML_A64( "vpblendw $0xff,(%rax),%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x0e, 0x00, 0xff );
    FCML_A64( "vpblendw $0xff,%xmm1,%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x0e, 0xc1, 0xff );
    FCML_A64( "vpblendw $0xff,(%rax),%ymm0,%ymm0", 0xc4, 0xe3, 0x7d, 0x0e, 0x00, 0xff );
    FCML_A64( "vpblendw $0xff,%ymm1,%ymm0,%ymm0", 0xc4, 0xe3, 0x7d, 0x0e, 0xc1, 0xff );
}

void fcml_tf_instruction_PCLMULQDQ(void) {

    FCML_I64( "pclmulqdq xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x44, 0x00, 0xFF );
    FCML_I32( "pclmulqdq xmm0,xmm1,0ffh", 0x66, 0x0F, 0x3A, 0x44, 0xC1, 0xFF );

    FCML_I64( "vpclmulqdq xmm0,xmm0,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x44, 0x00, 0xFF );
    FCML_I32( "vpclmulqdq xmm0,xmm0,xmm1,0ffh", 0xC4, 0xE3, 0x79, 0x44, 0xC1, 0xFF );

    FCML_A64( "pclmulqdq $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x44, 0x00, 0xff );
    FCML_A64( "pclmulqdq $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x3a, 0x44, 0xc1, 0xff );
    FCML_A64( "vpclmulqdq $0xff,(%rax),%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x44, 0x00, 0xff );
    FCML_A64( "vpclmulqdq $0xff,%xmm1,%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x44, 0xc1, 0xff );
}

void fcml_tf_instruction_PCMPEQ(void) {

    FCML_I64( "pcmpeqb mm0,mmword ptr [rax]", 0x0F, 0x74, 0x00 );
    FCML_I32( "pcmpeqb mm0,mm1", 0x0F, 0x74, 0xC1 );
    FCML_I64( "pcmpeqw mm0,mmword ptr [rax]", 0x0F, 0x75, 0x00 );
    FCML_I32( "pcmpeqw mm0,mm1", 0x0F, 0x75, 0xC1 );
    FCML_I64( "pcmpeqd mm0,mmword ptr [rax]", 0x0F, 0x76, 0x00 );
    FCML_I32( "pcmpeqd mm0,mm1", 0x0F, 0x76, 0xC1 );

    FCML_I64( "pcmpeqb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x74, 0x00 );
    FCML_I32( "pcmpeqb xmm0,xmm1", 0x66, 0x0F, 0x74, 0xC1 );
    FCML_I64( "pcmpeqw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x75, 0x00 );
    FCML_I32( "pcmpeqw xmm0,xmm1", 0x66, 0x0F, 0x75, 0xC1 );
    FCML_I64( "pcmpeqd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x76, 0x00 );
    FCML_I32( "pcmpeqd xmm0,xmm1", 0x66, 0x0F, 0x76, 0xC1 );

    FCML_I64( "vpcmpeqb xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x74, 0x00 );
    FCML_I32( "vpcmpeqb xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x74, 0xc1 );
    FCML_I64( "vpcmpeqw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x75, 0x00 );
    FCML_I32( "vpcmpeqw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x75, 0xc1 );
    FCML_I64( "vpcmpeqd xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x76, 0x00 );
    FCML_I32( "vpcmpeqd xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x76, 0xc1 );

    FCML_I64( "vpcmpeqd k1{k2},xmm0,xmmword ptr [rax]", 0x62, 0xf1, 0x7d, 0x0a, 0x76, 0x08 );
    FCML_I32( "vpcmpeqd k1{k3},xmm0,xmm1", 0x62, 0xf1, 0x7d, 0x0b, 0x76, 0xc9 );
    FCML_I32( "vpcmpeqd k1{k1},xmm0,xmm1", 0x62, 0xf1, 0x7d, 0x09, 0x76, 0xc9 );
    FCML_I64( "vpcmpeqd k1{k2},xmm0,xmmword ptr [rax+0000000000000040h]", 0x62, 0xf1, 0x7d, 0x0a, 0x76, 0x48, 0x04 );
    FCML_I64( "vpcmpeqd k1{k2},xmm0,dword ptr [rax+0000000000000040h]{1to4}", 0x62, 0xf1, 0x7d, 0x1a, 0x76, 0x48, 0x10 );

    /* k1, xmm2, m128 */
    FCML_A32("vpcmpeqb (%eax),%xmm6,%k7", 0x62, 0xf1, 0x4d, 0x08, 0x74, 0x38);
    FCML_I32("vpcmpeqb k7,xmm6,xmmword ptr [eax]", 0x62, 0xf1, 0x4d, 0x08, 0x74, 0x38);
    /* k1, ymm2, m256 */
    FCML_A32("vpcmpeqb (%eax),%ymm5,%k7", 0x62, 0xf1, 0x55, 0x28, 0x74, 0x38);
    FCML_I32("vpcmpeqb k7,ymm5,ymmword ptr [eax]", 0x62, 0xf1, 0x55, 0x28, 0x74, 0x38);
    /* k1, zmm2, m512 */
    FCML_A32("vpcmpeqb (%eax),%zmm3,%k7", 0x62, 0xf1, 0x65, 0x48, 0x74, 0x38);
    FCML_I32("vpcmpeqb k7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0x74, 0x38);
    /* k1, xmm2, xmm3 */
    FCML_A32("vpcmpeqb %xmm1,%xmm2,%k7", 0x62, 0xf1, 0x6d, 0x08, 0x74, 0xf9);
    FCML_I32("vpcmpeqb k7,xmm2,xmm1", 0x62, 0xf1, 0x6d, 0x08, 0x74, 0xf9);
    /* k1, ymm2, ymm3 */
    FCML_A32("vpcmpeqb %ymm5,%ymm3,%k6", 0x62, 0xf1, 0x65, 0x28, 0x74, 0xf5);
    FCML_I32("vpcmpeqb k6,ymm3,ymm5", 0x62, 0xf1, 0x65, 0x28, 0x74, 0xf5);
    /* k1, zmm2, zmm3 */
    FCML_A64("vpcmpeqb %zmm4,%zmm15,%k6", 0x62, 0xf1, 0x05, 0x48, 0x74, 0xf4);
    FCML_I64("vpcmpeqb k6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0x74, 0xf4);
    FCML_A32("vpcmpeqb %zmm4,%zmm6,%k6", 0x62, 0xf1, 0x4d, 0x48, 0x74, 0xf4);
    FCML_I32("vpcmpeqb k6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0x74, 0xf4);
    /* disp8 */
    FCML_I32("vpcmpeqb k1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x74, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpeqb 0x00000200(%esp),%zmm2,%k1", 0x62, 0xf1, 0x6d, 0x48, 0x74, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpeqb k1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x74, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpeqb 0x0000000000000200(%rsp),%zmm2,%k1", 0x62, 0xf1, 0x6d, 0x48, 0x74, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpeqb k1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf1, 0x6d, 0x28, 0x74, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpeqb 0x00000100(%esp),%ymm2,%k1", 0x62, 0xf1, 0x6d, 0x28, 0x74, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpeqb k1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf1, 0x6d, 0x28, 0x74, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpeqb 0x0000000000000100(%rsp),%ymm2,%k1", 0x62, 0xf1, 0x6d, 0x28, 0x74, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpeqb k1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf1, 0x6d, 0x08, 0x74, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpeqb 0x00000080(%esp),%xmm2,%k1", 0x62, 0xf1, 0x6d, 0x08, 0x74, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpeqb k1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf1, 0x6d, 0x08, 0x74, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpeqb 0x0000000000000080(%rsp),%xmm2,%k1", 0x62, 0xf1, 0x6d, 0x08, 0x74, 0x4c, 0x24, 0x08);
    /* {k} */
    FCML_A64("vpcmpeqb (%rcx,%rax),%xmm7,%k2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0x74, 0x14, 0x01);
    FCML_I64("vpcmpeqb k2{k5},xmm7,xmmword ptr [rcx+rax]", 0x62, 0xf1, 0x45, 0x0d, 0x74, 0x14, 0x01);
    FCML_A32("vpcmpeqb (%ecx,%eax),%ymm7,%k2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0x74, 0x14, 0x01);
    FCML_I32("vpcmpeqb k2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0x74, 0x14, 0x01);
    FCML_A32("vpcmpeqb (%ecx,%eax),%zmm7,%k2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0x74, 0x14, 0x01);
    FCML_I32("vpcmpeqb k2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0x74, 0x14, 0x01);

    /* k1, xmm2, m128 */
    FCML_A32("vpcmpeqw (%eax),%xmm6,%k7", 0x62, 0xf1, 0x4d, 0x08, 0x75, 0x38);
    FCML_I32("vpcmpeqw k7,xmm6,xmmword ptr [eax]", 0x62, 0xf1, 0x4d, 0x08, 0x75, 0x38);
    /* k1, ymm2, m256 */
    FCML_A32("vpcmpeqw (%eax),%ymm5,%k7", 0x62, 0xf1, 0x55, 0x28, 0x75, 0x38);
    FCML_I32("vpcmpeqw k7,ymm5,ymmword ptr [eax]", 0x62, 0xf1, 0x55, 0x28, 0x75, 0x38);
    /* k1, zmm2, m512 */
    FCML_A32("vpcmpeqw (%eax),%zmm3,%k7", 0x62, 0xf1, 0x65, 0x48, 0x75, 0x38);
    FCML_I32("vpcmpeqw k7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0x75, 0x38);
    /* k1, xmm2, xmm3 */
    FCML_A32("vpcmpeqw %xmm1,%xmm2,%k7", 0x62, 0xf1, 0x6d, 0x08, 0x75, 0xf9);
    FCML_I32("vpcmpeqw k7,xmm2,xmm1", 0x62, 0xf1, 0x6d, 0x08, 0x75, 0xf9);
    /* k1, ymm2, ymm3 */
    FCML_A32("vpcmpeqw %ymm5,%ymm3,%k6", 0x62, 0xf1, 0x65, 0x28, 0x75, 0xf5);
    FCML_I32("vpcmpeqw k6,ymm3,ymm5", 0x62, 0xf1, 0x65, 0x28, 0x75, 0xf5);
    /* k1, zmm2, zmm3 */
    FCML_A64("vpcmpeqw %zmm4,%zmm15,%k6", 0x62, 0xf1, 0x05, 0x48, 0x75, 0xf4);
    FCML_I64("vpcmpeqw k6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0x75, 0xf4);
    FCML_A32("vpcmpeqw %zmm4,%zmm6,%k6", 0x62, 0xf1, 0x4d, 0x48, 0x75, 0xf4);
    FCML_I32("vpcmpeqw k6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0x75, 0xf4);
    /* disp8 */
    FCML_I32("vpcmpeqw k1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x75, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpeqw 0x00000200(%esp),%zmm2,%k1", 0x62, 0xf1, 0x6d, 0x48, 0x75, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpeqw k1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x75, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpeqw 0x0000000000000200(%rsp),%zmm2,%k1", 0x62, 0xf1, 0x6d, 0x48, 0x75, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpeqw k1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf1, 0x6d, 0x28, 0x75, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpeqw 0x00000100(%esp),%ymm2,%k1", 0x62, 0xf1, 0x6d, 0x28, 0x75, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpeqw k1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf1, 0x6d, 0x28, 0x75, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpeqw 0x0000000000000100(%rsp),%ymm2,%k1", 0x62, 0xf1, 0x6d, 0x28, 0x75, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpeqw k1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf1, 0x6d, 0x08, 0x75, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpeqw 0x00000080(%esp),%xmm2,%k1", 0x62, 0xf1, 0x6d, 0x08, 0x75, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpeqw k1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf1, 0x6d, 0x08, 0x75, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpeqw 0x0000000000000080(%rsp),%xmm2,%k1", 0x62, 0xf1, 0x6d, 0x08, 0x75, 0x4c, 0x24, 0x08);
    /* {k} */
    FCML_A64("vpcmpeqw (%rcx,%rax),%xmm7,%k2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0x75, 0x14, 0x01);
    FCML_I64("vpcmpeqw k2{k5},xmm7,xmmword ptr [rcx+rax]", 0x62, 0xf1, 0x45, 0x0d, 0x75, 0x14, 0x01);
    FCML_A32("vpcmpeqw (%ecx,%eax),%ymm7,%k2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0x75, 0x14, 0x01);
    FCML_I32("vpcmpeqw k2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0x75, 0x14, 0x01);
    FCML_A32("vpcmpeqw (%ecx,%eax),%zmm7,%k2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0x75, 0x14, 0x01);
    FCML_I32("vpcmpeqw k2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0x75, 0x14, 0x01);

    FCML_I64( "vpcmpeqb ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x74, 0x00 );
    FCML_I32( "vpcmpeqb ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x74, 0xc1 );
    FCML_I64( "vpcmpeqw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x75, 0x00 );
    FCML_I32( "vpcmpeqw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x75, 0xc1 );
    FCML_I64( "vpcmpeqd ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x76, 0x00 );
    FCML_I32( "vpcmpeqd ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x76, 0xc1 );

    FCML_A64( "pcmpeqb (%rax),%mm0", 0x0f, 0x74, 0x00 );
    FCML_A64( "pcmpeqb %mm1,%mm0", 0x0f, 0x74, 0xc1 );
    FCML_A64( "pcmpeqw (%rax),%mm0", 0x0f, 0x75, 0x00 );
    FCML_A64( "pcmpeqw %mm1,%mm0", 0x0f, 0x75, 0xc1 );
    FCML_A64( "pcmpeqd (%rax),%mm0", 0x0f, 0x76, 0x00 );
    FCML_A64( "pcmpeqd %mm1,%mm0", 0x0f, 0x76, 0xc1 );
    FCML_A64( "pcmpeqb (%rax),%xmm0", 0x66, 0x0f, 0x74, 0x00 );
    FCML_A64( "pcmpeqb %xmm1,%xmm0", 0x66, 0x0f, 0x74, 0xc1 );
    FCML_A64( "pcmpeqw (%rax),%xmm0", 0x66, 0x0f, 0x75, 0x00 );
    FCML_A64( "pcmpeqw %xmm1,%xmm0", 0x66, 0x0f, 0x75, 0xc1 );
    FCML_A64( "pcmpeqd (%rax),%xmm0", 0x66, 0x0f, 0x76, 0x00 );
    FCML_A64( "pcmpeqd %xmm1,%xmm0", 0x66, 0x0f, 0x76, 0xc1 );
    FCML_A64( "vpcmpeqb (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x74, 0x00 );
    FCML_A64( "vpcmpeqb %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x74, 0xc1 );
    FCML_A64( "vpcmpeqw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x75, 0x00 );
    FCML_A64( "vpcmpeqw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x75, 0xc1 );
    FCML_A64( "vpcmpeqd (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x76, 0x00 );
    FCML_A64( "vpcmpeqd %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x76, 0xc1 );
    FCML_A64( "vpcmpeqb (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x74, 0x00 );
    FCML_A64( "vpcmpeqb %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x74, 0xc1 );
    FCML_A64( "vpcmpeqw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x75, 0x00 );
    FCML_A64( "vpcmpeqw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x75, 0xc1 );
    FCML_A64( "vpcmpeqd (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x76, 0x00 );
    FCML_A64( "vpcmpeqd %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x76, 0xc1 );

}

void fcml_tf_instruction_PCMPEQQ(void) {

    FCML_I64( "pcmpeqq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x29, 0x00 );
    FCML_I32( "pcmpeqq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x29, 0xC1 );

    FCML_I64( "vpcmpeqq xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x29, 0x00 );
    FCML_I32( "vpcmpeqq xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x29, 0xC1 );

    FCML_I64( "vpcmpeqq ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x29, 0x00 );
    FCML_I32( "vpcmpeqq ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x29, 0xC1 );

    FCML_A64( "pcmpeqq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x29, 0x00 );
    FCML_A64( "pcmpeqq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x29, 0xc1 );
    FCML_A64( "vpcmpeqq (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x29, 0x00 );
    FCML_A64( "vpcmpeqq %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x29, 0xc1 );
    FCML_A64( "vpcmpeqq (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x29, 0x00 );
    FCML_A64( "vpcmpeqq %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x29, 0xc1 );

    /* k1, xmm2, m128 */
    FCML_A32("vpcmpeqq (%eax),%xmm6,%k7", 0x62, 0xf2, 0xcd, 0x08, 0x29, 0x38);
    FCML_I32("vpcmpeqq k7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x29, 0x38);
    /* k1, ymm2, m256 */
    FCML_A32("vpcmpeqq (%eax),%ymm5,%k7", 0x62, 0xf2, 0xd5, 0x28, 0x29, 0x38);
    FCML_I32("vpcmpeqq k7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x29, 0x38);
    /* k1, zmm2, m512 */
    FCML_A32("vpcmpeqq (%eax),%zmm3,%k7", 0x62, 0xf2, 0xe5, 0x48, 0x29, 0x38);
    FCML_I32("vpcmpeqq k7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x29, 0x38);
    /* k1, xmm2, xmm3 */
    FCML_A32("vpcmpeqq %xmm1,%xmm2,%k7", 0x62, 0xf2, 0xed, 0x08, 0x29, 0xf9);
    FCML_I32("vpcmpeqq k7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x29, 0xf9);
    /* k1, ymm2, ymm3 */
    FCML_A32("vpcmpeqq %ymm5,%ymm3,%k6", 0x62, 0xf2, 0xe5, 0x28, 0x29, 0xf5);
    FCML_I32("vpcmpeqq k6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x29, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A32("vpcmpeqq %zmm4,%zmm6,%k6", 0x62, 0xf2, 0xcd, 0x48, 0x29, 0xf4);
    FCML_I32("vpcmpeqq k6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x29, 0xf4);
    /* disp8 */
    FCML_I32("vpcmpeqq k1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x29, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpeqq 0x00000200(%esp),%zmm2,%k1", 0x62, 0xf2, 0xed, 0x48, 0x29, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpeqq k1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x29, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpeqq 0x0000000000000200(%rsp),%zmm2,%k1", 0x62, 0xf2, 0xed, 0x48, 0x29, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpeqq k1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x29, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpeqq 0x00000100(%esp),%ymm2,%k1", 0x62, 0xf2, 0xed, 0x28, 0x29, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpeqq k1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x29, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpeqq 0x0000000000000100(%rsp),%ymm2,%k1", 0x62, 0xf2, 0xed, 0x28, 0x29, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpeqq k1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x29, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpeqq 0x00000080(%esp),%xmm2,%k1", 0x62, 0xf2, 0xed, 0x08, 0x29, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpeqq k1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x29, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpeqq 0x0000000000000080(%rsp),%xmm2,%k1", 0x62, 0xf2, 0xed, 0x08, 0x29, 0x4c, 0x24, 0x08);
    /* {k} */
    FCML_A32("vpcmpeqq (%ecx,%eax),%xmm7,%k2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x29, 0x14, 0x01);
    FCML_I32("vpcmpeqq k2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x29, 0x14, 0x01);
    FCML_A32("vpcmpeqq (%ecx,%eax),%ymm7,%k2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x29, 0x14, 0x01);
    FCML_I32("vpcmpeqq k2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x29, 0x14, 0x01);
    FCML_A32("vpcmpeqq (%ecx,%eax),%zmm7,%k2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x29, 0x14, 0x01);
    FCML_I32("vpcmpeqq k2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x29, 0x14, 0x01);
    /* bcast */
    FCML_A32("vpcmpeqq (%esi){1to8},%zmm2,%k1", 0x62, 0xf2, 0xed, 0x58, 0x29, 0x0e);
    FCML_I32("vpcmpeqq k1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x29, 0x0e);
    /* {bcast} disp8 */
    FCML_I32("vpcmpeqq k1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x29, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpeqq 0x00000040(%esp){1to8},%zmm2,%k1", 0x62, 0xf2, 0xed, 0x58, 0x29, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpeqq k1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x29, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpeqq 0x0000000000000040(%rsp){1to8},%zmm2,%k1", 0x62, 0xf2, 0xed, 0x58, 0x29, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpeqq k1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x29, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpeqq 0x00000040(%esp){1to4},%ymm2,%k1", 0x62, 0xf2, 0xed, 0x38, 0x29, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpeqq k1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x29, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpeqq 0x0000000000000040(%rsp){1to4},%ymm2,%k1", 0x62, 0xf2, 0xed, 0x38, 0x29, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpeqq k1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x29, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpeqq 0x00000040(%esp){1to2},%xmm2,%k1", 0x62, 0xf2, 0xed, 0x18, 0x29, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpeqq k1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x29, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpeqq 0x0000000000000040(%rsp){1to2},%xmm2,%k1", 0x62, 0xf2, 0xed, 0x18, 0x29, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PCMPESTRI(void) {

    FCML_I64( "pcmpestri xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x61, 0x00, 0xFF );
    FCML_I32( "pcmpestri xmm0,xmm1,0ffh", 0x66, 0x0F, 0x3A, 0x61, 0xC1, 0xFF );

    FCML_I64( "vpcmpestri xmm0,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x61, 0x00, 0xFF );
    FCML_I32( "vpcmpestri xmm0,xmm1,0ffh", 0xC4, 0xE3, 0x79, 0x61, 0xC1, 0xFF );

    FCML_A64( "pcmpestri $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x61, 0x00, 0xff );
    FCML_A64( "pcmpestri $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x3a, 0x61, 0xc1, 0xff );
    FCML_A64( "vpcmpestri $0xff,(%rax),%xmm0", 0xc4, 0xe3, 0x79, 0x61, 0x00, 0xff );
    FCML_A64( "vpcmpestri $0xff,%xmm1,%xmm0", 0xc4, 0xe3, 0x79, 0x61, 0xc1, 0xff );
}

void fcml_tf_instruction_PCMPESTRM(void) {

    FCML_I64( "pcmpestrm xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x60, 0x00, 0xFF );
    FCML_I32( "pcmpestrm xmm0,xmm1,0ffh", 0x66, 0x0F, 0x3A, 0x60, 0xC1, 0xFF );

    FCML_I64( "vpcmpestrm xmm0,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x60, 0x00, 0xFF );
    FCML_I32( "vpcmpestrm xmm0,xmm1,0ffh", 0xC4, 0xE3, 0x79, 0x60, 0xC1, 0xFF );

    FCML_A64( "pcmpestrm $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x60, 0x00, 0xff );
    FCML_A64( "pcmpestrm $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x3a, 0x60, 0xc1, 0xff );
    FCML_A64( "vpcmpestrm $0xff,(%rax),%xmm0", 0xc4, 0xe3, 0x79, 0x60, 0x00, 0xff );
    FCML_A64( "vpcmpestrm $0xff,%xmm1,%xmm0", 0xc4, 0xe3, 0x79, 0x60, 0xc1, 0xff );
}

void fcml_tf_instruction_PCMPGT(void) {

    FCML_I64( "pcmpgtb mm0,mmword ptr [rax]", 0x0F, 0x64, 0x00 );
    FCML_I32( "pcmpgtb mm0,mm1", 0x0F, 0x64, 0xC1 );
    FCML_I64( "pcmpgtw mm0,mmword ptr [rax]", 0x0F, 0x65, 0x00 );
    FCML_I32( "pcmpgtw mm0,mm1", 0x0F, 0x65, 0xC1 );
    FCML_I64( "pcmpgtd mm0,mmword ptr [rax]", 0x0F, 0x66, 0x00 );
    FCML_I32( "pcmpgtd mm0,mm1", 0x0F, 0x66, 0xC1 );

    FCML_I64( "pcmpgtb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x64, 0x00 );
    FCML_I32( "pcmpgtb xmm0,xmm1", 0x66, 0x0F, 0x64, 0xC1 );
    FCML_I64( "pcmpgtw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x65, 0x00 );
    FCML_I32( "pcmpgtw xmm0,xmm1", 0x66, 0x0F, 0x65, 0xC1 );
    FCML_I64( "pcmpgtd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x66, 0x00 );
    FCML_I32( "pcmpgtd xmm0,xmm1", 0x66, 0x0F, 0x66, 0xC1 );

    FCML_I64( "vpcmpgtb xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x64, 0x00 );
    FCML_I32( "vpcmpgtb xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x64, 0xc1 );
    FCML_I64( "vpcmpgtw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x65, 0x00 );
    FCML_I32( "vpcmpgtw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x65, 0xc1 );
    FCML_I64( "vpcmpgtd xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x66, 0x00 );
    FCML_I32( "vpcmpgtd xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x66, 0xc1 );

    FCML_I64( "vpcmpgtb ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x64, 0x00 );
    FCML_I32( "vpcmpgtb ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x64, 0xc1 );
    FCML_I64( "vpcmpgtw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x65, 0x00 );
    FCML_I32( "vpcmpgtw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x65, 0xc1 );
    FCML_I64( "vpcmpgtd ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x66, 0x00 );
    FCML_I32( "vpcmpgtd ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x66, 0xc1 );

    FCML_I64( "vpcmpgtd k1{k2},xmm0,xmmword ptr [rax]", 0x62, 0xf1, 0x7d, 0x0a, 0x66, 0x08 );
    FCML_I32( "vpcmpgtd k1{k3},xmm0,xmm1", 0x62, 0xf1, 0x7d, 0x0b, 0x66, 0xc9 );
    FCML_I32( "vpcmpgtd k1{k1},xmm0,xmm1", 0x62, 0xf1, 0x7d, 0x09, 0x66, 0xc9 );
    FCML_I64( "vpcmpgtd k1{k2},xmm0,xmmword ptr [rax+0000000000000040h]", 0x62, 0xf1, 0x7d, 0x0a, 0x66, 0x48, 0x04 );
    FCML_I64( "vpcmpgtd k1{k2},xmm0,dword ptr [rax+0000000000000040h]{1to4}", 0x62, 0xf1, 0x7d, 0x1a, 0x66, 0x48, 0x10 );

    FCML_A64( "pcmpgtb (%rax),%mm0", 0x0f, 0x64, 0x00 );
    FCML_A64( "pcmpgtb %mm1,%mm0", 0x0f, 0x64, 0xc1 );
    FCML_A64( "pcmpgtw (%rax),%mm0", 0x0f, 0x65, 0x00 );
    FCML_A64( "pcmpgtw %mm1,%mm0", 0x0f, 0x65, 0xc1 );
    FCML_A64( "pcmpgtd (%rax),%mm0", 0x0f, 0x66, 0x00 );
    FCML_A64( "pcmpgtd %mm1,%mm0", 0x0f, 0x66, 0xc1 );
    FCML_A64( "pcmpgtb (%rax),%xmm0", 0x66, 0x0f, 0x64, 0x00 );
    FCML_A64( "pcmpgtb %xmm1,%xmm0", 0x66, 0x0f, 0x64, 0xc1 );
    FCML_A64( "pcmpgtw (%rax),%xmm0", 0x66, 0x0f, 0x65, 0x00 );
    FCML_A64( "pcmpgtw %xmm1,%xmm0", 0x66, 0x0f, 0x65, 0xc1 );
    FCML_A64( "pcmpgtd (%rax),%xmm0", 0x66, 0x0f, 0x66, 0x00 );
    FCML_A64( "pcmpgtd %xmm1,%xmm0", 0x66, 0x0f, 0x66, 0xc1 );
    FCML_A64( "vpcmpgtb (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x64, 0x00 );
    FCML_A64( "vpcmpgtb %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x64, 0xc1 );
    FCML_A64( "vpcmpgtw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x65, 0x00 );
    FCML_A64( "vpcmpgtw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x65, 0xc1 );
    FCML_A64( "vpcmpgtd (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x66, 0x00 );
    FCML_A64( "vpcmpgtd %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x66, 0xc1 );
    FCML_A64( "vpcmpgtb (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x64, 0x00 );
    FCML_A64( "vpcmpgtb %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x64, 0xc1 );
    FCML_A64( "vpcmpgtw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x65, 0x00 );
    FCML_A64( "vpcmpgtw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x65, 0xc1 );
    FCML_A64( "vpcmpgtd (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x66, 0x00 );
    FCML_A64( "vpcmpgtd %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x66, 0xc1 );

    /* k1, xmm2, m128 */
    FCML_A32("vpcmpgtw (%eax),%xmm6,%k7", 0x62, 0xf1, 0x4d, 0x08, 0x65, 0x38);
    FCML_I32("vpcmpgtw k7,xmm6,xmmword ptr [eax]", 0x62, 0xf1, 0x4d, 0x08, 0x65, 0x38);
    /* k1, ymm2, m256 */
    FCML_A32("vpcmpgtw (%eax),%ymm5,%k7", 0x62, 0xf1, 0x55, 0x28, 0x65, 0x38);
    FCML_I32("vpcmpgtw k7,ymm5,ymmword ptr [eax]", 0x62, 0xf1, 0x55, 0x28, 0x65, 0x38);
    /* k1, zmm2, m512 */
    FCML_A32("vpcmpgtw (%eax),%zmm3,%k7", 0x62, 0xf1, 0x65, 0x48, 0x65, 0x38);
    FCML_I32("vpcmpgtw k7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0x65, 0x38);
    /* k1, xmm2, xmm3 */
    FCML_A32("vpcmpgtw %xmm1,%xmm2,%k7", 0x62, 0xf1, 0x6d, 0x08, 0x65, 0xf9);
    FCML_I32("vpcmpgtw k7,xmm2,xmm1", 0x62, 0xf1, 0x6d, 0x08, 0x65, 0xf9);
    /* k1, ymm2, ymm3 */
    FCML_A32("vpcmpgtw %ymm5,%ymm3,%k6", 0x62, 0xf1, 0x65, 0x28, 0x65, 0xf5);
    FCML_I32("vpcmpgtw k6,ymm3,ymm5", 0x62, 0xf1, 0x65, 0x28, 0x65, 0xf5);
    /* k1, zmm2, zmm3 */
    FCML_A64("vpcmpgtw %zmm4,%zmm15,%k6", 0x62, 0xf1, 0x05, 0x48, 0x65, 0xf4);
    FCML_I64("vpcmpgtw k6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0x65, 0xf4);
    FCML_A32("vpcmpgtw %zmm4,%zmm6,%k6", 0x62, 0xf1, 0x4d, 0x48, 0x65, 0xf4);
    FCML_I32("vpcmpgtw k6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0x65, 0xf4);
    /* disp8 */
    FCML_I32("vpcmpgtw k1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpgtw 0x00000200(%esp),%zmm2,%k1", 0x62, 0xf1, 0x6d, 0x48, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpgtw k1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpgtw 0x0000000000000200(%rsp),%zmm2,%k1", 0x62, 0xf1, 0x6d, 0x48, 0x65, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpgtw k1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf1, 0x6d, 0x28, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpgtw 0x00000100(%esp),%ymm2,%k1", 0x62, 0xf1, 0x6d, 0x28, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpgtw k1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf1, 0x6d, 0x28, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpgtw 0x0000000000000100(%rsp),%ymm2,%k1", 0x62, 0xf1, 0x6d, 0x28, 0x65, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpgtw k1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf1, 0x6d, 0x08, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpgtw 0x00000080(%esp),%xmm2,%k1", 0x62, 0xf1, 0x6d, 0x08, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpgtw k1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf1, 0x6d, 0x08, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpgtw 0x0000000000000080(%rsp),%xmm2,%k1", 0x62, 0xf1, 0x6d, 0x08, 0x65, 0x4c, 0x24, 0x08);
    /* {k} */
    FCML_A64("vpcmpgtw (%rcx,%rax),%xmm7,%k2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0x65, 0x14, 0x01);
    FCML_I64("vpcmpgtw k2{k5},xmm7,xmmword ptr [rcx+rax]", 0x62, 0xf1, 0x45, 0x0d, 0x65, 0x14, 0x01);
    FCML_A32("vpcmpgtw (%ecx,%eax),%ymm7,%k2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0x65, 0x14, 0x01);
    FCML_I32("vpcmpgtw k2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0x65, 0x14, 0x01);
    FCML_A32("vpcmpgtw (%ecx,%eax),%zmm7,%k2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0x65, 0x14, 0x01);
    FCML_I32("vpcmpgtw k2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0x65, 0x14, 0x01);

    /* k1, xmm2, m128 */
    FCML_A32("vpcmpgtb (%eax),%xmm6,%k7", 0x62, 0xf1, 0x4d, 0x08, 0x64, 0x38);
    FCML_I32("vpcmpgtb k7,xmm6,xmmword ptr [eax]", 0x62, 0xf1, 0x4d, 0x08, 0x64, 0x38);
    /* k1, ymm2, m256 */
    FCML_A32("vpcmpgtb (%eax),%ymm5,%k7", 0x62, 0xf1, 0x55, 0x28, 0x64, 0x38);
    FCML_I32("vpcmpgtb k7,ymm5,ymmword ptr [eax]", 0x62, 0xf1, 0x55, 0x28, 0x64, 0x38);
    /* k1, zmm2, m512 */
    FCML_A32("vpcmpgtb (%eax),%zmm3,%k7", 0x62, 0xf1, 0x65, 0x48, 0x64, 0x38);
    FCML_I32("vpcmpgtb k7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0x64, 0x38);
    /* k1, xmm2, xmm3 */
    FCML_A32("vpcmpgtb %xmm1,%xmm2,%k7", 0x62, 0xf1, 0x6d, 0x08, 0x64, 0xf9);
    FCML_I32("vpcmpgtb k7,xmm2,xmm1", 0x62, 0xf1, 0x6d, 0x08, 0x64, 0xf9);
    /* k1, ymm2, ymm3 */
    FCML_A32("vpcmpgtb %ymm5,%ymm3,%k6", 0x62, 0xf1, 0x65, 0x28, 0x64, 0xf5);
    FCML_I32("vpcmpgtb k6,ymm3,ymm5", 0x62, 0xf1, 0x65, 0x28, 0x64, 0xf5);
    /* k1, zmm2, zmm3 */
    FCML_A64("vpcmpgtb %zmm4,%zmm15,%k6", 0x62, 0xf1, 0x05, 0x48, 0x64, 0xf4);
    FCML_I64("vpcmpgtb k6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0x64, 0xf4);
    FCML_A32("vpcmpgtb %zmm4,%zmm6,%k6", 0x62, 0xf1, 0x4d, 0x48, 0x64, 0xf4);
    FCML_I32("vpcmpgtb k6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0x64, 0xf4);
    /* disp8 */
    FCML_I32("vpcmpgtb k1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpgtb 0x00000200(%esp),%zmm2,%k1", 0x62, 0xf1, 0x6d, 0x48, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpgtb k1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpgtb 0x0000000000000200(%rsp),%zmm2,%k1", 0x62, 0xf1, 0x6d, 0x48, 0x64, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpgtb k1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf1, 0x6d, 0x28, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpgtb 0x00000100(%esp),%ymm2,%k1", 0x62, 0xf1, 0x6d, 0x28, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpgtb k1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf1, 0x6d, 0x28, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpgtb 0x0000000000000100(%rsp),%ymm2,%k1", 0x62, 0xf1, 0x6d, 0x28, 0x64, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpgtb k1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf1, 0x6d, 0x08, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpgtb 0x00000080(%esp),%xmm2,%k1", 0x62, 0xf1, 0x6d, 0x08, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpgtb k1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf1, 0x6d, 0x08, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpgtb 0x0000000000000080(%rsp),%xmm2,%k1", 0x62, 0xf1, 0x6d, 0x08, 0x64, 0x4c, 0x24, 0x08);
    /* {k} */
    FCML_A64("vpcmpgtb (%rcx,%rax),%xmm7,%k2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0x64, 0x14, 0x01);
    FCML_I64("vpcmpgtb k2{k5},xmm7,xmmword ptr [rcx+rax]", 0x62, 0xf1, 0x45, 0x0d, 0x64, 0x14, 0x01);
    FCML_A32("vpcmpgtb (%ecx,%eax),%ymm7,%k2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0x64, 0x14, 0x01);
    FCML_I32("vpcmpgtb k2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0x64, 0x14, 0x01);
    FCML_A32("vpcmpgtb (%ecx,%eax),%zmm7,%k2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0x64, 0x14, 0x01);
    FCML_I32("vpcmpgtb k2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0x64, 0x14, 0x01);

}

void fcml_tf_instruction_PCMPGTQ(void) {

    FCML_I64( "pcmpgtq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x37, 0x00 );
    FCML_I32( "pcmpgtq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x37, 0xC1 );

    FCML_I64( "vpcmpgtq xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x37, 0x00 );
    FCML_I32( "vpcmpgtq xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x37, 0xC1 );

    FCML_I64( "vpcmpgtq ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x37, 0x00 );
    FCML_I32( "vpcmpgtq ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x37, 0xC1 );

    FCML_A64( "pcmpgtq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x37, 0x00 );
    FCML_A64( "pcmpgtq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x37, 0xc1 );
    FCML_A64( "vpcmpgtq (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x37, 0x00 );
    FCML_A64( "vpcmpgtq %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x37, 0xc1 );
    FCML_A64( "vpcmpgtq (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x37, 0x00 );
    FCML_A64( "vpcmpgtq %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x37, 0xc1 );

    /* k1, xmm2, m128 */
    FCML_A32("vpcmpgtq (%eax),%xmm6,%k7", 0x62, 0xf2, 0xcd, 0x08, 0x37, 0x38);
    FCML_I32("vpcmpgtq k7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x37, 0x38);
    /* k1, ymm2, m256 */
    FCML_A32("vpcmpgtq (%eax),%ymm5,%k7", 0x62, 0xf2, 0xd5, 0x28, 0x37, 0x38);
    FCML_I32("vpcmpgtq k7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x37, 0x38);
    /* k1, zmm2, m512 */
    FCML_A32("vpcmpgtq (%eax),%zmm3,%k7", 0x62, 0xf2, 0xe5, 0x48, 0x37, 0x38);
    FCML_I32("vpcmpgtq k7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x37, 0x38);
    /* k1, xmm2, xmm3 */
    FCML_A32("vpcmpgtq %xmm1,%xmm2,%k7", 0x62, 0xf2, 0xed, 0x08, 0x37, 0xf9);
    FCML_I32("vpcmpgtq k7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x37, 0xf9);
    /* k1, ymm2, ymm3 */
    FCML_A32("vpcmpgtq %ymm5,%ymm3,%k6", 0x62, 0xf2, 0xe5, 0x28, 0x37, 0xf5);
    FCML_I32("vpcmpgtq k6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x37, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A32("vpcmpgtq %zmm4,%zmm6,%k6", 0x62, 0xf2, 0xcd, 0x48, 0x37, 0xf4);
    FCML_I32("vpcmpgtq k6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x37, 0xf4);
    /* disp8 */
    FCML_I32("vpcmpgtq k1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x37, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpgtq 0x00000200(%esp),%zmm2,%k1", 0x62, 0xf2, 0xed, 0x48, 0x37, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpgtq k1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x37, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpgtq 0x0000000000000200(%rsp),%zmm2,%k1", 0x62, 0xf2, 0xed, 0x48, 0x37, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpgtq k1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x37, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpgtq 0x00000100(%esp),%ymm2,%k1", 0x62, 0xf2, 0xed, 0x28, 0x37, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpgtq k1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x37, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpgtq 0x0000000000000100(%rsp),%ymm2,%k1", 0x62, 0xf2, 0xed, 0x28, 0x37, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpgtq k1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x37, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpgtq 0x00000080(%esp),%xmm2,%k1", 0x62, 0xf2, 0xed, 0x08, 0x37, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpgtq k1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x37, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpgtq 0x0000000000000080(%rsp),%xmm2,%k1", 0x62, 0xf2, 0xed, 0x08, 0x37, 0x4c, 0x24, 0x08);
    /* {k} */
    FCML_A32("vpcmpgtq (%ecx,%eax),%xmm7,%k2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x37, 0x14, 0x01);
    FCML_I32("vpcmpgtq k2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x37, 0x14, 0x01);
    FCML_A32("vpcmpgtq (%ecx,%eax),%ymm7,%k2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x37, 0x14, 0x01);
    FCML_I32("vpcmpgtq k2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x37, 0x14, 0x01);
    FCML_A32("vpcmpgtq (%ecx,%eax),%zmm7,%k2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x37, 0x14, 0x01);
    FCML_I32("vpcmpgtq k2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x37, 0x14, 0x01);
    /* bcast */
    FCML_A32("vpcmpgtq (%esi){1to8},%zmm2,%k1", 0x62, 0xf2, 0xed, 0x58, 0x37, 0x0e);
    FCML_I32("vpcmpgtq k1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x37, 0x0e);
    /* {bcast} disp8 */
    FCML_I32("vpcmpgtq k1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x37, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpgtq 0x00000040(%esp){1to8},%zmm2,%k1", 0x62, 0xf2, 0xed, 0x58, 0x37, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpgtq k1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x37, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpgtq 0x0000000000000040(%rsp){1to8},%zmm2,%k1", 0x62, 0xf2, 0xed, 0x58, 0x37, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpgtq k1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x37, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpgtq 0x00000040(%esp){1to4},%ymm2,%k1", 0x62, 0xf2, 0xed, 0x38, 0x37, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpgtq k1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x37, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpgtq 0x0000000000000040(%rsp){1to4},%ymm2,%k1", 0x62, 0xf2, 0xed, 0x38, 0x37, 0x4c, 0x24, 0x08);
    FCML_I32("vpcmpgtq k1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x37, 0x4c, 0x24, 0x08);
    FCML_A32("vpcmpgtq 0x00000040(%esp){1to2},%xmm2,%k1", 0x62, 0xf2, 0xed, 0x18, 0x37, 0x4c, 0x24, 0x08);
    FCML_I64("vpcmpgtq k1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x37, 0x4c, 0x24, 0x08);
    FCML_A64("vpcmpgtq 0x0000000000000040(%rsp){1to2},%xmm2,%k1", 0x62, 0xf2, 0xed, 0x18, 0x37, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PCMPISTRI(void) {

    FCML_I64( "pcmpistri xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x63, 0x00, 0xFF );
    FCML_I32( "pcmpistri xmm0,xmm1,0ffh", 0x66, 0x0F, 0x3A, 0x63, 0xC1, 0xFF );

    FCML_I64( "vpcmpistri xmm0,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x63, 0x00, 0xFF );
    FCML_I32( "vpcmpistri xmm0,xmm1,0ffh", 0xC4, 0xE3, 0x79, 0x63, 0xC1, 0xFF );

    FCML_A64( "pcmpistri $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x63, 0x00, 0xff );
    FCML_A64( "pcmpistri $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x3a, 0x63, 0xc1, 0xff );
    FCML_A64( "vpcmpistri $0xff,(%rax),%xmm0", 0xc4, 0xe3, 0x79, 0x63, 0x00, 0xff );
    FCML_A64( "vpcmpistri $0xff,%xmm1,%xmm0", 0xc4, 0xe3, 0x79, 0x63, 0xc1, 0xff );
}

void fcml_tf_instruction_PCMPISTRM(void) {

    FCML_I64( "pcmpistrm xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x62, 0x00, 0xFF );
    FCML_I32( "pcmpistrm xmm0,xmm1,0ffh", 0x66, 0x0F, 0x3A, 0x62, 0xC1, 0xFF );

    FCML_I64( "vpcmpistrm xmm0,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x62, 0x00, 0xFF );
    FCML_I32( "vpcmpistrm xmm0,xmm1,0ffh", 0xC4, 0xE3, 0x79, 0x62, 0xC1, 0xFF );

    FCML_A64( "pcmpistrm $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x62, 0x00, 0xff );
    FCML_A64( "pcmpistrm $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x3a, 0x62, 0xc1, 0xff );
    FCML_A64( "vpcmpistrm $0xff,(%rax),%xmm0", 0xc4, 0xe3, 0x79, 0x62, 0x00, 0xff );
    FCML_A64( "vpcmpistrm $0xff,%xmm1,%xmm0", 0xc4, 0xe3, 0x79, 0x62, 0xc1, 0xff );
}

void fcml_tf_instruction_PEXTRB(void) {

    FCML_I64( "pextrb byte ptr [rax],xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x14, 0x00, 0xFF );
    FCML_I64( "pextrb rcx,xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x14, 0xC1, 0xFF );
    FCML_I32( "pextrb byte ptr [eax],xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x14, 0x00, 0xFF );
    FCML_I32( "pextrb ecx,xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x14, 0xC1, 0xFF );

    FCML_I64( "pextrd dword ptr [rax],xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x16, 0x00, 0xFF );
    FCML_I64( "pextrd rcx,xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x16, 0xC1, 0xFF );
    FCML_I32( "pextrd dword ptr [eax],xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x16, 0x00, 0xFF );
    FCML_I32( "pextrd ecx,xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x16, 0xC1, 0xFF );

    FCML_I64( "pextrq qword ptr [rax],xmm0,0ffh", 0x66, 0x48, 0x0F, 0x3A, 0x16, 0x00, 0xFF );
    FCML_I64( "pextrq rcx,xmm0,0ffh", 0x66, 0x48, 0x0F, 0x3A, 0x16, 0xC1, 0xFF );

    FCML_I64_M("vpextrb byte ptr [rax],xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x14, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x14, 0x00, 0xff));
    FCML_I64_M("vpextrb rcx,xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x14, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x14, 0xc1, 0xff));
    FCML_I32_M("vpextrb byte ptr [eax],xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x14, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x14, 0x00, 0xff));
    FCML_I32_M("vpextrb ecx,xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x14, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x14, 0xc1, 0xff));
    FCML_A64_M("vpextrb $0xff,%xmm0,(%rax)", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x14, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x14, 0x00, 0xff));
    FCML_A64_M("vpextrb $0xff,%xmm0,%rcx", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x14, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x14, 0xc1, 0xff));

    FCML_I64_M("vpextrd dword ptr [rax],xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x16, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x16, 0x00, 0xff));
    FCML_I64_M("vpextrd rcx,xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x16, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x16, 0xc1, 0xff));
    FCML_I32_M("vpextrd dword ptr [eax],xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x16, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x16, 0x00, 0xff));
    FCML_A64_M("vpextrd $0xff,%xmm0,(%rax)", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x16, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x16, 0x00, 0xff));
    FCML_A64_M("vpextrd $0xff,%xmm0,%rcx", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x16, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x16, 0xc1, 0xff));FCML_I32_M("vpextrd ecx,xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x16, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x16, 0xc1, 0xff));

    FCML_I64_M("vpextrq qword ptr [rax],xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x08, 0x16, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0xf9, 0x16, 0x00, 0xff));
    FCML_I64_M("vpextrq rcx,xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x08, 0x16, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0xf9, 0x16, 0xc1, 0xff));
    FCML_A64_M("vpextrq $0xff,%xmm0,(%rax)", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x08, 0x16, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0xf9, 0x16, 0x00, 0xff));
    FCML_A64_M("vpextrq $0xff,%xmm0,%rcx", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x08, 0x16, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0xf9, 0x16, 0xc1, 0xff));

    FCML_A64( "pextrb $0xff,%xmm0,(%rax)", 0x66, 0x0f, 0x3a, 0x14, 0x00, 0xff );
    FCML_A64( "pextrb $0xff,%xmm0,%rcx", 0x66, 0x0f, 0x3a, 0x14, 0xc1, 0xff );
    FCML_A64( "pextrd $0xff,%xmm0,(%rax)", 0x66, 0x0f, 0x3a, 0x16, 0x00, 0xff );
    FCML_A64( "pextrd $0xff,%xmm0,%rcx", 0x66, 0x0f, 0x3a, 0x16, 0xc1, 0xff );
    FCML_A64( "pextrq $0xff,%xmm0,(%rax)", 0x66, 0x48, 0x0f, 0x3a, 0x16, 0x00, 0xff );
    FCML_A64( "pextrq $0xff,%xmm0,%rcx", 0x66, 0x48, 0x0f, 0x3a, 0x16, 0xc1, 0xff );
}

void fcml_tf_instruction_PEXTRW(void) {

    FCML_I64( "pextrw rax,mm1,0ffh", 0x0F, 0xC5, 0xC1, 0xFF );
    FCML_I32( "pextrw eax,mm1,0ffh", 0x0F, 0xC5, 0xC1, 0xFF );

    FCML_I64_M( "pextrw rax,xmm1,0ffh", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc8, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc1, 0xff ) );
    FCML_I32_M( "pextrw eax,xmm1,0ffh", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc8, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc1, 0xff ) );

    FCML_I64( "pextrw word ptr [rax],xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x15, 0x00, 0xFF );
    FCML_I64_M( "pextrw rcx,xmm0,0ffh", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc1, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc8, 0xff ) );
    FCML_I32( "pextrw word ptr [eax],xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x15, 0x00, 0xFF );
    FCML_I32_M( "pextrw ecx,xmm0,0ffh", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc1, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc8, 0xff ) );

    FCML_A64( "pextrw $0xff,%mm1,%rax", 0x0f, 0xc5, 0xc1, 0xff );
    FCML_A64( "pextrw $0xff,%mm1,%rax", 0x0f, 0xc5, 0xc1, 0xff );
    FCML_A64( "pextrw $0xff,%xmm0,(%rax)", 0x66, 0x0f, 0x3a, 0x15, 0x00, 0xff );

    FCML_A64_M( "pextrw $0xff,%xmm1,%rax", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc8, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc1, 0xff ) );
    FCML_A64_M( "pextrw $0xff,%xmm1,%rax", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc8, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc1, 0xff ) );
    FCML_A64_M( "pextrw $0xff,%xmm0,%rcx", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc1, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc8, 0xff ) );
    FCML_A64_M( "pextrw $0xff,%xmm0,%rcx", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc1, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc8, 0xff ) );

    FCML_I64_M("vpextrw rax,xmm1,0ffh", 4, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x15, 0xc8, 0xff), FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xc5, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x15, 0xc8, 0xff), FCML_MI(0xc5, 0xf9, 0xc5, 0xc1, 0xff));
    FCML_I32_M("vpextrw eax,xmm1,0ffh", 4, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x15, 0xc8, 0xff), FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xc5, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x15, 0xc8, 0xff), FCML_MI(0xc5, 0xf9, 0xc5, 0xc1, 0xff));
    FCML_I64_M("vpextrw word ptr [rax],xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x15, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x15, 0x00, 0xff));
    FCML_I64_M("vpextrw rcx,xmm0,0ffh", 4, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x15, 0xc1, 0xff), FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xc5, 0xc8, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x15, 0xc1, 0xff), FCML_MI(0xc5, 0xf9, 0xc5, 0xc8, 0xff));
    FCML_I32_M("vpextrw word ptr [eax],xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x15, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x15, 0x00, 0xff));
    FCML_I32_M("vpextrw ecx,xmm0,0ffh", 4, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x15, 0xc1, 0xff), FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xc5, 0xc8, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x15, 0xc1, 0xff), FCML_MI(0xc5, 0xf9, 0xc5, 0xc8, 0xff));
    FCML_A64_M("vpextrw $0xff,%xmm0,(%rax)", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x15, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x15, 0x00, 0xff));
    FCML_A64_M("vpextrw $0xff,%xmm1,%rax", 4, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x15, 0xc8, 0xff), FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xc5, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x15, 0xc8, 0xff), FCML_MI(0xc5, 0xf9, 0xc5, 0xc1, 0xff));
    FCML_A64_M("vpextrw $0xff,%xmm1,%rax", 4, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x15, 0xc8, 0xff), FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xc5, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x15, 0xc8, 0xff), FCML_MI(0xc5, 0xf9, 0xc5, 0xc1, 0xff));
    FCML_A64_M("vpextrw $0xff,%xmm0,%rcx", 4, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x15, 0xc1, 0xff), FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xc5, 0xc8, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x15, 0xc1, 0xff), FCML_MI(0xc5, 0xf9, 0xc5, 0xc8, 0xff));
    FCML_I32_M("vpextrw word ptr [eax+00000040h],xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x15, 0x40, 0x20, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x15, 0x40, 0x40, 0xff));
}

void fcml_tf_instruction_PHADDW(void) {

    FCML_I64( "phaddw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x01, 0x00 );
    FCML_I32( "phaddw mm0,mm1", 0x0F, 0x38, 0x01, 0xC1 );
    FCML_I64( "phaddd mm0,mmword ptr [rax]", 0x0F, 0x38, 0x02, 0x00 );
    FCML_I32( "phaddd mm0,mm1", 0x0F, 0x38, 0x02, 0xC1 );

    FCML_I64( "phaddw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x01, 0x00 );
    FCML_I32( "phaddw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x01, 0xC1 );
    FCML_I64( "phaddd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x02, 0x00 );
    FCML_I32( "phaddd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x02, 0xC1 );

    FCML_I64( "vphaddw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x01, 0x00 );
    FCML_I32( "vphaddw xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x01, 0xC1 );
    FCML_I64( "vphaddd xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x02, 0x00 );
    FCML_I32( "vphaddd xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x02, 0xC1 );

    FCML_I64( "vphaddw ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x01, 0x00 );
    FCML_I32( "vphaddw ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x01, 0xC1 );
    FCML_I64( "vphaddd ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x02, 0x00 );
    FCML_I32( "vphaddd ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x02, 0xC1 );

    FCML_A64( "phaddw (%rax),%mm0", 0x0f, 0x38, 0x01, 0x00 );
    FCML_A64( "phaddw %mm1,%mm0", 0x0f, 0x38, 0x01, 0xc1 );
    FCML_A64( "phaddd (%rax),%mm0", 0x0f, 0x38, 0x02, 0x00 );
    FCML_A64( "phaddd %mm1,%mm0", 0x0f, 0x38, 0x02, 0xc1 );
    FCML_A64( "phaddw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x01, 0x00 );
    FCML_A64( "phaddw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x01, 0xc1 );
    FCML_A64( "phaddd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x02, 0x00 );
    FCML_A64( "phaddd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x02, 0xc1 );
    FCML_A64( "vphaddw (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x01, 0x00 );
    FCML_A64( "vphaddw %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x01, 0xc1 );
    FCML_A64( "vphaddd (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x02, 0x00 );
    FCML_A64( "vphaddd %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x02, 0xc1 );
    FCML_A64( "vphaddw (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x01, 0x00 );
    FCML_A64( "vphaddw %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x01, 0xc1 );
    FCML_A64( "vphaddd (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x02, 0x00 );
    FCML_A64( "vphaddd %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x02, 0xc1 );
}

void fcml_tf_instruction_PHADDSW(void) {

    FCML_I64( "phaddsw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x03, 0x00 );
    FCML_I32( "phaddsw mm0,mm1", 0x0F, 0x38, 0x03, 0xC1 );

    FCML_I64( "phaddsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x03, 0x00 );
    FCML_I32( "phaddsw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x03, 0xC1 );

    FCML_I64( "vphaddsw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x03, 0x00 );
    FCML_I32( "vphaddsw xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x03, 0xC1 );

    FCML_I64( "vphaddsw ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x03, 0x00 );
    FCML_I32( "vphaddsw ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x03, 0xC1 );

    FCML_A64( "phaddsw (%rax),%mm0", 0x0f, 0x38, 0x03, 0x00 );
    FCML_A64( "phaddsw %mm1,%mm0", 0x0f, 0x38, 0x03, 0xc1 );
    FCML_A64( "phaddsw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x03, 0x00 );
    FCML_A64( "phaddsw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x03, 0xc1 );
    FCML_A64( "vphaddsw (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x03, 0x00 );
    FCML_A64( "vphaddsw %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x03, 0xc1 );
    FCML_A64( "vphaddsw (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x03, 0x00 );
    FCML_A64( "vphaddsw %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x03, 0xc1 );
}

void fcml_tf_instruction_PHMINPOSUW(void) {

    FCML_I64( "phminposuw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x41, 0x00 );
    FCML_I32( "phminposuw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x41, 0xC1 );

    FCML_I64( "vphminposuw xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x41, 0x00 );
    FCML_I32( "vphminposuw xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x41, 0xC1 );

    FCML_A64( "phminposuw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x41, 0x00 );
    FCML_A64( "phminposuw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x41, 0xc1 );
    FCML_A64( "vphminposuw (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x41, 0x00 );
    FCML_A64( "vphminposuw %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x41, 0xc1 );
}

void fcml_tf_instruction_PHSUBW(void) {

    FCML_I64( "phsubw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x05, 0x00 );
    FCML_I32( "phsubw mm0,mm1", 0x0F, 0x38, 0x05, 0xC1 );
    FCML_I64( "phsubd mm0,mmword ptr [rax]", 0x0F, 0x38, 0x06, 0x00 );
    FCML_I32( "phsubd mm0,mm1", 0x0F, 0x38, 0x06, 0xC1 );

    FCML_I64( "phsubw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x05, 0x00 );
    FCML_I32( "phsubw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x05, 0xC1 );
    FCML_I64( "phsubd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x06, 0x00 );
    FCML_I32( "phsubd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x06, 0xC1 );

    FCML_I64( "vphsubw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x05, 0x00 );
    FCML_I32( "vphsubw xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x05, 0xC1 );
    FCML_I64( "vphsubd xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x06, 0x00 );
    FCML_I32( "vphsubd xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x06, 0xC1 );

    FCML_I64( "vphsubw ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x05, 0x00 );
    FCML_I32( "vphsubw ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x05, 0xC1 );
    FCML_I64( "vphsubd ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x06, 0x00 );
    FCML_I32( "vphsubd ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x06, 0xC1 );

    FCML_A64( "phsubw (%rax),%mm0", 0x0f, 0x38, 0x05, 0x00 );
    FCML_A64( "phsubw %mm1,%mm0", 0x0f, 0x38, 0x05, 0xc1 );
    FCML_A64( "phsubd (%rax),%mm0", 0x0f, 0x38, 0x06, 0x00 );
    FCML_A64( "phsubd %mm1,%mm0", 0x0f, 0x38, 0x06, 0xc1 );
    FCML_A64( "phsubw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x05, 0x00 );
    FCML_A64( "phsubw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x05, 0xc1 );
    FCML_A64( "phsubd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x06, 0x00 );
    FCML_A64( "phsubd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x06, 0xc1 );
    FCML_A64( "vphsubw (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x05, 0x00 );
    FCML_A64( "vphsubw %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x05, 0xc1 );
    FCML_A64( "vphsubd (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x06, 0x00 );
    FCML_A64( "vphsubd %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x06, 0xc1 );
    FCML_A64( "vphsubw (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x05, 0x00 );
    FCML_A64( "vphsubw %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x05, 0xc1 );
    FCML_A64( "vphsubd (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x06, 0x00 );
    FCML_A64( "vphsubd %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x06, 0xc1 );
}

void fcml_tf_instruction_PHSUBSW(void) {

    FCML_I64( "phsubsw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x07, 0x00 );
    FCML_I32( "phsubsw mm0,mm1", 0x0F, 0x38, 0x07, 0xC1 );

    FCML_I64( "phsubsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x07, 0x00 );
    FCML_I32( "phsubsw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x07, 0xC1 );

    FCML_I64( "vphsubsw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x07, 0x00 );
    FCML_I32( "vphsubsw xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x07, 0xC1 );

    FCML_I64( "vphsubsw ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x07, 0x00 );
    FCML_I32( "vphsubsw ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x07, 0xC1 );

    FCML_A64( "phsubsw (%rax),%mm0", 0x0f, 0x38, 0x07, 0x00 );
    FCML_A64( "phsubsw %mm1,%mm0", 0x0f, 0x38, 0x07, 0xc1 );
    FCML_A64( "phsubsw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x07, 0x00 );
    FCML_A64( "phsubsw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x07, 0xc1 );
    FCML_A64( "vphsubsw (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x07, 0x00 );
    FCML_A64( "vphsubsw %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x07, 0xc1 );
    FCML_A64( "vphsubsw (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x07, 0x00 );
    FCML_A64( "vphsubsw %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x07, 0xc1 );
}

void fcml_tf_instruction_PINSR(void) {

    FCML_I64( "pinsrb xmm0,byte ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x20, 0x00, 0xFF );
    FCML_I32( "pinsrb xmm0,ecx,0ffh", 0x66, 0x0F, 0x3A, 0x20, 0xC1, 0xFF );

    FCML_I64( "pinsrd xmm0,dword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x22, 0x00, 0xFF );
    FCML_I32( "pinsrd xmm0,ecx,0ffh", 0x66, 0x0F, 0x3A, 0x22, 0xC1, 0xFF );

    FCML_I64( "pinsrq xmm0,qword ptr [rax],0ffh", 0x66, 0x48, 0x0F, 0x3A, 0x22, 0x00, 0xFF );

    FCML_I64_M("vpinsrb xmm0,xmm0,byte ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x20, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x20, 0x00, 0xff));
    FCML_I32_M("vpinsrb xmm0,xmm0,ecx,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x20, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x20, 0xc1, 0xff));
    FCML_I64_M("vpinsrd xmm0,xmm0,dword ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x22, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x22, 0x00, 0xff));
    FCML_I32_M("vpinsrd xmm0,xmm0,ecx,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x22, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x22, 0xc1, 0xff));
    FCML_I64_M("vpinsrq xmm0,xmm0,qword ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x08, 0x22, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0xf9, 0x22, 0x00, 0xff));

    FCML_I64_M("vpinsrb xmm0,xmm2,byte ptr [rax+0000000000000040h],0ffh", 2, FCML_MI(0x62, 0xf3, 0x6d, 0x08, 0x20, 0x40, 0x40, 0xff), FCML_MI(0xc4, 0xe3, 0x69, 0x20, 0x40, 0x40, 0xff));
    FCML_I64_M("vpinsrd xmm0,xmm2,dword ptr [rax+0000000000000040h],0ffh", 2, FCML_MI(0x62, 0xf3, 0x6d, 0x08, 0x22, 0x40, 0x10, 0xff), FCML_MI(0xc4, 0xe3, 0x69, 0x22, 0x40, 0x40, 0xff));
    FCML_I64_M("vpinsrq xmm0,xmm2,qword ptr [rax+0000000000000040h],0ffh", 2, FCML_MI(0x62, 0xf3, 0xed, 0x08, 0x22, 0x40, 0x08, 0xff), FCML_MI(0xc4, 0xe3, 0xe9, 0x22, 0x40, 0x40, 0xff));

    FCML_A64( "pinsrb $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x20, 0x00, 0xff );
    FCML_A64( "pinsrb $0xff,%ecx,%xmm0", 0x66, 0x0f, 0x3a, 0x20, 0xc1, 0xff );
    FCML_A64( "pinsrd $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x22, 0x00, 0xff );
    FCML_A64( "pinsrd $0xff,%ecx,%xmm0", 0x66, 0x0f, 0x3a, 0x22, 0xc1, 0xff );
    FCML_A64( "pinsrq $0xff,(%rax),%xmm0", 0x66, 0x48, 0x0f, 0x3a, 0x22, 0x00, 0xff );

    FCML_A64_M("vpinsrb $0xff,(%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x20, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x20, 0x00, 0xff));
    FCML_A64_M("vpinsrb $0xff,%ecx,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x20, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x20, 0xc1, 0xff));
    FCML_A64_M("vpinsrd $0xff,(%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x22, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x22, 0x00, 0xff));
    FCML_A64_M("vpinsrd $0xff,%ecx,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x22, 0xc1, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x22, 0xc1, 0xff));
    FCML_A64_M("vpinsrq $0xff,(%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x08, 0x22, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0xf9, 0x22, 0x00, 0xff));
}

void fcml_tf_instruction_PINSRW(void) {

    FCML_I64( "pinsrw mm0,word ptr [rax],0ffh", 0x0F, 0xC4, 0x00, 0xFF );
    FCML_I32( "pinsrw mm0,ecx,0ffh", 0x0F, 0xC4, 0xC1, 0xFF );

    FCML_I64( "pinsrw xmm0,word ptr [rax],0ffh", 0x66, 0x0F, 0xC4, 0x00, 0xFF );
    FCML_I32( "pinsrw xmm0,ecx,0ffh", 0x66, 0x0F, 0xC4, 0xC1, 0xFF );

    FCML_I64_D( "vpinsrw xmm0,xmm0,word ptr [rax],0ffh", 0xC4, 0xE1, 0x79, 0xC4, 0x00, 0xFF );
    FCML_I32_D( "vpinsrw xmm0,xmm0,ecx,0ffh", 0xC4, 0xE1, 0x79, 0xC4, 0xC1, 0xFF );

    FCML_A64( "pinsrw $0xff,(%rax),%mm0", 0x0f, 0xc4, 0x00, 0xff );
    FCML_A64( "pinsrw $0xff,%ecx,%mm0", 0x0f, 0xc4, 0xc1, 0xff );
    FCML_A64( "pinsrw $0xff,(%rax),%xmm0", 0x66, 0x0f, 0xc4, 0x00, 0xff );
    FCML_A64( "pinsrw $0xff,%ecx,%xmm0", 0x66, 0x0f, 0xc4, 0xc1, 0xff );

    FCML_I64_M("vpinsrw xmm0,xmm0,word ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xc4, 0x00, 0xff), FCML_MI(0xc5, 0xf9, 0xc4, 0x00, 0xff));
    FCML_I32_M("vpinsrw xmm0,xmm0,ecx,0ffh", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xc4, 0xc1, 0xff), FCML_MI(0xc5, 0xf9, 0xc4, 0xc1, 0xff));
    FCML_A64_M("vpinsrw $0xff,(%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xc4, 0x00, 0xff), FCML_MI(0xc5, 0xf9, 0xc4, 0x00, 0xff));
    FCML_A64_M("vpinsrw $0xff,%ecx,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xc4, 0xc1, 0xff), FCML_MI(0xc5, 0xf9, 0xc4, 0xc1, 0xff));

    FCML_I64_M("vpinsrw xmm0,xmm0,word ptr [rax+0000000000000040h],0ffh", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xc4, 0x40, 0x20, 0xff), FCML_MI(0xc5, 0xf9, 0xc4, 0x40, 0x40, 0xff));
    FCML_I32_M("vpinsrw xmm0,xmm0,word ptr [eax+00000040h],0ffh", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xc4, 0x40, 0x20, 0xff), FCML_MI(0xc5, 0xf9, 0xc4, 0x40, 0x40, 0xff));
}

void fcml_tf_instruction_PMADDUBSW(void) {

    FCML_I64( "pmaddubsw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x04, 0x00 );
    FCML_I32( "pmaddubsw mm0,mm1", 0x0F, 0x38, 0x04, 0xC1 );

    FCML_I64( "pmaddubsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x04, 0x00 );
    FCML_I32( "pmaddubsw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x04, 0xC1 );

    FCML_A64( "pmaddubsw (%rax),%mm0", 0x0f, 0x38, 0x04, 0x00 );
    FCML_A64( "pmaddubsw %mm1,%mm0", 0x0f, 0x38, 0x04, 0xc1 );
    FCML_A64( "pmaddubsw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x04, 0x00 );
    FCML_A64( "pmaddubsw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x04, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmaddubsw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x04, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x04, 0x38));
    FCML_I64_M("vpmaddubsw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x04, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x04, 0x38));
    FCML_A32_M("vpmaddubsw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x04, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x04, 0x38));
    FCML_I32_M("vpmaddubsw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x04, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x04, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmaddubsw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x04, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x04, 0x38));
    FCML_I64_M("vpmaddubsw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x04, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x04, 0x38));
    FCML_A32_M("vpmaddubsw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x04, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x04, 0x38));
    FCML_I32_M("vpmaddubsw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x04, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x04, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmaddubsw (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x04, 0x38);
    FCML_I64("vpmaddubsw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x04, 0x38);
    FCML_A32("vpmaddubsw (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x04, 0x38);
    FCML_I32("vpmaddubsw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x04, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmaddubsw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x04, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x04, 0xf9));
    FCML_I64_M("vpmaddubsw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x04, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x04, 0xf9));
    FCML_A32_M("vpmaddubsw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x04, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x04, 0xf9));
    FCML_I32_M("vpmaddubsw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x04, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x04, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmaddubsw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x04, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x04, 0xf6));
    FCML_I64_M("vpmaddubsw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x04, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x04, 0xf6));
    FCML_A32_M("vpmaddubsw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x04, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x04, 0xf5));
    FCML_I32_M("vpmaddubsw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x04, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x04, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmaddubsw %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x04, 0xf4);
    FCML_I64("vpmaddubsw zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x04, 0xf4);
    FCML_A32("vpmaddubsw %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x04, 0xf4);
    FCML_I32("vpmaddubsw zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x04, 0xf4);
    /* disp8 */
    FCML_I32("vpmaddubsw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x04, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaddubsw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x04, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaddubsw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x04, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaddubsw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x04, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpmaddubsw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x04, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x04, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmaddubsw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x04, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x04, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpmaddubsw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x04, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x04, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmaddubsw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x04, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x04, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmaddubsw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x04, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x04, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmaddubsw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x04, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x04, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmaddubsw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x04, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x04, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmaddubsw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x04, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x04, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpmaddubsw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x04, 0x14, 0x01);
    FCML_I64("vpmaddubsw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x04, 0x14, 0x01);
    FCML_A32("vpmaddubsw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x04, 0x14, 0x01);
    FCML_I32("vpmaddubsw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x04, 0x14, 0x01);
    FCML_A64("vpmaddubsw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x04, 0x14, 0x01);
    FCML_I64("vpmaddubsw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x04, 0x14, 0x01);
    FCML_A32("vpmaddubsw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x04, 0x14, 0x01);
    FCML_I32("vpmaddubsw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x04, 0x14, 0x01);
    FCML_A64("vpmaddubsw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x04, 0x14, 0x01);
    FCML_I64("vpmaddubsw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x04, 0x14, 0x01);
    FCML_A32("vpmaddubsw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x04, 0x14, 0x01);
    FCML_I32("vpmaddubsw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x04, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmaddubsw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x04, 0x14, 0x01);
    FCML_I64("vpmaddubsw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x04, 0x14, 0x01);
    FCML_A32("vpmaddubsw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x04, 0x14, 0x01);
    FCML_I32("vpmaddubsw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x04, 0x14, 0x01);
    FCML_A64("vpmaddubsw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x04, 0x14, 0x01);
    FCML_I64("vpmaddubsw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x04, 0x14, 0x01);
    FCML_A32("vpmaddubsw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x04, 0x14, 0x01);
    FCML_I32("vpmaddubsw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x04, 0x14, 0x01);
    FCML_A64("vpmaddubsw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x04, 0x14, 0x01);
    FCML_I64("vpmaddubsw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x04, 0x14, 0x01);
    FCML_A32("vpmaddubsw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x04, 0x14, 0x01);
    FCML_I32("vpmaddubsw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x04, 0x14, 0x01);
}

void fcml_tf_instruction_PMADDWD(void) {

    FCML_I64( "pmaddwd mm0,mmword ptr [rax]", 0x0F, 0xF5, 0x00 );
    FCML_I32( "pmaddwd mm0,mm1", 0x0F, 0xF5, 0xC1 );
    FCML_I64( "pmaddwd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF5, 0x00 );
    FCML_I32( "pmaddwd xmm0,xmm1", 0x66, 0x0F, 0xF5, 0xC1 );
    FCML_A64( "pmaddwd (%rax),%mm0", 0x0f, 0xf5, 0x00 );
    FCML_A64( "pmaddwd %mm1,%mm0", 0x0f, 0xf5, 0xc1 );
    FCML_A64( "pmaddwd (%rax),%xmm0", 0x66, 0x0f, 0xf5, 0x00 );
    FCML_A64( "pmaddwd %xmm1,%xmm0", 0x66, 0x0f, 0xf5, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmaddwd (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf5, 0x38), FCML_MI(0xc5, 0x41, 0xf5, 0x38));
    FCML_I64_M("vpmaddwd xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf5, 0x38), FCML_MI(0xc5, 0x41, 0xf5, 0x38));
    FCML_A32_M("vpmaddwd (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xf5, 0x38), FCML_MI(0xc5, 0xc9, 0xf5, 0x38));
    FCML_I32_M("vpmaddwd xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xf5, 0x38), FCML_MI(0xc5, 0xc9, 0xf5, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmaddwd (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf5, 0x38), FCML_MI(0xc5, 0x45, 0xf5, 0x38));
    FCML_I64_M("vpmaddwd ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf5, 0x38), FCML_MI(0xc5, 0x45, 0xf5, 0x38));
    FCML_A32_M("vpmaddwd (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xf5, 0x38), FCML_MI(0xc5, 0xd5, 0xf5, 0x38));
    FCML_I32_M("vpmaddwd ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xf5, 0x38), FCML_MI(0xc5, 0xd5, 0xf5, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmaddwd (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xf5, 0x38);
    FCML_I64("vpmaddwd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xf5, 0x38);
    FCML_A32("vpmaddwd (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xf5, 0x38);
    FCML_I32("vpmaddwd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xf5, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmaddwd %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf5, 0xf9), FCML_MI(0xc5, 0x41, 0xf5, 0xf9));
    FCML_I64_M("vpmaddwd xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf5, 0xf9), FCML_MI(0xc5, 0x41, 0xf5, 0xf9));
    FCML_A32_M("vpmaddwd %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf5, 0xf9), FCML_MI(0xc5, 0xe9, 0xf5, 0xf9));
    FCML_I32_M("vpmaddwd xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf5, 0xf9), FCML_MI(0xc5, 0xe9, 0xf5, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmaddwd %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf5, 0xf6), FCML_MI(0xc5, 0x45, 0xf5, 0xf6));
    FCML_I64_M("vpmaddwd ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf5, 0xf6), FCML_MI(0xc5, 0x45, 0xf5, 0xf6));
    FCML_A32_M("vpmaddwd %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xf5, 0xf5), FCML_MI(0xc5, 0xe5, 0xf5, 0xf5));
    FCML_I32_M("vpmaddwd ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xf5, 0xf5), FCML_MI(0xc5, 0xe5, 0xf5, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmaddwd %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xf5, 0xf4);
    FCML_I64("vpmaddwd zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xf5, 0xf4);
    FCML_A32("vpmaddwd %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xf5, 0xf4);
    FCML_I32("vpmaddwd zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xf5, 0xf4);
    /* disp8 */
    FCML_I32("vpmaddwd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xf5, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaddwd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xf5, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaddwd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xf5, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaddwd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xf5, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpmaddwd ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf5, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmaddwd 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf5, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpmaddwd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf5, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmaddwd 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf5, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmaddwd xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf5, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmaddwd 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf5, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmaddwd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf5, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmaddwd 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf5, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpmaddwd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xf5, 0x14, 0x01);
    FCML_I64("vpmaddwd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xf5, 0x14, 0x01);
    FCML_A32("vpmaddwd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xf5, 0x14, 0x01);
    FCML_I32("vpmaddwd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xf5, 0x14, 0x01);
    FCML_A64("vpmaddwd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xf5, 0x14, 0x01);
    FCML_I64("vpmaddwd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xf5, 0x14, 0x01);
    FCML_A32("vpmaddwd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xf5, 0x14, 0x01);
    FCML_I32("vpmaddwd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xf5, 0x14, 0x01);
    FCML_A64("vpmaddwd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xf5, 0x14, 0x01);
    FCML_I64("vpmaddwd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xf5, 0x14, 0x01);
    FCML_A32("vpmaddwd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xf5, 0x14, 0x01);
    FCML_I32("vpmaddwd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xf5, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmaddwd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xf5, 0x14, 0x01);
    FCML_I64("vpmaddwd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xf5, 0x14, 0x01);
    FCML_A32("vpmaddwd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xf5, 0x14, 0x01);
    FCML_I32("vpmaddwd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xf5, 0x14, 0x01);
    FCML_A64("vpmaddwd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xf5, 0x14, 0x01);
    FCML_I64("vpmaddwd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xf5, 0x14, 0x01);
    FCML_A32("vpmaddwd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xf5, 0x14, 0x01);
    FCML_I32("vpmaddwd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xf5, 0x14, 0x01);
    FCML_A64("vpmaddwd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xf5, 0x14, 0x01);
    FCML_I64("vpmaddwd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xf5, 0x14, 0x01);
    FCML_A32("vpmaddwd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xf5, 0x14, 0x01);
    FCML_I32("vpmaddwd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xf5, 0x14, 0x01);
}

void fcml_tf_instruction_PMAXSB(void) {

    FCML_I64( "pmaxsb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x3C, 0x00 );
    FCML_I32( "pmaxsb xmm0,xmm1", 0x66, 0x0F, 0x38, 0x3C, 0xC1 );
    FCML_A64( "pmaxsb (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x3c, 0x00 );
    FCML_A64( "pmaxsb %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x3c, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmaxsb (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3c, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x3c, 0x38));
    FCML_I64_M("vpmaxsb xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3c, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x3c, 0x38));
    FCML_A32_M("vpmaxsb (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x3c, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x3c, 0x38));
    FCML_I32_M("vpmaxsb xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x3c, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x3c, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmaxsb (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3c, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x3c, 0x38));
    FCML_I64_M("vpmaxsb ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3c, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x3c, 0x38));
    FCML_A32_M("vpmaxsb (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x3c, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x3c, 0x38));
    FCML_I32_M("vpmaxsb ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x3c, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x3c, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmaxsb (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x3c, 0x38);
    FCML_I64("vpmaxsb zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x3c, 0x38);
    FCML_A32("vpmaxsb (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x3c, 0x38);
    FCML_I32("vpmaxsb zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x3c, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmaxsb %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3c, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x3c, 0xf9));
    FCML_I64_M("vpmaxsb xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3c, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x3c, 0xf9));
    FCML_A32_M("vpmaxsb %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3c, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x3c, 0xf9));
    FCML_I32_M("vpmaxsb xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3c, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x3c, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmaxsb %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3c, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x3c, 0xf6));
    FCML_I64_M("vpmaxsb ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3c, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x3c, 0xf6));
    FCML_A32_M("vpmaxsb %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x3c, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x3c, 0xf5));
    FCML_I32_M("vpmaxsb ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x3c, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x3c, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmaxsb %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x3c, 0xf4);
    FCML_I64("vpmaxsb zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x3c, 0xf4);
    FCML_A32("vpmaxsb %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x3c, 0xf4);
    FCML_I32("vpmaxsb zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x3c, 0xf4);
    /* disp8 */
    FCML_I32("vpmaxsb zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x3c, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxsb 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x3c, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxsb zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x3c, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxsb 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x3c, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpmaxsb ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3c, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmaxsb 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3c, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpmaxsb ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3c, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmaxsb 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3c, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmaxsb xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3c, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmaxsb 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3c, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmaxsb xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3c, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmaxsb 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3c, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpmaxsb (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x3c, 0x14, 0x01);
    FCML_I64("vpmaxsb xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x3c, 0x14, 0x01);
    FCML_A32("vpmaxsb (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x3c, 0x14, 0x01);
    FCML_I32("vpmaxsb xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x3c, 0x14, 0x01);
    FCML_A64("vpmaxsb (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x3c, 0x14, 0x01);
    FCML_I64("vpmaxsb ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x3c, 0x14, 0x01);
    FCML_A32("vpmaxsb (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x3c, 0x14, 0x01);
    FCML_I32("vpmaxsb ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x3c, 0x14, 0x01);
    FCML_A64("vpmaxsb (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x3c, 0x14, 0x01);
    FCML_I64("vpmaxsb zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x3c, 0x14, 0x01);
    FCML_A32("vpmaxsb (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x3c, 0x14, 0x01);
    FCML_I32("vpmaxsb zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x3c, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmaxsb (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x3c, 0x14, 0x01);
    FCML_I64("vpmaxsb xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x3c, 0x14, 0x01);
    FCML_A32("vpmaxsb (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x3c, 0x14, 0x01);
    FCML_I32("vpmaxsb xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x3c, 0x14, 0x01);
    FCML_A64("vpmaxsb (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x3c, 0x14, 0x01);
    FCML_I64("vpmaxsb ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x3c, 0x14, 0x01);
    FCML_A32("vpmaxsb (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x3c, 0x14, 0x01);
    FCML_I32("vpmaxsb ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x3c, 0x14, 0x01);
    FCML_A64("vpmaxsb (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x3c, 0x14, 0x01);
    FCML_I64("vpmaxsb zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x3c, 0x14, 0x01);
    FCML_A32("vpmaxsb (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x3c, 0x14, 0x01);
    FCML_I32("vpmaxsb zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x3c, 0x14, 0x01);
}

void fcml_tf_instruction_PMAXSD(void) {

    FCML_I64( "pmaxsd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x3D, 0x00 );
    FCML_I32( "pmaxsd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x3D, 0xC1 );
    FCML_A64( "pmaxsd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x3d, 0x00 );
    FCML_A64( "pmaxsd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x3d, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmaxsd (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3d, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x3d, 0x38));
    FCML_I64_M("vpmaxsd xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3d, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x3d, 0x38));
    FCML_A32_M("vpmaxsd (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x3d, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x3d, 0x38));
    FCML_I32_M("vpmaxsd xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x3d, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x3d, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmaxsd (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3d, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x3d, 0x38));
    FCML_I64_M("vpmaxsd ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3d, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x3d, 0x38));
    FCML_A32_M("vpmaxsd (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x3d, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x3d, 0x38));
    FCML_I32_M("vpmaxsd ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x3d, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x3d, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmaxsd (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x3d, 0x38);
    FCML_I64("vpmaxsd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x3d, 0x38);
    FCML_A32("vpmaxsd (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x3d, 0x38);
    FCML_I32("vpmaxsd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x3d, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmaxsd %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3d, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x3d, 0xf9));
    FCML_I64_M("vpmaxsd xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3d, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x3d, 0xf9));
    FCML_A32_M("vpmaxsd %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3d, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x3d, 0xf9));
    FCML_I32_M("vpmaxsd xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3d, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x3d, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmaxsd %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3d, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x3d, 0xf6));
    FCML_I64_M("vpmaxsd ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3d, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x3d, 0xf6));
    FCML_A32_M("vpmaxsd %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x3d, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x3d, 0xf5));
    FCML_I32_M("vpmaxsd ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x3d, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x3d, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmaxsd %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x3d, 0xf4);
    FCML_I64("vpmaxsd zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x3d, 0xf4);
    FCML_A32("vpmaxsd %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x3d, 0xf4);
    FCML_I32("vpmaxsd zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x3d, 0xf4);
    /* disp8 */
    FCML_I32("vpmaxsd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxsd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxsd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxsd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpmaxsd ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3d, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmaxsd 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3d, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpmaxsd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3d, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmaxsd 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3d, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmaxsd xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3d, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmaxsd 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3d, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmaxsd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3d, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmaxsd 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3d, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpmaxsd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x3d, 0x14, 0x01);
    FCML_I64("vpmaxsd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x3d, 0x14, 0x01);
    FCML_A32("vpmaxsd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x3d, 0x14, 0x01);
    FCML_I32("vpmaxsd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x3d, 0x14, 0x01);
    FCML_A64("vpmaxsd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x3d, 0x14, 0x01);
    FCML_I64("vpmaxsd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x3d, 0x14, 0x01);
    FCML_A32("vpmaxsd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x3d, 0x14, 0x01);
    FCML_I32("vpmaxsd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x3d, 0x14, 0x01);
    FCML_A64("vpmaxsd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x3d, 0x14, 0x01);
    FCML_I64("vpmaxsd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x3d, 0x14, 0x01);
    FCML_A32("vpmaxsd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x3d, 0x14, 0x01);
    FCML_I32("vpmaxsd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x3d, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmaxsd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x3d, 0x14, 0x01);
    FCML_I64("vpmaxsd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x3d, 0x14, 0x01);
    FCML_A32("vpmaxsd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x3d, 0x14, 0x01);
    FCML_I32("vpmaxsd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x3d, 0x14, 0x01);
    FCML_A64("vpmaxsd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x3d, 0x14, 0x01);
    FCML_I64("vpmaxsd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x3d, 0x14, 0x01);
    FCML_A32("vpmaxsd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x3d, 0x14, 0x01);
    FCML_I32("vpmaxsd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x3d, 0x14, 0x01);
    FCML_A64("vpmaxsd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x3d, 0x14, 0x01);
    FCML_I64("vpmaxsd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x3d, 0x14, 0x01);
    FCML_A32("vpmaxsd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x3d, 0x14, 0x01);
    FCML_I32("vpmaxsd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x3d, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpmaxsd zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x3d, 0x3e);
    FCML_A64("vpmaxsd (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x3d, 0x3e);
    FCML_I64("vpmaxsd ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x3d, 0x3e);
    FCML_A64("vpmaxsd (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x3d, 0x3e);
    FCML_I64("vpmaxsd xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x3d, 0x3e);
    FCML_A64("vpmaxsd (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x3d, 0x3e);
    FCML_A32("vpmaxsd (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x3d, 0x0e);
    FCML_I32("vpmaxsd zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x3d, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpmaxsd (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x3d, 0x3e);
    FCML_I64("vpmaxsd ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x3d, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpmaxsd zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxsd 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxsd zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxsd 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I32("vpmaxsd ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxsd 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxsd ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxsd 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I32("vpmaxsd xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxsd 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxsd xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxsd 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x3d, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PMAXSQ(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpmaxsq (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x3d, 0x38);
    FCML_I64("vpmaxsq xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x3d, 0x38);
    FCML_A32("vpmaxsq (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x3d, 0x38);
    FCML_I32("vpmaxsq xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x3d, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpmaxsq (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x3d, 0x38);
    FCML_I64("vpmaxsq ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x3d, 0x38);
    FCML_A32("vpmaxsq (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x3d, 0x38);
    FCML_I32("vpmaxsq ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x3d, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmaxsq (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x3d, 0x38);
    FCML_I64("vpmaxsq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x3d, 0x38);
    FCML_A32("vpmaxsq (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x3d, 0x38);
    FCML_I32("vpmaxsq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x3d, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpmaxsq %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x3d, 0xf9);
    FCML_I64("vpmaxsq xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x3d, 0xf9);
    FCML_A32("vpmaxsq %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x3d, 0xf9);
    FCML_I32("vpmaxsq xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x3d, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpmaxsq %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x3d, 0xf6);
    FCML_I64("vpmaxsq ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x3d, 0xf6);
    FCML_A32("vpmaxsq %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x3d, 0xf5);
    FCML_I32("vpmaxsq ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x3d, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmaxsq %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x3d, 0xf4);
    FCML_I64("vpmaxsq zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x3d, 0xf4);
    FCML_A32("vpmaxsq %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x3d, 0xf4);
    FCML_I32("vpmaxsq zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x3d, 0xf4);
    /* disp8 */
    FCML_I32("vpmaxsq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxsq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxsq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxsq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I32("vpmaxsq ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxsq 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxsq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxsq 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I32("vpmaxsq xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxsq 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxsq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxsq 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x3d, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpmaxsq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x3d, 0x14, 0x01);
    FCML_I64("vpmaxsq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x3d, 0x14, 0x01);
    FCML_A32("vpmaxsq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x3d, 0x14, 0x01);
    FCML_I32("vpmaxsq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x3d, 0x14, 0x01);
    FCML_A64("vpmaxsq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x3d, 0x14, 0x01);
    FCML_I64("vpmaxsq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x3d, 0x14, 0x01);
    FCML_A32("vpmaxsq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x3d, 0x14, 0x01);
    FCML_I32("vpmaxsq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x3d, 0x14, 0x01);
    FCML_A64("vpmaxsq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x3d, 0x14, 0x01);
    FCML_I64("vpmaxsq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x3d, 0x14, 0x01);
    FCML_A32("vpmaxsq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x3d, 0x14, 0x01);
    FCML_I32("vpmaxsq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x3d, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmaxsq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x3d, 0x14, 0x01);
    FCML_I64("vpmaxsq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x3d, 0x14, 0x01);
    FCML_A32("vpmaxsq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x3d, 0x14, 0x01);
    FCML_I32("vpmaxsq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x3d, 0x14, 0x01);
    FCML_A64("vpmaxsq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x3d, 0x14, 0x01);
    FCML_I64("vpmaxsq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x3d, 0x14, 0x01);
    FCML_A32("vpmaxsq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x3d, 0x14, 0x01);
    FCML_I32("vpmaxsq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x3d, 0x14, 0x01);
    FCML_A64("vpmaxsq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x3d, 0x14, 0x01);
    FCML_I64("vpmaxsq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x3d, 0x14, 0x01);
    FCML_A32("vpmaxsq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x3d, 0x14, 0x01);
    FCML_I32("vpmaxsq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x3d, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpmaxsq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x3d, 0x3e);
    FCML_A64("vpmaxsq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x3d, 0x3e);
    FCML_I64("vpmaxsq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x3d, 0x3e);
    FCML_A64("vpmaxsq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x3d, 0x3e);
    FCML_I64("vpmaxsq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x3d, 0x3e);
    FCML_A64("vpmaxsq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x3d, 0x3e);
    FCML_A32("vpmaxsq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x3d, 0x0e);
    FCML_I32("vpmaxsq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x3d, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpmaxsq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x3d, 0x3e);
    FCML_I64("vpmaxsq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x3d, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpmaxsq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxsq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxsq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxsq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I32("vpmaxsq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxsq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxsq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxsq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I32("vpmaxsq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxsq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x3d, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxsq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x3d, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxsq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x3d, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PMAXSW(void) {

    FCML_I64( "pmaxsw mm0,mmword ptr [rax]", 0x0F, 0xEE, 0x00 );
    FCML_I32( "pmaxsw mm0,mm1", 0x0F, 0xEE, 0xC1 );
    FCML_I64( "pmaxsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xEE, 0x00 );
    FCML_I32( "pmaxsw xmm0,xmm1", 0x66, 0x0F, 0xEE, 0xC1 );
    FCML_A64( "pmaxsw (%rax),%mm0", 0x0f, 0xee, 0x00 );
    FCML_A64( "pmaxsw %mm1,%mm0", 0x0f, 0xee, 0xc1 );
    FCML_A64( "pmaxsw (%rax),%xmm0", 0x66, 0x0f, 0xee, 0x00 );
    FCML_A64( "pmaxsw %xmm1,%xmm0", 0x66, 0x0f, 0xee, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmaxsw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xee, 0x38), FCML_MI(0xc5, 0x41, 0xee, 0x38));
    FCML_I64_M("vpmaxsw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xee, 0x38), FCML_MI(0xc5, 0x41, 0xee, 0x38));
    FCML_A32_M("vpmaxsw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xee, 0x38), FCML_MI(0xc5, 0xc9, 0xee, 0x38));
    FCML_I32_M("vpmaxsw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xee, 0x38), FCML_MI(0xc5, 0xc9, 0xee, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmaxsw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xee, 0x38), FCML_MI(0xc5, 0x45, 0xee, 0x38));
    FCML_I64_M("vpmaxsw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xee, 0x38), FCML_MI(0xc5, 0x45, 0xee, 0x38));
    FCML_A32_M("vpmaxsw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xee, 0x38), FCML_MI(0xc5, 0xd5, 0xee, 0x38));
    FCML_I32_M("vpmaxsw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xee, 0x38), FCML_MI(0xc5, 0xd5, 0xee, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmaxsw (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xee, 0x38);
    FCML_I64("vpmaxsw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xee, 0x38);
    FCML_A32("vpmaxsw (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xee, 0x38);
    FCML_I32("vpmaxsw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xee, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmaxsw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xee, 0xf9), FCML_MI(0xc5, 0x41, 0xee, 0xf9));
    FCML_I64_M("vpmaxsw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xee, 0xf9), FCML_MI(0xc5, 0x41, 0xee, 0xf9));
    FCML_A32_M("vpmaxsw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xee, 0xf9), FCML_MI(0xc5, 0xe9, 0xee, 0xf9));
    FCML_I32_M("vpmaxsw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xee, 0xf9), FCML_MI(0xc5, 0xe9, 0xee, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmaxsw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xee, 0xf6), FCML_MI(0xc5, 0x45, 0xee, 0xf6));
    FCML_I64_M("vpmaxsw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xee, 0xf6), FCML_MI(0xc5, 0x45, 0xee, 0xf6));
    FCML_A32_M("vpmaxsw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xee, 0xf5), FCML_MI(0xc5, 0xe5, 0xee, 0xf5));
    FCML_I32_M("vpmaxsw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xee, 0xf5), FCML_MI(0xc5, 0xe5, 0xee, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmaxsw %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xee, 0xf4);
    FCML_I64("vpmaxsw zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xee, 0xf4);
    FCML_A32("vpmaxsw %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xee, 0xf4);
    FCML_I32("vpmaxsw zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xee, 0xf4);
    /* disp8 */
    FCML_I32("vpmaxsw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xee, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxsw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xee, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxsw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xee, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxsw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xee, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpmaxsw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xee, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xee, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmaxsw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xee, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xee, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpmaxsw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xee, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xee, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmaxsw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xee, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xee, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmaxsw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xee, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xee, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmaxsw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xee, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xee, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmaxsw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xee, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xee, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmaxsw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xee, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xee, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpmaxsw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xee, 0x14, 0x01);
    FCML_I64("vpmaxsw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xee, 0x14, 0x01);
    FCML_A32("vpmaxsw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xee, 0x14, 0x01);
    FCML_I32("vpmaxsw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xee, 0x14, 0x01);
    FCML_A64("vpmaxsw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xee, 0x14, 0x01);
    FCML_I64("vpmaxsw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xee, 0x14, 0x01);
    FCML_A32("vpmaxsw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xee, 0x14, 0x01);
    FCML_I32("vpmaxsw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xee, 0x14, 0x01);
    FCML_A64("vpmaxsw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xee, 0x14, 0x01);
    FCML_I64("vpmaxsw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xee, 0x14, 0x01);
    FCML_A32("vpmaxsw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xee, 0x14, 0x01);
    FCML_I32("vpmaxsw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xee, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmaxsw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xee, 0x14, 0x01);
    FCML_I64("vpmaxsw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xee, 0x14, 0x01);
    FCML_A32("vpmaxsw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xee, 0x14, 0x01);
    FCML_I32("vpmaxsw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xee, 0x14, 0x01);
    FCML_A64("vpmaxsw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xee, 0x14, 0x01);
    FCML_I64("vpmaxsw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xee, 0x14, 0x01);
    FCML_A32("vpmaxsw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xee, 0x14, 0x01);
    FCML_I32("vpmaxsw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xee, 0x14, 0x01);
    FCML_A64("vpmaxsw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xee, 0x14, 0x01);
    FCML_I64("vpmaxsw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xee, 0x14, 0x01);
    FCML_A32("vpmaxsw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xee, 0x14, 0x01);
    FCML_I32("vpmaxsw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xee, 0x14, 0x01);
}

void fcml_tf_instruction_PMAXUB(void) {

    FCML_I64( "pmaxub mm0,mmword ptr [rax]", 0x0F, 0xDE, 0x00 );
    FCML_I32( "pmaxub mm0,mm1", 0x0F, 0xDE, 0xC1 );
    FCML_I64( "pmaxub xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xDE, 0x00 );
    FCML_I32( "pmaxub xmm0,xmm1", 0x66, 0x0F, 0xDE, 0xC1 );
    FCML_A64( "pmaxub (%rax),%mm0", 0x0f, 0xde, 0x00 );
    FCML_A64( "pmaxub %mm1,%mm0", 0x0f, 0xde, 0xc1 );
    FCML_A64( "pmaxub (%rax),%xmm0", 0x66, 0x0f, 0xde, 0x00 );
    FCML_A64( "pmaxub %xmm1,%xmm0", 0x66, 0x0f, 0xde, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmaxub (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xde, 0x38), FCML_MI(0xc5, 0x41, 0xde, 0x38));
    FCML_I64_M("vpmaxub xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xde, 0x38), FCML_MI(0xc5, 0x41, 0xde, 0x38));
    FCML_A32_M("vpmaxub (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xde, 0x38), FCML_MI(0xc5, 0xc9, 0xde, 0x38));
    FCML_I32_M("vpmaxub xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xde, 0x38), FCML_MI(0xc5, 0xc9, 0xde, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmaxub (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xde, 0x38), FCML_MI(0xc5, 0x45, 0xde, 0x38));
    FCML_I64_M("vpmaxub ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xde, 0x38), FCML_MI(0xc5, 0x45, 0xde, 0x38));
    FCML_A32_M("vpmaxub (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xde, 0x38), FCML_MI(0xc5, 0xd5, 0xde, 0x38));
    FCML_I32_M("vpmaxub ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xde, 0x38), FCML_MI(0xc5, 0xd5, 0xde, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmaxub (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xde, 0x38);
    FCML_I64("vpmaxub zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xde, 0x38);
    FCML_A32("vpmaxub (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xde, 0x38);
    FCML_I32("vpmaxub zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xde, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmaxub %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xde, 0xf9), FCML_MI(0xc5, 0x41, 0xde, 0xf9));
    FCML_I64_M("vpmaxub xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xde, 0xf9), FCML_MI(0xc5, 0x41, 0xde, 0xf9));
    FCML_A32_M("vpmaxub %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xde, 0xf9), FCML_MI(0xc5, 0xe9, 0xde, 0xf9));
    FCML_I32_M("vpmaxub xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xde, 0xf9), FCML_MI(0xc5, 0xe9, 0xde, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmaxub %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xde, 0xf6), FCML_MI(0xc5, 0x45, 0xde, 0xf6));
    FCML_I64_M("vpmaxub ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xde, 0xf6), FCML_MI(0xc5, 0x45, 0xde, 0xf6));
    FCML_A32_M("vpmaxub %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xde, 0xf5), FCML_MI(0xc5, 0xe5, 0xde, 0xf5));
    FCML_I32_M("vpmaxub ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xde, 0xf5), FCML_MI(0xc5, 0xe5, 0xde, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmaxub %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xde, 0xf4);
    FCML_I64("vpmaxub zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xde, 0xf4);
    FCML_A32("vpmaxub %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xde, 0xf4);
    FCML_I32("vpmaxub zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xde, 0xf4);
    /* disp8 */
    FCML_I32("vpmaxub zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xde, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxub 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xde, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxub zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xde, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxub 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xde, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpmaxub ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xde, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xde, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmaxub 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xde, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xde, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmaxub 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xde, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xde, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmaxub xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xde, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xde, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmaxub 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xde, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xde, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmaxub xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xde, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xde, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmaxub 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xde, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xde, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpmaxub (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xde, 0x14, 0x01);
    FCML_I64("vpmaxub xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xde, 0x14, 0x01);
    FCML_A32("vpmaxub (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xde, 0x14, 0x01);
    FCML_I32("vpmaxub xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xde, 0x14, 0x01);
    FCML_A64("vpmaxub (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xde, 0x14, 0x01);
    FCML_I64("vpmaxub ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xde, 0x14, 0x01);
    FCML_A32("vpmaxub (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xde, 0x14, 0x01);
    FCML_I32("vpmaxub ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xde, 0x14, 0x01);
    FCML_A64("vpmaxub (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xde, 0x14, 0x01);
    FCML_I64("vpmaxub zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xde, 0x14, 0x01);
    FCML_A32("vpmaxub (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xde, 0x14, 0x01);
    FCML_I32("vpmaxub zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xde, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmaxub (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xde, 0x14, 0x01);
    FCML_I64("vpmaxub xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xde, 0x14, 0x01);
    FCML_A32("vpmaxub (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xde, 0x14, 0x01);
    FCML_I32("vpmaxub xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xde, 0x14, 0x01);
    FCML_A64("vpmaxub (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xde, 0x14, 0x01);
    FCML_I64("vpmaxub ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xde, 0x14, 0x01);
    FCML_A32("vpmaxub (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xde, 0x14, 0x01);
    FCML_I32("vpmaxub ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xde, 0x14, 0x01);
    FCML_A64("vpmaxub (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xde, 0x14, 0x01);
    FCML_I64("vpmaxub zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xde, 0x14, 0x01);
    FCML_A32("vpmaxub (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xde, 0x14, 0x01);
    FCML_I32("vpmaxub zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xde, 0x14, 0x01);
}

void fcml_tf_instruction_PMAXUD(void) {

    FCML_I64( "pmaxud xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x3F, 0x00 );
    FCML_I32( "pmaxud xmm0,xmm1", 0x66, 0x0F, 0x38, 0x3F, 0xC1 );
    FCML_A64( "pmaxud (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x3f, 0x00 );
    FCML_A64( "pmaxud %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x3f, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmaxud (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3f, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x3f, 0x38));
    FCML_I64_M("vpmaxud xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3f, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x3f, 0x38));
    FCML_A32_M("vpmaxud (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x3f, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x3f, 0x38));
    FCML_I32_M("vpmaxud xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x3f, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x3f, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmaxud (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3f, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x3f, 0x38));
    FCML_I64_M("vpmaxud ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3f, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x3f, 0x38));
    FCML_A32_M("vpmaxud (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x3f, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x3f, 0x38));
    FCML_I32_M("vpmaxud ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x3f, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x3f, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmaxud (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x3f, 0x38);
    FCML_I64("vpmaxud zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x3f, 0x38);
    FCML_A32("vpmaxud (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x3f, 0x38);
    FCML_I32("vpmaxud zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x3f, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmaxud %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3f, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x3f, 0xf9));
    FCML_I64_M("vpmaxud xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3f, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x3f, 0xf9));
    FCML_A32_M("vpmaxud %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3f, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x3f, 0xf9));
    FCML_I32_M("vpmaxud xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3f, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x3f, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmaxud %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3f, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x3f, 0xf6));
    FCML_I64_M("vpmaxud ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3f, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x3f, 0xf6));
    FCML_A32_M("vpmaxud %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x3f, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x3f, 0xf5));
    FCML_I32_M("vpmaxud ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x3f, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x3f, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmaxud %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x3f, 0xf4);
    FCML_I64("vpmaxud zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x3f, 0xf4);
    FCML_A32("vpmaxud %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x3f, 0xf4);
    FCML_I32("vpmaxud zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x3f, 0xf4);
    /* disp8 */
    FCML_I32("vpmaxud zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxud 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxud zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxud 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpmaxud ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3f, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3f, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmaxud 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3f, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3f, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpmaxud ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3f, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3f, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmaxud 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3f, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3f, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmaxud xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3f, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3f, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmaxud 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3f, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3f, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmaxud xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3f, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3f, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmaxud 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3f, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3f, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpmaxud (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x3f, 0x14, 0x01);
    FCML_I64("vpmaxud xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x3f, 0x14, 0x01);
    FCML_A32("vpmaxud (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x3f, 0x14, 0x01);
    FCML_I32("vpmaxud xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x3f, 0x14, 0x01);
    FCML_A64("vpmaxud (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x3f, 0x14, 0x01);
    FCML_I64("vpmaxud ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x3f, 0x14, 0x01);
    FCML_A32("vpmaxud (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x3f, 0x14, 0x01);
    FCML_I32("vpmaxud ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x3f, 0x14, 0x01);
    FCML_A64("vpmaxud (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x3f, 0x14, 0x01);
    FCML_I64("vpmaxud zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x3f, 0x14, 0x01);
    FCML_A32("vpmaxud (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x3f, 0x14, 0x01);
    FCML_I32("vpmaxud zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x3f, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmaxud (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x3f, 0x14, 0x01);
    FCML_I64("vpmaxud xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x3f, 0x14, 0x01);
    FCML_A32("vpmaxud (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x3f, 0x14, 0x01);
    FCML_I32("vpmaxud xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x3f, 0x14, 0x01);
    FCML_A64("vpmaxud (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x3f, 0x14, 0x01);
    FCML_I64("vpmaxud ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x3f, 0x14, 0x01);
    FCML_A32("vpmaxud (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x3f, 0x14, 0x01);
    FCML_I32("vpmaxud ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x3f, 0x14, 0x01);
    FCML_A64("vpmaxud (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x3f, 0x14, 0x01);
    FCML_I64("vpmaxud zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x3f, 0x14, 0x01);
    FCML_A32("vpmaxud (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x3f, 0x14, 0x01);
    FCML_I32("vpmaxud zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x3f, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpmaxud zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x3f, 0x3e);
    FCML_A64("vpmaxud (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x3f, 0x3e);
    FCML_I64("vpmaxud ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x3f, 0x3e);
    FCML_A64("vpmaxud (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x3f, 0x3e);
    FCML_I64("vpmaxud xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x3f, 0x3e);
    FCML_A64("vpmaxud (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x3f, 0x3e);
    FCML_A32("vpmaxud (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x3f, 0x0e);
    FCML_I32("vpmaxud zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x3f, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpmaxud (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x3f, 0x3e);
    FCML_I64("vpmaxud ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x3f, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpmaxud zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxud 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxud zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxud 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I32("vpmaxud ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxud 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxud ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxud 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I32("vpmaxud xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxud 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxud xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxud 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x3f, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PMAXUQ(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpmaxuq (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x3f, 0x38);
    FCML_I64("vpmaxuq xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x3f, 0x38);
    FCML_A32("vpmaxuq (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x3f, 0x38);
    FCML_I32("vpmaxuq xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x3f, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpmaxuq (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x3f, 0x38);
    FCML_I64("vpmaxuq ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x3f, 0x38);
    FCML_A32("vpmaxuq (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x3f, 0x38);
    FCML_I32("vpmaxuq ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x3f, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmaxuq (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x3f, 0x38);
    FCML_I64("vpmaxuq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x3f, 0x38);
    FCML_A32("vpmaxuq (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x3f, 0x38);
    FCML_I32("vpmaxuq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x3f, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpmaxuq %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x3f, 0xf9);
    FCML_I64("vpmaxuq xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x3f, 0xf9);
    FCML_A32("vpmaxuq %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x3f, 0xf9);
    FCML_I32("vpmaxuq xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x3f, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpmaxuq %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x3f, 0xf6);
    FCML_I64("vpmaxuq ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x3f, 0xf6);
    FCML_A32("vpmaxuq %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x3f, 0xf5);
    FCML_I32("vpmaxuq ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x3f, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmaxuq %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x3f, 0xf4);
    FCML_I64("vpmaxuq zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x3f, 0xf4);
    FCML_A32("vpmaxuq %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x3f, 0xf4);
    FCML_I32("vpmaxuq zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x3f, 0xf4);
    /* disp8 */
    FCML_I32("vpmaxuq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxuq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxuq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxuq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I32("vpmaxuq ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxuq 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxuq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxuq 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I32("vpmaxuq xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxuq 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxuq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxuq 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x3f, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpmaxuq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x3f, 0x14, 0x01);
    FCML_I64("vpmaxuq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x3f, 0x14, 0x01);
    FCML_A32("vpmaxuq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x3f, 0x14, 0x01);
    FCML_I32("vpmaxuq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x3f, 0x14, 0x01);
    FCML_A64("vpmaxuq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x3f, 0x14, 0x01);
    FCML_I64("vpmaxuq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x3f, 0x14, 0x01);
    FCML_A32("vpmaxuq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x3f, 0x14, 0x01);
    FCML_I32("vpmaxuq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x3f, 0x14, 0x01);
    FCML_A64("vpmaxuq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x3f, 0x14, 0x01);
    FCML_I64("vpmaxuq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x3f, 0x14, 0x01);
    FCML_A32("vpmaxuq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x3f, 0x14, 0x01);
    FCML_I32("vpmaxuq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x3f, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmaxuq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x3f, 0x14, 0x01);
    FCML_I64("vpmaxuq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x3f, 0x14, 0x01);
    FCML_A32("vpmaxuq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x3f, 0x14, 0x01);
    FCML_I32("vpmaxuq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x3f, 0x14, 0x01);
    FCML_A64("vpmaxuq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x3f, 0x14, 0x01);
    FCML_I64("vpmaxuq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x3f, 0x14, 0x01);
    FCML_A32("vpmaxuq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x3f, 0x14, 0x01);
    FCML_I32("vpmaxuq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x3f, 0x14, 0x01);
    FCML_A64("vpmaxuq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x3f, 0x14, 0x01);
    FCML_I64("vpmaxuq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x3f, 0x14, 0x01);
    FCML_A32("vpmaxuq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x3f, 0x14, 0x01);
    FCML_I32("vpmaxuq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x3f, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpmaxuq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x3f, 0x3e);
    FCML_A64("vpmaxuq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x3f, 0x3e);
    FCML_I64("vpmaxuq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x3f, 0x3e);
    FCML_A64("vpmaxuq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x3f, 0x3e);
    FCML_I64("vpmaxuq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x3f, 0x3e);
    FCML_A64("vpmaxuq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x3f, 0x3e);
    FCML_A32("vpmaxuq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x3f, 0x0e);
    FCML_I32("vpmaxuq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x3f, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpmaxuq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x3f, 0x3e);
    FCML_I64("vpmaxuq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x3f, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpmaxuq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxuq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxuq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxuq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I32("vpmaxuq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxuq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxuq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxuq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I32("vpmaxuq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxuq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x3f, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxuq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x3f, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxuq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x3f, 0x4c, 0x24, 0x08);

}

void fcml_tf_instruction_PMAXUW(void) {

    FCML_I64( "pmaxuw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x3E, 0x00 );
    FCML_I32( "pmaxuw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x3E, 0xC1 );
    FCML_A64( "pmaxuw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x3e, 0x00 );
    FCML_A64( "pmaxuw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x3e, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmaxuw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3e, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x3e, 0x38));
    FCML_I64_M("vpmaxuw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3e, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x3e, 0x38));
    FCML_A32_M("vpmaxuw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x3e, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x3e, 0x38));
    FCML_I32_M("vpmaxuw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x3e, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x3e, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmaxuw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3e, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x3e, 0x38));
    FCML_I64_M("vpmaxuw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3e, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x3e, 0x38));
    FCML_A32_M("vpmaxuw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x3e, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x3e, 0x38));
    FCML_I32_M("vpmaxuw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x3e, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x3e, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmaxuw (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x3e, 0x38);
    FCML_I64("vpmaxuw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x3e, 0x38);
    FCML_A32("vpmaxuw (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x3e, 0x38);
    FCML_I32("vpmaxuw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x3e, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmaxuw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3e, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x3e, 0xf9));
    FCML_I64_M("vpmaxuw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3e, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x3e, 0xf9));
    FCML_A32_M("vpmaxuw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3e, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x3e, 0xf9));
    FCML_I32_M("vpmaxuw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3e, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x3e, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmaxuw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3e, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x3e, 0xf6));
    FCML_I64_M("vpmaxuw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3e, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x3e, 0xf6));
    FCML_A32_M("vpmaxuw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x3e, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x3e, 0xf5));
    FCML_I32_M("vpmaxuw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x3e, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x3e, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmaxuw %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x3e, 0xf4);
    FCML_I64("vpmaxuw zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x3e, 0xf4);
    FCML_A32("vpmaxuw %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x3e, 0xf4);
    FCML_I32("vpmaxuw zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x3e, 0xf4);
    /* disp8 */
    FCML_I32("vpmaxuw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x3e, 0x4c, 0x24, 0x08);
    FCML_A32("vpmaxuw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x3e, 0x4c, 0x24, 0x08);
    FCML_I64("vpmaxuw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x3e, 0x4c, 0x24, 0x08);
    FCML_A64("vpmaxuw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x3e, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpmaxuw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3e, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3e, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmaxuw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3e, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3e, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpmaxuw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3e, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3e, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmaxuw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3e, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3e, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmaxuw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3e, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3e, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmaxuw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3e, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3e, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmaxuw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3e, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3e, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmaxuw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3e, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3e, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));

    /* {k}{z} */
    FCML_A64("vpmaxuw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x3e, 0x14, 0x01);
    FCML_I64("vpmaxuw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x3e, 0x14, 0x01);
    FCML_A32("vpmaxuw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x3e, 0x14, 0x01);
    FCML_I32("vpmaxuw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x3e, 0x14, 0x01);
    FCML_A64("vpmaxuw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x3e, 0x14, 0x01);
    FCML_I64("vpmaxuw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x3e, 0x14, 0x01);
    FCML_A32("vpmaxuw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x3e, 0x14, 0x01);
    FCML_I32("vpmaxuw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x3e, 0x14, 0x01);
    FCML_A64("vpmaxuw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x3e, 0x14, 0x01);
    FCML_I64("vpmaxuw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x3e, 0x14, 0x01);
    FCML_A32("vpmaxuw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x3e, 0x14, 0x01);
    FCML_I32("vpmaxuw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x3e, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmaxuw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x3e, 0x14, 0x01);
    FCML_I64("vpmaxuw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x3e, 0x14, 0x01);
    FCML_A32("vpmaxuw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x3e, 0x14, 0x01);
    FCML_I32("vpmaxuw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x3e, 0x14, 0x01);
    FCML_A64("vpmaxuw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x3e, 0x14, 0x01);
    FCML_I64("vpmaxuw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x3e, 0x14, 0x01);
    FCML_A32("vpmaxuw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x3e, 0x14, 0x01);
    FCML_I32("vpmaxuw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x3e, 0x14, 0x01);
    FCML_A64("vpmaxuw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x3e, 0x14, 0x01);
    FCML_I64("vpmaxuw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x3e, 0x14, 0x01);
    FCML_A32("vpmaxuw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x3e, 0x14, 0x01);
    FCML_I32("vpmaxuw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x3e, 0x14, 0x01);

}

void fcml_tf_instruction_PMINSB(void) {

    FCML_I64( "pminsb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x38, 0x00 );
    FCML_I32( "pminsb xmm0,xmm1", 0x66, 0x0F, 0x38, 0x38, 0xC1 );
    FCML_A64( "pminsb (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x38, 0x00 );
    FCML_A64( "pminsb %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x38, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpminsb (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x38, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x38, 0x38));
    FCML_I64_M("vpminsb xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x38, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x38, 0x38));
    FCML_A32_M("vpminsb (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x38, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x38, 0x38));
    FCML_I32_M("vpminsb xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x38, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x38, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpminsb (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x38, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x38, 0x38));
    FCML_I64_M("vpminsb ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x38, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x38, 0x38));
    FCML_A32_M("vpminsb (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x38, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x38, 0x38));
    FCML_I32_M("vpminsb ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x38, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x38, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpminsb (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x38, 0x38);
    FCML_I64("vpminsb zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x38, 0x38);
    FCML_A32("vpminsb (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x38, 0x38);
    FCML_I32("vpminsb zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x38, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpminsb %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x38, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x38, 0xf9));
    FCML_I64_M("vpminsb xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x38, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x38, 0xf9));
    FCML_A32_M("vpminsb %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x38, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x38, 0xf9));
    FCML_I32_M("vpminsb xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x38, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x38, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpminsb %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x38, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x38, 0xf6));
    FCML_I64_M("vpminsb ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x38, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x38, 0xf6));
    FCML_A32_M("vpminsb %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x38, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x38, 0xf5));
    FCML_I32_M("vpminsb ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x38, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x38, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpminsb %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x38, 0xf4);
    FCML_I64("vpminsb zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x38, 0xf4);
    FCML_A32("vpminsb %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x38, 0xf4);
    FCML_I32("vpminsb zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x38, 0xf4);
    /* disp8 */
    FCML_I32("vpminsb zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x38, 0x4c, 0x24, 0x08);
    FCML_A32("vpminsb 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x38, 0x4c, 0x24, 0x08);
    FCML_I64("vpminsb zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x38, 0x4c, 0x24, 0x08);
    FCML_A64("vpminsb 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x38, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpminsb ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x38, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x38, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpminsb 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x38, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x38, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpminsb ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x38, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x38, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpminsb 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x38, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x38, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpminsb xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x38, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x38, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpminsb 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x38, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x38, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpminsb xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x38, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x38, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpminsb 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x38, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x38, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpminsb (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x38, 0x14, 0x01);
    FCML_I64("vpminsb xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x38, 0x14, 0x01);
    FCML_A32("vpminsb (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x38, 0x14, 0x01);
    FCML_I32("vpminsb xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x38, 0x14, 0x01);
    FCML_A64("vpminsb (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x38, 0x14, 0x01);
    FCML_I64("vpminsb ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x38, 0x14, 0x01);
    FCML_A32("vpminsb (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x38, 0x14, 0x01);
    FCML_I32("vpminsb ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x38, 0x14, 0x01);
    FCML_A64("vpminsb (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x38, 0x14, 0x01);
    FCML_I64("vpminsb zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x38, 0x14, 0x01);
    FCML_A32("vpminsb (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x38, 0x14, 0x01);
    FCML_I32("vpminsb zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x38, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpminsb (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x38, 0x14, 0x01);
    FCML_I64("vpminsb xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x38, 0x14, 0x01);
    FCML_A32("vpminsb (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x38, 0x14, 0x01);
    FCML_I32("vpminsb xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x38, 0x14, 0x01);
    FCML_A64("vpminsb (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x38, 0x14, 0x01);
    FCML_I64("vpminsb ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x38, 0x14, 0x01);
    FCML_A32("vpminsb (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x38, 0x14, 0x01);
    FCML_I32("vpminsb ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x38, 0x14, 0x01);
    FCML_A64("vpminsb (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x38, 0x14, 0x01);
    FCML_I64("vpminsb zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x38, 0x14, 0x01);
    FCML_A32("vpminsb (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x38, 0x14, 0x01);
    FCML_I32("vpminsb zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x38, 0x14, 0x01);
}

void fcml_tf_instruction_PMINSD(void) {

    FCML_I64( "pminsd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x39, 0x00 );
    FCML_I32( "pminsd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x39, 0xC1 );
    FCML_A64( "pminsd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x39, 0x00 );
    FCML_A64( "pminsd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x39, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpminsd (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x39, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x39, 0x38));
    FCML_I64_M("vpminsd xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x39, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x39, 0x38));
    FCML_A32_M("vpminsd (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x39, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x39, 0x38));
    FCML_I32_M("vpminsd xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x39, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x39, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpminsd (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x39, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x39, 0x38));
    FCML_I64_M("vpminsd ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x39, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x39, 0x38));
    FCML_A32_M("vpminsd (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x39, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x39, 0x38));
    FCML_I32_M("vpminsd ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x39, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x39, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpminsd (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x39, 0x38);
    FCML_I64("vpminsd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x39, 0x38);
    FCML_A32("vpminsd (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x39, 0x38);
    FCML_I32("vpminsd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x39, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpminsd %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x39, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x39, 0xf9));
    FCML_I64_M("vpminsd xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x39, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x39, 0xf9));
    FCML_A32_M("vpminsd %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x39, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x39, 0xf9));
    FCML_I32_M("vpminsd xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x39, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x39, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpminsd %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x39, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x39, 0xf6));
    FCML_I64_M("vpminsd ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x39, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x39, 0xf6));
    FCML_A32_M("vpminsd %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x39, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x39, 0xf5));
    FCML_I32_M("vpminsd ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x39, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x39, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpminsd %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x39, 0xf4);
    FCML_I64("vpminsd zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x39, 0xf4);
    FCML_A32("vpminsd %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x39, 0xf4);
    FCML_I32("vpminsd zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x39, 0xf4);
    /* disp8 */
    FCML_I32("vpminsd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x39, 0x4c, 0x24, 0x08);
    FCML_A32("vpminsd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x39, 0x4c, 0x24, 0x08);
    FCML_I64("vpminsd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x39, 0x4c, 0x24, 0x08);
    FCML_A64("vpminsd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x39, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpminsd ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x39, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x39, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpminsd 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x39, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x39, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpminsd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x39, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x39, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpminsd 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x39, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x39, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpminsd xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x39, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x39, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpminsd 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x39, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x39, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpminsd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x39, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x39, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpminsd 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x39, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x39, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpminsd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x39, 0x14, 0x01);
    FCML_I64("vpminsd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x39, 0x14, 0x01);
    FCML_A32("vpminsd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x39, 0x14, 0x01);
    FCML_I32("vpminsd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x39, 0x14, 0x01);
    FCML_A64("vpminsd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x39, 0x14, 0x01);
    FCML_I64("vpminsd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x39, 0x14, 0x01);
    FCML_A32("vpminsd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x39, 0x14, 0x01);
    FCML_I32("vpminsd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x39, 0x14, 0x01);
    FCML_A64("vpminsd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x39, 0x14, 0x01);
    FCML_I64("vpminsd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x39, 0x14, 0x01);
    FCML_A32("vpminsd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x39, 0x14, 0x01);
    FCML_I32("vpminsd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x39, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpminsd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x39, 0x14, 0x01);
    FCML_I64("vpminsd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x39, 0x14, 0x01);
    FCML_A32("vpminsd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x39, 0x14, 0x01);
    FCML_I32("vpminsd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x39, 0x14, 0x01);
    FCML_A64("vpminsd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x39, 0x14, 0x01);
    FCML_I64("vpminsd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x39, 0x14, 0x01);
    FCML_A32("vpminsd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x39, 0x14, 0x01);
    FCML_I32("vpminsd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x39, 0x14, 0x01);
    FCML_A64("vpminsd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x39, 0x14, 0x01);
    FCML_I64("vpminsd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x39, 0x14, 0x01);
    FCML_A32("vpminsd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x39, 0x14, 0x01);
    FCML_I32("vpminsd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x39, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpminsd zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x39, 0x3e);
    FCML_A64("vpminsd (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x39, 0x3e);
    FCML_I64("vpminsd ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x39, 0x3e);
    FCML_A64("vpminsd (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x39, 0x3e);
    FCML_I64("vpminsd xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x39, 0x3e);
    FCML_A64("vpminsd (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x39, 0x3e);
    FCML_A32("vpminsd (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x39, 0x0e);
    FCML_I32("vpminsd zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x39, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpminsd (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x39, 0x3e);
    FCML_I64("vpminsd ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x39, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpminsd zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x39, 0x4c, 0x24, 0x08);
    FCML_A32("vpminsd 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x39, 0x4c, 0x24, 0x08);
    FCML_I64("vpminsd zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x39, 0x4c, 0x24, 0x08);
    FCML_A64("vpminsd 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x39, 0x4c, 0x24, 0x08);
    FCML_I32("vpminsd ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x39, 0x4c, 0x24, 0x08);
    FCML_A32("vpminsd 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x39, 0x4c, 0x24, 0x08);
    FCML_I64("vpminsd ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x39, 0x4c, 0x24, 0x08);
    FCML_A64("vpminsd 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x39, 0x4c, 0x24, 0x08);
    FCML_I32("vpminsd xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x39, 0x4c, 0x24, 0x08);
    FCML_A32("vpminsd 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x39, 0x4c, 0x24, 0x08);
    FCML_I64("vpminsd xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x39, 0x4c, 0x24, 0x08);
    FCML_A64("vpminsd 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x39, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PMINSQ(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpminsq (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x39, 0x38);
    FCML_I64("vpminsq xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x39, 0x38);
    FCML_A32("vpminsq (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x39, 0x38);
    FCML_I32("vpminsq xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x39, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpminsq (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x39, 0x38);
    FCML_I64("vpminsq ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x39, 0x38);
    FCML_A32("vpminsq (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x39, 0x38);
    FCML_I32("vpminsq ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x39, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpminsq (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x39, 0x38);
    FCML_I64("vpminsq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x39, 0x38);
    FCML_A32("vpminsq (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x39, 0x38);
    FCML_I32("vpminsq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x39, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpminsq %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x39, 0xf9);
    FCML_I64("vpminsq xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x39, 0xf9);
    FCML_A32("vpminsq %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x39, 0xf9);
    FCML_I32("vpminsq xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x39, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpminsq %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x39, 0xf6);
    FCML_I64("vpminsq ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x39, 0xf6);
    FCML_A32("vpminsq %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x39, 0xf5);
    FCML_I32("vpminsq ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x39, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpminsq %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x39, 0xf4);
    FCML_I64("vpminsq zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x39, 0xf4);
    FCML_A32("vpminsq %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x39, 0xf4);
    FCML_I32("vpminsq zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x39, 0xf4);
    /* disp8 */
    FCML_I32("vpminsq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x39, 0x4c, 0x24, 0x08);
    FCML_A32("vpminsq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x39, 0x4c, 0x24, 0x08);
    FCML_I64("vpminsq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x39, 0x4c, 0x24, 0x08);
    FCML_A64("vpminsq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x39, 0x4c, 0x24, 0x08);
    FCML_I32("vpminsq ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x39, 0x4c, 0x24, 0x08);
    FCML_A32("vpminsq 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x39, 0x4c, 0x24, 0x08);
    FCML_I64("vpminsq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x39, 0x4c, 0x24, 0x08);
    FCML_A64("vpminsq 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x39, 0x4c, 0x24, 0x08);
    FCML_I32("vpminsq xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x39, 0x4c, 0x24, 0x08);
    FCML_A32("vpminsq 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x39, 0x4c, 0x24, 0x08);
    FCML_I64("vpminsq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x39, 0x4c, 0x24, 0x08);
    FCML_A64("vpminsq 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x39, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpminsq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x39, 0x14, 0x01);
    FCML_I64("vpminsq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x39, 0x14, 0x01);
    FCML_A32("vpminsq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x39, 0x14, 0x01);
    FCML_I32("vpminsq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x39, 0x14, 0x01);
    FCML_A64("vpminsq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x39, 0x14, 0x01);
    FCML_I64("vpminsq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x39, 0x14, 0x01);
    FCML_A32("vpminsq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x39, 0x14, 0x01);
    FCML_I32("vpminsq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x39, 0x14, 0x01);
    FCML_A64("vpminsq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x39, 0x14, 0x01);
    FCML_I64("vpminsq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x39, 0x14, 0x01);
    FCML_A32("vpminsq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x39, 0x14, 0x01);
    FCML_I32("vpminsq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x39, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpminsq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x39, 0x14, 0x01);
    FCML_I64("vpminsq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x39, 0x14, 0x01);
    FCML_A32("vpminsq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x39, 0x14, 0x01);
    FCML_I32("vpminsq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x39, 0x14, 0x01);
    FCML_A64("vpminsq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x39, 0x14, 0x01);
    FCML_I64("vpminsq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x39, 0x14, 0x01);
    FCML_A32("vpminsq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x39, 0x14, 0x01);
    FCML_I32("vpminsq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x39, 0x14, 0x01);
    FCML_A64("vpminsq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x39, 0x14, 0x01);
    FCML_I64("vpminsq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x39, 0x14, 0x01);
    FCML_A32("vpminsq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x39, 0x14, 0x01);
    FCML_I32("vpminsq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x39, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpminsq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x39, 0x3e);
    FCML_A64("vpminsq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x39, 0x3e);
    FCML_I64("vpminsq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x39, 0x3e);
    FCML_A64("vpminsq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x39, 0x3e);
    FCML_I64("vpminsq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x39, 0x3e);
    FCML_A64("vpminsq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x39, 0x3e);
    FCML_A32("vpminsq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x39, 0x0e);
    FCML_I32("vpminsq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x39, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpminsq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x39, 0x3e);
    FCML_I64("vpminsq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x39, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpminsq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x39, 0x4c, 0x24, 0x08);
    FCML_A32("vpminsq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x39, 0x4c, 0x24, 0x08);
    FCML_I64("vpminsq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x39, 0x4c, 0x24, 0x08);
    FCML_A64("vpminsq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x39, 0x4c, 0x24, 0x08);
    FCML_I32("vpminsq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x39, 0x4c, 0x24, 0x08);
    FCML_A32("vpminsq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x39, 0x4c, 0x24, 0x08);
    FCML_I64("vpminsq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x39, 0x4c, 0x24, 0x08);
    FCML_A64("vpminsq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x39, 0x4c, 0x24, 0x08);
    FCML_I32("vpminsq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x39, 0x4c, 0x24, 0x08);
    FCML_A32("vpminsq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x39, 0x4c, 0x24, 0x08);
    FCML_I64("vpminsq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x39, 0x4c, 0x24, 0x08);
    FCML_A64("vpminsq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x39, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PMINSW(void) {

    FCML_I64( "pminsw mm0,mmword ptr [rax]", 0x0F, 0xEA, 0x00 );
    FCML_I32( "pminsw mm0,mm1", 0x0F, 0xEA, 0xC1 );
    FCML_I64( "pminsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xEA, 0x00 );
    FCML_I32( "pminsw xmm0,xmm1", 0x66, 0x0F, 0xEA, 0xC1 );
    FCML_A64( "pminsw (%rax),%mm0", 0x0f, 0xea, 0x00 );
    FCML_A64( "pminsw %mm1,%mm0", 0x0f, 0xea, 0xc1 );
    FCML_A64( "pminsw (%rax),%xmm0", 0x66, 0x0f, 0xea, 0x00 );
    FCML_A64( "pminsw %xmm1,%xmm0", 0x66, 0x0f, 0xea, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpminsw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xea, 0x38), FCML_MI(0xc5, 0x41, 0xea, 0x38));
    FCML_I64_M("vpminsw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xea, 0x38), FCML_MI(0xc5, 0x41, 0xea, 0x38));
    FCML_A32_M("vpminsw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xea, 0x38), FCML_MI(0xc5, 0xc9, 0xea, 0x38));
    FCML_I32_M("vpminsw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xea, 0x38), FCML_MI(0xc5, 0xc9, 0xea, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpminsw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xea, 0x38), FCML_MI(0xc5, 0x45, 0xea, 0x38));
    FCML_I64_M("vpminsw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xea, 0x38), FCML_MI(0xc5, 0x45, 0xea, 0x38));
    FCML_A32_M("vpminsw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xea, 0x38), FCML_MI(0xc5, 0xd5, 0xea, 0x38));
    FCML_I32_M("vpminsw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xea, 0x38), FCML_MI(0xc5, 0xd5, 0xea, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpminsw (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xea, 0x38);
    FCML_I64("vpminsw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xea, 0x38);
    FCML_A32("vpminsw (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xea, 0x38);
    FCML_I32("vpminsw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xea, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpminsw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xea, 0xf9), FCML_MI(0xc5, 0x41, 0xea, 0xf9));
    FCML_I64_M("vpminsw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xea, 0xf9), FCML_MI(0xc5, 0x41, 0xea, 0xf9));
    FCML_A32_M("vpminsw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xea, 0xf9), FCML_MI(0xc5, 0xe9, 0xea, 0xf9));
    FCML_I32_M("vpminsw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xea, 0xf9), FCML_MI(0xc5, 0xe9, 0xea, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpminsw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xea, 0xf6), FCML_MI(0xc5, 0x45, 0xea, 0xf6));
    FCML_I64_M("vpminsw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xea, 0xf6), FCML_MI(0xc5, 0x45, 0xea, 0xf6));
    FCML_A32_M("vpminsw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xea, 0xf5), FCML_MI(0xc5, 0xe5, 0xea, 0xf5));
    FCML_I32_M("vpminsw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xea, 0xf5), FCML_MI(0xc5, 0xe5, 0xea, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpminsw %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xea, 0xf4);
    FCML_I64("vpminsw zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xea, 0xf4);
    FCML_A32("vpminsw %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xea, 0xf4);
    FCML_I32("vpminsw zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xea, 0xf4);
    /* disp8 */
    FCML_I32("vpminsw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xea, 0x4c, 0x24, 0x08);
    FCML_A32("vpminsw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xea, 0x4c, 0x24, 0x08);
    FCML_I64("vpminsw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xea, 0x4c, 0x24, 0x08);
    FCML_A64("vpminsw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xea, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpminsw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xea, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xea, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpminsw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xea, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xea, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpminsw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xea, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xea, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpminsw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xea, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xea, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpminsw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xea, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xea, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpminsw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xea, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xea, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpminsw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xea, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xea, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpminsw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xea, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xea, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));

    /* {k}{z} */
    FCML_A64("vpminsw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xea, 0x14, 0x01);
    FCML_I64("vpminsw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xea, 0x14, 0x01);
    FCML_A32("vpminsw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xea, 0x14, 0x01);
    FCML_I32("vpminsw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xea, 0x14, 0x01);
    FCML_A64("vpminsw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xea, 0x14, 0x01);
    FCML_I64("vpminsw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xea, 0x14, 0x01);
    FCML_A32("vpminsw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xea, 0x14, 0x01);
    FCML_I32("vpminsw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xea, 0x14, 0x01);
    FCML_A64("vpminsw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xea, 0x14, 0x01);
    FCML_I64("vpminsw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xea, 0x14, 0x01);
    FCML_A32("vpminsw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xea, 0x14, 0x01);
    FCML_I32("vpminsw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xea, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpminsw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xea, 0x14, 0x01);
    FCML_I64("vpminsw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xea, 0x14, 0x01);
    FCML_A32("vpminsw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xea, 0x14, 0x01);
    FCML_I32("vpminsw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xea, 0x14, 0x01);
    FCML_A64("vpminsw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xea, 0x14, 0x01);
    FCML_I64("vpminsw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xea, 0x14, 0x01);
    FCML_A32("vpminsw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xea, 0x14, 0x01);
    FCML_I32("vpminsw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xea, 0x14, 0x01);
    FCML_A64("vpminsw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xea, 0x14, 0x01);
    FCML_I64("vpminsw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xea, 0x14, 0x01);
    FCML_A32("vpminsw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xea, 0x14, 0x01);
    FCML_I32("vpminsw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xea, 0x14, 0x01);
}

void fcml_tf_instruction_PMINUB(void) {

    FCML_I64( "pminub mm0,mmword ptr [rax]", 0x0F, 0xDA, 0x00 );
    FCML_I32( "pminub mm0,mm1", 0x0F, 0xDA, 0xC1 );
    FCML_I64( "pminub xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xDA, 0x00 );
    FCML_I32( "pminub xmm0,xmm1", 0x66, 0x0F, 0xDA, 0xC1 );
    FCML_A64( "pminub (%rax),%mm0", 0x0f, 0xda, 0x00 );
    FCML_A64( "pminub %mm1,%mm0", 0x0f, 0xda, 0xc1 );
    FCML_A64( "pminub (%rax),%xmm0", 0x66, 0x0f, 0xda, 0x00 );
    FCML_A64( "pminub %xmm1,%xmm0", 0x66, 0x0f, 0xda, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpminub (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xda, 0x38), FCML_MI(0xc5, 0x41, 0xda, 0x38));
    FCML_I64_M("vpminub xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xda, 0x38), FCML_MI(0xc5, 0x41, 0xda, 0x38));
    FCML_A32_M("vpminub (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xda, 0x38), FCML_MI(0xc5, 0xc9, 0xda, 0x38));
    FCML_I32_M("vpminub xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xda, 0x38), FCML_MI(0xc5, 0xc9, 0xda, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpminub (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xda, 0x38), FCML_MI(0xc5, 0x45, 0xda, 0x38));
    FCML_I64_M("vpminub ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xda, 0x38), FCML_MI(0xc5, 0x45, 0xda, 0x38));
    FCML_A32_M("vpminub (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xda, 0x38), FCML_MI(0xc5, 0xd5, 0xda, 0x38));
    FCML_I32_M("vpminub ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xda, 0x38), FCML_MI(0xc5, 0xd5, 0xda, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpminub (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xda, 0x38);
    FCML_I64("vpminub zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xda, 0x38);
    FCML_A32("vpminub (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xda, 0x38);
    FCML_I32("vpminub zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xda, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpminub %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xda, 0xf9), FCML_MI(0xc5, 0x41, 0xda, 0xf9));
    FCML_I64_M("vpminub xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xda, 0xf9), FCML_MI(0xc5, 0x41, 0xda, 0xf9));
    FCML_A32_M("vpminub %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xda, 0xf9), FCML_MI(0xc5, 0xe9, 0xda, 0xf9));
    FCML_I32_M("vpminub xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xda, 0xf9), FCML_MI(0xc5, 0xe9, 0xda, 0xf9));
    FCML_A64_M("vpminub %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xda, 0xf6), FCML_MI(0xc5, 0x45, 0xda, 0xf6));
    FCML_I64_M("vpminub ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xda, 0xf6), FCML_MI(0xc5, 0x45, 0xda, 0xf6));
    FCML_A32_M("vpminub %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xda, 0xf5), FCML_MI(0xc5, 0xe5, 0xda, 0xf5));
    FCML_I32_M("vpminub ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xda, 0xf5), FCML_MI(0xc5, 0xe5, 0xda, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpminub %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xda, 0xf4);
    FCML_I64("vpminub zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xda, 0xf4);
    FCML_A32("vpminub %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xda, 0xf4);
    FCML_I32("vpminub zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xda, 0xf4);
    /* disp8 */
    FCML_I32("vpminub zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xda, 0x4c, 0x24, 0x08);
    FCML_A32("vpminub 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xda, 0x4c, 0x24, 0x08);
    FCML_I64("vpminub zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xda, 0x4c, 0x24, 0x08);
    FCML_A64("vpminub 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xda, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpminub ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xda, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xda, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpminub 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xda, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xda, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpminub ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xda, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xda, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpminub 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xda, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xda, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpminub xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xda, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xda, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpminub 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xda, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xda, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpminub xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xda, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xda, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpminub 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xda, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xda, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpminub (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xda, 0x14, 0x01);
    FCML_I64("vpminub xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xda, 0x14, 0x01);
    FCML_A32("vpminub (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xda, 0x14, 0x01);
    FCML_I32("vpminub xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xda, 0x14, 0x01);
    FCML_A64("vpminub (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xda, 0x14, 0x01);
    FCML_I64("vpminub ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xda, 0x14, 0x01);
    FCML_A32("vpminub (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xda, 0x14, 0x01);
    FCML_I32("vpminub ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xda, 0x14, 0x01);
    FCML_A64("vpminub (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xda, 0x14, 0x01);
    FCML_I64("vpminub zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xda, 0x14, 0x01);
    FCML_A32("vpminub (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xda, 0x14, 0x01);
    FCML_I32("vpminub zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xda, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpminub (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xda, 0x14, 0x01);
    FCML_I64("vpminub xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xda, 0x14, 0x01);
    FCML_A32("vpminub (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xda, 0x14, 0x01);
    FCML_I32("vpminub xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xda, 0x14, 0x01);
    FCML_A64("vpminub (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xda, 0x14, 0x01);
    FCML_I64("vpminub ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xda, 0x14, 0x01);
    FCML_A32("vpminub (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xda, 0x14, 0x01);
    FCML_I32("vpminub ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xda, 0x14, 0x01);
    FCML_A64("vpminub (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xda, 0x14, 0x01);
    FCML_I64("vpminub zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xda, 0x14, 0x01);
    FCML_A32("vpminub (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xda, 0x14, 0x01);
    FCML_I32("vpminub zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xda, 0x14, 0x01);

}

void fcml_tf_instruction_PMINUW(void) {

    FCML_I64( "pminuw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x3A, 0x00 );
    FCML_I32( "pminuw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x3A, 0xC1 );
    FCML_A64( "pminuw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x3a, 0x00 );
    FCML_A64( "pminuw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x3a, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpminuw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3a, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x3a, 0x38));
    FCML_I64_M("vpminuw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3a, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x3a, 0x38));
    FCML_A32_M("vpminuw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x3a, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x3a, 0x38));
    FCML_I32_M("vpminuw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x3a, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x3a, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpminuw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3a, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x3a, 0x38));
    FCML_I64_M("vpminuw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3a, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x3a, 0x38));
    FCML_A32_M("vpminuw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x3a, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x3a, 0x38));
    FCML_I32_M("vpminuw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x3a, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x3a, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpminuw (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x3a, 0x38);
    FCML_I64("vpminuw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x3a, 0x38);
    FCML_A32("vpminuw (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x3a, 0x38);
    FCML_I32("vpminuw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x3a, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpminuw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3a, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x3a, 0xf9));
    FCML_I64_M("vpminuw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3a, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x3a, 0xf9));
    FCML_A32_M("vpminuw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3a, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x3a, 0xf9));
    FCML_I32_M("vpminuw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3a, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x3a, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpminuw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3a, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x3a, 0xf6));
    FCML_I64_M("vpminuw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3a, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x3a, 0xf6));
    FCML_A32_M("vpminuw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x3a, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x3a, 0xf5));
    FCML_I32_M("vpminuw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x3a, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x3a, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpminuw %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x3a, 0xf4);
    FCML_I64("vpminuw zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x3a, 0xf4);
    FCML_A32("vpminuw %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x3a, 0xf4);
    FCML_I32("vpminuw zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x3a, 0xf4);
    /* disp8 */
    FCML_I32("vpminuw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x3a, 0x4c, 0x24, 0x08);
    FCML_A32("vpminuw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x3a, 0x4c, 0x24, 0x08);
    FCML_I64("vpminuw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x3a, 0x4c, 0x24, 0x08);
    FCML_A64("vpminuw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x3a, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpminuw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3a, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3a, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpminuw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3a, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3a, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpminuw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3a, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3a, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpminuw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3a, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3a, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpminuw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3a, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3a, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpminuw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3a, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3a, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpminuw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3a, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3a, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpminuw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3a, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3a, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpminuw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x3a, 0x14, 0x01);
    FCML_I64("vpminuw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x3a, 0x14, 0x01);
    FCML_A32("vpminuw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x3a, 0x14, 0x01);
    FCML_I32("vpminuw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x3a, 0x14, 0x01);
    FCML_A64("vpminuw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x3a, 0x14, 0x01);
    FCML_I64("vpminuw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x3a, 0x14, 0x01);
    FCML_A32("vpminuw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x3a, 0x14, 0x01);
    FCML_I32("vpminuw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x3a, 0x14, 0x01);
    FCML_A64("vpminuw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x3a, 0x14, 0x01);
    FCML_I64("vpminuw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x3a, 0x14, 0x01);
    FCML_A32("vpminuw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x3a, 0x14, 0x01);
    FCML_I32("vpminuw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x3a, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpminuw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x3a, 0x14, 0x01);
    FCML_I64("vpminuw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x3a, 0x14, 0x01);
    FCML_A32("vpminuw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x3a, 0x14, 0x01);
    FCML_I32("vpminuw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x3a, 0x14, 0x01);
    FCML_A64("vpminuw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x3a, 0x14, 0x01);
    FCML_I64("vpminuw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x3a, 0x14, 0x01);
    FCML_A32("vpminuw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x3a, 0x14, 0x01);
    FCML_I32("vpminuw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x3a, 0x14, 0x01);
    FCML_A64("vpminuw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x3a, 0x14, 0x01);
    FCML_I64("vpminuw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x3a, 0x14, 0x01);
    FCML_A32("vpminuw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x3a, 0x14, 0x01);
    FCML_I32("vpminuw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x3a, 0x14, 0x01);

}

void fcml_tf_instruction_PMINUD(void) {

    FCML_I64( "pminud xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x3B, 0x00 );
    FCML_I32( "pminud xmm0,xmm1", 0x66, 0x0F, 0x38, 0x3B, 0xC1 );
    FCML_A64( "pminud (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x3b, 0x00 );
    FCML_A64( "pminud %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x3b, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpminud (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3b, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x3b, 0x38));
    FCML_I64_M("vpminud xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3b, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x3b, 0x38));
    FCML_A32_M("vpminud (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x3b, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x3b, 0x38));
    FCML_I32_M("vpminud xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x3b, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x3b, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpminud (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3b, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x3b, 0x38));
    FCML_I64_M("vpminud ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3b, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x3b, 0x38));
    FCML_A32_M("vpminud (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x3b, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x3b, 0x38));
    FCML_I32_M("vpminud ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x3b, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x3b, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpminud (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x3b, 0x38);
    FCML_I64("vpminud zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x3b, 0x38);
    FCML_A32("vpminud (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x3b, 0x38);
    FCML_I32("vpminud zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x3b, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpminud %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3b, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x3b, 0xf9));
    FCML_I64_M("vpminud xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x3b, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x3b, 0xf9));
    FCML_A32_M("vpminud %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3b, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x3b, 0xf9));
    FCML_I32_M("vpminud xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3b, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x3b, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpminud %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3b, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x3b, 0xf6));
    FCML_I64_M("vpminud ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x3b, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x3b, 0xf6));
    FCML_A32_M("vpminud %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x3b, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x3b, 0xf5));
    FCML_I32_M("vpminud ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x3b, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x3b, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpminud %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x3b, 0xf4);
    FCML_I64("vpminud zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x3b, 0xf4);
    FCML_A32("vpminud %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x3b, 0xf4);
    FCML_I32("vpminud zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x3b, 0xf4);
    /* disp8 */
    FCML_I32("vpminud zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A32("vpminud 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I64("vpminud zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A64("vpminud 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpminud ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3b, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpminud 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3b, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpminud ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3b, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpminud 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x3b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x3b, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpminud xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3b, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpminud 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3b, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpminud xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3b, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpminud 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x3b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x3b, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpminud (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x3b, 0x14, 0x01);
    FCML_I64("vpminud xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x3b, 0x14, 0x01);
    FCML_A32("vpminud (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x3b, 0x14, 0x01);
    FCML_I32("vpminud xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x3b, 0x14, 0x01);
    FCML_A64("vpminud (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x3b, 0x14, 0x01);
    FCML_I64("vpminud ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x3b, 0x14, 0x01);
    FCML_A32("vpminud (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x3b, 0x14, 0x01);
    FCML_I32("vpminud ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x3b, 0x14, 0x01);
    FCML_A64("vpminud (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x3b, 0x14, 0x01);
    FCML_I64("vpminud zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x3b, 0x14, 0x01);
    FCML_A32("vpminud (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x3b, 0x14, 0x01);
    FCML_I32("vpminud zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x3b, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpminud (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x3b, 0x14, 0x01);
    FCML_I64("vpminud xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x3b, 0x14, 0x01);
    FCML_A32("vpminud (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x3b, 0x14, 0x01);
    FCML_I32("vpminud xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x3b, 0x14, 0x01);
    FCML_A64("vpminud (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x3b, 0x14, 0x01);
    FCML_I64("vpminud ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x3b, 0x14, 0x01);
    FCML_A32("vpminud (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x3b, 0x14, 0x01);
    FCML_I32("vpminud ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x3b, 0x14, 0x01);
    FCML_A64("vpminud (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x3b, 0x14, 0x01);
    FCML_I64("vpminud zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x3b, 0x14, 0x01);
    FCML_A32("vpminud (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x3b, 0x14, 0x01);
    FCML_I32("vpminud zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x3b, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpminud zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x3b, 0x3e);
    FCML_A64("vpminud (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x3b, 0x3e);
    FCML_I64("vpminud ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x3b, 0x3e);
    FCML_A64("vpminud (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x3b, 0x3e);
    FCML_I64("vpminud xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x3b, 0x3e);
    FCML_A64("vpminud (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x3b, 0x3e);
    FCML_A32("vpminud (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x3b, 0x0e);
    FCML_I32("vpminud zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x3b, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpminud (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x3b, 0x3e);
    FCML_I64("vpminud ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x3b, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpminud zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A32("vpminud 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I64("vpminud zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A64("vpminud 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I32("vpminud ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A32("vpminud 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I64("vpminud ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A64("vpminud 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I32("vpminud xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A32("vpminud 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I64("vpminud xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A64("vpminud 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x3b, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PMINUQ(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpminuq (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x3b, 0x38);
    FCML_I64("vpminuq xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x3b, 0x38);
    FCML_A32("vpminuq (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x3b, 0x38);
    FCML_I32("vpminuq xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x3b, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpminuq (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x3b, 0x38);
    FCML_I64("vpminuq ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x3b, 0x38);
    FCML_A32("vpminuq (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x3b, 0x38);
    FCML_I32("vpminuq ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x3b, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpminuq (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x3b, 0x38);
    FCML_I64("vpminuq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x3b, 0x38);
    FCML_A32("vpminuq (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x3b, 0x38);
    FCML_I32("vpminuq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x3b, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpminuq %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x3b, 0xf9);
    FCML_I64("vpminuq xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x3b, 0xf9);
    FCML_A32("vpminuq %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x3b, 0xf9);
    FCML_I32("vpminuq xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x3b, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpminuq %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x3b, 0xf6);
    FCML_I64("vpminuq ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x3b, 0xf6);
    FCML_A32("vpminuq %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x3b, 0xf5);
    FCML_I32("vpminuq ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x3b, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpminuq %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x3b, 0xf4);
    FCML_I64("vpminuq zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x3b, 0xf4);
    FCML_A32("vpminuq %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x3b, 0xf4);
    FCML_I32("vpminuq zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x3b, 0xf4);
    /* disp8 */
    FCML_I32("vpminuq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A32("vpminuq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I64("vpminuq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A64("vpminuq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I32("vpminuq ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A32("vpminuq 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I64("vpminuq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A64("vpminuq 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I32("vpminuq xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A32("vpminuq 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I64("vpminuq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A64("vpminuq 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x3b, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpminuq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x3b, 0x14, 0x01);
    FCML_I64("vpminuq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x3b, 0x14, 0x01);
    FCML_A32("vpminuq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x3b, 0x14, 0x01);
    FCML_I32("vpminuq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x3b, 0x14, 0x01);
    FCML_A64("vpminuq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x3b, 0x14, 0x01);
    FCML_I64("vpminuq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x3b, 0x14, 0x01);
    FCML_A32("vpminuq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x3b, 0x14, 0x01);
    FCML_I32("vpminuq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x3b, 0x14, 0x01);
    FCML_A64("vpminuq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x3b, 0x14, 0x01);
    FCML_I64("vpminuq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x3b, 0x14, 0x01);
    FCML_A32("vpminuq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x3b, 0x14, 0x01);
    FCML_I32("vpminuq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x3b, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpminuq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x3b, 0x14, 0x01);
    FCML_I64("vpminuq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x3b, 0x14, 0x01);
    FCML_A32("vpminuq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x3b, 0x14, 0x01);
    FCML_I32("vpminuq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x3b, 0x14, 0x01);
    FCML_A64("vpminuq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x3b, 0x14, 0x01);
    FCML_I64("vpminuq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x3b, 0x14, 0x01);
    FCML_A32("vpminuq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x3b, 0x14, 0x01);
    FCML_I32("vpminuq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x3b, 0x14, 0x01);
    FCML_A64("vpminuq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x3b, 0x14, 0x01);
    FCML_I64("vpminuq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x3b, 0x14, 0x01);
    FCML_A32("vpminuq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x3b, 0x14, 0x01);
    FCML_I32("vpminuq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x3b, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpminuq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x3b, 0x3e);
    FCML_A64("vpminuq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x3b, 0x3e);
    FCML_I64("vpminuq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x3b, 0x3e);
    FCML_A64("vpminuq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x3b, 0x3e);
    FCML_I64("vpminuq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x3b, 0x3e);
    FCML_A64("vpminuq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x3b, 0x3e);
    FCML_A32("vpminuq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x3b, 0x0e);
    FCML_I32("vpminuq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x3b, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpminuq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x3b, 0x3e);
    FCML_I64("vpminuq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x3b, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpminuq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A32("vpminuq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I64("vpminuq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A64("vpminuq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I32("vpminuq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A32("vpminuq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I64("vpminuq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A64("vpminuq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I32("vpminuq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A32("vpminuq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x3b, 0x4c, 0x24, 0x08);
    FCML_I64("vpminuq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x3b, 0x4c, 0x24, 0x08);
    FCML_A64("vpminuq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x3b, 0x4c, 0x24, 0x08);

}

void fcml_tf_instruction_PMOVMSKB(void) {

    FCML_I32( "pmovmskb eax,mm1", 0x0F, 0xD7, 0xC1 );
    FCML_I64( "pmovmskb rax,mm1", 0x0F, 0xD7, 0xC1 );

    FCML_I32( "pmovmskb eax,xmm1", 0x66, 0x0F, 0xD7, 0xC1 );
    FCML_I64( "pmovmskb rax,xmm1", 0x66, 0x0F, 0xD7, 0xC1 );

    FCML_I32( "vpmovmskb eax,xmm0", 0xc5, 0xf9, 0xd7, 0xc0 );
    FCML_I64( "vpmovmskb rcx,xmm0", 0xc5, 0xf9, 0xd7, 0xc8 );

    FCML_I32( "vpmovmskb ecx,ymm0", 0xc5, 0xfd, 0xd7, 0xc8 );
    FCML_I64( "vpmovmskb rax,ymm0", 0xc5, 0xfd, 0xd7, 0xc0 );

    FCML_A64( "pmovmskb %mm1,%rax", 0x0f, 0xd7, 0xc1 );
    FCML_A64( "pmovmskb %mm1,%rax", 0x0f, 0xd7, 0xc1 );
    FCML_A64( "pmovmskb %xmm1,%rax", 0x66, 0x0f, 0xd7, 0xc1 );
    FCML_A64( "pmovmskb %xmm1,%rax", 0x66, 0x0f, 0xd7, 0xc1 );

    FCML_A64( "vpmovmskb %xmm0,%rax", 0xc5, 0xf9, 0xd7, 0xc0 );
    FCML_A64( "vpmovmskb %xmm0,%rcx", 0xc5, 0xf9, 0xd7, 0xc8 );
    FCML_A64( "vpmovmskb %ymm0,%rcx", 0xc5, 0xfd, 0xd7, 0xc8 );
    FCML_A64( "vpmovmskb %ymm0,%r15", 0xc5, 0x7d, 0xd7, 0xf8 );
    FCML_A64( "vpmovmskb %xmm2,%r8", 0xc5, 0x79, 0xd7, 0xc2 );
    FCML_A64( "vpmovmskb %xmm8,%rcx", 0xc4, 0xc1, 0x79, 0xd7, 0xc8 );
    FCML_A64( "vpmovmskb %ymm13,%rcx", 0xc4, 0xc1, 0x7d, 0xd7, 0xcd );
    FCML_A64( "vpmovmskb %ymm15,%rax", 0xc4, 0xc1, 0x7d, 0xd7, 0xc7 );

    FCML_A32( "vpmovmskb %xmm0,%eax", 0xc5, 0xf9, 0xd7, 0xc0 );
    FCML_A32( "vpmovmskb %xmm0,%ecx", 0xc5, 0xf9, 0xd7, 0xc8 );
    FCML_A32( "vpmovmskb %ymm0,%ecx", 0xc5, 0xfd, 0xd7, 0xc8 );
    FCML_A32_D( "vpmovmskb %xmm0,%ecx", 0xc4, 0xc1, 0x79, 0xd7, 0xc8 );
    FCML_A32_D( "vpmovmskb %ymm5,%ecx", 0xc4, 0xc1, 0x7d, 0xd7, 0xcd );
    FCML_A32_D( "vpmovmskb %ymm7,%eax", 0xc4, 0xc1, 0x7d, 0xd7, 0xc7 );
    FCML_A32( "vpmovmskb %xmm0,%ecx", 0xc5, 0xf9, 0xd7, 0xc8 );
    FCML_A32( "vpmovmskb %ymm5,%ecx", 0xc5, 0xfd, 0xd7, 0xcd );
    FCML_A32( "vpmovmskb %ymm7,%eax", 0xc5, 0xfd, 0xd7, 0xc7 );

    FCML_A32( "vpmovmskb %ymm1,%eax", 0xc5, 0xfd, 0xd7, 0xc1 );
    FCML_A64( "vpmovmskb %ymm1,%rax", 0xc5, 0xfd, 0xd7, 0xc1 );
}

void fcml_tf_instruction_PMOVSX(void) {

    FCML_I64( "pmovsxbw xmm0,mmword ptr [rax]", 0x66, 0x0F, 0x38, 0x20, 0x00 );
    FCML_I32( "pmovsxbw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x20, 0xC1 );

    FCML_I64( "pmovsxbd xmm0,dword ptr [rax]", 0x66, 0x0F, 0x38, 0x21, 0x00 );
    FCML_I32( "pmovsxbd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x21, 0xC1 );

    FCML_I64( "pmovsxbq xmm0,word ptr [rax]", 0x66, 0x0F, 0x38, 0x22, 0x00 );
    FCML_I32( "pmovsxbq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x22, 0xC1 );

    FCML_I64( "pmovsxwd xmm0,mmword ptr [rax]", 0x66, 0x0F, 0x38, 0x23, 0x00 );
    FCML_I32( "pmovsxwd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x23, 0xC1 );

    FCML_I64( "pmovsxwq xmm0,dword ptr [rax]", 0x66, 0x0F, 0x38, 0x24, 0x00 );
    FCML_I32( "pmovsxwq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x24, 0xC1 );

    FCML_I64( "pmovsxdq xmm0,mmword ptr [rax]", 0x66, 0x0F, 0x38, 0x25, 0x00 );
    FCML_I32( "pmovsxdq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x25, 0xC1 );

    FCML_I32_M("vpmovsxbw xmm0,mmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x20, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x20, 0x00));
    FCML_I64_M("vpmovsxbw xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x20, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x20, 0xc1));

    FCML_I32_M("vpmovsxbw xmm0,mmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x20, 0x40, 0x08), FCML_MI(0xc4, 0xe2, 0x79, 0x20, 0x40, 0x40));
    FCML_I32("vpmovsxbw xmm0{k1},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x09, 0x20, 0x00);
    FCML_I32("vpmovsxbw xmm0{k2}{z},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x8a, 0x20, 0x00);

    FCML_I32_M("vpmovsxbw ymm0,xmmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x20, 0x40, 0x04), FCML_MI(0xc4, 0xe2, 0x7d, 0x20, 0x40, 0x40));
    FCML_I32("vpmovsxbw ymm0{k1},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x29, 0x20, 0x00);
    FCML_I32("vpmovsxbw ymm0{k2}{z},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xaa, 0x20, 0x00);

    FCML_I32("vpmovsxbw zmm0,ymmword ptr [eax+00000040h]", 0x62, 0xf2, 0x7d, 0x48, 0x20, 0x40, 0x02);
    FCML_I32("vpmovsxbw zmm0{k1},ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x49, 0x20, 0x00);
    FCML_I32("vpmovsxbw zmm0{k2}{z},ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xca, 0x20, 0x00);

    FCML_I32_M("vpmovsxbd xmm0,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x21, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x21, 0x00));
    FCML_I64_M("vpmovsxbd xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x21, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x21, 0xc1));

    FCML_I32_M("vpmovsxbd xmm0,dword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x21, 0x40, 0x10), FCML_MI(0xc4, 0xe2, 0x79, 0x21, 0x40, 0x40));
    FCML_I32_M("vpmovsxbd xmm0,xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x21, 0xc3), FCML_MI(0xc4, 0xe2, 0x79, 0x21, 0xc3));
    FCML_I32("vpmovsxbd xmm0{k4},dword ptr [eax]", 0x62, 0xf2, 0x7d, 0x0c, 0x21, 0x00);
    FCML_I32("vpmovsxbd xmm0{k3}{z},dword ptr [eax]", 0x62, 0xf2, 0x7d, 0x8b, 0x21, 0x00);

    FCML_I32_M("vpmovsxbd ymm0,mmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x21, 0x40, 0x08), FCML_MI(0xc4, 0xe2, 0x7d, 0x21, 0x40, 0x40));
    FCML_I32_M("vpmovsxbd ymm0,xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x21, 0xc3), FCML_MI(0xc4, 0xe2, 0x7d, 0x21, 0xc3));
    FCML_I32("vpmovsxbd ymm0{k4},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x2c, 0x21, 0x00);
    FCML_I32("vpmovsxbd ymm0{k3}{z},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xab, 0x21, 0x00);

    FCML_I32("vpmovsxbd zmm0,xmmword ptr [eax+00000040h]", 0x62, 0xf2, 0x7d, 0x48, 0x21, 0x40, 0x04);
    FCML_I32("vpmovsxbd zmm0{k4},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x4c, 0x21, 0x00);
    FCML_I32("vpmovsxbd zmm0{k3}{z},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xcb, 0x21, 0x00);

    FCML_I32_M("vpmovsxbq xmm0,word ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x22, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x22, 0x00));
    FCML_I64_M("vpmovsxbq xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x22, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x22, 0xc1));

    FCML_I32_M("vpmovsxbq xmm0,word ptr [eax+00000010h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x22, 0x40, 0x08), FCML_MI(0xc4, 0xe2, 0x79, 0x22, 0x40, 0x10));
    FCML_I32_M("vpmovsxbq xmm0,xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x22, 0xc3), FCML_MI(0xc4, 0xe2, 0x79, 0x22, 0xc3));
    FCML_I32("vpmovsxbq xmm0{k1},word ptr [eax]", 0x62, 0xf2, 0x7d, 0x09, 0x22, 0x00);
    FCML_I32("vpmovsxbq xmm0{k2}{z},word ptr [eax]", 0x62, 0xf2, 0x7d, 0x8a, 0x22, 0x00);

    FCML_I32_M("vpmovsxbq ymm0,dword ptr [eax+00000010h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x22, 0x40, 0x04), FCML_MI(0xc4, 0xe2, 0x7d, 0x22, 0x40, 0x10));
    FCML_I32_M("vpmovsxbq ymm0,xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x22, 0xc3), FCML_MI(0xc4, 0xe2, 0x7d, 0x22, 0xc3));
    FCML_I32("vpmovsxbq ymm0{k1},dword ptr [eax]", 0x62, 0xf2, 0x7d, 0x29, 0x22, 0x00);
    FCML_I32("vpmovsxbq ymm0{k2}{z},dword ptr [eax]", 0x62, 0xf2, 0x7d, 0xaa, 0x22, 0x00);

    FCML_I32("vpmovsxbq zmm0,mmword ptr [eax+00000010h]", 0x62, 0xf2, 0x7d, 0x48, 0x22, 0x40, 0x02);
    FCML_I32("vpmovsxbq zmm0,xmm3", 0x62, 0xf2, 0x7d, 0x48, 0x22, 0xc3);
    FCML_I32("vpmovsxbq zmm0{k1},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x49, 0x22, 0x00);
    FCML_I32("vpmovsxbq zmm0{k2}{z},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xca, 0x22, 0x00);

    FCML_I32_M("vpmovsxwd xmm0,mmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x23, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x23, 0x00));
    FCML_I64_M("vpmovsxwd xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x23, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x23, 0xc1));

    FCML_I32_M("vpmovsxwd xmm0,mmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x23, 0x40, 0x08), FCML_MI(0xc4, 0xe2, 0x79, 0x23, 0x40, 0x40));
    FCML_I32("vpmovsxwd xmm0{k1},xmm4", 0x62, 0xf2, 0x7d, 0x09, 0x23, 0xc4);
    FCML_I32("vpmovsxwd xmm0{k1},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x09, 0x23, 0x00);
    FCML_I32("vpmovsxwd xmm0{k2}{z},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x8a, 0x23, 0x00);

    FCML_I32_M("vpmovsxwd ymm0,xmmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x23, 0x40, 0x04), FCML_MI(0xc4, 0xe2, 0x7d, 0x23, 0x40, 0x40));
    FCML_I32("vpmovsxwd ymm0{k1},xmm4", 0x62, 0xf2, 0x7d, 0x29, 0x23, 0xc4);
    FCML_I32("vpmovsxwd ymm0{k1},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x29, 0x23, 0x00);
    FCML_I32("vpmovsxwd ymm0{k2}{z},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xaa, 0x23, 0x00);

    FCML_I32("vpmovsxwd zmm0,ymmword ptr [eax+00000040h]", 0x62, 0xf2, 0x7d, 0x48, 0x23, 0x40, 0x02);
    FCML_I32("vpmovsxwd zmm0{k1},ymm4", 0x62, 0xf2, 0x7d, 0x49, 0x23, 0xc4);
    FCML_I32("vpmovsxwd zmm0{k1},ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x49, 0x23, 0x00);
    FCML_I32("vpmovsxwd zmm0{k2}{z},ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xca, 0x23, 0x00);

    FCML_I32_M("vpmovsxwq xmm0,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x24, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x24, 0x00));
    FCML_I64_M("vpmovsxwq xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x24, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x24, 0xc1));

    FCML_I32_M("vpmovsxwq xmm0,dword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x24, 0x40, 0x10), FCML_MI(0xc4, 0xe2, 0x79, 0x24, 0x40, 0x40));
    FCML_I32_M("vpmovsxwq xmm0,xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x24, 0xc3), FCML_MI(0xc4, 0xe2, 0x79, 0x24, 0xc3));
    FCML_I32("vpmovsxwq xmm0{k4},dword ptr [eax]", 0x62, 0xf2, 0x7d, 0x0c, 0x24, 0x00);
    FCML_I32("vpmovsxwq xmm0{k3}{z},dword ptr [eax]", 0x62, 0xf2, 0x7d, 0x8b, 0x24, 0x00);

    FCML_I32_M("vpmovsxwq ymm0,mmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x24, 0x40, 0x08), FCML_MI(0xc4, 0xe2, 0x7d, 0x24, 0x40, 0x40));
    FCML_I32_M("vpmovsxwq ymm0,xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x24, 0xc3), FCML_MI(0xc4, 0xe2, 0x7d, 0x24, 0xc3));
    FCML_I32("vpmovsxwq ymm0{k4},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x2c, 0x24, 0x00);
    FCML_I32("vpmovsxwq ymm0{k3}{z},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xab, 0x24, 0x00);

    FCML_I32("vpmovsxwq zmm0,xmmword ptr [eax+00000040h]", 0x62, 0xf2, 0x7d, 0x48, 0x24, 0x40, 0x04);
    FCML_I32("vpmovsxwq zmm0{k4},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x4c, 0x24, 0x00);
    FCML_I32("vpmovsxwq zmm0{k3}{z},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xcb, 0x24, 0x00);

    FCML_I32_M("vpmovsxdq xmm0,mmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x25, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x25, 0x00));
    FCML_I64_M("vpmovsxdq xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x25, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x25, 0xc1));

    FCML_I32_M("vpmovsxdq xmm0,mmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x25, 0x40, 0x08), FCML_MI(0xc4, 0xe2, 0x79, 0x25, 0x40, 0x40));
    FCML_I32("vpmovsxdq xmm0{k1},xmm4", 0x62, 0xf2, 0x7d, 0x09, 0x25, 0xc4);
    FCML_I32("vpmovsxdq xmm0{k1},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x09, 0x25, 0x00);
    FCML_I32("vpmovsxdq xmm0{k2}{z},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x8a, 0x25, 0x00);

    FCML_I32_M("vpmovsxdq ymm0,xmmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x25, 0x40, 0x04), FCML_MI(0xc4, 0xe2, 0x7d, 0x25, 0x40, 0x40));
    FCML_I32("vpmovsxdq ymm0{k1},xmm4", 0x62, 0xf2, 0x7d, 0x29, 0x25, 0xc4);
    FCML_I32("vpmovsxdq ymm0{k1},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x29, 0x25, 0x00);
    FCML_I32("vpmovsxdq ymm0{k2}{z},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xaa, 0x25, 0x00);

    FCML_I32("vpmovsxdq zmm0,ymmword ptr [eax+00000040h]", 0x62, 0xf2, 0x7d, 0x48, 0x25, 0x40, 0x02);
    FCML_I32("vpmovsxdq zmm0{k1},ymm4", 0x62, 0xf2, 0x7d, 0x49, 0x25, 0xc4);
    FCML_I32("vpmovsxdq zmm0{k1},ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x49, 0x25, 0x00);
    FCML_I32("vpmovsxdq zmm0{k2}{z},ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xca, 0x25, 0x00);

    FCML_I32_M("vpmovsxbw ymm0,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x20, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x20, 0x00));
    FCML_I64_M("vpmovsxbw ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x20, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x20, 0xc1));

    FCML_I32_M("vpmovsxbd ymm0,mmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x21, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x21, 0x00));
    FCML_I64_M("vpmovsxbd ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x21, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x21, 0xc1));

    FCML_I32_M("vpmovsxbq ymm0,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x22, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x22, 0x00));
    FCML_I64_M("vpmovsxbq ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x22, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x22, 0xc1));

    FCML_A64( "pmovsxbw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x20, 0x00 );
    FCML_A64( "pmovsxbw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x20, 0xc1 );
    FCML_A64( "pmovsxbd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x21, 0x00 );
    FCML_A64( "pmovsxbd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x21, 0xc1 );
    FCML_A64( "pmovsxbq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x22, 0x00 );
    FCML_A64( "pmovsxbq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x22, 0xc1 );
    FCML_A64( "pmovsxwd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x23, 0x00 );
    FCML_A64( "pmovsxwd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x23, 0xc1 );
    FCML_A64( "pmovsxwq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x24, 0x00 );
    FCML_A64( "pmovsxwq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x24, 0xc1 );
    FCML_A64( "pmovsxdq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x25, 0x00 );
    FCML_A64( "pmovsxdq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x25, 0xc1 );
    FCML_A64_M("vpmovsxbw (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x20, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x20, 0x00));
    FCML_A64_M("vpmovsxbw %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x20, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x20, 0xc1));
    FCML_A64_M("vpmovsxbd (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x21, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x21, 0x00));
    FCML_A64_M("vpmovsxbd %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x21, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x21, 0xc1));
    FCML_A64_M("vpmovsxbq (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x22, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x22, 0x00));
    FCML_A64_M("vpmovsxbq %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x22, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x22, 0xc1));
    FCML_A64_M("vpmovsxwd (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x23, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x23, 0x00));
    FCML_A64_M("vpmovsxwd %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x23, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x23, 0xc1));
    FCML_A64_M("vpmovsxwq (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x24, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x24, 0x00));
    FCML_A64_M("vpmovsxwq %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x24, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x24, 0xc1));
    FCML_A64_M("vpmovsxdq (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x25, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x25, 0x00));
    FCML_A64_M("vpmovsxdq %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x25, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x25, 0xc1));
    FCML_A64_M("vpmovsxbw (%rax),%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x20, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x20, 0x00));
    FCML_A64_M("vpmovsxbw %xmm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x20, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x20, 0xc1));
    FCML_A64_M("vpmovsxbd (%rax),%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x21, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x21, 0x00));
    FCML_A64_M("vpmovsxbd %xmm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x21, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x21, 0xc1));
    FCML_A64_M("vpmovsxbq (%rax),%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x22, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x22, 0x00));
    FCML_A64_M("vpmovsxbq %xmm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x22, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x22, 0xc1));
}

void fcml_tf_instruction_PMOVZX(void) {

    FCML_I64( "pmovzxbw xmm0,mmword ptr [rax]", 0x66, 0x0F, 0x38, 0x30, 0x00 );
    FCML_I32( "pmovzxbw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x30, 0xC1 );

    FCML_I64( "pmovzxbd xmm0,dword ptr [rax]", 0x66, 0x0F, 0x38, 0x31, 0x00 );
    FCML_I32( "pmovzxbd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x31, 0xC1 );

    FCML_I64( "pmovzxbq xmm0,word ptr [rax]", 0x66, 0x0F, 0x38, 0x32, 0x00 );
    FCML_I32( "pmovzxbq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x32, 0xC1 );

    FCML_I64( "pmovzxwd xmm0,mmword ptr [rax]", 0x66, 0x0F, 0x38, 0x33, 0x00 );
    FCML_I32( "pmovzxwd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x33, 0xC1 );

    FCML_I64( "pmovzxwq xmm0,dword ptr [rax]", 0x66, 0x0F, 0x38, 0x34, 0x00 );
    FCML_I32( "pmovzxwq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x34, 0xC1 );

    FCML_I64( "pmovzxdq xmm0,mmword ptr [rax]", 0x66, 0x0F, 0x38, 0x35, 0x00 );
    FCML_I32( "pmovzxdq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x35, 0xC1 );

    FCML_I32_M("vpmovzxbw xmm0,mmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x30, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x30, 0x00));
    FCML_I64_M("vpmovzxbw xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x30, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x30, 0xc1));
    FCML_I32_M("vpmovzxbd xmm0,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x31, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x31, 0x00));
    FCML_I64_M("vpmovzxbd xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x31, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x31, 0xc1));
    FCML_I32_M("vpmovzxbq xmm0,word ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x32, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x32, 0x00));
    FCML_I64_M("vpmovzxbq xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x32, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x32, 0xc1));
    FCML_I32_M("vpmovzxwd xmm0,mmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x33, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x33, 0x00));
    FCML_I64_M("vpmovzxwd xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x33, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x33, 0xc1));
    FCML_I32_M("vpmovzxwq xmm0,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x34, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x34, 0x00));
    FCML_I64_M("vpmovzxwq xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x34, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x34, 0xc1));
    FCML_I32_M("vpmovzxwq ymm0,mmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x34, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x34, 0x00));
    FCML_I64_M("vpmovzxwq ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x34, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x34, 0xc1));
    FCML_I32_M("vpmovzxdq xmm0,mmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x35, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x35, 0x00));
    FCML_I64_M("vpmovzxdq xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x35, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x35, 0xc1));
    FCML_I32_M("vpmovzxdq ymm0,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x35, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x35, 0x00));
    FCML_I64_M("vpmovzxdq ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x35, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x35, 0xc1));
    FCML_I32_M("vpmovzxbw ymm0,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x30, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x30, 0x00));
    FCML_I64_M("vpmovzxbw ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x30, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x30, 0xc1));
    FCML_I32_M("vpmovzxbd ymm0,mmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x31, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x31, 0x00));
    FCML_I64_M("vpmovzxbd ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x31, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x31, 0xc1));
    FCML_I32_M("vpmovzxbq ymm0,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x32, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x32, 0x00));
    FCML_I64_M("vpmovzxbq ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x32, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x32, 0xc1));
    FCML_I32_M("vpmovzxwd ymm0,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x33, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x33, 0x00));
    FCML_I64_M("vpmovzxwd ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x33, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x33, 0xc1));
    FCML_A64_M("vpmovzxbw (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x30, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x30, 0x00));
    FCML_A64_M("vpmovzxbw %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x30, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x30, 0xc1));
    FCML_A64_M("vpmovzxbd (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x31, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x31, 0x00));
    FCML_A64_M("vpmovzxbd %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x31, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x31, 0xc1));
    FCML_A64_M("vpmovzxbq (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x32, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x32, 0x00));
    FCML_A64_M("vpmovzxbq %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x32, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x32, 0xc1));
    FCML_A64_M("vpmovzxwd (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x33, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x33, 0x00));
    FCML_A64_M("vpmovzxwd %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x33, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x33, 0xc1));
    FCML_A64_M("vpmovzxwq (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x34, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x34, 0x00));
    FCML_A64_M("vpmovzxwq %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x34, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x34, 0xc1));
    FCML_A64_M("vpmovzxdq (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x35, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x35, 0x00));
    FCML_A64_M("vpmovzxdq %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x35, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x35, 0xc1));
    FCML_A64_M("vpmovzxbw (%rax),%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x30, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x30, 0x00));
    FCML_A64_M("vpmovzxbw %xmm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x30, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x30, 0xc1));
    FCML_A64_M("vpmovzxbd (%rax),%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x31, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x31, 0x00));
    FCML_A64_M("vpmovzxbd %xmm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x31, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x31, 0xc1));
    FCML_A64_M("vpmovzxbq (%rax),%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x32, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x32, 0x00));
    FCML_A64_M("vpmovzxbq %xmm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x32, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x32, 0xc1));
    FCML_A64_M("vpmovzxwd (%rax),%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x33, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x33, 0x00));
    FCML_A64_M("vpmovzxwd %xmm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x33, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x33, 0xc1));

    FCML_I32_M("vpmovzxbw xmm0,mmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x30, 0x40, 0x08), FCML_MI(0xc4, 0xe2, 0x79, 0x30, 0x40, 0x40));
    FCML_I32("vpmovzxbw xmm0{k1},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x09, 0x30, 0x00);
    FCML_I32("vpmovzxbw xmm0{k2}{z},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x8a, 0x30, 0x00);
    FCML_I32_M("vpmovzxbw ymm0,xmmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x30, 0x40, 0x04), FCML_MI(0xc4, 0xe2, 0x7d, 0x30, 0x40, 0x40));
    FCML_I32("vpmovzxbw ymm0{k1},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x29, 0x30, 0x00);
    FCML_I32("vpmovzxbw ymm0{k2}{z},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xaa, 0x30, 0x00);
    FCML_I32("vpmovzxbw zmm0,ymmword ptr [eax+00000040h]", 0x62, 0xf2, 0x7d, 0x48, 0x30, 0x40, 0x02);
    FCML_I32("vpmovzxbw zmm0{k1},ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x49, 0x30, 0x00);
    FCML_I32("vpmovzxbw zmm0{k2}{z},ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xca, 0x30, 0x00);

    FCML_I32_M("vpmovzxbd xmm0,dword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x31, 0x40, 0x10), FCML_MI(0xc4, 0xe2, 0x79, 0x31, 0x40, 0x40));
    FCML_I32_M("vpmovzxbd xmm0,xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x31, 0xc3), FCML_MI(0xc4, 0xe2, 0x79, 0x31, 0xc3));
    FCML_I32("vpmovzxbd xmm0{k4},dword ptr [eax]", 0x62, 0xf2, 0x7d, 0x0c, 0x31, 0x00);
    FCML_I32("vpmovzxbd xmm0{k3}{z},dword ptr [eax]", 0x62, 0xf2, 0x7d, 0x8b, 0x31, 0x00);
    FCML_I32_M("vpmovzxbd ymm0,mmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x31, 0x40, 0x08), FCML_MI(0xc4, 0xe2, 0x7d, 0x31, 0x40, 0x40));
    FCML_I32_M("vpmovzxbd ymm0,xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x31, 0xc3), FCML_MI(0xc4, 0xe2, 0x7d, 0x31, 0xc3));
    FCML_I32("vpmovzxbd ymm0{k4},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x2c, 0x31, 0x00);
    FCML_I32("vpmovzxbd ymm0{k3}{z},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xab, 0x31, 0x00);
    FCML_I32("vpmovzxbd zmm0,xmmword ptr [eax+00000040h]", 0x62, 0xf2, 0x7d, 0x48, 0x31, 0x40, 0x04);
    FCML_I32("vpmovzxbd zmm0{k4},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x4c, 0x31, 0x00);
    FCML_I32("vpmovzxbd zmm0{k3}{z},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xcb, 0x31, 0x00);

    FCML_I32_M("vpmovzxbq xmm0,word ptr [eax+00000010h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x32, 0x40, 0x08), FCML_MI(0xc4, 0xe2, 0x79, 0x32, 0x40, 0x10));
    FCML_I32_M("vpmovzxbq xmm0,xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x32, 0xc3), FCML_MI(0xc4, 0xe2, 0x79, 0x32, 0xc3));
    FCML_I32("vpmovzxbq xmm0{k1},word ptr [eax]", 0x62, 0xf2, 0x7d, 0x09, 0x32, 0x00);
    FCML_I32("vpmovzxbq xmm0{k2}{z},word ptr [eax]", 0x62, 0xf2, 0x7d, 0x8a, 0x32, 0x00);
    FCML_I32_M("vpmovzxbq ymm0,dword ptr [eax+00000010h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x32, 0x40, 0x04), FCML_MI(0xc4, 0xe2, 0x7d, 0x32, 0x40, 0x10));
    FCML_I32_M("vpmovzxbq ymm0,xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x32, 0xc3), FCML_MI(0xc4, 0xe2, 0x7d, 0x32, 0xc3));
    FCML_I32("vpmovzxbq ymm0{k1},dword ptr [eax]", 0x62, 0xf2, 0x7d, 0x29, 0x32, 0x00);
    FCML_I32("vpmovzxbq ymm0{k2}{z},dword ptr [eax]", 0x62, 0xf2, 0x7d, 0xaa, 0x32, 0x00);
    FCML_I32("vpmovzxbq zmm0,mmword ptr [eax+00000010h]", 0x62, 0xf2, 0x7d, 0x48, 0x32, 0x40, 0x02);
    FCML_I32("vpmovzxbq zmm0,xmm3", 0x62, 0xf2, 0x7d, 0x48, 0x32, 0xc3);
    FCML_I32("vpmovzxbq zmm0{k1},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x49, 0x32, 0x00);
    FCML_I32("vpmovzxbq zmm0{k2}{z},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xca, 0x32, 0x00);

    FCML_I32_M("vpmovzxwd xmm0,mmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x33, 0x40, 0x08), FCML_MI(0xc4, 0xe2, 0x79, 0x33, 0x40, 0x40));
    FCML_I32("vpmovzxwd xmm0{k1},xmm4", 0x62, 0xf2, 0x7d, 0x09, 0x33, 0xc4);
    FCML_I32("vpmovzxwd xmm0{k1},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x09, 0x33, 0x00);
    FCML_I32("vpmovzxwd xmm0{k2}{z},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x8a, 0x33, 0x00);
    FCML_I32_M("vpmovzxwd ymm0,xmmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x33, 0x40, 0x04), FCML_MI(0xc4, 0xe2, 0x7d, 0x33, 0x40, 0x40));
    FCML_I32("vpmovzxwd ymm0{k1},xmm4", 0x62, 0xf2, 0x7d, 0x29, 0x33, 0xc4);
    FCML_I32("vpmovzxwd ymm0{k1},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x29, 0x33, 0x00);
    FCML_I32("vpmovzxwd ymm0{k2}{z},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xaa, 0x33, 0x00);
    FCML_I32("vpmovzxwd zmm0,ymmword ptr [eax+00000040h]", 0x62, 0xf2, 0x7d, 0x48, 0x33, 0x40, 0x02);
    FCML_I32("vpmovzxwd zmm0{k1},ymm4", 0x62, 0xf2, 0x7d, 0x49, 0x33, 0xc4);
    FCML_I32("vpmovzxwd zmm0{k1},ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x49, 0x33, 0x00);
    FCML_I32("vpmovzxwd zmm0{k2}{z},ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xca, 0x33, 0x00);

    FCML_I32_M("vpmovzxwq xmm0,dword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x34, 0x40, 0x10), FCML_MI(0xc4, 0xe2, 0x79, 0x34, 0x40, 0x40));
    FCML_I32_M("vpmovzxwq xmm0,xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x34, 0xc3), FCML_MI(0xc4, 0xe2, 0x79, 0x34, 0xc3));
    FCML_I32("vpmovzxwq xmm0{k4},dword ptr [eax]", 0x62, 0xf2, 0x7d, 0x0c, 0x34, 0x00);
    FCML_I32("vpmovzxwq xmm0{k3}{z},dword ptr [eax]", 0x62, 0xf2, 0x7d, 0x8b, 0x34, 0x00);
    FCML_I32_M("vpmovzxwq ymm0,mmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x34, 0x40, 0x08), FCML_MI(0xc4, 0xe2, 0x7d, 0x34, 0x40, 0x40));
    FCML_I32_M("vpmovzxwq ymm0,xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x34, 0xc3), FCML_MI(0xc4, 0xe2, 0x7d, 0x34, 0xc3));
    FCML_I32("vpmovzxwq ymm0{k4},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x2c, 0x34, 0x00);
    FCML_I32("vpmovzxwq ymm0{k3}{z},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xab, 0x34, 0x00);
    FCML_I32("vpmovzxwq zmm0,xmmword ptr [eax+00000040h]", 0x62, 0xf2, 0x7d, 0x48, 0x34, 0x40, 0x04);
    FCML_I32("vpmovzxwq zmm0{k4},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x4c, 0x34, 0x00);
    FCML_I32("vpmovzxwq zmm0{k3}{z},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xcb, 0x34, 0x00);

    FCML_I32_M("vpmovzxdq xmm0,mmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x35, 0x40, 0x08), FCML_MI(0xc4, 0xe2, 0x79, 0x35, 0x40, 0x40));
    FCML_I32("vpmovzxdq xmm0{k1},xmm4", 0x62, 0xf2, 0x7d, 0x09, 0x35, 0xc4);
    FCML_I32("vpmovzxdq xmm0{k1},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x09, 0x35, 0x00);
    FCML_I32("vpmovzxdq xmm0{k2}{z},mmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x8a, 0x35, 0x00);
    FCML_I32_M("vpmovzxdq ymm0,xmmword ptr [eax+00000040h]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x35, 0x40, 0x04), FCML_MI(0xc4, 0xe2, 0x7d, 0x35, 0x40, 0x40));
    FCML_I32("vpmovzxdq ymm0{k1},xmm4", 0x62, 0xf2, 0x7d, 0x29, 0x35, 0xc4);
    FCML_I32("vpmovzxdq ymm0{k1},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x29, 0x35, 0x00);
    FCML_I32("vpmovzxdq ymm0{k2}{z},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xaa, 0x35, 0x00);
    FCML_I32("vpmovzxdq zmm0,ymmword ptr [eax+00000040h]", 0x62, 0xf2, 0x7d, 0x48, 0x35, 0x40, 0x02);
    FCML_I32("vpmovzxdq zmm0{k1},ymm4", 0x62, 0xf2, 0x7d, 0x49, 0x35, 0xc4);
    FCML_I32("vpmovzxdq zmm0{k1},ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x49, 0x35, 0x00);
    FCML_I32("vpmovzxdq zmm0{k2}{z},ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xca, 0x35, 0x00);
}

void fcml_tf_instruction_PMULDQ(void) {

    FCML_I64( "pmuldq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x28, 0x00 );
    FCML_I32( "pmuldq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x28, 0xC1 );
    FCML_A64( "pmuldq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x28, 0x00 );
    FCML_A64( "pmuldq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x28, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmuldq (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x28, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x28, 0x38));
    FCML_I64_M("vpmuldq xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x28, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x28, 0x38));
    FCML_A32_M("vpmuldq (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x28, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x28, 0x38));
    FCML_I32_M("vpmuldq xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x28, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x28, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmuldq (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x28, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x28, 0x38));
    FCML_I64_M("vpmuldq ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x28, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x28, 0x38));
    FCML_A32_M("vpmuldq (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x28, 0x28, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x28, 0x38));
    FCML_I32_M("vpmuldq ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x28, 0x28, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x28, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmuldq (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x28, 0x38);
    FCML_I64("vpmuldq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x28, 0x38);
    FCML_A32("vpmuldq (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x28, 0x38);
    FCML_I32("vpmuldq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x28, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmuldq %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x28, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x28, 0xf9));
    FCML_I64_M("vpmuldq xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x28, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x28, 0xf9));
    FCML_A32_M("vpmuldq %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x28, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x28, 0xf9));
    FCML_I32_M("vpmuldq xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x28, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x28, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmuldq %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x28, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x28, 0xf6));
    FCML_I64_M("vpmuldq ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x28, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x28, 0xf6));
    FCML_A32_M("vpmuldq %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x28, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x28, 0xf5));
    FCML_I32_M("vpmuldq ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x28, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x28, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmuldq %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x28, 0xf4);
    FCML_I64("vpmuldq zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x28, 0xf4);
    FCML_A32("vpmuldq %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x28, 0xf4);
    FCML_I32("vpmuldq zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x28, 0xf4);
    /* disp8 */
    FCML_I32("vpmuldq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x28, 0x4c, 0x24, 0x08);
    FCML_A32("vpmuldq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x28, 0x4c, 0x24, 0x08);
    FCML_I64("vpmuldq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x28, 0x4c, 0x24, 0x08);
    FCML_A64("vpmuldq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x28, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpmuldq ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x28, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x28, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmuldq 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x28, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x28, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpmuldq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x28, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x28, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmuldq 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x28, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x28, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmuldq xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x28, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x28, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmuldq 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x28, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x28, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmuldq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x28, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x28, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmuldq 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x28, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x28, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpmuldq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x28, 0x14, 0x01);
    FCML_I64("vpmuldq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x28, 0x14, 0x01);
    FCML_A32("vpmuldq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x28, 0x14, 0x01);
    FCML_I32("vpmuldq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x28, 0x14, 0x01);
    FCML_A64("vpmuldq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x28, 0x14, 0x01);
    FCML_I64("vpmuldq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x28, 0x14, 0x01);
    FCML_A32("vpmuldq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x28, 0x14, 0x01);
    FCML_I32("vpmuldq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x28, 0x14, 0x01);
    FCML_A64("vpmuldq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x28, 0x14, 0x01);
    FCML_I64("vpmuldq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x28, 0x14, 0x01);
    FCML_A32("vpmuldq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x28, 0x14, 0x01);
    FCML_I32("vpmuldq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x28, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmuldq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x28, 0x14, 0x01);
    FCML_I64("vpmuldq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x28, 0x14, 0x01);
    FCML_A32("vpmuldq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x28, 0x14, 0x01);
    FCML_I32("vpmuldq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x28, 0x14, 0x01);
    FCML_A64("vpmuldq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x28, 0x14, 0x01);
    FCML_I64("vpmuldq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x28, 0x14, 0x01);
    FCML_A32("vpmuldq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x28, 0x14, 0x01);
    FCML_I32("vpmuldq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x28, 0x14, 0x01);
    FCML_A64("vpmuldq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x28, 0x14, 0x01);
    FCML_I64("vpmuldq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x28, 0x14, 0x01);
    FCML_A32("vpmuldq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x28, 0x14, 0x01);
    FCML_I32("vpmuldq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x28, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpmuldq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x28, 0x3e);
    FCML_A64("vpmuldq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x28, 0x3e);
    FCML_I64("vpmuldq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x28, 0x3e);
    FCML_A64("vpmuldq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x28, 0x3e);
    FCML_I64("vpmuldq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x28, 0x3e);
    FCML_A64("vpmuldq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x28, 0x3e);
    FCML_A32("vpmuldq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x28, 0x0e);
    FCML_I32("vpmuldq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x28, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpmuldq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x28, 0x3e);
    FCML_I64("vpmuldq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x28, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpmuldq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x28, 0x4c, 0x24, 0x08);
    FCML_A32("vpmuldq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x28, 0x4c, 0x24, 0x08);
    FCML_I64("vpmuldq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x28, 0x4c, 0x24, 0x08);
    FCML_A64("vpmuldq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x28, 0x4c, 0x24, 0x08);
    FCML_I32("vpmuldq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x28, 0x4c, 0x24, 0x08);
    FCML_A32("vpmuldq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x28, 0x4c, 0x24, 0x08);
    FCML_I64("vpmuldq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x28, 0x4c, 0x24, 0x08);
    FCML_A64("vpmuldq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x28, 0x4c, 0x24, 0x08);
    FCML_I32("vpmuldq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x28, 0x4c, 0x24, 0x08);
    FCML_A32("vpmuldq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x28, 0x4c, 0x24, 0x08);
    FCML_I64("vpmuldq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x28, 0x4c, 0x24, 0x08);
    FCML_A64("vpmuldq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x28, 0x4c, 0x24, 0x08);

}

void fcml_tf_instruction_PMULHRSW(void) {

    FCML_I64( "pmulhrsw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x0B, 0x00 );
    FCML_I32( "pmulhrsw mm0,mm1", 0x0F, 0x38, 0x0B, 0xC1 );

    FCML_I64( "pmulhrsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x0B, 0x00 );
    FCML_I32( "pmulhrsw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x0B, 0xC1 );

    FCML_A64( "pmulhrsw (%rax),%mm0", 0x0f, 0x38, 0x0b, 0x00 );
    FCML_A64( "pmulhrsw %mm1,%mm0", 0x0f, 0x38, 0x0b, 0xc1 );
    FCML_A64( "pmulhrsw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x0b, 0x00 );
    FCML_A64( "pmulhrsw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x0b, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmulhrsw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x0b, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x0b, 0x38));
    FCML_I64_M("vpmulhrsw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x0b, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x0b, 0x38));
    FCML_A32_M("vpmulhrsw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x0b, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x0b, 0x38));
    FCML_I32_M("vpmulhrsw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x0b, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x0b, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmulhrsw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x0b, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x0b, 0x38));
    FCML_I64_M("vpmulhrsw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x0b, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x0b, 0x38));
    FCML_A32_M("vpmulhrsw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x0b, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x0b, 0x38));
    FCML_I32_M("vpmulhrsw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x0b, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x0b, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmulhrsw (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x0b, 0x38);
    FCML_I64("vpmulhrsw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x0b, 0x38);
    FCML_A32("vpmulhrsw (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x0b, 0x38);
    FCML_I32("vpmulhrsw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x0b, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmulhrsw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x0b, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x0b, 0xf9));
    FCML_I64_M("vpmulhrsw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x0b, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x0b, 0xf9));
    FCML_A32_M("vpmulhrsw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x0b, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x0b, 0xf9));
    FCML_I32_M("vpmulhrsw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x0b, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x0b, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmulhrsw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x0b, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x0b, 0xf6));
    FCML_I64_M("vpmulhrsw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x0b, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x0b, 0xf6));
    FCML_A32_M("vpmulhrsw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x0b, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x0b, 0xf5));
    FCML_I32_M("vpmulhrsw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x0b, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x0b, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_I32("vpmulhrsw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x0b, 0x4c, 0x24, 0x08);
    FCML_A32("vpmulhrsw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x0b, 0x4c, 0x24, 0x08);
    FCML_I64("vpmulhrsw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x0b, 0x4c, 0x24, 0x08);
    FCML_A64("vpmulhrsw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x0b, 0x4c, 0x24, 0x08);    FCML_I32_M("vpmulhrsw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x0b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x0b, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmulhrsw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x0b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x0b, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpmulhrsw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x0b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x0b, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmulhrsw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x0b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x0b, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmulhrsw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x0b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x0b, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmulhrsw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x0b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x0b, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmulhrsw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x0b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x0b, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmulhrsw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x0b, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x0b, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpmulhrsw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x0b, 0x14, 0x01);
    FCML_I64("vpmulhrsw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x0b, 0x14, 0x01);
    FCML_A32("vpmulhrsw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x0b, 0x14, 0x01);
    FCML_I32("vpmulhrsw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x0b, 0x14, 0x01);
    FCML_A64("vpmulhrsw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x0b, 0x14, 0x01);
    FCML_I64("vpmulhrsw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x0b, 0x14, 0x01);
    FCML_A32("vpmulhrsw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x0b, 0x14, 0x01);
    FCML_I32("vpmulhrsw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x0b, 0x14, 0x01);
    FCML_A64("vpmulhrsw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x0b, 0x14, 0x01);
    FCML_I64("vpmulhrsw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x0b, 0x14, 0x01);
    FCML_A32("vpmulhrsw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x0b, 0x14, 0x01);
    FCML_I32("vpmulhrsw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x0b, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmulhrsw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x0b, 0x14, 0x01);
    FCML_I64("vpmulhrsw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x0b, 0x14, 0x01);
    FCML_A32("vpmulhrsw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x0b, 0x14, 0x01);
    FCML_I32("vpmulhrsw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x0b, 0x14, 0x01);
    FCML_A64("vpmulhrsw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x0b, 0x14, 0x01);
    FCML_I64("vpmulhrsw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x0b, 0x14, 0x01);
    FCML_A32("vpmulhrsw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x0b, 0x14, 0x01);
    FCML_I32("vpmulhrsw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x0b, 0x14, 0x01);
    FCML_A64("vpmulhrsw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x0b, 0x14, 0x01);
    FCML_I64("vpmulhrsw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x0b, 0x14, 0x01);
    FCML_A32("vpmulhrsw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x0b, 0x14, 0x01);
    FCML_I32("vpmulhrsw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x0b, 0x14, 0x01);
}

void fcml_tf_instruction_PMULHUW(void) {

    FCML_I64( "pmulhuw mm0,mmword ptr [rax]", 0x0F, 0xE4, 0x00 );
    FCML_I32( "pmulhuw mm0,mm1", 0x0F, 0xE4, 0xC1 );

    FCML_I64( "pmulhuw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE4, 0x00 );
    FCML_I32( "pmulhuw xmm0,xmm1", 0x66, 0x0F, 0xE4, 0xC1 );

    FCML_A64( "pmulhuw (%rax),%mm0", 0x0f, 0xe4, 0x00 );
    FCML_A64( "pmulhuw %mm1,%mm0", 0x0f, 0xe4, 0xc1 );
    FCML_A64( "pmulhuw (%rax),%xmm0", 0x66, 0x0f, 0xe4, 0x00 );
    FCML_A64( "pmulhuw %xmm1,%xmm0", 0x66, 0x0f, 0xe4, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmulhuw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe4, 0x38), FCML_MI(0xc5, 0x41, 0xe4, 0x38));
    FCML_I64_M("vpmulhuw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe4, 0x38), FCML_MI(0xc5, 0x41, 0xe4, 0x38));
    FCML_A32_M("vpmulhuw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xe4, 0x38), FCML_MI(0xc5, 0xc9, 0xe4, 0x38));
    FCML_I32_M("vpmulhuw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xe4, 0x38), FCML_MI(0xc5, 0xc9, 0xe4, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmulhuw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe4, 0x38), FCML_MI(0xc5, 0x45, 0xe4, 0x38));
    FCML_I64_M("vpmulhuw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe4, 0x38), FCML_MI(0xc5, 0x45, 0xe4, 0x38));
    FCML_A32_M("vpmulhuw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xe4, 0x38), FCML_MI(0xc5, 0xd5, 0xe4, 0x38));
    FCML_I32_M("vpmulhuw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xe4, 0x38), FCML_MI(0xc5, 0xd5, 0xe4, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmulhuw (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xe4, 0x38);
    FCML_I64("vpmulhuw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xe4, 0x38);
    FCML_A32("vpmulhuw (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xe4, 0x38);
    FCML_I32("vpmulhuw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xe4, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmulhuw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe4, 0xf9), FCML_MI(0xc5, 0x41, 0xe4, 0xf9));
    FCML_I64_M("vpmulhuw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe4, 0xf9), FCML_MI(0xc5, 0x41, 0xe4, 0xf9));
    FCML_A32_M("vpmulhuw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe4, 0xf9), FCML_MI(0xc5, 0xe9, 0xe4, 0xf9));
    FCML_I32_M("vpmulhuw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe4, 0xf9), FCML_MI(0xc5, 0xe9, 0xe4, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmulhuw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe4, 0xf6), FCML_MI(0xc5, 0x45, 0xe4, 0xf6));
    FCML_I64_M("vpmulhuw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe4, 0xf6), FCML_MI(0xc5, 0x45, 0xe4, 0xf6));
    FCML_A32_M("vpmulhuw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xe4, 0xf5), FCML_MI(0xc5, 0xe5, 0xe4, 0xf5));
    FCML_I32_M("vpmulhuw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xe4, 0xf5), FCML_MI(0xc5, 0xe5, 0xe4, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmulhuw %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xe4, 0xf4);
    FCML_I64("vpmulhuw zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xe4, 0xf4);
    FCML_A32("vpmulhuw %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xe4, 0xf4);
    FCML_I32("vpmulhuw zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xe4, 0xf4);
    /* disp8 */
    FCML_I32("vpmulhuw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xe4, 0x4c, 0x24, 0x08);
    FCML_A32("vpmulhuw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xe4, 0x4c, 0x24, 0x08);
    FCML_I64("vpmulhuw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xe4, 0x4c, 0x24, 0x08);
    FCML_A64("vpmulhuw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xe4, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpmulhuw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe4, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmulhuw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe4, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpmulhuw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe4, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmulhuw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe4, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmulhuw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe4, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmulhuw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe4, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmulhuw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe4, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmulhuw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe4, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpmulhuw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xe4, 0x14, 0x01);
    FCML_I64("vpmulhuw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xe4, 0x14, 0x01);
    FCML_A32("vpmulhuw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xe4, 0x14, 0x01);
    FCML_I32("vpmulhuw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xe4, 0x14, 0x01);
    FCML_A64("vpmulhuw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xe4, 0x14, 0x01);
    FCML_I64("vpmulhuw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xe4, 0x14, 0x01);
    FCML_A32("vpmulhuw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xe4, 0x14, 0x01);
    FCML_I32("vpmulhuw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xe4, 0x14, 0x01);
    FCML_A64("vpmulhuw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xe4, 0x14, 0x01);
    FCML_I64("vpmulhuw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xe4, 0x14, 0x01);
    FCML_A32("vpmulhuw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xe4, 0x14, 0x01);
    FCML_I32("vpmulhuw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xe4, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmulhuw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xe4, 0x14, 0x01);
    FCML_I64("vpmulhuw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xe4, 0x14, 0x01);
    FCML_A32("vpmulhuw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xe4, 0x14, 0x01);
    FCML_I32("vpmulhuw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xe4, 0x14, 0x01);
    FCML_A64("vpmulhuw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xe4, 0x14, 0x01);
    FCML_I64("vpmulhuw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xe4, 0x14, 0x01);
    FCML_A32("vpmulhuw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xe4, 0x14, 0x01);
    FCML_I32("vpmulhuw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xe4, 0x14, 0x01);
    FCML_A64("vpmulhuw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xe4, 0x14, 0x01);
    FCML_I64("vpmulhuw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xe4, 0x14, 0x01);
    FCML_A32("vpmulhuw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xe4, 0x14, 0x01);
    FCML_I32("vpmulhuw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xe4, 0x14, 0x01);
}

void fcml_tf_instruction_PMULHW(void) {

    FCML_I64( "pmulhw mm0,mmword ptr [rax]", 0x0F, 0xE5, 0x00 );
    FCML_I32( "pmulhw mm0,mm1", 0x0F, 0xE5, 0xC1 );

    FCML_I64( "pmulhw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE5, 0x00 );
    FCML_I32( "pmulhw xmm0,xmm1", 0x66, 0x0F, 0xE5, 0xC1 );

    FCML_A64( "pmulhw (%rax),%mm0", 0x0f, 0xe5, 0x00 );
    FCML_A64( "pmulhw %mm1,%mm0", 0x0f, 0xe5, 0xc1 );
    FCML_A64( "pmulhw (%rax),%xmm0", 0x66, 0x0f, 0xe5, 0x00 );
    FCML_A64( "pmulhw %xmm1,%xmm0", 0x66, 0x0f, 0xe5, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmulhw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe5, 0x38), FCML_MI(0xc5, 0x41, 0xe5, 0x38));
    FCML_I64_M("vpmulhw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe5, 0x38), FCML_MI(0xc5, 0x41, 0xe5, 0x38));
    FCML_A32_M("vpmulhw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xe5, 0x38), FCML_MI(0xc5, 0xc9, 0xe5, 0x38));
    FCML_I32_M("vpmulhw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xe5, 0x38), FCML_MI(0xc5, 0xc9, 0xe5, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmulhw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe5, 0x38), FCML_MI(0xc5, 0x45, 0xe5, 0x38));
    FCML_I64_M("vpmulhw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe5, 0x38), FCML_MI(0xc5, 0x45, 0xe5, 0x38));
    FCML_A32_M("vpmulhw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xe5, 0x38), FCML_MI(0xc5, 0xd5, 0xe5, 0x38));
    FCML_I32_M("vpmulhw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xe5, 0x38), FCML_MI(0xc5, 0xd5, 0xe5, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmulhw (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xe5, 0x38);
    FCML_I64("vpmulhw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xe5, 0x38);
    FCML_A32("vpmulhw (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xe5, 0x38);
    FCML_I32("vpmulhw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xe5, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmulhw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe5, 0xf9), FCML_MI(0xc5, 0x41, 0xe5, 0xf9));
    FCML_I64_M("vpmulhw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe5, 0xf9), FCML_MI(0xc5, 0x41, 0xe5, 0xf9));
    FCML_A32_M("vpmulhw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe5, 0xf9), FCML_MI(0xc5, 0xe9, 0xe5, 0xf9));
    FCML_I32_M("vpmulhw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe5, 0xf9), FCML_MI(0xc5, 0xe9, 0xe5, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmulhw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe5, 0xf6), FCML_MI(0xc5, 0x45, 0xe5, 0xf6));
    FCML_I64_M("vpmulhw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe5, 0xf6), FCML_MI(0xc5, 0x45, 0xe5, 0xf6));
    FCML_A32_M("vpmulhw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xe5, 0xf5), FCML_MI(0xc5, 0xe5, 0xe5, 0xf5));
    FCML_I32_M("vpmulhw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xe5, 0xf5), FCML_MI(0xc5, 0xe5, 0xe5, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmulhw %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xe5, 0xf4);
    FCML_I64("vpmulhw zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xe5, 0xf4);
    FCML_A32("vpmulhw %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xe5, 0xf4);
    FCML_I32("vpmulhw zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xe5, 0xf4);
    /* disp8 */
    FCML_I32("vpmulhw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xe5, 0x4c, 0x24, 0x08);
    FCML_A32("vpmulhw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xe5, 0x4c, 0x24, 0x08);
    FCML_I64("vpmulhw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xe5, 0x4c, 0x24, 0x08);
    FCML_A64("vpmulhw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xe5, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpmulhw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe5, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmulhw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe5, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpmulhw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe5, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmulhw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe5, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmulhw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe5, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmulhw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe5, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmulhw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe5, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmulhw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe5, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpmulhw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xe5, 0x14, 0x01);
    FCML_I64("vpmulhw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xe5, 0x14, 0x01);
    FCML_A32("vpmulhw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xe5, 0x14, 0x01);
    FCML_I32("vpmulhw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xe5, 0x14, 0x01);
    FCML_A64("vpmulhw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xe5, 0x14, 0x01);
    FCML_I64("vpmulhw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xe5, 0x14, 0x01);
    FCML_A32("vpmulhw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xe5, 0x14, 0x01);
    FCML_I32("vpmulhw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xe5, 0x14, 0x01);
    FCML_A64("vpmulhw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xe5, 0x14, 0x01);
    FCML_I64("vpmulhw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xe5, 0x14, 0x01);
    FCML_A32("vpmulhw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xe5, 0x14, 0x01);
    FCML_I32("vpmulhw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xe5, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmulhw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xe5, 0x14, 0x01);
    FCML_I64("vpmulhw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xe5, 0x14, 0x01);
    FCML_A32("vpmulhw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xe5, 0x14, 0x01);
    FCML_I32("vpmulhw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xe5, 0x14, 0x01);
    FCML_A64("vpmulhw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xe5, 0x14, 0x01);
    FCML_I64("vpmulhw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xe5, 0x14, 0x01);
    FCML_A32("vpmulhw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xe5, 0x14, 0x01);
    FCML_I32("vpmulhw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xe5, 0x14, 0x01);
    FCML_A64("vpmulhw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xe5, 0x14, 0x01);
    FCML_I64("vpmulhw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xe5, 0x14, 0x01);
    FCML_A32("vpmulhw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xe5, 0x14, 0x01);
    FCML_I32("vpmulhw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xe5, 0x14, 0x01);
}

void fcml_tf_instruction_PMULUDQ(void) {

    FCML_I64( "pmuludq mm0,mmword ptr [rax]", 0x0F, 0xF4, 0x00 );
    FCML_I32( "pmuludq mm0,mm1", 0x0F, 0xF4, 0xC1 );
    FCML_I64( "pmuludq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF4, 0x00 );
    FCML_I32( "pmuludq xmm0,xmm1", 0x66, 0x0F, 0xF4, 0xC1 );
    FCML_A64( "pmuludq (%rax),%mm0", 0x0f, 0xf4, 0x00 );
    FCML_A64( "pmuludq %mm1,%mm0", 0x0f, 0xf4, 0xc1 );
    FCML_A64( "pmuludq (%rax),%xmm0", 0x66, 0x0f, 0xf4, 0x00 );
    FCML_A64( "pmuludq %xmm1,%xmm0", 0x66, 0x0f, 0xf4, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmuludq (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0xf4, 0x38), FCML_MI(0xc5, 0x41, 0xf4, 0x38));
    FCML_I64_M("vpmuludq xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0xf4, 0x38), FCML_MI(0xc5, 0x41, 0xf4, 0x38));
    FCML_A32_M("vpmuludq (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0xf4, 0x38), FCML_MI(0xc5, 0xc9, 0xf4, 0x38));
    FCML_I32_M("vpmuludq xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0xf4, 0x38), FCML_MI(0xc5, 0xc9, 0xf4, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmuludq (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0xf4, 0x38), FCML_MI(0xc5, 0x45, 0xf4, 0x38));
    FCML_I64_M("vpmuludq ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0xf4, 0x38), FCML_MI(0xc5, 0x45, 0xf4, 0x38));
    FCML_A32_M("vpmuludq (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0xd5, 0x28, 0xf4, 0x38), FCML_MI(0xc5, 0xd5, 0xf4, 0x38));
    FCML_I32_M("vpmuludq ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0xd5, 0x28, 0xf4, 0x38), FCML_MI(0xc5, 0xd5, 0xf4, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmuludq (%rax),%zmm7,%zmm15", 0x62, 0x71, 0xc5, 0x48, 0xf4, 0x38);
    FCML_I64("vpmuludq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0xc5, 0x48, 0xf4, 0x38);
    FCML_A32("vpmuludq (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0xe5, 0x48, 0xf4, 0x38);
    FCML_I32("vpmuludq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0xe5, 0x48, 0xf4, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmuludq %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0xf4, 0xf9), FCML_MI(0xc5, 0x41, 0xf4, 0xf9));
    FCML_I64_M("vpmuludq xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0xf4, 0xf9), FCML_MI(0xc5, 0x41, 0xf4, 0xf9));
    FCML_A32_M("vpmuludq %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xf4, 0xf9), FCML_MI(0xc5, 0xe9, 0xf4, 0xf9));
    FCML_I32_M("vpmuludq xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xf4, 0xf9), FCML_MI(0xc5, 0xe9, 0xf4, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmuludq %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0xf4, 0xf6), FCML_MI(0xc5, 0x45, 0xf4, 0xf6));
    FCML_I64_M("vpmuludq ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0xf4, 0xf6), FCML_MI(0xc5, 0x45, 0xf4, 0xf6));
    FCML_A32_M("vpmuludq %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0xe5, 0x28, 0xf4, 0xf5), FCML_MI(0xc5, 0xe5, 0xf4, 0xf5));
    FCML_I32_M("vpmuludq ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0xe5, 0x28, 0xf4, 0xf5), FCML_MI(0xc5, 0xe5, 0xf4, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmuludq %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x85, 0x48, 0xf4, 0xf4);
    FCML_I64("vpmuludq zmm6,zmm15,zmm4", 0x62, 0xf1, 0x85, 0x48, 0xf4, 0xf4);
    FCML_A32("vpmuludq %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0xcd, 0x48, 0xf4, 0xf4);
    FCML_I32("vpmuludq zmm6,zmm6,zmm4", 0x62, 0xf1, 0xcd, 0x48, 0xf4, 0xf4);
    /* disp8 */
    FCML_I32("vpmuludq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0xed, 0x48, 0xf4, 0x4c, 0x24, 0x08);
    FCML_A32("vpmuludq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x48, 0xf4, 0x4c, 0x24, 0x08);
    FCML_I64("vpmuludq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0xed, 0x48, 0xf4, 0x4c, 0x24, 0x08);
    FCML_A64("vpmuludq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x48, 0xf4, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpmuludq ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0xf4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf4, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmuludq 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0xf4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf4, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpmuludq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0xf4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf4, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmuludq 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0xf4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf4, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmuludq xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xf4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf4, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmuludq 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xf4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf4, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmuludq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xf4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf4, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmuludq 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xf4, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf4, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpmuludq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x8d, 0x8c, 0xf4, 0x14, 0x01);
    FCML_I64("vpmuludq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x8c, 0xf4, 0x14, 0x01);
    FCML_A32("vpmuludq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0x8d, 0xf4, 0x14, 0x01);
    FCML_I32("vpmuludq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x8d, 0xf4, 0x14, 0x01);
    FCML_A64("vpmuludq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x8d, 0xac, 0xf4, 0x14, 0x01);
    FCML_I64("vpmuludq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0xac, 0xf4, 0x14, 0x01);
    FCML_A32("vpmuludq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0xad, 0xf4, 0x14, 0x01);
    FCML_I32("vpmuludq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0xad, 0xf4, 0x14, 0x01);
    FCML_A64("vpmuludq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x8d, 0xcc, 0xf4, 0x14, 0x01);
    FCML_I64("vpmuludq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0xcc, 0xf4, 0x14, 0x01);
    FCML_A32("vpmuludq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0xcd, 0xf4, 0x14, 0x01);
    FCML_I32("vpmuludq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0xcd, 0xf4, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmuludq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x8d, 0x0c, 0xf4, 0x14, 0x01);
    FCML_I64("vpmuludq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x0c, 0xf4, 0x14, 0x01);
    FCML_A32("vpmuludq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0xc5, 0x0d, 0xf4, 0x14, 0x01);
    FCML_I32("vpmuludq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x0d, 0xf4, 0x14, 0x01);
    FCML_A64("vpmuludq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x8d, 0x2c, 0xf4, 0x14, 0x01);
    FCML_I64("vpmuludq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x2c, 0xf4, 0x14, 0x01);
    FCML_A32("vpmuludq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0xc5, 0x2d, 0xf4, 0x14, 0x01);
    FCML_I32("vpmuludq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x2d, 0xf4, 0x14, 0x01);
    FCML_A64("vpmuludq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x8d, 0x4c, 0xf4, 0x14, 0x01);
    FCML_I64("vpmuludq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x4c, 0xf4, 0x14, 0x01);
    FCML_A32("vpmuludq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0xc5, 0x4d, 0xf4, 0x14, 0x01);
    FCML_I32("vpmuludq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x4d, 0xf4, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpmuludq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xd5, 0x50, 0xf4, 0x3e);
    FCML_A64("vpmuludq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x61, 0xd5, 0x50, 0xf4, 0x3e);
    FCML_I64("vpmuludq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xd5, 0x30, 0xf4, 0x3e);
    FCML_A64("vpmuludq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x61, 0xd5, 0x30, 0xf4, 0x3e);
    FCML_I64("vpmuludq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x61, 0xd5, 0x10, 0xf4, 0x3e);
    FCML_A64("vpmuludq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x61, 0xd5, 0x10, 0xf4, 0x3e);
    FCML_A32("vpmuludq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0xf4, 0x0e);
    FCML_I32("vpmuludq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0xf4, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpmuludq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0xd5, 0xb7, 0xf4, 0x3e);
    FCML_I64("vpmuludq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xd5, 0xb7, 0xf4, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpmuludq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0xf4, 0x4c, 0x24, 0x08);
    FCML_A32("vpmuludq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0xf4, 0x4c, 0x24, 0x08);
    FCML_I64("vpmuludq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0xf4, 0x4c, 0x24, 0x08);
    FCML_A64("vpmuludq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0xf4, 0x4c, 0x24, 0x08);
    FCML_I32("vpmuludq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf1, 0xed, 0x38, 0xf4, 0x4c, 0x24, 0x08);
    FCML_A32("vpmuludq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x38, 0xf4, 0x4c, 0x24, 0x08);
    FCML_I64("vpmuludq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf1, 0xed, 0x38, 0xf4, 0x4c, 0x24, 0x08);
    FCML_A64("vpmuludq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x38, 0xf4, 0x4c, 0x24, 0x08);
    FCML_I32("vpmuludq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf1, 0xed, 0x18, 0xf4, 0x4c, 0x24, 0x08);
    FCML_A32("vpmuludq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x18, 0xf4, 0x4c, 0x24, 0x08);
    FCML_I64("vpmuludq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf1, 0xed, 0x18, 0xf4, 0x4c, 0x24, 0x08);
    FCML_A64("vpmuludq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x18, 0xf4, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PMULLW(void) {

    FCML_I64( "pmullw mm0,mmword ptr [rax]", 0x0F, 0xD5, 0x00 );
    FCML_I32( "pmullw mm0,mm1", 0x0F, 0xD5, 0xC1 );
    FCML_I64( "pmullw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xD5, 0x00 );
    FCML_I32( "pmullw xmm0,xmm1", 0x66, 0x0F, 0xD5, 0xC1 );
    FCML_A64( "pmullw (%rax),%mm0", 0x0f, 0xd5, 0x00 );
    FCML_A64( "pmullw %mm1,%mm0", 0x0f, 0xd5, 0xc1 );
    FCML_A64( "pmullw (%rax),%xmm0", 0x66, 0x0f, 0xd5, 0x00 );
    FCML_A64( "pmullw %xmm1,%xmm0", 0x66, 0x0f, 0xd5, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmullw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xd5, 0x38), FCML_MI(0xc5, 0x41, 0xd5, 0x38));
    FCML_I64_M("vpmullw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xd5, 0x38), FCML_MI(0xc5, 0x41, 0xd5, 0x38));
    FCML_A32_M("vpmullw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xd5, 0x38), FCML_MI(0xc5, 0xc9, 0xd5, 0x38));
    FCML_I32_M("vpmullw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xd5, 0x38), FCML_MI(0xc5, 0xc9, 0xd5, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmullw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xd5, 0x38), FCML_MI(0xc5, 0x45, 0xd5, 0x38));
    FCML_I64_M("vpmullw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xd5, 0x38), FCML_MI(0xc5, 0x45, 0xd5, 0x38));
    FCML_A32_M("vpmullw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xd5, 0x38), FCML_MI(0xc5, 0xd5, 0xd5, 0x38));
    FCML_I32_M("vpmullw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xd5, 0x38), FCML_MI(0xc5, 0xd5, 0xd5, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmullw (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xd5, 0x38);
    FCML_I64("vpmullw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xd5, 0x38);
    FCML_A32("vpmullw (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xd5, 0x38);
    FCML_I32("vpmullw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xd5, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmullw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xd5, 0xf9), FCML_MI(0xc5, 0x41, 0xd5, 0xf9));
    FCML_I64_M("vpmullw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xd5, 0xf9), FCML_MI(0xc5, 0x41, 0xd5, 0xf9));
    FCML_A32_M("vpmullw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd5, 0xf9), FCML_MI(0xc5, 0xe9, 0xd5, 0xf9));
    FCML_I32_M("vpmullw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd5, 0xf9), FCML_MI(0xc5, 0xe9, 0xd5, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmullw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xd5, 0xf6), FCML_MI(0xc5, 0x45, 0xd5, 0xf6));
    FCML_I64_M("vpmullw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xd5, 0xf6), FCML_MI(0xc5, 0x45, 0xd5, 0xf6));
    FCML_A32_M("vpmullw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xd5, 0xf5), FCML_MI(0xc5, 0xe5, 0xd5, 0xf5));
    FCML_I32_M("vpmullw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xd5, 0xf5), FCML_MI(0xc5, 0xe5, 0xd5, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmullw %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xd5, 0xf4);
    FCML_I64("vpmullw zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xd5, 0xf4);
    FCML_A32("vpmullw %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xd5, 0xf4);
    FCML_I32("vpmullw zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xd5, 0xf4);
    /* disp8 */
    FCML_I32("vpmullw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xd5, 0x4c, 0x24, 0x08);
    FCML_A32("vpmullw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xd5, 0x4c, 0x24, 0x08);
    FCML_I64("vpmullw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xd5, 0x4c, 0x24, 0x08);
    FCML_A64("vpmullw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xd5, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpmullw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xd5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xd5, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmullw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xd5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xd5, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpmullw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xd5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xd5, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmullw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xd5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xd5, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmullw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xd5, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmullw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xd5, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmullw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xd5, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmullw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd5, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xd5, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpmullw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xd5, 0x14, 0x01);
    FCML_I64("vpmullw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xd5, 0x14, 0x01);
    FCML_A32("vpmullw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xd5, 0x14, 0x01);
    FCML_I32("vpmullw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xd5, 0x14, 0x01);
    FCML_A64("vpmullw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xd5, 0x14, 0x01);
    FCML_I64("vpmullw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xd5, 0x14, 0x01);
    FCML_A32("vpmullw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xd5, 0x14, 0x01);
    FCML_I32("vpmullw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xd5, 0x14, 0x01);
    FCML_A64("vpmullw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xd5, 0x14, 0x01);
    FCML_I64("vpmullw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xd5, 0x14, 0x01);
    FCML_A32("vpmullw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xd5, 0x14, 0x01);
    FCML_I32("vpmullw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xd5, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmullw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xd5, 0x14, 0x01);
    FCML_I64("vpmullw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xd5, 0x14, 0x01);
    FCML_A32("vpmullw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xd5, 0x14, 0x01);
    FCML_I32("vpmullw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xd5, 0x14, 0x01);
    FCML_A64("vpmullw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xd5, 0x14, 0x01);
    FCML_I64("vpmullw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xd5, 0x14, 0x01);
    FCML_A32("vpmullw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xd5, 0x14, 0x01);
    FCML_I32("vpmullw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xd5, 0x14, 0x01);
    FCML_A64("vpmullw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xd5, 0x14, 0x01);
    FCML_I64("vpmullw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xd5, 0x14, 0x01);
    FCML_A32("vpmullw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xd5, 0x14, 0x01);
    FCML_I32("vpmullw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xd5, 0x14, 0x01);
}

void fcml_tf_instruction_VPMULLQ(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpmullq (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x40, 0x38);
    FCML_I64("vpmullq xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x40, 0x38);
    FCML_A32("vpmullq (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x40, 0x38);
    FCML_I32("vpmullq xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x40, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpmullq (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x40, 0x38);
    FCML_I64("vpmullq ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x40, 0x38);
    FCML_A32("vpmullq (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x40, 0x38);
    FCML_I32("vpmullq ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x40, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmullq (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x40, 0x38);
    FCML_I64("vpmullq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x40, 0x38);
    FCML_A32("vpmullq (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x40, 0x38);
    FCML_I32("vpmullq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x40, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpmullq %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x40, 0xf9);
    FCML_I64("vpmullq xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x40, 0xf9);
    FCML_A32("vpmullq %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x40, 0xf9);
    FCML_I32("vpmullq xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x40, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpmullq %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x40, 0xf6);
    FCML_I64("vpmullq ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x40, 0xf6);
    FCML_A32("vpmullq %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x40, 0xf5);
    FCML_I32("vpmullq ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x40, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmullq %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x40, 0xf4);
    FCML_I64("vpmullq zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x40, 0xf4);
    FCML_A32("vpmullq %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x40, 0xf4);
    FCML_I32("vpmullq zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x40, 0xf4);
    /* disp8 */
    FCML_I32("vpmullq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x40, 0x4c, 0x24, 0x08);
    FCML_A32("vpmullq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x40, 0x4c, 0x24, 0x08);
    FCML_I64("vpmullq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x40, 0x4c, 0x24, 0x08);
    FCML_A64("vpmullq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x40, 0x4c, 0x24, 0x08);
    FCML_I32("vpmullq ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x40, 0x4c, 0x24, 0x08);
    FCML_A32("vpmullq 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x40, 0x4c, 0x24, 0x08);
    FCML_I64("vpmullq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x40, 0x4c, 0x24, 0x08);
    FCML_A64("vpmullq 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x40, 0x4c, 0x24, 0x08);
    FCML_I32("vpmullq xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x40, 0x4c, 0x24, 0x08);
    FCML_A32("vpmullq 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x40, 0x4c, 0x24, 0x08);
    FCML_I64("vpmullq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x40, 0x4c, 0x24, 0x08);
    FCML_A64("vpmullq 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x40, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpmullq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x40, 0x14, 0x01);
    FCML_I64("vpmullq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x40, 0x14, 0x01);
    FCML_A32("vpmullq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x40, 0x14, 0x01);
    FCML_I32("vpmullq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x40, 0x14, 0x01);
    FCML_A64("vpmullq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x40, 0x14, 0x01);
    FCML_I64("vpmullq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x40, 0x14, 0x01);
    FCML_A32("vpmullq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x40, 0x14, 0x01);
    FCML_I32("vpmullq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x40, 0x14, 0x01);
    FCML_A64("vpmullq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x40, 0x14, 0x01);
    FCML_I64("vpmullq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x40, 0x14, 0x01);
    FCML_A32("vpmullq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x40, 0x14, 0x01);
    FCML_I32("vpmullq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x40, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmullq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x40, 0x14, 0x01);
    FCML_I64("vpmullq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x40, 0x14, 0x01);
    FCML_A32("vpmullq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x40, 0x14, 0x01);
    FCML_I32("vpmullq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x40, 0x14, 0x01);
    FCML_A64("vpmullq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x40, 0x14, 0x01);
    FCML_I64("vpmullq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x40, 0x14, 0x01);
    FCML_A32("vpmullq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x40, 0x14, 0x01);
    FCML_I32("vpmullq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x40, 0x14, 0x01);
    FCML_A64("vpmullq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x40, 0x14, 0x01);
    FCML_I64("vpmullq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x40, 0x14, 0x01);
    FCML_A32("vpmullq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x40, 0x14, 0x01);
    FCML_I32("vpmullq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x40, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpmullq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x40, 0x3e);
    FCML_A64("vpmullq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x40, 0x3e);
    FCML_I64("vpmullq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x40, 0x3e);
    FCML_A64("vpmullq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x40, 0x3e);
    FCML_I64("vpmullq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x40, 0x3e);
    FCML_A64("vpmullq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x40, 0x3e);
    FCML_A32("vpmullq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x40, 0x0e);
    FCML_I32("vpmullq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x40, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpmullq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x40, 0x3e);
    FCML_I64("vpmullq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x40, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpmullq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x40, 0x4c, 0x24, 0x08);
    FCML_A32("vpmullq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x40, 0x4c, 0x24, 0x08);
    FCML_I64("vpmullq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x40, 0x4c, 0x24, 0x08);
    FCML_A64("vpmullq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x40, 0x4c, 0x24, 0x08);
    FCML_I32("vpmullq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x40, 0x4c, 0x24, 0x08);
    FCML_A32("vpmullq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x40, 0x4c, 0x24, 0x08);
    FCML_I64("vpmullq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x40, 0x4c, 0x24, 0x08);
    FCML_A64("vpmullq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x40, 0x4c, 0x24, 0x08);
    FCML_I32("vpmullq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x40, 0x4c, 0x24, 0x08);
    FCML_A32("vpmullq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x40, 0x4c, 0x24, 0x08);
    FCML_I64("vpmullq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x40, 0x4c, 0x24, 0x08);
    FCML_A64("vpmullq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x40, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PMULLD(void) {

    FCML_I64( "pmulld xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x40, 0x00 );
    FCML_I32( "pmulld xmm0,xmm1", 0x66, 0x0F, 0x38, 0x40, 0xC1 );
    FCML_A64( "pmulld (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x40, 0x00 );
    FCML_A64( "pmulld %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x40, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpmulld (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x40, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x40, 0x38));
    FCML_I64_M("vpmulld xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x40, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x40, 0x38));
    FCML_A32_M("vpmulld (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x40, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x40, 0x38));
    FCML_I32_M("vpmulld xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x40, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x40, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpmulld (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x40, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x40, 0x38));
    FCML_I64_M("vpmulld ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x40, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x40, 0x38));
    FCML_A32_M("vpmulld (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x40, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x40, 0x38));
    FCML_I32_M("vpmulld ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x40, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x40, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmulld (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x40, 0x38);
    FCML_I64("vpmulld zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x40, 0x38);
    FCML_A32("vpmulld (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x40, 0x38);
    FCML_I32("vpmulld zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x40, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpmulld %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x40, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x40, 0xf9));
    FCML_I64_M("vpmulld xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x40, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x40, 0xf9));
    FCML_A32_M("vpmulld %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x40, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x40, 0xf9));
    FCML_I32_M("vpmulld xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x40, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x40, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpmulld %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x40, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x40, 0xf6));
    FCML_I64_M("vpmulld ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x40, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x40, 0xf6));
    FCML_A32_M("vpmulld %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x40, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x40, 0xf5));
    FCML_I32_M("vpmulld ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x40, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x40, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmulld %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x40, 0xf4);
    FCML_I64("vpmulld zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x40, 0xf4);
    FCML_A32("vpmulld %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x40, 0xf4);
    FCML_I32("vpmulld zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x40, 0xf4);
    /* disp8 */
    FCML_I32("vpmulld zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x40, 0x4c, 0x24, 0x08);
    FCML_A32("vpmulld 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x40, 0x4c, 0x24, 0x08);
    FCML_I64("vpmulld zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x40, 0x4c, 0x24, 0x08);
    FCML_A64("vpmulld 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x40, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpmulld ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x40, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x40, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpmulld 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x40, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x40, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpmulld ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x40, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x40, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpmulld 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x40, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x40, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpmulld xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x40, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x40, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpmulld 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x40, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x40, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpmulld xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x40, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x40, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpmulld 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x40, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x40, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpmulld (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x40, 0x14, 0x01);
    FCML_I64("vpmulld xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x40, 0x14, 0x01);
    FCML_A32("vpmulld (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x40, 0x14, 0x01);
    FCML_I32("vpmulld xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x40, 0x14, 0x01);
    FCML_A64("vpmulld (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x40, 0x14, 0x01);
    FCML_I64("vpmulld ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x40, 0x14, 0x01);
    FCML_A32("vpmulld (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x40, 0x14, 0x01);
    FCML_I32("vpmulld ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x40, 0x14, 0x01);
    FCML_A64("vpmulld (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x40, 0x14, 0x01);
    FCML_I64("vpmulld zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x40, 0x14, 0x01);
    FCML_A32("vpmulld (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x40, 0x14, 0x01);
    FCML_I32("vpmulld zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x40, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmulld (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x40, 0x14, 0x01);
    FCML_I64("vpmulld xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x40, 0x14, 0x01);
    FCML_A32("vpmulld (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x40, 0x14, 0x01);
    FCML_I32("vpmulld xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x40, 0x14, 0x01);
    FCML_A64("vpmulld (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x40, 0x14, 0x01);
    FCML_I64("vpmulld ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x40, 0x14, 0x01);
    FCML_A32("vpmulld (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x40, 0x14, 0x01);
    FCML_I32("vpmulld ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x40, 0x14, 0x01);
    FCML_A64("vpmulld (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x40, 0x14, 0x01);
    FCML_I64("vpmulld zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x40, 0x14, 0x01);
    FCML_A32("vpmulld (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x40, 0x14, 0x01);
    FCML_I32("vpmulld zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x40, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpmulld zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x40, 0x3e);
    FCML_A64("vpmulld (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x40, 0x3e);
    FCML_I64("vpmulld ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x40, 0x3e);
    FCML_A64("vpmulld (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x40, 0x3e);
    FCML_I64("vpmulld xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x40, 0x3e);
    FCML_A64("vpmulld (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x40, 0x3e);
    FCML_A32("vpmulld (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x40, 0x0e);
    FCML_I32("vpmulld zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x40, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpmulld (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x40, 0x3e);
    FCML_I64("vpmulld ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x40, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpmulld zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x40, 0x4c, 0x24, 0x08);
    FCML_A32("vpmulld 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x40, 0x4c, 0x24, 0x08);
    FCML_I64("vpmulld zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x40, 0x4c, 0x24, 0x08);
    FCML_A64("vpmulld 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x40, 0x4c, 0x24, 0x08);
    FCML_I32("vpmulld ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x40, 0x4c, 0x24, 0x08);
    FCML_A32("vpmulld 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x40, 0x4c, 0x24, 0x08);
    FCML_I64("vpmulld ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x40, 0x4c, 0x24, 0x08);
    FCML_A64("vpmulld 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x40, 0x4c, 0x24, 0x08);
    FCML_I32("vpmulld xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x40, 0x4c, 0x24, 0x08);
    FCML_A32("vpmulld 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x40, 0x4c, 0x24, 0x08);
    FCML_I64("vpmulld xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x40, 0x4c, 0x24, 0x08);
    FCML_A64("vpmulld 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x40, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_POP(void) {

    FCML_I32( "pop dword ptr [eax]", 0x8F, 0x00 );
    FCML_I32_M( "pop eax", 2, FCML_MI( 0x58 ), FCML_MI( 0x8f, 0xc0 ) );
    FCML_I32( "pop word ptr [eax]", 0x66, 0x8F, 0x00 );
    FCML_I32_M( "pop dx", 2, FCML_MI( 0x66, 0x5a ), FCML_MI( 0x66, 0x8f, 0xc2 ) );
    FCML_I32( "pop dword ptr [bx+si]", 0x67, 0x8F, 0x00 );
    FCML_I32_D( "pop ecx", 0x67, 0x8F, 0xC1 );
    FCML_I32_M( "pop ecx", 2, FCML_MI( 0x59 ), FCML_MI( 0x8f, 0xc1 ) );
    FCML_I32( "pop word ptr [bx+si]", 0x66, 0x67, 0x8F, 0x00 );
    FCML_I32_M( "pop cx", 2, FCML_MI( 0x66, 0x59 ), FCML_MI( 0x66, 0x8f, 0xc1 ) );

    FCML_A32( "popl (%eax)", 0x8f, 0x00 );

    FCML_I64( "pop qword ptr [rax]", 0x8F, 0x00 );
    FCML_I64_M( "pop rcx", 2, FCML_MI( 0x59 ), FCML_MI( 0x8f, 0xc1 ) );
    FCML_I64( "pop word ptr [rax]", 0x66, 0x8F, 0x00 );
    FCML_I64_M( "pop cx", 2, FCML_MI( 0x66, 0x59 ), FCML_MI( 0x66, 0x8f, 0xc1 ) );
    FCML_I64( "pop qword ptr [eax]", 0x67, 0x8F, 0x00 );
    FCML_I64_D( "pop rcx", 0x67, 0x8F, 0xC1 );
    FCML_I64( "pop word ptr [eax]", 0x66, 0x67, 0x8F, 0x00 );
    FCML_I64_D( "pop cx", 0x66, 0x67, 0x8F, 0xC1 );
    FCML_I64_D( "pop qword ptr [rax]", 0x48, 0x8F, 0x00 );
    FCML_I64_D( "pop rcx", 0x48, 0x8F, 0xC1 );

    FCML_A64( "popq (%rax)", 0x8f, 0x00 );
    FCML_A64_M( "pop %rcx", 2, FCML_MI( 0x59 ), FCML_MI( 0x8f, 0xc1 ) );
    FCML_A32_M( "pop %ecx", 2, FCML_MI( 0x59 ), FCML_MI( 0x8f, 0xc1 ) );
    FCML_A64( "popw (%rax)", 0x66, 0x8f, 0x00 );
    FCML_A64_M( "pop %cx", 2, FCML_MI( 0x66, 0x59 ), FCML_MI( 0x66, 0x8f, 0xc1 ) );
    FCML_A64( "popq (%eax)", 0x67, 0x8f, 0x00 );
    FCML_A64_M( "pop %rcx", 2, FCML_MI( 0x67, 0x59 ), FCML_MI( 0x67, 0x8f, 0xc1 ) );
    FCML_A64( "popw (%eax)", 0x66, 0x67, 0x8f, 0x00 );
    FCML_A64_M( "pop %cx", 2, FCML_MI( 0x66, 0x67, 0x59 ), FCML_MI( 0x66, 0x67, 0x8f, 0xc1 ) );
    FCML_A64_D( "popq (%rax)", 0x48, 0x8f, 0x00 );
    FCML_A64_D( "pop %rcx", 0x48, 0x8f, 0xc1 );

    FCML_I32_M( "pop eax", 2, FCML_MI( 0x58 ), FCML_MI( 0x8f, 0xc0 ) );
    FCML_I32_M( "pop ax", 2, FCML_MI( 0x66, 0x58 ), FCML_MI( 0x66, 0x8f, 0xc0 ) );
    FCML_I32_D( "pop eax", 0x67, 0x58 );
    FCML_I64_M( "pop rax", 2, FCML_MI( 0x58 ), FCML_MI( 0x8f, 0xc0 ) );
    FCML_I64_M( "pop ax", 2, FCML_MI( 0x66, 0x58 ), FCML_MI( 0x66, 0x8f, 0xc0 ) );
    FCML_I64_D( "pop rax", 0x67, 0x58 );
    FCML_I64_D( "pop rax", 0x48, 0x58 );

    FCML_A32_M( "pop %eax", 2, FCML_MI( 0x58 ), FCML_MI( 0x8f, 0xc0 ) );
    FCML_A32_M( "pop %ax", 2, FCML_MI( 0x66, 0x58 ), FCML_MI( 0x66, 0x8f, 0xc0 ) );
    FCML_A32_D( "pop %eax", 0x67, 0x58 );
    FCML_A64_M( "pop %rax", 2, FCML_MI( 0x58 ), FCML_MI( 0x8f, 0xc0 ) );
    FCML_A64_M( "pop %ax", 2, FCML_MI( 0x66, 0x58 ), FCML_MI( 0x66, 0x8f, 0xc0 ) );
    FCML_A64_D( "pop %rax", 0x67, 0x58 );
    FCML_A64_D( "pop %rax", 0x48, 0x58 );

    FCML_I32( "pop ds", 0x1F );
    FCML_I32( "pop es", 0x07 );
    FCML_I32( "pop ss", 0x17 );

    FCML_A32( "pop %ds", 0x1F );
    FCML_A32( "pop %es", 0x07 );
    FCML_A32( "pop %ss", 0x17 );

    FCML_I32( "pop fs", 0x0F, 0xA1 );
    FCML_I64( "pop fs", 0x0f, 0xa1 );

    FCML_A32( "popw %fs", 0x66, 0x0f, 0xa1 );
    FCML_A32( "popl %fs", 0x0f, 0xa1 );
    FCML_A32_A( "pop %fs", 0x0f, 0xa1 );
    FCML_A64( "popw %fs", 0x66, 0x0f, 0xa1 );
    FCML_A64( "popq %fs", 0x0f, 0xa1 );
    FCML_A64_A( "pop %fs", 0x0f, 0xa1 );

    FCML_I32( "pop gs", 0x0F, 0xA9 );
    FCML_I64( "pop gs", 0x0F, 0xA9 );

    FCML_A32( "popw %gs", 0x66, 0x0f, 0xa9 );
    FCML_A32( "popl %gs", 0x0f, 0xa9 );
    FCML_A32_A( "pop %gs", 0x0f, 0xa9 );
    FCML_A64( "popw %gs", 0x66, 0x0f, 0xa9 );
    FCML_A64( "popq %gs", 0x0f, 0xa9 );
    FCML_A64_A( "pop %gs", 0x0f, 0xa9 );
}

void fcml_tf_instruction_POPA(void) {

    FCML_I32( "popad", 0x61 );
    FCML_I64_FAILED( "popad", 0x61 );

    FCML_I32( "popa", 0x66, 0x61 );

    FCML_A32( "popa", 0x61 );
    FCML_A32( "popaw", 0x66, 0x61 );
}

void fcml_tf_instruction_POPCNT(void) {

    FCML_I32( "popcnt ax,word ptr [eax]", 0x66, 0xF3, 0x0F, 0xB8, 0x00 );
    FCML_I32( "popcnt ax,ax", 0x66, 0xF3, 0x0F, 0xB8, 0xC0 );

    FCML_I32( "popcnt eax,dword ptr [eax]", 0xF3, 0x0F, 0xB8, 0x00 );

    FCML_I64( "popcnt rax,qword ptr [rax]", 0xF3, 0x48, 0x0F, 0xB8, 0x00 );

    FCML_A64( "popcnt (%rax),%ax", 0x66, 0xf3, 0x0f, 0xb8, 0x00 );
    FCML_A64( "popcnt %ax,%ax", 0x66, 0xf3, 0x0f, 0xb8, 0xc0 );
    FCML_A64( "popcnt (%rax),%eax", 0xf3, 0x0f, 0xb8, 0x00 );
    FCML_A64( "popcnt (%rax),%rax", 0xf3, 0x48, 0x0f, 0xb8, 0x00 );
}

void fcml_tf_instruction_POPF(void) {

    FCML_I32( "popf", 0x66, 0x9D );
    FCML_I64( "popf", 0x66, 0x9D );

    FCML_I32( "popfd", 0x9D );
    FCML_I64_FAILED( "popfd", 0x9D );

    FCML_I64( "popfq", 0x48, 0x9D );

    FCML_A32( "popfw", 0x66, 0x9d );
    FCML_A32( "popf", 0x9D );
    FCML_A64( "popfw", 0x66, 0x9d );
    FCML_A64( "popfq", 0x48, 0x9d );
}

void fcml_tf_instruction_POR(void) {

    FCML_I64( "por mm0,mmword ptr [rax]", 0x0F, 0xEB, 0x00 );
    FCML_I32( "por mm0,mm1", 0x0F, 0xEB, 0xC1 );

    FCML_I64( "por xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xEB, 0x00 );
    FCML_I32( "por xmm0,xmm1", 0x66, 0x0F, 0xEB, 0xC1 );

    FCML_I64( "vpor xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xeb, 0x00 );
    FCML_I32( "vpor xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xeb, 0xc1 );

    FCML_I64( "vpor ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xeb, 0x00 );
    FCML_I32( "vpor ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xeb, 0xc1 );

    FCML_A64( "por (%rax),%mm0", 0x0f, 0xeb, 0x00 );
    FCML_A64( "por %mm1,%mm0", 0x0f, 0xeb, 0xc1 );
    FCML_A64( "por (%rax),%xmm0", 0x66, 0x0f, 0xeb, 0x00 );
    FCML_A64( "por %xmm1,%xmm0", 0x66, 0x0f, 0xeb, 0xc1 );
    FCML_A64( "vpor (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xeb, 0x00 );
    FCML_A64( "vpor %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xeb, 0xc1 );
    FCML_A64( "vpor (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xeb, 0x00 );
    FCML_A64( "vpor %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xeb, 0xc1 );
}

void fcml_tf_instruction_VPOR(void) {

    /* xmm1, xmm2, m128 */
    FCML_A64("vpord (%rax),%xmm7,%xmm15", 0x62, 0x71, 0x45, 0x08, 0xeb, 0x38);
    FCML_I64("vpord xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x71, 0x45, 0x08, 0xeb, 0x38);
    FCML_A32("vpord (%eax),%xmm6,%xmm7", 0x62, 0xf1, 0x4d, 0x08, 0xeb, 0x38);
    FCML_I32("vpord xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf1, 0x4d, 0x08, 0xeb, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpord (%rax),%ymm7,%ymm15", 0x62, 0x71, 0x45, 0x28, 0xeb, 0x38);
    FCML_I64("vpord ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x71, 0x45, 0x28, 0xeb, 0x38);
    FCML_A32("vpord (%eax),%ymm5,%ymm7", 0x62, 0xf1, 0x55, 0x28, 0xeb, 0x38);
    FCML_I32("vpord ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf1, 0x55, 0x28, 0xeb, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpord (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xeb, 0x38);
    FCML_I64("vpord zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xeb, 0x38);
    FCML_A32("vpord (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xeb, 0x38);
    FCML_I32("vpord zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xeb, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpord %xmm1,%xmm7,%xmm15", 0x62, 0x71, 0x45, 0x08, 0xeb, 0xf9);
    FCML_I64("vpord xmm15,xmm7,xmm1", 0x62, 0x71, 0x45, 0x08, 0xeb, 0xf9);
    FCML_A32("vpord %xmm1,%xmm2,%xmm7", 0x62, 0xf1, 0x6d, 0x08, 0xeb, 0xf9);
    FCML_I32("vpord xmm7,xmm2,xmm1", 0x62, 0xf1, 0x6d, 0x08, 0xeb, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpord %ymm6,%ymm7,%ymm14", 0x62, 0x71, 0x45, 0x28, 0xeb, 0xf6);
    FCML_I64("vpord ymm14,ymm7,ymm6", 0x62, 0x71, 0x45, 0x28, 0xeb, 0xf6);
    FCML_A32("vpord %ymm5,%ymm3,%ymm6", 0x62, 0xf1, 0x65, 0x28, 0xeb, 0xf5);
    FCML_I32("vpord ymm6,ymm3,ymm5", 0x62, 0xf1, 0x65, 0x28, 0xeb, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpord %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xeb, 0xf4);
    FCML_I64("vpord zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xeb, 0xf4);
    FCML_A32("vpord %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xeb, 0xf4);
    FCML_I32("vpord zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xeb, 0xf4);
    /* disp8 */
    FCML_I32("vpord zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A32("vpord 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I64("vpord zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A64("vpord 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I32("vpord ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf1, 0x6d, 0x28, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A32("vpord 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf1, 0x6d, 0x28, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I64("vpord ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf1, 0x6d, 0x28, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A64("vpord 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf1, 0x6d, 0x28, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I32("vpord xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf1, 0x6d, 0x08, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A32("vpord 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf1, 0x6d, 0x08, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I64("vpord xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf1, 0x6d, 0x08, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A64("vpord 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf1, 0x6d, 0x08, 0xeb, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpord (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xeb, 0x14, 0x01);
    FCML_I64("vpord xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xeb, 0x14, 0x01);
    FCML_A32("vpord (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xeb, 0x14, 0x01);
    FCML_I32("vpord xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xeb, 0x14, 0x01);
    FCML_A64("vpord (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xeb, 0x14, 0x01);
    FCML_I64("vpord ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xeb, 0x14, 0x01);
    FCML_A32("vpord (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xeb, 0x14, 0x01);
    FCML_I32("vpord ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xeb, 0x14, 0x01);
    FCML_A64("vpord (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xeb, 0x14, 0x01);
    FCML_I64("vpord zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xeb, 0x14, 0x01);
    FCML_A32("vpord (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xeb, 0x14, 0x01);
    FCML_I32("vpord zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xeb, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpord (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xeb, 0x14, 0x01);
    FCML_I64("vpord xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xeb, 0x14, 0x01);
    FCML_A32("vpord (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xeb, 0x14, 0x01);
    FCML_I32("vpord xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xeb, 0x14, 0x01);
    FCML_A64("vpord (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xeb, 0x14, 0x01);
    FCML_I64("vpord ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xeb, 0x14, 0x01);
    FCML_A32("vpord (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xeb, 0x14, 0x01);
    FCML_I32("vpord ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xeb, 0x14, 0x01);
    FCML_A64("vpord (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xeb, 0x14, 0x01);
    FCML_I64("vpord zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xeb, 0x14, 0x01);
    FCML_A32("vpord (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xeb, 0x14, 0x01);
    FCML_I32("vpord zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xeb, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpord zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x61, 0x55, 0x50, 0xeb, 0x3e);
    FCML_A64("vpord (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x61, 0x55, 0x50, 0xeb, 0x3e);
    FCML_I64("vpord ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x55, 0x30, 0xeb, 0x3e);
    FCML_A64("vpord (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x61, 0x55, 0x30, 0xeb, 0x3e);
    FCML_I64("vpord xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x61, 0x55, 0x10, 0xeb, 0x3e);
    FCML_A64("vpord (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x61, 0x55, 0x10, 0xeb, 0x3e);
    FCML_A32("vpord (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0xeb, 0x0e);
    FCML_I32("vpord zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0xeb, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpord (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0x55, 0xb7, 0xeb, 0x3e);
    FCML_I64("vpord ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x55, 0xb7, 0xeb, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpord zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A32("vpord 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I64("vpord zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A64("vpord 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I32("vpord ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf1, 0x6d, 0x38, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A32("vpord 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf1, 0x6d, 0x38, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I64("vpord ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf1, 0x6d, 0x38, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A64("vpord 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf1, 0x6d, 0x38, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I32("vpord xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf1, 0x6d, 0x18, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A32("vpord 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf1, 0x6d, 0x18, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I64("vpord xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf1, 0x6d, 0x18, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A64("vpord 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf1, 0x6d, 0x18, 0xeb, 0x4c, 0x24, 0x08);

    /* xmm1, xmm2, m128 */
    FCML_A64("vporq (%rax),%xmm7,%xmm15", 0x62, 0x71, 0xc5, 0x08, 0xeb, 0x38);
    FCML_I64("vporq xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x71, 0xc5, 0x08, 0xeb, 0x38);
    FCML_A32("vporq (%eax),%xmm6,%xmm7", 0x62, 0xf1, 0xcd, 0x08, 0xeb, 0x38);
    FCML_I32("vporq xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf1, 0xcd, 0x08, 0xeb, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vporq (%rax),%ymm7,%ymm15", 0x62, 0x71, 0xc5, 0x28, 0xeb, 0x38);
    FCML_I64("vporq ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x71, 0xc5, 0x28, 0xeb, 0x38);
    FCML_A32("vporq (%eax),%ymm5,%ymm7", 0x62, 0xf1, 0xd5, 0x28, 0xeb, 0x38);
    FCML_I32("vporq ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf1, 0xd5, 0x28, 0xeb, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vporq (%rax),%zmm7,%zmm15", 0x62, 0x71, 0xc5, 0x48, 0xeb, 0x38);
    FCML_I64("vporq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0xc5, 0x48, 0xeb, 0x38);
    FCML_A32("vporq (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0xe5, 0x48, 0xeb, 0x38);
    FCML_I32("vporq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0xe5, 0x48, 0xeb, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vporq %xmm1,%xmm7,%xmm15", 0x62, 0x71, 0xc5, 0x08, 0xeb, 0xf9);
    FCML_I64("vporq xmm15,xmm7,xmm1", 0x62, 0x71, 0xc5, 0x08, 0xeb, 0xf9);
    FCML_A32("vporq %xmm1,%xmm2,%xmm7", 0x62, 0xf1, 0xed, 0x08, 0xeb, 0xf9);
    FCML_I32("vporq xmm7,xmm2,xmm1", 0x62, 0xf1, 0xed, 0x08, 0xeb, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vporq %ymm6,%ymm7,%ymm14", 0x62, 0x71, 0xc5, 0x28, 0xeb, 0xf6);
    FCML_I64("vporq ymm14,ymm7,ymm6", 0x62, 0x71, 0xc5, 0x28, 0xeb, 0xf6);
    FCML_A32("vporq %ymm5,%ymm3,%ymm6", 0x62, 0xf1, 0xe5, 0x28, 0xeb, 0xf5);
    FCML_I32("vporq ymm6,ymm3,ymm5", 0x62, 0xf1, 0xe5, 0x28, 0xeb, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vporq %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x85, 0x48, 0xeb, 0xf4);
    FCML_I64("vporq zmm6,zmm15,zmm4", 0x62, 0xf1, 0x85, 0x48, 0xeb, 0xf4);
    FCML_A32("vporq %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0xcd, 0x48, 0xeb, 0xf4);
    FCML_I32("vporq zmm6,zmm6,zmm4", 0x62, 0xf1, 0xcd, 0x48, 0xeb, 0xf4);
    /* disp8 */
    FCML_I32("vporq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0xed, 0x48, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A32("vporq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x48, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I64("vporq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0xed, 0x48, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A64("vporq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x48, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I32("vporq ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf1, 0xed, 0x28, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A32("vporq 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x28, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I64("vporq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf1, 0xed, 0x28, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A64("vporq 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x28, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I32("vporq xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf1, 0xed, 0x08, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A32("vporq 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x08, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I64("vporq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf1, 0xed, 0x08, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A64("vporq 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x08, 0xeb, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vporq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x8d, 0x8c, 0xeb, 0x14, 0x01);
    FCML_I64("vporq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x8c, 0xeb, 0x14, 0x01);
    FCML_A32("vporq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0x8d, 0xeb, 0x14, 0x01);
    FCML_I32("vporq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x8d, 0xeb, 0x14, 0x01);
    FCML_A64("vporq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x8d, 0xac, 0xeb, 0x14, 0x01);
    FCML_I64("vporq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0xac, 0xeb, 0x14, 0x01);
    FCML_A32("vporq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0xad, 0xeb, 0x14, 0x01);
    FCML_I32("vporq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0xad, 0xeb, 0x14, 0x01);
    FCML_A64("vporq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x8d, 0xcc, 0xeb, 0x14, 0x01);
    FCML_I64("vporq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0xcc, 0xeb, 0x14, 0x01);
    FCML_A32("vporq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0xcd, 0xeb, 0x14, 0x01);
    FCML_I32("vporq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0xcd, 0xeb, 0x14, 0x01);
    /* {k} */
    FCML_A64("vporq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x8d, 0x0c, 0xeb, 0x14, 0x01);
    FCML_I64("vporq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x0c, 0xeb, 0x14, 0x01);
    FCML_A32("vporq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0xc5, 0x0d, 0xeb, 0x14, 0x01);
    FCML_I32("vporq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x0d, 0xeb, 0x14, 0x01);
    FCML_A64("vporq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x8d, 0x2c, 0xeb, 0x14, 0x01);
    FCML_I64("vporq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x2c, 0xeb, 0x14, 0x01);
    FCML_A32("vporq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0xc5, 0x2d, 0xeb, 0x14, 0x01);
    FCML_I32("vporq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x2d, 0xeb, 0x14, 0x01);
    FCML_A64("vporq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x8d, 0x4c, 0xeb, 0x14, 0x01);
    FCML_I64("vporq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x4c, 0xeb, 0x14, 0x01);
    FCML_A32("vporq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0xc5, 0x4d, 0xeb, 0x14, 0x01);
    FCML_I32("vporq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x4d, 0xeb, 0x14, 0x01);
    /* bcast */
    FCML_I64("vporq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xd5, 0x50, 0xeb, 0x3e);
    FCML_A64("vporq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x61, 0xd5, 0x50, 0xeb, 0x3e);
    FCML_I64("vporq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xd5, 0x30, 0xeb, 0x3e);
    FCML_A64("vporq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x61, 0xd5, 0x30, 0xeb, 0x3e);
    FCML_I64("vporq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x61, 0xd5, 0x10, 0xeb, 0x3e);
    FCML_A64("vporq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x61, 0xd5, 0x10, 0xeb, 0x3e);
    FCML_A32("vporq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0xeb, 0x0e);
    FCML_I32("vporq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0xeb, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vporq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0xd5, 0xb7, 0xeb, 0x3e);
    FCML_I64("vporq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xd5, 0xb7, 0xeb, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vporq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A32("vporq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I64("vporq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A64("vporq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I32("vporq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf1, 0xed, 0x38, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A32("vporq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x38, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I64("vporq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf1, 0xed, 0x38, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A64("vporq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x38, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I32("vporq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf1, 0xed, 0x18, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A32("vporq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x18, 0xeb, 0x4c, 0x24, 0x08);
    FCML_I64("vporq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf1, 0xed, 0x18, 0xeb, 0x4c, 0x24, 0x08);
    FCML_A64("vporq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x18, 0xeb, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PREFETCHT(void) {

    FCML_I32( "prefetcht0 byte ptr [eax]", 0x0F, 0x18, 0x08 );
    FCML_I64( "prefetcht0 byte ptr [rax]", 0x0F, 0x18, 0x08 );

    FCML_I32( "prefetcht1 byte ptr [eax]", 0x0F, 0x18, 0x10 );
    FCML_I64( "prefetcht1 byte ptr [rax]", 0x0F, 0x18, 0x10 );

    FCML_I32( "prefetcht2 byte ptr [eax]", 0x0F, 0x18, 0x18 );
    FCML_I64( "prefetcht2 byte ptr [rax]", 0x0F, 0x18, 0x18 );

    FCML_I32( "prefetchnta byte ptr [eax]", 0x0F, 0x18, 0x00 );
    FCML_I64( "prefetchnta byte ptr [rax]", 0x0F, 0x18, 0x00 );

    FCML_A64( "prefetcht0 (%rax)", 0x0f, 0x18, 0x08 );
    FCML_A32( "prefetcht0 (%eax)", 0x0f, 0x18, 0x08 );
    FCML_A64( "prefetcht1 (%rax)", 0x0f, 0x18, 0x10 );
    FCML_A32( "prefetcht1 (%eax)", 0x0f, 0x18, 0x10 );
    FCML_A64( "prefetcht2 (%rax)", 0x0f, 0x18, 0x18 );
    FCML_A32( "prefetcht2 (%eax)", 0x0f, 0x18, 0x18 );
    FCML_A64( "prefetchnta (%rax)", 0x0f, 0x18, 0x00 );
    FCML_A32( "prefetchnta (%eax)", 0x0f, 0x18, 0x00 );
}

void fcml_tf_instruction_PSADBW(void) {

    FCML_I64( "psadbw mm0,mmword ptr [rax]", 0x0F, 0xF6, 0x00 );
    FCML_I32( "psadbw mm0,mm1", 0x0F, 0xF6, 0xC1 );
    FCML_I64( "psadbw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF6, 0x00 );
    FCML_I32( "psadbw xmm0,xmm1", 0x66, 0x0F, 0xF6, 0xC1 );
    FCML_A64( "psadbw (%rax),%mm0", 0x0f, 0xf6, 0x00 );
    FCML_A64( "psadbw %mm1,%mm0", 0x0f, 0xf6, 0xc1 );
    FCML_A64( "psadbw (%rax),%xmm0", 0x66, 0x0f, 0xf6, 0x00 );
    FCML_A64( "psadbw %xmm1,%xmm0", 0x66, 0x0f, 0xf6, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpsadbw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf6, 0x38), FCML_MI(0xc5, 0x41, 0xf6, 0x38));
    FCML_I64_M("vpsadbw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf6, 0x38), FCML_MI(0xc5, 0x41, 0xf6, 0x38));
    FCML_A32_M("vpsadbw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xf6, 0x38), FCML_MI(0xc5, 0xc9, 0xf6, 0x38));
    FCML_I32_M("vpsadbw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xf6, 0x38), FCML_MI(0xc5, 0xc9, 0xf6, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpsadbw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf6, 0x38), FCML_MI(0xc5, 0x45, 0xf6, 0x38));
    FCML_I64_M("vpsadbw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf6, 0x38), FCML_MI(0xc5, 0x45, 0xf6, 0x38));
    FCML_A32_M("vpsadbw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xf6, 0x38), FCML_MI(0xc5, 0xd5, 0xf6, 0x38));
    FCML_I32_M("vpsadbw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xf6, 0x38), FCML_MI(0xc5, 0xd5, 0xf6, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsadbw (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xf6, 0x38);
    FCML_I64("vpsadbw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xf6, 0x38);
    FCML_A32("vpsadbw (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xf6, 0x38);
    FCML_I32("vpsadbw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xf6, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpsadbw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf6, 0xf9), FCML_MI(0xc5, 0x41, 0xf6, 0xf9));
    FCML_I64_M("vpsadbw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf6, 0xf9), FCML_MI(0xc5, 0x41, 0xf6, 0xf9));
    FCML_A32_M("vpsadbw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf6, 0xf9), FCML_MI(0xc5, 0xe9, 0xf6, 0xf9));
    FCML_I32_M("vpsadbw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf6, 0xf9), FCML_MI(0xc5, 0xe9, 0xf6, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpsadbw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf6, 0xf6), FCML_MI(0xc5, 0x45, 0xf6, 0xf6));
    FCML_I64_M("vpsadbw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf6, 0xf6), FCML_MI(0xc5, 0x45, 0xf6, 0xf6));
    FCML_A32_M("vpsadbw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xf6, 0xf5), FCML_MI(0xc5, 0xe5, 0xf6, 0xf5));
    FCML_I32_M("vpsadbw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xf6, 0xf5), FCML_MI(0xc5, 0xe5, 0xf6, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsadbw %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xf6, 0xf4);
    FCML_I64("vpsadbw zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xf6, 0xf4);
    FCML_A32("vpsadbw %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xf6, 0xf4);
    FCML_I32("vpsadbw zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xf6, 0xf4);
    /* disp8 */
    FCML_I32("vpsadbw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xf6, 0x4c, 0x24, 0x08);
    FCML_A32("vpsadbw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xf6, 0x4c, 0x24, 0x08);
    FCML_I64("vpsadbw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xf6, 0x4c, 0x24, 0x08);
    FCML_A64("vpsadbw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xf6, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpsadbw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf6, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf6, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpsadbw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf6, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf6, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpsadbw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf6, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf6, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpsadbw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf6, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf6, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpsadbw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf6, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf6, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpsadbw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf6, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf6, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpsadbw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf6, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf6, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpsadbw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf6, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf6, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
}

void fcml_tf_instruction_PSHUFB(void) {

    FCML_I64( "pshufb mm0,mmword ptr [rax]", 0x0F, 0x38, 0x00, 0x00 );
    FCML_I32( "pshufb mm0,mm1", 0x0F, 0x38, 0x00, 0xC1 );
    FCML_I64( "pshufb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x00, 0x00 );
    FCML_I32( "pshufb xmm0,xmm1", 0x66, 0x0F, 0x38, 0x00, 0xC1 );
    FCML_A64( "pshufb (%rax),%mm0", 0x0f, 0x38, 0x00, 0x00 );
    FCML_A64( "pshufb %mm1,%mm0", 0x0f, 0x38, 0x00, 0xc1 );
    FCML_A64( "pshufb (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x00, 0x00 );
    FCML_A64( "pshufb %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x00, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpshufb (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x00, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x00, 0x38));
    FCML_I64_M("vpshufb xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x00, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x00, 0x38));
    FCML_A32_M("vpshufb (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x00, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x00, 0x38));
    FCML_I32_M("vpshufb xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x00, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x00, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpshufb (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x00, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x00, 0x38));
    FCML_I64_M("vpshufb ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x00, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x00, 0x38));
    FCML_A32_M("vpshufb (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x00, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x00, 0x38));
    FCML_I32_M("vpshufb ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x00, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x00, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpshufb (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x00, 0x38);
    FCML_I64("vpshufb zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x00, 0x38);
    FCML_A32("vpshufb (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x00, 0x38);
    FCML_I32("vpshufb zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x00, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpshufb %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x00, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x00, 0xf9));
    FCML_I64_M("vpshufb xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x00, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x00, 0xf9));
    FCML_A32_M("vpshufb %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x00, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x00, 0xf9));
    FCML_I32_M("vpshufb xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x00, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x00, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpshufb %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x00, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x00, 0xf6));
    FCML_I64_M("vpshufb ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x00, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x00, 0xf6));
    FCML_A32_M("vpshufb %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x00, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x00, 0xf5));
    FCML_I32_M("vpshufb ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x00, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x00, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpshufb %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x00, 0xf4);
    FCML_I64("vpshufb zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x00, 0xf4);
    FCML_A32("vpshufb %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x00, 0xf4);
    FCML_I32("vpshufb zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x00, 0xf4);
    /* disp8 */
    FCML_I32("vpshufb zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x00, 0x4c, 0x24, 0x08);
    FCML_A32("vpshufb 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x00, 0x4c, 0x24, 0x08);
    FCML_I64("vpshufb zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x00, 0x4c, 0x24, 0x08);
    FCML_A64("vpshufb 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x00, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpshufb ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x00, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x00, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpshufb 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x00, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x00, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpshufb ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x00, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x00, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpshufb 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x00, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x00, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpshufb xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x00, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x00, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpshufb 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x00, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x00, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpshufb xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x00, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x00, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpshufb 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x00, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x00, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpshufb (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x00, 0x14, 0x01);
    FCML_I64("vpshufb xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x00, 0x14, 0x01);
    FCML_A32("vpshufb (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x00, 0x14, 0x01);
    FCML_I32("vpshufb xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x00, 0x14, 0x01);
    FCML_A64("vpshufb (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x00, 0x14, 0x01);
    FCML_I64("vpshufb ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x00, 0x14, 0x01);
    FCML_A32("vpshufb (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x00, 0x14, 0x01);
    FCML_I32("vpshufb ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x00, 0x14, 0x01);
    FCML_A64("vpshufb (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x00, 0x14, 0x01);
    FCML_I64("vpshufb zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x00, 0x14, 0x01);
    FCML_A32("vpshufb (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x00, 0x14, 0x01);
    FCML_I32("vpshufb zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x00, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpshufb (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x00, 0x14, 0x01);
    FCML_I64("vpshufb xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x00, 0x14, 0x01);
    FCML_A32("vpshufb (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x00, 0x14, 0x01);
    FCML_I32("vpshufb xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x00, 0x14, 0x01);
    FCML_A64("vpshufb (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x00, 0x14, 0x01);
    FCML_I64("vpshufb ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x00, 0x14, 0x01);
    FCML_A32("vpshufb (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x00, 0x14, 0x01);
    FCML_I32("vpshufb ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x00, 0x14, 0x01);
    FCML_A64("vpshufb (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x00, 0x14, 0x01);
    FCML_I64("vpshufb zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x00, 0x14, 0x01);
    FCML_A32("vpshufb (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x00, 0x14, 0x01);
    FCML_I32("vpshufb zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x00, 0x14, 0x01);
}

void fcml_tf_instruction_PSHUFD(void) {

    FCML_I64( "pshufd xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x70, 0x00, 0xFF );
    FCML_I32( "pshufd xmm0,xmm1,0ffh", 0x66, 0x0F, 0x70, 0xC1, 0xFF );

    FCML_I64( "vpshufd xmm0,xmmword ptr [rax],0ffh", 0xc5, 0xf9, 0x70, 0x00, 0xff );
    FCML_I32( "vpshufd xmm0,xmm1,0ffh", 0xc5, 0xf9, 0x70, 0xc1, 0xff );

    FCML_I64( "vpshufd ymm0,ymmword ptr [rax],0ffh", 0xc5, 0xfd, 0x70, 0x00, 0xff );
    FCML_I32( "vpshufd ymm0,ymm1,0ffh", 0xc5, 0xfd, 0x70, 0xc1, 0xff );

    FCML_A64( "pshufd $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x70, 0x00, 0xff );
    FCML_A64( "pshufd $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x70, 0xc1, 0xff );
    FCML_A64( "vpshufd $0xff,(%rax),%xmm0", 0xc5, 0xf9, 0x70, 0x00, 0xff );
    FCML_A64( "vpshufd $0xff,%xmm1,%xmm0", 0xc5, 0xf9, 0x70, 0xc1, 0xff );
    FCML_A64( "vpshufd $0xff,(%rax),%ymm0", 0xc5, 0xfd, 0x70, 0x00, 0xff );
    FCML_A64( "vpshufd $0xff,%ymm1,%ymm0", 0xc5, 0xfd, 0x70, 0xc1, 0xff );
}

void fcml_tf_instruction_PSHUFHW(void) {

    FCML_I64( "pshufhw xmm0,xmmword ptr [rax],0ffh", 0xF3, 0x0F, 0x70, 0x00, 0xFF );
    FCML_I32( "pshufhw xmm0,xmm1,0ffh", 0xF3, 0x0F, 0x70, 0xC1, 0xFF );
    FCML_A64( "pshufhw $0xff,(%rax),%xmm0", 0xf3, 0x0f, 0x70, 0x00, 0xff );
    FCML_A64( "pshufhw $0xff,%xmm1,%xmm0", 0xf3, 0x0f, 0x70, 0xc1, 0xff );

    FCML_I64_M("vpshufhw xmm0,xmmword ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf1, 0x7e, 0x08, 0x70, 0x00, 0xff), FCML_MI(0xc5, 0xfa, 0x70, 0x00, 0xff));
    FCML_I32_M("vpshufhw xmm0,xmm1,0ffh", 2, FCML_MI(0x62, 0xf1, 0x7e, 0x08, 0x70, 0xc1, 0xff), FCML_MI(0xc5, 0xfa, 0x70, 0xc1, 0xff));
    FCML_I64_M("vpshufhw ymm0,ymmword ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf1, 0x7e, 0x28, 0x70, 0x00, 0xff), FCML_MI(0xc5, 0xfe, 0x70, 0x00, 0xff));
    FCML_I32_M("vpshufhw ymm0,ymm1,0ffh", 2, FCML_MI(0x62, 0xf1, 0x7e, 0x28, 0x70, 0xc1, 0xff), FCML_MI(0xc5, 0xfe, 0x70, 0xc1, 0xff));
    FCML_A64_M("vpshufhw $0xff,(%rax),%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7e, 0x08, 0x70, 0x00, 0xff), FCML_MI(0xc5, 0xfa, 0x70, 0x00, 0xff));
    FCML_A64_M("vpshufhw $0xff,%xmm1,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7e, 0x08, 0x70, 0xc1, 0xff), FCML_MI(0xc5, 0xfa, 0x70, 0xc1, 0xff));
    FCML_A64_M("vpshufhw $0xff,(%rax),%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7e, 0x28, 0x70, 0x00, 0xff), FCML_MI(0xc5, 0xfe, 0x70, 0x00, 0xff));
    FCML_A64_M("vpshufhw $0xff,%ymm1,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7e, 0x28, 0x70, 0xc1, 0xff), FCML_MI(0xc5, 0xfe, 0x70, 0xc1, 0xff));
    FCML_I64_M("vpshufhw ymm0,ymmword ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf1, 0x7e, 0x28, 0x70, 0x00, 0xff), FCML_MI(0xc5, 0xfe, 0x70, 0x00, 0xff));
    FCML_I32("vpshufhw xmm0{k2},xmm1,0ffh", 0x62, 0xf1, 0x7e, 0x0a, 0x70, 0xc1, 0xff);
    FCML_I32("vpshufhw xmm0{k5}{z},xmm1,0ffh", 0x62, 0xf1, 0x7e, 0x8d, 0x70, 0xc1, 0xff);
    FCML_I32("vpshufhw ymm0{k2},ymm1,0ffh", 0x62, 0xf1, 0x7e, 0x2a, 0x70, 0xc1, 0xff);
    FCML_I32("vpshufhw ymm0{k5}{z},ymm1,0ffh", 0x62, 0xf1, 0x7e, 0xad, 0x70, 0xc1, 0xff);
    FCML_I32("vpshufhw zmm0{k2},zmm1,0ffh", 0x62, 0xf1, 0x7e, 0x4a, 0x70, 0xc1, 0xff);
    FCML_I32("vpshufhw zmm0{k5}{z},zmm1,0ffh", 0x62, 0xf1, 0x7e, 0xcd, 0x70, 0xc1, 0xff);
}

void fcml_tf_instruction_PSHUFLW(void) {

    FCML_I64( "pshuflw xmm0,xmmword ptr [rax],0ffh", 0xF2, 0x0F, 0x70, 0x00, 0xFF );
    FCML_I32( "pshuflw xmm0,xmm1,0ffh", 0xF2, 0x0F, 0x70, 0xC1, 0xFF );
    FCML_A64( "pshuflw $0xff,(%rax),%xmm0", 0xf2, 0x0f, 0x70, 0x00, 0xff );
    FCML_A64( "pshuflw $0xff,%xmm1,%xmm0", 0xf2, 0x0f, 0x70, 0xc1, 0xff );

    FCML_I64_M("vpshuflw xmm0,xmmword ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf1, 0x7f, 0x08, 0x70, 0x00, 0xff), FCML_MI(0xc5, 0xfb, 0x70, 0x00, 0xff));
    FCML_I32_M("vpshuflw xmm0,xmm1,0ffh", 2, FCML_MI(0x62, 0xf1, 0x7f, 0x08, 0x70, 0xc1, 0xff), FCML_MI(0xc5, 0xfb, 0x70, 0xc1, 0xff));
    FCML_I64_M("vpshuflw ymm0,ymmword ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf1, 0x7f, 0x28, 0x70, 0x00, 0xff), FCML_MI(0xc5, 0xff, 0x70, 0x00, 0xff));
    FCML_I32_M("vpshuflw ymm0,ymm1,0ffh", 2, FCML_MI(0x62, 0xf1, 0x7f, 0x28, 0x70, 0xc1, 0xff), FCML_MI(0xc5, 0xff, 0x70, 0xc1, 0xff));
    FCML_A64_M("vpshuflw $0xff,(%rax),%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7f, 0x08, 0x70, 0x00, 0xff), FCML_MI(0xc5, 0xfb, 0x70, 0x00, 0xff));
    FCML_A64_M("vpshuflw $0xff,%xmm1,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7f, 0x08, 0x70, 0xc1, 0xff), FCML_MI(0xc5, 0xfb, 0x70, 0xc1, 0xff));
    FCML_A64_M("vpshuflw $0xff,(%rax),%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7f, 0x28, 0x70, 0x00, 0xff), FCML_MI(0xc5, 0xff, 0x70, 0x00, 0xff));
    FCML_A64_M("vpshuflw $0xff,%ymm1,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7f, 0x28, 0x70, 0xc1, 0xff), FCML_MI(0xc5, 0xff, 0x70, 0xc1, 0xff));
    FCML_I64("vpshuflw xmm0{k4}{z},xmmword ptr [rax],0ffh", 0x62, 0xf1, 0x7f, 0x8c, 0x70, 0x00, 0xff);
    FCML_I32("vpshuflw xmm0{k3},xmm1,0ffh", 0x62, 0xf1, 0x7f, 0x0b, 0x70, 0xc1, 0xff);
    FCML_I64("vpshuflw ymm0{k4}{z},ymmword ptr [rax],0ffh", 0x62, 0xf1, 0x7f, 0xac, 0x70, 0x00, 0xff);
    FCML_I32("vpshuflw ymm0{k3},ymm1,0ffh", 0x62, 0xf1, 0x7f, 0x2b, 0x70, 0xc1, 0xff);
    FCML_I64("vpshuflw zmm0{k4}{z},zmmword ptr [rax],0ffh", 0x62, 0xf1, 0x7f, 0xcc, 0x70, 0x00, 0xff);
    FCML_I32("vpshuflw zmm0{k3},zmm1,0ffh", 0x62, 0xf1, 0x7f, 0x4b, 0x70, 0xc1, 0xff);
}

void fcml_tf_instruction_PSHUFW(void) {

    FCML_I64( "pshufw mm0,mmword ptr [rax],0ffh", 0x0F, 0x70, 0x00, 0xFF );
    FCML_I32( "pshufw mm0,mm1,0ffh", 0x0F, 0x70, 0xC1, 0xFF );

    FCML_A64( "pshufw $0xff,(%rax),%mm0", 0x0f, 0x70, 0x00, 0xff );
    FCML_A64( "pshufw $0xff,%mm1,%mm0", 0x0f, 0x70, 0xc1, 0xff );
}

void fcml_tf_instruction_PSIGN(void) {

    FCML_I64( "psignb mm0,mmword ptr [rax]", 0x0F, 0x38, 0x08, 0x00 );
    FCML_I32( "psignb mm0,mm1", 0x0F, 0x38, 0x08, 0xC1 );

    FCML_I64( "psignw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x09, 0x00 );
    FCML_I32( "psignw mm0,mm1", 0x0F, 0x38, 0x09, 0xC1 );

    FCML_I64( "psignd mm0,mmword ptr [rax]", 0x0F, 0x38, 0x0A, 0x00 );
    FCML_I32( "psignd mm0,mm1", 0x0F, 0x38, 0x0A, 0xC1 );

    FCML_I64( "psignb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x08, 0x00 );
    FCML_I32( "psignb xmm0,xmm1", 0x66, 0x0F, 0x38, 0x08, 0xC1 );

    FCML_I64( "psignw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x09, 0x00 );
    FCML_I32( "psignw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x09, 0xC1 );

    FCML_I64( "psignd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x0A, 0x00 );
    FCML_I32( "psignd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x0A, 0xC1 );

    FCML_I64( "vpsignb xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x08, 0x00 );
    FCML_I32( "vpsignb xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x08, 0xC1 );

    FCML_I64( "vpsignw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x09, 0x00 );
    FCML_I32( "vpsignw xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x09, 0xC1 );

    FCML_I64( "vpsignd xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x0A, 0x00 );
    FCML_I32( "vpsignd xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x0A, 0xC1 );

    FCML_I64( "vpsignb ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x08, 0x00 );
    FCML_I32( "vpsignb ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x08, 0xC1 );

    FCML_I64( "vpsignw ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x09, 0x00 );
    FCML_I32( "vpsignw ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x09, 0xC1 );

    FCML_I64( "vpsignd ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x0A, 0x00 );
    FCML_I32( "vpsignd ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x0A, 0xC1 );

    FCML_A64( "psignb (%rax),%mm0", 0x0f, 0x38, 0x08, 0x00 );
    FCML_A64( "psignb %mm1,%mm0", 0x0f, 0x38, 0x08, 0xc1 );
    FCML_A64( "psignw (%rax),%mm0", 0x0f, 0x38, 0x09, 0x00 );
    FCML_A64( "psignw %mm1,%mm0", 0x0f, 0x38, 0x09, 0xc1 );
    FCML_A64( "psignd (%rax),%mm0", 0x0f, 0x38, 0x0a, 0x00 );
    FCML_A64( "psignd %mm1,%mm0", 0x0f, 0x38, 0x0a, 0xc1 );
    FCML_A64( "psignb (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x08, 0x00 );
    FCML_A64( "psignb %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x08, 0xc1 );
    FCML_A64( "psignw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x09, 0x00 );
    FCML_A64( "psignw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x09, 0xc1 );
    FCML_A64( "psignd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x0a, 0x00 );
    FCML_A64( "psignd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x0a, 0xc1 );
    FCML_A64( "vpsignb (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x08, 0x00 );
    FCML_A64( "vpsignb %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x08, 0xc1 );
    FCML_A64( "vpsignw (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x09, 0x00 );
    FCML_A64( "vpsignw %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x09, 0xc1 );
    FCML_A64( "vpsignd (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x0a, 0x00 );
    FCML_A64( "vpsignd %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x0a, 0xc1 );
    FCML_A64( "vpsignb (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x08, 0x00 );
    FCML_A64( "vpsignb %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x08, 0xc1 );
    FCML_A64( "vpsignw (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x09, 0x00 );
    FCML_A64( "vpsignw %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x09, 0xc1 );
    FCML_A64( "vpsignd (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x0a, 0x00 );
    FCML_A64( "vpsignd %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x0a, 0xc1 );
}

void fcml_tf_instruction_PSLLDQ(void) {

    FCML_I32( "pslldq xmm1,0ffh", 0x66, 0x0F, 0x73, 0xF9, 0xFF );
    FCML_A64( "pslldq $0xff,%xmm1", 0x66, 0x0f, 0x73, 0xf9, 0xff );

    FCML_I32_M("vpslldq xmm3,xmm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x73, 0xf8, 0xff), FCML_MI(0xc5, 0xe1, 0x73, 0xf8, 0xff));
    FCML_I32_M("vpslldq ymm3,ymm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x73, 0xf8, 0xff), FCML_MI(0xc5, 0xe5, 0x73, 0xf8, 0xff));
    FCML_A64_M("vpslldq $0xff,%xmm0,%xmm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x73, 0xf8, 0xff), FCML_MI(0xc5, 0xe1, 0x73, 0xf8, 0xff));
    FCML_A64_M("vpslldq $0xff,%ymm0,%ymm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x73, 0xf8, 0xff), FCML_MI(0xc5, 0xe5, 0x73, 0xf8, 0xff));
    FCML_I32_M("vpslldq xmm3,xmm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x73, 0xf8, 0xff), FCML_MI(0xc5, 0xe1, 0x73, 0xf8, 0xff));
    FCML_I32_M("vpslldq ymm3,ymm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x73, 0xf8, 0xff), FCML_MI(0xc5, 0xe5, 0x73, 0xf8, 0xff));
    FCML_A64_M("vpslldq $0xff,%xmm0,%xmm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x73, 0xf8, 0xff), FCML_MI(0xc5, 0xe1, 0x73, 0xf8, 0xff));
    FCML_A64_M("vpslldq $0xff,%ymm0,%ymm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x73, 0xf8, 0xff), FCML_MI(0xc5, 0xe5, 0x73, 0xf8, 0xff));
    FCML_A64("vpslldq $0xff,%zmm0,%zmm3", 0x62, 0xf1, 0x65, 0x48, 0x73, 0xf8, 0xff);
}

void fcml_tf_instruction_PSLL(void) {

    FCML_I64( "psllw mm0,mmword ptr [rax]", 0x0F, 0xF1, 0x00 );
    FCML_I32( "psllw mm0,mm1", 0x0F, 0xF1, 0xC1 );
    FCML_I64( "pslld mm0,mmword ptr [rax]", 0x0F, 0xF2, 0x00 );
    FCML_I32( "pslld mm0,mm1", 0x0F, 0xF2, 0xC1 );
    FCML_I64( "psllq mm0,mmword ptr [rax]", 0x0F, 0xF3, 0x00 );
    FCML_I32( "psllq mm0,mm1", 0x0F, 0xF3, 0xC1 );

    FCML_I64( "psllw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF1, 0x00 );
    FCML_I32( "psllw xmm0,xmm1", 0x66, 0x0F, 0xF1, 0xC1 );
    FCML_I64( "pslld xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF2, 0x00 );
    FCML_I32( "pslld xmm0,xmm1", 0x66, 0x0F, 0xF2, 0xC1 );
    FCML_I64( "psllq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF3, 0x00 );
    FCML_I32( "psllq xmm0,xmm1", 0x66, 0x0F, 0xF3, 0xC1 );

    FCML_I32( "psllw mm1,0ffh", 0x0F, 0x71, 0xF1, 0xFF );
    FCML_I32( "pslld mm2,0ffh", 0x0F, 0x72, 0xF2, 0xFF );
    FCML_I32( "psllq mm3,0ffh", 0x0F, 0x73, 0xf3, 0xFF );

    FCML_I32( "psllw xmm1,0ffh", 0x66, 0x0F, 0x71, 0xF1, 0xFF );
    FCML_I32( "pslld xmm1,0ffh", 0x66, 0x0F, 0x72, 0xF1, 0xFF );
    FCML_I32( "psllq xmm1,0ffh", 0x66, 0x0F, 0x73, 0xF1, 0xFF );

    FCML_I64_M("vpslld xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xf2, 0x00), FCML_MI(0xc5, 0xf9, 0xf2, 0x00));
    FCML_I64_M("vpslld ymm0,ymm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xf2, 0x00), FCML_MI(0xc5, 0xfd, 0xf2, 0x00));
    FCML_I32_M("vpslld xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xf2, 0xc1), FCML_MI(0xc5, 0xf9, 0xf2, 0xc1));
    FCML_I32_M("vpslld ymm0,ymm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xf2, 0xc1), FCML_MI(0xc5, 0xfd, 0xf2, 0xc1));
    FCML_I64_M("vpsllq xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0xFD, 0x08, 0xf3, 0x00), FCML_MI(0xc5, 0xf9, 0xf3, 0x00));
    FCML_I64_M("vpsllq ymm0,ymm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0xFD, 0x28, 0xf3, 0x00), FCML_MI(0xc5, 0xfd, 0xf3, 0x00));
    FCML_I32_M("vpsllq xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0xFD, 0x08, 0xf3, 0xc1), FCML_MI(0xc5, 0xf9, 0xf3, 0xc1));
    FCML_I32_M("vpsllq ymm0,ymm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0xFD, 0x28, 0xf3, 0xc1), FCML_MI(0xc5, 0xfd, 0xf3, 0xc1));

    FCML_I32_M("vpsllq xmm3,xmm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0xE5, 0x08, 0x73, 0xf0, 0xff), FCML_MI(0xc5, 0xe1, 0x73, 0xf0, 0xff));
    FCML_I64_M("vpsllq xmm3,xmm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0xE5, 0x08, 0x73, 0xf0, 0xff), FCML_MI(0xc5, 0xe1, 0x73, 0xf0, 0xff));
    FCML_I32_M("vpsllq ymm3,ymm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0xE5, 0x28, 0x73, 0xf0, 0xff), FCML_MI(0xc5, 0xe5, 0x73, 0xf0, 0xff));
    FCML_I64_M("vpsllq ymm3,ymm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0xE5, 0x28, 0x73, 0xf0, 0xff), FCML_MI(0xc5, 0xe5, 0x73, 0xf0, 0xff));

    FCML_I32_M("vpslld xmm3,xmm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x72, 0xf0, 0xff), FCML_MI(0xc5, 0xe1, 0x72, 0xf0, 0xff));
    FCML_I64_M("vpslld xmm3,xmm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x72, 0xf0, 0xff), FCML_MI(0xc5, 0xe1, 0x72, 0xf0, 0xff));

    FCML_A64( "psllw (%rax),%mm0", 0x0f, 0xf1, 0x00 );
    FCML_A64( "psllw %mm1,%mm0", 0x0f, 0xf1, 0xc1 );
    FCML_A64( "pslld (%rax),%mm0", 0x0f, 0xf2, 0x00 );
    FCML_A64( "pslld %mm1,%mm0", 0x0f, 0xf2, 0xc1 );
    FCML_A64( "psllq (%rax),%mm0", 0x0f, 0xf3, 0x00 );
    FCML_A64( "psllq %mm1,%mm0", 0x0f, 0xf3, 0xc1 );
    FCML_A64( "psllw (%rax),%xmm0", 0x66, 0x0f, 0xf1, 0x00 );
    FCML_A64( "psllw %xmm1,%xmm0", 0x66, 0x0f, 0xf1, 0xc1 );
    FCML_A64( "pslld (%rax),%xmm0", 0x66, 0x0f, 0xf2, 0x00 );
    FCML_A64( "pslld %xmm1,%xmm0", 0x66, 0x0f, 0xf2, 0xc1 );
    FCML_A64( "psllq (%rax),%xmm0", 0x66, 0x0f, 0xf3, 0x00 );
    FCML_A64( "psllq %xmm1,%xmm0", 0x66, 0x0f, 0xf3, 0xc1 );
    FCML_A64( "psllw $0xff,%mm1", 0x0f, 0x71, 0xf1, 0xff );
    FCML_A64( "pslld $0xff,%mm2", 0x0f, 0x72, 0xf2, 0xff );
    FCML_A64( "psllq $0xff,%mm3", 0x0f, 0x73, 0xf3, 0xff );
    FCML_A64( "psllw $0xff,%xmm1", 0x66, 0x0f, 0x71, 0xf1, 0xff );
    FCML_A64( "pslld $0xff,%xmm1", 0x66, 0x0f, 0x72, 0xf1, 0xff );
    FCML_A64( "psllq $0xff,%xmm1", 0x66, 0x0f, 0x73, 0xf1, 0xff );
    FCML_A64_M("vpslld (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xf2, 0x00), FCML_MI(0xc5, 0xf9, 0xf2, 0x00));
    FCML_A64_M("vpslld (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xf2, 0x00), FCML_MI(0xc5, 0xfd, 0xf2, 0x00));
    FCML_A64_M("vpslld %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xf2, 0xc1), FCML_MI(0xc5, 0xf9, 0xf2, 0xc1));
    FCML_A64_M("vpslld %xmm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xf2, 0xc1), FCML_MI(0xc5, 0xfd, 0xf2, 0xc1));
    FCML_A64_M("vpsllq (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0xFD, 0x08, 0xf3, 0x00), FCML_MI(0xc5, 0xf9, 0xf3, 0x00));
    FCML_A64_M("vpsllq (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0xFD, 0x28, 0xf3, 0x00), FCML_MI(0xc5, 0xfd, 0xf3, 0x00));
    FCML_A64_M("vpsllq %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0xFD, 0x08, 0xf3, 0xc1), FCML_MI(0xc5, 0xf9, 0xf3, 0xc1));
    FCML_A64_M("vpsllq %xmm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0xFD, 0x28, 0xf3, 0xc1), FCML_MI(0xc5, 0xfd, 0xf3, 0xc1));
    FCML_A64_M("vpslld $0xff,%xmm0,%xmm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x72, 0xf0, 0xff), FCML_MI(0xc5, 0xe1, 0x72, 0xf0, 0xff));
    FCML_A64_M("vpslld $0xff,%ymm0,%ymm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x72, 0xf0, 0xff), FCML_MI(0xc5, 0xe5, 0x72, 0xf0, 0xff));
    FCML_A64_M("vpslld $0xff,%ymm0,%ymm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x72, 0xf0, 0xff), FCML_MI(0xc5, 0xe5, 0x72, 0xf0, 0xff));
    FCML_A64_M("vpsllq $0xff,%ymm0,%ymm3", 2, FCML_MI(0x62, 0xf1, 0xE5, 0x28, 0x73, 0xf0, 0xff), FCML_MI(0xc5, 0xe5, 0x73, 0xf0, 0xff));

    FCML_A64("vpslld $0x00,(%rsi){1to16},%zmm6{%k2}", 0x62, 0xf1, 0x4d, 0x5a, 0x72, 0x36, 0x00);
    FCML_A64("vpslld $0x00,(%rsi),%zmm6{%k2}", 0x62, 0xf1, 0x4d, 0x4a, 0x72, 0x36, 0x00);
    FCML_A64("vpslld $0x00,%zmm2,%zmm6{%k2}", 0x62, 0xf1, 0x4d, 0x4a, 0x72, 0xf2, 0x00);
    FCML_A64("vpslld $0x00,%ymm2,%ymm6{%k2}", 0x62, 0xf1, 0x4d, 0x2a, 0x72, 0xf2, 0x00);
    FCML_A64("vpslld $0x00,%xmm2,%xmm6{%k2}{z}", 0x62, 0xf1, 0x4d, 0x8a, 0x72, 0xf2, 0x00);

    FCML_A64("vpsllq $0x00,(%rsi){1to8},%zmm6{%k2}", 0x62, 0xf1, 0xCD, 0x5a, 0x73, 0x36, 0x00);
    FCML_A64("vpsllq $0x00,(%rsi),%zmm6{%k2}", 0x62, 0xf1, 0xCD, 0x4a, 0x73, 0x36, 0x00);
    FCML_A64("vpsllq $0x00,%zmm2,%zmm6{%k2}", 0x62, 0xf1, 0xCD, 0x4a, 0x73, 0xf2, 0x00);
    FCML_A64("vpsllq $0x00,%ymm2,%ymm6{%k2}", 0x62, 0xf1, 0xCD, 0x2a, 0x73, 0xf2, 0x00);
    FCML_A64("vpsllq $0x00,%xmm2,%xmm6{%k2}{z}", 0x62, 0xf1, 0xCD, 0x8a, 0x73, 0xf2, 0x00);

    FCML_I64_M("vpsllw xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xf1, 0x00), FCML_MI(0xc5, 0xf9, 0xf1, 0x00));
    FCML_I64_M("vpsllw ymm0,ymm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xf1, 0x00), FCML_MI(0xc5, 0xfd, 0xf1, 0x00));
    FCML_I64("vpsllw zmm0,zmm0,xmmword ptr [rax]", 0x62, 0xf1, 0x7d, 0x48, 0xf1, 0x00);
    FCML_I64("vpsllw zmm0{k3},zmm0,xmmword ptr [rax]", 0x62, 0xf1, 0x7d, 0x4b, 0xf1, 0x00);
    FCML_I64("vpsllw zmm0{k4}{z},zmm0,xmmword ptr [rax]", 0x62, 0xf1, 0x7d, 0xcc, 0xf1, 0x00);
    FCML_I32_M("vpsllw xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xf1, 0xc1), FCML_MI(0xc5, 0xf9, 0xf1, 0xc1));
    FCML_I32("vpsllw xmm0{k2}{z},xmm0,xmm1", 0x62, 0xf1, 0x7d, 0x8a, 0xf1, 0xc1);
    FCML_I32("vpsllw xmm0{k3},xmm0,xmm1", 0x62, 0xf1, 0x7d, 0x0b, 0xf1, 0xc1);
    FCML_I32_M("vpsllw ymm0,ymm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xf1, 0xc1), FCML_MI(0xc5, 0xfd, 0xf1, 0xc1));
    FCML_I32("vpsllw ymm0{k4}{z},ymm0,xmm1", 0x62, 0xf1, 0x7d, 0xac, 0xf1, 0xc1);
    FCML_I32("vpsllw ymm0{k2},ymm0,xmm1", 0x62, 0xf1, 0x7d, 0x2a, 0xf1, 0xc1);
    FCML_I32_M("vpsllw xmm3,xmm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x71, 0xf0, 0xff), FCML_MI(0xc5, 0xe1, 0x71, 0xf0, 0xff));
    FCML_I64_M("vpsllw xmm3,xmm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x71, 0xf0, 0xff), FCML_MI(0xc5, 0xe1, 0x71, 0xf0, 0xff));
    FCML_I32_M("vpsllw ymm3,ymm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x71, 0xf0, 0xff), FCML_MI(0xc5, 0xe5, 0x71, 0xf0, 0xff));
    FCML_I64_M("vpsllw ymm3,ymm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x71, 0xf0, 0xff), FCML_MI(0xc5, 0xe5, 0x71, 0xf0, 0xff));
    FCML_A64_M("vpsllw (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xf1, 0x00), FCML_MI(0xc5, 0xf9, 0xf1, 0x00));
    FCML_A64_M("vpsllw (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xf1, 0x00), FCML_MI(0xc5, 0xfd, 0xf1, 0x00));
    FCML_A64_M("vpsllw %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xf1, 0xc1), FCML_MI(0xc5, 0xf9, 0xf1, 0xc1));
    FCML_A64_M("vpsllw %xmm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xf1, 0xc1), FCML_MI(0xc5, 0xfd, 0xf1, 0xc1));
    FCML_A64_M("vpsllw $0xff,%xmm0,%xmm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x71, 0xf0, 0xff), FCML_MI(0xc5, 0xe1, 0x71, 0xf0, 0xff));
    FCML_A64_M("vpsllw $0xff,%ymm0,%ymm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x71, 0xf0, 0xff), FCML_MI(0xc5, 0xe5, 0x71, 0xf0, 0xff));
    FCML_A64("vpsllw $0xff,%zmm0,%zmm3", 0x62, 0xf1, 0x65, 0x48, 0x71, 0xf0, 0xff);
    FCML_A64("vpsllw $0xff,%zmm0,%zmm3{%k3}", 0x62, 0xf1, 0x65, 0x4b, 0x71, 0xf0, 0xff);
    FCML_A64("vpsllw $0xff,%zmm0,%zmm3{%k1}{z}", 0x62, 0xf1, 0x65, 0xc9, 0x71, 0xf0, 0xff);
}

void fcml_tf_instruction_PSRA(void) {

    FCML_I64( "psraw mm0,mmword ptr [rax]", 0x0F, 0xE1, 0x00 );
    FCML_I32( "psraw mm0,mm1", 0x0F, 0xE1, 0xC1 );
    FCML_I64( "psrad mm0,mmword ptr [rax]", 0x0F, 0xE2, 0x00 );
    FCML_I32( "psrad mm0,mm1", 0x0F, 0xE2, 0xC1 );

    FCML_I64( "psraw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE1, 0x00 );
    FCML_I32( "psraw xmm0,xmm1", 0x66, 0x0F, 0xE1, 0xC1 );
    FCML_I64( "psrad xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE2, 0x00 );
    FCML_I32( "psrad xmm0,xmm1", 0x66, 0x0F, 0xE2, 0xC1 );

    FCML_I64_M("vpsraw xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xe1, 0x00), FCML_MI(0xc5, 0xf9, 0xe1, 0x00));
    FCML_I32_M("vpsraw xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xe1, 0xc1), FCML_MI(0xc5, 0xf9, 0xe1, 0xc1));
    FCML_I64_M("vpsrad ymm0,ymm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xe2, 0x00), FCML_MI(0xc5, 0xfd, 0xe2, 0x00));
    FCML_I32_M("vpsrad ymm0,ymm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xe2, 0xc1), FCML_MI(0xc5, 0xfd, 0xe2, 0xc1));

    FCML_I64_M("vpsraw ymm0,ymm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xe1, 0x00), FCML_MI(0xc5, 0xfd, 0xe1, 0x00));
    FCML_I32_M("vpsraw ymm0,ymm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xe1, 0xc1), FCML_MI(0xc5, 0xfd, 0xe1, 0xc1));

    FCML_I64_M("vpsrad ymm0,ymm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xe2, 0x00), FCML_MI(0xc5, 0xfd, 0xe2, 0x00));
    FCML_I32_M("vpsrad ymm0,ymm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xe2, 0xc1), FCML_MI(0xc5, 0xfd, 0xe2, 0xc1));

    FCML_I32( "psraw mm1,0ffh", 0x0F, 0x71, 0xE1, 0xFF );
    FCML_I32( "psrad mm2,0ffh", 0x0F, 0x72, 0xE2, 0xFF );

    FCML_I32( "psraw xmm1,0ffh", 0x66, 0x0F, 0x71, 0xE1, 0xFF );
    FCML_I32( "psrad xmm1,0ffh", 0x66, 0x0F, 0x72, 0xE1, 0xFF );

    FCML_I32_M("vpsraw xmm3,xmm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x71, 0xe0, 0xff), FCML_MI(0xc5, 0xe1, 0x71, 0xe0, 0xff));
    FCML_I32_M("vpsrad xmm3,xmm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x72, 0xe0, 0xff), FCML_MI(0xc5, 0xe1, 0x72, 0xe0, 0xff));

    FCML_I32_M("vpsraw ymm3,ymm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x71, 0xe0, 0xff), FCML_MI(0xc5, 0xe5, 0x71, 0xe0, 0xff));
    FCML_I32_M("vpsrad ymm3,ymm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x72, 0xe0, 0xff), FCML_MI(0xc5, 0xe5, 0x72, 0xe0, 0xff));

    FCML_A64( "psraw (%rax),%mm0", 0x0f, 0xe1, 0x00 );
    FCML_A64( "psraw %mm1,%mm0", 0x0f, 0xe1, 0xc1 );
    FCML_A64( "psrad (%rax),%mm0", 0x0f, 0xe2, 0x00 );
    FCML_A64( "psrad %mm1,%mm0", 0x0f, 0xe2, 0xc1 );
    FCML_A64( "psraw (%rax),%xmm0", 0x66, 0x0f, 0xe1, 0x00 );
    FCML_A64( "psraw %xmm1,%xmm0", 0x66, 0x0f, 0xe1, 0xc1 );
    FCML_A64( "psrad (%rax),%xmm0", 0x66, 0x0f, 0xe2, 0x00 );
    FCML_A64( "psrad %xmm1,%xmm0", 0x66, 0x0f, 0xe2, 0xc1 );
    FCML_A64_M("vpsraw (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xe1, 0x00), FCML_MI(0xc5, 0xf9, 0xe1, 0x00));
    FCML_A64_M("vpsraw %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xe1, 0xc1), FCML_MI(0xc5, 0xf9, 0xe1, 0xc1));
    FCML_A64("vpsraw (%rax),%xmm4,%xmm0{%k4}{z}", 0x62, 0xf1, 0x5d, 0x8c, 0xe1, 0x00);
    FCML_A64("vpsraw (%rax),%ymm4,%ymm0{%k4}{z}", 0x62, 0xf1, 0x5d, 0xac, 0xe1, 0x00);
    FCML_A64("vpsraw (%rax),%zmm4,%zmm0{%k4}{z}", 0x62, 0xf1, 0x5d, 0xcc, 0xe1, 0x00);
    FCML_A64_M("vpsrad (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xe2, 0x00), FCML_MI(0xc5, 0xf9, 0xe2, 0x00));
    FCML_A64_M("vpsrad %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xe2, 0xc1), FCML_MI(0xc5, 0xf9, 0xe2, 0xc1));
    FCML_A64_M("vpsraw (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xe1, 0x00), FCML_MI(0xc5, 0xfd, 0xe1, 0x00));
    FCML_A64_M("vpsraw %xmm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xe1, 0xc1), FCML_MI(0xc5, 0xfd, 0xe1, 0xc1));
    FCML_A64_M("vpsrad (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xe2, 0x00), FCML_MI(0xc5, 0xfd, 0xe2, 0x00));
    FCML_A64_M("vpsrad %xmm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xe2, 0xc1), FCML_MI(0xc5, 0xfd, 0xe2, 0xc1));
    FCML_A64( "psraw $0xff,%mm1", 0x0f, 0x71, 0xe1, 0xff );
    FCML_A64( "psrad $0xff,%mm2", 0x0f, 0x72, 0xe2, 0xff );
    FCML_A64( "psraw $0xff,%xmm1", 0x66, 0x0f, 0x71, 0xe1, 0xff );
    FCML_A64( "psrad $0xff,%xmm1", 0x66, 0x0f, 0x72, 0xe1, 0xff );
    FCML_A64_M("vpsraw $0xff,%xmm0,%xmm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x71, 0xe0, 0xff), FCML_MI(0xc5, 0xe1, 0x71, 0xe0, 0xff));
    FCML_A64_M("vpsrad $0xff,%xmm0,%xmm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x72, 0xe0, 0xff), FCML_MI(0xc5, 0xe1, 0x72, 0xe0, 0xff));
    FCML_A64_M("vpsraw $0xff,%ymm0,%ymm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x71, 0xe0, 0xff), FCML_MI(0xc5, 0xe5, 0x71, 0xe0, 0xff));
    FCML_A64_M("vpsrad $0xff,%ymm0,%ymm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x72, 0xe0, 0xff), FCML_MI(0xc5, 0xe5, 0x72, 0xe0, 0xff));

    FCML_A64("vpsraq $0x00,(%rsi){1to8},%zmm6{%k2}", 0x62, 0xf1, 0xcd, 0x5a, 0x72, 0x26, 0x00);
    FCML_A64("vpsraq $0x00,(%rsi),%zmm6{%k2}", 0x62, 0xf1, 0xcd, 0x4a, 0x72, 0x26, 0x00);
    FCML_A64("vpsraq $0x00,%zmm2,%zmm6{%k2}", 0x62, 0xf1, 0xcd, 0x4a, 0x72, 0xe2, 0x00);
    FCML_A64("vpsraq $0x00,%ymm2,%ymm6{%k2}", 0x62, 0xf1, 0xcd, 0x2a, 0x72, 0xe2, 0x00);
    FCML_A64("vpsraq $0x00,%xmm2,%xmm6{%k2}{z}", 0x62, 0xf1, 0xcd, 0x8a, 0x72, 0xe2, 0x00);

    FCML_A64("vpsrad $0x00,(%rsi){1to16},%zmm6{%k2}", 0x62, 0xf1, 0x4d, 0x5a, 0x72, 0x26, 0x00);
    FCML_A64("vpsrad $0x00,(%rsi),%zmm6{%k2}", 0x62, 0xf1, 0x4d, 0x4a, 0x72, 0x26, 0x00);
    FCML_A64("vpsrad $0x00,%zmm2,%zmm6{%k2}", 0x62, 0xf1, 0x4d, 0x4a, 0x72, 0xe2, 0x00);
    FCML_A64("vpsrad $0x00,%ymm2,%ymm6{%k2}", 0x62, 0xf1, 0x4d, 0x2a, 0x72, 0xe2, 0x00);
    FCML_A64("vpsrad $0x00,%xmm2,%xmm6{%k2}{z}", 0x62, 0xf1, 0x4d, 0x8a, 0x72, 0xe2, 0x00);
}

void fcml_tf_instruction_PSRLDQ(void) {

    FCML_I32("psrldq xmm1,0ffh", 0x66, 0x0f, 0x73, 0xd9, 0xff);
    FCML_A64("psrldq $0xff,%xmm1", 0x66, 0x0f, 0x73, 0xd9, 0xff);

    FCML_A64_M("vpsrldq $0xff,%xmm0,%xmm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x73, 0xd8, 0xff), FCML_MI(0xc5, 0xe1, 0x73, 0xd8, 0xff));
    FCML_A64_M("vpsrldq $0xff,%ymm0,%ymm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x73, 0xd8, 0xff), FCML_MI(0xc5, 0xe5, 0x73, 0xd8, 0xff));
    FCML_I32_M("vpsrldq xmm3,xmm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x73, 0xd8, 0xff), FCML_MI(0xc5, 0xe1, 0x73, 0xd8, 0xff));
    FCML_I32_M("vpsrldq ymm3,ymm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x73, 0xd8, 0xff), FCML_MI(0xc5, 0xe5, 0x73, 0xd8, 0xff));
    FCML_I32("vpsrldq zmm3,zmm0,0ffh", 0x62, 0xf1, 0x65, 0x48, 0x73, 0xd8, 0xff);
}

void fcml_tf_instruction_PSRL(void) {

    FCML_I64( "psrlw mm0,mmword ptr [rax]", 0x0F, 0xD1, 0x00 );
    FCML_I32( "psrlw mm0,mm1", 0x0F, 0xD1, 0xC1 );

    FCML_I64( "psrld mm0,mmword ptr [rax]", 0x0F, 0xD2, 0x00 );
    FCML_I32( "psrld mm0,mm1", 0x0F, 0xD2, 0xC1 );

    FCML_I64( "psrlq mm0,mmword ptr [rax]", 0x0F, 0xD3, 0x00 );
    FCML_I32( "psrlq mm0,mm1", 0x0F, 0xD3, 0xC1 );

    FCML_I64( "psrlw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xD1, 0x00 );
    FCML_I32( "psrlw xmm0,xmm1", 0x66, 0x0F, 0xD1, 0xC1 );

    FCML_I64( "psrld xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xD2, 0x00 );
    FCML_I32( "psrld xmm0,xmm1", 0x66, 0x0F, 0xD2, 0xC1 );

    FCML_I64( "psrlq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xD3, 0x00 );
    FCML_I32( "psrlq xmm0,xmm1", 0x66, 0x0F, 0xD3, 0xC1 );

    FCML_I32( "psrlw mm1,0ffh", 0x0F, 0x71, 0xD1, 0xFF );
    FCML_I32( "psrld mm2,0ffh", 0x0F, 0x72, 0xD2, 0xFF );
    FCML_I32( "psrlq mm3,0ffh", 0x0F, 0x73, 0xD3, 0xFF );
    FCML_I32( "psrlw xmm1,0ffh", 0x66, 0x0F, 0x71, 0xD1, 0xFF );
    FCML_I32( "psrld xmm1,0ffh", 0x66, 0x0F, 0x72, 0xD1, 0xFF );
    FCML_I32( "psrlq xmm1,0ffh", 0x66, 0x0F, 0x73, 0xD1, 0xFF );

    FCML_I64_D( "vpsrlw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE1, 0x79, 0xD1, 0x00 );
    FCML_I32_D( "vpsrlw xmm0,xmm0,xmm1", 0xC4, 0xE1, 0x79, 0xD1, 0xC1 );
    FCML_I32_D( "vpsrlw xmm3,xmm0,0ffh", 0xC4, 0xE1, 0x61, 0x71, 0xD0, 0xFF );
    FCML_I32_D( "vpsrld xmm3,xmm0,0ffh", 0xC4, 0xE1, 0x61, 0x72, 0xD0, 0xFF );
    FCML_I32_D( "vpsrlq xmm3,xmm0,0ffh", 0xC4, 0xE1, 0x61, 0x73, 0xD0, 0xFF );
    FCML_I32_D( "vpsrlw ymm3,ymm0,0ffh", 0xC4, 0xE1, 0x65, 0x71, 0xD0, 0xFF );

    FCML_A64( "psrlw (%rax),%mm0", 0x0f, 0xd1, 0x00 );
    FCML_A64( "psrlw %mm1,%mm0", 0x0f, 0xd1, 0xc1 );
    FCML_A64( "psrld (%rax),%mm0", 0x0f, 0xd2, 0x00 );
    FCML_A64( "psrld %mm1,%mm0", 0x0f, 0xd2, 0xc1 );
    FCML_A64( "psrlq (%rax),%mm0", 0x0f, 0xd3, 0x00 );
    FCML_A64( "psrlq %mm1,%mm0", 0x0f, 0xd3, 0xc1 );
    FCML_A64( "psrlw (%rax),%xmm0", 0x66, 0x0f, 0xd1, 0x00 );
    FCML_A64( "psrlw %xmm1,%xmm0", 0x66, 0x0f, 0xd1, 0xc1 );
    FCML_A64( "psrld (%rax),%xmm0", 0x66, 0x0f, 0xd2, 0x00 );
    FCML_A64( "psrld %xmm1,%xmm0", 0x66, 0x0f, 0xd2, 0xc1 );
    FCML_A64( "psrlq (%rax),%xmm0", 0x66, 0x0f, 0xd3, 0x00 );
    FCML_A64( "psrlq %xmm1,%xmm0", 0x66, 0x0f, 0xd3, 0xc1 );
    FCML_A64( "psrlw $0xff,%mm1", 0x0f, 0x71, 0xd1, 0xff );
    FCML_A64( "psrld $0xff,%mm2", 0x0f, 0x72, 0xd2, 0xff );
    FCML_A64( "psrlq $0xff,%mm3", 0x0f, 0x73, 0xd3, 0xff );
    FCML_A64( "psrlw $0xff,%xmm1", 0x66, 0x0f, 0x71, 0xd1, 0xff );
    FCML_A64( "psrld $0xff,%xmm1", 0x66, 0x0f, 0x72, 0xd1, 0xff );
    FCML_A64( "psrlq $0xff,%xmm1", 0x66, 0x0f, 0x73, 0xd1, 0xff );

    FCML_I64_M("vpsrlw xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xd1, 0x00), FCML_MI(0xc5, 0xf9, 0xd1, 0x00));
    FCML_I32_M("vpsrlw xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xd1, 0xc1), FCML_MI(0xc5, 0xf9, 0xd1, 0xc1));
    FCML_I64_M("vpsrlw ymm0,ymm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xd1, 0x00), FCML_MI(0xc5, 0xfd, 0xd1, 0x00));
    FCML_I32_M("vpsrlw ymm0,ymm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xd1, 0xc1), FCML_MI(0xc5, 0xfd, 0xd1, 0xc1));
    FCML_I32_M("vpsrlw xmm3,xmm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x71, 0xd0, 0xff), FCML_MI(0xc5, 0xe1, 0x71, 0xd0, 0xff));
    FCML_I32_M("vpsrlw ymm3,ymm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x71, 0xd0, 0xff), FCML_MI(0xc5, 0xe5, 0x71, 0xd0, 0xff));
    FCML_A64_M("vpsrlw (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xd1, 0x00), FCML_MI(0xc5, 0xf9, 0xd1, 0x00));
    FCML_A64_M("vpsrlw %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xd1, 0xc1), FCML_MI(0xc5, 0xf9, 0xd1, 0xc1));
    FCML_A64_M("vpsrlw (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xd1, 0x00), FCML_MI(0xc5, 0xfd, 0xd1, 0x00));
    FCML_A64_M("vpsrlw %xmm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xd1, 0xc1), FCML_MI(0xc5, 0xfd, 0xd1, 0xc1));
    FCML_A64_M("vpsrlw $0xff,%xmm0,%xmm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x71, 0xd0, 0xff), FCML_MI(0xc5, 0xe1, 0x71, 0xd0, 0xff));
    FCML_A64_M("vpsrlw $0xff,%ymm0,%ymm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x71, 0xd0, 0xff), FCML_MI(0xc5, 0xe5, 0x71, 0xd0, 0xff));

    FCML_I64_M("vpsrld xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xd2, 0x00), FCML_MI(0xc5, 0xf9, 0xd2, 0x00));
    FCML_I32_M("vpsrld xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xd2, 0xc1), FCML_MI(0xc5, 0xf9, 0xd2, 0xc1));
    FCML_I64_M("vpsrld ymm0,ymm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xd2, 0x00), FCML_MI(0xc5, 0xfd, 0xd2, 0x00));
    FCML_I32_M("vpsrld ymm0,ymm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xd2, 0xc1), FCML_MI(0xc5, 0xfd, 0xd2, 0xc1));
    FCML_I32_M("vpsrld xmm3,xmm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x72, 0xd0, 0xff), FCML_MI(0xc5, 0xe1, 0x72, 0xd0, 0xff));
    FCML_A64_M("vpsrld (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xd2, 0x00), FCML_MI(0xc5, 0xf9, 0xd2, 0x00));
    FCML_A64_M("vpsrld %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xd2, 0xc1), FCML_MI(0xc5, 0xf9, 0xd2, 0xc1));
    FCML_A64_M("vpsrld (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xd2, 0x00), FCML_MI(0xc5, 0xfd, 0xd2, 0x00));
    FCML_A64_M("vpsrld %xmm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xd2, 0xc1), FCML_MI(0xc5, 0xfd, 0xd2, 0xc1));
    FCML_A64_M("vpsrld $0xff,%xmm0,%xmm3", 2, FCML_MI(0x62, 0xf1, 0x65, 0x08, 0x72, 0xd0, 0xff), FCML_MI(0xc5, 0xe1, 0x72, 0xd0, 0xff));

    FCML_I64_M("vpsrlq xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0xd3, 0x00), FCML_MI(0xc5, 0xf9, 0xd3, 0x00));
    FCML_I32_M("vpsrlq xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0xd3, 0xc1), FCML_MI(0xc5, 0xf9, 0xd3, 0xc1));
    FCML_I32_M("vpsrlq xmm3,xmm0,0ffh", 2, FCML_MI(0x62, 0xf1, 0xe5, 0x08, 0x73, 0xd0, 0xff), FCML_MI(0xc5, 0xe1, 0x73, 0xd0, 0xff));
    FCML_A64_M("vpsrlq (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0xd3, 0x00), FCML_MI(0xc5, 0xf9, 0xd3, 0x00));
    FCML_A64_M("vpsrlq %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0xd3, 0xc1), FCML_MI(0xc5, 0xf9, 0xd3, 0xc1));
    FCML_A64_M("vpsrlq $0xff,%xmm0,%xmm3", 2, FCML_MI(0x62, 0xf1, 0xe5, 0x08, 0x73, 0xd0, 0xff), FCML_MI(0xc5, 0xe1, 0x73, 0xd0, 0xff));
    FCML_A64("vpsrlq $0x00,(%rsi){1to8},%zmm6{%k2}", 0x62, 0xf1, 0xcd, 0x5a, 0x73, 0x16, 0x00);
    FCML_A64("vpsrlq $0x00,(%rsi),%zmm6{%k2}", 0x62, 0xf1, 0xcd, 0x4a, 0x73, 0x16, 0x00);
    FCML_A64("vpsrlq $0x00,%zmm2,%zmm6{%k2}", 0x62, 0xf1, 0xcd, 0x4a, 0x73, 0xd2, 0x00);
    FCML_A64("vpsrlq $0x00,%ymm2,%ymm6{%k2}", 0x62, 0xf1, 0xcd, 0x2a, 0x73, 0xd2, 0x00);
    FCML_A64("vpsrlq $0x00,%xmm2,%xmm6{%k2}{z}", 0x62, 0xf1, 0xcd, 0x8a, 0x73, 0xd2, 0x00);
}

void fcml_tf_instruction_PSUB(void) {

    FCML_I64( "psubb mm0,mmword ptr [rax]", 0x0F, 0xF8, 0x00 );
    FCML_I32( "psubb mm0,mm1", 0x0F, 0xF8, 0xC1 );

    FCML_I64( "psubw mm0,mmword ptr [rax]", 0x0F, 0xF9, 0x00 );
    FCML_I32( "psubw mm0,mm1", 0x0F, 0xF9, 0xC1 );

    FCML_I64( "psubd mm0,mmword ptr [rax]", 0x0F, 0xFA, 0x00 );
    FCML_I32( "psubd mm0,mm1", 0x0F, 0xFA, 0xC1 );

    FCML_I64( "psubb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF8, 0x00 );
    FCML_I32( "psubb xmm0,xmm1", 0x66, 0x0F, 0xF8, 0xC1 );

    FCML_I64( "psubw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF9, 0x00 );
    FCML_I32( "psubw xmm0,xmm1", 0x66, 0x0F, 0xF9, 0xC1 );

    FCML_I64( "psubd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xFA, 0x00 );
    FCML_I32( "psubd xmm0,xmm1", 0x66, 0x0F, 0xFA, 0xC1 );

    FCML_A64( "psubb (%rax),%mm0", 0x0f, 0xf8, 0x00 );
    FCML_A64( "psubb %mm1,%mm0", 0x0f, 0xf8, 0xc1 );
    FCML_A64( "psubw (%rax),%mm0", 0x0f, 0xf9, 0x00 );
    FCML_A64( "psubw %mm1,%mm0", 0x0f, 0xf9, 0xc1 );
    FCML_A64( "psubd (%rax),%mm0", 0x0f, 0xfa, 0x00 );
    FCML_A64( "psubd %mm1,%mm0", 0x0f, 0xfa, 0xc1 );
    FCML_A64( "psubb (%rax),%xmm0", 0x66, 0x0f, 0xf8, 0x00 );
    FCML_A64( "psubb %xmm1,%xmm0", 0x66, 0x0f, 0xf8, 0xc1 );
    FCML_A64( "psubw (%rax),%xmm0", 0x66, 0x0f, 0xf9, 0x00 );
    FCML_A64( "psubw %xmm1,%xmm0", 0x66, 0x0f, 0xf9, 0xc1 );
    FCML_A64( "psubd (%rax),%xmm0", 0x66, 0x0f, 0xfa, 0x00 );
    FCML_A64( "psubd %xmm1,%xmm0", 0x66, 0x0f, 0xfa, 0xc1 );

    FCML_I64_M("vpsubb xmm0,xmm0,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xf8, 0x00), FCML_MI(0xc5, 0xf9, 0xf8, 0x00));
    FCML_I32_M("vpsubb xmm0,xmm0,xmm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xf8, 0xc1), FCML_MI(0xc5, 0xf9, 0xf8, 0xc1));
    FCML_I64_M("vpsubb ymm0,ymm0,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xf8, 0x00), FCML_MI(0xc5, 0xfd, 0xf8, 0x00));
    FCML_I32_M("vpsubb ymm0,ymm0,ymm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xf8, 0xc1), FCML_MI(0xc5, 0xfd, 0xf8, 0xc1));

    FCML_A64_M("vpsubb (%rax),%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xf8, 0x00), FCML_MI(0xc5, 0xf9, 0xf8, 0x00));
    FCML_A64_M("vpsubb %xmm1,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x08, 0xf8, 0xc1), FCML_MI(0xc5, 0xf9, 0xf8, 0xc1));
    FCML_A64_M("vpsubb (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xf8, 0x00), FCML_MI(0xc5, 0xfd, 0xf8, 0x00));
    FCML_A64_M("vpsubb %ymm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0xf8, 0xc1), FCML_MI(0xc5, 0xfd, 0xf8, 0xc1));

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpsubb (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf8, 0x38), FCML_MI(0xc5, 0x41, 0xf8, 0x38));
    FCML_I64_M("vpsubb xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf8, 0x38), FCML_MI(0xc5, 0x41, 0xf8, 0x38));
    FCML_A32_M("vpsubb (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xf8, 0x38), FCML_MI(0xc5, 0xc9, 0xf8, 0x38));
    FCML_I32_M("vpsubb xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xf8, 0x38), FCML_MI(0xc5, 0xc9, 0xf8, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpsubb (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf8, 0x38), FCML_MI(0xc5, 0x45, 0xf8, 0x38));
    FCML_I64_M("vpsubb ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf8, 0x38), FCML_MI(0xc5, 0x45, 0xf8, 0x38));
    FCML_A32_M("vpsubb (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xf8, 0x38), FCML_MI(0xc5, 0xd5, 0xf8, 0x38));
    FCML_I32_M("vpsubb ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xf8, 0x38), FCML_MI(0xc5, 0xd5, 0xf8, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsubb (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xf8, 0x38);
    FCML_I64("vpsubb zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xf8, 0x38);
    FCML_A32("vpsubb (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xf8, 0x38);
    FCML_I32("vpsubb zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xf8, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpsubb %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf8, 0xf9), FCML_MI(0xc5, 0x41, 0xf8, 0xf9));
    FCML_I64_M("vpsubb xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf8, 0xf9), FCML_MI(0xc5, 0x41, 0xf8, 0xf9));
    FCML_A32_M("vpsubb %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf8, 0xf9), FCML_MI(0xc5, 0xe9, 0xf8, 0xf9));
    FCML_I32_M("vpsubb xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf8, 0xf9), FCML_MI(0xc5, 0xe9, 0xf8, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpsubb %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf8, 0xf6), FCML_MI(0xc5, 0x45, 0xf8, 0xf6));
    FCML_I64_M("vpsubb ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf8, 0xf6), FCML_MI(0xc5, 0x45, 0xf8, 0xf6));
    FCML_A32_M("vpsubb %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xf8, 0xf5), FCML_MI(0xc5, 0xe5, 0xf8, 0xf5));
    FCML_I32_M("vpsubb ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xf8, 0xf5), FCML_MI(0xc5, 0xe5, 0xf8, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsubb %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xf8, 0xf4);
    FCML_I64("vpsubb zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xf8, 0xf4);
    FCML_A32("vpsubb %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xf8, 0xf4);
    FCML_I32("vpsubb zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xf8, 0xf4);
    /* disp8 */
    FCML_I32("vpsubb zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xf8, 0x4c, 0x24, 0x08);
    FCML_A32("vpsubb 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xf8, 0x4c, 0x24, 0x08);
    FCML_I64("vpsubb zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xf8, 0x4c, 0x24, 0x08);
    FCML_A64("vpsubb 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xf8, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpsubb ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf8, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpsubb 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf8, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpsubb ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf8, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpsubb 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf8, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpsubb xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf8, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpsubb 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf8, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpsubb xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf8, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpsubb 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf8, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpsubb (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xf8, 0x14, 0x01);
    FCML_I64("vpsubb xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xf8, 0x14, 0x01);
    FCML_A32("vpsubb (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xf8, 0x14, 0x01);
    FCML_I32("vpsubb xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xf8, 0x14, 0x01);
    FCML_A64("vpsubb (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xf8, 0x14, 0x01);
    FCML_I64("vpsubb ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xf8, 0x14, 0x01);
    FCML_A32("vpsubb (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xf8, 0x14, 0x01);
    FCML_I32("vpsubb ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xf8, 0x14, 0x01);
    FCML_A64("vpsubb (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xf8, 0x14, 0x01);
    FCML_I64("vpsubb zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xf8, 0x14, 0x01);
    FCML_A32("vpsubb (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xf8, 0x14, 0x01);
    FCML_I32("vpsubb zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xf8, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsubb (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xf8, 0x14, 0x01);
    FCML_I64("vpsubb xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xf8, 0x14, 0x01);
    FCML_A32("vpsubb (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xf8, 0x14, 0x01);
    FCML_I32("vpsubb xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xf8, 0x14, 0x01);
    FCML_A64("vpsubb (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xf8, 0x14, 0x01);
    FCML_I64("vpsubb ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xf8, 0x14, 0x01);
    FCML_A32("vpsubb (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xf8, 0x14, 0x01);
    FCML_I32("vpsubb ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xf8, 0x14, 0x01);
    FCML_A64("vpsubb (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xf8, 0x14, 0x01);
    FCML_I64("vpsubb zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xf8, 0x14, 0x01);
    FCML_A32("vpsubb (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xf8, 0x14, 0x01);
    FCML_I32("vpsubb zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xf8, 0x14, 0x01);

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpsubw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf9, 0x38), FCML_MI(0xc5, 0x41, 0xf9, 0x38));
    FCML_I64_M("vpsubw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf9, 0x38), FCML_MI(0xc5, 0x41, 0xf9, 0x38));
    FCML_A32_M("vpsubw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xf9, 0x38), FCML_MI(0xc5, 0xc9, 0xf9, 0x38));
    FCML_I32_M("vpsubw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xf9, 0x38), FCML_MI(0xc5, 0xc9, 0xf9, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpsubw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf9, 0x38), FCML_MI(0xc5, 0x45, 0xf9, 0x38));
    FCML_I64_M("vpsubw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf9, 0x38), FCML_MI(0xc5, 0x45, 0xf9, 0x38));
    FCML_A32_M("vpsubw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xf9, 0x38), FCML_MI(0xc5, 0xd5, 0xf9, 0x38));
    FCML_I32_M("vpsubw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xf9, 0x38), FCML_MI(0xc5, 0xd5, 0xf9, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsubw (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xf9, 0x38);
    FCML_I64("vpsubw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xf9, 0x38);
    FCML_A32("vpsubw (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xf9, 0x38);
    FCML_I32("vpsubw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xf9, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpsubw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf9, 0xf9), FCML_MI(0xc5, 0x41, 0xf9, 0xf9));
    FCML_I64_M("vpsubw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xf9, 0xf9), FCML_MI(0xc5, 0x41, 0xf9, 0xf9));
    FCML_A32_M("vpsubw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf9, 0xf9), FCML_MI(0xc5, 0xe9, 0xf9, 0xf9));
    FCML_I32_M("vpsubw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf9, 0xf9), FCML_MI(0xc5, 0xe9, 0xf9, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpsubw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf9, 0xf6), FCML_MI(0xc5, 0x45, 0xf9, 0xf6));
    FCML_I64_M("vpsubw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xf9, 0xf6), FCML_MI(0xc5, 0x45, 0xf9, 0xf6));
    FCML_A32_M("vpsubw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xf9, 0xf5), FCML_MI(0xc5, 0xe5, 0xf9, 0xf5));
    FCML_I32_M("vpsubw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xf9, 0xf5), FCML_MI(0xc5, 0xe5, 0xf9, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsubw %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xf9, 0xf4);
    FCML_I64("vpsubw zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xf9, 0xf4);
    FCML_A32("vpsubw %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xf9, 0xf4);
    FCML_I32("vpsubw zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xf9, 0xf4);
    /* disp8 */
    FCML_I32("vpsubw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xf9, 0x4c, 0x24, 0x08);
    FCML_A32("vpsubw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xf9, 0x4c, 0x24, 0x08);
    FCML_I64("vpsubw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xf9, 0x4c, 0x24, 0x08);
    FCML_A64("vpsubw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xf9, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpsubw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf9, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpsubw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf9, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpsubw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf9, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpsubw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xf9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xf9, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpsubw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf9, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpsubw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf9, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpsubw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf9, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpsubw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xf9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xf9, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpsubw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xf9, 0x14, 0x01);
    FCML_I64("vpsubw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xf9, 0x14, 0x01);
    FCML_A32("vpsubw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xf9, 0x14, 0x01);
    FCML_I32("vpsubw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xf9, 0x14, 0x01);
    FCML_A64("vpsubw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xf9, 0x14, 0x01);
    FCML_I64("vpsubw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xf9, 0x14, 0x01);
    FCML_A32("vpsubw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xf9, 0x14, 0x01);
    FCML_I32("vpsubw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xf9, 0x14, 0x01);
    FCML_A64("vpsubw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xf9, 0x14, 0x01);
    FCML_I64("vpsubw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xf9, 0x14, 0x01);
    FCML_A32("vpsubw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xf9, 0x14, 0x01);
    FCML_I32("vpsubw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xf9, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsubw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xf9, 0x14, 0x01);
    FCML_I64("vpsubw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xf9, 0x14, 0x01);
    FCML_A32("vpsubw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xf9, 0x14, 0x01);
    FCML_I32("vpsubw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xf9, 0x14, 0x01);
    FCML_A64("vpsubw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xf9, 0x14, 0x01);
    FCML_I64("vpsubw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xf9, 0x14, 0x01);
    FCML_A32("vpsubw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xf9, 0x14, 0x01);
    FCML_I32("vpsubw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xf9, 0x14, 0x01);
    FCML_A64("vpsubw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xf9, 0x14, 0x01);
    FCML_I64("vpsubw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xf9, 0x14, 0x01);
    FCML_A32("vpsubw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xf9, 0x14, 0x01);
    FCML_I32("vpsubw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xf9, 0x14, 0x01);

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpsubd (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xfa, 0x38), FCML_MI(0xc5, 0x41, 0xfa, 0x38));
    FCML_I64_M("vpsubd xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xfa, 0x38), FCML_MI(0xc5, 0x41, 0xfa, 0x38));
    FCML_A32_M("vpsubd (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xfa, 0x38), FCML_MI(0xc5, 0xc9, 0xfa, 0x38));
    FCML_I32_M("vpsubd xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xfa, 0x38), FCML_MI(0xc5, 0xc9, 0xfa, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpsubd (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xfa, 0x38), FCML_MI(0xc5, 0x45, 0xfa, 0x38));
    FCML_I64_M("vpsubd ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xfa, 0x38), FCML_MI(0xc5, 0x45, 0xfa, 0x38));
    FCML_A32_M("vpsubd (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xfa, 0x38), FCML_MI(0xc5, 0xd5, 0xfa, 0x38));
    FCML_I32_M("vpsubd ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xfa, 0x38), FCML_MI(0xc5, 0xd5, 0xfa, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsubd (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xfa, 0x38);
    FCML_I64("vpsubd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xfa, 0x38);
    FCML_A32("vpsubd (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xfa, 0x38);
    FCML_I32("vpsubd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xfa, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpsubd %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xfa, 0xf9), FCML_MI(0xc5, 0x41, 0xfa, 0xf9));
    FCML_I64_M("vpsubd xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xfa, 0xf9), FCML_MI(0xc5, 0x41, 0xfa, 0xf9));
    FCML_A32_M("vpsubd %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xfa, 0xf9), FCML_MI(0xc5, 0xe9, 0xfa, 0xf9));
    FCML_I32_M("vpsubd xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xfa, 0xf9), FCML_MI(0xc5, 0xe9, 0xfa, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpsubd %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xfa, 0xf6), FCML_MI(0xc5, 0x45, 0xfa, 0xf6));
    FCML_I64_M("vpsubd ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xfa, 0xf6), FCML_MI(0xc5, 0x45, 0xfa, 0xf6));
    FCML_A32_M("vpsubd %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xfa, 0xf5), FCML_MI(0xc5, 0xe5, 0xfa, 0xf5));
    FCML_I32_M("vpsubd ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xfa, 0xf5), FCML_MI(0xc5, 0xe5, 0xfa, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsubd %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xfa, 0xf4);
    FCML_I64("vpsubd zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xfa, 0xf4);
    FCML_A32("vpsubd %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xfa, 0xf4);
    FCML_I32("vpsubd zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xfa, 0xf4);
    /* disp8 */
    FCML_I32("vpsubd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xfa, 0x4c, 0x24, 0x08);
    FCML_A32("vpsubd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xfa, 0x4c, 0x24, 0x08);
    FCML_I64("vpsubd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xfa, 0x4c, 0x24, 0x08);
    FCML_A64("vpsubd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xfa, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpsubd ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xfa, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xfa, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
FCML_A32_M( "vpsubd 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xfa, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xfa, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpsubd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xfa, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xfa, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpsubd 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xfa, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xfa, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpsubd xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xfa, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xfa, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpsubd 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xfa, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xfa, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpsubd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xfa, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xfa, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpsubd 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xfa, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xfa, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpsubd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xfa, 0x14, 0x01);
    FCML_I64("vpsubd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xfa, 0x14, 0x01);
    FCML_A32("vpsubd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xfa, 0x14, 0x01);
    FCML_I32("vpsubd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xfa, 0x14, 0x01);
    FCML_A64("vpsubd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xfa, 0x14, 0x01);
    FCML_I64("vpsubd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xfa, 0x14, 0x01);
    FCML_A32("vpsubd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xfa, 0x14, 0x01);
    FCML_I32("vpsubd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xfa, 0x14, 0x01);
    FCML_A64("vpsubd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xfa, 0x14, 0x01);
    FCML_I64("vpsubd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xfa, 0x14, 0x01);
    FCML_A32("vpsubd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xfa, 0x14, 0x01);
    FCML_I32("vpsubd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xfa, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsubd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xfa, 0x14, 0x01);
    FCML_I64("vpsubd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xfa, 0x14, 0x01);
    FCML_A32("vpsubd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xfa, 0x14, 0x01);
    FCML_I32("vpsubd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xfa, 0x14, 0x01);
    FCML_A64("vpsubd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xfa, 0x14, 0x01);
    FCML_I64("vpsubd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xfa, 0x14, 0x01);
    FCML_A32("vpsubd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xfa, 0x14, 0x01);
    FCML_I32("vpsubd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xfa, 0x14, 0x01);
    FCML_A64("vpsubd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xfa, 0x14, 0x01);
    FCML_I64("vpsubd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xfa, 0x14, 0x01);
    FCML_A32("vpsubd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xfa, 0x14, 0x01);
    FCML_I32("vpsubd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xfa, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpsubd zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x61, 0x55, 0x50, 0xfa, 0x3e);
    FCML_A64("vpsubd (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x61, 0x55, 0x50, 0xfa, 0x3e);
    FCML_I64("vpsubd ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x55, 0x30, 0xfa, 0x3e);
    FCML_A64("vpsubd (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x61, 0x55, 0x30, 0xfa, 0x3e);
    FCML_I64("vpsubd xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x61, 0x55, 0x10, 0xfa, 0x3e);
    FCML_A64("vpsubd (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x61, 0x55, 0x10, 0xfa, 0x3e);
    FCML_A32("vpsubd (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0xfa, 0x0e);
    FCML_I32("vpsubd zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0xfa, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpsubd (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0x55, 0xb7, 0xfa, 0x3e);
    FCML_I64("vpsubd ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x55, 0xb7, 0xfa, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpsubd zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0xfa, 0x4c, 0x24, 0x08);
    FCML_A32("vpsubd 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0xfa, 0x4c, 0x24, 0x08);
    FCML_I64("vpsubd zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0xfa, 0x4c, 0x24, 0x08);
    FCML_A64("vpsubd 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0xfa, 0x4c, 0x24, 0x08);
    FCML_I32("vpsubd ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf1, 0x6d, 0x38, 0xfa, 0x4c, 0x24, 0x08);
    FCML_A32("vpsubd 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf1, 0x6d, 0x38, 0xfa, 0x4c, 0x24, 0x08);
    FCML_I64("vpsubd ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf1, 0x6d, 0x38, 0xfa, 0x4c, 0x24, 0x08);
    FCML_A64("vpsubd 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf1, 0x6d, 0x38, 0xfa, 0x4c, 0x24, 0x08);
    FCML_I32("vpsubd xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf1, 0x6d, 0x18, 0xfa, 0x4c, 0x24, 0x08);
    FCML_A32("vpsubd 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf1, 0x6d, 0x18, 0xfa, 0x4c, 0x24, 0x08);
    FCML_I64("vpsubd xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf1, 0x6d, 0x18, 0xfa, 0x4c, 0x24, 0x08);
    FCML_A64("vpsubd 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf1, 0x6d, 0x18, 0xfa, 0x4c, 0x24, 0x08);

}

void fcml_tf_instruction_PSUBQ(void) {

    FCML_I64( "psubq mm0,mmword ptr [rax]", 0x0F, 0xFB, 0x00 );
    FCML_I32( "psubq mm0,mm1", 0x0F, 0xFB, 0xC1 );

    FCML_I64( "psubq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xFB, 0x00 );
    FCML_I32( "psubq xmm0,xmm1", 0x66, 0x0F, 0xFB, 0xC1 );

    FCML_A64( "psubq (%rax),%mm0", 0x0f, 0xfb, 0x00 );
    FCML_A64( "psubq %mm1,%mm0", 0x0f, 0xfb, 0xc1 );
    FCML_A64( "psubq (%rax),%xmm0", 0x66, 0x0f, 0xfb, 0x00 );
    FCML_A64( "psubq %xmm1,%xmm0", 0x66, 0x0f, 0xfb, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpsubq (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0xfb, 0x38), FCML_MI(0xc5, 0x41, 0xfb, 0x38));
    FCML_I64_M("vpsubq xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0xfb, 0x38), FCML_MI(0xc5, 0x41, 0xfb, 0x38));
    FCML_A32_M("vpsubq (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0xfb, 0x38), FCML_MI(0xc5, 0xc9, 0xfb, 0x38));
    FCML_I32_M("vpsubq xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0xfb, 0x38), FCML_MI(0xc5, 0xc9, 0xfb, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpsubq (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0xfb, 0x38), FCML_MI(0xc5, 0x45, 0xfb, 0x38));
    FCML_I64_M("vpsubq ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0xfb, 0x38), FCML_MI(0xc5, 0x45, 0xfb, 0x38));
    FCML_A32_M("vpsubq (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0xd5, 0x28, 0xfb, 0x38), FCML_MI(0xc5, 0xd5, 0xfb, 0x38));
    FCML_I32_M("vpsubq ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0xd5, 0x28, 0xfb, 0x38), FCML_MI(0xc5, 0xd5, 0xfb, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsubq (%rax),%zmm7,%zmm15", 0x62, 0x71, 0xc5, 0x48, 0xfb, 0x38);
    FCML_I64("vpsubq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0xc5, 0x48, 0xfb, 0x38);
    FCML_A32("vpsubq (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0xe5, 0x48, 0xfb, 0x38);
    FCML_I32("vpsubq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0xe5, 0x48, 0xfb, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpsubq %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0xfb, 0xf9), FCML_MI(0xc5, 0x41, 0xfb, 0xf9));
    FCML_I64_M("vpsubq xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0xfb, 0xf9), FCML_MI(0xc5, 0x41, 0xfb, 0xf9));
    FCML_A32_M("vpsubq %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xfb, 0xf9), FCML_MI(0xc5, 0xe9, 0xfb, 0xf9));
    FCML_I32_M("vpsubq xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xfb, 0xf9), FCML_MI(0xc5, 0xe9, 0xfb, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpsubq %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0xfb, 0xf6), FCML_MI(0xc5, 0x45, 0xfb, 0xf6));
    FCML_I64_M("vpsubq ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0xfb, 0xf6), FCML_MI(0xc5, 0x45, 0xfb, 0xf6));
    FCML_A32_M("vpsubq %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0xe5, 0x28, 0xfb, 0xf5), FCML_MI(0xc5, 0xe5, 0xfb, 0xf5));
    FCML_I32_M("vpsubq ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0xe5, 0x28, 0xfb, 0xf5), FCML_MI(0xc5, 0xe5, 0xfb, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsubq %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x85, 0x48, 0xfb, 0xf4);
    FCML_I64("vpsubq zmm6,zmm15,zmm4", 0x62, 0xf1, 0x85, 0x48, 0xfb, 0xf4);
    FCML_A32("vpsubq %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0xcd, 0x48, 0xfb, 0xf4);
    FCML_I32("vpsubq zmm6,zmm6,zmm4", 0x62, 0xf1, 0xcd, 0x48, 0xfb, 0xf4);
    /* disp8 */
    FCML_I32("vpsubq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0xed, 0x48, 0xfb, 0x4c, 0x24, 0x08);
    FCML_A32("vpsubq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x48, 0xfb, 0x4c, 0x24, 0x08);
    FCML_I64("vpsubq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0xed, 0x48, 0xfb, 0x4c, 0x24, 0x08);
    FCML_A64("vpsubq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x48, 0xfb, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpsubq ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0xfb, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xfb, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpsubq 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0xfb, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xfb, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpsubq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0xfb, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xfb, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpsubq 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0xfb, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xfb, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpsubq xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xfb, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xfb, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpsubq 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xfb, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xfb, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpsubq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xfb, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xfb, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpsubq 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xfb, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xfb, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpsubq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x8d, 0x8c, 0xfb, 0x14, 0x01);
    FCML_I64("vpsubq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x8c, 0xfb, 0x14, 0x01);
    FCML_A32("vpsubq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0x8d, 0xfb, 0x14, 0x01);
    FCML_I32("vpsubq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x8d, 0xfb, 0x14, 0x01);
    FCML_A64("vpsubq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x8d, 0xac, 0xfb, 0x14, 0x01);
    FCML_I64("vpsubq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0xac, 0xfb, 0x14, 0x01);
    FCML_A32("vpsubq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0xad, 0xfb, 0x14, 0x01);
    FCML_I32("vpsubq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0xad, 0xfb, 0x14, 0x01);
    FCML_A64("vpsubq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x8d, 0xcc, 0xfb, 0x14, 0x01);
    FCML_I64("vpsubq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0xcc, 0xfb, 0x14, 0x01);
    FCML_A32("vpsubq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0xcd, 0xfb, 0x14, 0x01);
    FCML_I32("vpsubq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0xcd, 0xfb, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsubq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x8d, 0x0c, 0xfb, 0x14, 0x01);
    FCML_I64("vpsubq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x0c, 0xfb, 0x14, 0x01);
    FCML_A32("vpsubq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0xc5, 0x0d, 0xfb, 0x14, 0x01);
    FCML_I32("vpsubq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x0d, 0xfb, 0x14, 0x01);
    FCML_A64("vpsubq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x8d, 0x2c, 0xfb, 0x14, 0x01);
    FCML_I64("vpsubq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x2c, 0xfb, 0x14, 0x01);
    FCML_A32("vpsubq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0xc5, 0x2d, 0xfb, 0x14, 0x01);
    FCML_I32("vpsubq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x2d, 0xfb, 0x14, 0x01);
    FCML_A64("vpsubq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x8d, 0x4c, 0xfb, 0x14, 0x01);
    FCML_I64("vpsubq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x4c, 0xfb, 0x14, 0x01);
    FCML_A32("vpsubq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0xc5, 0x4d, 0xfb, 0x14, 0x01);
    FCML_I32("vpsubq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x4d, 0xfb, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpsubq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xd5, 0x50, 0xfb, 0x3e);
    FCML_A64("vpsubq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x61, 0xd5, 0x50, 0xfb, 0x3e);
    FCML_I64("vpsubq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xd5, 0x30, 0xfb, 0x3e);
    FCML_A64("vpsubq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x61, 0xd5, 0x30, 0xfb, 0x3e);
    FCML_I64("vpsubq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x61, 0xd5, 0x10, 0xfb, 0x3e);
    FCML_A64("vpsubq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x61, 0xd5, 0x10, 0xfb, 0x3e);
    FCML_A32("vpsubq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0xfb, 0x0e);
    FCML_I32("vpsubq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0xfb, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpsubq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0xd5, 0xb7, 0xfb, 0x3e);
    FCML_I64("vpsubq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xd5, 0xb7, 0xfb, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpsubq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0xfb, 0x4c, 0x24, 0x08);
    FCML_A32("vpsubq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0xfb, 0x4c, 0x24, 0x08);
    FCML_I64("vpsubq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0xfb, 0x4c, 0x24, 0x08);
    FCML_A64("vpsubq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0xfb, 0x4c, 0x24, 0x08);
    FCML_I32("vpsubq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf1, 0xed, 0x38, 0xfb, 0x4c, 0x24, 0x08);
    FCML_A32("vpsubq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x38, 0xfb, 0x4c, 0x24, 0x08);
    FCML_I64("vpsubq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf1, 0xed, 0x38, 0xfb, 0x4c, 0x24, 0x08);
    FCML_A64("vpsubq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x38, 0xfb, 0x4c, 0x24, 0x08);
    FCML_I32("vpsubq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf1, 0xed, 0x18, 0xfb, 0x4c, 0x24, 0x08);
    FCML_A32("vpsubq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x18, 0xfb, 0x4c, 0x24, 0x08);
    FCML_I64("vpsubq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf1, 0xed, 0x18, 0xfb, 0x4c, 0x24, 0x08);
    FCML_A64("vpsubq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x18, 0xfb, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PSUBS(void) {

    FCML_I64( "psubsb mm0,mmword ptr [rax]", 0x0F, 0xE8, 0x00 );
    FCML_I32( "psubsb mm0,mm1", 0x0F, 0xE8, 0xC1 );

    FCML_I64( "psubsw mm0,mmword ptr [rax]", 0x0F, 0xE9, 0x00 );
    FCML_I32( "psubsw mm0,mm1", 0x0F, 0xE9, 0xC1 );

    FCML_I64( "psubsb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE8, 0x00 );
    FCML_I32( "psubsb xmm0,xmm1", 0x66, 0x0F, 0xE8, 0xC1 );

    FCML_I64( "psubsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE9, 0x00 );
    FCML_I32( "psubsw xmm0,xmm1", 0x66, 0x0F, 0xE9, 0xC1 );

    FCML_A64( "psubsb (%rax),%mm0", 0x0f, 0xe8, 0x00 );
    FCML_A64( "psubsb %mm1,%mm0", 0x0f, 0xe8, 0xc1 );
    FCML_A64( "psubsw (%rax),%mm0", 0x0f, 0xe9, 0x00 );
    FCML_A64( "psubsw %mm1,%mm0", 0x0f, 0xe9, 0xc1 );
    FCML_A64( "psubsb (%rax),%xmm0", 0x66, 0x0f, 0xe8, 0x00 );
    FCML_A64( "psubsb %xmm1,%xmm0", 0x66, 0x0f, 0xe8, 0xc1 );
    FCML_A64( "psubsw (%rax),%xmm0", 0x66, 0x0f, 0xe9, 0x00 );
    FCML_A64( "psubsw %xmm1,%xmm0", 0x66, 0x0f, 0xe9, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpsubsb (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe8, 0x38), FCML_MI(0xc5, 0x41, 0xe8, 0x38));
    FCML_I64_M("vpsubsb xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe8, 0x38), FCML_MI(0xc5, 0x41, 0xe8, 0x38));
    FCML_A32_M("vpsubsb (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xe8, 0x38), FCML_MI(0xc5, 0xc9, 0xe8, 0x38));
    FCML_I32_M("vpsubsb xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xe8, 0x38), FCML_MI(0xc5, 0xc9, 0xe8, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpsubsb (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe8, 0x38), FCML_MI(0xc5, 0x45, 0xe8, 0x38));
    FCML_I64_M("vpsubsb ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe8, 0x38), FCML_MI(0xc5, 0x45, 0xe8, 0x38));
    FCML_A32_M("vpsubsb (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xe8, 0x38), FCML_MI(0xc5, 0xd5, 0xe8, 0x38));
    FCML_I32_M("vpsubsb ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xe8, 0x38), FCML_MI(0xc5, 0xd5, 0xe8, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsubsb (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xe8, 0x38);
    FCML_I64("vpsubsb zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xe8, 0x38);
    FCML_A32("vpsubsb (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xe8, 0x38);
    FCML_I32("vpsubsb zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xe8, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpsubsb %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe8, 0xf9), FCML_MI(0xc5, 0x41, 0xe8, 0xf9));
    FCML_I64_M("vpsubsb xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe8, 0xf9), FCML_MI(0xc5, 0x41, 0xe8, 0xf9));
    FCML_A32_M("vpsubsb %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe8, 0xf9), FCML_MI(0xc5, 0xe9, 0xe8, 0xf9));
    FCML_I32_M("vpsubsb xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe8, 0xf9), FCML_MI(0xc5, 0xe9, 0xe8, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpsubsb %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe8, 0xf6), FCML_MI(0xc5, 0x45, 0xe8, 0xf6));
    FCML_I64_M("vpsubsb ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe8, 0xf6), FCML_MI(0xc5, 0x45, 0xe8, 0xf6));
    FCML_A32_M("vpsubsb %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xe8, 0xf5), FCML_MI(0xc5, 0xe5, 0xe8, 0xf5));
    FCML_I32_M("vpsubsb ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xe8, 0xf5), FCML_MI(0xc5, 0xe5, 0xe8, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsubsb %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xe8, 0xf4);
    FCML_I64("vpsubsb zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xe8, 0xf4);
    FCML_A32("vpsubsb %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xe8, 0xf4);
    FCML_I32("vpsubsb zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xe8, 0xf4);
    /* disp8 */
    FCML_I32("vpsubsb zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xe8, 0x4c, 0x24, 0x08);
    FCML_A32("vpsubsb 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xe8, 0x4c, 0x24, 0x08);
    FCML_I64("vpsubsb zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xe8, 0x4c, 0x24, 0x08);
    FCML_A64("vpsubsb 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xe8, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpsubsb ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe8, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpsubsb 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe8, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpsubsb ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe8, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpsubsb 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe8, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpsubsb xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe8, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpsubsb 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe8, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpsubsb xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe8, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpsubsb 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe8, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpsubsb (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xe8, 0x14, 0x01);
    FCML_I64("vpsubsb xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xe8, 0x14, 0x01);
    FCML_A32("vpsubsb (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xe8, 0x14, 0x01);
    FCML_I32("vpsubsb xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xe8, 0x14, 0x01);
    FCML_A64("vpsubsb (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xe8, 0x14, 0x01);
    FCML_I64("vpsubsb ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xe8, 0x14, 0x01);
    FCML_A32("vpsubsb (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xe8, 0x14, 0x01);
    FCML_I32("vpsubsb ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xe8, 0x14, 0x01);
    FCML_A64("vpsubsb (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xe8, 0x14, 0x01);
    FCML_I64("vpsubsb zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xe8, 0x14, 0x01);
    FCML_A32("vpsubsb (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xe8, 0x14, 0x01);
    FCML_I32("vpsubsb zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xe8, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsubsb (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xe8, 0x14, 0x01);
    FCML_I64("vpsubsb xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xe8, 0x14, 0x01);
    FCML_A32("vpsubsb (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xe8, 0x14, 0x01);
    FCML_I32("vpsubsb xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xe8, 0x14, 0x01);
    FCML_A64("vpsubsb (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xe8, 0x14, 0x01);
    FCML_I64("vpsubsb ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xe8, 0x14, 0x01);
    FCML_A32("vpsubsb (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xe8, 0x14, 0x01);
    FCML_I32("vpsubsb ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xe8, 0x14, 0x01);
    FCML_A64("vpsubsb (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xe8, 0x14, 0x01);
    FCML_I64("vpsubsb zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xe8, 0x14, 0x01);
    FCML_A32("vpsubsb (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xe8, 0x14, 0x01);
    FCML_I32("vpsubsb zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xe8, 0x14, 0x01);

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpsubsw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe9, 0x38), FCML_MI(0xc5, 0x41, 0xe9, 0x38));
    FCML_I64_M("vpsubsw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe9, 0x38), FCML_MI(0xc5, 0x41, 0xe9, 0x38));
    FCML_A32_M("vpsubsw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xe9, 0x38), FCML_MI(0xc5, 0xc9, 0xe9, 0x38));
    FCML_I32_M("vpsubsw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xe9, 0x38), FCML_MI(0xc5, 0xc9, 0xe9, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpsubsw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe9, 0x38), FCML_MI(0xc5, 0x45, 0xe9, 0x38));
    FCML_I64_M("vpsubsw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe9, 0x38), FCML_MI(0xc5, 0x45, 0xe9, 0x38));
    FCML_A32_M("vpsubsw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xe9, 0x38), FCML_MI(0xc5, 0xd5, 0xe9, 0x38));
    FCML_I32_M("vpsubsw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xe9, 0x38), FCML_MI(0xc5, 0xd5, 0xe9, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsubsw (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xe9, 0x38);
    FCML_I64("vpsubsw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xe9, 0x38);
    FCML_A32("vpsubsw (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xe9, 0x38);
    FCML_I32("vpsubsw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xe9, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpsubsw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe9, 0xf9), FCML_MI(0xc5, 0x41, 0xe9, 0xf9));
    FCML_I64_M("vpsubsw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xe9, 0xf9), FCML_MI(0xc5, 0x41, 0xe9, 0xf9));
    FCML_A32_M("vpsubsw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe9, 0xf9), FCML_MI(0xc5, 0xe9, 0xe9, 0xf9));
    FCML_I32_M("vpsubsw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe9, 0xf9), FCML_MI(0xc5, 0xe9, 0xe9, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpsubsw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe9, 0xf6), FCML_MI(0xc5, 0x45, 0xe9, 0xf6));
    FCML_I64_M("vpsubsw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xe9, 0xf6), FCML_MI(0xc5, 0x45, 0xe9, 0xf6));
    FCML_A32_M("vpsubsw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xe9, 0xf5), FCML_MI(0xc5, 0xe5, 0xe9, 0xf5));
    FCML_I32_M("vpsubsw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xe9, 0xf5), FCML_MI(0xc5, 0xe5, 0xe9, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsubsw %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xe9, 0xf4);
    FCML_I64("vpsubsw zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xe9, 0xf4);
    FCML_A32("vpsubsw %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xe9, 0xf4);
    FCML_I32("vpsubsw zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xe9, 0xf4);
    /* disp8 */
    FCML_I32("vpsubsw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xe9, 0x4c, 0x24, 0x08);
    FCML_A32("vpsubsw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xe9, 0x4c, 0x24, 0x08);
    FCML_I64("vpsubsw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xe9, 0x4c, 0x24, 0x08);
    FCML_A64("vpsubsw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xe9, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpsubsw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe9, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpsubsw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe9, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpsubsw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe9, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpsubsw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xe9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xe9, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpsubsw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe9, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpsubsw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe9, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpsubsw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe9, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpsubsw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xe9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xe9, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpsubsw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xe9, 0x14, 0x01);
    FCML_I64("vpsubsw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xe9, 0x14, 0x01);
    FCML_A32("vpsubsw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xe9, 0x14, 0x01);
    FCML_I32("vpsubsw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xe9, 0x14, 0x01);
    FCML_A64("vpsubsw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xe9, 0x14, 0x01);
    FCML_I64("vpsubsw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xe9, 0x14, 0x01);
    FCML_A32("vpsubsw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xe9, 0x14, 0x01);
    FCML_I32("vpsubsw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xe9, 0x14, 0x01);
    FCML_A64("vpsubsw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xe9, 0x14, 0x01);
    FCML_I64("vpsubsw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xe9, 0x14, 0x01);
    FCML_A32("vpsubsw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xe9, 0x14, 0x01);
    FCML_I32("vpsubsw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xe9, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsubsw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xe9, 0x14, 0x01);
    FCML_I64("vpsubsw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xe9, 0x14, 0x01);
    FCML_A32("vpsubsw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xe9, 0x14, 0x01);
    FCML_I32("vpsubsw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xe9, 0x14, 0x01);
    FCML_A64("vpsubsw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xe9, 0x14, 0x01);
    FCML_I64("vpsubsw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xe9, 0x14, 0x01);
    FCML_A32("vpsubsw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xe9, 0x14, 0x01);
    FCML_I32("vpsubsw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xe9, 0x14, 0x01);
    FCML_A64("vpsubsw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xe9, 0x14, 0x01);
    FCML_I64("vpsubsw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xe9, 0x14, 0x01);
    FCML_A32("vpsubsw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xe9, 0x14, 0x01);
    FCML_I32("vpsubsw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xe9, 0x14, 0x01);
}

void fcml_tf_instruction_PSUBUS(void) {

    FCML_I64( "psubusb mm0,mmword ptr [rax]", 0x0F, 0xD8, 0x00 );
    FCML_I32( "psubusb mm0,mm1", 0x0F, 0xD8, 0xC1 );

    FCML_I64( "psubusw mm0,mmword ptr [rax]", 0x0F, 0xD9, 0x00 );
    FCML_I32( "psubusw mm0,mm1", 0x0F, 0xD9, 0xC1 );

    FCML_I64( "psubusb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xD8, 0x00 );
    FCML_I32( "psubusb xmm0,xmm1", 0x66, 0x0F, 0xD8, 0xC1 );

    FCML_I64( "psubusw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xD9, 0x00 );
    FCML_I32( "psubusw xmm0,xmm1", 0x66, 0x0F, 0xD9, 0xC1 );

    FCML_A64( "psubusb (%rax),%mm0", 0x0f, 0xd8, 0x00 );
    FCML_A64( "psubusb %mm1,%mm0", 0x0f, 0xd8, 0xc1 );
    FCML_A64( "psubusw (%rax),%mm0", 0x0f, 0xd9, 0x00 );
    FCML_A64( "psubusw %mm1,%mm0", 0x0f, 0xd9, 0xc1 );
    FCML_A64( "psubusb (%rax),%xmm0", 0x66, 0x0f, 0xd8, 0x00 );
    FCML_A64( "psubusb %xmm1,%xmm0", 0x66, 0x0f, 0xd8, 0xc1 );
    FCML_A64( "psubusw (%rax),%xmm0", 0x66, 0x0f, 0xd9, 0x00 );
    FCML_A64( "psubusw %xmm1,%xmm0", 0x66, 0x0f, 0xd9, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpsubusb (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xd8, 0x38), FCML_MI(0xc5, 0x41, 0xd8, 0x38));
    FCML_I64_M("vpsubusb xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xd8, 0x38), FCML_MI(0xc5, 0x41, 0xd8, 0x38));
    FCML_A32_M("vpsubusb (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xd8, 0x38), FCML_MI(0xc5, 0xc9, 0xd8, 0x38));
    FCML_I32_M("vpsubusb xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xd8, 0x38), FCML_MI(0xc5, 0xc9, 0xd8, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpsubusb (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xd8, 0x38), FCML_MI(0xc5, 0x45, 0xd8, 0x38));
    FCML_I64_M("vpsubusb ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xd8, 0x38), FCML_MI(0xc5, 0x45, 0xd8, 0x38));
    FCML_A32_M("vpsubusb (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xd8, 0x38), FCML_MI(0xc5, 0xd5, 0xd8, 0x38));
    FCML_I32_M("vpsubusb ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xd8, 0x38), FCML_MI(0xc5, 0xd5, 0xd8, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsubusb (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xd8, 0x38);
    FCML_I64("vpsubusb zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xd8, 0x38);
    FCML_A32("vpsubusb (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xd8, 0x38);
    FCML_I32("vpsubusb zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xd8, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpsubusb %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xd8, 0xf9), FCML_MI(0xc5, 0x41, 0xd8, 0xf9));
    FCML_I64_M("vpsubusb xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xd8, 0xf9), FCML_MI(0xc5, 0x41, 0xd8, 0xf9));
    FCML_A32_M("vpsubusb %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd8, 0xf9), FCML_MI(0xc5, 0xe9, 0xd8, 0xf9));
    FCML_I32_M("vpsubusb xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd8, 0xf9), FCML_MI(0xc5, 0xe9, 0xd8, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpsubusb %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xd8, 0xf6), FCML_MI(0xc5, 0x45, 0xd8, 0xf6));
    FCML_I64_M("vpsubusb ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xd8, 0xf6), FCML_MI(0xc5, 0x45, 0xd8, 0xf6));
    FCML_A32_M("vpsubusb %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xd8, 0xf5), FCML_MI(0xc5, 0xe5, 0xd8, 0xf5));
    FCML_I32_M("vpsubusb ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xd8, 0xf5), FCML_MI(0xc5, 0xe5, 0xd8, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsubusb %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xd8, 0xf4);
    FCML_I64("vpsubusb zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xd8, 0xf4);
    FCML_A32("vpsubusb %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xd8, 0xf4);
    FCML_I32("vpsubusb zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xd8, 0xf4);
    /* disp8 */
    FCML_I32("vpsubusb zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xd8, 0x4c, 0x24, 0x08);
    FCML_A32("vpsubusb 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xd8, 0x4c, 0x24, 0x08);
    FCML_I64("vpsubusb zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xd8, 0x4c, 0x24, 0x08);
    FCML_A64("vpsubusb 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xd8, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpsubusb ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xd8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xd8, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpsubusb 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xd8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xd8, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpsubusb ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xd8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xd8, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpsubusb 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xd8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xd8, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpsubusb xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xd8, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpsubusb 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xd8, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpsubusb xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xd8, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpsubusb 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd8, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xd8, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpsubusb (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xd8, 0x14, 0x01);
    FCML_I64("vpsubusb xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xd8, 0x14, 0x01);
    FCML_A32("vpsubusb (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xd8, 0x14, 0x01);
    FCML_I32("vpsubusb xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xd8, 0x14, 0x01);
    FCML_A64("vpsubusb (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xd8, 0x14, 0x01);
    FCML_I64("vpsubusb ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xd8, 0x14, 0x01);
    FCML_A32("vpsubusb (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xd8, 0x14, 0x01);
    FCML_I32("vpsubusb ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xd8, 0x14, 0x01);
    FCML_A64("vpsubusb (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xd8, 0x14, 0x01);
    FCML_I64("vpsubusb zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xd8, 0x14, 0x01);
    FCML_A32("vpsubusb (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xd8, 0x14, 0x01);
    FCML_I32("vpsubusb zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xd8, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsubusb (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xd8, 0x14, 0x01);
    FCML_I64("vpsubusb xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xd8, 0x14, 0x01);
    FCML_A32("vpsubusb (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xd8, 0x14, 0x01);
    FCML_I32("vpsubusb xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xd8, 0x14, 0x01);
    FCML_A64("vpsubusb (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xd8, 0x14, 0x01);
    FCML_I64("vpsubusb ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xd8, 0x14, 0x01);
    FCML_A32("vpsubusb (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xd8, 0x14, 0x01);
    FCML_I32("vpsubusb ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xd8, 0x14, 0x01);
    FCML_A64("vpsubusb (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xd8, 0x14, 0x01);
    FCML_I64("vpsubusb zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xd8, 0x14, 0x01);
    FCML_A32("vpsubusb (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xd8, 0x14, 0x01);
    FCML_I32("vpsubusb zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xd8, 0x14, 0x01);

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpsubusw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xd9, 0x38), FCML_MI(0xc5, 0x41, 0xd9, 0x38));
    FCML_I64_M("vpsubusw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xd9, 0x38), FCML_MI(0xc5, 0x41, 0xd9, 0x38));
    FCML_A32_M("vpsubusw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xd9, 0x38), FCML_MI(0xc5, 0xc9, 0xd9, 0x38));
    FCML_I32_M("vpsubusw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0xd9, 0x38), FCML_MI(0xc5, 0xc9, 0xd9, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpsubusw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xd9, 0x38), FCML_MI(0xc5, 0x45, 0xd9, 0x38));
    FCML_I64_M("vpsubusw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xd9, 0x38), FCML_MI(0xc5, 0x45, 0xd9, 0x38));
    FCML_A32_M("vpsubusw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xd9, 0x38), FCML_MI(0xc5, 0xd5, 0xd9, 0x38));
    FCML_I32_M("vpsubusw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0xd9, 0x38), FCML_MI(0xc5, 0xd5, 0xd9, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsubusw (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xd9, 0x38);
    FCML_I64("vpsubusw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xd9, 0x38);
    FCML_A32("vpsubusw (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xd9, 0x38);
    FCML_I32("vpsubusw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xd9, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpsubusw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xd9, 0xf9), FCML_MI(0xc5, 0x41, 0xd9, 0xf9));
    FCML_I64_M("vpsubusw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0xd9, 0xf9), FCML_MI(0xc5, 0x41, 0xd9, 0xf9));
    FCML_A32_M("vpsubusw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd9, 0xf9), FCML_MI(0xc5, 0xe9, 0xd9, 0xf9));
    FCML_I32_M("vpsubusw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd9, 0xf9), FCML_MI(0xc5, 0xe9, 0xd9, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpsubusw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xd9, 0xf6), FCML_MI(0xc5, 0x45, 0xd9, 0xf6));
    FCML_I64_M("vpsubusw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0xd9, 0xf6), FCML_MI(0xc5, 0x45, 0xd9, 0xf6));
    FCML_A32_M("vpsubusw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xd9, 0xf5), FCML_MI(0xc5, 0xe5, 0xd9, 0xf5));
    FCML_I32_M("vpsubusw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0xd9, 0xf5), FCML_MI(0xc5, 0xe5, 0xd9, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsubusw %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xd9, 0xf4);
    FCML_I64("vpsubusw zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xd9, 0xf4);
    FCML_A32("vpsubusw %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xd9, 0xf4);
    FCML_I32("vpsubusw zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xd9, 0xf4);
    /* disp8 */
    FCML_I32("vpsubusw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xd9, 0x4c, 0x24, 0x08);
    FCML_A32("vpsubusw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xd9, 0x4c, 0x24, 0x08);
    FCML_I64("vpsubusw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xd9, 0x4c, 0x24, 0x08);
    FCML_A64("vpsubusw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xd9, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpsubusw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xd9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xd9, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpsubusw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xd9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xd9, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpsubusw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xd9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xd9, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpsubusw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0xd9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0xd9, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpsubusw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xd9, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpsubusw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xd9, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpsubusw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xd9, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpsubusw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0xd9, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0xd9, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpsubusw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xd9, 0x14, 0x01);
    FCML_I64("vpsubusw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xd9, 0x14, 0x01);
    FCML_A32("vpsubusw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xd9, 0x14, 0x01);
    FCML_I32("vpsubusw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xd9, 0x14, 0x01);
    FCML_A64("vpsubusw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xd9, 0x14, 0x01);
    FCML_I64("vpsubusw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xd9, 0x14, 0x01);
    FCML_A32("vpsubusw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xd9, 0x14, 0x01);
    FCML_I32("vpsubusw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xd9, 0x14, 0x01);
    FCML_A64("vpsubusw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xd9, 0x14, 0x01);
    FCML_I64("vpsubusw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xd9, 0x14, 0x01);
    FCML_A32("vpsubusw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xd9, 0x14, 0x01);
    FCML_I32("vpsubusw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xd9, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsubusw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xd9, 0x14, 0x01);
    FCML_I64("vpsubusw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xd9, 0x14, 0x01);
    FCML_A32("vpsubusw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xd9, 0x14, 0x01);
    FCML_I32("vpsubusw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xd9, 0x14, 0x01);
    FCML_A64("vpsubusw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xd9, 0x14, 0x01);
    FCML_I64("vpsubusw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xd9, 0x14, 0x01);
    FCML_A32("vpsubusw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xd9, 0x14, 0x01);
    FCML_I32("vpsubusw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xd9, 0x14, 0x01);
    FCML_A64("vpsubusw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xd9, 0x14, 0x01);
    FCML_I64("vpsubusw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xd9, 0x14, 0x01);
    FCML_A32("vpsubusw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xd9, 0x14, 0x01);
    FCML_I32("vpsubusw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xd9, 0x14, 0x01);

}

void fcml_tf_instruction_PTEST(void) {

    FCML_I64( "ptest xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x17, 0x00 );
    FCML_I32( "ptest xmm0,xmm1", 0x66, 0x0F, 0x38, 0x17, 0xC1 );

    FCML_I64( "vptest xmm3,xmm0", 0xC4, 0xE2, 0x79, 0x17, 0xD8 );
    FCML_I32( "vptest xmm3,xmm0", 0xC4, 0xE2, 0x79, 0x17, 0xD8 );
    FCML_I32( "vptest ymm0,ymmword ptr [eax]", 0xC4, 0xE2, 0x7D, 0x17, 0x00 );

    FCML_A64( "ptest (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x17, 0x00 );
    FCML_A64( "ptest %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x17, 0xc1 );
    FCML_A64( "vptest %xmm0,%xmm3", 0xc4, 0xe2, 0x79, 0x17, 0xd8 );
    FCML_A64( "vptest %xmm0,%xmm3", 0xc4, 0xe2, 0x79, 0x17, 0xd8 );
    FCML_A64( "vptest (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x17, 0x00 );
}

void fcml_tf_instruction_PUNPCKLB(void) {

    FCML_I64( "punpcklbw mm0,dword ptr [rax]", 0x0F, 0x60, 0x00 );
    FCML_I32( "punpcklbw mm0,mm1", 0x0F, 0x60, 0xC1 );

    FCML_I64( "punpcklwd mm0,dword ptr [rax]", 0x0F, 0x61, 0x00 );
    FCML_I32( "punpcklwd mm0,mm1", 0x0F, 0x61, 0xC1 );

    FCML_I64( "punpckldq mm0,dword ptr [rax]", 0x0F, 0x62, 0x00 );
    FCML_I32( "punpckldq mm0,mm1", 0x0F, 0x62, 0xC1 );

    FCML_I64( "punpcklbw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x60, 0x00 );
    FCML_I32( "punpcklbw xmm0,xmm1", 0x66, 0x0F, 0x60, 0xC1 );

    FCML_I64( "punpcklwd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x61, 0x00 );
    FCML_I32( "punpcklwd xmm0,xmm1", 0x66, 0x0F, 0x61, 0xC1 );

    FCML_I64( "punpckldq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x62, 0x00 );
    FCML_I32( "punpckldq xmm0,xmm1", 0x66, 0x0F, 0x62, 0xC1 );

    FCML_I64( "punpcklqdq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x6c, 0x00 );
    FCML_I32( "punpcklqdq xmm0,xmm1", 0x66, 0x0F, 0x6c, 0xC1 );

    FCML_A64( "punpcklbw (%rax),%mm0", 0x0f, 0x60, 0x00 );
    FCML_A64( "punpcklbw %mm1,%mm0", 0x0f, 0x60, 0xc1 );
    FCML_A64( "punpcklwd (%rax),%mm0", 0x0f, 0x61, 0x00 );
    FCML_A64( "punpcklwd %mm1,%mm0", 0x0f, 0x61, 0xc1 );
    FCML_A64( "punpckldq (%rax),%mm0", 0x0f, 0x62, 0x00 );
    FCML_A64( "punpckldq %mm1,%mm0", 0x0f, 0x62, 0xc1 );
    FCML_A64( "punpcklbw (%rax),%xmm0", 0x66, 0x0f, 0x60, 0x00 );
    FCML_A64( "punpcklbw %xmm1,%xmm0", 0x66, 0x0f, 0x60, 0xc1 );
    FCML_A64( "punpcklwd (%rax),%xmm0", 0x66, 0x0f, 0x61, 0x00 );
    FCML_A64( "punpcklwd %xmm1,%xmm0", 0x66, 0x0f, 0x61, 0xc1 );
    FCML_A64( "punpckldq (%rax),%xmm0", 0x66, 0x0f, 0x62, 0x00 );
    FCML_A64( "punpckldq %xmm1,%xmm0", 0x66, 0x0f, 0x62, 0xc1 );
    FCML_A64( "punpcklqdq (%rax),%xmm0", 0x66, 0x0f, 0x6c, 0x00 );
    FCML_A64( "punpcklqdq %xmm1,%xmm0", 0x66, 0x0f, 0x6c, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpunpcklbw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x60, 0x38), FCML_MI(0xc5, 0x41, 0x60, 0x38));
    FCML_I64_M("vpunpcklbw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x60, 0x38), FCML_MI(0xc5, 0x41, 0x60, 0x38));
    FCML_A32_M("vpunpcklbw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0x60, 0x38), FCML_MI(0xc5, 0xc9, 0x60, 0x38));
    FCML_I32_M("vpunpcklbw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0x60, 0x38), FCML_MI(0xc5, 0xc9, 0x60, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpunpcklbw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x60, 0x38), FCML_MI(0xc5, 0x45, 0x60, 0x38));
    FCML_I64_M("vpunpcklbw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x60, 0x38), FCML_MI(0xc5, 0x45, 0x60, 0x38));
    FCML_A32_M("vpunpcklbw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0x60, 0x38), FCML_MI(0xc5, 0xd5, 0x60, 0x38));
    FCML_I32_M("vpunpcklbw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0x60, 0x38), FCML_MI(0xc5, 0xd5, 0x60, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpunpcklbw (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0x60, 0x38);
    FCML_I64("vpunpcklbw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0x60, 0x38);
    FCML_A32("vpunpcklbw (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0x60, 0x38);
    FCML_I32("vpunpcklbw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0x60, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpunpcklbw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x60, 0xf9), FCML_MI(0xc5, 0x41, 0x60, 0xf9));
    FCML_I64_M("vpunpcklbw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x60, 0xf9), FCML_MI(0xc5, 0x41, 0x60, 0xf9));
    FCML_A32_M("vpunpcklbw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x60, 0xf9), FCML_MI(0xc5, 0xe9, 0x60, 0xf9));
    FCML_I32_M("vpunpcklbw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x60, 0xf9), FCML_MI(0xc5, 0xe9, 0x60, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpunpcklbw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x60, 0xf6), FCML_MI(0xc5, 0x45, 0x60, 0xf6));
    FCML_I64_M("vpunpcklbw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x60, 0xf6), FCML_MI(0xc5, 0x45, 0x60, 0xf6));
    FCML_A32_M("vpunpcklbw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x60, 0xf5), FCML_MI(0xc5, 0xe5, 0x60, 0xf5));
    FCML_I32_M("vpunpcklbw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x60, 0xf5), FCML_MI(0xc5, 0xe5, 0x60, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpunpcklbw %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0x60, 0xf4);
    FCML_I64("vpunpcklbw zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0x60, 0xf4);
    FCML_A32("vpunpcklbw %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0x60, 0xf4);
    FCML_I32("vpunpcklbw zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0x60, 0xf4);
    /* disp8 */
    FCML_I32("vpunpcklbw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x60, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpcklbw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0x60, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpcklbw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x60, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpcklbw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0x60, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpunpcklbw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x60, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x60, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpunpcklbw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x60, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x60, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpunpcklbw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x60, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x60, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpunpcklbw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x60, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x60, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpunpcklbw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x60, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x60, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpunpcklbw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x60, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x60, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpunpcklbw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x60, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x60, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpunpcklbw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x60, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x60, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpunpcklbw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0x60, 0x14, 0x01);
    FCML_I64("vpunpcklbw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0x60, 0x14, 0x01);
    FCML_A32("vpunpcklbw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0x60, 0x14, 0x01);
    FCML_I32("vpunpcklbw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0x60, 0x14, 0x01);
    FCML_A64("vpunpcklbw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0x60, 0x14, 0x01);
    FCML_I64("vpunpcklbw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0x60, 0x14, 0x01);
    FCML_A32("vpunpcklbw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0x60, 0x14, 0x01);
    FCML_I32("vpunpcklbw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0x60, 0x14, 0x01);
    FCML_A64("vpunpcklbw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0x60, 0x14, 0x01);
    FCML_I64("vpunpcklbw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0x60, 0x14, 0x01);
    FCML_A32("vpunpcklbw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0x60, 0x14, 0x01);
    FCML_I32("vpunpcklbw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0x60, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpunpcklbw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0x60, 0x14, 0x01);
    FCML_I64("vpunpcklbw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0x60, 0x14, 0x01);
    FCML_A32("vpunpcklbw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0x60, 0x14, 0x01);
    FCML_I32("vpunpcklbw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0x60, 0x14, 0x01);
    FCML_A64("vpunpcklbw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0x60, 0x14, 0x01);
    FCML_I64("vpunpcklbw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0x60, 0x14, 0x01);
    FCML_A32("vpunpcklbw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0x60, 0x14, 0x01);
    FCML_I32("vpunpcklbw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0x60, 0x14, 0x01);
    FCML_A64("vpunpcklbw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0x60, 0x14, 0x01);
    FCML_I64("vpunpcklbw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0x60, 0x14, 0x01);
    FCML_A32("vpunpcklbw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0x60, 0x14, 0x01);
    FCML_I32("vpunpcklbw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0x60, 0x14, 0x01);

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpunpcklwd (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x61, 0x38), FCML_MI(0xc5, 0x41, 0x61, 0x38));
    FCML_I64_M("vpunpcklwd xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x61, 0x38), FCML_MI(0xc5, 0x41, 0x61, 0x38));
    FCML_A32_M("vpunpcklwd (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0x61, 0x38), FCML_MI(0xc5, 0xc9, 0x61, 0x38));
    FCML_I32_M("vpunpcklwd xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0x61, 0x38), FCML_MI(0xc5, 0xc9, 0x61, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpunpcklwd (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x61, 0x38), FCML_MI(0xc5, 0x45, 0x61, 0x38));
    FCML_I64_M("vpunpcklwd ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x61, 0x38), FCML_MI(0xc5, 0x45, 0x61, 0x38));
    FCML_A32_M("vpunpcklwd (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0x61, 0x38), FCML_MI(0xc5, 0xd5, 0x61, 0x38));
    FCML_I32_M("vpunpcklwd ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0x61, 0x38), FCML_MI(0xc5, 0xd5, 0x61, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpunpcklwd (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0x61, 0x38);
    FCML_I64("vpunpcklwd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0x61, 0x38);
    FCML_A32("vpunpcklwd (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0x61, 0x38);
    FCML_I32("vpunpcklwd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0x61, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpunpcklwd %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x61, 0xf9), FCML_MI(0xc5, 0x41, 0x61, 0xf9));
    FCML_I64_M("vpunpcklwd xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x61, 0xf9), FCML_MI(0xc5, 0x41, 0x61, 0xf9));
    FCML_A32_M("vpunpcklwd %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x61, 0xf9), FCML_MI(0xc5, 0xe9, 0x61, 0xf9));
    FCML_I32_M("vpunpcklwd xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x61, 0xf9), FCML_MI(0xc5, 0xe9, 0x61, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpunpcklwd %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x61, 0xf6), FCML_MI(0xc5, 0x45, 0x61, 0xf6));
    FCML_I64_M("vpunpcklwd ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x61, 0xf6), FCML_MI(0xc5, 0x45, 0x61, 0xf6));
    FCML_A32_M("vpunpcklwd %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x61, 0xf5), FCML_MI(0xc5, 0xe5, 0x61, 0xf5));
    FCML_I32_M("vpunpcklwd ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x61, 0xf5), FCML_MI(0xc5, 0xe5, 0x61, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpunpcklwd %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0x61, 0xf4);
    FCML_I64("vpunpcklwd zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0x61, 0xf4);
    FCML_A32("vpunpcklwd %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0x61, 0xf4);
    FCML_I32("vpunpcklwd zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0x61, 0xf4);
    /* disp8 */
    FCML_I32("vpunpcklwd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x61, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpcklwd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0x61, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpcklwd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x61, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpcklwd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0x61, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpunpcklwd ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x61, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x61, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpunpcklwd 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x61, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x61, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpunpcklwd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x61, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x61, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpunpcklwd 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x61, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x61, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpunpcklwd xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x61, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x61, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpunpcklwd 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x61, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x61, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpunpcklwd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x61, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x61, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpunpcklwd 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x61, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x61, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpunpcklwd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0x61, 0x14, 0x01);
    FCML_I64("vpunpcklwd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0x61, 0x14, 0x01);
    FCML_A32("vpunpcklwd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0x61, 0x14, 0x01);
    FCML_I32("vpunpcklwd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0x61, 0x14, 0x01);
    FCML_A64("vpunpcklwd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0x61, 0x14, 0x01);
    FCML_I64("vpunpcklwd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0x61, 0x14, 0x01);
    FCML_A32("vpunpcklwd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0x61, 0x14, 0x01);
    FCML_I32("vpunpcklwd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0x61, 0x14, 0x01);
    FCML_A64("vpunpcklwd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0x61, 0x14, 0x01);
    FCML_I64("vpunpcklwd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0x61, 0x14, 0x01);
    FCML_A32("vpunpcklwd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0x61, 0x14, 0x01);
    FCML_I32("vpunpcklwd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0x61, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpunpcklwd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0x61, 0x14, 0x01);
    FCML_I64("vpunpcklwd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0x61, 0x14, 0x01);
    FCML_A32("vpunpcklwd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0x61, 0x14, 0x01);
    FCML_I32("vpunpcklwd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0x61, 0x14, 0x01);
    FCML_A64("vpunpcklwd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0x61, 0x14, 0x01);
    FCML_I64("vpunpcklwd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0x61, 0x14, 0x01);
    FCML_A32("vpunpcklwd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0x61, 0x14, 0x01);
    FCML_I32("vpunpcklwd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0x61, 0x14, 0x01);
    FCML_A64("vpunpcklwd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0x61, 0x14, 0x01);
    FCML_I64("vpunpcklwd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0x61, 0x14, 0x01);
    FCML_A32("vpunpcklwd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0x61, 0x14, 0x01);
    FCML_I32("vpunpcklwd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0x61, 0x14, 0x01);

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpunpckldq (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x62, 0x38), FCML_MI(0xc5, 0x41, 0x62, 0x38));
    FCML_I64_M("vpunpckldq xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x62, 0x38), FCML_MI(0xc5, 0x41, 0x62, 0x38));
    FCML_A32_M("vpunpckldq (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0x62, 0x38), FCML_MI(0xc5, 0xc9, 0x62, 0x38));
    FCML_I32_M("vpunpckldq xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0x62, 0x38), FCML_MI(0xc5, 0xc9, 0x62, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpunpckldq (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x62, 0x38), FCML_MI(0xc5, 0x45, 0x62, 0x38));
    FCML_I64_M("vpunpckldq ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x62, 0x38), FCML_MI(0xc5, 0x45, 0x62, 0x38));
    FCML_A32_M("vpunpckldq (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0x62, 0x38), FCML_MI(0xc5, 0xd5, 0x62, 0x38));
    FCML_I32_M("vpunpckldq ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0x62, 0x38), FCML_MI(0xc5, 0xd5, 0x62, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpunpckldq (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0x62, 0x38);
    FCML_I64("vpunpckldq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0x62, 0x38);
    FCML_A32("vpunpckldq (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0x62, 0x38);
    FCML_I32("vpunpckldq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0x62, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpunpckldq %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x62, 0xf9), FCML_MI(0xc5, 0x41, 0x62, 0xf9));
    FCML_I64_M("vpunpckldq xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x62, 0xf9), FCML_MI(0xc5, 0x41, 0x62, 0xf9));
    FCML_A32_M("vpunpckldq %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x62, 0xf9), FCML_MI(0xc5, 0xe9, 0x62, 0xf9));
    FCML_I32_M("vpunpckldq xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x62, 0xf9), FCML_MI(0xc5, 0xe9, 0x62, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpunpckldq %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x62, 0xf6), FCML_MI(0xc5, 0x45, 0x62, 0xf6));
    FCML_I64_M("vpunpckldq ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x62, 0xf6), FCML_MI(0xc5, 0x45, 0x62, 0xf6));
    FCML_A32_M("vpunpckldq %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x62, 0xf5), FCML_MI(0xc5, 0xe5, 0x62, 0xf5));
    FCML_I32_M("vpunpckldq ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x62, 0xf5), FCML_MI(0xc5, 0xe5, 0x62, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpunpckldq %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0x62, 0xf4);
    FCML_I64("vpunpckldq zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0x62, 0xf4);
    FCML_A32("vpunpckldq %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0x62, 0xf4);
    FCML_I32("vpunpckldq zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0x62, 0xf4);
    /* disp8 */
    FCML_I32("vpunpckldq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x62, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpckldq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0x62, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpckldq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x62, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpckldq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0x62, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpunpckldq ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x62, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x62, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpunpckldq 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x62, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x62, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpunpckldq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x62, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x62, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpunpckldq 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x62, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x62, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpunpckldq xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x62, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x62, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpunpckldq 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x62, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x62, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpunpckldq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x62, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x62, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpunpckldq 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x62, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x62, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpunpckldq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0x62, 0x14, 0x01);
    FCML_I64("vpunpckldq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0x62, 0x14, 0x01);
    FCML_A32("vpunpckldq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0x62, 0x14, 0x01);
    FCML_I32("vpunpckldq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0x62, 0x14, 0x01);
    FCML_A64("vpunpckldq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0x62, 0x14, 0x01);
    FCML_I64("vpunpckldq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0x62, 0x14, 0x01);
    FCML_A32("vpunpckldq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0x62, 0x14, 0x01);
    FCML_I32("vpunpckldq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0x62, 0x14, 0x01);
    FCML_A64("vpunpckldq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0x62, 0x14, 0x01);
    FCML_I64("vpunpckldq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0x62, 0x14, 0x01);
    FCML_A32("vpunpckldq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0x62, 0x14, 0x01);
    FCML_I32("vpunpckldq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0x62, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpunpckldq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0x62, 0x14, 0x01);
    FCML_I64("vpunpckldq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0x62, 0x14, 0x01);
    FCML_A32("vpunpckldq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0x62, 0x14, 0x01);
    FCML_I32("vpunpckldq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0x62, 0x14, 0x01);
    FCML_A64("vpunpckldq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0x62, 0x14, 0x01);
    FCML_I64("vpunpckldq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0x62, 0x14, 0x01);
    FCML_A32("vpunpckldq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0x62, 0x14, 0x01);
    FCML_I32("vpunpckldq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0x62, 0x14, 0x01);
    FCML_A64("vpunpckldq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0x62, 0x14, 0x01);
    FCML_I64("vpunpckldq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0x62, 0x14, 0x01);
    FCML_A32("vpunpckldq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0x62, 0x14, 0x01);
    FCML_I32("vpunpckldq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0x62, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpunpckldq zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x61, 0x55, 0x50, 0x62, 0x3e);
    FCML_A64("vpunpckldq (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x61, 0x55, 0x50, 0x62, 0x3e);
    FCML_I64("vpunpckldq ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x55, 0x30, 0x62, 0x3e);
    FCML_A64("vpunpckldq (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x61, 0x55, 0x30, 0x62, 0x3e);
    FCML_I64("vpunpckldq xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x61, 0x55, 0x10, 0x62, 0x3e);
    FCML_A64("vpunpckldq (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x61, 0x55, 0x10, 0x62, 0x3e);
    FCML_A32("vpunpckldq (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0x62, 0x0e);
    FCML_I32("vpunpckldq zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0x62, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpunpckldq (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0x55, 0xb7, 0x62, 0x3e);
    FCML_I64("vpunpckldq ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x55, 0xb7, 0x62, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpunpckldq zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0x62, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpckldq 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0x62, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpckldq zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0x62, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpckldq 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0x62, 0x4c, 0x24, 0x08);
    FCML_I32("vpunpckldq ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf1, 0x6d, 0x38, 0x62, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpckldq 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf1, 0x6d, 0x38, 0x62, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpckldq ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf1, 0x6d, 0x38, 0x62, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpckldq 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf1, 0x6d, 0x38, 0x62, 0x4c, 0x24, 0x08);
    FCML_I32("vpunpckldq xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf1, 0x6d, 0x18, 0x62, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpckldq 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf1, 0x6d, 0x18, 0x62, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpckldq xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf1, 0x6d, 0x18, 0x62, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpckldq 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf1, 0x6d, 0x18, 0x62, 0x4c, 0x24, 0x08);

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpunpcklqdq (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0x6c, 0x38), FCML_MI(0xc5, 0x41, 0x6c, 0x38));
    FCML_I64_M("vpunpcklqdq xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0x6c, 0x38), FCML_MI(0xc5, 0x41, 0x6c, 0x38));
    FCML_A32_M("vpunpcklqdq (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0x6c, 0x38), FCML_MI(0xc5, 0xc9, 0x6c, 0x38));
    FCML_I32_M("vpunpcklqdq xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0x6c, 0x38), FCML_MI(0xc5, 0xc9, 0x6c, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpunpcklqdq (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0x6c, 0x38), FCML_MI(0xc5, 0x45, 0x6c, 0x38));
    FCML_I64_M("vpunpcklqdq ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0x6c, 0x38), FCML_MI(0xc5, 0x45, 0x6c, 0x38));
    FCML_A32_M("vpunpcklqdq (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0xd5, 0x28, 0x6c, 0x38), FCML_MI(0xc5, 0xd5, 0x6c, 0x38));
    FCML_I32_M("vpunpcklqdq ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0xd5, 0x28, 0x6c, 0x38), FCML_MI(0xc5, 0xd5, 0x6c, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpunpcklqdq (%rax),%zmm7,%zmm15", 0x62, 0x71, 0xc5, 0x48, 0x6c, 0x38);
    FCML_I64("vpunpcklqdq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0xc5, 0x48, 0x6c, 0x38);
    FCML_A32("vpunpcklqdq (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0xe5, 0x48, 0x6c, 0x38);
    FCML_I32("vpunpcklqdq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0xe5, 0x48, 0x6c, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpunpcklqdq %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0x6c, 0xf9), FCML_MI(0xc5, 0x41, 0x6c, 0xf9));
    FCML_I64_M("vpunpcklqdq xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0x6c, 0xf9), FCML_MI(0xc5, 0x41, 0x6c, 0xf9));
    FCML_A32_M("vpunpcklqdq %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x6c, 0xf9), FCML_MI(0xc5, 0xe9, 0x6c, 0xf9));
    FCML_I32_M("vpunpcklqdq xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x6c, 0xf9), FCML_MI(0xc5, 0xe9, 0x6c, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpunpcklqdq %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0x6c, 0xf6), FCML_MI(0xc5, 0x45, 0x6c, 0xf6));
    FCML_I64_M("vpunpcklqdq ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0x6c, 0xf6), FCML_MI(0xc5, 0x45, 0x6c, 0xf6));
    FCML_A32_M("vpunpcklqdq %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0xe5, 0x28, 0x6c, 0xf5), FCML_MI(0xc5, 0xe5, 0x6c, 0xf5));
    FCML_I32_M("vpunpcklqdq ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0xe5, 0x28, 0x6c, 0xf5), FCML_MI(0xc5, 0xe5, 0x6c, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpunpcklqdq %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x85, 0x48, 0x6c, 0xf4);
    FCML_I64("vpunpcklqdq zmm6,zmm15,zmm4", 0x62, 0xf1, 0x85, 0x48, 0x6c, 0xf4);
    FCML_A32("vpunpcklqdq %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0xcd, 0x48, 0x6c, 0xf4);
    FCML_I32("vpunpcklqdq zmm6,zmm6,zmm4", 0x62, 0xf1, 0xcd, 0x48, 0x6c, 0xf4);
    /* disp8 */
    FCML_I32("vpunpcklqdq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0xed, 0x48, 0x6c, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpcklqdq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x48, 0x6c, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpcklqdq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0xed, 0x48, 0x6c, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpcklqdq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x48, 0x6c, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpunpcklqdq ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0x6c, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x6c, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpunpcklqdq 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0x6c, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x6c, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpunpcklqdq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0x6c, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x6c, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpunpcklqdq 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0x6c, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x6c, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpunpcklqdq xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x6c, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x6c, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpunpcklqdq 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x6c, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x6c, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpunpcklqdq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x6c, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x6c, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpunpcklqdq 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x6c, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x6c, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpunpcklqdq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x8d, 0x8c, 0x6c, 0x14, 0x01);
    FCML_I64("vpunpcklqdq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x8c, 0x6c, 0x14, 0x01);
    FCML_A32("vpunpcklqdq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0x8d, 0x6c, 0x14, 0x01);
    FCML_I32("vpunpcklqdq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x8d, 0x6c, 0x14, 0x01);
    FCML_A64("vpunpcklqdq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x8d, 0xac, 0x6c, 0x14, 0x01);
    FCML_I64("vpunpcklqdq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0xac, 0x6c, 0x14, 0x01);
    FCML_A32("vpunpcklqdq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0xad, 0x6c, 0x14, 0x01);
    FCML_I32("vpunpcklqdq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0xad, 0x6c, 0x14, 0x01);
    FCML_A64("vpunpcklqdq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x8d, 0xcc, 0x6c, 0x14, 0x01);
    FCML_I64("vpunpcklqdq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0xcc, 0x6c, 0x14, 0x01);
    FCML_A32("vpunpcklqdq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0xcd, 0x6c, 0x14, 0x01);
    FCML_I32("vpunpcklqdq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0xcd, 0x6c, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpunpcklqdq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x8d, 0x0c, 0x6c, 0x14, 0x01);
    FCML_I64("vpunpcklqdq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x0c, 0x6c, 0x14, 0x01);
    FCML_A32("vpunpcklqdq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0xc5, 0x0d, 0x6c, 0x14, 0x01);
    FCML_I32("vpunpcklqdq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x0d, 0x6c, 0x14, 0x01);
    FCML_A64("vpunpcklqdq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x8d, 0x2c, 0x6c, 0x14, 0x01);
    FCML_I64("vpunpcklqdq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x2c, 0x6c, 0x14, 0x01);
    FCML_A32("vpunpcklqdq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0xc5, 0x2d, 0x6c, 0x14, 0x01);
    FCML_I32("vpunpcklqdq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x2d, 0x6c, 0x14, 0x01);
    FCML_A64("vpunpcklqdq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x8d, 0x4c, 0x6c, 0x14, 0x01);
    FCML_I64("vpunpcklqdq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x4c, 0x6c, 0x14, 0x01);
    FCML_A32("vpunpcklqdq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0xc5, 0x4d, 0x6c, 0x14, 0x01);
    FCML_I32("vpunpcklqdq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x4d, 0x6c, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpunpcklqdq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xd5, 0x50, 0x6c, 0x3e);
    FCML_A64("vpunpcklqdq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x61, 0xd5, 0x50, 0x6c, 0x3e);
    FCML_I64("vpunpcklqdq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xd5, 0x30, 0x6c, 0x3e);
    FCML_A64("vpunpcklqdq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x61, 0xd5, 0x30, 0x6c, 0x3e);
    FCML_I64("vpunpcklqdq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x61, 0xd5, 0x10, 0x6c, 0x3e);
    FCML_A64("vpunpcklqdq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x61, 0xd5, 0x10, 0x6c, 0x3e);
    FCML_A32("vpunpcklqdq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0x6c, 0x0e);
    FCML_I32("vpunpcklqdq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0x6c, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpunpcklqdq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0xd5, 0xb7, 0x6c, 0x3e);
    FCML_I64("vpunpcklqdq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xd5, 0xb7, 0x6c, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpunpcklqdq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0x6c, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpcklqdq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0x6c, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpcklqdq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0x6c, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpcklqdq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0x6c, 0x4c, 0x24, 0x08);
    FCML_I32("vpunpcklqdq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf1, 0xed, 0x38, 0x6c, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpcklqdq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x38, 0x6c, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpcklqdq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf1, 0xed, 0x38, 0x6c, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpcklqdq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x38, 0x6c, 0x4c, 0x24, 0x08);
    FCML_I32("vpunpcklqdq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf1, 0xed, 0x18, 0x6c, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpcklqdq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x18, 0x6c, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpcklqdq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf1, 0xed, 0x18, 0x6c, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpcklqdq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x18, 0x6c, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PUNPCKHB(void) {

    FCML_I64( "punpckhbw mm0,mmword ptr [rax]", 0x0F, 0x68, 0x00 );
    FCML_I32( "punpckhbw mm0,mm1", 0x0F, 0x68, 0xC1 );

    FCML_I64( "punpckhwd mm0,mmword ptr [rax]", 0x0F, 0x69, 0x00 );
    FCML_I32( "punpckhwd mm0,mm1", 0x0F, 0x69, 0xC1 );

    FCML_I64( "punpckhdq mm0,mmword ptr [rax]", 0x0F, 0x6A, 0x00 );
    FCML_I32( "punpckhdq mm0,mm1", 0x0F, 0x6A, 0xC1 );

    FCML_I64( "punpckhbw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x68, 0x00 );
    FCML_I32( "punpckhbw xmm0,xmm1", 0x66, 0x0F, 0x68, 0xC1 );

    FCML_I64( "punpckhwd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x69, 0x00 );
    FCML_I32( "punpckhwd xmm0,xmm1", 0x66, 0x0F, 0x69, 0xC1 );

    FCML_I64( "punpckhdq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x6A, 0x00 );
    FCML_I32( "punpckhdq xmm0,xmm1", 0x66, 0x0F, 0x6A, 0xC1 );

    FCML_I64( "punpckhqdq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x6D, 0x00 );
    FCML_I32( "punpckhqdq xmm0,xmm1", 0x66, 0x0F, 0x6D, 0xC1 );

    FCML_A64( "punpckhbw (%rax),%mm0", 0x0f, 0x68, 0x00 );
    FCML_A64( "punpckhbw %mm1,%mm0", 0x0f, 0x68, 0xc1 );
    FCML_A64( "punpckhwd (%rax),%mm0", 0x0f, 0x69, 0x00 );
    FCML_A64( "punpckhwd %mm1,%mm0", 0x0f, 0x69, 0xc1 );
    FCML_A64( "punpckhdq (%rax),%mm0", 0x0f, 0x6a, 0x00 );
    FCML_A64( "punpckhdq %mm1,%mm0", 0x0f, 0x6a, 0xc1 );
    FCML_A64( "punpckhbw (%rax),%xmm0", 0x66, 0x0f, 0x68, 0x00 );
    FCML_A64( "punpckhbw %xmm1,%xmm0", 0x66, 0x0f, 0x68, 0xc1 );
    FCML_A64( "punpckhwd (%rax),%xmm0", 0x66, 0x0f, 0x69, 0x00 );
    FCML_A64( "punpckhwd %xmm1,%xmm0", 0x66, 0x0f, 0x69, 0xc1 );
    FCML_A64( "punpckhdq (%rax),%xmm0", 0x66, 0x0f, 0x6a, 0x00 );
    FCML_A64( "punpckhdq %xmm1,%xmm0", 0x66, 0x0f, 0x6a, 0xc1 );
    FCML_A64( "punpckhqdq (%rax),%xmm0", 0x66, 0x0f, 0x6d, 0x00 );
    FCML_A64( "punpckhqdq %xmm1,%xmm0", 0x66, 0x0f, 0x6d, 0xc1 );

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpunpckhbw (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x68, 0x38), FCML_MI(0xc5, 0x41, 0x68, 0x38));
    FCML_I64_M("vpunpckhbw xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x68, 0x38), FCML_MI(0xc5, 0x41, 0x68, 0x38));
    FCML_A32_M("vpunpckhbw (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0x68, 0x38), FCML_MI(0xc5, 0xc9, 0x68, 0x38));
    FCML_I32_M("vpunpckhbw xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0x68, 0x38), FCML_MI(0xc5, 0xc9, 0x68, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpunpckhbw (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x68, 0x38), FCML_MI(0xc5, 0x45, 0x68, 0x38));
    FCML_I64_M("vpunpckhbw ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x68, 0x38), FCML_MI(0xc5, 0x45, 0x68, 0x38));
    FCML_A32_M("vpunpckhbw (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0x68, 0x38), FCML_MI(0xc5, 0xd5, 0x68, 0x38));
    FCML_I32_M("vpunpckhbw ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0x68, 0x38), FCML_MI(0xc5, 0xd5, 0x68, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpunpckhbw (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0x68, 0x38);
    FCML_I64("vpunpckhbw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0x68, 0x38);
    FCML_A32("vpunpckhbw (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0x68, 0x38);
    FCML_I32("vpunpckhbw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0x68, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpunpckhbw %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x68, 0xf9), FCML_MI(0xc5, 0x41, 0x68, 0xf9));
    FCML_I64_M("vpunpckhbw xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x68, 0xf9), FCML_MI(0xc5, 0x41, 0x68, 0xf9));
    FCML_A32_M("vpunpckhbw %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x68, 0xf9), FCML_MI(0xc5, 0xe9, 0x68, 0xf9));
    FCML_I32_M("vpunpckhbw xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x68, 0xf9), FCML_MI(0xc5, 0xe9, 0x68, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpunpckhbw %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x68, 0xf6), FCML_MI(0xc5, 0x45, 0x68, 0xf6));
    FCML_I64_M("vpunpckhbw ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x68, 0xf6), FCML_MI(0xc5, 0x45, 0x68, 0xf6));
    FCML_A32_M("vpunpckhbw %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x68, 0xf5), FCML_MI(0xc5, 0xe5, 0x68, 0xf5));
    FCML_I32_M("vpunpckhbw ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x68, 0xf5), FCML_MI(0xc5, 0xe5, 0x68, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpunpckhbw %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0x68, 0xf4);
    FCML_I64("vpunpckhbw zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0x68, 0xf4);
    FCML_A32("vpunpckhbw %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0x68, 0xf4);
    FCML_I32("vpunpckhbw zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0x68, 0xf4);
    /* disp8 */
    FCML_I32("vpunpckhbw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x68, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpckhbw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0x68, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpckhbw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x68, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpckhbw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0x68, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpunpckhbw ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x68, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x68, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpunpckhbw 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x68, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x68, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpunpckhbw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x68, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x68, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpunpckhbw 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x68, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x68, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpunpckhbw xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x68, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x68, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpunpckhbw 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x68, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x68, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpunpckhbw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x68, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x68, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpunpckhbw 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x68, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x68, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpunpckhbw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0x68, 0x14, 0x01);
    FCML_I64("vpunpckhbw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0x68, 0x14, 0x01);
    FCML_A32("vpunpckhbw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0x68, 0x14, 0x01);
    FCML_I32("vpunpckhbw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0x68, 0x14, 0x01);
    FCML_A64("vpunpckhbw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0x68, 0x14, 0x01);
    FCML_I64("vpunpckhbw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0x68, 0x14, 0x01);
    FCML_A32("vpunpckhbw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0x68, 0x14, 0x01);
    FCML_I32("vpunpckhbw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0x68, 0x14, 0x01);
    FCML_A64("vpunpckhbw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0x68, 0x14, 0x01);
    FCML_I64("vpunpckhbw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0x68, 0x14, 0x01);
    FCML_A32("vpunpckhbw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0x68, 0x14, 0x01);
    FCML_I32("vpunpckhbw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0x68, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpunpckhbw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0x68, 0x14, 0x01);
    FCML_I64("vpunpckhbw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0x68, 0x14, 0x01);
    FCML_A32("vpunpckhbw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0x68, 0x14, 0x01);
    FCML_I32("vpunpckhbw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0x68, 0x14, 0x01);
    FCML_A64("vpunpckhbw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0x68, 0x14, 0x01);
    FCML_I64("vpunpckhbw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0x68, 0x14, 0x01);
    FCML_A32("vpunpckhbw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0x68, 0x14, 0x01);
    FCML_I32("vpunpckhbw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0x68, 0x14, 0x01);
    FCML_A64("vpunpckhbw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0x68, 0x14, 0x01);
    FCML_I64("vpunpckhbw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0x68, 0x14, 0x01);
    FCML_A32("vpunpckhbw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0x68, 0x14, 0x01);
    FCML_I32("vpunpckhbw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0x68, 0x14, 0x01);

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpunpckhwd (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x69, 0x38), FCML_MI(0xc5, 0x41, 0x69, 0x38));
    FCML_I64_M("vpunpckhwd xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x69, 0x38), FCML_MI(0xc5, 0x41, 0x69, 0x38));
    FCML_A32_M("vpunpckhwd (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0x69, 0x38), FCML_MI(0xc5, 0xc9, 0x69, 0x38));
    FCML_I32_M("vpunpckhwd xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4d, 0x08, 0x69, 0x38), FCML_MI(0xc5, 0xc9, 0x69, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpunpckhwd (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x69, 0x38), FCML_MI(0xc5, 0x45, 0x69, 0x38));
    FCML_I64_M("vpunpckhwd ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x69, 0x38), FCML_MI(0xc5, 0x45, 0x69, 0x38));
    FCML_A32_M("vpunpckhwd (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0x69, 0x38), FCML_MI(0xc5, 0xd5, 0x69, 0x38));
    FCML_I32_M("vpunpckhwd ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0x69, 0x38), FCML_MI(0xc5, 0xd5, 0x69, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpunpckhwd (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0x69, 0x38);
    FCML_I64("vpunpckhwd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0x69, 0x38);
    FCML_A32("vpunpckhwd (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0x69, 0x38);
    FCML_I32("vpunpckhwd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0x69, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpunpckhwd %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x69, 0xf9), FCML_MI(0xc5, 0x41, 0x69, 0xf9));
    FCML_I64_M("vpunpckhwd xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x69, 0xf9), FCML_MI(0xc5, 0x41, 0x69, 0xf9));
    FCML_A32_M("vpunpckhwd %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x69, 0xf9), FCML_MI(0xc5, 0xe9, 0x69, 0xf9));
    FCML_I32_M("vpunpckhwd xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x69, 0xf9), FCML_MI(0xc5, 0xe9, 0x69, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpunpckhwd %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x69, 0xf6), FCML_MI(0xc5, 0x45, 0x69, 0xf6));
    FCML_I64_M("vpunpckhwd ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x69, 0xf6), FCML_MI(0xc5, 0x45, 0x69, 0xf6));
    FCML_A32_M("vpunpckhwd %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x69, 0xf5), FCML_MI(0xc5, 0xe5, 0x69, 0xf5));
    FCML_I32_M("vpunpckhwd ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x69, 0xf5), FCML_MI(0xc5, 0xe5, 0x69, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpunpckhwd %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0x69, 0xf4);
    FCML_I64("vpunpckhwd zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0x69, 0xf4);
    FCML_A32("vpunpckhwd %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0x69, 0xf4);
    FCML_I32("vpunpckhwd zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0x69, 0xf4);
    /* disp8 */
    FCML_I32("vpunpckhwd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x69, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpckhwd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0x69, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpckhwd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x69, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpckhwd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0x69, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpunpckhwd ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x69, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x69, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpunpckhwd 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x69, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x69, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpunpckhwd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x69, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x69, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpunpckhwd 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x69, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x69, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpunpckhwd xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x69, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x69, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpunpckhwd 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x69, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x69, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpunpckhwd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x69, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x69, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpunpckhwd 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x69, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x69, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpunpckhwd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0x69, 0x14, 0x01);
    FCML_I64("vpunpckhwd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0x69, 0x14, 0x01);
    FCML_A32("vpunpckhwd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0x69, 0x14, 0x01);
    FCML_I32("vpunpckhwd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0x69, 0x14, 0x01);
    FCML_A64("vpunpckhwd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0x69, 0x14, 0x01);
    FCML_I64("vpunpckhwd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0x69, 0x14, 0x01);
    FCML_A32("vpunpckhwd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0x69, 0x14, 0x01);
    FCML_I32("vpunpckhwd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0x69, 0x14, 0x01);
    FCML_A64("vpunpckhwd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0x69, 0x14, 0x01);
    FCML_I64("vpunpckhwd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0x69, 0x14, 0x01);
    FCML_A32("vpunpckhwd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0x69, 0x14, 0x01);
    FCML_I32("vpunpckhwd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0x69, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpunpckhwd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0x69, 0x14, 0x01);
    FCML_I64("vpunpckhwd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0x69, 0x14, 0x01);
    FCML_A32("vpunpckhwd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0x69, 0x14, 0x01);
    FCML_I32("vpunpckhwd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0x69, 0x14, 0x01);
    FCML_A64("vpunpckhwd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0x69, 0x14, 0x01);
    FCML_I64("vpunpckhwd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0x69, 0x14, 0x01);
    FCML_A32("vpunpckhwd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0x69, 0x14, 0x01);
    FCML_I32("vpunpckhwd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0x69, 0x14, 0x01);
    FCML_A64("vpunpckhwd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0x69, 0x14, 0x01);
    FCML_I64("vpunpckhwd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0x69, 0x14, 0x01);
    FCML_A32("vpunpckhwd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0x69, 0x14, 0x01);
    FCML_I32("vpunpckhwd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0x69, 0x14, 0x01);

    /* xmm1, xmm2, m128 */
    FCML_I64_M("vpunpckhdq ymm0,ymm0,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0x6a, 0x00), FCML_MI(0xc5, 0xfd, 0x6a, 0x00));
    FCML_I32_M("vpunpckhdq ymm0,ymm0,ymm1", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0x6a, 0xc1), FCML_MI(0xc5, 0xfd, 0x6a, 0xc1));
    FCML_A64_M("vpunpckhdq (%rax),%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0x6a, 0x00), FCML_MI(0xc5, 0xfd, 0x6a, 0x00));
    FCML_A64_M("vpunpckhdq %ymm1,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7d, 0x28, 0x6a, 0xc1), FCML_MI(0xc5, 0xfd, 0x6a, 0xc1));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpunpckhdq (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x6a, 0x38), FCML_MI(0xc5, 0x45, 0x6a, 0x38));
    FCML_I64_M("vpunpckhdq ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x6a, 0x38), FCML_MI(0xc5, 0x45, 0x6a, 0x38));
    FCML_A32_M("vpunpckhdq (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0x6a, 0x38), FCML_MI(0xc5, 0xd5, 0x6a, 0x38));
    FCML_I32_M("vpunpckhdq ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x55, 0x28, 0x6a, 0x38), FCML_MI(0xc5, 0xd5, 0x6a, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpunpckhdq (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0x6a, 0x38);
    FCML_I64("vpunpckhdq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0x6a, 0x38);
    FCML_A32("vpunpckhdq (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0x6a, 0x38);
    FCML_I32("vpunpckhdq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0x6a, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpunpckhdq %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x6a, 0xf9), FCML_MI(0xc5, 0x41, 0x6a, 0xf9));
    FCML_I64_M("vpunpckhdq xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0x45, 0x08, 0x6a, 0xf9), FCML_MI(0xc5, 0x41, 0x6a, 0xf9));
    FCML_A32_M("vpunpckhdq %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x6a, 0xf9), FCML_MI(0xc5, 0xe9, 0x6a, 0xf9));
    FCML_I32_M("vpunpckhdq xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x6a, 0xf9), FCML_MI(0xc5, 0xe9, 0x6a, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpunpckhdq %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x6a, 0xf6), FCML_MI(0xc5, 0x45, 0x6a, 0xf6));
    FCML_I64_M("vpunpckhdq ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0x45, 0x28, 0x6a, 0xf6), FCML_MI(0xc5, 0x45, 0x6a, 0xf6));
    FCML_A32_M("vpunpckhdq %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x6a, 0xf5), FCML_MI(0xc5, 0xe5, 0x6a, 0xf5));
    FCML_I32_M("vpunpckhdq ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0x65, 0x28, 0x6a, 0xf5), FCML_MI(0xc5, 0xe5, 0x6a, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpunpckhdq %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0x6a, 0xf4);
    FCML_I64("vpunpckhdq zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0x6a, 0xf4);
    FCML_A32("vpunpckhdq %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0x6a, 0xf4);
    FCML_I32("vpunpckhdq zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0x6a, 0xf4);
    /* disp8 */
    FCML_I32("vpunpckhdq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x6a, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpckhdq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0x6a, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpckhdq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0x6a, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpckhdq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0x6a, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpunpckhdq ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x6a, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x6a, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpunpckhdq 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x6a, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x6a, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpunpckhdq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x6a, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x6a, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpunpckhdq 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x28, 0x6a, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x6a, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpunpckhdq xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x6a, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x6a, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpunpckhdq 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x6a, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x6a, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpunpckhdq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x6a, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x6a, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpunpckhdq 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6d, 0x08, 0x6a, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x6a, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpunpckhdq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0x6a, 0x14, 0x01);
    FCML_I64("vpunpckhdq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0x6a, 0x14, 0x01);
    FCML_A32("vpunpckhdq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0x6a, 0x14, 0x01);
    FCML_I32("vpunpckhdq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0x6a, 0x14, 0x01);
    FCML_A64("vpunpckhdq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0x6a, 0x14, 0x01);
    FCML_I64("vpunpckhdq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0x6a, 0x14, 0x01);
    FCML_A32("vpunpckhdq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0x6a, 0x14, 0x01);
    FCML_I32("vpunpckhdq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0x6a, 0x14, 0x01);
    FCML_A64("vpunpckhdq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0x6a, 0x14, 0x01);
    FCML_I64("vpunpckhdq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0x6a, 0x14, 0x01);
    FCML_A32("vpunpckhdq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0x6a, 0x14, 0x01);
    FCML_I32("vpunpckhdq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0x6a, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpunpckhdq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0x6a, 0x14, 0x01);
    FCML_I64("vpunpckhdq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0x6a, 0x14, 0x01);
    FCML_A32("vpunpckhdq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0x6a, 0x14, 0x01);
    FCML_I32("vpunpckhdq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0x6a, 0x14, 0x01);
    FCML_A64("vpunpckhdq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0x6a, 0x14, 0x01);
    FCML_I64("vpunpckhdq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0x6a, 0x14, 0x01);
    FCML_A32("vpunpckhdq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0x6a, 0x14, 0x01);
    FCML_I32("vpunpckhdq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0x6a, 0x14, 0x01);
    FCML_A64("vpunpckhdq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0x6a, 0x14, 0x01);
    FCML_I64("vpunpckhdq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0x6a, 0x14, 0x01);
    FCML_A32("vpunpckhdq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0x6a, 0x14, 0x01);
    FCML_I32("vpunpckhdq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0x6a, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpunpckhdq zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x61, 0x55, 0x50, 0x6a, 0x3e);
    FCML_A64("vpunpckhdq (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x61, 0x55, 0x50, 0x6a, 0x3e);
    FCML_I64("vpunpckhdq ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x55, 0x30, 0x6a, 0x3e);
    FCML_A64("vpunpckhdq (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x61, 0x55, 0x30, 0x6a, 0x3e);
    FCML_I64("vpunpckhdq xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x61, 0x55, 0x10, 0x6a, 0x3e);
    FCML_A64("vpunpckhdq (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x61, 0x55, 0x10, 0x6a, 0x3e);
    FCML_A32("vpunpckhdq (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0x6a, 0x0e);
    FCML_I32("vpunpckhdq zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0x6a, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpunpckhdq (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0x55, 0xb7, 0x6a, 0x3e);
    FCML_I64("vpunpckhdq ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x55, 0xb7, 0x6a, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpunpckhdq zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0x6a, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpckhdq 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0x6a, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpckhdq zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0x6a, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpckhdq 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0x6a, 0x4c, 0x24, 0x08);
    FCML_I32("vpunpckhdq ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf1, 0x6d, 0x38, 0x6a, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpckhdq 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf1, 0x6d, 0x38, 0x6a, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpckhdq ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf1, 0x6d, 0x38, 0x6a, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpckhdq 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf1, 0x6d, 0x38, 0x6a, 0x4c, 0x24, 0x08);
    FCML_I32("vpunpckhdq xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf1, 0x6d, 0x18, 0x6a, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpckhdq 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf1, 0x6d, 0x18, 0x6a, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpckhdq xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf1, 0x6d, 0x18, 0x6a, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpckhdq 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf1, 0x6d, 0x18, 0x6a, 0x4c, 0x24, 0x08);

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpunpckhqdq (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0x6d, 0x38), FCML_MI(0xc5, 0x41, 0x6d, 0x38));
    FCML_I64_M("vpunpckhqdq xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0x6d, 0x38), FCML_MI(0xc5, 0x41, 0x6d, 0x38));
    FCML_A32_M("vpunpckhqdq (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0x6d, 0x38), FCML_MI(0xc5, 0xc9, 0x6d, 0x38));
    FCML_I32_M("vpunpckhqdq xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0x6d, 0x38), FCML_MI(0xc5, 0xc9, 0x6d, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpunpckhqdq (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0x6d, 0x38), FCML_MI(0xc5, 0x45, 0x6d, 0x38));
    FCML_I64_M("vpunpckhqdq ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0x6d, 0x38), FCML_MI(0xc5, 0x45, 0x6d, 0x38));
    FCML_A32_M("vpunpckhqdq (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0xd5, 0x28, 0x6d, 0x38), FCML_MI(0xc5, 0xd5, 0x6d, 0x38));
    FCML_I32_M("vpunpckhqdq ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0xd5, 0x28, 0x6d, 0x38), FCML_MI(0xc5, 0xd5, 0x6d, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpunpckhqdq (%rax),%zmm7,%zmm15", 0x62, 0x71, 0xc5, 0x48, 0x6d, 0x38);
    FCML_I64("vpunpckhqdq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0xc5, 0x48, 0x6d, 0x38);
    FCML_A32("vpunpckhqdq (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0xe5, 0x48, 0x6d, 0x38);
    FCML_I32("vpunpckhqdq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0xe5, 0x48, 0x6d, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpunpckhqdq %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0x6d, 0xf9), FCML_MI(0xc5, 0x41, 0x6d, 0xf9));
    FCML_I64_M("vpunpckhqdq xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0x6d, 0xf9), FCML_MI(0xc5, 0x41, 0x6d, 0xf9));
    FCML_A32_M("vpunpckhqdq %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x6d, 0xf9), FCML_MI(0xc5, 0xe9, 0x6d, 0xf9));
    FCML_I32_M("vpunpckhqdq xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x6d, 0xf9), FCML_MI(0xc5, 0xe9, 0x6d, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpunpckhqdq %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0x6d, 0xf6), FCML_MI(0xc5, 0x45, 0x6d, 0xf6));
    FCML_I64_M("vpunpckhqdq ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0x6d, 0xf6), FCML_MI(0xc5, 0x45, 0x6d, 0xf6));
    FCML_A32_M("vpunpckhqdq %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0xe5, 0x28, 0x6d, 0xf5), FCML_MI(0xc5, 0xe5, 0x6d, 0xf5));
    FCML_I32_M("vpunpckhqdq ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf1, 0xe5, 0x28, 0x6d, 0xf5), FCML_MI(0xc5, 0xe5, 0x6d, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpunpckhqdq %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x85, 0x48, 0x6d, 0xf4);
    FCML_I64("vpunpckhqdq zmm6,zmm15,zmm4", 0x62, 0xf1, 0x85, 0x48, 0x6d, 0xf4);
    FCML_A32("vpunpckhqdq %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0xcd, 0x48, 0x6d, 0xf4);
    FCML_I32("vpunpckhqdq zmm6,zmm6,zmm4", 0x62, 0xf1, 0xcd, 0x48, 0x6d, 0xf4);
    /* disp8 */
    FCML_I32("vpunpckhqdq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0xed, 0x48, 0x6d, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpckhqdq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x48, 0x6d, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpckhqdq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0xed, 0x48, 0x6d, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpckhqdq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x48, 0x6d, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpunpckhqdq ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0x6d, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x6d, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpunpckhqdq 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0x6d, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x6d, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpunpckhqdq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0x6d, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x6d, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpunpckhqdq 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0x6d, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xed, 0x6d, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpunpckhqdq xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x6d, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x6d, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpunpckhqdq 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x6d, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x6d, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpunpckhqdq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x6d, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x6d, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpunpckhqdq 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0x6d, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xe9, 0x6d, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpunpckhqdq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x8d, 0x8c, 0x6d, 0x14, 0x01);
    FCML_I64("vpunpckhqdq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x8c, 0x6d, 0x14, 0x01);
    FCML_A32("vpunpckhqdq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0x8d, 0x6d, 0x14, 0x01);
    FCML_I32("vpunpckhqdq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x8d, 0x6d, 0x14, 0x01);
    FCML_A64("vpunpckhqdq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x8d, 0xac, 0x6d, 0x14, 0x01);
    FCML_I64("vpunpckhqdq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0xac, 0x6d, 0x14, 0x01);
    FCML_A32("vpunpckhqdq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0xad, 0x6d, 0x14, 0x01);
    FCML_I32("vpunpckhqdq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0xad, 0x6d, 0x14, 0x01);
    FCML_A64("vpunpckhqdq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x8d, 0xcc, 0x6d, 0x14, 0x01);
    FCML_I64("vpunpckhqdq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0xcc, 0x6d, 0x14, 0x01);
    FCML_A32("vpunpckhqdq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0xcd, 0x6d, 0x14, 0x01);
    FCML_I32("vpunpckhqdq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0xcd, 0x6d, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpunpckhqdq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x8d, 0x0c, 0x6d, 0x14, 0x01);
    FCML_I64("vpunpckhqdq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x0c, 0x6d, 0x14, 0x01);
    FCML_A32("vpunpckhqdq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0xc5, 0x0d, 0x6d, 0x14, 0x01);
    FCML_I32("vpunpckhqdq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x0d, 0x6d, 0x14, 0x01);
    FCML_A64("vpunpckhqdq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x8d, 0x2c, 0x6d, 0x14, 0x01);
    FCML_I64("vpunpckhqdq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x2c, 0x6d, 0x14, 0x01);
    FCML_A32("vpunpckhqdq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0xc5, 0x2d, 0x6d, 0x14, 0x01);
    FCML_I32("vpunpckhqdq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x2d, 0x6d, 0x14, 0x01);
    FCML_A64("vpunpckhqdq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x8d, 0x4c, 0x6d, 0x14, 0x01);
    FCML_I64("vpunpckhqdq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x4c, 0x6d, 0x14, 0x01);
    FCML_A32("vpunpckhqdq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0xc5, 0x4d, 0x6d, 0x14, 0x01);
    FCML_I32("vpunpckhqdq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x4d, 0x6d, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpunpckhqdq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xd5, 0x50, 0x6d, 0x3e);
    FCML_A64("vpunpckhqdq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x61, 0xd5, 0x50, 0x6d, 0x3e);
    FCML_I64("vpunpckhqdq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xd5, 0x30, 0x6d, 0x3e);
    FCML_A64("vpunpckhqdq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x61, 0xd5, 0x30, 0x6d, 0x3e);
    FCML_I64("vpunpckhqdq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x61, 0xd5, 0x10, 0x6d, 0x3e);
    FCML_A64("vpunpckhqdq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x61, 0xd5, 0x10, 0x6d, 0x3e);
    FCML_A32("vpunpckhqdq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0x6d, 0x0e);
    FCML_I32("vpunpckhqdq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0x6d, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpunpckhqdq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0xd5, 0xb7, 0x6d, 0x3e);
    FCML_I64("vpunpckhqdq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xd5, 0xb7, 0x6d, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpunpckhqdq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0x6d, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpckhqdq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0x6d, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpckhqdq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0x6d, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpckhqdq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0x6d, 0x4c, 0x24, 0x08);
    FCML_I32("vpunpckhqdq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf1, 0xed, 0x38, 0x6d, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpckhqdq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x38, 0x6d, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpckhqdq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf1, 0xed, 0x38, 0x6d, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpckhqdq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x38, 0x6d, 0x4c, 0x24, 0x08);
    FCML_I32("vpunpckhqdq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf1, 0xed, 0x18, 0x6d, 0x4c, 0x24, 0x08);
    FCML_A32("vpunpckhqdq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x18, 0x6d, 0x4c, 0x24, 0x08);
    FCML_I64("vpunpckhqdq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf1, 0xed, 0x18, 0x6d, 0x4c, 0x24, 0x08);
    FCML_A64("vpunpckhqdq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x18, 0x6d, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PUSH(void) {

    FCML_I32( "push dword ptr [eax]", 0xFF, 0x30 );
    FCML_I32_M( "push ecx", 2, FCML_MI( 0x51 ), FCML_MI( 0xff, 0xf1 ) );
    FCML_I32( "push word ptr [eax]", 0x66, 0xFF, 0x30 );
    FCML_I32_M( "push cx", 2, FCML_MI( 0x66, 0x51 ), FCML_MI( 0x66, 0xff, 0xf1 ) );
    FCML_I32( "push dword ptr [bx+si]", 0x67, 0xFF, 0x30 );
    FCML_I32_D( "push ecx", 0x67, 0xFF, 0xF1 );
    FCML_I32( "push word ptr [bx+si]", 0x66, 0x67, 0xFF, 0x30 );
    FCML_I32_D( "push cx", 0x66, 0x67, 0xFF, 0xF1 );

    FCML_A32( "pushl (%eax)", 0xFF, 0x30 );

    FCML_I64( "push qword ptr [rax]", 0xFF, 0x30 );
    FCML_I64_M( "push rcx", 2, FCML_MI( 0x51 ), FCML_MI( 0xff, 0xf1 ) );
    FCML_I64( "push word ptr [rax]", 0x66, 0xFF, 0x30 );
    FCML_I64_M( "push cx", 2, FCML_MI( 0x66, 0x51 ), FCML_MI( 0x66, 0xff, 0xf1 ) );
    FCML_I64( "push qword ptr [eax]", 0x67, 0xFF, 0x30 );
    FCML_I64_D( "push rcx", 0x67, 0xFF, 0xF1 );
    FCML_I64( "push word ptr [eax]", 0x66, 0x67, 0xFF, 0x30 );
    FCML_I64_D( "push cx", 0x66, 0x67, 0xFF, 0xF1 );
    FCML_I64_D( "push qword ptr [rax]", 0x48, 0xFF, 0x30 );
    FCML_I64_D( "push rcx", 0x48, 0xFF, 0xF1 );

    FCML_A64( "pushq (%rax)", 0xFF, 0x30 );
    FCML_A64_M( "push %rcx", 2, FCML_MI( 0x51 ), FCML_MI( 0xff, 0xf1 ) );
    FCML_A64( "pushw (%rax)", 0x66, 0xFF, 0x30 );
    FCML_A64_M( "push %cx", 2, FCML_MI( 0x66, 0x51 ), FCML_MI( 0x66, 0xff, 0xf1 ) );
    FCML_A64( "pushq (%eax)", 0x67, 0xFF, 0x30 );
    FCML_A64_D( "push %rcx", 0x67, 0xFF, 0xF1 );
    FCML_A64( "pushw (%eax)", 0x66, 0x67, 0xFF, 0x30 );
    FCML_A64_D( "push %cx", 0x66, 0x67, 0xFF, 0xF1 );
    FCML_A64_D( "pushq (%rax)", 0x48, 0xFF, 0x30 );
    FCML_A64_D( "push %rcx", 0x48, 0xFF, 0xF1 );

    FCML_I32_M( "push eax", 2, FCML_MI( 0x50 ), FCML_MI( 0xff, 0xf0 ) );
    FCML_I32_M( "push ax", 2, FCML_MI( 0x66, 0x50 ), FCML_MI( 0x66, 0xff, 0xf0 ) );
    FCML_I32_D( "push eax", 0x67, 0x50 );
    FCML_I64_M( "push rax", 2, FCML_MI( 0x50 ), FCML_MI( 0xff, 0xf0 ) );
    FCML_I64_M( "push ax", 2, FCML_MI( 0x66, 0x50 ), FCML_MI( 0x66, 0xff, 0xf0 ) );
    FCML_I64_D( "push rax", 0x67, 0x50 );
    FCML_I64_D( "push rax", 0x48, 0x50 );

    FCML_A64_M( "push %rax", 2, FCML_MI( 0x50 ), FCML_MI( 0xff, 0xf0 ) );
    FCML_A64_M( "push %ax", 2, FCML_MI( 0x66, 0x50 ), FCML_MI( 0x66, 0xff, 0xf0 ) );
    FCML_A64_D( "push %rax", 0x67, 0x50 );
    FCML_A64_D( "push %rax", 0x48, 0x50 );

    FCML_I32_M( "push 0ffffffffh", 2, FCML_MI( 0x68, 0xff, 0xff, 0xff, 0xff ), FCML_MI( 0x6a, 0xff ) );
    FCML_I32_M( "push 00000020h", 2, FCML_MI( 0x68, 0x20, 0x00, 0x00, 0x00 ), FCML_MI( 0x6a, 0x20 ) );
    FCML_I32_M( "push 0ffffh", 2, FCML_MI( 0x66, 0x68, 0xff, 0xff ), FCML_MI( 0x66, 0x6a, 0xff ) );
    FCML_I32_M_A("push -080h", 2, FCML_MI(0x68, 0x80, 0xff, 0xff, 0xff), FCML_MI(0x6a, 0x80));
    FCML_I32( "push 50402020h", 0x68, 0x20, 0x20, 0x40, 0x50 );
    FCML_I32( "push 11ff20ffh", 0x68, 0xFF, 0x20, 0xFF, 0x11 );
    FCML_I64( "push 11ffh", 0x66, 0x68, 0xff, 0x11 );
    FCML_I64_A( "push 11ffh", 0x68, 0xff, 0x11, 0x00, 0x00 );
    FCML_I32( "push 11ffh", 0x66, 0x68, 0xff, 0x11 );
    FCML_I32_A( "push 11ffh", 0x68, 0xff, 0x11, 0x00, 0x00 );
    FCML_I64( "push 00000000221111ffh", 0x68, 0xFF, 0x11, 0x11, 0x22 );
    FCML_I64_D( "push 00000000221111ffh", 0x48, 0x68, 0xFF, 0x11, 0x11, 0x22 );
    FCML_I64( "push 00000000221111ffh", 0x68, 0xff, 0x11, 0x11, 0x22 );
    FCML_I64( "push 0ffffffffff1111ffh", 0x68, 0xFF, 0x11, 0x11, 0xFF );
    FCML_I64_D( "push 0ffffffffff1111ffh", 0x48, 0x68, 0xFF, 0x11, 0x11, 0xFF );
    FCML_I16( "push 11ffh", 0x68, 0xff, 0x11 );

    FCML_A64( "pushq $0xffffffffffffffff", 0x68, 0xff, 0xff, 0xff, 0xff );
    FCML_A64( "pushq $0x00000000221111ff", 0x68, 0xff, 0x11, 0x11, 0x22 );
    FCML_A32( "pushw $0x11ff", 0x66, 0x68, 0xff, 0x11 );
    FCML_A32( "pushl $0x000011ff", 0x68, 0xff, 0x11, 0x00, 0x00 );

    FCML_I32( "push cs", 0x0e );
    FCML_I32( "push ss", 0x16 );
    FCML_I32( "push ds", 0x1e );
    FCML_I32( "push es", 0x06 );
    FCML_I64_FAILED( "push cs", 0x0e );
    FCML_I64_FAILED( "push ss", 0x16 );
    FCML_I64_FAILED( "push ds", 0x1e );
    FCML_I64_FAILED( "push es", 0x06 );

    FCML_A32( "push %cs", 0x0e );
    FCML_A32( "push %ss", 0x16 );
    FCML_A32( "push %ds", 0x1e );
    FCML_A32( "push %es", 0x06 );

    FCML_I32( "push fs", 0x0f, 0xa0 );
    FCML_I32( "push gs", 0x0f, 0xa8 );
    FCML_I64( "push fs", 0x0f, 0xa0 );
    FCML_I64( "push gs", 0x0f, 0xa8 );

    FCML_A32( "pushw %fs", 0x66, 0x0f, 0xa0 );
    FCML_A32( "pushl %fs", 0x0f, 0xa0 );
    FCML_A32_A( "push %fs", 0x0f, 0xa0 );
    FCML_A64( "pushw %fs", 0x66, 0x0f, 0xa0 );
    FCML_A64( "pushq %fs", 0x0f, 0xa0 );
    FCML_A64_A( "push %fs", 0x0f, 0xa0 );
    FCML_A32( "pushw %gs", 0x66, 0x0f, 0xa8 );
    FCML_A32( "pushl %gs", 0x0f, 0xa8 );
    FCML_A32_A( "push %gs", 0x0f, 0xa8 );
    FCML_A64( "pushw %gs", 0x66, 0x0f, 0xa8 );
    FCML_A64( "pushq %gs", 0x0f, 0xa8 );
    FCML_A64_A( "push %gs", 0x0f, 0xa8 );
}

void fcml_tf_instruction_PUSHA(void) {

    FCML_I32( "pushad", 0x60 );
    FCML_I64_FAILED( "pushad", 0x60 );
    FCML_I32( "pusha", 0x66, 0x60 );

    FCML_A32( "pusha", 0x60 );
    FCML_A32( "pushaw", 0x66, 0x60 );
}

void fcml_tf_instruction_PUSHF(void) {

    FCML_I32( "pushf", 0x66, 0x9C );
    FCML_I64( "pushf", 0x66, 0x9C );

    FCML_I32( "pushfd", 0x9C );
    FCML_I64_FAILED( "pushfd", 0x9C );

    FCML_I64( "pushfq", 0x9C );

    FCML_A32( "pushfw", 0x66, 0x9c );
    FCML_A32( "pushf", 0x9c );
    FCML_A64( "pushfw", 0x66, 0x9c );
    FCML_A64( "pushfq", 0x9c );
}

void fcml_tf_instruction_PXOR(void) {

    FCML_I64( "pxor mm0,mmword ptr [rax]", 0x0F, 0xEF, 0x00 );
    FCML_I32( "pxor mm0,mm1", 0x0F, 0xEF, 0xC1 );

    FCML_I64( "pxor xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xEF, 0x00 );
    FCML_I32( "pxor xmm0,xmm1", 0x66, 0x0F, 0xEF, 0xC1 );

    FCML_I64( "vpxor xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xef, 0x00 );
    FCML_I32( "vpxor xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xef, 0xc1 );

    FCML_I64( "vpxor ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xef, 0x00 );
    FCML_I32( "vpxor ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xef, 0xc1 );

    FCML_A64( "pxor (%rax),%mm0", 0x0f, 0xef, 0x00 );
    FCML_A64( "pxor %mm1,%mm0", 0x0f, 0xef, 0xc1 );
    FCML_A64( "pxor (%rax),%xmm0", 0x66, 0x0f, 0xef, 0x00 );
    FCML_A64( "pxor %xmm1,%xmm0", 0x66, 0x0f, 0xef, 0xc1 );
    FCML_A64( "vpxor (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xef, 0x00 );
    FCML_A64( "vpxor %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xef, 0xc1 );
    FCML_A64( "vpxor (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xef, 0x00 );
    FCML_A64( "vpxor %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xef, 0xc1 );
}

void fcml_tf_instruction_VPXORD(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpxord (%rax),%xmm7,%xmm15", 0x62, 0x71, 0x45, 0x08, 0xef, 0x38);
    FCML_I64("vpxord xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x71, 0x45, 0x08, 0xef, 0x38);
    FCML_A32("vpxord (%eax),%xmm6,%xmm7", 0x62, 0xf1, 0x4d, 0x08, 0xef, 0x38);
    FCML_I32("vpxord xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf1, 0x4d, 0x08, 0xef, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpxord (%rax),%ymm7,%ymm15", 0x62, 0x71, 0x45, 0x28, 0xef, 0x38);
    FCML_I64("vpxord ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x71, 0x45, 0x28, 0xef, 0x38);
    FCML_A32("vpxord (%eax),%ymm5,%ymm7", 0x62, 0xf1, 0x55, 0x28, 0xef, 0x38);
    FCML_I32("vpxord ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf1, 0x55, 0x28, 0xef, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpxord (%rax),%zmm7,%zmm15", 0x62, 0x71, 0x45, 0x48, 0xef, 0x38);
    FCML_I64("vpxord zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0x45, 0x48, 0xef, 0x38);
    FCML_A32("vpxord (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x65, 0x48, 0xef, 0x38);
    FCML_I32("vpxord zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0x65, 0x48, 0xef, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpxord %xmm1,%xmm7,%xmm15", 0x62, 0x71, 0x45, 0x08, 0xef, 0xf9);
    FCML_I64("vpxord xmm15,xmm7,xmm1", 0x62, 0x71, 0x45, 0x08, 0xef, 0xf9);
    FCML_A32("vpxord %xmm1,%xmm2,%xmm7", 0x62, 0xf1, 0x6d, 0x08, 0xef, 0xf9);
    FCML_I32("vpxord xmm7,xmm2,xmm1", 0x62, 0xf1, 0x6d, 0x08, 0xef, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpxord %ymm6,%ymm7,%ymm14", 0x62, 0x71, 0x45, 0x28, 0xef, 0xf6);
    FCML_I64("vpxord ymm14,ymm7,ymm6", 0x62, 0x71, 0x45, 0x28, 0xef, 0xf6);
    FCML_A32("vpxord %ymm5,%ymm3,%ymm6", 0x62, 0xf1, 0x65, 0x28, 0xef, 0xf5);
    FCML_I32("vpxord ymm6,ymm3,ymm5", 0x62, 0xf1, 0x65, 0x28, 0xef, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpxord %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x05, 0x48, 0xef, 0xf4);
    FCML_I64("vpxord zmm6,zmm15,zmm4", 0x62, 0xf1, 0x05, 0x48, 0xef, 0xf4);
    FCML_A32("vpxord %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4d, 0x48, 0xef, 0xf4);
    FCML_I32("vpxord zmm6,zmm6,zmm4", 0x62, 0xf1, 0x4d, 0x48, 0xef, 0xf4);
    /* disp8 */
    FCML_I32("vpxord zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xef, 0x4c, 0x24, 0x08);
    FCML_A32("vpxord 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xef, 0x4c, 0x24, 0x08);
    FCML_I64("vpxord zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0x6d, 0x48, 0xef, 0x4c, 0x24, 0x08);
    FCML_A64("vpxord 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x48, 0xef, 0x4c, 0x24, 0x08);
    FCML_I32("vpxord ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf1, 0x6d, 0x28, 0xef, 0x4c, 0x24, 0x08);
    FCML_A32("vpxord 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf1, 0x6d, 0x28, 0xef, 0x4c, 0x24, 0x08);
    FCML_I64("vpxord ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf1, 0x6d, 0x28, 0xef, 0x4c, 0x24, 0x08);
    FCML_A64("vpxord 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf1, 0x6d, 0x28, 0xef, 0x4c, 0x24, 0x08);
    FCML_I32("vpxord xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf1, 0x6d, 0x08, 0xef, 0x4c, 0x24, 0x08);
    FCML_A32("vpxord 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf1, 0x6d, 0x08, 0xef, 0x4c, 0x24, 0x08);
    FCML_I64("vpxord xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf1, 0x6d, 0x08, 0xef, 0x4c, 0x24, 0x08);
    FCML_A64("vpxord 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf1, 0x6d, 0x08, 0xef, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpxord (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0x8c, 0xef, 0x14, 0x01);
    FCML_I64("vpxord xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x8c, 0xef, 0x14, 0x01);
    FCML_A32("vpxord (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0x8d, 0xef, 0x14, 0x01);
    FCML_I32("vpxord xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x8d, 0xef, 0x14, 0x01);
    FCML_A64("vpxord (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xac, 0xef, 0x14, 0x01);
    FCML_I64("vpxord ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xac, 0xef, 0x14, 0x01);
    FCML_A32("vpxord (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xad, 0xef, 0x14, 0x01);
    FCML_I32("vpxord ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xad, 0xef, 0x14, 0x01);
    FCML_A64("vpxord (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0d, 0xcc, 0xef, 0x14, 0x01);
    FCML_I64("vpxord zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0xcc, 0xef, 0x14, 0x01);
    FCML_A32("vpxord (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x45, 0xcd, 0xef, 0x14, 0x01);
    FCML_I32("vpxord zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0xcd, 0xef, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpxord (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0d, 0x0c, 0xef, 0x14, 0x01);
    FCML_I64("vpxord xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x0c, 0xef, 0x14, 0x01);
    FCML_A32("vpxord (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x45, 0x0d, 0xef, 0x14, 0x01);
    FCML_I32("vpxord xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x0d, 0xef, 0x14, 0x01);
    FCML_A64("vpxord (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0d, 0x2c, 0xef, 0x14, 0x01);
    FCML_I64("vpxord ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x2c, 0xef, 0x14, 0x01);
    FCML_A32("vpxord (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x45, 0x2d, 0xef, 0x14, 0x01);
    FCML_I32("vpxord ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x2d, 0xef, 0x14, 0x01);
    FCML_A64("vpxord (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0d, 0x4c, 0xef, 0x14, 0x01);
    FCML_I64("vpxord zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x0d, 0x4c, 0xef, 0x14, 0x01);
    FCML_A32("vpxord (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x45, 0x4d, 0xef, 0x14, 0x01);
    FCML_I32("vpxord zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0x45, 0x4d, 0xef, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpxord zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x61, 0x55, 0x50, 0xef, 0x3e);
    FCML_A64("vpxord (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x61, 0x55, 0x50, 0xef, 0x3e);
    FCML_I64("vpxord ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x55, 0x30, 0xef, 0x3e);
    FCML_A64("vpxord (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x61, 0x55, 0x30, 0xef, 0x3e);
    FCML_I64("vpxord xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x61, 0x55, 0x10, 0xef, 0x3e);
    FCML_A64("vpxord (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x61, 0x55, 0x10, 0xef, 0x3e);
    FCML_A32("vpxord (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0xef, 0x0e);
    FCML_I32("vpxord zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0xef, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpxord (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0x55, 0xb7, 0xef, 0x3e);
    FCML_I64("vpxord ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x55, 0xb7, 0xef, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpxord zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0xef, 0x4c, 0x24, 0x08);
    FCML_A32("vpxord 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0xef, 0x4c, 0x24, 0x08);
    FCML_I64("vpxord zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf1, 0x6d, 0x58, 0xef, 0x4c, 0x24, 0x08);
    FCML_A64("vpxord 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6d, 0x58, 0xef, 0x4c, 0x24, 0x08);
    FCML_I32("vpxord ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf1, 0x6d, 0x38, 0xef, 0x4c, 0x24, 0x08);
    FCML_A32("vpxord 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf1, 0x6d, 0x38, 0xef, 0x4c, 0x24, 0x08);
    FCML_I64("vpxord ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf1, 0x6d, 0x38, 0xef, 0x4c, 0x24, 0x08);
    FCML_A64("vpxord 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf1, 0x6d, 0x38, 0xef, 0x4c, 0x24, 0x08);
    FCML_I32("vpxord xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf1, 0x6d, 0x18, 0xef, 0x4c, 0x24, 0x08);
    FCML_A32("vpxord 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf1, 0x6d, 0x18, 0xef, 0x4c, 0x24, 0x08);
    FCML_I64("vpxord xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf1, 0x6d, 0x18, 0xef, 0x4c, 0x24, 0x08);
    FCML_A64("vpxord 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf1, 0x6d, 0x18, 0xef, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPXORQ(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpxorq (%rax),%xmm7,%xmm15", 0x62, 0x71, 0xc5, 0x08, 0xef, 0x38);
    FCML_I64("vpxorq xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x71, 0xc5, 0x08, 0xef, 0x38);
    FCML_A32("vpxorq (%eax),%xmm6,%xmm7", 0x62, 0xf1, 0xcd, 0x08, 0xef, 0x38);
    FCML_I32("vpxorq xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf1, 0xcd, 0x08, 0xef, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpxorq (%rax),%ymm7,%ymm15", 0x62, 0x71, 0xc5, 0x28, 0xef, 0x38);
    FCML_I64("vpxorq ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x71, 0xc5, 0x28, 0xef, 0x38);
    FCML_A32("vpxorq (%eax),%ymm5,%ymm7", 0x62, 0xf1, 0xd5, 0x28, 0xef, 0x38);
    FCML_I32("vpxorq ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf1, 0xd5, 0x28, 0xef, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpxorq (%rax),%zmm7,%zmm15", 0x62, 0x71, 0xc5, 0x48, 0xef, 0x38);
    FCML_I64("vpxorq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x71, 0xc5, 0x48, 0xef, 0x38);
    FCML_A32("vpxorq (%eax),%zmm3,%zmm7", 0x62, 0xf1, 0xe5, 0x48, 0xef, 0x38);
    FCML_I32("vpxorq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf1, 0xe5, 0x48, 0xef, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpxorq %xmm1,%xmm7,%xmm15", 0x62, 0x71, 0xc5, 0x08, 0xef, 0xf9);
    FCML_I64("vpxorq xmm15,xmm7,xmm1", 0x62, 0x71, 0xc5, 0x08, 0xef, 0xf9);
    FCML_A32("vpxorq %xmm1,%xmm2,%xmm7", 0x62, 0xf1, 0xed, 0x08, 0xef, 0xf9);
    FCML_I32("vpxorq xmm7,xmm2,xmm1", 0x62, 0xf1, 0xed, 0x08, 0xef, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpxorq %ymm6,%ymm7,%ymm14", 0x62, 0x71, 0xc5, 0x28, 0xef, 0xf6);
    FCML_I64("vpxorq ymm14,ymm7,ymm6", 0x62, 0x71, 0xc5, 0x28, 0xef, 0xf6);
    FCML_A32("vpxorq %ymm5,%ymm3,%ymm6", 0x62, 0xf1, 0xe5, 0x28, 0xef, 0xf5);
    FCML_I32("vpxorq ymm6,ymm3,ymm5", 0x62, 0xf1, 0xe5, 0x28, 0xef, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpxorq %zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x85, 0x48, 0xef, 0xf4);
    FCML_I64("vpxorq zmm6,zmm15,zmm4", 0x62, 0xf1, 0x85, 0x48, 0xef, 0xf4);
    FCML_A32("vpxorq %zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0xcd, 0x48, 0xef, 0xf4);
    FCML_I32("vpxorq zmm6,zmm6,zmm4", 0x62, 0xf1, 0xcd, 0x48, 0xef, 0xf4);
    /* disp8 */
    FCML_I32("vpxorq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf1, 0xed, 0x48, 0xef, 0x4c, 0x24, 0x08);
    FCML_A32("vpxorq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x48, 0xef, 0x4c, 0x24, 0x08);
    FCML_I64("vpxorq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf1, 0xed, 0x48, 0xef, 0x4c, 0x24, 0x08);
    FCML_A64("vpxorq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x48, 0xef, 0x4c, 0x24, 0x08);
    FCML_I32("vpxorq ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf1, 0xed, 0x28, 0xef, 0x4c, 0x24, 0x08);
    FCML_A32("vpxorq 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x28, 0xef, 0x4c, 0x24, 0x08);
    FCML_I64("vpxorq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf1, 0xed, 0x28, 0xef, 0x4c, 0x24, 0x08);
    FCML_A64("vpxorq 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x28, 0xef, 0x4c, 0x24, 0x08);
    FCML_I32("vpxorq xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf1, 0xed, 0x08, 0xef, 0x4c, 0x24, 0x08);
    FCML_A32("vpxorq 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x08, 0xef, 0x4c, 0x24, 0x08);
    FCML_I64("vpxorq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf1, 0xed, 0x08, 0xef, 0x4c, 0x24, 0x08);
    FCML_A64("vpxorq 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x08, 0xef, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpxorq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x8d, 0x8c, 0xef, 0x14, 0x01);
    FCML_I64("vpxorq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x8c, 0xef, 0x14, 0x01);
    FCML_A32("vpxorq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0x8d, 0xef, 0x14, 0x01);
    FCML_I32("vpxorq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x8d, 0xef, 0x14, 0x01);
    FCML_A64("vpxorq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x8d, 0xac, 0xef, 0x14, 0x01);
    FCML_I64("vpxorq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0xac, 0xef, 0x14, 0x01);
    FCML_A32("vpxorq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0xad, 0xef, 0x14, 0x01);
    FCML_I32("vpxorq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0xad, 0xef, 0x14, 0x01);
    FCML_A64("vpxorq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x8d, 0xcc, 0xef, 0x14, 0x01);
    FCML_I64("vpxorq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0xcc, 0xef, 0x14, 0x01);
    FCML_A32("vpxorq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0xc5, 0xcd, 0xef, 0x14, 0x01);
    FCML_I32("vpxorq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0xcd, 0xef, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpxorq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x8d, 0x0c, 0xef, 0x14, 0x01);
    FCML_I64("vpxorq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x0c, 0xef, 0x14, 0x01);
    FCML_A32("vpxorq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0xc5, 0x0d, 0xef, 0x14, 0x01);
    FCML_I32("vpxorq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x0d, 0xef, 0x14, 0x01);
    FCML_A64("vpxorq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x8d, 0x2c, 0xef, 0x14, 0x01);
    FCML_I64("vpxorq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x2c, 0xef, 0x14, 0x01);
    FCML_A32("vpxorq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0xc5, 0x2d, 0xef, 0x14, 0x01);
    FCML_I32("vpxorq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x2d, 0xef, 0x14, 0x01);
    FCML_A64("vpxorq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x8d, 0x4c, 0xef, 0x14, 0x01);
    FCML_I64("vpxorq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x4c, 0xef, 0x14, 0x01);
    FCML_A32("vpxorq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0xc5, 0x4d, 0xef, 0x14, 0x01);
    FCML_I32("vpxorq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf1, 0xc5, 0x4d, 0xef, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpxorq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xd5, 0x50, 0xef, 0x3e);
    FCML_A64("vpxorq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x61, 0xd5, 0x50, 0xef, 0x3e);
    FCML_I64("vpxorq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xd5, 0x30, 0xef, 0x3e);
    FCML_A64("vpxorq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x61, 0xd5, 0x30, 0xef, 0x3e);
    FCML_I64("vpxorq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x61, 0xd5, 0x10, 0xef, 0x3e);
    FCML_A64("vpxorq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x61, 0xd5, 0x10, 0xef, 0x3e);
    FCML_A32("vpxorq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0xef, 0x0e);
    FCML_I32("vpxorq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0xef, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpxorq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0xd5, 0xb7, 0xef, 0x3e);
    FCML_I64("vpxorq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xd5, 0xb7, 0xef, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpxorq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0xef, 0x4c, 0x24, 0x08);
    FCML_A32("vpxorq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0xef, 0x4c, 0x24, 0x08);
    FCML_I64("vpxorq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf1, 0xed, 0x58, 0xef, 0x4c, 0x24, 0x08);
    FCML_A64("vpxorq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf1, 0xed, 0x58, 0xef, 0x4c, 0x24, 0x08);
    FCML_I32("vpxorq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf1, 0xed, 0x38, 0xef, 0x4c, 0x24, 0x08);
    FCML_A32("vpxorq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x38, 0xef, 0x4c, 0x24, 0x08);
    FCML_I64("vpxorq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf1, 0xed, 0x38, 0xef, 0x4c, 0x24, 0x08);
    FCML_A64("vpxorq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf1, 0xed, 0x38, 0xef, 0x4c, 0x24, 0x08);
    FCML_I32("vpxorq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf1, 0xed, 0x18, 0xef, 0x4c, 0x24, 0x08);
    FCML_A32("vpxorq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x18, 0xef, 0x4c, 0x24, 0x08);
    FCML_I64("vpxorq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf1, 0xed, 0x18, 0xef, 0x4c, 0x24, 0x08);
    FCML_A64("vpxorq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf1, 0xed, 0x18, 0xef, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_PAVGUSB(void) {

    FCML_I32( "pavgusb mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xBF );
    FCML_I64( "pavgusb mm0,mm1", 0x0F, 0x0F, 0xC1, 0xBF );

    FCML_A64( "pavgusb (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xbf );
    FCML_A64( "pavgusb %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xbf );
}

void fcml_tf_instruction_PF2ID(void) {

    FCML_I32( "pf2id mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x1D );
    FCML_I64( "pf2id mm0,mm1", 0x0F, 0x0F, 0xC1, 0x1D );

    FCML_A64( "pf2id (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x1d );
    FCML_A64( "pf2id %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x1d );
}

void fcml_tf_instruction_PFACC(void) {

    FCML_I32( "pfacc mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xAE );
    FCML_I64( "pfacc mm0,mm1", 0x0F, 0x0F, 0xC1, 0xAE );

    FCML_A64( "pfacc (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xae );
    FCML_A64( "pfacc %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xae );
}

void fcml_tf_instruction_PFADD(void) {

    FCML_I32( "pfadd mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x9E );
    FCML_I64( "pfadd mm0,mm1", 0x0F, 0x0F, 0xC1, 0x9E );

    FCML_A64( "pfadd (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x9e );
    FCML_A64( "pfadd %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x9e );
}

void fcml_tf_instruction_PFCMPEQ(void) {

    FCML_I32( "pfcmpeq mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xB0 );
    FCML_I64( "pfcmpeq mm0,mm1", 0x0F, 0x0F, 0xC1, 0xB0 );

    FCML_A64( "pfcmpeq (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xb0 );
    FCML_A64( "pfcmpeq %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xb0 );
}

void fcml_tf_instruction_PFCMPGE(void) {

    FCML_I32( "pfcmpge mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x90 );
    FCML_I64( "pfcmpge mm0,mm1", 0x0F, 0x0F, 0xC1, 0x90 );

    FCML_A64( "pfcmpeq (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xb0 );
    FCML_A64( "pfcmpeq %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xb0 );
}

void fcml_tf_instruction_PFCMPGT(void) {

    FCML_I32( "pfcmpgt mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xA0 );
    FCML_I64( "pfcmpgt mm0,mm1", 0x0F, 0x0F, 0xC1, 0xA0 );

    FCML_A64( "pfcmpgt (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xa0 );
    FCML_A64( "pfcmpgt %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xa0 );
}

void fcml_tf_instruction_PFMAX(void) {

    FCML_I32( "pfmax mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xA4 );
    FCML_I64( "pfmax mm0,mm1", 0x0F, 0x0F, 0xC1, 0xA4 );

    FCML_A64( "pfmax (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xa4 );
    FCML_A64( "pfmax %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xa4 );
}

void fcml_tf_instruction_PFMIN(void) {

    FCML_I32( "pfmin mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x94 );
    FCML_I64( "pfmin mm0,mm1", 0x0F, 0x0F, 0xC1, 0x94 );

    FCML_A64( "pfmin (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x94 );
    FCML_A64( "pfmin %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x94 );
}

void fcml_tf_instruction_PFMUL(void) {

    FCML_I32( "pfmul mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xB4 );
    FCML_I64( "pfmul mm0,mm1", 0x0F, 0x0F, 0xC1, 0xB4 );

    FCML_A64( "pfmul (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xb4 );
    FCML_A64( "pfmul %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xb4 );
}

void fcml_tf_instruction_PFRCP(void) {

    FCML_I32( "pfrcp mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x96 );
    FCML_I64( "pfrcp mm0,mm1", 0x0F, 0x0F, 0xC1, 0x96 );

    FCML_A64( "pfrcp (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x96 );
    FCML_A64( "pfrcp %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x96 );
}

void fcml_tf_instruction_PFRCPIT1(void) {

    FCML_I32( "pfrcpit1 mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xA6 );
    FCML_I64( "pfrcpit1 mm0,mm1", 0x0F, 0x0F, 0xC1, 0xA6 );

    FCML_I32( "pfrcpit1 mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xA6 );
    FCML_I64( "pfrcpit1 mm0,mm1", 0x0F, 0x0F, 0xC1, 0xA6 );
}

void fcml_tf_instruction_PFRCPIT2(void) {

    FCML_I32( "pfrcpit2 mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xB6 );
    FCML_I64( "pfrcpit2 mm0,mm1", 0x0F, 0x0F, 0xC1, 0xB6 );

    FCML_A64( "pfrcpit2 (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xb6 );
    FCML_A64( "pfrcpit2 %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xb6 );
}

void fcml_tf_instruction_PFRSQIT1(void) {

    FCML_I32( "pfrsqit1 mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xA7 );
    FCML_I64( "pfrsqit1 mm0,mm1", 0x0F, 0x0F, 0xC1, 0xA7 );

    FCML_A64( "pfrsqit1 (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xa7 );
    FCML_A64( "pfrsqit1 %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xa7 );
}

void fcml_tf_instruction_PFRSQRT(void) {

    FCML_I32( "pfrsqrt mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x97 );
    FCML_I64( "pfrsqrt mm0,mm1", 0x0F, 0x0F, 0xC1, 0x97 );
}

void fcml_tf_instruction_PFSUB(void) {

    FCML_I32( "pfsub mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x9A );
    FCML_I64( "pfsub mm0,mm1", 0x0F, 0x0F, 0xC1, 0x9A );

    FCML_A64( "pfsub (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x9a );
    FCML_A64( "pfsub %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x9a );
}

void fcml_tf_instruction_PFSUBR(void) {

    FCML_I32( "pfsubr mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xAA );
    FCML_I64( "pfsubr mm0,mm1", 0x0F, 0x0F, 0xC1, 0xAA );

    FCML_A64( "pfsubr (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xaa );
    FCML_A64( "pfsubr %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xaa );
}

void fcml_tf_instruction_PI2FD(void) {

    FCML_I32( "pi2fd mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x0D );
    FCML_I64( "pi2fd mm0,mm1", 0x0F, 0x0F, 0xC1, 0x0D );

    FCML_A64( "pi2fd (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x0d );
    FCML_A64( "pi2fd %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x0d );
}

void fcml_tf_instruction_PMULHRW(void) {

    FCML_I32( "pmulhrw mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xB7 );
    FCML_I64( "pmulhrw mm0,mm1", 0x0F, 0x0F, 0xC1, 0xB7 );

    FCML_A64( "pmulhrw (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xb7 );
    FCML_A64( "pmulhrw %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xb7 );
}

void fcml_tf_instruction_PREFETCH(void) {

    FCML_I32( "prefetch byte ptr [eax]", 0x0F, 0x0D, 0x00 );
    FCML_I64( "prefetchw byte ptr [rax]", 0x0F, 0x0D, 0x08 );

    FCML_A64( "prefetch (%rax)", 0x0f, 0x0d, 0x00 );
    FCML_A64( "prefetchw (%rax)", 0x0f, 0x0d, 0x08 );
}

void fcml_tf_instruction_PREFETCHWT1(void) {
    FCML_I32("prefetchwt1 byte ptr [eax]", 0x0f, 0x0d, 0x10);
    FCML_I64("prefetchwt1 byte ptr [rax]", 0x0f, 0x0d, 0x10);
    FCML_A64("prefetchwt1 (%rax)", 0x0f, 0x0d, 0x10);
    FCML_A64("prefetchwt1 (%rax)", 0x0f, 0x0d, 0x10);
}

void fcml_tf_instruction_PF2IW(void) {

    FCML_I32( "pf2iw mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x1C );
    FCML_I64( "pf2iw mm0,mm1", 0x0F, 0x0F, 0xC1, 0x1C );

    FCML_A64( "pf2iw (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x1c );
    FCML_A64( "pf2iw %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x1c );
}

void fcml_tf_instruction_PFNACC(void) {

    FCML_I32( "pfnacc mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x8A );
    FCML_I64( "pfnacc mm0,mm1", 0x0F, 0x0F, 0xC1, 0x8A );

    FCML_A64( "pfnacc (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x8a );
    FCML_A64( "pfnacc %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x8a );
}

void fcml_tf_instruction_PFPNACC(void) {

    FCML_I32( "pfpnacc mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x8E );
    FCML_I64( "pfpnacc mm0,mm1", 0x0F, 0x0F, 0xC1, 0x8E );

    FCML_A64( "pfpnacc (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x8e );
    FCML_A64( "pfpnacc %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x8e );
}

void fcml_tf_instruction_PI2FW(void) {

    FCML_I32( "pi2fw mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x0C );
    FCML_I64( "pi2fw mm0,mm1", 0x0F, 0x0F, 0xC1, 0x0C );

    FCML_A64( "pi2fw (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x0c );
    FCML_A64( "pi2fw %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x0c );
}

void fcml_tf_instruction_PSWAPD(void) {

    FCML_I32( "pswapd mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xBB );
    FCML_I64( "pswapd mm0,mm1", 0x0F, 0x0F, 0xC1, 0xBB );

    FCML_A64( "pswapd (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xbb );
    FCML_A64( "pswapd %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xbb );
}

void fcml_tf_instruction_PDEP(void) {

    FCML_I32( "pdep eax,edi,dword ptr [eax]", 0xC4, 0xE2, 0x43, 0xF5, 0x00 );
    FCML_I32( "pdep eax,edi,eax", 0xC4, 0xE2, 0x43, 0xF5, 0xC0 );

    FCML_I64( "pdep rax,rdi,qword ptr [rax]", 0xC4, 0xE2, 0xC3, 0xF5, 0x00 );
    FCML_I64( "pdep rax,rdi,rax", 0xC4, 0xE2, 0xC3, 0xF5, 0xC0 );

    FCML_A64( "pdep (%rax),%edi,%eax", 0xc4, 0xe2, 0x43, 0xf5, 0x00 );
    FCML_A64( "pdep %eax,%edi,%eax", 0xc4, 0xe2, 0x43, 0xf5, 0xc0 );
    FCML_A64( "pdep (%rax),%rdi,%rax", 0xc4, 0xe2, 0xc3, 0xf5, 0x00 );
    FCML_A64( "pdep %rax,%rdi,%rax", 0xc4, 0xe2, 0xc3, 0xf5, 0xc0 );
}

void fcml_tf_instruction_PEXT(void) {

    FCML_I32( "pext eax,edi,dword ptr [eax]", 0xC4, 0xE2, 0x42, 0xF5, 0x00 );
    FCML_I32( "pext eax,edi,eax", 0xC4, 0xE2, 0x42, 0xF5, 0xC0 );

    FCML_I64( "pext rax,rdi,qword ptr [rax]", 0xC4, 0xE2, 0xC2, 0xF5, 0x00 );
    FCML_I64( "pext rax,rdi,rax", 0xC4, 0xE2, 0xC2, 0xF5, 0xC0 );

    FCML_A64( "pext (%rax),%edi,%eax", 0xc4, 0xe2, 0x42, 0xf5, 0x00 );
    FCML_A64( "pext %eax,%edi,%eax", 0xc4, 0xe2, 0x42, 0xf5, 0xc0 );
    FCML_A64( "pext (%rax),%rdi,%rax", 0xc4, 0xe2, 0xc2, 0xf5, 0x00 );
    FCML_A64( "pext %rax,%rdi,%rax", 0xc4, 0xe2, 0xc2, 0xf5, 0xc0 );
}

fcml_stf_test_case fctl_ti_instructions_p[] = {
    { "fcml_tf_instruction_PREFETCHWT1", fcml_tf_instruction_PREFETCHWT1 },
    { "fcml_tf_instruction_PABS", fcml_tf_instruction_PABS },
    { "fcml_tf_instruction_PACKSS", fcml_tf_instruction_PACKSS },
    { "fcml_tf_instruction_PACKUSD", fcml_tf_instruction_PACKUSD },
    { "fcml_tf_instruction_PACKUSW", fcml_tf_instruction_PACKUSW },
    { "fcml_tf_instruction_PADD", fcml_tf_instruction_PADD },
    { "fcml_tf_instruction_PADDS", fcml_tf_instruction_PADDS },
    { "fcml_tf_instruction_PADDUS", fcml_tf_instruction_PADDUS },
    { "fcml_tf_instruction_PADDQ", fcml_tf_instruction_PADDQ },
    { "fcml_tf_instruction_PALIGNR", fcml_tf_instruction_PALIGNR },
    { "fcml_tf_instruction_PAND", fcml_tf_instruction_PAND },
    { "fcml_tf_instruction_VPANDD", fcml_tf_instruction_VPANDD },
    { "fcml_tf_instruction_VPANDQ", fcml_tf_instruction_VPANDQ },
    { "fcml_tf_instruction_PANDN", fcml_tf_instruction_PANDN },
    { "fcml_tf_instruction_VPANDND", fcml_tf_instruction_VPANDND },
    { "fcml_tf_instruction_VPANDNQ", fcml_tf_instruction_VPANDNQ },
    { "fcml_tf_instruction_PAUSE", fcml_tf_instruction_PAUSE },
    { "fcml_tf_instruction_PAVGB", fcml_tf_instruction_PAVGB },
    { "fcml_tf_instruction_PBLENDVB", fcml_tf_instruction_PBLENDVB },
    { "fcml_tf_instruction_PBLENDW", fcml_tf_instruction_PBLENDW },
    { "fcml_tf_instruction_PCLMULQDQ", fcml_tf_instruction_PCLMULQDQ },
    { "fcml_tf_instruction_PCMPEQ", fcml_tf_instruction_PCMPEQ },
    { "fcml_tf_instruction_PCMPEQQ", fcml_tf_instruction_PCMPEQQ },
    { "fcml_tf_instruction_PCMPESTRI", fcml_tf_instruction_PCMPESTRI },
    { "fcml_tf_instruction_PCMPESTRM", fcml_tf_instruction_PCMPESTRM },
    { "fcml_tf_instruction_PCMPGT", fcml_tf_instruction_PCMPGT },
    { "fcml_tf_instruction_PCMPGTQ", fcml_tf_instruction_PCMPGTQ },
    { "fcml_tf_instruction_PCMPISTRI", fcml_tf_instruction_PCMPISTRI },
    { "fcml_tf_instruction_PCMPISTRM", fcml_tf_instruction_PCMPISTRM },
    { "fcml_tf_instruction_PEXTRB", fcml_tf_instruction_PEXTRB },
    { "fcml_tf_instruction_PEXTRW", fcml_tf_instruction_PEXTRW },
    { "fcml_tf_instruction_PHADDW", fcml_tf_instruction_PHADDW },
    { "fcml_tf_instruction_PHADDSW", fcml_tf_instruction_PHADDSW },
    { "fcml_tf_instruction_PHMINPOSUW", fcml_tf_instruction_PHMINPOSUW },
    { "fcml_tf_instruction_PHSUBW", fcml_tf_instruction_PHSUBW },
    { "fcml_tf_instruction_PHSUBSW", fcml_tf_instruction_PHSUBSW },
    { "fcml_tf_instruction_PINSR", fcml_tf_instruction_PINSR },
    { "fcml_tf_instruction_PINSRW", fcml_tf_instruction_PINSRW },
    { "fcml_tf_instruction_PMADDUBSW", fcml_tf_instruction_PMADDUBSW },
    { "fcml_tf_instruction_PMADDWD", fcml_tf_instruction_PMADDWD },
    { "fcml_tf_instruction_PMAXSB", fcml_tf_instruction_PMAXSB },
    { "fcml_tf_instruction_PMAXSW", fcml_tf_instruction_PMAXSW },
    { "fcml_tf_instruction_PMAXSD", fcml_tf_instruction_PMAXSD },
    { "fcml_tf_instruction_PMAXSQ", fcml_tf_instruction_PMAXSQ },
    { "fcml_tf_instruction_PMAXUB", fcml_tf_instruction_PMAXUB },
    { "fcml_tf_instruction_PMAXUW", fcml_tf_instruction_PMAXUW },
    { "fcml_tf_instruction_PMAXUD", fcml_tf_instruction_PMAXUD },
    { "fcml_tf_instruction_PMAXUQ", fcml_tf_instruction_PMAXUQ },
    { "fcml_tf_instruction_PMINSB", fcml_tf_instruction_PMINSB },
    { "fcml_tf_instruction_PMINSW", fcml_tf_instruction_PMINSW },
    { "fcml_tf_instruction_PMINSD", fcml_tf_instruction_PMINSD },
    { "fcml_tf_instruction_PMINSQ", fcml_tf_instruction_PMINSQ },
    { "fcml_tf_instruction_PMINUB", fcml_tf_instruction_PMINUB },
    { "fcml_tf_instruction_PMINUW", fcml_tf_instruction_PMINUW },
    { "fcml_tf_instruction_PMINUD", fcml_tf_instruction_PMINUD },
    { "fcml_tf_instruction_PMINUQ", fcml_tf_instruction_PMINUQ },
    { "fcml_tf_instruction_PMOVMSKB", fcml_tf_instruction_PMOVMSKB },
    { "fcml_tf_instruction_PMOVSX", fcml_tf_instruction_PMOVSX },
    { "fcml_tf_instruction_PMOVZX", fcml_tf_instruction_PMOVZX },
    { "fcml_tf_instruction_PMULDQ", fcml_tf_instruction_PMULDQ },
    { "fcml_tf_instruction_PMULHRSW", fcml_tf_instruction_PMULHRSW },
    { "fcml_tf_instruction_PMULHUW", fcml_tf_instruction_PMULHUW },
    { "fcml_tf_instruction_PMULHW", fcml_tf_instruction_PMULHW },
    { "fcml_tf_instruction_PMULUDQ", fcml_tf_instruction_PMULUDQ },
    { "fcml_tf_instruction_PMULLW", fcml_tf_instruction_PMULLW },
    { "fcml_tf_instruction_PMULLD", fcml_tf_instruction_PMULLD },
    { "fcml_tf_instruction_VPMULLQ", fcml_tf_instruction_VPMULLQ },
    { "fcml_tf_instruction_POP", fcml_tf_instruction_POP },
    { "fcml_tf_instruction_POPA", fcml_tf_instruction_POPA },
    { "fcml_tf_instruction_POPCNT", fcml_tf_instruction_POPCNT },
    { "fcml_tf_instruction_POPF", fcml_tf_instruction_POPF },
    { "fcml_tf_instruction_POR", fcml_tf_instruction_POR },
    { "fcml_tf_instruction_VPOR", fcml_tf_instruction_VPOR },
    { "fcml_tf_instruction_PREFETCHT", fcml_tf_instruction_PREFETCHT },
    { "fcml_tf_instruction_PSADBW", fcml_tf_instruction_PSADBW },
    { "fcml_tf_instruction_PSHUFB", fcml_tf_instruction_PSHUFB },
    { "fcml_tf_instruction_PSHUFD", fcml_tf_instruction_PSHUFD },
    { "fcml_tf_instruction_PSHUFHW", fcml_tf_instruction_PSHUFHW },
    { "fcml_tf_instruction_PSHUFLW", fcml_tf_instruction_PSHUFLW },
    { "fcml_tf_instruction_PSHUFW", fcml_tf_instruction_PSHUFW },
    { "fcml_tf_instruction_PSIGN", fcml_tf_instruction_PSIGN },
    { "fcml_tf_instruction_PSLLDQ", fcml_tf_instruction_PSLLDQ },
    { "fcml_tf_instruction_PSLL", fcml_tf_instruction_PSLL },
    { "fcml_tf_instruction_PSRA", fcml_tf_instruction_PSRA },
    { "fcml_tf_instruction_PSRLDQ", fcml_tf_instruction_PSRLDQ },
    { "fcml_tf_instruction_PSRL", fcml_tf_instruction_PSRL },
    { "fcml_tf_instruction_PSUB", fcml_tf_instruction_PSUB },
    { "fcml_tf_instruction_PSUBQ", fcml_tf_instruction_PSUBQ },
    { "fcml_tf_instruction_PSUBS", fcml_tf_instruction_PSUBS },
    { "fcml_tf_instruction_PSUBUS", fcml_tf_instruction_PSUBUS },
    { "fcml_tf_instruction_PTEST", fcml_tf_instruction_PTEST },
    { "fcml_tf_instruction_PUNPCKLB", fcml_tf_instruction_PUNPCKLB },
    { "fcml_tf_instruction_PUNPCKHB", fcml_tf_instruction_PUNPCKHB },
    { "fcml_tf_instruction_PUSH", fcml_tf_instruction_PUSH },
    { "fcml_tf_instruction_PUSHA", fcml_tf_instruction_PUSHA },
    { "fcml_tf_instruction_PUSHF", fcml_tf_instruction_PUSHF },
    { "fcml_tf_instruction_PXOR", fcml_tf_instruction_PXOR },
    { "fcml_tf_instruction_VPXORD", fcml_tf_instruction_VPXORD },
    { "fcml_tf_instruction_VPXORQ", fcml_tf_instruction_VPXORQ },
    { "fcml_tf_instruction_PAVGUSB", fcml_tf_instruction_PAVGUSB },
    { "fcml_tf_instruction_PF2ID", fcml_tf_instruction_PF2ID },
    { "fcml_tf_instruction_PFACC", fcml_tf_instruction_PFACC },
    { "fcml_tf_instruction_PFADD", fcml_tf_instruction_PFADD },
    { "fcml_tf_instruction_PFCMPEQ", fcml_tf_instruction_PFCMPEQ },
    { "fcml_tf_instruction_PFCMPGE", fcml_tf_instruction_PFCMPGE },
    { "fcml_tf_instruction_PFCMPGT", fcml_tf_instruction_PFCMPGT },
    { "fcml_tf_instruction_PFMAX", fcml_tf_instruction_PFMAX },
    { "fcml_tf_instruction_PFMIN", fcml_tf_instruction_PFMIN },
    { "fcml_tf_instruction_PFMUL", fcml_tf_instruction_PFMUL },
    { "fcml_tf_instruction_PFRCP", fcml_tf_instruction_PFRCP },
    { "fcml_tf_instruction_PFRCPIT1", fcml_tf_instruction_PFRCPIT1 },
    { "fcml_tf_instruction_PFRCPIT2", fcml_tf_instruction_PFRCPIT2 },
    { "fcml_tf_instruction_PFRSQIT1", fcml_tf_instruction_PFRSQIT1 },
    { "fcml_tf_instruction_PFRSQRT", fcml_tf_instruction_PFRSQRT },
    { "fcml_tf_instruction_PFSUB", fcml_tf_instruction_PFSUB },
    { "fcml_tf_instruction_PFSUBR", fcml_tf_instruction_PFSUBR },
    { "fcml_tf_instruction_PI2FD", fcml_tf_instruction_PI2FD },
    { "fcml_tf_instruction_PMULHRW", fcml_tf_instruction_PMULHRW },
    { "fcml_tf_instruction_PREFETCH", fcml_tf_instruction_PREFETCH },
    { "fcml_tf_instruction_PF2IW", fcml_tf_instruction_PF2IW },
    { "fcml_tf_instruction_PFNACC", fcml_tf_instruction_PFNACC },
    { "fcml_tf_instruction_PFPNACC", fcml_tf_instruction_PFPNACC },
    { "fcml_tf_instruction_PI2FW", fcml_tf_instruction_PI2FW },
    { "fcml_tf_instruction_PSWAPD", fcml_tf_instruction_PSWAPD },
    { "fcml_tf_instruction_PDEP", fcml_tf_instruction_PDEP },
    { "fcml_tf_instruction_PEXT", fcml_tf_instruction_PEXT },
    FCML_STF_NULL_TEST
};

fcml_stf_test_suite fctl_si_instructions_p = {
    "suite-fctl_ti_instructions_p", fcml_tf_instructions_p_suite_init, fcml_tf_instructions_p_suite_cleanup, fctl_ti_instructions_p
};




