/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.Codec;

public class LZOCodec
extends BaseCodec
implements Codec {
    private static final int LZO_OVERRUN = -6;

    public byte[] compress(byte[] data, int x, int y, int[] dims, Object options) throws FormatException {
        throw new FormatException("LZO Compression not currently supported");
    }

    public byte[] decompress(byte[] src, Object options) throws FormatException {
        byte[] newdst;
        int t;
        int ip = 0;
        int op = 0;
        byte[] dst = new byte[src.length];
        if ((t = src[ip++] & 0xFF) > 17) {
            t -= 17;
            do {
                dst[op++] = src[ip++];
                if (op != dst.length) continue;
                newdst = new byte[dst.length * 2];
                System.arraycopy(dst, 0, newdst, 0, dst.length);
                dst = newdst;
            } while (--t > 0);
            if ((t = src[ip++] & 0xFF) < 16) {
                newdst = new byte[op];
                System.arraycopy(dst, 0, newdst, 0, op);
                return newdst;
            }
        }
        block1: while (true) {
            block28: {
                int mPos;
                block27: {
                    if (t >= 16) break block27;
                    if (t == 0) {
                        while (src[ip] == 0) {
                            t += 255;
                            ++ip;
                        }
                        t += 15 + (src[ip++] & 0xFF);
                    }
                    t += 3;
                    do {
                        dst[op++] = src[ip++];
                        if (op != dst.length) continue;
                        newdst = new byte[dst.length * 2];
                        System.arraycopy(dst, 0, newdst, 0, dst.length);
                        dst = newdst;
                    } while (--t > 0);
                    if ((t = src[ip++] & 0xFF) >= 16) break block27;
                    if ((mPos = op - 2049 - (t >> 2) - ((src[ip++] & 0xFF) << 2)) < 0) {
                        t = -6;
                        break;
                    }
                    t = 3;
                    do {
                        dst[op++] = dst[mPos++];
                        if (op != dst.length && mPos != dst.length) continue;
                        newdst = new byte[dst.length * 2];
                        System.arraycopy(dst, 0, newdst, 0, dst.length);
                        dst = newdst;
                    } while (--t > 0);
                    t = src[ip - 2] & 3;
                    if (t == 0) break block28;
                    do {
                        dst[op++] = src[ip++];
                        if (op != dst.length) continue;
                        newdst = new byte[dst.length * 2];
                        System.arraycopy(dst, 0, newdst, 0, dst.length);
                        dst = newdst;
                    } while (--t > 0);
                    t = src[ip++] & 0xFF;
                }
                while (true) {
                    if (t >= 64) {
                        mPos = op - 1 - (t >> 2 & 7) - ((src[ip++] & 0xFF) << 3);
                        t = (t >> 5) - 1;
                    } else if (t >= 32) {
                        if ((t &= 0x1F) == 0) {
                            while (src[ip] == 0) {
                                t += 255;
                                ++ip;
                            }
                            t += 31 + (src[ip++] & 0xFF);
                        }
                        mPos = op - 1 - ((src[ip++] & 0xFF) >> 2);
                        mPos -= (src[ip++] & 0xFF) << 6;
                    } else if (t >= 16) {
                        mPos = op - ((t & 8) << 11);
                        if ((t &= 7) == 0) {
                            while (src[ip] == 0) {
                                t += 255;
                                ++ip;
                            }
                            t += 7 + (src[ip++] & 0xFF);
                        }
                        mPos -= (src[ip++] & 0xFF) >> 2;
                        if ((mPos -= (src[ip++] & 0xFF) << 6) == op) break block1;
                        mPos -= 16384;
                    } else {
                        mPos = op - 1 - (t >> 2) - ((src[ip++] & 0xFF) << 2);
                        t = 0;
                    }
                    if (mPos < 0) {
                        t = -6;
                        break block1;
                    }
                    t += 2;
                    do {
                        dst[op++] = dst[mPos++];
                        if (op != dst.length && mPos != dst.length) continue;
                        newdst = new byte[dst.length * 2];
                        System.arraycopy(dst, 0, newdst, 0, dst.length);
                        dst = newdst;
                    } while (--t > 0);
                    t = src[ip - 2] & 3;
                    if (t == 0) break;
                    do {
                        dst[op++] = src[ip++];
                        if (op != dst.length) continue;
                        newdst = new byte[dst.length * 2];
                        System.arraycopy(dst, 0, newdst, 0, dst.length);
                        dst = newdst;
                    } while (--t > 0);
                    t = src[ip++] & 0xFF;
                }
            }
            t = src[ip++] & 0xFF;
        }
        newdst = new byte[op];
        System.arraycopy(dst, 0, newdst, 0, op);
        return newdst;
    }
}

