require "spec_helper"

describe "FC069" do
  context "with a cookbook with a metadata file that specifies a license generated by knife cookbook create" do
    metadata_file "license 'Apache 2.0'"
    it { is_expected.to violate_rule }
  end

  context "with a cookbook with a metadata file that specifies a license generated by chef generate cookbook" do
    metadata_file "license 'apache_2'"
    it { is_expected.to violate_rule }
  end

  context "with a cookbook with a metadata file that specifies a valid SPDX license" do
    metadata_file "license 'Apache-2.0'"
    it { is_expected.to_not violate_rule }
  end

  context "with a cookbook with a metadata file that specifies ChefDK's non-SPDX all rights reserved string" do
    metadata_file "license 'All Rights Reserved'"
    it { is_expected.to_not violate_rule }
  end

  context "with a cookbook with a metadata file that specifies ChefDK's non-SPDX all rights reserved string with a different casing" do
    metadata_file "license 'All rights reserved'"
    it { is_expected.to_not violate_rule }
  end

  context "with a cookbook with a metadata file that specifies a license with parens" do
    metadata_file "license('Apache-2.0')"
    it { is_expected.to_not violate_rule }
  end

  context "with a cookbook with a metadata file that does not specifiy a license" do
    metadata_file
    it { is_expected.to violate_rule }
  end
end
