/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.imports;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;

public class DontImportJavaLang
extends AbstractRule {
    private Set<Package> skipPackages = new HashSet<Package>(Arrays.asList(Package.getPackage("java.lang.ref"), Package.getPackage("java.lang.reflect"), Package.getPackage("java.lang.annotation"), Package.getPackage("java.lang.instrument"), Package.getPackage("java.lang.management"), Package.getPackage("java.lang.Thread")));
    private Package javaLangPackage = Package.getPackage("java.lang");

    public Object visit(ASTImportDeclaration node, Object data) {
        if (node.isStatic()) {
            return data;
        }
        if (node.getPackage() != null) {
            if (node.getPackage().equals(this.javaLangPackage) && !this.skipPackages.contains(node.getPackage())) {
                this.addViolation(data, node);
            }
        } else {
            String img = ((SimpleNode)node.jjtGetChild(0)).getImage();
            if (img.startsWith("java.lang")) {
                if (img.startsWith("java.lang.ref") || img.startsWith("java.lang.reflect") || img.startsWith("java.lang.annotation") || img.startsWith("java.lang.instrument") || img.startsWith("java.lang.management") || img.startsWith("java.lang.Thread.")) {
                    return data;
                }
                this.addViolation(data, node);
            }
        }
        return data;
    }
}

