import QtQuick 2.0
import Ubuntu.Components 0.1

Rectangle {
    id: linkBox

    color: mouseArea.hovered ? Qt.rgba(1,1,1,0.5) : Qt.rgba(1,1,1,0.25)

    // Ignore this setting here as flipping the switch  can break the layout
    // Also, the link thumbnails don't consume much bandwidth
    property bool showImage : linkPicture.length > 0//&& previewImagesSetting.value

    Image {
        id: thumbnail

        visible: status == Image.Ready && showImage
        source: showImage ? Qt.resolvedUrl(linkPicture) : ""
        asynchronous: true

        anchors {
            left: parent.left
            top: parent.top
            bottom: parent.bottom
        }

        width: visible ? parent.height : 0
        height: parent.height

        fillMode: Image.PreserveAspectCrop
    }

    Item {
        id: textContainer

        anchors {
            right: parent.right
            left: thumbnail.right
            top: parent.top
            bottom: parent.bottom

            margins: units.gu(1)
        }

        Label{
            id: linkCaption

            anchors {
                right: parent.right
                left: parent.left
                top: parent.top
            }

            text: linkName
            wrapMode: Text.WrapAtWordBoundaryOrAnywhere

            font.bold: true
        }

        Label {
            id: linkDesc

            anchors {
                right: parent.right
                left: parent.left
                top: linkCaption.bottom
                bottom: parent.bottom
            }

            text: linkDescription
            elide: Text.ElideRight
            wrapMode: Text.WrapAtWordBoundaryOrAnywhere
            textFormat: Text.StyledText
            onLinkActivated: Qt.openUrlExternally(link)
        }
    }

    MouseArea {
        anchors.fill: linkBox
        cursorShape: Qt.PointingHandCursor
        hoverEnabled: true

        enabled: linkBox.visible
        id: mouseArea

        onClicked: {
            if (linkUrl.length > 0)
            {
                Qt.openUrlExternally(linkUrl);
            }
        }
    }
}
