import QtQuick 2.0

// Generate some more info on the post
// All properties used here must be exposed by the parent
// This is usually done via the StreamModel of Friends
// TODO: this should be exposed by QML friends
QtObject {
    // Sometimes microblogging needs to be treated differently
    // Use this property in such a case so we can easily add new services
    property bool isMicroblogging: (service === "twitter") || (service === "identica")

    // Is there a link attached to this post?
    property bool isLinkPost : linkDescription !== ""

    // Is an image attached to this post?
    property bool isImagePost: !isLinkPost && (linkPicture !== "")

    // Does it have any content attached at all?
    property bool hasContent : isImagePost || isLinkPost
}
