import QtQuick 2.0
import Ubuntu.Components 0.1

Item {
    id: repeatIcon

    anchors {
        right: parent.right
        bottom: parent.bottom
        rightMargin: units.gu(2)
        bottomMargin: units.gu(1)
    }

    height: fromMe ? 0 : childrenRect.height

    // FIXME: Use features API instead
    visible: showDetails &&
             (service == "twitter" || service == "identica") && !fromMe && stream !== "private"

    Image {
        id: repeatIconImage
        width: units.gu(3)
        height: units.gu(3)
        source: "images/share.png"
        asynchronous: true
        visible: retweetSpinner.visble ? false : true
        MouseArea {
            anchors.fill: parent
            onClicked: {
                console.log ("Retweeting " + messageId + " from " + accountId);
                retweetSpinner.visible = true
                friends.retweetAsync(accountId, messageId);
            }
        }
        ActivityIndicator {
            id: retweetSpinner
            anchors.centerIn: parent
            //width: parent.width
            visible: false
            running: visible
        }
    }
}
