import QtQuick 2.0
import Ubuntu.Components 0.1

Column {
    property bool showDetails: false
    spacing: units.gu(1)

    SenderAndTimeItem {
    }

    Label {
        id: messageText
        anchors {
            right: parent.right
            left: parent.left
        }
        text: {
            // StyledText needs HTML-style newlines
            return message.replace("\n", "<br \>")
        }

        elide: Text.ElideRight
        visible: message.length > 0 && message != linkDescription
        wrapMode: Text.WrapAtWordBoundaryOrAnywhere
        textFormat: Text.StyledText
        linkColor: Theme.palette.normal.baseText
        onLinkActivated: Qt.openUrlExternally(link)
    }

    LocationItem {
    }

    FavoriteIcon {
        id: favorite
    }

    RepeatIcon {
        id: repeatIcon
    }
}
