#!/bin/sh

TARGET=$1
OUTPUTDIR=$2


CONFIG_H="$OUTPUTDIR/config.h"
LIBFILE="$OUTPUTDIR/FROTZ_LIBS"
echo "Checking..."

touch $CONFIG_H
exit 0

cat << EOF > $CONFIG_H
/*
 * This file is automatically generated by config.sh, which is run from
 * the Makefile found in the Frotz source distribution.
 *
 */

EOF
OSNAME=`uname`


#echo "#define __${OSNAME}__" >> $CONFIG_H


if [ $TARGET = "dumb" ] ; then
	echo "Ah, so you're building for the dumb interface..."
	echo "That greatly simplifies things."
	echo
	echo "/* Nothing more is needed to build for a dumb interface. */" >> $CONFIG_H
	exit 0
fi

echo "/* Make sure this is uncommented if you want to disable audio support. */" >> $CONFIG_H
echo "/* #define NO_SOUND */" >> $CONFIG_H
echo >> $CONFIG_H


if [ $OSNAME = "Linux" ] ; then
	echo "#define USE_NCURSES" >> $CONFIG_H
	echo >> $CONFIG_H
	echo "/* Comment this out to disable color support. */" >> $CONFIG_H
	echo "#define COLOR_SUPPORT" >> $CONFIG_H
	echo >> $CONFIG_H
	echo "/* Comment this out to disable OSS audio support. */" >> $CONFIG_H
        echo "#define OSS_SOUND" >> $CONFIG_H
	echo "-lncurses" > $LIBFILE
	exit 0
fi

if [ $OSNAME = "NetBSD" ] ; then
	RELEASE=`uname -r`
	VER="$OSNAME-$RELEASE"
	echo $VER

	echo "/* Uncomment this if you want to use ncurses instead of regular curses." >> $CONFIG_H
	case "$RELEASE" in
	1.6*|1.7*)
		echo "/* #define USE_NCURSES */" >> $CONFIG_H ;
		echo "Great!  You can use NetBSD's curses library."
		;;
	*)
		echo "#define USE_NCURSES" >> $CONFIG_H ;
		echo "Use of ncurses required" ;
		echo "Let's see where ncurses.h is hiding..." ;
		echo "  /usr/pkg/include/ncurses.h"
		echo "  /usr/local/include/ncurses.h"
		echo "  /usr/local/pkg/include/ncurses.h"

		if [ -r /usr/pkg/include/ncurses.h ] ; then
			NCURSES_HEADER=/usr/pkg/include/ncurses.h
		elif [ -r /usr/local/include/ncurses.h ] ; then
			NCURSES_HEADER=/usr/local/include/ncurses.h
		elif [ -r /usr/local/pkg/include/ncurses.h ] ; then
			NCURSES_HEADER=/usr/local/pkg/include/ncurses.h
		fi

		if [ -z $NCURSES_HEADER ] ; then
			echo
			echo "Sorry, couldn't find ncurses.h anywhere."
			echo "Frotz requires ncurses or curses from NetBSD 1.6 or greater."
			echo "Install ncurses and try again."
			echo
		else
			echo "/* Found $NCURSES_HEADER */" >> $CONFIG_H
			echo "  --Found $NCURSES_HEADER"
		fi
		;;
	esac

	echo >> $CONFIG_H
	echo "/* Comment this out to disable color support. */" >> $CONFIG_H
	echo "#define COLOR_SUPPORT" >> $CONFIG_H

	echo >> $CONFIG_H
	echo "/* Sound device file */" >> $CONFIG_H
	echo "#ifndef SOUND_DEV" >> $CONFIG_H
	echo "#define SOUND_DEV \"/dev/sound\"" >> $CONFIG_H
	echo "#endif" >> $CONFIG_H
	echo >> $CONFIG_H
	echo "/* Comment this out to disable OSS audio support. */" >> $CONFIG_H
	echo "#define OSS_SOUND" >> $CONFIG_H
	echo >> $CONFIG_H
	echo "#include <soundcard.h>" >> $CONFIG_H

	if [ $NCURSES_HEADER ] ; then
		echo "-lncurses -lossaudio" > $LIBFILE
	else
		echo "-lcurses -lossaudio" > $LIBFILE
	fi

	exit 0
fi	

# Untested

if [ $OSNAME = "FreeBSD" ] ; then
	RELEASE=`uname -r`
	VER="$OSNAME-$RELEASE"
	echo $VER

	echo "/* Uncomment this if you want to use ncurses instead of regular curses." >> $CONFIG_H
	case "$RELEASE" in
	*)
		echo "#define USE_NCURSES" >> $CONFIG_H ;
		echo "Use of ncurses required" ;
		echo "Let's see where ncurses.h is hiding..." ;
		echo "  /usr/include/ncurses.h"
		echo "  /usr/local/include/ncurses.h"

		if [ -r /usr/include/ncurses.h ] ; then
			NCURSES_HEADER=/usr/include/ncurses.h
		elif [ -r /usr/local/include/ncurses.h ] ; then
			NCURSES_HEADER=/usr/local/include/ncurses.h
		fi

		if [ -z $NCURSES_HEADER ] ; then
			echo
			echo "Sorry, couldn't find ncurses.h anywhere."
			echo "Frotz requires ncurses on this OS."
			echo "Install ncurses and try again."
			echo
			exit 1
		else
			echo "/* Found $NCURSES_HEADER */" >> $CONFIG_H
			echo "  --Found $NCURSES_HEADER"
		fi
		;;
	esac

	echo >> $CONFIG_H
	echo "/* Comment this out to disable color support. */" >> $CONFIG_H
	echo "#define COLOR_SUPPORT" >> $CONFIG_H

	echo >> $CONFIG_H
	echo "/* Sound device file */" >> $CONFIG_H
	echo "#ifndef SOUND_DEV" >> $CONFIG_H
	echo "#define SOUND_DEV /dev/dsp" >> $CONFIG_H
	echo "#endif" >> $CONFIG_H
	echo >> $CONFIG_H
	echo "/* Comment this out to disable OSS audio support. */" >> $CONFIG_H
	echo "#define OSS_SOUND" >> $CONFIG_H

	if [ $NCURSES_HEADER ] ; then
		echo "-lncurses -lossaudio" > $LIBFILE
	else
		echo "-lcurses -lossaudio" > $LIBFILE
	fi

	exit 0
fi


# Untested

if [ $OSNAME = "OpenBSD" ] ; then
	RELEASE=`uname -r`
	VER="$OSNAME-$RELEASE"
	echo $VER

	echo "/* Uncomment this if you want to use ncurses instead of regular curses." >> $CONFIG_H
	case "$RELEASE" in
	*)
		echo "#define USE_NCURSES" >> $CONFIG_H ;
		echo "Use of ncurses required" ;
		echo "Let's see where ncurses.h is hiding..." ;
		echo "  /usr/pkg/include/ncurses.h"
		echo "  /usr/local/include/ncurses.h"

		if [ -r /usr/include/ncurses.h ] ; then
			NCURSES_HEADER=/usr/pkg/include/ncurses.h
		elif [ -r /usr/local/include/ncurses.h ] ; then
			NCURSES_HEADER=/usr/local/include/ncurses.h
		fi

		if [ -z $NCURSES_HEADER ] ; then
			echo
			echo "Sorry, couldn't find ncurses.h anywhere."
			echo "Frotz requires ncurses on this OS."
			echo "Install ncurses and try again."
			echo
			exit 1
		else
			echo "/* Found $NCURSES_HEADER */" >> $CONFIG_H
			echo "  --Found $NCURSES_HEADER"
		fi
		;;
	esac

	echo >> $CONFIG_H
	echo "/* Comment this out to disable color support. */" >> $CONFIG_H
	echo "#define COLOR_SUPPORT" >> $CONFIG_H

	echo >> $CONFIG_H
	echo "/* Sound device file */" >> $CONFIG_H
	echo "#ifndef SOUND_DEV" >> $CONFIG_H
	echo "#define SOUND_DEV /dev/dsp" >> $CONFIG_H
	echo "#endif" >> $CONFIG_H
	echo >> $CONFIG_H
	echo "/* Comment this out to disable OSS audio support. */" >> $CONFIG_H
	echo "#define OSS_SOUND" >> $CONFIG_H

	if [ $NCURSES_HEADER ] ; then
		echo "-lncurses -lossaudio" > $LIBFILE
	else
		echo "-lcurses -lossaudio" > $LIBFILE
	fi

	exit 0
fi	


