/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.12
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace OSGeo.GDAL {

using System;
using System.Runtime.InteropServices;

public class Gdal {

  internal class GdalObject : IDisposable {
	public virtual void Dispose() {

    }
  }
  internal static GdalObject theGdalObject = new GdalObject();
  protected static object ThisOwn_true() { return null; }
  protected static object ThisOwn_false() { return theGdalObject; }

  public static void UseExceptions() {
    GdalPINVOKE.UseExceptions();
  }

  public static void DontUseExceptions() {
    GdalPINVOKE.DontUseExceptions();
  }


  internal static byte[] StringToUtf8Bytes(string str)
  {
    if (str == null)
      return null;

    int bytecount = System.Text.Encoding.UTF8.GetMaxByteCount(str.Length);
    byte[] bytes = new byte[bytecount + 1];
    System.Text.Encoding.UTF8.GetBytes(str, 0, str.Length, bytes, 0);
    return bytes;
  }

  internal static string Utf8BytesToString(IntPtr pNativeData)
  {
    if (pNativeData == IntPtr.Zero)
        return null;

    int length = Marshal.PtrToStringAnsi(pNativeData).Length;
    byte[] strbuf = new byte[length];
    Marshal.Copy(pNativeData, strbuf, 0, length);
    return System.Text.Encoding.UTF8.GetString(strbuf);
  }

  internal static void StringListDestroy(IntPtr buffer_ptr) {
    GdalPINVOKE.StringListDestroy(buffer_ptr);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

public delegate void GDALErrorHandlerDelegate(int eclass, int code, IntPtr msg);
public delegate int GDALProgressFuncDelegate(double Complete, IntPtr Message, IntPtr Data);

  public static int GCPsToGeoTransform(GCP[] pGCPs, double[] argout, int bApproxOK) {
    int ret = 0;
    if (pGCPs != null && pGCPs.Length > 0)
     {
         IntPtr cPtr = __AllocCArray_GDAL_GCP(pGCPs.Length);
         if (cPtr == IntPtr.Zero)
            throw new ApplicationException("Error allocating CArray with __AllocCArray_GDAL_GCP");

         try {
             for (int i=0; i < pGCPs.Length; i++)
                __WriteCArrayItem_GDAL_GCP(cPtr, i, pGCPs[i]);

             ret = GCPsToGeoTransform(pGCPs.Length, cPtr, argout, bApproxOK);
         }
         finally
         {
            __FreeCArray_GDAL_GCP(cPtr);
         }
     }
     return ret;
   }

 public static void FileFromMemBuffer(string utf8_path, byte[] bytes) {
     GCHandle handle = GCHandle.Alloc(bytes, GCHandleType.Pinned);
     try {
          FileFromMemBuffer(utf8_path, bytes.Length, handle.AddrOfPinnedObject());
     } finally {
        handle.Free();
     }
  }

  public static void Debug(string msg_class, string message) {
    GdalPINVOKE.Debug(msg_class, message);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static CPLErr SetErrorHandler(string pszCallbackName) {
    CPLErr ret = (CPLErr)GdalPINVOKE.SetErrorHandler(pszCallbackName);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static CPLErr PushErrorHandler(string pszCallbackName) {
    CPLErr ret = (CPLErr)GdalPINVOKE.PushErrorHandler__SWIG_0(pszCallbackName);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void Error(CPLErr msg_class, int err_code, string msg) {
    GdalPINVOKE.Error((int)msg_class, err_code, msg);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static string GOA2GetAuthorizationURL(string pszScope) {
    string ret = GdalPINVOKE.GOA2GetAuthorizationURL(pszScope);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static string GOA2GetRefreshToken(string pszAuthToken, string pszScope) {
    string ret = GdalPINVOKE.GOA2GetRefreshToken(pszAuthToken, pszScope);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static string GOA2GetAccessToken(string pszRefreshToken, string pszScope) {
    string ret = GdalPINVOKE.GOA2GetAccessToken(pszRefreshToken, pszScope);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void PushErrorHandler(Gdal.GDALErrorHandlerDelegate arg0) {
    GdalPINVOKE.PushErrorHandler__SWIG_1(arg0);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static void PopErrorHandler() {
    GdalPINVOKE.PopErrorHandler();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static void ErrorReset() {
    GdalPINVOKE.ErrorReset();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static string EscapeString(int len, string bin_string, int scheme) {
    string ret = GdalPINVOKE.EscapeString(len, bin_string, scheme);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int GetLastErrorNo() {
    int ret = GdalPINVOKE.GetLastErrorNo();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int GetLastErrorType() {
    int ret = GdalPINVOKE.GetLastErrorType();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static string GetLastErrorMsg() {
    string ret = GdalPINVOKE.GetLastErrorMsg();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int VSIGetLastErrorNo() {
    int ret = GdalPINVOKE.VSIGetLastErrorNo();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static string VSIGetLastErrorMsg() {
    string ret = GdalPINVOKE.VSIGetLastErrorMsg();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void PushFinderLocation(string utf8_path) {
    GdalPINVOKE.PushFinderLocation(Gdal.StringToUtf8Bytes(utf8_path));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static void PopFinderLocation() {
    GdalPINVOKE.PopFinderLocation();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static void FinderClean() {
    GdalPINVOKE.FinderClean();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static string FindFile(string pszClass, string utf8_path) {
    string ret = GdalPINVOKE.FindFile(pszClass, Gdal.StringToUtf8Bytes(utf8_path));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static string[] ReadDir(string utf8_path, int nMaxFiles) {
        /* %typemap(csout) char** CSL */
        IntPtr cPtr = GdalPINVOKE.ReadDir(Gdal.StringToUtf8Bytes(utf8_path), nMaxFiles);
        IntPtr objPtr;
        int count = 0;
        if (cPtr != IntPtr.Zero) {
            while (Marshal.ReadIntPtr(cPtr, count*IntPtr.Size) != IntPtr.Zero)
                ++count;
        }
        string[] ret = new string[count];
        if (count > 0) {
	        for(int cx = 0; cx < count; cx++) {
                objPtr = System.Runtime.InteropServices.Marshal.ReadIntPtr(cPtr, cx * System.Runtime.InteropServices.Marshal.SizeOf(typeof(IntPtr)));
                ret[cx]= (objPtr == IntPtr.Zero) ? null : System.Runtime.InteropServices.Marshal.PtrToStringAnsi(objPtr);
            }
        }
        if (cPtr != IntPtr.Zero)
            GdalPINVOKE.StringListDestroy(cPtr);
        
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
        return ret;
}

  public static string[] ReadDirRecursive(string utf8_path) {
        /* %typemap(csout) char** CSL */
        IntPtr cPtr = GdalPINVOKE.ReadDirRecursive(Gdal.StringToUtf8Bytes(utf8_path));
        IntPtr objPtr;
        int count = 0;
        if (cPtr != IntPtr.Zero) {
            while (Marshal.ReadIntPtr(cPtr, count*IntPtr.Size) != IntPtr.Zero)
                ++count;
        }
        string[] ret = new string[count];
        if (count > 0) {
	        for(int cx = 0; cx < count; cx++) {
                objPtr = System.Runtime.InteropServices.Marshal.ReadIntPtr(cPtr, cx * System.Runtime.InteropServices.Marshal.SizeOf(typeof(IntPtr)));
                ret[cx]= (objPtr == IntPtr.Zero) ? null : System.Runtime.InteropServices.Marshal.PtrToStringAnsi(objPtr);
            }
        }
        if (cPtr != IntPtr.Zero)
            GdalPINVOKE.StringListDestroy(cPtr);
        
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
        return ret;
}

  public static void SetConfigOption(string pszKey, string pszValue) {
    GdalPINVOKE.SetConfigOption(pszKey, pszValue);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static string GetConfigOption(string pszKey, string pszDefault) {
    string ret = GdalPINVOKE.GetConfigOption(pszKey, pszDefault);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static string CPLBinaryToHex(int nBytes, IntPtr pabyData) {
    string ret = GdalPINVOKE.CPLBinaryToHex(nBytes, pabyData);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static IntPtr CPLHexToBinary(string pszHex, out int pnBytes) {
      IntPtr ret = GdalPINVOKE.CPLHexToBinary(pszHex, out pnBytes);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
      return ret;
}

  public static void FileFromMemBuffer(string utf8_path, int nBytes, IntPtr pabyData) {
    GdalPINVOKE.FileFromMemBuffer(Gdal.StringToUtf8Bytes(utf8_path), nBytes, pabyData);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static int Unlink(string utf8_path) {
    int ret = GdalPINVOKE.Unlink(Gdal.StringToUtf8Bytes(utf8_path));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int HasThreadSupport() {
    int ret = GdalPINVOKE.HasThreadSupport();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int Mkdir(string utf8_path, int mode) {
    int ret = GdalPINVOKE.Mkdir(Gdal.StringToUtf8Bytes(utf8_path), mode);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int Rmdir(string utf8_path) {
    int ret = GdalPINVOKE.Rmdir(Gdal.StringToUtf8Bytes(utf8_path));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int Rename(string pszOld, string pszNew) {
    int ret = GdalPINVOKE.Rename(Gdal.StringToUtf8Bytes(pszOld), Gdal.StringToUtf8Bytes(pszNew));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static IntPtr VSIFOpenL(string utf8_path, string pszMode) {
      IntPtr ret = GdalPINVOKE.VSIFOpenL(Gdal.StringToUtf8Bytes(utf8_path), pszMode);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
      return ret;
}

  public static IntPtr VSIFOpenExL(string utf8_path, string pszMode, int bSetError) {
      IntPtr ret = GdalPINVOKE.VSIFOpenExL(Gdal.StringToUtf8Bytes(utf8_path), pszMode, bSetError);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
      return ret;
}

  public static int VSIFCloseL(IntPtr fp) {
    int ret = GdalPINVOKE.VSIFCloseL(fp);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int VSIFSeekL(IntPtr fp, int offset, int whence) {
    int ret = GdalPINVOKE.VSIFSeekL(fp, offset, whence);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int VSIFTellL(IntPtr fp) {
    int ret = GdalPINVOKE.VSIFTellL(fp);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int VSIFTruncateL(IntPtr fp, int length) {
    int ret = GdalPINVOKE.VSIFTruncateL(fp, length);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int VSIFWriteL(string arg0, int arg1, int arg2, IntPtr fp) {
    int ret = GdalPINVOKE.VSIFWriteL(arg0, arg1, arg2, fp);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void VSICurlClearCache() {
    GdalPINVOKE.VSICurlClearCache();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static string[] ParseCommandLine(string utf8_path) {
        /* %typemap(csout) char** CSL */
        IntPtr cPtr = GdalPINVOKE.ParseCommandLine(Gdal.StringToUtf8Bytes(utf8_path));
        IntPtr objPtr;
        int count = 0;
        if (cPtr != IntPtr.Zero) {
            while (Marshal.ReadIntPtr(cPtr, count*IntPtr.Size) != IntPtr.Zero)
                ++count;
        }
        string[] ret = new string[count];
        if (count > 0) {
	        for(int cx = 0; cx < count; cx++) {
                objPtr = System.Runtime.InteropServices.Marshal.ReadIntPtr(cPtr, cx * System.Runtime.InteropServices.Marshal.SizeOf(typeof(IntPtr)));
                ret[cx]= (objPtr == IntPtr.Zero) ? null : System.Runtime.InteropServices.Marshal.PtrToStringAnsi(objPtr);
            }
        }
        if (cPtr != IntPtr.Zero)
            GdalPINVOKE.StringListDestroy(cPtr);
        
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
        return ret;
}

  public static double GDAL_GCP_GCPX_get(GCP gcp) {
    double ret = GdalPINVOKE.GDAL_GCP_GCPX_get(GCP.getCPtr(gcp));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void GDAL_GCP_GCPX_set(GCP gcp, double dfGCPX) {
    GdalPINVOKE.GDAL_GCP_GCPX_set(GCP.getCPtr(gcp), dfGCPX);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static double GDAL_GCP_GCPY_get(GCP gcp) {
    double ret = GdalPINVOKE.GDAL_GCP_GCPY_get(GCP.getCPtr(gcp));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void GDAL_GCP_GCPY_set(GCP gcp, double dfGCPY) {
    GdalPINVOKE.GDAL_GCP_GCPY_set(GCP.getCPtr(gcp), dfGCPY);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static double GDAL_GCP_GCPZ_get(GCP gcp) {
    double ret = GdalPINVOKE.GDAL_GCP_GCPZ_get(GCP.getCPtr(gcp));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void GDAL_GCP_GCPZ_set(GCP gcp, double dfGCPZ) {
    GdalPINVOKE.GDAL_GCP_GCPZ_set(GCP.getCPtr(gcp), dfGCPZ);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static double GDAL_GCP_GCPPixel_get(GCP gcp) {
    double ret = GdalPINVOKE.GDAL_GCP_GCPPixel_get(GCP.getCPtr(gcp));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void GDAL_GCP_GCPPixel_set(GCP gcp, double dfGCPPixel) {
    GdalPINVOKE.GDAL_GCP_GCPPixel_set(GCP.getCPtr(gcp), dfGCPPixel);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static double GDAL_GCP_GCPLine_get(GCP gcp) {
    double ret = GdalPINVOKE.GDAL_GCP_GCPLine_get(GCP.getCPtr(gcp));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void GDAL_GCP_GCPLine_set(GCP gcp, double dfGCPLine) {
    GdalPINVOKE.GDAL_GCP_GCPLine_set(GCP.getCPtr(gcp), dfGCPLine);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static string GDAL_GCP_Info_get(GCP gcp) {
    string ret = GdalPINVOKE.GDAL_GCP_Info_get(GCP.getCPtr(gcp));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void GDAL_GCP_Info_set(GCP gcp, string pszInfo) {
    GdalPINVOKE.GDAL_GCP_Info_set(GCP.getCPtr(gcp), pszInfo);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static string GDAL_GCP_Id_get(GCP gcp) {
    string ret = GdalPINVOKE.GDAL_GCP_Id_get(GCP.getCPtr(gcp));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void GDAL_GCP_Id_set(GCP gcp, string pszId) {
    GdalPINVOKE.GDAL_GCP_Id_set(GCP.getCPtr(gcp), pszId);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static double GDAL_GCP_get_GCPX(GCP gcp) {
    double ret = GdalPINVOKE.GDAL_GCP_get_GCPX(GCP.getCPtr(gcp));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void GDAL_GCP_set_GCPX(GCP gcp, double dfGCPX) {
    GdalPINVOKE.GDAL_GCP_set_GCPX(GCP.getCPtr(gcp), dfGCPX);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static double GDAL_GCP_get_GCPY(GCP gcp) {
    double ret = GdalPINVOKE.GDAL_GCP_get_GCPY(GCP.getCPtr(gcp));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void GDAL_GCP_set_GCPY(GCP gcp, double dfGCPY) {
    GdalPINVOKE.GDAL_GCP_set_GCPY(GCP.getCPtr(gcp), dfGCPY);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static double GDAL_GCP_get_GCPZ(GCP gcp) {
    double ret = GdalPINVOKE.GDAL_GCP_get_GCPZ(GCP.getCPtr(gcp));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void GDAL_GCP_set_GCPZ(GCP gcp, double dfGCPZ) {
    GdalPINVOKE.GDAL_GCP_set_GCPZ(GCP.getCPtr(gcp), dfGCPZ);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static double GDAL_GCP_get_GCPPixel(GCP gcp) {
    double ret = GdalPINVOKE.GDAL_GCP_get_GCPPixel(GCP.getCPtr(gcp));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void GDAL_GCP_set_GCPPixel(GCP gcp, double dfGCPPixel) {
    GdalPINVOKE.GDAL_GCP_set_GCPPixel(GCP.getCPtr(gcp), dfGCPPixel);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static double GDAL_GCP_get_GCPLine(GCP gcp) {
    double ret = GdalPINVOKE.GDAL_GCP_get_GCPLine(GCP.getCPtr(gcp));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void GDAL_GCP_set_GCPLine(GCP gcp, double dfGCPLine) {
    GdalPINVOKE.GDAL_GCP_set_GCPLine(GCP.getCPtr(gcp), dfGCPLine);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static string GDAL_GCP_get_Info(GCP gcp) {
    string ret = GdalPINVOKE.GDAL_GCP_get_Info(GCP.getCPtr(gcp));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void GDAL_GCP_set_Info(GCP gcp, string pszInfo) {
    GdalPINVOKE.GDAL_GCP_set_Info(GCP.getCPtr(gcp), pszInfo);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static string GDAL_GCP_get_Id(GCP gcp) {
    string ret = GdalPINVOKE.GDAL_GCP_get_Id(GCP.getCPtr(gcp));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void GDAL_GCP_set_Id(GCP gcp, string pszId) {
    GdalPINVOKE.GDAL_GCP_set_Id(GCP.getCPtr(gcp), pszId);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  private static int GCPsToGeoTransform(int nGCPs, IntPtr pGCPs, double[] argout, int bApproxOK) {
    int res = GdalPINVOKE.GCPsToGeoTransform(nGCPs, pGCPs, argout, bApproxOK);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return res;
}

  public static int ComputeMedianCutPCT(Band red, Band green, Band blue, int num_colors, ColorTable colors, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.ComputeMedianCutPCT(Band.getCPtr(red), Band.getCPtr(green), Band.getCPtr(blue), num_colors, ColorTable.getCPtr(colors), callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int DitherRGB2PCT(Band red, Band green, Band blue, Band target, ColorTable colors, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.DitherRGB2PCT(Band.getCPtr(red), Band.getCPtr(green), Band.getCPtr(blue), Band.getCPtr(target), ColorTable.getCPtr(colors), callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static CPLErr ReprojectImage(Dataset src_ds, Dataset dst_ds, string src_wkt, string dst_wkt, ResampleAlg eResampleAlg, double WarpMemoryLimit, double maxerror, Gdal.GDALProgressFuncDelegate callback, string callback_data, string[] options) {
    CPLErr ret = (CPLErr)GdalPINVOKE.ReprojectImage(Dataset.getCPtr(src_ds), Dataset.getCPtr(dst_ds), src_wkt, dst_wkt, (int)eResampleAlg, WarpMemoryLimit, maxerror, callback, callback_data, (options != null)? new GdalPINVOKE.StringListMarshal(options)._ar : null);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int ComputeProximity(Band srcBand, Band proximityBand, string[] options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.ComputeProximity(Band.getCPtr(srcBand), Band.getCPtr(proximityBand), (options != null)? new GdalPINVOKE.StringListMarshal(options)._ar : null, callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int RasterizeLayer(Dataset dataset, int bands, int[] band_list, OSGeo.OGR.Layer layer, IntPtr pfnTransformer, IntPtr pTransformArg, int burn_values, double[] burn_values_list, string[] options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.RasterizeLayer(Dataset.getCPtr(dataset), bands, band_list, OSGeo.OGR.Layer.getCPtr(layer), pfnTransformer, pTransformArg, burn_values, burn_values_list, (options != null)? new GdalPINVOKE.StringListMarshal(options)._ar : null, callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int Polygonize(Band srcBand, Band maskBand, OSGeo.OGR.Layer outLayer, int iPixValField, string[] options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.Polygonize(Band.getCPtr(srcBand), Band.getCPtr(maskBand), OSGeo.OGR.Layer.getCPtr(outLayer), iPixValField, (options != null)? new GdalPINVOKE.StringListMarshal(options)._ar : null, callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int FPolygonize(Band srcBand, Band maskBand, OSGeo.OGR.Layer outLayer, int iPixValField, string[] options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.FPolygonize(Band.getCPtr(srcBand), Band.getCPtr(maskBand), OSGeo.OGR.Layer.getCPtr(outLayer), iPixValField, (options != null)? new GdalPINVOKE.StringListMarshal(options)._ar : null, callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int FillNodata(Band targetBand, Band maskBand, double maxSearchDist, int smoothingIterations, string[] options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.FillNodata(Band.getCPtr(targetBand), Band.getCPtr(maskBand), maxSearchDist, smoothingIterations, (options != null)? new GdalPINVOKE.StringListMarshal(options)._ar : null, callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int SieveFilter(Band srcBand, Band maskBand, Band dstBand, int threshold, int connectedness, string[] options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.SieveFilter(Band.getCPtr(srcBand), Band.getCPtr(maskBand), Band.getCPtr(dstBand), threshold, connectedness, (options != null)? new GdalPINVOKE.StringListMarshal(options)._ar : null, callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int RegenerateOverviews(Band srcBand, int overviewBandCount, SWIGTYPE_p_p_GDALRasterBandShadow overviewBands, string resampling, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.RegenerateOverviews(Band.getCPtr(srcBand), overviewBandCount, SWIGTYPE_p_p_GDALRasterBandShadow.getCPtr(overviewBands), resampling, callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int RegenerateOverview(Band srcBand, Band overviewBand, string resampling, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.RegenerateOverview(Band.getCPtr(srcBand), Band.getCPtr(overviewBand), resampling, callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int ContourGenerate(Band srcBand, double contourInterval, double contourBase, int fixedLevelCount, double[] fixedLevels, int useNoData, double noDataValue, OSGeo.OGR.Layer dstLayer, int idField, int elevField, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.ContourGenerate(Band.getCPtr(srcBand), contourInterval, contourBase, fixedLevelCount, fixedLevels, useNoData, noDataValue, OSGeo.OGR.Layer.getCPtr(dstLayer), idField, elevField, callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset AutoCreateWarpedVRT(Dataset src_ds, string src_wkt, string dst_wkt, ResampleAlg eResampleAlg, double maxerror) {
    IntPtr cPtr = GdalPINVOKE.AutoCreateWarpedVRT(Dataset.getCPtr(src_ds), src_wkt, dst_wkt, (int)eResampleAlg, maxerror);
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset CreatePansharpenedVRT(string pszXML, Band panchroBand, int nInputSpectralBands, SWIGTYPE_p_p_GDALRasterBandShadow ahInputSpectralBands) {
    IntPtr cPtr = GdalPINVOKE.CreatePansharpenedVRT(pszXML, Band.getCPtr(panchroBand), nInputSpectralBands, SWIGTYPE_p_p_GDALRasterBandShadow.getCPtr(ahInputSpectralBands));
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset ApplyVerticalShiftGrid(Dataset src_ds, Dataset grid_ds, bool inverse, double srcUnitToMeter, double dstUnitToMeter, string[] options) {
    IntPtr cPtr = GdalPINVOKE.ApplyVerticalShiftGrid(Dataset.getCPtr(src_ds), Dataset.getCPtr(grid_ds), inverse, srcUnitToMeter, dstUnitToMeter, (options != null)? new GdalPINVOKE.StringListMarshal(options)._ar : null);
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void ApplyGeoTransform(double[] padfGeoTransform, double dfPixel, double dfLine, out double pdfGeoX, out double pdfGeoY) {
    GdalPINVOKE.ApplyGeoTransform(padfGeoTransform, dfPixel, dfLine, out pdfGeoX, out pdfGeoY);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static int InvGeoTransform(double[] gt_in, double[] gt_out) {
    int res = GdalPINVOKE.InvGeoTransform(gt_in, gt_out);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return res;
}

  public static string VersionInfo(string request) {
    string ret = GdalPINVOKE.VersionInfo(request);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void AllRegister() {
    GdalPINVOKE.AllRegister();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static void GDALDestroyDriverManager() {
    GdalPINVOKE.GDALDestroyDriverManager();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static int GetCacheMax() {
    int ret = GdalPINVOKE.GetCacheMax();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int GetCacheUsed() {
    int ret = GdalPINVOKE.GetCacheUsed();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static void SetCacheMax(int nBytes) {
    GdalPINVOKE.SetCacheMax(nBytes);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static int GetDataTypeSize(DataType eDataType) {
    int ret = GdalPINVOKE.GetDataTypeSize((int)eDataType);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int DataTypeIsComplex(DataType eDataType) {
    int ret = GdalPINVOKE.DataTypeIsComplex((int)eDataType);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static string GetDataTypeName(DataType eDataType) {
    string ret = GdalPINVOKE.GetDataTypeName((int)eDataType);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static DataType GetDataTypeByName(string pszDataTypeName) {
    DataType ret = (DataType)GdalPINVOKE.GetDataTypeByName(pszDataTypeName);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static string GetColorInterpretationName(ColorInterp eColorInterp) {
    string ret = GdalPINVOKE.GetColorInterpretationName((int)eColorInterp);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static string GetPaletteInterpretationName(PaletteInterp ePaletteInterp) {
    string ret = GdalPINVOKE.GetPaletteInterpretationName((int)ePaletteInterp);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static string DecToDMS(double arg0, string arg1, int arg2) {
    string ret = GdalPINVOKE.DecToDMS(arg0, arg1, arg2);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static double PackedDMSToDec(double dfPacked) {
    double ret = GdalPINVOKE.PackedDMSToDec(dfPacked);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static double DecToPackedDMS(double dfDec) {
    double ret = GdalPINVOKE.DecToPackedDMS(dfDec);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static XMLNode ParseXMLString(string pszXMLString) {
    IntPtr cPtr = GdalPINVOKE.ParseXMLString(pszXMLString);
    XMLNode ret = (cPtr == IntPtr.Zero) ? null : new XMLNode(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static string SerializeXMLTree(XMLNode xmlnode) {
    string ret = GdalPINVOKE.SerializeXMLTree(XMLNode.getCPtr(xmlnode));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static string GetJPEG2000StructureAsString(string pszFilename, string[] options) {
    string ret = GdalPINVOKE.GetJPEG2000StructureAsString(pszFilename, (options != null)? new GdalPINVOKE.StringListMarshal(options)._ar : null);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int GetDriverCount() {
    int ret = GdalPINVOKE.GetDriverCount();
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Driver GetDriverByName(string name) {
    IntPtr cPtr = GdalPINVOKE.GetDriverByName(name);
    Driver ret = (cPtr == IntPtr.Zero) ? null : new Driver(cPtr, false, ThisOwn_false());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Driver GetDriver(int i) {
    IntPtr cPtr = GdalPINVOKE.GetDriver(i);
    Driver ret = (cPtr == IntPtr.Zero) ? null : new Driver(cPtr, false, ThisOwn_false());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset Open(string utf8_path, Access eAccess) {
    IntPtr cPtr = GdalPINVOKE.Open(Gdal.StringToUtf8Bytes(utf8_path), (int)eAccess);
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset OpenEx(string utf8_path, uint nOpenFlags, string[] allowed_drivers, string[] open_options, string[] sibling_files) {
    IntPtr cPtr = GdalPINVOKE.OpenEx(Gdal.StringToUtf8Bytes(utf8_path), nOpenFlags, (allowed_drivers != null)? new GdalPINVOKE.StringListMarshal(allowed_drivers)._ar : null, (open_options != null)? new GdalPINVOKE.StringListMarshal(open_options)._ar : null, (sibling_files != null)? new GdalPINVOKE.StringListMarshal(sibling_files)._ar : null);
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset OpenShared(string utf8_path, Access eAccess) {
    IntPtr cPtr = GdalPINVOKE.OpenShared(Gdal.StringToUtf8Bytes(utf8_path), (int)eAccess);
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Driver IdentifyDriver(string utf8_path, string[] papszSiblings) {
    IntPtr cPtr = GdalPINVOKE.IdentifyDriver(Gdal.StringToUtf8Bytes(utf8_path), (papszSiblings != null)? new GdalPINVOKE.StringListMarshal(papszSiblings)._ar : null);
    Driver ret = (cPtr == IntPtr.Zero) ? null : new Driver(cPtr, false, ThisOwn_false());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Driver IdentifyDriverEx(string utf8_path, uint nIdentifyFlags, string[] allowed_drivers, string[] sibling_files) {
    IntPtr cPtr = GdalPINVOKE.IdentifyDriverEx(Gdal.StringToUtf8Bytes(utf8_path), nIdentifyFlags, (allowed_drivers != null)? new GdalPINVOKE.StringListMarshal(allowed_drivers)._ar : null, (sibling_files != null)? new GdalPINVOKE.StringListMarshal(sibling_files)._ar : null);
    Driver ret = (cPtr == IntPtr.Zero) ? null : new Driver(cPtr, false, ThisOwn_false());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static string[] GeneralCmdLineProcessor(string[] papszArgv, int nOptions) {
        /* %typemap(csout) char**options */
        IntPtr cPtr = GdalPINVOKE.GeneralCmdLineProcessor((papszArgv != null)? new GdalPINVOKE.StringListMarshal(papszArgv)._ar : null, nOptions);
        IntPtr objPtr;
        int count = 0;
        if (cPtr != IntPtr.Zero) {
            while (Marshal.ReadIntPtr(cPtr, count*IntPtr.Size) != IntPtr.Zero)
                ++count;
        }
        string[] ret = new string[count];
        if (count > 0) {
	        for(int cx = 0; cx < count; cx++) {
                objPtr = System.Runtime.InteropServices.Marshal.ReadIntPtr(cPtr, cx * System.Runtime.InteropServices.Marshal.SizeOf(typeof(IntPtr)));
                ret[cx]= (objPtr == IntPtr.Zero) ? null : System.Runtime.InteropServices.Marshal.PtrToStringAnsi(objPtr);
            }
        }
        
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
        return ret;
}

  internal static void __WriteCArrayItem_GDAL_GCP(IntPtr carray, int index, GCP value) {
    GdalPINVOKE.__WriteCArrayItem_GDAL_GCP(carray, index, GCP.getCPtr(value));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  internal static GCP __ReadCArrayItem_GDAL_GCP(IntPtr carray, int index) {
    IntPtr cPtr = GdalPINVOKE.__ReadCArrayItem_GDAL_GCP(carray, index);
    GCP ret = (cPtr == IntPtr.Zero) ? null : new GCP(cPtr, false, ThisOwn_false());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  internal static IntPtr __AllocCArray_GDAL_GCP(int size) {
      IntPtr ret = GdalPINVOKE.__AllocCArray_GDAL_GCP(size);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
      return ret;
}

  internal static void __FreeCArray_GDAL_GCP(IntPtr carray) {
    GdalPINVOKE.__FreeCArray_GDAL_GCP(carray);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public static string GDALInfo(Dataset hDataset, GDALInfoOptions infoOptions) {
    string ret = GdalPINVOKE.GDALInfo(Dataset.getCPtr(hDataset), GDALInfoOptions.getCPtr(infoOptions));
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset wrapper_GDALTranslate(string dest, Dataset dataset, GDALTranslateOptions translateOptions, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    IntPtr cPtr = GdalPINVOKE.wrapper_GDALTranslate(Gdal.StringToUtf8Bytes(dest), Dataset.getCPtr(dataset), GDALTranslateOptions.getCPtr(translateOptions), callback, callback_data);
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int wrapper_GDALWarpDestDS(Dataset dstDS, int object_list_count, SWIGTYPE_p_p_GDALDatasetShadow poObjects, GDALWarpAppOptions warpAppOptions, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.wrapper_GDALWarpDestDS(Dataset.getCPtr(dstDS), object_list_count, SWIGTYPE_p_p_GDALDatasetShadow.getCPtr(poObjects), GDALWarpAppOptions.getCPtr(warpAppOptions), callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset wrapper_GDALWarpDestName(string dest, int object_list_count, SWIGTYPE_p_p_GDALDatasetShadow poObjects, GDALWarpAppOptions warpAppOptions, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    IntPtr cPtr = GdalPINVOKE.wrapper_GDALWarpDestName(Gdal.StringToUtf8Bytes(dest), object_list_count, SWIGTYPE_p_p_GDALDatasetShadow.getCPtr(poObjects), GDALWarpAppOptions.getCPtr(warpAppOptions), callback, callback_data);
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int wrapper_GDALVectorTranslateDestDS(Dataset dstDS, Dataset srcDS, GDALVectorTranslateOptions options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.wrapper_GDALVectorTranslateDestDS(Dataset.getCPtr(dstDS), Dataset.getCPtr(srcDS), GDALVectorTranslateOptions.getCPtr(options), callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset wrapper_GDALVectorTranslateDestName(string dest, Dataset srcDS, GDALVectorTranslateOptions options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    IntPtr cPtr = GdalPINVOKE.wrapper_GDALVectorTranslateDestName(Gdal.StringToUtf8Bytes(dest), Dataset.getCPtr(srcDS), GDALVectorTranslateOptions.getCPtr(options), callback, callback_data);
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset wrapper_GDALDEMProcessing(string dest, Dataset dataset, string pszProcessing, string pszColorFilename, GDALDEMProcessingOptions options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    IntPtr cPtr = GdalPINVOKE.wrapper_GDALDEMProcessing(Gdal.StringToUtf8Bytes(dest), Dataset.getCPtr(dataset), pszProcessing, pszColorFilename, GDALDEMProcessingOptions.getCPtr(options), callback, callback_data);
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int wrapper_GDALNearblackDestDS(Dataset dstDS, Dataset srcDS, GDALNearblackOptions options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.wrapper_GDALNearblackDestDS(Dataset.getCPtr(dstDS), Dataset.getCPtr(srcDS), GDALNearblackOptions.getCPtr(options), callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset wrapper_GDALNearblackDestName(string dest, Dataset srcDS, GDALNearblackOptions options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    IntPtr cPtr = GdalPINVOKE.wrapper_GDALNearblackDestName(Gdal.StringToUtf8Bytes(dest), Dataset.getCPtr(srcDS), GDALNearblackOptions.getCPtr(options), callback, callback_data);
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset wrapper_GDALGrid(string dest, Dataset dataset, GDALGridOptions options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    IntPtr cPtr = GdalPINVOKE.wrapper_GDALGrid(Gdal.StringToUtf8Bytes(dest), Dataset.getCPtr(dataset), GDALGridOptions.getCPtr(options), callback, callback_data);
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static int wrapper_GDALRasterizeDestDS(Dataset dstDS, Dataset srcDS, GDALRasterizeOptions options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    int ret = GdalPINVOKE.wrapper_GDALRasterizeDestDS(Dataset.getCPtr(dstDS), Dataset.getCPtr(srcDS), GDALRasterizeOptions.getCPtr(options), callback, callback_data);
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset wrapper_GDALRasterizeDestName(string dest, Dataset srcDS, GDALRasterizeOptions options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    IntPtr cPtr = GdalPINVOKE.wrapper_GDALRasterizeDestName(Gdal.StringToUtf8Bytes(dest), Dataset.getCPtr(srcDS), GDALRasterizeOptions.getCPtr(options), callback, callback_data);
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset wrapper_GDALBuildVRT_objects(string dest, int object_list_count, SWIGTYPE_p_p_GDALDatasetShadow poObjects, GDALBuildVRTOptions options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    IntPtr cPtr = GdalPINVOKE.wrapper_GDALBuildVRT_objects(Gdal.StringToUtf8Bytes(dest), object_list_count, SWIGTYPE_p_p_GDALDatasetShadow.getCPtr(poObjects), GDALBuildVRTOptions.getCPtr(options), callback, callback_data);
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public static Dataset wrapper_GDALBuildVRT_names(string dest, string[] source_filenames, GDALBuildVRTOptions options, Gdal.GDALProgressFuncDelegate callback, string callback_data) {
    IntPtr cPtr = GdalPINVOKE.wrapper_GDALBuildVRT_names(Gdal.StringToUtf8Bytes(dest), (source_filenames != null)? new GdalPINVOKE.StringListMarshal(source_filenames)._ar : null, GDALBuildVRTOptions.getCPtr(options), callback, callback_data);
    Dataset ret = (cPtr == IntPtr.Zero) ? null : new Dataset(cPtr, true, ThisOwn_true());
    if (GdalPINVOKE.SWIGPendingException.Pending) throw GdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

}

}
