static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" * Copyright 2013 Daniel Sabo                                                 \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (value, _(\"Opacity\"), 1.0)                                  \n"
"    description (_(\"Global opacity value that is always used on top of the optional auxiliary input buffer.\"))\n"
"    value_range (-10.0, 10.0)                                                 \n"
"    ui_range    (0.0, 1.0)                                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_COMPOSER                                                \n"
"#define GEGL_OP_C_SOURCE opacity.c                                            \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *self)                                                 \n"
"{                                                                             \n"
"  const Babl *fmt = gegl_operation_get_source_format (self, \"input\");       \n"
"  GeglProperties *o = GEGL_PROPERTIES (self);                                 \n"
"                                                                              \n"
"  if (fmt)                                                                    \n"
"    {                                                                         \n"
"      const Babl *model = babl_format_get_model (fmt);                        \n"
"                                                                              \n"
"      if (model == babl_model (\"R'aG'aB'aA\") ||                             \n"
"          model == babl_model (\"Y'aA\"))                                     \n"
"        {                                                                     \n"
"          o->user_data = NULL;                                                \n"
"          fmt = babl_format (\"R'aG'aB'aA float\");                           \n"
"        }                                                                     \n"
"      else if (model == babl_model (\"RaGaBaA\") ||                           \n"
"               model == babl_model (\"YaA\"))                                 \n"
"        {                                                                     \n"
"          o->user_data = NULL;                                                \n"
"          fmt = babl_format (\"RaGaBaA float\");                              \n"
"        }                                                                     \n"
"      else if (model == babl_model (\"R'G'B'A\") ||                           \n"
"               model == babl_model (\"R'G'B'\")  ||                           \n"
"               model == babl_model (\"Y'\")      ||                           \n"
"               model == babl_model (\"Y'A\"))                                 \n"
"        {                                                                     \n"
"          o->user_data = (void*)0xabc;                                        \n"
"          fmt = babl_format (\"R'G'B'A float\");                              \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          o->user_data = (void*)0xabc;                                        \n"
"          fmt = babl_format (\"RGBA float\");                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      o->user_data = (void*)0xabc;                                            \n"
"      fmt = babl_format (\"RGBA float\");                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (self, \"input\", fmt);                           \n"
"  gegl_operation_set_format (self, \"output\", fmt);                          \n"
"  gegl_operation_set_format (self, \"aux\", babl_format (\"Y float\"));       \n"
"                                                                              \n"
"  return;                                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"process_RaGaBaAfloat (GeglOperation       *op,                                \n"
"                      void                *in_buf,                            \n"
"                      void                *aux_buf,                           \n"
"                      void                *out_buf,                           \n"
"                      glong                samples,                           \n"
"                      const GeglRectangle *roi,                               \n"
"                      gint                 level)                             \n"
"{                                                                             \n"
"  gfloat *in = in_buf;                                                        \n"
"  gfloat *out = out_buf;                                                      \n"
"  gfloat *aux = aux_buf;                                                      \n"
"  gfloat value = GEGL_PROPERTIES (op)->value;                                 \n"
"                                                                              \n"
"  if (aux == NULL)                                                            \n"
"    {                                                                         \n"
"      g_assert (value != 1.0); /* buffer should have been passed through */   \n"
"      while (samples--)                                                       \n"
"        {                                                                     \n"
"          gint j;                                                             \n"
"          for (j=0; j<4; j++)                                                 \n"
"            out[j] = in[j] * value;                                           \n"
"          in  += 4;                                                           \n"
"          out += 4;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else if (value == 1.0)                                                      \n"
"    while (samples--)                                                         \n"
"      {                                                                       \n"
"        gint j;                                                               \n"
"        for (j=0; j<4; j++)                                                   \n"
"          out[j] = in[j] * (*aux);                                            \n"
"        in  += 4;                                                             \n"
"        out += 4;                                                             \n"
"        aux += 1;                                                             \n"
"      }                                                                       \n"
"  else                                                                        \n"
"    while (samples--)                                                         \n"
"      {                                                                       \n"
"        gfloat v = (*aux) * value;                                            \n"
"        gint j;                                                               \n"
"        for (j=0; j<4; j++)                                                   \n"
"          out[j] = in[j] * v;                                                 \n"
"        in  += 4;                                                             \n"
"        out += 4;                                                             \n"
"        aux += 1;                                                             \n"
"      }                                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"process_RGBAfloat (GeglOperation       *op,                                   \n"
"                   void                *in_buf,                               \n"
"                   void                *aux_buf,                              \n"
"                   void                *out_buf,                              \n"
"                   glong                samples,                              \n"
"                   const GeglRectangle *roi,                                  \n"
"                   gint                 level)                                \n"
"{                                                                             \n"
"  gfloat *in = in_buf;                                                        \n"
"  gfloat *out = out_buf;                                                      \n"
"  gfloat *aux = aux_buf;                                                      \n"
"  gfloat value = GEGL_PROPERTIES (op)->value;                                 \n"
"                                                                              \n"
"  if (aux == NULL)                                                            \n"
"    {                                                                         \n"
"      g_assert (value != 1.0); /* buffer should have been passed through */   \n"
"      while (samples--)                                                       \n"
"        {                                                                     \n"
"          gint j;                                                             \n"
"          for (j=0; j<3; j++)                                                 \n"
"            out[j] = in[j];                                                   \n"
"          out[3] = in[3] * value;                                             \n"
"          in  += 4;                                                           \n"
"          out += 4;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else if (value == 1.0)                                                      \n"
"    while (samples--)                                                         \n"
"      {                                                                       \n"
"        gint j;                                                               \n"
"        for (j=0; j<3; j++)                                                   \n"
"          out[j] = in[j];                                                     \n"
"        out[3] = in[3] * (*aux);                                              \n"
"        in  += 4;                                                             \n"
"        out += 4;                                                             \n"
"        aux += 1;                                                             \n"
"      }                                                                       \n"
"  else                                                                        \n"
"    while (samples--)                                                         \n"
"      {                                                                       \n"
"        gfloat v = (*aux) * value;                                            \n"
"        gint j;                                                               \n"
"        for (j=0; j<3; j++)                                                   \n"
"          out[j] = in[j];                                                     \n"
"        out[3] = in[3] * v;                                                   \n"
"        in  += 4;                                                             \n"
"        out += 4;                                                             \n"
"        aux += 1;                                                             \n"
"      }                                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *aux_buf,                                        \n"
"         void                *out_buf,                                        \n"
"         glong                samples,                                        \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  if (GEGL_PROPERTIES (op)->user_data != NULL)                                \n"
"    process_RGBAfloat (op, in_buf, aux_buf, out_buf, samples, roi, level);    \n"
"  else                                                                        \n"
"    process_RaGaBaAfloat (op, in_buf, aux_buf, out_buf, samples, roi, level); \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"                                                                              \n"
"#include \"opencl/opacity.cl.h\"                                              \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *op,                                          \n"
"            cl_mem               in_tex,                                      \n"
"            cl_mem               aux_tex,                                     \n"
"            cl_mem               out_tex,                                     \n"
"            size_t               global_worksize,                             \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                 level)                                       \n"
"{                                                                             \n"
"  cl_int cl_err = 0;                                                          \n"
"  int kernel;                                                                 \n"
"  gfloat value;                                                               \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"gegl_opacity_RaGaBaA_float\", \"gegl_opacity_RGBA_float\", NULL};\n"
"      cl_data = gegl_cl_compile_and_build (opacity_cl_source, kernel_name);   \n"
"    }                                                                         \n"
"  if (!cl_data) return TRUE;                                                  \n"
"                                                                              \n"
"  value = GEGL_PROPERTIES (op)->value;                                        \n"
"                                                                              \n"
"  kernel = (GEGL_PROPERTIES (op)->user_data == NULL)? 0 : 1;                  \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[kernel], 0, sizeof(cl_mem),   (void*)&in_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[kernel], 1, sizeof(cl_mem),   (aux_tex)? (void*)&aux_tex : NULL);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[kernel], 2, sizeof(cl_mem),   (void*)&out_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[kernel], 3, sizeof(cl_float), (void*)&value);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),          \n"
"                                        cl_data->kernel[kernel], 1,           \n"
"                                        NULL, &global_worksize, NULL,         \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"/* Fast path when opacity is a no-op                                          \n"
" */                                                                           \n"
"static gboolean operation_process (GeglOperation        *operation,           \n"
"                                   GeglOperationContext *context,             \n"
"                                   const gchar          *output_prop,         \n"
"                                   const GeglRectangle  *result,              \n"
"                                   gint                  level)               \n"
"{                                                                             \n"
"  GeglOperationClass  *operation_class;                                       \n"
"  gpointer in, aux;                                                           \n"
"  operation_class = GEGL_OPERATION_CLASS (gegl_op_parent_class);              \n"
"                                                                              \n"
"  /* get the raw values this does not increase the reference count */         \n"
"  in = gegl_operation_context_get_object (context, \"input\");                \n"
"  aux = gegl_operation_context_get_object (context, \"aux\");                 \n"
"                                                                              \n"
"  if (in && !aux && GEGL_PROPERTIES (operation)->value == 1.0)                \n"
"    {                                                                         \n"
"      gegl_operation_context_take_object (context, \"output\",                \n"
"                                          g_object_ref (G_OBJECT (in)));      \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"  /* chain up, which will create the needed buffers for our actual            \n"
"   * process function                                                         \n"
"   */                                                                         \n"
"  return operation_class->process (operation, context, output_prop, result,   \n"
"                                  gegl_operation_context_get_level (context));\n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass              *operation_class;                           \n"
"  GeglOperationPointComposerClass *point_composer_class;                      \n"
"                                                                              \n"
"  operation_class      = GEGL_OPERATION_CLASS (klass);                        \n"
"  point_composer_class = GEGL_OPERATION_POINT_COMPOSER_CLASS (klass);         \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->process = operation_process;                               \n"
"  point_composer_class->process = process;                                    \n"
"  point_composer_class->cl_process = cl_process;                              \n"
"                                                                              \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:opacity\",                                        \n"
"    \"categories\" , \"transparency\",                                        \n"
"    \"title\",       _(\"Opacity\"),                                          \n"
"    \"description\",                                                          \n"
"          _(\"Weights the opacity of the input both the value of the aux\"    \n"
"            \" input and the global value property.\"),                       \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
