# Geonkick User Guide

**Author:** Iurie Nistor

**License:** This work (including all images it uses) is released under [CC0 1.0 Universal (CC0 1.0) Public Domain Dedication](https://creativecommons.org/publicdomain/zero/1.0/deed.en).

**Version:** 3.4.0

**Website:** [https://geonkick.org](https://geonkick.org)

### Table of Contents

- [Introduction](#introduction)
- [How it works](#how-it-works)
- [Block diagram](#block-diagram)
- [Instrument](#instrument)
   * [Instrument Layers](#instrument-layers)
   * [Playing Instrument](#playing-instrument)
   * [Instrument UI](#instrument-ui)
   * [Top Bar](#top-bar)
   * [Shortcut Keys](#shortcut-keys)
   * [Instrument Envelope Area](#instrument-envelope-area)
   * [Envelope Points](#envelope-points)
   * [Envelope Point Label](#envelope-point-label)
   * [Manually Input Envelope Point Value](#manually-input-envelope-point-value)
   * [Display Current Selected Coordinates of Envelope Point](#display-current-selected-coordinates-of-envelope-point)
   * [Instrument Graph](#instrument-graph)
   * [Instrument Preset](#instrument-preset)
   * [Oscillator](#oscillator)
   * [Noise Generator](#noise-generator)
   * [General Controls](#general-controls)
   * [Limiter](#limiter)
   * [Filter](#filter)
   * [Distortion](#distortion)
   * [Compressor](#compressor)
   * [Tune](#tune)
   * [Export](#export)
- [Kit](#kit)
   * [Default Kit State](#default-kit-state)
   * [Kit UI](#kit-ui)
   * [Current Instrument](#current-instrument)
   * [Kit Output Channels](#kit-output-channels)
   * [Kit Preset](#kit-preset)
   * [Kit Preset vs Instrument Preset](#kit-preset-vs-instrument-preset)
- [Preset Browser](#preset-browser)
- [Instrument vs Channel](#instrument-vs-channel)
- [Sample Browser](#sample-browser)
- [Settings](#settings)
- [LV2 Plugin](#lv2-plugin)
- [Standalone](#standalone)
- [Build & Install](#build-install)

### Introduction

Geonkick is a [free software](https://www.gnu.org/philosophy/free-sw.en.html) percussive synthesizer. It can synthesize various percussive sounds, including kicks, snares, hi-hats, shakers, claps, and other unique sound effects. The synthesizer can also play pre-existing samples and offers features such as pitch modification, allowing users to modify and blend samples and synthesis. Geonkick is released under the GNU General Public License version 3 (and later), developed in C and C++, and utilizes the CMake build system. It can be used as a standalone application and as a LV2 & VST3 plugin.

### How it works

Geonkick synthesizes the full instrument length sound into a buffer in the memory whenever the user modifies the controls or the envelopes. The resulting instrument sound is then transferred to a module responsible for playing the instrument. There is no synthesis occurring when the user presses a key; in other words, if no controls are altered, Geonkick functions like a sampler. However, this behavior results in the same real-time synthesis experience for the user as common synthesizers.

Additionally, there is a list of synthesized instruments that enables Geonkick to function as an instrument kit with specific key mappings. The Instrument UI (main window) essentially acts as an "editor" for the selected instrument from the kit list.

Each instrument in the kit list is monophonic. However, the instrument can be directed to the audio output of any of the 16 stereo audio output channels. Given that the instrument is monophonic, the left and right channels of a stereo channel are identical.

### Block diagram

![Screenshot](diagram.png)

### Instrument

An instrument is a percussive sound generated by the Geonkick synthesizer. Its maximum length can be 4 seconds. This sound is played by Geonkick when an associated MIDI key is pressed.

Geonkick can handle up to 16 instruments in parallel, making it a multi-timbral synthesizer. There is always a currently selected instrument that can be modified using the instrument UI. The user can select any instrument from the kit list and modify it.

#### Instrument Layers

An instrument consists of three layers that can be turned on/off using the buttons "L1," "L2," and "L3" in the top bar menu. Each layer contains two oscillators and a noise generator. The sum of these layers is passed to the "General" controls. The contribution of each layer to the output can be controlled using the "Layers Mixer." Although only one layer is controllable through the UI, the user can switch between layers by pressing the buttons "L1," "L2," or "L3" in the envelope area.

#### Playing Instrument

Every time the user presses the key associated with the instrument, Geonkick will play the instrument until the end or until the key is released. If the key is released before the sound ends, Geonkick will apply a 30 ms linear decay to the sound.

If there are changes in controls during the instrument play, the changes will only be applied at the next key press. However, the instrument graph will display the changes instantly.

#### Instrument UI

The instrument's user interface serves as the primary window of Geonkick, displaying the instrument graph, envelopes, and controls. Additionally, there is a menu for opening and saving instrument presets, as well as exporting instruments.

#### Top Bar

- **"Open" and "Save" buttons:** Opens a dialog for opening or saving the instrument preset.
- **"Export" button:** Displays a dialog for exporting the current instrument to an audio file format.
- **Play button:** Triggers Geonkick to play the current instrument.
- **"L1", "L2", and "L3" buttons:** Turn on/off layers 1, 2, and 3.
- **"Reset" button:** Resets the current instrument to default settings.
- **"Tune" checkbox:** Toggles the tuning of the current instrument. The output instrument sound will be tuned according to the pressed MIDI key.

- **Preset label:** Displays the name of the currently selected instrument; by default, shows "Default".
- **MIDI Key:** Displays the current MIDI input key for the instrument. Pressing on the label opens a popup to select a MIDI key for the instrument.
- **Tabs:** "Controls", "Kit", "Presets", and "Samples", "Settings" switch to instrument main controls, kit, presets, and sample browser UI, settings respectively.

#### Shortcut Keys

- **'Ctrl + k':** Plays the instrument sound.
- **'Ctrl + r':** Resets the current instrument to default.
- **'Ctrl + h':** Hides the envelope, showing only the graph.
- **'Ctrl + o':** Opens the file browser dialog.
- **'Ctrl + s':** Opens the save dialog.
- **'Ctrl + e':** Opens the export dialog.
- **'Ctrl + c':** Copies the currently selected instrument.
- **'Ctrl + v':** Pastes the copied instrument into the currently selected instrument.
- **'Left Ctrl + f':** Scales up the UI by a factor of x1.5, 2x, or restores the original size.
- **'Up/Down arrows':** Navigates the kit list.
- **'Ctrl + Up/Down arrows':** Moves up/down the position of the currently selected instrument in the kit list.
- **'Left Ctrl + left mouse double-click on an envelope point':** Opens the envelope point context input for its value.

**Note:** When running as a plugin, ensure that the focus is on the main Geonkick window and that the key inputs are enabled by the host for the plugin.


#### Instrument Envelope Area

The instrument envelope area displays:

- **Instrument graph:** Shows the real-time synthesized instrument sound graph.
- **Envelopes:** Various types of envelopes displayed on top of the instrument sound graph.
- **Envelope points:** Can be added, removed, and moved by the user. Display the values of the envelopes points and also have a context input for the value (Ctrl + left mouse double-click on the point).
- **Envelope Path Label:** Shows the current selected envelope type and category. For example, "L1/OSC1/AMPL" means the amplitude envelope of Layer 1 of Oscillator 1.
- **Buttons "L1", "L2", "L3":** Set the envelope area to display only the envelopes for Layer 1, 2, or 3.
- When hovering over/selecting an envelope point, it displays the point's coordinates (value, time) in the bottom right corner area.

#### Envelope Points

Users can add, remove, or move an envelope point. The default first and last points cannot be removed, only moved.

- **Left click:** Select and move the point.
- **Left double click:** Add a new point.
- **Right click:** Remove the point.

#### Envelope Point Label

Envelope points have labels showing the current value related to vertical axes (amplitude, frequency, etc.). For frequency envelope or cutoff, an additional point label maps the current frequency to a MIDI note.

*Note: Point key labels are shown for a frequency region close to or exact to the particular key, not just an exact frequency. The exact value is displayed in the buttom-right corner.*

#### Manually Input Envelope Point Value

Users can set the value of an envelope point manually with a maximum precision of 4 digits after the floating point:

1. Press `Left Ctrl` and double-click on the envelope point. An input context line edit will be displayed.

2. Enter the desired value and press `Enter`.

3. To cancel, press `Esc` or click outside the line edit widget to close it.

#### Display Current Selected Coordinates of Envelope Point

A more exact values of the coordinates of the currently hovered or selected envelope point are shown in the bottom-right area, displaying both value and time in milliseconds.

#### Instrument Graph

The instrument graph shows the real-time synthesized instrument sound. Whenever the user changes instrument controls, Geonkick generates a new graph and updates it.

If the sound exceeds the range of -1.0 to 1.0, the sound is hard-limited to these values, visible in the instrument graph.

*Issues:* For strictly periodic signals with high frequencies that cause the graph to be dense, aliasing might occur for specific frequencies. However, this issue does not affect the played sound or the exported sound itself.

#### Instrument Preset

The instrument preset is in JSON format and uses the file extension "*.gkick". It can be opened and saved through the instrument UI using the "Open" and "Save" buttons in the top bar.

#### Oscillator

Each layer consists of two oscillators, the outputs of which are mixed with a noise generator to produce the layer's output. Controls related to oscillators are grouped and arranged vertically.

- **"Oscillator1" and "Oscillator 2":** Checkboxes to toggle the oscillators on/off.
- **"Osc1->Osc2":** Checkbox that allows Oscillator1 to FM modulate Oscillator2.
- **Waveform Types:** "Sine," "Square," "Triangle," "Sawtooth" - options for periodic wave functions of the oscillator.
- **"Sample":** Represents a sampler with a maximum length of 4 seconds.
- **"...":** Button to browse and load a sample (WAV, FLAC, or OGG).
- **"Phase":** Adjusts the initial phase of the oscillator. For samples, this moves the start of the sample up to 1/2 of the instrument sound length.
- **Amplitude Knob:** Sets the maximum current amplitude of the oscillator.
- **Frequency Knob:** Sets the maximum current frequency of the oscillator.
- **Pitch Knob:** Sets the pitch shift range when the waveform is set as a sample.
- **Pitch Buttons:** Show the envelopes for the pitch shift.
- **"Filter" Button:** Enables/Disables the filter for the oscillator.
- **Envelopes Buttons:** "Amplitude," "Frequency," "Pitch," and "Cutoff" to access envelopes for amplitude, frequency, pitch shift, and filter cutoff, respectively.

#### Noise Generator

The noise generator creates white and brownian noise.

- **"Amplitude":** Sets the maximum noise amplitude and the amplitude envelope.
- **"White" and "Brownian":** Select the noise type.
- **"Seed":** Slider to set different seeds for the noise generator.
- **Filter:** Similar controls to oscillators.

Loading/saving presets preserves the noise pattern and seed.

#### General Controls

General controls are applied after the layers mixer. Arranged vertically and applied from top to bottom. The compressor is applied last.

- **Amplitude Knob:** Controls the maximum amplitude after the layers mixer.
- **"Amplitude" Button:** Shows the general amplitude envelope.
- **"Length":** Sets the maximum sound length of the instrument.
- **Filter Controls:** Similar to oscillator controls.
- **Distortion:** Drive and volume envelopes can be accessed with "Drive" and "Volume" buttons.
- **Compressor**

#### Limiter

The limiter control is applied to the audio output of the instrument, controlling only the currently selected instrument. 

*Issues:* When playing the instrument and simultaneously changing the limiter quickly, sound artifacts may occur due to abrupt changes in sound. To adjust the total output amplitude, it's better to use the "General" controls for amplitude.

#### Filter

Geonkick implements a digital state-variable filter applied to oscillators, the noise generator, and after the layers mixer (general filter).

Parameters:

- **"Filter" Buttons:** Enable/Disable filter.
- **Cutoff Knob:** Controls the cutoff frequency of the filter in a logarithmic range (20Hz - 20kHz).
- **"Cutoff" Button:** Shows the cutoff envelope.
- **Resonance Knob:** Logarithmic range from 0.01 to 10.
- **"Q" Button:** Shows the envelope for the resonance.
- **Filter Type Buttons:** "LP" for low-pass, "BP" for band-pass, and "HP" for high-pass filters.

The filter becomes unstable for extreme combinations of cutoff frequency and Q parameter. If it becomes unstable, the instrument graph will be hard-limited. Proper adjustments of the Q factor are necessary to maintain desired cutoff frequency ranges. This behavior can be used as a feature to generate special effect sounds.

#### Distortion

The distortion effect is applied after the general filter and has the following controls:

- **Input:** Limiter for the input signal.
- **Volume:** Output volume control.
- **Volume Envelope:** Accessed with the "Volume" button.
- **Drive:** Controls the amount of distortion.
- **Drive Envelope:** Accessed with the "Drive" button.

#### Compressor

The compressor is applied after distortion and has the following controls:

- **"Attack"**
- **"Threshold"**
- **"Ratio"**
- **"Drive"**

*Note:* The compressor is not a standard compressor; it only compresses signal aplitude with a zero release time. It is more useful for creating distortion effects. For standard sound compression, it is recommended to use a dedicated compressor.

#### Tune

In the top bar, the "Tune" checkbox toggles tuning for the currently selected instrument. When enabled, Geonkick will stop mapping the instrument to a specific key and will tune the sound relative to the untuned key A4 (in number of semitones).

*Note:* "Tune" will not make Geonkick polyphonic.

#### Export

The Export dialog can be accessed by clicking the "Export" button in the top bar. It includes the following inputs:

- **File format:** "FLAC16", "FLAC24", "WAV16", "WAV24", "WAV32", "Ogg"
- **"Path":** Specifies the export file path.
- **"File name"**
- **"Stereo" or "Mono":** Exports into a file with one or two identical channels.

Geonkick will export only the currently selected instrument.

### Kit

Geonkick is multitimbral by default. Each synthesized instrument in Geonkick is added to a list, forming a kit of up to 16 instruments. To access the kit UI, click the "Kit" button on the top bar the main UI.

#### Default Kit State

When the user opens a new Geonkick instance, it will have a single default instrument in the kit UI list. The key mapping for this instrument will be set to any key, and the channel of the default instrument will be directed to channel number 0.

#### Kit UI

The instrument list has a maximum limit of 16 instruments and displays the instrument names and their MIDI key mappings, forming a grid. The kit UI will show the currently selected instrument from the list, which can be controlled. In the kit list, the current instrument will be emphasized.

- **Left click:** Selects the current instrument.
- **Left double click:** Edits the instrument name.
- **"Add" button (icon with a plus):** Adds a new default instrument.
- **"Open" button (icon with an up arrow):** Opens a kit preset.
- **"Save" button (icon with a down arrow):** Saves the kit preset.
- **"Remove" button (icon with a cross):** Removes the instrument.
- **"Copy" button:** Copies an instrument and adds it to the list.
- **Buttons at the end of the instrument line:** Popup for selecting the MIDI key.
- **Spinbox for setting MIDI input channel for an instrument.**
- **Column labels:** Show the MIDI key the instrument can be mapped to. The "Any" label indicates that the instrument will be played by pressing any key.
- **Green circle:** Indicates which instrument is mapped to which output channel and can be changed by left-clicking on the grid cell.
- **Limiter slider:** Controls the limiter for the current instrument.
- **"M" button:** Mutes the current instrument.
- **"S" button:** Solos the current instrument.

#### Current Instrument

When the user selects an instrument from the kit list, it becomes the current controllable instrument in the instrument UI. The instrument UI displays the graph and envelopes of the current instrument. Changing controls will synthesize the selected instrument.

When the user opens an instrument preset (using the "Open" button in the top bar), the currently selected instrument is updated to the opened preset. Similarly, when the user saves an instrument, only the preset of the currently selected instrument is saved. The same applies to exporting.

#### Kit Output Channels

There are a maximum of 16 stereo audio output channels to which the user can map the instruments. When a new instrument is added, it is mapped to channel 1 by default.

#### Kit Preset

A kit preset is in JSON format with the file extension "*.gkit" and includes a list of all instrument presets from the kit. Users can save and open this preset from the kit UI.

#### Kit Preset vs Instrument Preset

An instrument preset is specific to a single instrument and can be loaded using the instrument UI. In contrast, a kit preset contains a list of instrument presets and can be loaded using the kit UI.

#### Preset Browser

The preset browser can be accessed by clicking the "Presets" button on the top bar.

The first column of the preset browser lists the names of preset folders. Each folder may contain instrument and kit presets. When a folder is selected, the browser displays all the presets within that folder in subsequent columns. Kit presets are marked with the prefix "KIT:".

- "+" / "-" -  to add or remove a custom preset folder (for all instances).
- ">", "<" - to navigate the preset pages

**Note2:**
- To add new presets to the browser, users need to save the presets (both kit and instrument types) in one of the following paths, then reopen the program or reload the plugin:
    - /usr/share/geonkick/presets/<PresetFolder>/<Preset>
    - /usr/local/share/geonkick/presets/<PresetFolder>/<Preset>
    - /home/<user>/.local/geonkick/presets/<PresetFolder>/<Preset>

**Note3:**
- Default Geonkick presets are installed under:
    - /usr/share/geonkick/presets/
    - or /usr/local/share/geonkick/presets

#### Instrument vs Channel

In Geonkick's Kit UI, instruments and channels are distinct entities. An instrument from the kit UI can be redirected to any audio output channel (from channels 1 to 16). This allows multiple instruments to be directed to a single channel. However, assigning multiple channels to a single instrument is not possible from the Kit UI (this feature may be provided by the host).

#### Sample Browser

The sample browser is a file dialog for sample files (WAV, FLAC, OGG). Users can select and load samples into Osc1 or Osc2. The browser includes a preview section where the selected file can be played and previewed. The preview sound is routed through the first stereo channel (which must be connected in the host for plugin usage).

#### Settings

The settings widget gives the user the ability to configure various settings. These settings typically apply to all Geonkick instances.

- **Force all MIDI channels to:** Forces all instrument MIDI input channels to a specific channel (for all instances).


### LV2 Plugin

There are two versions of the plugin: the default version and the "Single" version.

- The default plugin version supports kits with 16 instruments and creates 16 stereo audio output channels per plugin instance. One instance of this plugin will use approximately 35MB of heap memory.

- The "Single" plugin version does not support kits and only includes one instrument and one stereo audio output channel. One instance of this version will use about 2MB of heap memory. If only one instrument per track is needed, it is recommended to use the "Single" version of the plugin.

*Note*: VST3 plugin has only the default version (kit version).

### Standalone

The standalone version of Geonkick offers the same features as the LV2 or VST3 plugin.

### Build & Install

For instructions on building and installing Geonkick, please refer to the README file.


