/*
  gmorgan - a ryhthm station software

  gmorgan.c  -  Most of thefinction of the organ
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License
(version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

/* Alsa sequencer functions  by Matthias Nagorni 
   modified by Josep Andreu

*/


#include "GMorgan.h"
#include <iostream>
using namespace std;

void
GMO::loadpatt(char *filename)
{
   
   FILE *fs;
   char temp[128];
   int NumRit,i,j,k;
   int w,haymas,contemp,NumMiCont,NumMiDr;
   haymas = 1;
   bzero(temp,sizeof(temp));
 
  if ((fs = fopen (filename, "r")) != NULL)
   {
      for(NumRit=prime; NumRit<ulti; NumRit++)
       {
              patternclear(NumRit);
              PonCeroDrum();
              PonCeroControl();
                            
              bzero(Rt[NumRit].Nom,sizeof(Rt[NumRit].Nom));
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              for (i = 0; i <=(int) strlen(temp) - 2; i++) Rt[NumRit].Nom[i] = temp[i];                   
       if (strcmp(Rt[NumRit].Nom, "Empty") != 0)
              {

              bzero(Rt[NumRit].Nfile,sizeof(Rt[NumRit].Nfile));
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              for (i = 0; i <= (int) strlen(temp) - 2; i++) Rt[NumRit].Nfile[i] = temp[i];
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf(temp,"%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d",&Rt[NumRit].bars,&Rt[NumRit].blackn,&Rt[NumRit].octavate,&Rt[NumRit].acc2mode,&Rt[NumRit].swing,&Rt[NumRit].acc3mode,&Rt[NumRit].acc4mode,&Rt[NumRit].acc5mode,&Rt[NumRit].octavate4,&Rt[NumRit].terceras4,&Rt[NumRit].sextas4);
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf (temp,"%d,%d,%d,%d,%d,%d", &Rt[NumRit].dron,&Rt[NumRit].drpc,&Rt[NumRit].drvol,&Rt[NumRit].drpan,&Rt[NumRit].drrev,&Rt[NumRit].drcho);
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf (temp,"%d,%d,%d,%d", &Rt[NumRit].drocta,&Rt[NumRit].drBankM,&Rt[NumRit].drpon,&Rt[NumRit].drptime);
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf (temp,"%d,%d,%d,%d,%d,%d", &Rt[NumRit].basson,&Rt[NumRit].basspc,&Rt[NumRit].bassvol,&Rt[NumRit].basspan,&Rt[NumRit].bassrev,&Rt[NumRit].basscho);
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf (temp,"%d,%d,%d,%d", &Rt[NumRit].bassocta,&Rt[NumRit].bassBankM,&Rt[NumRit].basspon,&Rt[NumRit].bassptime);
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf (temp,"%d,%d,%d,%d,%d,%d", &Rt[NumRit].acc1on,&Rt[NumRit].acc1pc,&Rt[NumRit].acc1vol,&Rt[NumRit].acc1pan,&Rt[NumRit].acc1rev,&Rt[NumRit].acc1cho);
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf (temp,"%d,%d,%d,%d", &Rt[NumRit].acc1octa,&Rt[NumRit].acc1BankM,&Rt[NumRit].acc1pon,&Rt[NumRit].acc1ptime);
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf (temp,"%d,%d,%d,%d,%d,%d", &Rt[NumRit].acc2on,&Rt[NumRit].acc2pc,&Rt[NumRit].acc2vol,&Rt[NumRit].acc2pan,&Rt[NumRit].acc2rev,&Rt[NumRit].acc2cho);
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf (temp,"%d,%d,%d,%d", &Rt[NumRit].acc2octa,&Rt[NumRit].acc2BankM,&Rt[NumRit].acc2pon,&Rt[NumRit].acc2ptime);
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf (temp,"%d,%d,%d,%d,%d,%d", &Rt[NumRit].acc3on,&Rt[NumRit].acc3pc,&Rt[NumRit].acc3vol,&Rt[NumRit].acc3pan,&Rt[NumRit].acc3rev,&Rt[NumRit].acc3cho);
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf (temp,"%d,%d,%d,%d", &Rt[NumRit].acc3octa,&Rt[NumRit].acc3BankM,&Rt[NumRit].acc3pon,&Rt[NumRit].acc3ptime);
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf (temp,"%d,%d,%d,%d,%d,%d",&Rt[NumRit].acc4on,&Rt[NumRit].acc4pc,&Rt[NumRit].acc4vol,&Rt[NumRit].acc4pan,&Rt[NumRit].acc4rev,&Rt[NumRit].acc4cho);
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf (temp,"%d,%d,%d,%d",&Rt[NumRit].acc4octa,&Rt[NumRit].acc4BankM,&Rt[NumRit].acc4pon,&Rt[NumRit].acc4ptime);
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf (temp,"%d,%d,%d,%d,%d,%d",&Rt[NumRit].acc5on,&Rt[NumRit].acc5pc,&Rt[NumRit].acc5vol,&Rt[NumRit].acc5pan,&Rt[NumRit].acc5rev,&Rt[NumRit].acc5cho);
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf (temp,"%d,%d,%d,%d",&Rt[NumRit].acc5octa,&Rt[NumRit].acc5BankM,&Rt[NumRit].acc5pon,&Rt[NumRit].acc5ptime);
             NumMiDr = 0;
             for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
             for (j=1; j<62; j++)
             {
              w = i*4;
              bzero(temp,sizeof(temp));
              fgets(temp, sizeof temp, fs);
              sscanf(temp,"%d,%d,%d,%d",&Edr[j][w+1],&Edr[j][w+2],&Edr[j][w+3],&Edr[j][w+4]);
              for (k=1; k<=4; k++)
              {
              if (Edr[j][w+k] != 0)
              {
              Rt[NumRit].EvDr[NumMiDr].posicion = w+k;
              Rt[NumRit].EvDr[NumMiDr].nota = j;
              Rt[NumRit].EvDr[NumMiDr].valor = Edr[j][w+k];             
              NumMiDr++;
              }
              }
 
             }
             } 
             for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
             for (j=0; j<3; j++)
             {
              w =i*4;       
             bzero(temp,sizeof(temp));
             fgets(temp, sizeof temp, fs);
             sscanf(temp,"%d,%d,%d,%d",&Rt[NumRit].basn[j][w+1],&Rt[NumRit].basn[j][w+2],&Rt[NumRit].basn[j][w+3],&Rt[NumRit].basn[j][w+4]);
             }
             }
             for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
             for (j=0; j<2; j++)
             {
              w = i*4;
             bzero(temp,sizeof(temp));
             fgets(temp, sizeof temp, fs);
             sscanf(temp,"%d,%d,%d,%d",&Rt[NumRit].acc1n[j][w+1],&Rt[NumRit].acc1n[j][w+2],&Rt[NumRit].acc1n[j][w+3],&Rt[NumRit].acc1n[j][w+4]);
             }
             }

             for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
             for (j=0; j<3; j++)
             {
              w =i*4;       
             bzero(temp,sizeof(temp));
             fgets(temp, sizeof temp, fs);
             sscanf(temp,"%d,%d,%d,%d",&Rt[NumRit].acc2n[j][w+1],&Rt[NumRit].acc2n[j][w+2],&Rt[NumRit].acc2n[j][w+3],&Rt[NumRit].acc2n[j][w+4]);
             }
             }

             for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
             for (j=0; j<3; j++)
             {
              w =i*4;       
             bzero(temp,sizeof(temp));
             fgets(temp, sizeof temp, fs);
             sscanf(temp,"%d,%d,%d,%d",&Rt[NumRit].acc3n[j][w+1],&Rt[NumRit].acc3n[j][w+2],&Rt[NumRit].acc3n[j][w+3],&Rt[NumRit].acc3n[j][w+4]);
             }
             }
             
             for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
             for (j=0; j<3; j++)
             {
              w =i*4;       
             bzero(temp,sizeof(temp));
             fgets(temp, sizeof temp, fs);
             sscanf(temp,"%d,%d,%d,%d",&Rt[NumRit].acc4n[j][w+1],&Rt[NumRit].acc4n[j][w+2],&Rt[NumRit].acc4n[j][w+3],&Rt[NumRit].acc4n[j][w+4]);
             }
             }

             for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
             for (j=0; j<3; j++)
             {
              w =i*4;       
             bzero(temp,sizeof(temp));
             fgets(temp, sizeof temp, fs);
             sscanf(temp,"%d,%d,%d,%d",&Rt[NumRit].acc5n[j][w+1],&Rt[NumRit].acc5n[j][w+2],&Rt[NumRit].acc5n[j][w+3],&Rt[NumRit].acc5n[j][w+4]);
             }
             }

             bzero(temp,sizeof(temp));
             fgets(temp, sizeof temp, fs);
             sscanf (temp,"%d,%d,%d,%d,%d,%d,%d,%d",&Rt[NumRit].terceras,&Rt[NumRit].sextas,&Rt[NumRit].bassstlt,&Rt[NumRit].acc1stlt,&Rt[NumRit].acc2stlt,&Rt[NumRit].acc3stlt,&Rt[NumRit].acc4stlt,&Rt[NumRit].acc5stlt);
 
             haymas = 1;
             NumMiCont= 1;

             while ( haymas == 1)
             {
             bzero(temp,sizeof(temp));
             fgets(temp, sizeof temp, fs);
             if (temp[0] != '-') 
             {
                   if (NumMiCont < 1000)
                     {
                      sscanf(temp,"%d,%d,%d,%d",&j,&k,&w,&contemp);
                      Rt[NumRit].EvMidCon[NumMiCont].pista = j;
                      Rt[NumRit].EvMidCon[NumMiCont].controlador = k;
                      Rt[NumRit].EvMidCon[NumMiCont].posicion = w;
                      Rt[NumRit].EvMidCon[NumMiCont].valor = contemp;
                      NumMiCont++;
                      }
             }
             else haymas = 0;
             }  
           
             for (i=1; i<=5; i++)
             {
             bzero(temp,sizeof(temp));
             fgets(temp, sizeof temp, fs);
             }
              
       }  
       }

  }


};

void
GMO::loadfile(char *filename)
{
   FILE *fs;
   char temp[128];
   int i;
   int j;
   int k;
   bzero(temp,sizeof(temp));
  cout << " loadfile " << filename << endl;
  if ((fs = fopen (filename, "r")) != NULL)
   {
      for(i=prime; i<=ulti; i++)
       {
         bzero(Prog[i].Nom,sizeof(Prog[i].Nom));
         bzero(temp,sizeof(temp));
         fgets(temp, sizeof temp, fs);
         for (k = 0; k <= (int) strlen(temp) - 2; k++) Prog[i].Nom[k] = temp[k];
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&Prog[i].style,&Prog[i].pattern,&Prog[i].bpm,&Prog[i].transpose);

         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&v1lowVelocity,&v1highVelocity,&v1lowMidi,&v1highMidi);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&v2lowVelocity,&v2highVelocity,&v2lowMidi,&v2highMidi);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&v3lowVelocity,&v3highVelocity,&v3lowMidi,&v3highMidi);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&v4lowVelocity,&v4highVelocity,&v4lowMidi,&v4highMidi);
         for (j=1; j<=4; j++)
         {
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&Prog[i].progch[j],&Prog[i].volume[j],&Prog[i].BankLSB[j],&Prog[i].BankMSB[j]);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&Prog[i].pan[j],&Prog[i].Pon[j],&Prog[i].reverb[j],&Prog[i].chorus[j]);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d",&Prog[i].Ptime[j],&Prog[i].OnOff[j],&Prog[i].octa[j]);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         }
       }
     }
};     
              
void
GMO::loadstyl(char *filename)
{
   FILE *fs;
   char temp[128];
   int i,k;
   bzero(temp,sizeof(temp));
  if ((fs = fopen (filename, "r")) != NULL)
   {
      for(i=prime; i<=ulti; i++)
       {
         bzero(Styl[i].Nom,sizeof(Styl[i].Nom));
         bzero(temp,sizeof(temp));
         fgets(temp, sizeof temp, fs);
         for (k = 0; k <= (int)strlen(temp) - 2; k++) Styl[i].Nom[k] = temp[k];
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&Styl[i].Intro,&Styl[i].Var1,&Styl[i].Var2,&Styl[i].Fill1);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d,%d",&Styl[i].Fill2,&Styl[i].Ending,&Styl[i].programa,&Styl[i].bpm,&Styl[i].startP);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
      }
   }
};


void
GMO::savestyl(char *filename)
{

   FILE *fs;
   char temp[128];
   int i;
   bzero(temp,sizeof(temp));

  if ((fs = fopen (filename, "w")) != NULL)
   {
     for(i=prime; i<=ulti; i++)
     {
         bzero(temp,sizeof(temp));
         sprintf(temp,"%s\n",Styl[i].Nom);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d\n",Styl[i].Intro,Styl[i].Var1,Styl[i].Var2,Styl[i].Fill1);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d,%d\n",Styl[i].Fill2,Styl[i].Ending,Styl[i].programa,Styl[i].bpm,Styl[i].startP);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));    
         sprintf(temp,"0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0\n");
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0\n");
         fputs (temp, fs);
     }
   fclose(fs); 
 }
};


void
GMO::savevelo(char *filename)
{
   
   FILE *fs;
   char temp[128];
   int i;
   bzero(temp,sizeof(temp));
 
  if ((fs = fopen (filename, "w")) != NULL)
   {     
     for(i=1; i<=61; i++)
       {    

         bzero(temp,sizeof(temp));
         sprintf(temp,"%d\n",veloplus[i]);
         fputs (temp, fs);        
        }
    fclose(fs);
   }

};

void
GMO::loadsong(char *filename)
{
   
   FILE *fs;
   char temp[128];
   int i,k;

   bzero(temp,sizeof(temp));

  if ((fs = fopen (filename, "r")) != NULL)
   {

         fgets(temp,sizeof temp, fs);
         if (strlen(temp) > 2) for (k = 0; k <= (int) strlen(temp) - 2; k++) NombreSong[k] = temp[k];

         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d",&TempoSong,&SNomi,&InvMode);
        


      for(i=1; i<=128; i++)
       {
         bzero(S[i].ch1, sizeof(S[i].ch1));
         bzero(S[i].ch2, sizeof(S[i].ch2));
         bzero(S[i].ch3, sizeof(S[i].ch3));
         bzero(S[i].ch4, sizeof(S[i].ch4));
         bzero(S[i].go_to, sizeof(S[i].go_to));
         bzero(S[i].go_af, sizeof(S[i].go_af));
                 
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         if (strlen(temp) > 0) sscanf(temp,"%s",(char* ) S[i].ch1);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         if (strlen(temp) > 0) sscanf(temp,"%s",(char* ) S[i].ch2);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         if (strlen(temp) > 0) sscanf(temp,"%s",(char* ) S[i].ch3);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         if (strlen(temp) > 0) sscanf(temp,"%s",(char* ) S[i].ch4);

         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d,%d,%d,%d,%d,%d",&S[i].a,&S[i].b,&S[i].c,&S[i].d,&S[i].e,&S[i].f,&S[i].g,&S[i].h,&S[i].fin);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         if (strlen(temp) > 0) sscanf(temp,"%s",(char*) S[i].go_to);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         if (strlen(temp) > 0) sscanf(temp,"%s",(char*) S[i].go_af);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d,%d",&S[i].times,&S[i].atimes,&S[i].pattern,&S[i].ar8,&S[i].ar16);

        }

        i = 1;
        while(!feof(fs))
         {
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d",&TemT[i].bar,&TemT[i].black,&TemT[i].tempo);
         i++;
         }
    }



};

void
GMO::savesong(char *filename)
{

  FILE *fs;
   char temp[128];
   int i;
   bzero(temp,sizeof(temp));

  if ((fs = fopen (filename, "w")) != NULL)
   {

     sprintf(temp, "%s\n",NombreSong);
     fputs (temp,fs);
     bzero(temp,sizeof(temp));
     sprintf(temp,"%d,%d,%d\n",TempoSong,SNomi,InvMode);
     fputs (temp, fs);

     for(i=1; i<=128; i++)
       {
         bzero(temp,sizeof(temp));
         sprintf(temp,"%s\n",S[i].ch1);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%s\n",S[i].ch2);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%s\n",S[i].ch3);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%s\n",S[i].ch4);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d,%d,%d,%d,%d,%d\n",S[i].a,S[i].b,S[i].c,S[i].d,S[i].e,S[i].f,S[i].g,S[i].h,S[i].fin);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%s\n",S[i].go_to);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%s\n",S[i].go_af);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d,%d\n",S[i].times,S[i].atimes,S[i].pattern,S[i].ar8,S[i].ar16);
         fputs (temp, fs);
        }
         i = 1;
         while ( TemT[i].bar != 0)
         {
           bzero(temp,sizeof(temp));
           sprintf(temp,"%d,%d,%d\n",TemT[i].bar,TemT[i].black,TemT[i].tempo);
           fputs(temp,fs);
           i++;
         }     
         
    fclose(fs);
   }




};


void
GMO::loadvelo(char *filename)
{

   FILE *fs;
   char temp[128];
   int i;

   bzero(temp,sizeof(temp));

  if ((fs = fopen (filename, "r")) != NULL)
   {
      for(i=1; i<=61; i++)
       {
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d",&veloplus[i]);
        }
    }
};






void
GMO::savefile(char *filename)
{
   
   FILE *fs;
   char temp[128];
   int i,j;
   bzero(temp,sizeof(temp));
 
  if ((fs = fopen (filename, "w")) != NULL)
   {     
     for(i=prime; i<=ulti; i++)
       {    

         bzero(temp,sizeof(temp));
         sprintf(temp,"%s\n",Prog[i].Nom);
         fputs (temp, fs);        
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d\n",Prog[i].style,Prog[i].pattern,Prog[i].bpm,Prog[i].transpose);
         fputs (temp, fs);
         for (j=1; j<=4; j++)
         {
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d\n",Prog[i].progch[j],Prog[i].volume[j],Prog[i].BankLSB[j],Prog[i].BankMSB[j]);
         fputs (temp, fs);

         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d\n",Prog[i].pan[j],Prog[i].Pon[j],Prog[i].reverb[j],Prog[i].chorus[j]);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d\n",Prog[i].Ptime[j],Prog[i].OnOff[j],Prog[i].octa[j]);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d,%d,%d\n",0,0,0,0,0,0);
         fputs (temp, fs);
         }
        }
       fclose(fs);
      }

};


void
GMO::savesoundfile(int soundno, char *filename)
{
   

   FILE *fs;
   char temp[128];
   int i,j;
   GetCombiM(soundno);

   bzero(temp,sizeof(temp));
 
  if ((fs = fopen (filename, "w")) != NULL)
   {     
     for(i=prime; i<=ulti; i++)
       {    

         bzero(temp,sizeof(temp));
         sprintf(temp,"%s\n",Prog[i].Nom);
         fputs (temp, fs);        
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d\n",Prog[i].style,Prog[i].pattern,Prog[i].bpm,Prog[i].transpose);
         fputs (temp, fs);
	 bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d\n",v1lowVelocity,v1highVelocity,v1lowMidi,v1highMidi);
         fputs (temp, fs);
	 bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d\n",v2lowVelocity,v2highVelocity,v2lowMidi,v2highMidi);
         fputs (temp, fs);
	 bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d\n",v3lowVelocity,v3highVelocity,v3lowMidi,v3highMidi);
         fputs (temp, fs);
	 bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d\n",v4lowVelocity,v4highVelocity,v4lowMidi,v4highMidi);
         fputs (temp, fs);
         for (j=1; j<=4; j++)
         {
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d\n",Prog[i].progch[j],Prog[i].volume[j],Prog[i].BankLSB[j],Prog[i].BankMSB[j]);
//         sprintf(temp,"%d,%d,%d,%d\n",progch[j],Prog[i].volume[j],Prog[i].BankLSB[j],Prog[i].BankMSB[j]);
         fputs (temp, fs);

         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d\n",Prog[i].pan[j],Prog[i].Pon[j],Prog[i].reverb[j],Prog[i].chorus[j]);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d\n",Prog[i].Ptime[j],Prog[i].OnOff[j],Prog[i].octa[j]);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d,%d,%d\n",0,0,0,0,0,0);
         fputs (temp, fs);
         }
        }
       fclose(fs);
      }

};


void
GMO::savepatt(char *filename)
{
   
   FILE *fs;
   char temp[128];
   int w=0;   
   int NumRit,i,j;
   bzero(temp,sizeof(temp));
  cout << " savepatt: " << filename << endl; 
  if ((fs = fopen (filename, "w")) != NULL)
   {     
     for(NumRit=prime; NumRit<ulti; NumRit++)
       {    
         PonDrumTemp(NumRit);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%s\n",Rt[NumRit].Nom);
         fputs (temp, fs);        
  if (strcmp(Rt[NumRit].Nom, "Empty") != 0 )
         {
         if (Rt[NumRit].drBankM == 128) Rt[NumRit].drBankM = 1;
         bzero(temp,sizeof(temp));           
         sprintf(temp,"%s\n",Rt[NumRit].Nfile);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n",Rt[NumRit].bars,Rt[NumRit].blackn,Rt[NumRit].octavate,Rt[NumRit].acc2mode,Rt[NumRit].swing,Rt[NumRit].acc3mode,Rt[NumRit].acc4mode,Rt[NumRit].acc5mode,Rt[NumRit].octavate4,Rt[NumRit].terceras4,Rt[NumRit].sextas4);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf (temp,"%d,%d,%d,%d,%d,%d\n",Rt[NumRit].dron,Rt[NumRit].drpc,Rt[NumRit].drvol,Rt[NumRit].drpan,Rt[NumRit].drrev,Rt[NumRit].drcho);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf (temp,"%d,%d,%d,%d\n",Rt[NumRit].drocta,Rt[NumRit].drBankM,Rt[NumRit].drpon,Rt[NumRit].drptime);
         fputs (temp, fs); 
         bzero(temp,sizeof(temp));
         sprintf (temp,"%d,%d,%d,%d,%d,%d\n",Rt[NumRit].basson,Rt[NumRit].basspc,Rt[NumRit].bassvol,Rt[NumRit].basspan,Rt[NumRit].bassrev,Rt[NumRit].basscho);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf (temp,"%d,%d,%d,%d\n",Rt[NumRit].bassocta,Rt[NumRit].bassBankM,Rt[NumRit].basspon,Rt[NumRit].bassptime);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
	 Rt[NumRit].acc1on = 0;
         sprintf (temp,"%d,%d,%d,%d,%d,%d\n",Rt[NumRit].acc1on,Rt[NumRit].acc1pc,Rt[NumRit].acc1vol,Rt[NumRit].acc1pan,Rt[NumRit].acc1rev,Rt[NumRit].acc1cho);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf (temp,"%d,%d,%d,%d\n",Rt[NumRit].acc1octa,Rt[NumRit].acc1BankM,Rt[NumRit].acc1pon,Rt[NumRit].acc1ptime);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
	 Rt[NumRit].acc2on = 0;
         sprintf (temp,"%d,%d,%d,%d,%d,%d\n",Rt[NumRit].acc2on,Rt[NumRit].acc2pc,Rt[NumRit].acc2vol,Rt[NumRit].acc2pan,Rt[NumRit].acc2rev,Rt[NumRit].acc2cho);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf (temp,"%d,%d,%d,%d\n",Rt[NumRit].acc2octa,Rt[NumRit].acc2BankM,Rt[NumRit].acc2pon,Rt[NumRit].acc2ptime);
         fputs (temp, fs);

         bzero(temp,sizeof(temp));
	 Rt[NumRit].acc3on = 0;
         sprintf (temp,"%d,%d,%d,%d,%d,%d\n",Rt[NumRit].acc3on,Rt[NumRit].acc3pc,Rt[NumRit].acc3vol,Rt[NumRit].acc3pan,Rt[NumRit].acc3rev,Rt[NumRit].acc3cho);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf (temp,"%d,%d,%d,%d\n",Rt[NumRit].acc3octa,Rt[NumRit].acc3BankM,Rt[NumRit].acc3pon,Rt[NumRit].acc3ptime);
         fputs (temp, fs);

         bzero(temp,sizeof(temp));
	 Rt[NumRit].acc4on = 0;
         sprintf(temp,"%d,%d,%d,%d,%d,%d\n",Rt[NumRit].acc4on,Rt[NumRit].acc4pc,Rt[NumRit].acc4vol,Rt[NumRit].acc4pan,Rt[NumRit].acc4rev,Rt[NumRit].acc4cho);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d\n",Rt[NumRit].acc4octa,Rt[NumRit].acc4BankM,Rt[NumRit].acc4pon,Rt[NumRit].acc4ptime);
         fputs (temp, fs);

         bzero(temp,sizeof(temp));
	 Rt[NumRit].acc5on = 0;
         sprintf(temp,"%d,%d,%d,%d,%d,%d\n",Rt[NumRit].acc5on,Rt[NumRit].acc5pc,Rt[NumRit].acc5vol,Rt[NumRit].acc5pan,Rt[NumRit].acc5rev,Rt[NumRit].acc5cho);
         fputs (temp, fs);
         bzero(temp,sizeof(temp));
         sprintf(temp,"%d,%d,%d,%d\n",Rt[NumRit].acc5octa,Rt[NumRit].acc5BankM,Rt[NumRit].acc5pon,Rt[NumRit].acc5ptime);
         fputs (temp, fs);


         for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
         for (j=1; j<62; j++)
             {
              w = i*4;
              bzero(temp,sizeof(temp));
              sprintf(temp,"%d,%d,%d,%d\n",Edr[j][w+1],Edr[j][w+2],Edr[j][w+3],Edr[j][w+4]);
              fputs (temp, fs);
             } 
             }

             for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
             for (j=0; j<3; j++)
             {
              w = i*4;
              bzero(temp,sizeof(temp));
              sprintf(temp,"%d,%d,%d,%d\n",Rt[NumRit].basn[j][w+1],Rt[NumRit].basn[j][w+2],Rt[NumRit].basn[j][w+3],Rt[NumRit].basn[j][w+4]);
              fputs (temp, fs);
             }
             }
             
             for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
             for (j=0; j<2; j++)
             {
              w = i*4;
              bzero(temp,sizeof(temp));
              sprintf(temp,"%d,%d,%d,%d\n",Rt[NumRit].acc1n[j][w+1],Rt[NumRit].acc1n[j][w+2],Rt[NumRit].acc1n[j][w+3],Rt[NumRit].acc1n[j][w+4]);
              fputs (temp, fs);
             }
             }

             for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
             for (j=0; j<3; j++)
             {
              w = i*4;
              bzero(temp,sizeof(temp));
              sprintf(temp,"%d,%d,%d,%d\n",Rt[NumRit].acc2n[j][w+1],Rt[NumRit].acc2n[j][w+2],Rt[NumRit].acc2n[j][w+3],Rt[NumRit].acc2n[j][w+4]);
              fputs (temp, fs);
             }
             }
             
             for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
             for (j=0; j<3; j++)
             {
              w = i*4;
              bzero(temp,sizeof(temp));
              sprintf(temp,"%d,%d,%d,%d\n",Rt[NumRit].acc3n[j][w+1],Rt[NumRit].acc3n[j][w+2],Rt[NumRit].acc3n[j][w+3],Rt[NumRit].acc3n[j][w+4]);
              fputs (temp, fs);
             }
             }

             for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
             for (j=0; j<3; j++)
             {
              w = i*4;
              bzero(temp,sizeof(temp));
              sprintf(temp,"%d,%d,%d,%d\n",Rt[NumRit].acc4n[j][w+1],Rt[NumRit].acc4n[j][w+2],Rt[NumRit].acc4n[j][w+3],Rt[NumRit].acc4n[j][w+4]);
              fputs (temp, fs);
             }
             }
             
             for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
             for (j=0; j<3; j++)
             {
              w = i*4;
              bzero(temp,sizeof(temp));
              sprintf(temp,"%d,%d,%d,%d\n",Rt[NumRit].acc5n[j][w+1],Rt[NumRit].acc5n[j][w+2],Rt[NumRit].acc5n[j][w+3],Rt[NumRit].acc5n[j][w+4]);
              fputs (temp, fs);
             }
             }

              bzero(temp,sizeof(temp));

              sprintf(temp,"%d,%d,%d,%d,%d,%d,%d,%d\n",Rt[NumRit].terceras,Rt[NumRit].sextas,Rt[NumRit].bassstlt,Rt[NumRit].acc1stlt,Rt[NumRit].acc2stlt,Rt[NumRit].acc3stlt,Rt[NumRit].acc4stlt,Rt[NumRit].acc5stlt);
              fputs (temp, fs);

             for (i=0; i<Rt[NumRit].bars*Rt[NumRit].blackn; i++)
             {
             for (j=1; j<1000; j++)
             {
             if ( Rt[NumRit].EvMidCon[j].posicion != 0)
             {
             bzero(temp,sizeof(temp));
             sprintf(temp,"%d,%d,%d,%d\n",Rt[NumRit].EvMidCon[j].pista,Rt[NumRit].EvMidCon[j].controlador,Rt[NumRit].EvMidCon[j].posicion,Rt[NumRit].EvMidCon[j].valor);
             fputs (temp, fs);
             }
             }
             }
              bzero(temp, sizeof(temp));
              sprintf(temp, "-\n");
              fputs(temp,fs);


              for (j=1; j<=5; j++)
              {
              bzero(temp, sizeof(temp));
              sprintf(temp, "0\n");
              fputs(temp,fs);
              }
          }
          }

     fclose(fs);
  }



};


void
GMO::loadgmpl(char *filename)
{

 int i;
 FILE *fs;


 if ((fs = fopen (filename, "rb")) != NULL)
   {
   while (!feof(fs))
    {
    i = fread(&GP, sizeof(GP),1,fs);
    } 
   fclose(fs);
   }

};


void
GMO::savegmpl(char *filename)
{

 FILE *fs;
 if ((fs = fopen (filename, "wb")) != NULL)
   {
    fwrite(&GP, sizeof(GP),1,fs);
    fclose(fs);
   }

};


void
GMO::savesongplay(char *filename)
{

  FILE *fs;
   char temp[128];
   int i;
   bzero(temp,sizeof(temp));

  if ((fs = fopen (filename, "w")) != NULL)
   {
      bzero(temp,sizeof(temp));
      sprintf(temp,"%d\n",bpm);
      fputs(temp,fs);

     for(i=1; i<=grabaconta; i++)
       {
         bzero(temp,sizeof(temp));

sprintf(temp,"%d,%d,%d,%d,%d,%d,%d,%d,%d\n",EG[i].tipo,EG[i].tick,EG[i].nota,EG[i].canal,EG[i].velocity,EG[i].length,0,0,0);
         fputs(temp, fs);
       }
    fclose(fs);
   }

};



void
GMO::loadsongplay(char *filename)
{
   
  FILE *fs;
   char temp[128];
   int r;
   int i=1;

   bzero(temp,sizeof(temp));

  if ((fs = fopen (filename, "r")) != NULL)
   {
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp, "%d",&bpm);
        bzero (temp, sizeof (temp));
      while (fgets (temp, sizeof temp, fs) != NULL)
        {
          sscanf(temp,"%d,%d,%d,%d,%d,%d,%d,%d,%d\n",&EG[i].tipo,&EG[i].tick,&EG[i].nota,&EG[i].canal,&EG[i].velocity,&EG[i].length,&r,&r,&r);
          bzero(temp,sizeof(temp));
          i++;
        }
        grabaconta = i-1;
   }

};



void
GMO::loadpreset(char *filename)

{
  int i = 0, j = 0;
  for (i = 0; i <= 127; i++)
    {
      for (j = 0; j <= 127; j++)
        {
          PresetList[i].Banco = i;
          PresetList[i].PBanco[i].Prog = j;
        }
    }

  FILE *fp;
  char temp[256];
  int bb = 0, pp = 0;
  char nn[80];
  if ((fp = fopen (filename, "r")) != NULL)
    {

      bzero (temp, sizeof (temp));
      while (fgets (temp, sizeof temp, fp) != NULL)
        {
          sscanf (temp, "%d %d %[^]]c", &bb, &pp, (char*) nn);

            for (i = 0; i <=(int) strlen (temp); i++)
            PresetList[bb].PBanco[pp].ProgName[i] = nn[i];

        }
    }

};


void
GMO::loaddrumset(char *filename)
{
int  i = 0, j = 0, bb = 0 , pp = 0;
FILE *fp;
char temp[256];
char nn[80];
  for (i = 0; i <= 59; i++)
    {
      for (j = 27; j <= 88; j++)
        {
          PD[i].ProgD = i;
          PD[i].DNN[i].Note  = j;
        }
    }
  bb = 0;
  pp = 0;
  bzero (nn, sizeof(nn));
  if ((fp = fopen (filename, "r")) != NULL)
    {
      bzero (temp, sizeof (temp));
      while (fgets (temp, sizeof temp, fp) != NULL)
        {
          sscanf (temp, "%d %d %[^]]c", &bb, &pp, (char*) nn);
            for (i = 0; i <= (int)strlen (temp); i++)
            PD[bb].DNN[pp].Nom[i] = nn[i];
        }
    }
};

void
GMO::grabalib()
{
FILE *fs;

 char *filename;
 
  filename= strdup(LibStylesFilename);
   
  if ((fs = fopen (filename, "ab")) != NULL)
   {
    fwrite(&Register, sizeof(Register),1,fs);
    fclose(fs);
   }

};



void
GMO::GrabaSettings()
{

FILE *fn;
int i;
char *temp;
char t1[4];
char nomfile[256];
sprintf(nomfile,"%s%s",getenv("HOME"),"/.gmorgan");
fn = fopen(nomfile,"w");
temp = MidiInPuerto[1].SMidiIn;
if (temp == NULL ) temp= strdup(gettext("Not Connected"));
fputs(temp,fn);
fputs("\n",fn);
temp = MidiOutPuerto[1].SMidiOut;
if (temp == NULL) temp=strdup(gettext("Not Connected"));
fputs(temp,fn);
fputs("\n",fn);
temp = SoundsFilename;
if (temp == NULL) temp=strdup("0");
fputs(temp,fn);
fputs("\n",fn);
temp = PatternsFilename;
if (temp == NULL) temp=strdup("0");
fputs(temp,fn);
fputs("\n",fn);
temp = StylesFilename;
if (temp == NULL) temp=strdup("0");
fputs(temp,fn);
fputs("\n",fn);
temp = PresetFilename;
if (temp == NULL) temp=strdup("0");
fputs(temp,fn);
fputs("\n",fn);
temp = DrumNoteFilename;
if (temp == NULL) temp=strdup("0");
fputs(temp,fn);
fputs("\n",fn);
temp = SkinFilename;
if (temp == NULL) temp=strdup("0");
fputs(temp,fn);
fputs("\n",fn);
temp = SkinNombre;
if (temp == NULL) temp=strdup("0");
fputs(temp,fn);
fputs("\n",fn);
sprintf(t1,"%d",MutesOnOff);
fputs(t1,fn);
fputs("\n",fn);
temp = HelpFilename;
if (temp == NULL) temp=strdup("0");
fputs(temp,fn);
fputs("\n",fn);
temp = LibStylesFilename;
if (temp == NULL) temp=strdup("0");
fputs(temp,fn);
fputs("\n",fn);
for(i=0; i<=31; i++)
fputs("0\n",fn);
fclose(fn);
}
