-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_worksheet.ads,v $
--  Description     : GUI for the data base client
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/05/29 20:24:47 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;               use Ada.Strings.Unbounded;

with Gtk.Box;                             use Gtk.Box;
with Gtk.Event_Box;                       use Gtk.Event_Box;
with Gtk.Label;                           use Gtk.Label;
with Gtk.Notebook;                        use Gtk.Notebook;

with Contents_Handler;                    use Contents_Handler;

package GUI_Worksheet is

   Toplevel       : Gtk_Notebook;

   Unnamed_Buffer : constant Unbounded_String := Null_Unbounded_String;

   type Object is tagged private;
   type Handle is access all Object'Class;

   -- ******************************************************************** --
   -- **               C L A S S      I N T E R F A C E                 ** --
   -- ******************************************************************** --

   procedure Initialize(
      This : in out Object'Class );

   procedure Finalize(
      This : in out Object'Class );

   procedure Add_Sheet(
      This        : in out Object'Class;
      Handler     : Contents_Handler.Handle;
      Sheet_Name  : in Unbounded_String;
      Permanent   : in Boolean := False);

   procedure Remove_Sheet(
      Sheet_Name  : in Unbounded_String );

   procedure Remove_Sheet (
      This  : in out Object'Class );

   function Is_Open(
      Sheet_Name  : in Unbounded_String ) return Boolean;

   procedure Bring_In_Front(
      Sheet_Name : in Unbounded_String );

   type Allocator_Access is access function return Handle;

   procedure Register(
      Name  : in String;
      Alloc : in Allocator_Access );

   function Create(
      Name  : in String ) return Handle;

   function Contents(
      this  : in Object'Class ) return Contents_Handler.Handle;

   function Contents  return Contents_Handler.Handle;

   function Self(
      This : in Object'Class ) return Handle;

   -- ******************************************************************** --
   -- **          E X T E N D A B L E   I N T E R F A C E               ** --
   -- ******************************************************************** --

   procedure Command(
      This  : in out Object;
      Cmd   : in Natural );

   procedure Display(
      This  : in out Object;
      Box   : in out Gtk_Box );

   procedure Add_Command(
      This  : in out Object'Class;
      Text  : in String;
      Cmd   : in Natural );

private

   ------------------------
   -- Extended Event box --
   ------------------------
   type Sheet_Box_Record  is new Gtk_Event_Box_Record with record
         Sheet   : Handle                  := null ;
         Handler : Contents_Handler.Handle := null;
      end record;

   type Sheet_Box is access all Sheet_Box_Record;

   type Object is tagged record
         Label       : Gtk_Label;
         SheetBox    : Sheet_Box;
         Vbox        : Gtk_Box;
         Cbox        : Gtk_Box;
         Abox        : Gtk_Box;
         Buffer_Name : Unbounded_String        := Null_Unbounded_String;
         Handler     : Contents_Handler.Handle := null;
         Self        : Handle                  := null;
         Permanent   : Boolean                 := False;
      end record;

end GUI_Worksheet;
