--- ------------------------------------------------------------------------ --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/Makefile
--  Description     : Base class for all persistent objects                  --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 30-April-2005                                          --
--  Last Modified By: $Author: merdmann $                                    --
--  Last Modified On: $Date: 2007/02/03 14:59:52 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2005 Michael Erdmann                                       --
--                                                                           --
--  GNADE is copyrighted by the persons and institutions enumerated in the   --
--  AUTHORS file. This file is located in the root directory of the          --
--  GNADE distribution.                                                      --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNADE;  see file COPYING. If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from      --
--  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
--  files  to produce an executable, these  units or libraries do not by     --
--  itself cause the resulting  executable  to  be covered  by the  GNU      --
--  General  Public  License.  This exception does not however invalidate    --
--  any other reasons why  the executable file  might be covered by the      --
--  GNU Public License.                                                      --
--                                                                           --
-- ------------------------------------------------------------------------- --

with Ada.Finalization;                  use Ada.Finalization;
use  Ada;

with Objects;				use Objects;
with SQL_Standard;			use SQL_Standard;
with Key_Type;				use Key_Type;
with TAM.Persistent;			use TAM.Persistent;


package Persistent is

   type Object_Type is ( Cached, Non_Cached );

   type Object is new TAM.Persistent.Object with private;

   type Handle is access all Object'Class;
   Null_Handle : constant Handle := null;

   ---------------------------------------------------------------------------
   -- Description:
   --    Get an object from the object data base
   -- Preconditions:
   --    P.1 - Database is connected
   -- Postconditions:
   -- Exceptions:
   -- Notes:
   ---------------------------------------------------------------------------
   procedure Get_Object(
      This    : in out Object'Class;
      Create  : in Boolean := False;
      Version : in Integer := Highest_Version;
      ID      : Integer := 0);

   procedure Get_Object(
      This    : in out Object'Class;
      Key     : Key_Type.Object'Class;
      Create  : in Boolean := False;
      Version : in Integer := Highest_Version );
   ---------------------------------------------------------------------------
   -- Description:
   --   Store an object in the underlying data base
   -- Preconditions:
   --   P.1 - Database is connected
   -- Postconditions:
   -- Exceptions:
   -- Notes:
   ---------------------------------------------------------------------------
   procedure Put_Object(
      This    : in out Object'Class;
      Create  : in Boolean := True );

   procedure Put_Object(
      This    : in out Object'Class;
      Key     : in Key_Type.Object'Class;
      Create  : in Boolean := True );

    procedure Relate(
       This     : in Object'Class;
       Other    : in Object'Class;
       Relation : in String );

    function Hash(
       This : in Object'Class ) return GNADE.BINARY;

   -- ======================================================================= --
private

   type Object is new TAM.Persistent.Object with record
         Version : Integer := 0;
         Mode    : Object_Type := Cached;
   end record;

    procedure Initialize(
       This : in out Object );

    procedure Finalize(
       This : in out Object );



end Persistent;
