------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2006 Dmitriy Anisimkov.                                   --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: invalid.adb,v 1.1 2006/06/16 09:03:14 vagul Exp $

--  Example of invalid statement.

with
   Ada.Text_IO,
   OCI.Thick.Connections,
   OCI.Thick.Statements;

procedure Invalid is
   use OCI.Thick;
   use Ada.Text_IO;

   Connect : Connections.Connection := Connections.Logon
     (Server_Name => "",
      User        => "scott",
      Password    => "tiger");
   --  Using the OCI.Thick.Connections package.
   --  Logon to the database and creating database connection

   Stmt_Text : String := "eeeeeselect "
       & "OBJECT_NAME, " --  VARCHAR2(128)
       & "OBJECT_TYPE, " --  VARCHAR2(18)
       & "OBJECT_ID, "   --  NUMBER
       & "CREATED "      --  DATE
       & "from user_objects where STATUS";

   Stmt : Statements.Statement;

begin
   --  We can see the server version information.

   Put_Line (Connections.Server_Version (Connect));
   New_Line;

   Stmt := Statements.Prepare (Connect, Stmt_Text);

   Put_Line (Statements.Statement_Type'Image
               (Statements.Type_Of_Statement (Stmt)));

   Statements.Execute (Stmt);
end Invalid;
