with GNAT.Source_Info;
with Ada.Text_IO; use Ada.Text_IO;
with Ada.Directories; use Ada.Directories;

package body GNU.Db.Sqlite3.Tests.Testcases.Tc_000_Basic is
   use AUnit.Test_Cases.Registration;
   use AUnit.Assertions;
   ----------
   -- Name --
   ----------
   Db_Name  : constant String := Base_Name (GNAT.Source_Info.File) & ".db";
   TxT_Name : constant String := Base_Name (GNAT.Source_Info.File) & ".txt";
   function Name (T : Test_Case)
                  return Message_String is
      pragma Unreferenced (T);
   begin
      return Format (GNAT.Source_Info.File);
   end Name;


   -------------------------
   --  t_open
   -------------------------
   procedure T_Open (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
   begin
      T.Db.Open (Db_Name);
   end T_Open;

   -------------------------
   --  t_create
   -------------------------
   procedure T_Create (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
   begin
      T.Db.Exec ("CREATE TABLE demo(bla INT, ble INT, blo INT);");
   end T_Create;

   -------------------------
   --  t_fill
   -------------------------
   procedure T_Fill (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
   begin
      for I in 1 .. 10 loop
         T.Db.Exec ("INSERT INTO demo VALUES(" & I'Img & ", 200, 300);");
      end loop;
   end T_Fill;
   -------------------------
   --  t_dump
   -------------------------
   procedure T_Dump (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
      F : Ada.Text_IO.File_Type;
      function List
        (Argc        : Integer;
         Argv        : String_Vectors.Vector;
         ColumnNames : String_Vectors.Vector)
         return Return_Value is
      begin
         for I in 0 .. Argc loop
            Put_Line (F, ColumnNames.Element (I)  & ": " & Argv.Element (I));
         end loop;

         return SQLITE_OK;
      end List;
   begin
      Create (F, Out_File, TxT_Name);
      T.Db.Exec ("SELECT * FROM demo where bla > 4;", List'Unrestricted_Access);
      Close (F);
   end T_Dump;
   -------------------------
   --  t_drop
   -------------------------
   procedure T_Drop (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
   begin
      T.Db.Exec ("DROP TABLE demo;");
   end T_Drop;
   -------------------------
   --  t_close
   -------------------------
   procedure T_Close (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
   begin
      T.Db.Close;
   end T_Close;
   --------------------
   -- Register_Tests --
   --------------------

   procedure Register_Tests (T : in out Test_Case) is
   begin
      Register_Routine (T, T_Open'Access, "T_Open");
      Register_Routine (T, T_Create'Access, "T_Create");
      Register_Routine (T, T_Fill'Access, "T_Fill");
      Register_Routine (T, T_Dump'Access, "T_Dump");
      Register_Routine (T, T_Drop'Access, "T_Drop");
      Register_Routine (T, T_Close'Access, "T_Close");
   end Register_Tests;
   procedure Set_Up_Case (Test : in out Test_Case) is
      pragma Unreferenced (Test);
   begin
      if Ada.Directories.Exists (Db_Name) then
         Ada.Directories.Delete_File (Db_Name);
      end if;
   end Set_Up_Case;
end GNU.DB.SQLite3.Tests.Testcases.Tc_000_Basic;
