// Code generated by smithy-go-codegen DO NOT EDIT.

package backup

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/backup/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of restore testing selections. Can be filtered by MaxResults and
// RestoreTestingPlanName .
func (c *Client) ListRestoreTestingSelections(ctx context.Context, params *ListRestoreTestingSelectionsInput, optFns ...func(*Options)) (*ListRestoreTestingSelectionsOutput, error) {
	if params == nil {
		params = &ListRestoreTestingSelectionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRestoreTestingSelections", params, optFns, c.addOperationListRestoreTestingSelectionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRestoreTestingSelectionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRestoreTestingSelectionsInput struct {

	// Returns restore testing selections by the specified restore testing plan name.
	//
	// This member is required.
	RestoreTestingPlanName *string

	// The maximum number of items to be returned.
	MaxResults *int32

	// The next item following a partial list of returned items. For example, if a
	// request is made to return MaxResults number of items, NextToken allows you to
	// return more items in your list starting at the location pointed to by the
	// nexttoken.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRestoreTestingSelectionsOutput struct {

	// The returned restore testing selections associated with the restore testing
	// plan.
	//
	// This member is required.
	RestoreTestingSelections []types.RestoreTestingSelectionForList

	// The next item following a partial list of returned items. For example, if a
	// request is made to return MaxResults number of items, NextToken allows you to
	// return more items in your list starting at the location pointed to by the
	// nexttoken.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRestoreTestingSelectionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRestoreTestingSelections{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRestoreTestingSelections{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRestoreTestingSelections"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListRestoreTestingSelectionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRestoreTestingSelections(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListRestoreTestingSelectionsAPIClient is a client that implements the
// ListRestoreTestingSelections operation.
type ListRestoreTestingSelectionsAPIClient interface {
	ListRestoreTestingSelections(context.Context, *ListRestoreTestingSelectionsInput, ...func(*Options)) (*ListRestoreTestingSelectionsOutput, error)
}

var _ ListRestoreTestingSelectionsAPIClient = (*Client)(nil)

// ListRestoreTestingSelectionsPaginatorOptions is the paginator options for
// ListRestoreTestingSelections
type ListRestoreTestingSelectionsPaginatorOptions struct {
	// The maximum number of items to be returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRestoreTestingSelectionsPaginator is a paginator for
// ListRestoreTestingSelections
type ListRestoreTestingSelectionsPaginator struct {
	options   ListRestoreTestingSelectionsPaginatorOptions
	client    ListRestoreTestingSelectionsAPIClient
	params    *ListRestoreTestingSelectionsInput
	nextToken *string
	firstPage bool
}

// NewListRestoreTestingSelectionsPaginator returns a new
// ListRestoreTestingSelectionsPaginator
func NewListRestoreTestingSelectionsPaginator(client ListRestoreTestingSelectionsAPIClient, params *ListRestoreTestingSelectionsInput, optFns ...func(*ListRestoreTestingSelectionsPaginatorOptions)) *ListRestoreTestingSelectionsPaginator {
	if params == nil {
		params = &ListRestoreTestingSelectionsInput{}
	}

	options := ListRestoreTestingSelectionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRestoreTestingSelectionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRestoreTestingSelectionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRestoreTestingSelections page.
func (p *ListRestoreTestingSelectionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRestoreTestingSelectionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListRestoreTestingSelections(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListRestoreTestingSelections(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRestoreTestingSelections",
	}
}
