// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the properties associated with a model-customization job, including
// the status of the job. For more information, see Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Bedrock User Guide.
func (c *Client) GetModelCustomizationJob(ctx context.Context, params *GetModelCustomizationJobInput, optFns ...func(*Options)) (*GetModelCustomizationJobOutput, error) {
	if params == nil {
		params = &GetModelCustomizationJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetModelCustomizationJob", params, optFns, c.addOperationGetModelCustomizationJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetModelCustomizationJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetModelCustomizationJobInput struct {

	// Identifier for the customization job.
	//
	// This member is required.
	JobIdentifier *string

	noSmithyDocumentSerde
}

type GetModelCustomizationJobOutput struct {

	// ARN of the base model.
	//
	// This member is required.
	BaseModelArn *string

	// Time that the resource was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The hyperparameter values for the job. For information about hyperparameters
	// for specific models, see Guidelines for model customization (https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-guidelines.html)
	// .
	//
	// This member is required.
	HyperParameters map[string]string

	// The ARN of the customization job.
	//
	// This member is required.
	JobArn *string

	// The name of the customization job.
	//
	// This member is required.
	JobName *string

	// Output data configuration
	//
	// This member is required.
	OutputDataConfig *types.OutputDataConfig

	// The name of the output model.
	//
	// This member is required.
	OutputModelName *string

	// The ARN of the IAM role.
	//
	// This member is required.
	RoleArn *string

	// S3 Location of the training data.
	//
	// This member is required.
	TrainingDataConfig *types.TrainingDataConfig

	// Array of up to 10 validators.
	//
	// This member is required.
	ValidationDataConfig *types.ValidationDataConfig

	// The token that you specified in the CreateCustomizationJob request.
	ClientRequestToken *string

	// The type of model customization.
	CustomizationType types.CustomizationType

	// Time that the resource transitioned to terminal state.
	EndTime *time.Time

	// Information about why the job failed.
	FailureMessage *string

	// Time that the resource was last modified.
	LastModifiedTime *time.Time

	// The ARN of the output model.
	OutputModelArn *string

	// The custom model is encrypted at rest using this key.
	OutputModelKmsKeyArn *string

	// The status of the job. A successful job transitions from in-progress to
	// completed when the output model is ready to use. If the job failed, the failure
	// message contains information about why the job failed.
	Status types.ModelCustomizationJobStatus

	// Metrics associated with the custom job.
	TrainingMetrics *types.TrainingMetrics

	// The loss metric for each validator that you provided in the createjob request.
	ValidationMetrics []types.ValidatorMetric

	// VPC configuration for the custom model job.
	VpcConfig *types.VpcConfig

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetModelCustomizationJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetModelCustomizationJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetModelCustomizationJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetModelCustomizationJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetModelCustomizationJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetModelCustomizationJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetModelCustomizationJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetModelCustomizationJob",
	}
}
