// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A name value pair that describes an aspect of an account.
type AccountAttribute struct {

	// The name of the attribute.
	AttributeName *string

	// A list of attribute values.
	AttributeValues []AttributeValueTarget

	noSmithyDocumentSerde
}

// Describes an Amazon Web Services account authorized to restore a snapshot.
type AccountWithRestoreAccess struct {

	// The identifier of an Amazon Web Services support account authorized to restore
	// a snapshot. For Amazon Web Services Support, the identifier is
	// amazon-redshift-support .
	AccountAlias *string

	// The identifier of an Amazon Web Services account authorized to restore a
	// snapshot.
	AccountId *string

	noSmithyDocumentSerde
}

// The operation that uses this structure is retired. Amazon Redshift
// automatically determines whether to use AQUA (Advanced Query Accelerator).
type AquaConfiguration struct {

	// This field is retired. Amazon Redshift automatically determines whether to use
	// AQUA (Advanced Query Accelerator).
	AquaConfigurationStatus AquaConfigurationStatus

	// This field is retired. Amazon Redshift automatically determines whether to use
	// AQUA (Advanced Query Accelerator).
	AquaStatus AquaStatus

	noSmithyDocumentSerde
}

// Contains information about the custom domain name association.
type Association struct {

	// A list of all associated clusters and domain names tied to a specific
	// certificate.
	CertificateAssociations []CertificateAssociation

	// The Amazon Resource Name (ARN) for the certificate associated with the custom
	// domain.
	CustomDomainCertificateArn *string

	// The expiration date for the certificate.
	CustomDomainCertificateExpiryDate *time.Time

	noSmithyDocumentSerde
}

// Describes an attribute value.
type AttributeValueTarget struct {

	// The value of the attribute.
	AttributeValue *string

	noSmithyDocumentSerde
}

// Describes an authentication profile.
type AuthenticationProfile struct {

	// The content of the authentication profile in JSON format. The maximum length of
	// the JSON string is determined by a quota for your account.
	AuthenticationProfileContent *string

	// The name of the authentication profile.
	AuthenticationProfileName *string

	noSmithyDocumentSerde
}

// The authorized token issuer for the Amazon Redshift IAM Identity Center
// application.
type AuthorizedTokenIssuer struct {

	// The list of audiences for the authorized token issuer for integrating Amazon
	// Redshift with IDC Identity Center.
	AuthorizedAudiencesList []string

	// The ARN for the authorized token issuer for integrating Amazon Redshift with
	// IDC Identity Center.
	TrustedTokenIssuerArn *string

	noSmithyDocumentSerde
}

// Describes an availability zone.
type AvailabilityZone struct {

	// The name of the availability zone.
	Name *string

	//
	SupportedPlatforms []SupportedPlatform

	noSmithyDocumentSerde
}

// A cluster ID and custom domain name tied to a specific certificate. These are
// typically returned in a list.
type CertificateAssociation struct {

	// The cluster identifier for the certificate association.
	ClusterIdentifier *string

	// The custom domain name for the certificate association.
	CustomDomainName *string

	noSmithyDocumentSerde
}

// Describes a cluster.
type Cluster struct {

	// A boolean value that, if true , indicates that major version upgrades will be
	// applied automatically to the cluster during the maintenance window.
	AllowVersionUpgrade *bool

	// This field is retired. Amazon Redshift automatically determines whether to use
	// AQUA (Advanced Query Accelerator).
	AquaConfiguration *AquaConfiguration

	// The number of days that automatic cluster snapshots are retained.
	AutomatedSnapshotRetentionPeriod *int32

	// The name of the Availability Zone in which the cluster is located.
	AvailabilityZone *string

	// Describes the status of the Availability Zone relocation operation.
	AvailabilityZoneRelocationStatus *string

	// The availability status of the cluster for queries. Possible values are the
	// following:
	//   - Available - The cluster is available for queries.
	//   - Unavailable - The cluster is not available for queries.
	//   - Maintenance - The cluster is intermittently available for queries due to
	//   maintenance activities.
	//   - Modifying - The cluster is intermittently available for queries due to
	//   changes that modify the cluster.
	//   - Failed - The cluster failed and is not available for queries.
	ClusterAvailabilityStatus *string

	// The date and time that the cluster was created.
	ClusterCreateTime *time.Time

	// The unique identifier of the cluster.
	ClusterIdentifier *string

	// The namespace Amazon Resource Name (ARN) of the cluster.
	ClusterNamespaceArn *string

	// The nodes in the cluster.
	ClusterNodes []ClusterNode

	// The list of cluster parameter groups that are associated with this cluster.
	// Each parameter group in the list is returned with its status.
	ClusterParameterGroups []ClusterParameterGroupStatus

	// The public key for the cluster.
	ClusterPublicKey *string

	// The specific revision number of the database in the cluster.
	ClusterRevisionNumber *string

	// A list of cluster security group that are associated with the cluster. Each
	// security group is represented by an element that contains
	// ClusterSecurityGroup.Name and ClusterSecurityGroup.Status subelements. Cluster
	// security groups are used when the cluster is not created in an Amazon Virtual
	// Private Cloud (VPC). Clusters that are created in a VPC use VPC security groups,
	// which are listed by the VpcSecurityGroups parameter.
	ClusterSecurityGroups []ClusterSecurityGroupMembership

	// A value that returns the destination region and retention period that are
	// configured for cross-region snapshot copy.
	ClusterSnapshotCopyStatus *ClusterSnapshotCopyStatus

	// The current state of the cluster. Possible values are the following:
	//   - available
	//   - available, prep-for-resize
	//   - available, resize-cleanup
	//   - cancelling-resize
	//   - creating
	//   - deleting
	//   - final-snapshot
	//   - hardware-failure
	//   - incompatible-hsm
	//   - incompatible-network
	//   - incompatible-parameters
	//   - incompatible-restore
	//   - modifying
	//   - paused
	//   - rebooting
	//   - renaming
	//   - resizing
	//   - rotating-keys
	//   - storage-full
	//   - updating-hsm
	ClusterStatus *string

	// The name of the subnet group that is associated with the cluster. This
	// parameter is valid only when the cluster is in a VPC.
	ClusterSubnetGroupName *string

	// The version ID of the Amazon Redshift engine that is running on the cluster.
	ClusterVersion *string

	// The certificate Amazon Resource Name (ARN) for the custom domain name.
	CustomDomainCertificateArn *string

	// The expiration date for the certificate associated with the custom domain name.
	CustomDomainCertificateExpiryDate *time.Time

	// The custom domain name associated with the cluster.
	CustomDomainName *string

	// The name of the initial database that was created when the cluster was created.
	// This same name is returned for the life of the cluster. If an initial database
	// was not specified, a database named dev dev was created by default.
	DBName *string

	//
	DataTransferProgress *DataTransferProgress

	// The Amazon Resource Name (ARN) for the IAM role set as default for the cluster.
	DefaultIamRoleArn *string

	// Describes a group of DeferredMaintenanceWindow objects.
	DeferredMaintenanceWindows []DeferredMaintenanceWindow

	// The status of the elastic IP (EIP) address.
	ElasticIpStatus *ElasticIpStatus

	// The number of nodes that you can resize the cluster to with the elastic resize
	// method.
	ElasticResizeNumberOfNodeOptions *string

	// A boolean value that, if true , indicates that data in the cluster is encrypted
	// at rest.
	Encrypted *bool

	// The connection endpoint.
	Endpoint *Endpoint

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the cluster
	// must be in a VPC. For more information, see Enhanced VPC Routing (https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide. If this option is true ,
	// enhanced VPC routing is enabled. Default: false
	EnhancedVpcRouting *bool

	// The date and time when the next snapshot is expected to be taken for clusters
	// with a valid snapshot schedule and backups enabled.
	ExpectedNextSnapshotScheduleTime *time.Time

	// The status of next expected snapshot for clusters having a valid snapshot
	// schedule and backups enabled. Possible values are the following:
	//   - OnTrack - The next snapshot is expected to be taken on time.
	//   - Pending - The next snapshot is pending to be taken.
	ExpectedNextSnapshotScheduleTimeStatus *string

	// A value that reports whether the Amazon Redshift cluster has finished applying
	// any hardware security module (HSM) settings changes specified in a modify
	// cluster command. Values: active, applying
	HsmStatus *HsmStatus

	// A list of Identity and Access Management (IAM) roles that can be used by the
	// cluster to access other Amazon Web Services services.
	IamRoles []ClusterIamRole

	// The IP address type for the cluster. Possible values are ipv4 and dualstack .
	IpAddressType *string

	// The Key Management Service (KMS) key ID of the encryption key used to encrypt
	// data in the cluster.
	KmsKeyId *string

	// The name of the maintenance track for the cluster.
	MaintenanceTrackName *string

	// The default number of days to retain a manual snapshot. If the value is -1, the
	// snapshot is retained indefinitely. This setting doesn't change the retention
	// period of existing snapshots. The value must be either -1 or an integer between
	// 1 and 3,653.
	ManualSnapshotRetentionPeriod *int32

	// The Amazon Resource Name (ARN) for the cluster's admin user credentials secret.
	MasterPasswordSecretArn *string

	// The ID of the Key Management Service (KMS) key used to encrypt and store the
	// cluster's admin credentials secret.
	MasterPasswordSecretKmsKeyId *string

	// The admin user name for the cluster. This name is used to connect to the
	// database that is specified in the DBName parameter.
	MasterUsername *string

	// The status of a modify operation, if any, initiated for the cluster.
	ModifyStatus *string

	// A boolean value that, if true, indicates that the cluster is deployed in two
	// Availability Zones.
	MultiAZ *string

	// The secondary compute unit of a cluster, if Multi-AZ deployment is turned on.
	MultiAZSecondary *SecondaryClusterInfo

	// The date and time in UTC when system maintenance can begin.
	NextMaintenanceWindowStartTime *time.Time

	// The node type for the nodes in the cluster.
	NodeType *string

	// The number of compute nodes in the cluster.
	NumberOfNodes *int32

	// Cluster operations that are waiting to be started.
	PendingActions []string

	// A value that, if present, indicates that changes to the cluster are pending.
	// Specific pending changes are identified by subelements.
	PendingModifiedValues *PendingModifiedValues

	// The weekly time range, in Universal Coordinated Time (UTC), during which system
	// maintenance can occur.
	PreferredMaintenanceWindow *string

	// A boolean value that, if true , indicates that the cluster can be accessed from
	// a public network.
	PubliclyAccessible *bool

	// The status of the reserved-node exchange request. Statuses include in-progress
	// and requested.
	ReservedNodeExchangeStatus *ReservedNodeExchangeStatus

	// Returns the following:
	//   - AllowCancelResize: a boolean value indicating if the resize operation can
	//   be cancelled.
	//   - ResizeType: Returns ClassicResize
	ResizeInfo *ResizeInfo

	// A value that describes the status of a cluster restore action. This parameter
	// returns null if the cluster was not created by restoring a snapshot.
	RestoreStatus *RestoreStatus

	// A unique identifier for the cluster snapshot schedule.
	SnapshotScheduleIdentifier *string

	// The current state of the cluster snapshot schedule.
	SnapshotScheduleState ScheduleState

	// The list of tags for the cluster.
	Tags []Tag

	// The total storage capacity of the cluster in megabytes.
	TotalStorageCapacityInMegaBytes *int64

	// The identifier of the VPC the cluster is in, if the cluster is in a VPC.
	VpcId *string

	// A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are
	// associated with the cluster. This parameter is returned only if the cluster is
	// in a VPC.
	VpcSecurityGroups []VpcSecurityGroupMembership

	noSmithyDocumentSerde
}

type ClusterAssociatedToSchedule struct {

	//
	ClusterIdentifier *string

	//
	ScheduleAssociationState ScheduleState

	noSmithyDocumentSerde
}

// Describes a ClusterDbRevision .
type ClusterDbRevision struct {

	// The unique identifier of the cluster.
	ClusterIdentifier *string

	// A string representing the current cluster version.
	CurrentDatabaseRevision *string

	// The date on which the database revision was released.
	DatabaseRevisionReleaseDate *time.Time

	// A list of RevisionTarget objects, where each object describes the database
	// revision that a cluster can be updated to.
	RevisionTargets []RevisionTarget

	noSmithyDocumentSerde
}

// An Identity and Access Management (IAM) role that can be used by the associated
// Amazon Redshift cluster to access other Amazon Web Services services.
type ClusterIamRole struct {

	// A value that describes the status of the IAM role's association with an Amazon
	// Redshift cluster. The following are possible statuses and descriptions.
	//   - in-sync : The role is available for use by the cluster.
	//   - adding : The role is in the process of being associated with the cluster.
	//   - removing : The role is in the process of being disassociated with the
	//   cluster.
	ApplyStatus *string

	// The Amazon Resource Name (ARN) of the IAM role, for example,
	// arn:aws:iam::123456789012:role/RedshiftCopyUnload .
	IamRoleArn *string

	noSmithyDocumentSerde
}

// The identifier of a node in a cluster.
type ClusterNode struct {

	// Whether the node is a leader node or a compute node.
	NodeRole *string

	// The private IP address of a node within a cluster.
	PrivateIPAddress *string

	// The public IP address of a node within a cluster.
	PublicIPAddress *string

	noSmithyDocumentSerde
}

// Describes a parameter group.
type ClusterParameterGroup struct {

	// The description of the parameter group.
	Description *string

	// The name of the cluster parameter group family that this cluster parameter
	// group is compatible with.
	ParameterGroupFamily *string

	// The name of the cluster parameter group.
	ParameterGroupName *string

	// The list of tags for the cluster parameter group.
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes the status of a parameter group.
type ClusterParameterGroupStatus struct {

	// The list of parameter statuses. For more information about parameters and
	// parameter groups, go to Amazon Redshift Parameter Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	// in the Amazon Redshift Cluster Management Guide.
	ClusterParameterStatusList []ClusterParameterStatus

	// The status of parameter updates.
	ParameterApplyStatus *string

	// The name of the cluster parameter group.
	ParameterGroupName *string

	noSmithyDocumentSerde
}

// Describes the status of a parameter group.
type ClusterParameterStatus struct {

	// The error that prevented the parameter from being applied to the database.
	ParameterApplyErrorDescription *string

	// The status of the parameter that indicates whether the parameter is in sync
	// with the database, waiting for a cluster reboot, or encountered an error when
	// being applied. The following are possible statuses and descriptions.
	//   - in-sync : The parameter value is in sync with the database.
	//   - pending-reboot : The parameter value will be applied after the cluster
	//   reboots.
	//   - applying : The parameter value is being applied to the database.
	//   - invalid-parameter : Cannot apply the parameter value because it has an
	//   invalid value or syntax.
	//   - apply-deferred : The parameter contains static property changes. The changes
	//   are deferred until the cluster reboots.
	//   - apply-error : Cannot connect to the cluster. The parameter change will be
	//   applied after the cluster reboots.
	//   - unknown-error : Cannot apply the parameter change right now. The change will
	//   be applied after the cluster reboots.
	ParameterApplyStatus *string

	// The name of the parameter.
	ParameterName *string

	noSmithyDocumentSerde
}

// Describes a security group.
type ClusterSecurityGroup struct {

	// The name of the cluster security group to which the operation was applied.
	ClusterSecurityGroupName *string

	// A description of the security group.
	Description *string

	// A list of EC2 security groups that are permitted to access clusters associated
	// with this cluster security group.
	EC2SecurityGroups []EC2SecurityGroup

	// A list of IP ranges (CIDR blocks) that are permitted to access clusters
	// associated with this cluster security group.
	IPRanges []IPRange

	// The list of tags for the cluster security group.
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes a cluster security group.
type ClusterSecurityGroupMembership struct {

	// The name of the cluster security group.
	ClusterSecurityGroupName *string

	// The status of the cluster security group.
	Status *string

	noSmithyDocumentSerde
}

// Returns the destination region and retention period that are configured for
// cross-region snapshot copy.
type ClusterSnapshotCopyStatus struct {

	// The destination region that snapshots are automatically copied to when
	// cross-region snapshot copy is enabled.
	DestinationRegion *string

	// The number of days that automated snapshots are retained in the destination
	// region after they are copied from a source region. If the value is -1, the
	// manual snapshot is retained indefinitely. The value must be either -1 or an
	// integer between 1 and 3,653.
	ManualSnapshotRetentionPeriod *int32

	// The number of days that automated snapshots are retained in the destination
	// region after they are copied from a source region.
	RetentionPeriod *int64

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string

	noSmithyDocumentSerde
}

// Describes a subnet group.
type ClusterSubnetGroup struct {

	// The name of the cluster subnet group.
	ClusterSubnetGroupName *string

	// The description of the cluster subnet group.
	Description *string

	// The status of the cluster subnet group. Possible values are Complete ,
	// Incomplete and Invalid .
	SubnetGroupStatus *string

	// A list of the VPC Subnet elements.
	Subnets []Subnet

	// The IP address types supported by this cluster subnet group. Possible values
	// are ipv4 and dualstack .
	SupportedClusterIpAddressTypes []string

	// The list of tags for the cluster subnet group.
	Tags []Tag

	// The VPC ID of the cluster subnet group.
	VpcId *string

	noSmithyDocumentSerde
}

// Describes a cluster version, including the parameter group family and
// description of the version.
type ClusterVersion struct {

	// The name of the cluster parameter group family for the cluster.
	ClusterParameterGroupFamily *string

	// The version number used by the cluster.
	ClusterVersion *string

	// The description of the cluster version.
	Description *string

	noSmithyDocumentSerde
}

type DataShare struct {

	// A value that specifies whether the datashare can be shared to a publicly
	// accessible cluster.
	AllowPubliclyAccessibleConsumers *bool

	// An Amazon Resource Name (ARN) that references the datashare that is owned by a
	// specific namespace of the producer cluster. A datashare ARN is in the
	// arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}
	// format.
	DataShareArn *string

	// A value that specifies when the datashare has an association between producer
	// and data consumers.
	DataShareAssociations []DataShareAssociation

	// The identifier of a datashare to show its managing entity.
	ManagedBy *string

	// The Amazon Resource Name (ARN) of the producer.
	ProducerArn *string

	noSmithyDocumentSerde
}

// The association of a datashare from a producer account with a data consumer.
type DataShareAssociation struct {

	// Specifies whether write operations were allowed during data share association.
	ConsumerAcceptedWrites *bool

	// The name of the consumer accounts that have an association with a producer
	// datashare.
	ConsumerIdentifier *string

	// The Amazon Web Services Region of the consumer accounts that have an
	// association with a producer datashare.
	ConsumerRegion *string

	// The creation date of the datashare that is associated.
	CreatedDate *time.Time

	// Specifies whether write operations were allowed during data share authorization.
	ProducerAllowedWrites *bool

	// The status of the datashare that is associated.
	Status DataShareStatus

	// The status change data of the datashare that is associated.
	StatusChangeDate *time.Time

	noSmithyDocumentSerde
}

// Describes the status of a cluster while it is in the process of resizing with
// an incremental resize.
type DataTransferProgress struct {

	// Describes the data transfer rate in MB's per second.
	CurrentRateInMegaBytesPerSecond *float64

	// Describes the total amount of data that has been transfered in MB's.
	DataTransferredInMegaBytes *int64

	// Describes the number of seconds that have elapsed during the data transfer.
	ElapsedTimeInSeconds *int64

	// Describes the estimated number of seconds remaining to complete the transfer.
	EstimatedTimeToCompletionInSeconds *int64

	// Describes the status of the cluster. While the transfer is in progress the
	// status is transferringdata .
	Status *string

	// Describes the total amount of data to be transfered in megabytes.
	TotalDataInMegaBytes *int64

	noSmithyDocumentSerde
}

// Describes the default cluster parameters for a parameter group family.
type DefaultClusterParameters struct {

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string

	// The name of the cluster parameter group family to which the engine default
	// parameters apply.
	ParameterGroupFamily *string

	// The list of cluster default parameters.
	Parameters []Parameter

	noSmithyDocumentSerde
}

// Describes a deferred maintenance window
type DeferredMaintenanceWindow struct {

	// A timestamp for the end of the time period when we defer maintenance.
	DeferMaintenanceEndTime *time.Time

	// A unique identifier for the maintenance window.
	DeferMaintenanceIdentifier *string

	// A timestamp for the beginning of the time period when we defer maintenance.
	DeferMaintenanceStartTime *time.Time

	noSmithyDocumentSerde
}

type DeleteClusterSnapshotMessage struct {

	// The unique identifier of the manual snapshot to be deleted. Constraints: Must
	// be the name of an existing snapshot that is in the available , failed , or
	// cancelled state.
	//
	// This member is required.
	SnapshotIdentifier *string

	// The unique identifier of the cluster the snapshot was created from. This
	// parameter is required if your IAM user has a policy containing a snapshot
	// resource element that specifies anything other than * for the cluster name.
	// Constraints: Must be the name of valid cluster.
	SnapshotClusterIdentifier *string

	noSmithyDocumentSerde
}

// Describes an Amazon EC2 security group.
type EC2SecurityGroup struct {

	// The name of the EC2 Security Group.
	EC2SecurityGroupName *string

	// The Amazon Web Services account ID of the owner of the EC2 security group
	// specified in the EC2SecurityGroupName field.
	EC2SecurityGroupOwnerId *string

	// The status of the EC2 security group.
	Status *string

	// The list of tags for the EC2 security group.
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes the status of the elastic IP (EIP) address.
type ElasticIpStatus struct {

	// The elastic IP (EIP) address for the cluster.
	ElasticIp *string

	// The status of the elastic IP (EIP) address.
	Status *string

	noSmithyDocumentSerde
}

// Describes a connection endpoint.
type Endpoint struct {

	// The DNS address of the Cluster.
	Address *string

	// The port that the database engine is listening on.
	Port *int32

	// Describes a connection endpoint.
	VpcEndpoints []VpcEndpoint

	noSmithyDocumentSerde
}

// Describes a Redshift-managed VPC endpoint.
type EndpointAccess struct {

	// The DNS address of the endpoint.
	Address *string

	// The cluster identifier of the cluster associated with the endpoint.
	ClusterIdentifier *string

	// The time (UTC) that the endpoint was created.
	EndpointCreateTime *time.Time

	// The name of the endpoint.
	EndpointName *string

	// The status of the endpoint.
	EndpointStatus *string

	// The port number on which the cluster accepts incoming connections.
	Port *int32

	// The Amazon Web Services account ID of the owner of the cluster.
	ResourceOwner *string

	// The subnet group name where Amazon Redshift chooses to deploy the endpoint.
	SubnetGroupName *string

	// The connection endpoint for connecting to an Amazon Redshift cluster through
	// the proxy.
	VpcEndpoint *VpcEndpoint

	// The security groups associated with the endpoint.
	VpcSecurityGroups []VpcSecurityGroupMembership

	noSmithyDocumentSerde
}

// Describes an endpoint authorization for authorizing Redshift-managed VPC
// endpoint access to a cluster across Amazon Web Services accounts.
type EndpointAuthorization struct {

	// Indicates whether all VPCs in the grantee account are allowed access to the
	// cluster.
	AllowedAllVPCs *bool

	// The VPCs allowed access to the cluster.
	AllowedVPCs []string

	// The time (UTC) when the authorization was created.
	AuthorizeTime *time.Time

	// The cluster identifier.
	ClusterIdentifier *string

	// The status of the cluster.
	ClusterStatus *string

	// The number of Redshift-managed VPC endpoints created for the authorization.
	EndpointCount *int32

	// The Amazon Web Services account ID of the grantee of the cluster.
	Grantee *string

	// The Amazon Web Services account ID of the cluster owner.
	Grantor *string

	// The status of the authorization action.
	Status AuthorizationStatus

	noSmithyDocumentSerde
}

// Describes an event.
type Event struct {

	// The date and time of the event.
	Date *time.Time

	// A list of the event categories. Values: Configuration, Management, Monitoring,
	// Security, Pending
	EventCategories []string

	// The identifier of the event.
	EventId *string

	// The text of this event.
	Message *string

	// The severity of the event. Values: ERROR, INFO
	Severity *string

	// The identifier for the source of the event.
	SourceIdentifier *string

	// The source type for this event.
	SourceType SourceType

	noSmithyDocumentSerde
}

// Describes event categories.
type EventCategoriesMap struct {

	// The events in the event category.
	Events []EventInfoMap

	// The source type, such as cluster or cluster-snapshot, that the returned
	// categories belong to.
	SourceType *string

	noSmithyDocumentSerde
}

// Describes event information.
type EventInfoMap struct {

	// The category of an Amazon Redshift event.
	EventCategories []string

	// The description of an Amazon Redshift event.
	EventDescription *string

	// The identifier of an Amazon Redshift event.
	EventId *string

	// The severity of the event. Values: ERROR, INFO
	Severity *string

	noSmithyDocumentSerde
}

// Describes event subscriptions.
type EventSubscription struct {

	// The name of the Amazon Redshift event notification subscription.
	CustSubscriptionId *string

	// The Amazon Web Services account associated with the Amazon Redshift event
	// notification subscription.
	CustomerAwsId *string

	// A boolean value indicating whether the subscription is enabled; true indicates
	// that the subscription is enabled.
	Enabled *bool

	// The list of Amazon Redshift event categories specified in the event
	// notification subscription. Values: Configuration, Management, Monitoring,
	// Security, Pending
	EventCategoriesList []string

	// The event severity specified in the Amazon Redshift event notification
	// subscription. Values: ERROR, INFO
	Severity *string

	// The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event
	// notification subscription.
	SnsTopicArn *string

	// A list of the sources that publish events to the Amazon Redshift event
	// notification subscription.
	SourceIdsList []string

	// The source type of the events returned by the Amazon Redshift event
	// notification, such as cluster, cluster-snapshot, cluster-parameter-group,
	// cluster-security-group, or scheduled-action.
	SourceType *string

	// The status of the Amazon Redshift event notification subscription. Constraints:
	//   - Can be one of the following: active | no-permission | topic-not-exist
	//   - The status "no-permission" indicates that Amazon Redshift no longer has
	//   permission to post to the Amazon SNS topic. The status "topic-not-exist"
	//   indicates that the topic was deleted after the subscription was created.
	Status *string

	// The date and time the Amazon Redshift event notification subscription was
	// created.
	SubscriptionCreationTime *time.Time

	// The list of tags for the event subscription.
	Tags []Tag

	noSmithyDocumentSerde
}

// Returns information about an HSM client certificate. The certificate is stored
// in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift
// cluster to encrypt data files.
type HsmClientCertificate struct {

	// The identifier of the HSM client certificate.
	HsmClientCertificateIdentifier *string

	// The public key that the Amazon Redshift cluster will use to connect to the HSM.
	// You must register the public key in the HSM.
	HsmClientCertificatePublicKey *string

	// The list of tags for the HSM client certificate.
	Tags []Tag

	noSmithyDocumentSerde
}

// Returns information about an HSM configuration, which is an object that
// describes to Amazon Redshift clusters the information they require to connect to
// an HSM where they can store database encryption keys.
type HsmConfiguration struct {

	// A text description of the HSM configuration.
	Description *string

	// The name of the Amazon Redshift HSM configuration.
	HsmConfigurationIdentifier *string

	// The IP address that the Amazon Redshift cluster must use to access the HSM.
	HsmIpAddress *string

	// The name of the partition in the HSM where the Amazon Redshift clusters will
	// store their database encryption keys.
	HsmPartitionName *string

	// The list of tags for the HSM configuration.
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes the status of changes to HSM settings.
type HsmStatus struct {

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string

	// Specifies the name of the HSM configuration that contains the information the
	// Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string

	// Reports whether the Amazon Redshift cluster has finished applying any HSM
	// settings changes specified in a modify cluster command. Values: active, applying
	Status *string

	noSmithyDocumentSerde
}

// The content of an inbound integration.
type InboundIntegration struct {

	// The creation time of an inbound integration.
	CreateTime *time.Time

	// The outstanding errors of an inbound integration. Each item is an
	// "IntegrationError". This is null if there is no error.
	Errors []IntegrationError

	// The Amazon Resource Name (ARN) of an inbound integration.
	IntegrationArn *string

	// The Amazon Resource Name (ARN) of the source of an inbound integration.
	SourceArn *string

	// The status of an inbound integration.
	Status ZeroETLIntegrationStatus

	// The Amazon Resource Name (ARN) of the target of an inbound integration.
	TargetArn *string

	noSmithyDocumentSerde
}

// The error of an inbound integration.
type IntegrationError struct {

	// The error code of an inbound integration error.
	//
	// This member is required.
	ErrorCode *string

	// The error message of an inbound integration error.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Describes an IP range used in a security group.
type IPRange struct {

	// The IP range in Classless Inter-Domain Routing (CIDR) notation.
	CIDRIP *string

	// The status of the IP range, for example, "authorized".
	Status *string

	// The list of tags for the IP range.
	Tags []Tag

	noSmithyDocumentSerde
}

// The Lake Formation scope.
type LakeFormationQuery struct {

	// Determines whether the query scope is enabled or disabled.
	//
	// This member is required.
	Authorization ServiceAuthorization

	noSmithyDocumentSerde
}

// A list of scopes set up for Lake Formation integration.
//
// The following types satisfy this interface:
//
//	LakeFormationScopeUnionMemberLakeFormationQuery
type LakeFormationScopeUnion interface {
	isLakeFormationScopeUnion()
}

// The Lake Formation scope.
type LakeFormationScopeUnionMemberLakeFormationQuery struct {
	Value LakeFormationQuery

	noSmithyDocumentSerde
}

func (*LakeFormationScopeUnionMemberLakeFormationQuery) isLakeFormationScopeUnion() {}

// Defines a maintenance track that determines which Amazon Redshift version to
// apply during a maintenance window. If the value for MaintenanceTrack is current
// , the cluster is updated to the most recently certified maintenance release. If
// the value is trailing , the cluster is updated to the previously certified
// maintenance release.
type MaintenanceTrack struct {

	// The version number for the cluster release.
	DatabaseVersion *string

	// The name of the maintenance track. Possible values are current and trailing .
	MaintenanceTrackName *string

	// An array of UpdateTarget objects to update with the maintenance track.
	UpdateTargets []UpdateTarget

	noSmithyDocumentSerde
}

// Describes a network interface.
type NetworkInterface struct {

	// The Availability Zone.
	AvailabilityZone *string

	// The IPv6 address of the network interface within the subnet.
	Ipv6Address *string

	// The network interface identifier.
	NetworkInterfaceId *string

	// The IPv4 address of the network interface within the subnet.
	PrivateIpAddress *string

	// The subnet identifier.
	SubnetId *string

	noSmithyDocumentSerde
}

// A list of node configurations.
type NodeConfigurationOption struct {

	// The estimated disk utilizaton percentage.
	EstimatedDiskUtilizationPercent *float64

	// The category of the node configuration recommendation.
	Mode Mode

	// The node type, such as, "ds2.8xlarge".
	NodeType *string

	// The number of nodes.
	NumberOfNodes *int32

	noSmithyDocumentSerde
}

// A set of elements to filter the returned node configurations.
type NodeConfigurationOptionsFilter struct {

	// The name of the element to filter.
	Name NodeConfigurationOptionsFilterName

	// The filter operator. If filter Name is NodeType only the 'in' operator is
	// supported. Provide one value to evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'.
	// Provide two values to evaluate for 'between'. Provide a list of values for 'in'.
	Operator OperatorType

	// List of values. Compare Name using Operator to Values. If filter Name is
	// NumberOfNodes, then values can range from 0 to 200. If filter Name is
	// EstimatedDiskUtilizationPercent, then values can range from 0 to 100. For
	// example, filter NumberOfNodes (name) GT (operator) 3 (values).
	Values []string

	noSmithyDocumentSerde
}

// Describes an orderable cluster option.
type OrderableClusterOption struct {

	// A list of availability zones for the orderable cluster.
	AvailabilityZones []AvailabilityZone

	// The cluster type, for example multi-node .
	ClusterType *string

	// The version of the orderable cluster.
	ClusterVersion *string

	// The node type for the orderable cluster.
	NodeType *string

	noSmithyDocumentSerde
}

// Describes a parameter in a cluster parameter group.
type Parameter struct {

	// The valid range of values for the parameter.
	AllowedValues *string

	// Specifies how to apply the WLM configuration parameter. Some properties can be
	// applied dynamically, while other properties require that any associated clusters
	// be rebooted for the configuration changes to be applied. For more information
	// about parameters and parameter groups, go to Amazon Redshift Parameter Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	// in the Amazon Redshift Cluster Management Guide.
	ApplyType ParameterApplyType

	// The data type of the parameter.
	DataType *string

	// A description of the parameter.
	Description *string

	// If true , the parameter can be modified. Some parameters have security or
	// operational implications that prevent them from being changed.
	IsModifiable *bool

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string

	// The name of the parameter.
	ParameterName *string

	// The value of the parameter. If ParameterName is wlm_json_configuration , then
	// the maximum size of ParameterValue is 8000 characters.
	ParameterValue *string

	// The source of the parameter value, such as "engine-default" or "user".
	Source *string

	noSmithyDocumentSerde
}

// Describes a partner integration.
type PartnerIntegrationInfo struct {

	// The date (UTC) that the partner integration was created.
	CreatedAt *time.Time

	// The name of the database that receives data from a partner.
	DatabaseName *string

	// The name of the partner.
	PartnerName *string

	// The partner integration status.
	Status PartnerIntegrationStatus

	// The status message provided by the partner.
	StatusMessage *string

	// The date (UTC) that the partner integration status was last updated by the
	// partner.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Describes a pause cluster operation. For example, a scheduled action to run the
// PauseCluster API operation.
type PauseClusterMessage struct {

	// The identifier of the cluster to be paused.
	//
	// This member is required.
	ClusterIdentifier *string

	noSmithyDocumentSerde
}

// Describes cluster attributes that are in a pending state. A change to one or
// more the attributes was requested and is in progress or will be applied.
type PendingModifiedValues struct {

	// The pending or in-progress change of the automated snapshot retention period.
	AutomatedSnapshotRetentionPeriod *int32

	// The pending or in-progress change of the new identifier for the cluster.
	ClusterIdentifier *string

	// The pending or in-progress change of the cluster type.
	ClusterType *string

	// The pending or in-progress change of the service version.
	ClusterVersion *string

	// The encryption type for a cluster. Possible values are: KMS and None.
	EncryptionType *string

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the cluster
	// must be in a VPC. For more information, see Enhanced VPC Routing (https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide. If this option is true ,
	// enhanced VPC routing is enabled. Default: false
	EnhancedVpcRouting *bool

	// The name of the maintenance track that the cluster will change to during the
	// next maintenance window.
	MaintenanceTrackName *string

	// The pending or in-progress change of the admin user password for the cluster.
	MasterUserPassword *string

	// The pending or in-progress change of the cluster's node type.
	NodeType *string

	// The pending or in-progress change of the number of nodes in the cluster.
	NumberOfNodes *int32

	// The pending or in-progress change of the ability to connect to the cluster from
	// the public network.
	PubliclyAccessible *bool

	noSmithyDocumentSerde
}

// Describes a recurring charge.
type RecurringCharge struct {

	// The amount charged per the period of time specified by the recurring charge
	// frequency.
	RecurringChargeAmount *float64

	// The frequency at which the recurring charge amount is applied.
	RecurringChargeFrequency *string

	noSmithyDocumentSerde
}

// Contains properties for the Redshift IDC application.
type RedshiftIdcApplication struct {

	// The authorized token issuer list for the Amazon Redshift IAM Identity Center
	// application.
	AuthorizedTokenIssuerList []AuthorizedTokenIssuer

	// The ARN for the Amazon Redshift IAM Identity Center application. It has the
	// required permissions to be assumed and invoke the IDC Identity Center API.
	IamRoleArn *string

	// The display name for the Amazon Redshift IAM Identity Center application. It
	// appears on the console.
	IdcDisplayName *string

	// The ARN for the IAM Identity Center instance that Redshift integrates with.
	IdcInstanceArn *string

	// The ARN for the Amazon Redshift IAM Identity Center application.
	IdcManagedApplicationArn *string

	// The onboarding status for the Amazon Redshift IAM Identity Center application.
	IdcOnboardStatus *string

	// The identity namespace for the Amazon Redshift IAM Identity Center application.
	// It determines which managed application verifies the connection token.
	IdentityNamespace *string

	// The ARN for the Redshift application that integrates with IAM Identity Center.
	RedshiftIdcApplicationArn *string

	// The name of the Redshift application in IAM Identity Center.
	RedshiftIdcApplicationName *string

	// A list of service integrations for the Redshift IAM Identity Center application.
	ServiceIntegrations []ServiceIntegrationsUnion

	noSmithyDocumentSerde
}

// Describes a reserved node. You can call the DescribeReservedNodeOfferings API
// to obtain the available reserved node offerings.
type ReservedNode struct {

	// The currency code for the reserved cluster.
	CurrencyCode *string

	// The duration of the node reservation in seconds.
	Duration *int32

	// The fixed cost Amazon Redshift charges you for this reserved node.
	FixedPrice *float64

	// The number of reserved compute nodes.
	NodeCount *int32

	// The node type of the reserved node.
	NodeType *string

	// The anticipated utilization of the reserved node, as defined in the reserved
	// node offering.
	OfferingType *string

	// The recurring charges for the reserved node.
	RecurringCharges []RecurringCharge

	// The unique identifier for the reservation.
	ReservedNodeId *string

	// The identifier for the reserved node offering.
	ReservedNodeOfferingId *string

	//
	ReservedNodeOfferingType ReservedNodeOfferingType

	// The time the reservation started. You purchase a reserved node offering for a
	// duration. This is the start time of that duration.
	StartTime *time.Time

	// The state of the reserved compute node. Possible Values:
	//   - pending-payment-This reserved node has recently been purchased, and the
	//   sale has been approved, but payment has not yet been confirmed.
	//   - active-This reserved node is owned by the caller and is available for use.
	//   - payment-failed-Payment failed for the purchase attempt.
	//   - retired-The reserved node is no longer available.
	//   - exchanging-The owner is exchanging the reserved node for another reserved
	//   node.
	State *string

	// The hourly rate Amazon Redshift charges you for this reserved node.
	UsagePrice *float64

	noSmithyDocumentSerde
}

// Details for a reserved-node exchange. Examples include the node type for a
// reserved node, the price for a node, the node's state, and other details.
type ReservedNodeConfigurationOption struct {

	// Describes a reserved node. You can call the DescribeReservedNodeOfferings API
	// to obtain the available reserved node offerings.
	SourceReservedNode *ReservedNode

	// The target reserved-node count.
	TargetReservedNodeCount *int32

	// Describes a reserved node offering.
	TargetReservedNodeOffering *ReservedNodeOffering

	noSmithyDocumentSerde
}

// Reserved-node status details, such as the source reserved-node identifier, the
// target reserved-node identifier, the node type, the node count, and other
// details.
type ReservedNodeExchangeStatus struct {

	// A date and time that indicate when the reserved-node exchange was requested.
	RequestTime *time.Time

	// The identifier of the reserved-node exchange request.
	ReservedNodeExchangeRequestId *string

	// The source reserved-node count in the cluster.
	SourceReservedNodeCount *int32

	// The identifier of the source reserved node.
	SourceReservedNodeId *string

	// The source reserved-node type, for example ds2.xlarge.
	SourceReservedNodeType *string

	// The status of the reserved-node exchange request. Statuses include in-progress
	// and requested.
	Status ReservedNodeExchangeStatusType

	// The count of target reserved nodes in the cluster.
	TargetReservedNodeCount *int32

	// The identifier of the target reserved node offering.
	TargetReservedNodeOfferingId *string

	// The node type of the target reserved node, for example ra3.4xlarge.
	TargetReservedNodeType *string

	noSmithyDocumentSerde
}

// Describes a reserved node offering.
type ReservedNodeOffering struct {

	// The currency code for the compute nodes offering.
	CurrencyCode *string

	// The duration, in seconds, for which the offering will reserve the node.
	Duration *int32

	// The upfront fixed charge you will pay to purchase the specific reserved node
	// offering.
	FixedPrice *float64

	// The node type offered by the reserved node offering.
	NodeType *string

	// The anticipated utilization of the reserved node, as defined in the reserved
	// node offering.
	OfferingType *string

	// The charge to your account regardless of whether you are creating any clusters
	// using the node offering. Recurring charges are only in effect for
	// heavy-utilization reserved nodes.
	RecurringCharges []RecurringCharge

	// The offering identifier.
	ReservedNodeOfferingId *string

	//
	ReservedNodeOfferingType ReservedNodeOfferingType

	// The rate you are charged for each hour the cluster that is using the offering
	// is running.
	UsagePrice *float64

	noSmithyDocumentSerde
}

// Describes a resize cluster operation. For example, a scheduled action to run
// the ResizeCluster API operation.
type ResizeClusterMessage struct {

	// The unique identifier for the cluster to resize.
	//
	// This member is required.
	ClusterIdentifier *string

	// A boolean value indicating whether the resize operation is using the classic
	// resize process. If you don't provide this parameter or set the value to false ,
	// the resize type is elastic.
	Classic *bool

	// The new cluster type for the specified cluster.
	ClusterType *string

	// The new node type for the nodes you are adding. If not specified, the cluster's
	// current node type is used.
	NodeType *string

	// The new number of nodes for the cluster. If not specified, the cluster's
	// current number of nodes is used.
	NumberOfNodes *int32

	// The identifier of the reserved node.
	ReservedNodeId *string

	// The identifier of the target reserved node offering.
	TargetReservedNodeOfferingId *string

	noSmithyDocumentSerde
}

// Describes a resize operation.
type ResizeInfo struct {

	// A boolean value indicating if the resize operation can be cancelled.
	AllowCancelResize *bool

	// Returns the value ClassicResize .
	ResizeType *string

	noSmithyDocumentSerde
}

// The policy that is attached to a resource.
type ResourcePolicy struct {

	// The content of a resource policy.
	Policy *string

	// The resources that a policy is attached to.
	ResourceArn *string

	noSmithyDocumentSerde
}

// Describes the status of a cluster restore action. Returns null if the cluster
// was not created by restoring a snapshot.
type RestoreStatus struct {

	// The number of megabytes per second being transferred from the backup storage.
	// Returns the average rate for a completed backup. This field is only updated when
	// you restore to DC2 and DS2 node types.
	CurrentRestoreRateInMegaBytesPerSecond *float64

	// The amount of time an in-progress restore has been running, or the amount of
	// time it took a completed restore to finish. This field is only updated when you
	// restore to DC2 and DS2 node types.
	ElapsedTimeInSeconds *int64

	// The estimate of the time remaining before the restore will complete. Returns 0
	// for a completed restore. This field is only updated when you restore to DC2 and
	// DS2 node types.
	EstimatedTimeToCompletionInSeconds *int64

	// The number of megabytes that have been transferred from snapshot storage. This
	// field is only updated when you restore to DC2 and DS2 node types.
	ProgressInMegaBytes *int64

	// The size of the set of snapshot data used to restore the cluster. This field is
	// only updated when you restore to DC2 and DS2 node types.
	SnapshotSizeInMegaBytes *int64

	// The status of the restore action. Returns starting, restoring, completed, or
	// failed.
	Status *string

	noSmithyDocumentSerde
}

// Describes a resume cluster operation. For example, a scheduled action to run
// the ResumeCluster API operation.
type ResumeClusterMessage struct {

	// The identifier of the cluster to be resumed.
	//
	// This member is required.
	ClusterIdentifier *string

	noSmithyDocumentSerde
}

// Describes a RevisionTarget .
type RevisionTarget struct {

	// A unique string that identifies the version to update the cluster to. You can
	// use this value in ModifyClusterDbRevision .
	DatabaseRevision *string

	// The date on which the database revision was released.
	DatabaseRevisionReleaseDate *time.Time

	// A string that describes the changes and features that will be applied to the
	// cluster when it is updated to the corresponding ClusterDbRevision .
	Description *string

	noSmithyDocumentSerde
}

// Describes a scheduled action. You can use a scheduled action to trigger some
// Amazon Redshift API operations on a schedule. For information about which API
// operations can be scheduled, see ScheduledActionType .
type ScheduledAction struct {

	// The end time in UTC when the schedule is no longer active. After this time, the
	// scheduled action does not trigger.
	EndTime *time.Time

	// The IAM role to assume to run the scheduled action. This IAM role must have
	// permission to run the Amazon Redshift API operation in the scheduled action.
	// This IAM role must allow the Amazon Redshift scheduler (Principal
	// scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more
	// information about the IAM role to use with the Amazon Redshift scheduler, see
	// Using Identity-Based Policies for Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html)
	// in the Amazon Redshift Cluster Management Guide.
	IamRole *string

	// List of times when the scheduled action will run.
	NextInvocations []time.Time

	// The schedule for a one-time (at format) or recurring (cron format) scheduled
	// action. Schedule invocations must be separated by at least one hour. Format of
	// at expressions is " at(yyyy-mm-ddThh:mm:ss) ". For example, "
	// at(2016-03-04T17:27:00) ". Format of cron expressions is " cron(Minutes Hours
	// Day-of-month Month Day-of-week Year) ". For example, " cron(0 10 ? * MON *) ".
	// For more information, see Cron Expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	// in the Amazon CloudWatch Events User Guide.
	Schedule *string

	// The description of the scheduled action.
	ScheduledActionDescription *string

	// The name of the scheduled action.
	ScheduledActionName *string

	// The start time in UTC when the schedule is active. Before this time, the
	// scheduled action does not trigger.
	StartTime *time.Time

	// The state of the scheduled action. For example, DISABLED .
	State ScheduledActionState

	// A JSON format string of the Amazon Redshift API operation with input
	// parameters. "
	// {\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}
	// ".
	TargetAction *ScheduledActionType

	noSmithyDocumentSerde
}

// A set of elements to filter the returned scheduled actions.
type ScheduledActionFilter struct {

	// The type of element to filter.
	//
	// This member is required.
	Name ScheduledActionFilterName

	// List of values. Compare if the value (of type defined by Name ) equals an item
	// in the list of scheduled actions.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The action type that specifies an Amazon Redshift API operation that is
// supported by the Amazon Redshift scheduler.
type ScheduledActionType struct {

	// An action that runs a PauseCluster API operation.
	PauseCluster *PauseClusterMessage

	// An action that runs a ResizeCluster API operation.
	ResizeCluster *ResizeClusterMessage

	// An action that runs a ResumeCluster API operation.
	ResumeCluster *ResumeClusterMessage

	noSmithyDocumentSerde
}

// The AvailabilityZone and ClusterNodes information of the secondary compute unit.
type SecondaryClusterInfo struct {

	// The name of the Availability Zone in which the secondary compute unit of the
	// cluster is located.
	AvailabilityZone *string

	// The nodes in the secondary compute unit.
	ClusterNodes []ClusterNode

	noSmithyDocumentSerde
}

// A list of service integrations.
//
// The following types satisfy this interface:
//
//	ServiceIntegrationsUnionMemberLakeFormation
type ServiceIntegrationsUnion interface {
	isServiceIntegrationsUnion()
}

// A list of scopes set up for Lake Formation integration.
type ServiceIntegrationsUnionMemberLakeFormation struct {
	Value []LakeFormationScopeUnion

	noSmithyDocumentSerde
}

func (*ServiceIntegrationsUnionMemberLakeFormation) isServiceIntegrationsUnion() {}

// Describes a snapshot.
type Snapshot struct {

	// A list of the Amazon Web Services accounts authorized to restore the snapshot.
	// Returns null if no accounts are authorized. Visible only to the snapshot owner.
	AccountsWithRestoreAccess []AccountWithRestoreAccess

	// The size of the incremental backup.
	ActualIncrementalBackupSizeInMegaBytes *float64

	// The Availability Zone in which the cluster was created.
	AvailabilityZone *string

	// The number of megabytes that have been transferred to the snapshot backup.
	BackupProgressInMegaBytes *float64

	// The time (UTC) when the cluster was originally created.
	ClusterCreateTime *time.Time

	// The identifier of the cluster for which the snapshot was taken.
	ClusterIdentifier *string

	// The version ID of the Amazon Redshift engine that is running on the cluster.
	ClusterVersion *string

	// The number of megabytes per second being transferred to the snapshot backup.
	// Returns 0 for a completed backup.
	CurrentBackupRateInMegaBytesPerSecond *float64

	// The name of the database that was created when the cluster was created.
	DBName *string

	// The amount of time an in-progress snapshot backup has been running, or the
	// amount of time it took a completed backup to finish.
	ElapsedTimeInSeconds *int64

	// If true , the data in the snapshot is encrypted at rest.
	Encrypted *bool

	// A boolean that indicates whether the snapshot data is encrypted using the HSM
	// keys of the source cluster. true indicates that the data is encrypted using HSM
	// keys.
	EncryptedWithHSM *bool

	// The cluster version of the cluster used to create the snapshot. For example,
	// 1.0.15503.
	EngineFullVersion *string

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the cluster
	// must be in a VPC. For more information, see Enhanced VPC Routing (https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide. If this option is true ,
	// enhanced VPC routing is enabled. Default: false
	EnhancedVpcRouting *bool

	// The estimate of the time remaining before the snapshot backup will complete.
	// Returns 0 for a completed backup.
	EstimatedSecondsToCompletion *int64

	// The Key Management Service (KMS) key ID of the encryption key that was used to
	// encrypt data in the cluster from which the snapshot was taken.
	KmsKeyId *string

	// The name of the maintenance track for the snapshot.
	MaintenanceTrackName *string

	// The number of days until a manual snapshot will pass its retention period.
	ManualSnapshotRemainingDays *int32

	// The number of days that a manual snapshot is retained. If the value is -1, the
	// manual snapshot is retained indefinitely. The value must be either -1 or an
	// integer between 1 and 3,653.
	ManualSnapshotRetentionPeriod *int32

	// The Amazon Resource Name (ARN) for the cluster's admin user credentials secret.
	MasterPasswordSecretArn *string

	// The ID of the Key Management Service (KMS) key used to encrypt and store the
	// cluster's admin credentials secret.
	MasterPasswordSecretKmsKeyId *string

	// The admin user name for the cluster.
	MasterUsername *string

	// The node type of the nodes in the cluster.
	NodeType *string

	// The number of nodes in the cluster.
	NumberOfNodes *int32

	// For manual snapshots, the Amazon Web Services account used to create or copy
	// the snapshot. For automatic snapshots, the owner of the cluster. The owner can
	// perform all snapshot actions, such as sharing a manual snapshot.
	OwnerAccount *string

	// The port that the cluster is listening on.
	Port *int32

	// The list of node types that this cluster snapshot is able to restore into.
	RestorableNodeTypes []string

	// The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot
	// contains a copy of the cluster data as of this exact time.
	SnapshotCreateTime *time.Time

	// The snapshot identifier that is provided in the request.
	SnapshotIdentifier *string

	// A timestamp representing the start of the retention period for the snapshot.
	SnapshotRetentionStartTime *time.Time

	// The snapshot type. Snapshots created using CreateClusterSnapshot and
	// CopyClusterSnapshot are of type "manual".
	SnapshotType *string

	// The source region from which the snapshot was copied.
	SourceRegion *string

	// The snapshot status. The value of the status depends on the API operation used:
	//   - CreateClusterSnapshot and CopyClusterSnapshot returns status as "creating".
	//   - DescribeClusterSnapshots returns status as "creating", "available", "final
	//   snapshot", or "failed".
	//   - DeleteClusterSnapshot returns status as "deleted".
	Status *string

	// The list of tags for the cluster snapshot.
	Tags []Tag

	// The size of the complete set of backup data that would be used to restore the
	// cluster.
	TotalBackupSizeInMegaBytes *float64

	// The VPC identifier of the cluster if the snapshot is from a cluster in a VPC.
	// Otherwise, this field is not in the output.
	VpcId *string

	noSmithyDocumentSerde
}

// The snapshot copy grant that grants Amazon Redshift permission to encrypt
// copied snapshots with the specified encrypted symmetric key from Amazon Web
// Services KMS in the destination region. For more information about managing
// snapshot copy grants, go to Amazon Redshift Database Encryption (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
// in the Amazon Redshift Cluster Management Guide.
type SnapshotCopyGrant struct {

	// The unique identifier of the encrypted symmetric key in Amazon Web Services KMS
	// to which Amazon Redshift is granted permission.
	KmsKeyId *string

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string

	// A list of tag instances.
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes the errors returned by a snapshot.
type SnapshotErrorMessage struct {

	// The failure code for the error.
	FailureCode *string

	// The text message describing the error.
	FailureReason *string

	// A unique identifier for the cluster.
	SnapshotClusterIdentifier *string

	// A unique identifier for the snapshot returning the error.
	SnapshotIdentifier *string

	noSmithyDocumentSerde
}

// Describes a snapshot schedule. You can set a regular interval for creating
// snapshots of a cluster. You can also schedule snapshots for specific dates.
type SnapshotSchedule struct {

	// The number of clusters associated with the schedule.
	AssociatedClusterCount *int32

	// A list of clusters associated with the schedule. A maximum of 100 clusters is
	// returned.
	AssociatedClusters []ClusterAssociatedToSchedule

	//
	NextInvocations []time.Time

	// A list of ScheduleDefinitions.
	ScheduleDefinitions []string

	// The description of the schedule.
	ScheduleDescription *string

	// A unique identifier for the schedule.
	ScheduleIdentifier *string

	// An optional set of tags describing the schedule.
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes a sorting entity
type SnapshotSortingEntity struct {

	// The category for sorting the snapshots.
	//
	// This member is required.
	Attribute SnapshotAttributeToSortBy

	// The order for listing the attributes.
	SortOrder SortByOrder

	noSmithyDocumentSerde
}

// Describes a subnet.
type Subnet struct {

	//
	SubnetAvailabilityZone *AvailabilityZone

	// The identifier of the subnet.
	SubnetIdentifier *string

	// The status of the subnet.
	SubnetStatus *string

	noSmithyDocumentSerde
}

// Describes the operations that are allowed on a maintenance track.
type SupportedOperation struct {

	// A list of the supported operations.
	OperationName *string

	noSmithyDocumentSerde
}

// A list of supported platforms for orderable clusters.
type SupportedPlatform struct {

	//
	Name *string

	noSmithyDocumentSerde
}

// Describes the status of a RestoreTableFromClusterSnapshot operation.
type TableRestoreStatus struct {

	// The identifier of the Amazon Redshift cluster that the table is being restored
	// to.
	ClusterIdentifier *string

	// A description of the status of the table restore request. Status values include
	// SUCCEEDED , FAILED , CANCELED , PENDING , IN_PROGRESS .
	Message *string

	// The name of the table to create as a result of the table restore request.
	NewTableName *string

	// The amount of data restored to the new table so far, in megabytes (MB).
	ProgressInMegaBytes *int64

	// The time that the table restore request was made, in Universal Coordinated Time
	// (UTC).
	RequestTime *time.Time

	// The identifier of the snapshot that the table is being restored from.
	SnapshotIdentifier *string

	// The name of the source database that contains the table being restored.
	SourceDatabaseName *string

	// The name of the source schema that contains the table being restored.
	SourceSchemaName *string

	// The name of the source table being restored.
	SourceTableName *string

	// A value that describes the current state of the table restore request. Valid
	// Values: SUCCEEDED , FAILED , CANCELED , PENDING , IN_PROGRESS
	Status TableRestoreStatusType

	// The unique identifier for the table restore request.
	TableRestoreRequestId *string

	// The name of the database to restore the table to.
	TargetDatabaseName *string

	// The name of the schema to restore the table to.
	TargetSchemaName *string

	// The total amount of data to restore to the new table, in megabytes (MB).
	TotalDataInMegaBytes *int64

	noSmithyDocumentSerde
}

// A tag consisting of a name/value pair for a resource.
type Tag struct {

	// The key, or name, for the resource tag.
	Key *string

	// The value for the resource tag.
	Value *string

	noSmithyDocumentSerde
}

// A tag and its associated resource.
type TaggedResource struct {

	// The Amazon Resource Name (ARN) with which the tag is associated, for example:
	// arn:aws:redshift:us-east-2:123456789:cluster:t1 .
	ResourceName *string

	// The type of resource with which the tag is associated. Valid resource types
	// are:
	//   - Cluster
	//   - CIDR/IP
	//   - EC2 security group
	//   - Snapshot
	//   - Cluster security group
	//   - Subnet group
	//   - HSM connection
	//   - HSM certificate
	//   - Parameter group
	// For more information about Amazon Redshift resource types and constructing
	// ARNs, go to Constructing an Amazon Redshift Amazon Resource Name (ARN) (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions)
	// in the Amazon Redshift Cluster Management Guide.
	ResourceType *string

	// The tag for the resource.
	Tag *Tag

	noSmithyDocumentSerde
}

// A maintenance track that you can switch the current track to.
type UpdateTarget struct {

	// The cluster version for the new maintenance track.
	DatabaseVersion *string

	// The name of the new maintenance track.
	MaintenanceTrackName *string

	// A list of operations supported by the maintenance track.
	SupportedOperations []SupportedOperation

	noSmithyDocumentSerde
}

// Describes a usage limit object for a cluster.
type UsageLimit struct {

	// The limit amount. If time-based, this amount is in minutes. If data-based, this
	// amount is in terabytes (TB).
	Amount *int64

	// The action that Amazon Redshift takes when the limit is reached. Possible
	// values are:
	//   - log - To log an event in a system table. The default is log.
	//   - emit-metric - To emit CloudWatch metrics.
	//   - disable - To disable the feature until the next usage period begins.
	BreachAction UsageLimitBreachAction

	// The identifier of the cluster with a usage limit.
	ClusterIdentifier *string

	// The Amazon Redshift feature to which the limit applies.
	FeatureType UsageLimitFeatureType

	// The type of limit. Depending on the feature type, this can be based on a time
	// duration or data size.
	LimitType UsageLimitLimitType

	// The time period that the amount applies to. A weekly period begins on Sunday.
	// The default is monthly .
	Period UsageLimitPeriod

	// A list of tag instances.
	Tags []Tag

	// The identifier of the usage limit.
	UsageLimitId *string

	noSmithyDocumentSerde
}

// The connection endpoint for connecting to an Amazon Redshift cluster through
// the proxy.
type VpcEndpoint struct {

	// One or more network interfaces of the endpoint. Also known as an interface
	// endpoint.
	NetworkInterfaces []NetworkInterface

	// The connection endpoint ID for connecting an Amazon Redshift cluster through
	// the proxy.
	VpcEndpointId *string

	// The VPC identifier that the endpoint is associated.
	VpcId *string

	noSmithyDocumentSerde
}

// Describes the members of a VPC security group.
type VpcSecurityGroupMembership struct {

	// The status of the VPC security group.
	Status *string

	// The identifier of the VPC security group.
	VpcSecurityGroupId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isLakeFormationScopeUnion()  {}
func (*UnknownUnionMember) isServiceIntegrationsUnion() {}
