// Code generated by smithy-go-codegen DO NOT EDIT.

package awsrestjson

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
)

// This examples serializes a streaming media-typed blob shape in the request
// body. This examples uses a @mediaType trait on the payload to force a custom
// content-type to be serialized.
func (c *Client) StreamingTraitsWithMediaType(ctx context.Context, params *StreamingTraitsWithMediaTypeInput, optFns ...func(*Options)) (*StreamingTraitsWithMediaTypeOutput, error) {
	if params == nil {
		params = &StreamingTraitsWithMediaTypeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StreamingTraitsWithMediaType", params, optFns, c.addOperationStreamingTraitsWithMediaTypeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StreamingTraitsWithMediaTypeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StreamingTraitsWithMediaTypeInput struct {

	// This value conforms to the media type: text/plain
	Blob io.Reader

	Foo *string

	noSmithyDocumentSerde
}

type StreamingTraitsWithMediaTypeOutput struct {

	// This value conforms to the media type: text/plain
	Blob io.ReadCloser

	Foo *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStreamingTraitsWithMediaTypeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStreamingTraitsWithMediaType{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStreamingTraitsWithMediaType{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StreamingTraitsWithMediaType"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStreamingTraitsWithMediaType(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStreamingTraitsWithMediaType(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StreamingTraitsWithMediaType",
	}
}
