// Code generated by smithy-go-codegen DO NOT EDIT.

package elastictranscoder

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/elastictranscoder/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// With the UpdatePipelineNotifications operation, you can update Amazon Simple
// Notification Service (Amazon SNS) notifications for a pipeline. When you update
// notifications for a pipeline, Elastic Transcoder returns the values that you
// specified in the request.
func (c *Client) UpdatePipelineNotifications(ctx context.Context, params *UpdatePipelineNotificationsInput, optFns ...func(*Options)) (*UpdatePipelineNotificationsOutput, error) {
	if params == nil {
		params = &UpdatePipelineNotificationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdatePipelineNotifications", params, optFns, c.addOperationUpdatePipelineNotificationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdatePipelineNotificationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The UpdatePipelineNotificationsRequest structure.
type UpdatePipelineNotificationsInput struct {

	// The identifier of the pipeline for which you want to change notification
	// settings.
	//
	// This member is required.
	Id *string

	// The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic
	// that you want to notify to report job status. To receive notifications, you must
	// also subscribe to the new topic in the Amazon SNS console.
	//   - Progressing: The topic ARN for the Amazon Simple Notification Service
	//   (Amazon SNS) topic that you want to notify when Elastic Transcoder has started
	//   to process jobs that are added to this pipeline. This is the ARN that Amazon SNS
	//   returned when you created the topic.
	//   - Complete: The topic ARN for the Amazon SNS topic that you want to notify
	//   when Elastic Transcoder has finished processing a job. This is the ARN that
	//   Amazon SNS returned when you created the topic.
	//   - Warning: The topic ARN for the Amazon SNS topic that you want to notify
	//   when Elastic Transcoder encounters a warning condition. This is the ARN that
	//   Amazon SNS returned when you created the topic.
	//   - Error: The topic ARN for the Amazon SNS topic that you want to notify when
	//   Elastic Transcoder encounters an error condition. This is the ARN that Amazon
	//   SNS returned when you created the topic.
	//
	// This member is required.
	Notifications *types.Notifications

	noSmithyDocumentSerde
}

// The UpdatePipelineNotificationsResponse structure.
type UpdatePipelineNotificationsOutput struct {

	// A section of the response body that provides information about the pipeline
	// associated with this notification.
	Pipeline *types.Pipeline

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdatePipelineNotificationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdatePipelineNotifications{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdatePipelineNotifications{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdatePipelineNotifications"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdatePipelineNotificationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdatePipelineNotifications(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdatePipelineNotifications(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdatePipelineNotifications",
	}
}
