// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Remove versions from the specified schema. A version number or range may be
// supplied. If the compatibility mode forbids deleting of a version that is
// necessary, such as BACKWARDS_FULL, an error is returned. Calling the
// GetSchemaVersions API after this call will list the status of the deleted
// versions. When the range of version numbers contain check pointed version, the
// API will return a 409 conflict and will not proceed with the deletion. You have
// to remove the checkpoint first using the DeleteSchemaCheckpoint API before
// using this API. You cannot use the DeleteSchemaVersions API to delete the first
// schema version in the schema set. The first schema version can only be deleted
// by the DeleteSchema API. This operation will also delete the attached
// SchemaVersionMetadata under the schema versions. Hard deletes will be enforced
// on the database. If the compatibility mode forbids deleting of a version that is
// necessary, such as BACKWARDS_FULL, an error is returned.
func (c *Client) DeleteSchemaVersions(ctx context.Context, params *DeleteSchemaVersionsInput, optFns ...func(*Options)) (*DeleteSchemaVersionsOutput, error) {
	if params == nil {
		params = &DeleteSchemaVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteSchemaVersions", params, optFns, c.addOperationDeleteSchemaVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteSchemaVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteSchemaVersionsInput struct {

	// This is a wrapper structure that may contain the schema name and Amazon
	// Resource Name (ARN).
	//
	// This member is required.
	SchemaId *types.SchemaId

	// A version range may be supplied which may be of the format:
	//   - a single version number, 5
	//   - a range, 5-8 : deletes versions 5, 6, 7, 8
	//
	// This member is required.
	Versions *string

	noSmithyDocumentSerde
}

type DeleteSchemaVersionsOutput struct {

	// A list of SchemaVersionErrorItem objects, each containing an error and schema
	// version.
	SchemaVersionErrors []types.SchemaVersionErrorItem

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteSchemaVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDeleteSchemaVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDeleteSchemaVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteSchemaVersions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDeleteSchemaVersionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteSchemaVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteSchemaVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteSchemaVersions",
	}
}
