// Code generated by smithy-go-codegen DO NOT EDIT.

package ivs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts the process of revoking the viewer session associated with a specified
// channel ARN and viewer ID. Optionally, you can provide a version to revoke
// viewer sessions less than and including that version. For instructions on
// associating a viewer ID with a viewer session, see Setting Up Private Channels (https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html)
// .
func (c *Client) StartViewerSessionRevocation(ctx context.Context, params *StartViewerSessionRevocationInput, optFns ...func(*Options)) (*StartViewerSessionRevocationOutput, error) {
	if params == nil {
		params = &StartViewerSessionRevocationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartViewerSessionRevocation", params, optFns, c.addOperationStartViewerSessionRevocationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartViewerSessionRevocationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartViewerSessionRevocationInput struct {

	// The ARN of the channel associated with the viewer session to revoke.
	//
	// This member is required.
	ChannelArn *string

	// The ID of the viewer associated with the viewer session to revoke. Do not use
	// this field for personally identifying, confidential, or sensitive information.
	//
	// This member is required.
	ViewerId *string

	// An optional filter on which versions of the viewer session to revoke. All
	// versions less than or equal to the specified version will be revoked. Default:
	// 0.
	ViewerSessionVersionsLessThanOrEqualTo int32

	noSmithyDocumentSerde
}

type StartViewerSessionRevocationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartViewerSessionRevocationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartViewerSessionRevocation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartViewerSessionRevocation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartViewerSessionRevocation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartViewerSessionRevocationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartViewerSessionRevocation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartViewerSessionRevocation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartViewerSessionRevocation",
	}
}
