// Code generated by smithy-go-codegen DO NOT EDIT.

package location

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/location/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists geofences stored in a given geofence collection.
func (c *Client) ListGeofences(ctx context.Context, params *ListGeofencesInput, optFns ...func(*Options)) (*ListGeofencesOutput, error) {
	if params == nil {
		params = &ListGeofencesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListGeofences", params, optFns, c.addOperationListGeofencesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListGeofencesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListGeofencesInput struct {

	// The name of the geofence collection storing the list of geofences.
	//
	// This member is required.
	CollectionName *string

	// An optional limit for the number of geofences returned in a single call.
	// Default value: 100
	MaxResults *int32

	// The pagination token specifying which page of results to return in the
	// response. If no token is provided, the default page is the first page. Default
	// value: null
	NextToken *string

	noSmithyDocumentSerde
}

type ListGeofencesOutput struct {

	// Contains a list of geofences stored in the geofence collection.
	//
	// This member is required.
	Entries []types.ListGeofenceResponseEntry

	// A pagination token indicating there are additional pages available. You can use
	// the token in a following request to fetch the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListGeofencesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListGeofences{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListGeofences{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListGeofences"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opListGeofencesMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListGeofencesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListGeofences(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opListGeofencesMiddleware struct {
}

func (*endpointPrefix_opListGeofencesMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opListGeofencesMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "geofencing." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opListGeofencesMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opListGeofencesMiddleware{}, "ResolveEndpointV2", middleware.After)
}

// ListGeofencesAPIClient is a client that implements the ListGeofences operation.
type ListGeofencesAPIClient interface {
	ListGeofences(context.Context, *ListGeofencesInput, ...func(*Options)) (*ListGeofencesOutput, error)
}

var _ ListGeofencesAPIClient = (*Client)(nil)

// ListGeofencesPaginatorOptions is the paginator options for ListGeofences
type ListGeofencesPaginatorOptions struct {
	// An optional limit for the number of geofences returned in a single call.
	// Default value: 100
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListGeofencesPaginator is a paginator for ListGeofences
type ListGeofencesPaginator struct {
	options   ListGeofencesPaginatorOptions
	client    ListGeofencesAPIClient
	params    *ListGeofencesInput
	nextToken *string
	firstPage bool
}

// NewListGeofencesPaginator returns a new ListGeofencesPaginator
func NewListGeofencesPaginator(client ListGeofencesAPIClient, params *ListGeofencesInput, optFns ...func(*ListGeofencesPaginatorOptions)) *ListGeofencesPaginator {
	if params == nil {
		params = &ListGeofencesInput{}
	}

	options := ListGeofencesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListGeofencesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListGeofencesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListGeofences page.
func (p *ListGeofencesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListGeofencesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListGeofences(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListGeofences(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListGeofences",
	}
}
