// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptography

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/paymentcryptography/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets the import token and the wrapping key certificate in PEM format (base64
// encoded) to initiate a TR-34 WrappedKeyBlock or a RSA WrappedKeyCryptogram
// import into Amazon Web Services Payment Cryptography. The wrapping key
// certificate wraps the key under import. The import token and wrapping key
// certificate must be in place and operational before calling ImportKey . The
// import token expires in 7 days. You can use the same import token to import
// multiple keys into your service account. Cross-account use: This operation can't
// be used across different Amazon Web Services accounts. Related operations:
//   - GetParametersForExport
//   - ImportKey
func (c *Client) GetParametersForImport(ctx context.Context, params *GetParametersForImportInput, optFns ...func(*Options)) (*GetParametersForImportOutput, error) {
	if params == nil {
		params = &GetParametersForImportInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetParametersForImport", params, optFns, c.addOperationGetParametersForImportMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetParametersForImportOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetParametersForImportInput struct {

	// The method to use for key material import. Import token is only required for
	// TR-34 WrappedKeyBlock ( TR34_KEY_BLOCK ) and RSA WrappedKeyCryptogram (
	// KEY_CRYPTOGRAM ). Import token is not required for TR-31, root public key
	// cerificate or trusted public key certificate.
	//
	// This member is required.
	KeyMaterialType types.KeyMaterialType

	// The wrapping key algorithm to generate a wrapping key certificate. This
	// certificate wraps the key under import. At this time, RSA_2048 is the allowed
	// algorithm for TR-34 WrappedKeyBlock import. Additionally, RSA_2048 , RSA_3072 ,
	// RSA_4096 are the allowed algorithms for RSA WrappedKeyCryptogram import.
	//
	// This member is required.
	WrappingKeyAlgorithm types.KeyAlgorithm

	noSmithyDocumentSerde
}

type GetParametersForImportOutput struct {

	// The import token to initiate key import into Amazon Web Services Payment
	// Cryptography. The import token expires after 7 days. You can use the same import
	// token to import multiple keys to the same service account.
	//
	// This member is required.
	ImportToken *string

	// The validity period of the import token.
	//
	// This member is required.
	ParametersValidUntilTimestamp *time.Time

	// The algorithm of the wrapping key for use within TR-34 WrappedKeyBlock or RSA
	// WrappedKeyCryptogram.
	//
	// This member is required.
	WrappingKeyAlgorithm types.KeyAlgorithm

	// The wrapping key certificate in PEM format (base64 encoded) of the wrapping key
	// for use within the TR-34 key block. The certificate expires in 7 days.
	//
	// This member is required.
	WrappingKeyCertificate *string

	// The Amazon Web Services Payment Cryptography root certificate authority (CA)
	// that signed the wrapping key certificate in PEM format (base64 encoded).
	//
	// This member is required.
	WrappingKeyCertificateChain *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetParametersForImportMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetParametersForImport{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetParametersForImport{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetParametersForImport"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetParametersForImportValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetParametersForImport(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetParametersForImport(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetParametersForImport",
	}
}
