// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Defines a recommendation for a CloudWatch alarm.
type AlarmRecommendation struct {

	// Name of the alarm recommendation.
	//
	// This member is required.
	Name *string

	// Identifier of the alarm recommendation.
	//
	// This member is required.
	RecommendationId *string

	// Reference identifier of the alarm recommendation.
	//
	// This member is required.
	ReferenceId *string

	// Type of alarm recommendation.
	//
	// This member is required.
	Type AlarmType

	// Application Component name for the CloudWatch alarm recommendation. This name
	// is saved as the first item in the appComponentNames list.
	//
	// Deprecated: An alarm recommendation can be attached to multiple Application
	// Components, hence this property will be replaced by the new property
	// 'appComponentNames'.
	AppComponentName *string

	// List of Application Component names for the CloudWatch alarm recommendation.
	AppComponentNames []string

	// Description of the alarm recommendation.
	Description *string

	// List of CloudWatch alarm recommendations.
	Items []RecommendationItem

	// The prerequisite for the alarm recommendation.
	Prerequisite *string

	// Status of the recommended Amazon CloudWatch alarm.
	RecommendationStatus RecommendationStatus

	noSmithyDocumentSerde
}

// Defines an Resilience Hub application.
type App struct {

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format for
	// this ARN is: arn: partition :resiliencehub: region : account :app/ app-id . For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// This member is required.
	AppArn *string

	// Date and time when the app was created.
	//
	// This member is required.
	CreationTime *time.Time

	// Name for the application.
	//
	// This member is required.
	Name *string

	// Assessment execution schedule with 'Daily' or 'Disabled' values.
	AssessmentSchedule AppAssessmentScheduleType

	// Current status of compliance for the resiliency policy.
	ComplianceStatus AppComplianceStatusType

	// Optional description for an application.
	Description *string

	// Indicates if compliance drifts (deviations) were detected while running an
	// assessment for your application.
	DriftStatus AppDriftStatusType

	// The list of events you would like to subscribe and get notification for.
	// Currently, Resilience Hub supports notifications only for Drift detected and
	// Scheduled assessment failure events.
	EventSubscriptions []EventSubscription

	// Date and time the most recent compliance evaluation.
	LastAppComplianceEvaluationTime *time.Time

	// Indicates the last time that a drift was evaluated.
	LastDriftEvaluationTime *time.Time

	// Date and time the most recent resiliency score evaluation.
	LastResiliencyScoreEvaluationTime *time.Time

	// Defines the roles and credentials that Resilience Hub would use while creating
	// the application, importing its resources, and running an assessment.
	PermissionModel *PermissionModel

	// Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN
	// is: arn: partition :resiliencehub: region : account :resiliency-policy/ policy-id
	// . For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	PolicyArn *string

	// Current resiliency score for the application.
	ResiliencyScore float64

	// Recovery Point Objective (RPO) in seconds.
	RpoInSecs *int32

	// Recovery Time Objective (RTO) in seconds.
	RtoInSecs *int32

	// Status of the application.
	Status AppStatusType

	// Tags assigned to the resource. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key/value pair.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Defines an application assessment.
type AppAssessment struct {

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:
	// partition :resiliencehub: region : account :app-assessment/ app-id . For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// This member is required.
	AssessmentArn *string

	// Current status of the assessment for the resiliency policy.
	//
	// This member is required.
	AssessmentStatus AssessmentStatus

	// The entity that invoked the assessment.
	//
	// This member is required.
	Invoker AssessmentInvoker

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format for
	// this ARN is: arn: partition :resiliencehub: region : account :app/ app-id . For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	AppArn *string

	// Version of an application.
	AppVersion *string

	// Name of the assessment.
	AssessmentName *string

	// Application compliance against the resiliency policy.
	Compliance map[string]DisruptionCompliance

	// Current status of the compliance for the resiliency policy.
	ComplianceStatus ComplianceStatus

	// Cost for the application.
	Cost *Cost

	// Indicates if compliance drifts (deviations) were detected while running an
	// assessment for your application.
	DriftStatus DriftStatus

	// End time for the action.
	EndTime *time.Time

	// Error or warning message from the assessment execution
	Message *string

	// Resiliency policy of an application.
	Policy *ResiliencyPolicy

	// Current resiliency score for an application.
	ResiliencyScore *ResiliencyScore

	// A resource error object containing a list of errors retrieving an application's
	// resources.
	ResourceErrorsDetails *ResourceErrorsDetails

	// Starting time for the action.
	StartTime *time.Time

	// Tags assigned to the resource. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key/value pair.
	Tags map[string]string

	// Version name of the published application.
	VersionName *string

	noSmithyDocumentSerde
}

// Defines an application assessment summary.
type AppAssessmentSummary struct {

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:
	// partition :resiliencehub: region : account :app-assessment/ app-id . For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// This member is required.
	AssessmentArn *string

	// Current status of the assessment for the resiliency policy.
	//
	// This member is required.
	AssessmentStatus AssessmentStatus

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format for
	// this ARN is: arn: partition :resiliencehub: region : account :app/ app-id . For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	AppArn *string

	// Version of an application.
	AppVersion *string

	// Name of the assessment.
	AssessmentName *string

	// TCurrent status of compliance for the resiliency policy.
	ComplianceStatus ComplianceStatus

	// Cost for an application.
	Cost *Cost

	// Indicates if compliance drifts (deviations) were detected while running an
	// assessment for your application.
	DriftStatus DriftStatus

	// End time for the action.
	EndTime *time.Time

	// Entity that invoked the assessment.
	Invoker AssessmentInvoker

	// Message from the assessment run.
	Message *string

	// Current resiliency score for the application.
	ResiliencyScore float64

	// Starting time for the action.
	StartTime *time.Time

	// Name of an application version.
	VersionName *string

	noSmithyDocumentSerde
}

// Defines an Application Component.
type AppComponent struct {

	// Name of the Application Component.
	//
	// This member is required.
	Name *string

	// The type of Application Component.
	//
	// This member is required.
	Type *string

	// Additional configuration parameters for an Resilience Hub application. If you
	// want to implement additionalInfo through the Resilience Hub console rather than
	// using an API call, see Configure the application configuration parameters (https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html)
	// . Currently, this parameter accepts a key-value mapping (in a string format) of
	// only one failover region and one associated account. Key: "failover-regions"
	// Value: "[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"
	AdditionalInfo map[string][]string

	// Identifier of the Application Component.
	Id *string

	noSmithyDocumentSerde
}

// Defines the compliance of an Application Component against the resiliency
// policy.
type AppComponentCompliance struct {

	// Name of the Application Component.
	AppComponentName *string

	// The compliance of the Application Component against the resiliency policy.
	Compliance map[string]DisruptionCompliance

	// The cost for the application.
	Cost *Cost

	// The compliance message.
	Message *string

	// The current resiliency score for the application.
	ResiliencyScore *ResiliencyScore

	// Status of the action.
	Status ComplianceStatus

	noSmithyDocumentSerde
}

// The list of Resilience Hub application input sources.
type AppInputSource struct {

	// The resource type of the input source.
	//
	// This member is required.
	ImportType ResourceMappingType

	// The namespace on your Amazon Elastic Kubernetes Service cluster.
	EksSourceClusterNamespace *EksSourceClusterNamespace

	// The number of resources.
	ResourceCount int32

	// The Amazon Resource Name (ARN) of the input source. For more information about
	// ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	SourceArn *string

	// The name of the input source.
	SourceName *string

	// The name of the Terraform s3 state ﬁle.
	TerraformSource *TerraformSource

	noSmithyDocumentSerde
}

// Defines an application summary.
type AppSummary struct {

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format for
	// this ARN is: arn: partition :resiliencehub: region : account :app/ app-id . For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// This member is required.
	AppArn *string

	// Date and time when the app was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The name of the application.
	//
	// This member is required.
	Name *string

	// Assessment execution schedule with 'Daily' or 'Disabled' values.
	AssessmentSchedule AppAssessmentScheduleType

	// The current status of compliance for the resiliency policy.
	ComplianceStatus AppComplianceStatusType

	// The optional description for an app.
	Description *string

	// Indicates if compliance drifts (deviations) were detected while running an
	// assessment for your application.
	DriftStatus AppDriftStatusType

	// Date and time of the most recent compliance evaluation.
	LastAppComplianceEvaluationTime *time.Time

	// The current resiliency score for the application.
	ResiliencyScore float64

	// Recovery Point Objective (RPO) in seconds.
	RpoInSecs *int32

	// Recovery Time Objective (RTO) in seconds.
	RtoInSecs *int32

	// Status of the application.
	Status AppStatusType

	noSmithyDocumentSerde
}

// Version of an application.
type AppVersionSummary struct {

	// Version of an application.
	//
	// This member is required.
	AppVersion *string

	// Creation time of the application version.
	CreationTime *time.Time

	// Identifier of the application version.
	Identifier *int64

	// Name of the application version.
	VersionName *string

	noSmithyDocumentSerde
}

// List of operational recommendations that did not get included or excluded.
type BatchUpdateRecommendationStatusFailedEntry struct {

	// An identifier of an entry in this batch that is used to communicate the result.
	// The entryId s of a batch request need to be unique within a request.
	//
	// This member is required.
	EntryId *string

	// Indicates the error that occurred while excluding an operational recommendation.
	//
	// This member is required.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// List of operational recommendations that were successfully included or excluded.
type BatchUpdateRecommendationStatusSuccessfulEntry struct {

	// An identifier for an entry in this batch that is used to communicate the
	// result. The entryId s of a batch request need to be unique within a request.
	//
	// This member is required.
	EntryId *string

	// Indicates if the operational recommendation was successfully excluded.
	//
	// This member is required.
	Excluded *bool

	// The operational recommendation item.
	//
	// This member is required.
	Item *UpdateRecommendationStatusItem

	// Reference identifier of the operational recommendation.
	//
	// This member is required.
	ReferenceId *string

	// Indicates the reason for excluding an operational recommendation.
	ExcludeReason ExcludeRecommendationReason

	noSmithyDocumentSerde
}

// Indicates the compliance drifts (recovery time objective (RTO) and recovery
// point objective (RPO)) that were detected for an assessed entity.
type ComplianceDrift struct {

	// Assessment identifier that is associated with this drift item.
	ActualReferenceId *string

	// Actual compliance value of the entity.
	ActualValue map[string]DisruptionCompliance

	// Identifier of your application.
	AppId *string

	// Published version of your application on which drift was detected.
	AppVersion *string

	// Difference type between actual and expected recovery point objective (RPO) and
	// recovery time objective (RTO) values. Currently, Resilience Hub supports only
	// NotEqual difference type.
	DiffType DifferenceType

	// The type of drift detected. Currently, Resilience Hub supports only
	// ApplicationCompliance drift type.
	DriftType DriftType

	// Identifier of an entity in which drift was detected. For compliance drift, the
	// entity ID can be either application ID or the AppComponent ID.
	EntityId *string

	// The type of entity in which drift was detected. For compliance drifts,
	// Resilience Hub supports AWS::ResilienceHub::AppComponent and
	// AWS::ResilienceHub::Application .
	EntityType *string

	// Assessment identifier of a previous assessment of the same application version.
	// Resilience Hub uses the previous assessment (associated with the reference
	// identifier) to compare the compliance with the current assessment to identify
	// drifts.
	ExpectedReferenceId *string

	// The expected compliance value of an entity.
	ExpectedValue map[string]DisruptionCompliance

	noSmithyDocumentSerde
}

// Defines recommendations for an Resilience Hub Application Component, returned
// as an object. This object contains component names, configuration
// recommendations, and recommendation statuses.
type ComponentRecommendation struct {

	// Name of the Application Component.
	//
	// This member is required.
	AppComponentName *string

	// List of recommendations.
	//
	// This member is required.
	ConfigRecommendations []ConfigRecommendation

	// Status of the recommendation.
	//
	// This member is required.
	RecommendationStatus RecommendationComplianceStatus

	noSmithyDocumentSerde
}

// Defines a recommendation configuration.
type ConfigRecommendation struct {

	// The name of the recommendation configuration.
	//
	// This member is required.
	Name *string

	// The type of optimization.
	//
	// This member is required.
	OptimizationType ConfigRecommendationOptimizationType

	// Reference identifier for the recommendation configuration.
	//
	// This member is required.
	ReferenceId *string

	// Name of the Application Component.
	AppComponentName *string

	// The current compliance against the resiliency policy before applying the
	// configuration change.
	Compliance map[string]DisruptionCompliance

	// The cost for the application.
	Cost *Cost

	// The optional description for an app.
	Description *string

	// The architecture type.
	HaArchitecture HaArchitecture

	// The expected compliance against the resiliency policy after applying the
	// configuration change.
	RecommendationCompliance map[string]RecommendationDisruptionCompliance

	// List of the suggested configuration changes.
	SuggestedChanges []string

	noSmithyDocumentSerde
}

// Defines a cost object.
type Cost struct {

	// The cost amount.
	//
	// This member is required.
	Amount float64

	// The cost currency, for example USD .
	//
	// This member is required.
	Currency *string

	// The cost frequency.
	//
	// This member is required.
	Frequency CostFrequency

	noSmithyDocumentSerde
}

// Defines the compliance against the resiliency policy for a disruption.
type DisruptionCompliance struct {

	// The current status of compliance for the resiliency policy.
	//
	// This member is required.
	ComplianceStatus ComplianceStatus

	// The Recovery Point Objective (RPO) that is achievable, in seconds.
	AchievableRpoInSecs int32

	// The Recovery Time Objective (RTO) that is achievable, in seconds
	AchievableRtoInSecs int32

	// The current RPO, in seconds.
	CurrentRpoInSecs int32

	// The current RTO, in seconds.
	CurrentRtoInSecs int32

	// The disruption compliance message.
	Message *string

	// The RPO description.
	RpoDescription *string

	// Reference identifier of the RPO .
	RpoReferenceId *string

	// The RTO description.
	RtoDescription *string

	// Reference identifier of the RTO.
	RtoReferenceId *string

	noSmithyDocumentSerde
}

// The input source of the Amazon Elastic Kubernetes Service cluster.
type EksSource struct {

	// Amazon Resource Name (ARN) of the Amazon Elastic Kubernetes Service cluster.
	// The format for this ARN is: arn: aws :eks: region : account-id :cluster/
	// cluster-name . For more information about ARNs, see  Amazon Resource Names
	// (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// This member is required.
	EksClusterArn *string

	// The list of namespaces located on your Amazon Elastic Kubernetes Service
	// cluster.
	//
	// This member is required.
	Namespaces []string

	noSmithyDocumentSerde
}

// The input source of the namespace that is located on your Amazon Elastic
// Kubernetes Service cluster.
type EksSourceClusterNamespace struct {

	// Amazon Resource Name (ARN) of the Amazon Elastic Kubernetes Service cluster.
	// The format for this ARN is: arn: aws :eks: region : account-id :cluster/
	// cluster-name . For more information about ARNs, see  Amazon Resource Names
	// (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// This member is required.
	EksClusterArn *string

	// Name of the namespace that is located on your Amazon Elastic Kubernetes Service
	// cluster.
	//
	// This member is required.
	Namespace *string

	noSmithyDocumentSerde
}

// Indicates an event you would like to subscribe and get notification for.
// Currently, Resilience Hub supports notifications only for Drift detected and
// Scheduled assessment failure events.
type EventSubscription struct {

	// The type of event you would like to subscribe and get notification for.
	// Currently, Resilience Hub supports notifications only for Drift detected (
	// DriftDetected ) and Scheduled assessment failure ( ScheduledAssessmentFailure )
	// events.
	//
	// This member is required.
	EventType EventType

	// Unique name to identify an event subscription.
	//
	// This member is required.
	Name *string

	// Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic. The
	// format for this ARN is: arn:partition:sns:region:account:topic-name . For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	SnsTopicArn *string

	noSmithyDocumentSerde
}

// Defines a failure policy.
type FailurePolicy struct {

	// Recovery Point Objective (RPO) in seconds.
	//
	// This member is required.
	RpoInSecs int32

	// Recovery Time Objective (RTO) in seconds.
	//
	// This member is required.
	RtoInSecs int32

	noSmithyDocumentSerde
}

// Defines a logical resource identifier.
type LogicalResourceId struct {

	// Identifier of the resource.
	//
	// This member is required.
	Identifier *string

	// Name of the Amazon Elastic Kubernetes Service cluster and namespace this
	// resource belongs to. This parameter accepts values in "eks-cluster/namespace"
	// format.
	EksSourceName *string

	// The name of the CloudFormation stack this resource belongs to.
	LogicalStackName *string

	// The name of the resource group that this resource belongs to.
	ResourceGroupName *string

	// The name of the Terraform S3 state file this resource belongs to.
	TerraformSourceName *string

	noSmithyDocumentSerde
}

// Defines the roles and credentials that Resilience Hub would use while creating
// the application, importing its resources, and running an assessment.
type PermissionModel struct {

	// Defines how Resilience Hub scans your resources. It can scan for the resources
	// by using a pre-existing role in your Amazon Web Services account, or by using
	// the credentials of the current IAM user.
	//
	// This member is required.
	Type PermissionModelType

	// Defines a list of role Amazon Resource Names (ARNs) to be used in other
	// accounts. These ARNs are used for querying purposes while importing resources
	// and assessing your application.
	//   - These ARNs are required only when your resources are in other accounts and
	//   you have different role name in these accounts. Else, the invoker role name will
	//   be used in the other accounts.
	//   - These roles must have a trust policy with iam:AssumeRole permission to the
	//   invoker role in the primary account.
	CrossAccountRoleArns []string

	// Existing Amazon Web Services IAM role name in the primary Amazon Web Services
	// account that will be assumed by Resilience Hub Service Principle to obtain a
	// read-only access to your application resources while running an assessment.
	//   - You must have iam:passRole permission for this role while creating or
	//   updating the application.
	//   - Currently, invokerRoleName accepts only [A-Za-z0-9_+=,.@-] characters.
	InvokerRoleName *string

	noSmithyDocumentSerde
}

// Defines a physical resource. A physical resource is a resource that exists in
// your account. It can be identified using an Amazon Resource Name (ARN) or an
// Resilience Hub-native identifier.
type PhysicalResource struct {

	// Logical identifier of the resource.
	//
	// This member is required.
	LogicalResourceId *LogicalResourceId

	// Identifier of the physical resource.
	//
	// This member is required.
	PhysicalResourceId *PhysicalResourceId

	// The type of resource.
	//
	// This member is required.
	ResourceType *string

	// Additional configuration parameters for an Resilience Hub application. If you
	// want to implement additionalInfo through the Resilience Hub console rather than
	// using an API call, see Configure the application configuration parameters (https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html)
	// . Currently, this parameter accepts a key-value mapping (in a string format) of
	// only one failover region and one associated account. Key: "failover-regions"
	// Value: "[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"
	AdditionalInfo map[string][]string

	// The application components that belong to this resource.
	AppComponents []AppComponent

	// Indicates if a resource is included or excluded from the assessment.
	Excluded *bool

	// Name of the parent resource.
	ParentResourceName *string

	// The name of the resource.
	ResourceName *string

	// Type of input source.
	SourceType ResourceSourceType

	noSmithyDocumentSerde
}

// Defines a physical resource identifier.
type PhysicalResourceId struct {

	// Identifier of the physical resource.
	//
	// This member is required.
	Identifier *string

	// Specifies the type of physical resource identifier. Arn The resource identifier
	// is an Amazon Resource Name (ARN) and it can identify the following list of
	// resources:
	//   - AWS::ECS::Service
	//   - AWS::EFS::FileSystem
	//   - AWS::ElasticLoadBalancingV2::LoadBalancer
	//   - AWS::Lambda::Function
	//   - AWS::SNS::Topic
	// Native The resource identifier is an Resilience Hub-native identifier and it
	// can identify the following list of resources:
	//   - AWS::ApiGateway::RestApi
	//   - AWS::ApiGatewayV2::Api
	//   - AWS::AutoScaling::AutoScalingGroup
	//   - AWS::DocDB::DBCluster
	//   - AWS::DocDB::DBGlobalCluster
	//   - AWS::DocDB::DBInstance
	//   - AWS::DynamoDB::GlobalTable
	//   - AWS::DynamoDB::Table
	//   - AWS::EC2::EC2Fleet
	//   - AWS::EC2::Instance
	//   - AWS::EC2::NatGateway
	//   - AWS::EC2::Volume
	//   - AWS::ElasticLoadBalancing::LoadBalancer
	//   - AWS::RDS::DBCluster
	//   - AWS::RDS::DBInstance
	//   - AWS::RDS::GlobalCluster
	//   - AWS::Route53::RecordSet
	//   - AWS::S3::Bucket
	//   - AWS::SQS::Queue
	//
	// This member is required.
	Type PhysicalIdentifierType

	// The Amazon Web Services account that owns the physical resource.
	AwsAccountId *string

	// The Amazon Web Services Region that the physical resource is located in.
	AwsRegion *string

	noSmithyDocumentSerde
}

// Defines a disruption compliance recommendation.
type RecommendationDisruptionCompliance struct {

	// The expected compliance status after applying the recommended configuration
	// change.
	//
	// This member is required.
	ExpectedComplianceStatus ComplianceStatus

	// The expected Recovery Point Objective (RPO) description after applying the
	// recommended configuration change.
	ExpectedRpoDescription *string

	// The expected RPO after applying the recommended configuration change.
	ExpectedRpoInSecs int32

	// The expected Recovery Time Objective (RTO) description after applying the
	// recommended configuration change.
	ExpectedRtoDescription *string

	// The expected RTO after applying the recommended configuration change.
	ExpectedRtoInSecs int32

	noSmithyDocumentSerde
}

// Defines a recommendation.
type RecommendationItem struct {

	// Specifies if the recommendation has already been implemented.
	AlreadyImplemented *bool

	// Indicates the reason for excluding an operational recommendation.
	ExcludeReason ExcludeRecommendationReason

	// Indicates if an operational recommendation item is excluded.
	Excluded *bool

	// Identifier of the resource.
	ResourceId *string

	// Identifier of the target account.
	TargetAccountId *string

	// The target region.
	TargetRegion *string

	noSmithyDocumentSerde
}

// Defines a recommendation template created with the CreateRecommendationTemplate
// action.
type RecommendationTemplate struct {

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:
	// partition :resiliencehub: region : account :app-assessment/ app-id . For more
	// information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	//
	// This member is required.
	AssessmentArn *string

	// Format of the recommendation template. CfnJson The template is CloudFormation
	// JSON. CfnYaml The template is CloudFormation YAML.
	//
	// This member is required.
	Format TemplateFormat

	// Name for the recommendation template.
	//
	// This member is required.
	Name *string

	// Amazon Resource Name (ARN) for the recommendation template.
	//
	// This member is required.
	RecommendationTemplateArn *string

	// An array of strings that specify the recommendation template type or types.
	// Alarm The template is an AlarmRecommendation template. Sop The template is a
	// SopRecommendation template. Test The template is a TestRecommendation template.
	//
	// This member is required.
	RecommendationTypes []RenderRecommendationType

	// Status of the action.
	//
	// This member is required.
	Status RecommendationTemplateStatus

	// Amazon Resource Name (ARN) of the Resilience Hub application. The format for
	// this ARN is: arn: partition :resiliencehub: region : account :app/ app-id . For
	// more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	AppArn *string

	// The end time for the action.
	EndTime *time.Time

	// Message for the recommendation template.
	Message *string

	// Indicates if replacements are needed.
	NeedsReplacements *bool

	// Identifiers for the recommendations used in the recommendation template.
	RecommendationIds []string

	// The start time for the action.
	StartTime *time.Time

	// Tags assigned to the resource. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key/value pair.
	Tags map[string]string

	// The file location of the template.
	TemplatesLocation *S3Location

	noSmithyDocumentSerde
}

// Defines a resiliency policy. Resilience Hub allows you to provide a value of
// zero for rtoInSecs and rpoInSecs of your resiliency policy. But, while
// assessing your application, the lowest possible assessment result is near zero.
// Hence, if you provide value zero for rtoInSecs and rpoInSecs , the estimated
// workload RTO and estimated workload RPO result will be near zero and the
// Compliance status for your application will be set to Policy breached.
type ResiliencyPolicy struct {

	// Date and time when the resiliency policy was created.
	CreationTime *time.Time

	// Specifies a high-level geographical location constraint for where your
	// resilience policy data can be stored.
	DataLocationConstraint DataLocationConstraint

	// Specifies the estimated cost tier of the resiliency policy.
	EstimatedCostTier EstimatedCostTier

	// The resiliency policy.
	Policy map[string]FailurePolicy

	// Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN
	// is: arn: partition :resiliencehub: region : account :resiliency-policy/ policy-id
	// . For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference guide.
	PolicyArn *string

	// The description for the policy.
	PolicyDescription *string

	// The name of the policy
	PolicyName *string

	// Tags assigned to the resource. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key/value pair.
	Tags map[string]string

	// The tier for this resiliency policy, ranging from the highest severity (
	// MissionCritical ) to lowest ( NonCritical ).
	Tier ResiliencyPolicyTier

	noSmithyDocumentSerde
}

// The overall resiliency score, returned as an object that includes the
// disruption score and outage score.
type ResiliencyScore struct {

	// The disruption score for a valid key.
	//
	// This member is required.
	DisruptionScore map[string]float64

	// The outage score for a valid key.
	//
	// This member is required.
	Score float64

	// The score generated by Resilience Hub for the scoring component after running
	// an assessment. For example, if the score is 25 points, it indicates the overall
	// score of your application generated by Resilience Hub after running an
	// assessment.
	ComponentScore map[string]ScoringComponentResiliencyScore

	noSmithyDocumentSerde
}

// Defines application resource errors.
type ResourceError struct {

	// Identifier of the logical resource.
	LogicalResourceId *string

	// Identifier of the physical resource.
	PhysicalResourceId *string

	// This is the error message.
	Reason *string

	noSmithyDocumentSerde
}

// A list of errors retrieving an application's resources.
type ResourceErrorsDetails struct {

	// This indicates if there are more errors not listed in the resourceErrors list.
	HasMoreErrors *bool

	// A list of errors retrieving an application's resources.
	ResourceErrors []ResourceError

	noSmithyDocumentSerde
}

// Defines a resource mapping.
type ResourceMapping struct {

	// Specifies the type of resource mapping. AppRegistryApp The resource is mapped
	// to another application. The name of the application is contained in the
	// appRegistryAppName property. CfnStack The resource is mapped to a CloudFormation
	// stack. The name of the CloudFormation stack is contained in the logicalStackName
	// property. Resource The resource is mapped to another resource. The name of the
	// resource is contained in the resourceName property. ResourceGroup The resource
	// is mapped to Resource Groups. The name of the resource group is contained in the
	// resourceGroupName property.
	//
	// This member is required.
	MappingType ResourceMappingType

	// Identifier of the physical resource.
	//
	// This member is required.
	PhysicalResourceId *PhysicalResourceId

	// The name of the application this resource is mapped to.
	AppRegistryAppName *string

	// Name of the Amazon Elastic Kubernetes Service cluster and namespace this
	// resource belongs to. This parameter accepts values in "eks-cluster/namespace"
	// format.
	EksSourceName *string

	// The name of the CloudFormation stack this resource is mapped to.
	LogicalStackName *string

	// Name of the resource group that the resource is mapped to.
	ResourceGroupName *string

	// Name of the resource that the resource is mapped to.
	ResourceName *string

	// The short name of the Terraform source.
	TerraformSourceName *string

	noSmithyDocumentSerde
}

// The location of the Amazon S3 bucket.
type S3Location struct {

	// The name of the Amazon S3 bucket.
	Bucket *string

	// The prefix for the Amazon S3 bucket.
	Prefix *string

	noSmithyDocumentSerde
}

// Resiliency score of each scoring component. For more information about scoring
// component, see Calculating resiliency score (https://docs.aws.amazon.com/resilience-hub/latest/userguide/calculate-score.html)
// .
type ScoringComponentResiliencyScore struct {

	// Number of recommendations that were excluded from the assessment. For example,
	// if the Excluded count for Resilience Hub recommended Amazon CloudWatch alarms
	// is 7, it indicates that 7 Amazon CloudWatch alarms are excluded from the
	// assessment.
	ExcludedCount int64

	// Number of issues that must be resolved to obtain the maximum possible score for
	// the scoring component. For SOPs, alarms, and FIS experiments, these are the
	// number of recommendations that must be implemented. For compliance, it is the
	// number of Application Components that has breached the resiliency policy. For
	// example, if the Outstanding count for Resilience Hub recommended Amazon
	// CloudWatch alarms is 5, it indicates that 5 Amazon CloudWatch alarms must be
	// fixed to achieve the maximum possible score.
	OutstandingCount int64

	// Maximum possible score that can be obtained for the scoring component. If the
	// Possible score is 20 points, it indicates the maximum possible score you can
	// achieve for your application when you run a new assessment after implementing
	// all the Resilience Hub recommendations.
	PossibleScore float64

	// Resiliency score of your application.
	Score float64

	noSmithyDocumentSerde
}

// Defines a standard operating procedure (SOP) recommendation.
type SopRecommendation struct {

	// Identifier for the SOP recommendation.
	//
	// This member is required.
	RecommendationId *string

	// Reference identifier for the SOP recommendation.
	//
	// This member is required.
	ReferenceId *string

	// The service type.
	//
	// This member is required.
	ServiceType SopServiceType

	// Name of the Application Component.
	AppComponentName *string

	// Description of the SOP recommendation.
	Description *string

	// The recommendation items.
	Items []RecommendationItem

	// Name of the SOP recommendation.
	Name *string

	// Prerequisite for the SOP recommendation.
	Prerequisite *string

	// Status of the recommended standard operating procedure.
	RecommendationStatus RecommendationStatus

	noSmithyDocumentSerde
}

// The Terraform s3 state file you need to import.
type TerraformSource struct {

	// The URL of the Terraform s3 state file you need to import.
	//
	// This member is required.
	S3StateFileUrl *string

	noSmithyDocumentSerde
}

// Defines a test recommendation.
type TestRecommendation struct {

	// Reference identifier for the test recommendation.
	//
	// This member is required.
	ReferenceId *string

	// Name of the Application Component.
	AppComponentName *string

	// A list of recommended alarms that are used in the test and must be exported
	// before or with the test.
	DependsOnAlarms []string

	// Description for the test recommendation.
	Description *string

	// Intent of the test recommendation.
	Intent *string

	// The test recommendation items.
	Items []RecommendationItem

	// Name of the test recommendation.
	Name *string

	// Prerequisite of the test recommendation.
	Prerequisite *string

	// Identifier for the test recommendation.
	RecommendationId *string

	// Status of the recommended test.
	RecommendationStatus RecommendationStatus

	// Level of risk for this test recommendation.
	Risk TestRisk

	// Type of test recommendation.
	Type TestType

	noSmithyDocumentSerde
}

// Defines a resource that is not supported by Resilience Hub.
type UnsupportedResource struct {

	// Logical resource identifier for the unsupported resource.
	//
	// This member is required.
	LogicalResourceId *LogicalResourceId

	// Physical resource identifier for the unsupported resource.
	//
	// This member is required.
	PhysicalResourceId *PhysicalResourceId

	// The type of resource.
	//
	// This member is required.
	ResourceType *string

	// The status of the unsupported resource.
	UnsupportedResourceStatus *string

	noSmithyDocumentSerde
}

// Defines the operational recommendation item that needs a status update.
type UpdateRecommendationStatusItem struct {

	// Resource identifier of the operational recommendation item.
	ResourceId *string

	// Identifier of the target Amazon Web Services account.
	TargetAccountId *string

	// Identifier of the target Amazon Web Services Region.
	TargetRegion *string

	noSmithyDocumentSerde
}

// Defines the operational recommendation item that is to be included or excluded.
type UpdateRecommendationStatusRequestEntry struct {

	// An identifier for an entry in this batch that is used to communicate the
	// result. The entryId s of a batch request need to be unique within a request.
	//
	// This member is required.
	EntryId *string

	// Indicates if the operational recommendation needs to be excluded. If set to
	// True, the operational recommendation will be excluded.
	//
	// This member is required.
	Excluded *bool

	// The operational recommendation item.
	//
	// This member is required.
	Item *UpdateRecommendationStatusItem

	// Reference identifier of the operational recommendation item.
	//
	// This member is required.
	ReferenceId *string

	// Indicates the reason for excluding an operational recommendation.
	ExcludeReason ExcludeRecommendationReason

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
