# pytudes

"An *étude* (a French word meaning *study*) is an instrumental musical composition, usually short, of considerable difficulty, and designed to provide practice material for perfecting a particular musical skill." &mdash; [Wikipedia](https://en.wikipedia.org/wiki/%C3%89tude)

This project contains **pytudes**&mdash;Python programs for perfecting programming skills. 

Some are in Jupyter (IPython) notebooks, some in `.py` files. You can view the files here, or clone the project, or run the notebooks online by clicking this button: [![Binder](https://mybinder.org/badge.svg)](https://mybinder.org/v2/gh/norvig/pytudes/master)
 
# Index of Jupyter (IPython) Notebooks

|Logic and Number Puzzles|
|---|
|[Advent of Code 2017](https://github.com/norvig/pytudes/blob/master/ipynb/Advent%202017.ipynb)<br>*Puzzle site with a coding puzzle each day for Advent 2017.*|
|[Advent of Code 2016](https://github.com/norvig/pytudes/blob/master/ipynb/Advent%20of%20Code.ipynb)<br>*Puzzle site with a coding puzzle each day for Advent 2016*.|
|[The Devil and the Coin Flip Game](https://github.com/norvig/pytudes/blob/master/ipynb/Coin%20Flip.ipynb)<br>*How to beat the Devil at his own game.*|
|[Translating English Sentences into Propositional Logic Statements](https://github.com/norvig/pytudes/blob/master/ipynb/PropositionalLogic.ipynb)<br>*Automatically converting informal English sentences into formal Propositional Logic.*|
|[The Puzzle of the Misanthropic Neighbors](https://github.com/norvig/pytudes/blob/master/ipynb/Mean%20Misanthrope%20Density.ipynb)<br>*How crowded will this neighborhood be, if nobody wants to live next door to anyone else?*|
|[Countdown to 2016](https://github.com/norvig/pytudes/blob/master/ipynb/Countdown.ipynb)<br>*Solving the equation 10 _ 9 _ 8 _ 7 _ 6 _ 5 _ 4 _ 3 _ 2 _ 1 = 2016. From an Alex Bellos puzzle.*|
|[Sicherman Dice](https://github.com/norvig/pytudes/blob/master/ipynb/Sicherman%20Dice.ipynb)<br>*Find a pair of dice that is like a regular pair of dice, only different.*|
|[Beal's Conjecture Revisited](https://github.com/norvig/pytudes/blob/master/ipynb/Beal.ipynb)<br>*A search for counterexamples to Beal's Conjecture*|
|[When is Cheryl's Birthday?](https://github.com/norvig/pytudes/blob/master/ipynb/Cheryl.ipynb)<br>*Solving the "Cheryl's Birthday" logic puzzle.*|
|[When Cheryl Met Eve: A Birthday Story](https://github.com/norvig/pytudes/blob/master/ipynb/Cheryl-and-Eve.ipynb)<br>*Inventing new puzzles in the Style of Cheryl's Birthday.*|
|[Sol Golomb's Rectangle Puzzle](https://github.com/norvig/pytudes/blob/master/ipynb/Golomb-Puzzle.ipynb)<br>*A Puzzle involving placing rectangles of different sizes inside a square. Bonus: cryptarithmetic.*|
|[WWW: Will Warriors Win?](https://github.com/norvig/pytudes/blob/master/ipynb/WWW.ipynb)<br>*Golden State Warriors probability of winning the 2016 NBA title.*|
|[The Riddler: Battle Royale](https://github.com/norvig/pytudes/blob/master/ipynb/Riddler%20Battle%20Royale.ipynb)<br>*A puzzle involving allocating your troops and going up against an opponent.*|

|More Serious Math Stuff|
|---|
|[A Concrete Introduction to Probability](https://github.com/norvig/pytudes/blob/master/ipynb/Probability.ipynb)<br>*Code and examples of the basic principles of Probability Theory.*|
|[Probability, Paradox, and the Reasonable Person Principle](https://github.com/norvig/pytudes/blob/master/ipynb/ProbabilityParadox.ipynb)<br>*Some classic paradoxes in Probability Theory, and how to think about disagreements.*|
|[Symbolic Algebra, Simplification, and Differentiation](https://github.com/norvig/pytudes/blob/master/ipynb/Differentiation.ipynb)<br>*A computer algebra system that  manipulates expressions, including symbolic differentiation.*|
|[Economics Simulation](https://github.com/norvig/pytudes/blob/master/ipynb/Economics.ipynb)<br>*A simulation of a simple economic game.*|
|[How to Count Things](https://github.com/norvig/pytudes/blob/master/ipynb/How%20To%20Count%20Things.ipynb)<br>*Combinatorial math: how to count how many things there are, when there are a lot of them.*|

|Word Games|
|---|
|[Ghost](https://github.com/norvig/pytudes/blob/master/ipynb/Ghost.ipynb)<br>*The word game Ghost (add letters, try to avoid making a word).*|
|[World's Longest Palindrome](https://github.com/norvig/pytudes/blob/master/ipynb/pal3.ipynb)<br>*Searching for a long Panama-style palindrome, this time letter-by-letter.*|
|[Refactoring a Crossword Game Program](https://github.com/norvig/pytudes/blob/master/ipynb/Scrabble.ipynb)<br>*Refactoring the Scrabble / Word with Friends game from Udacity 212.*|
|[xkcd 1313: Regex Golf](https://github.com/norvig/pytudes/blob/master/ipynb/xkcd1313.ipynb)<br>*Find the smallest regular expression; inspired by Randall Monroe.*|
|[xkcd 1313: Regex Golf (Part 2: Infinite Problems)](https://github.com/norvig/pytudes/blob/master/ipynb/xkcd1313-part2.ipynb)<br>*Regex Golf: better, faster, funner. With Stefan Pochmann.*|
|[Let's Code About Bike Locks](https://github.com/norvig/pytudes/blob/master/ipynb/Fred%20Buns.ipynb)<br>*A tale of a bicycle combination lock that uses letters instead of digits. Inspired by Bike Snob NYC.*|
|[Gesture Typing](https://github.com/norvig/pytudes/blob/master/ipynb/Gesture%20Typing.ipynb)<br>*What word has the longest path on a gesture-typing smartphone keyboard?*|
|[How to Do Things with Words, or Statistical Natural Language Processing in Python](https://github.com/norvig/pytudes/blob/master/ipynb/How%20to%20Do%20Things%20with%20Words.ipynb)<br>*Spelling Correction, Secret Codes, Word Segmentation, and more: grab your bag of words.*|

|Computer Science Algorithms, Concepts, and Problems|
|---|
|[BASIC Interpreter](https://github.com/norvig/pytudes/blob/master/ipynb/BASIC.ipynb)<br>*How to write an interpreter for the BASIC programming language.*|
|[Bad Grade, Good Experience](https://github.com/norvig/pytudes/blob/master/ipynb/Snobol.ipynb)<br>*As a student, did you ever get a bad grade on a programming assignment? (Snobol, Concordance)*|
|[Conway's Game of Life](https://github.com/norvig/pytudes/blob/master/ipynb/Life.ipynb)<br>*The cellular automata zero-player game.*|
|[A Chaos Game with Triangles](https://github.com/norvig/pytudes/blob/master/ipynb/Sierpinski.ipynb)<br>*A surprising appearance of the Sierpinski triangle in a random walk between vertexes.*|
|[The Convex Hull Problem](https://github.com/norvig/pytudes/blob/master/ipynb/Convex%20Hull.ipynb)<br>*A classic Computer Science Algorithm.*|
|[The Traveling Salesperson Problem](https://github.com/norvig/pytudes/blob/master/ipynb/TSP.ipynb)<br>*Another of the classics.*|
|[Project Euler Utilities](https://github.com/norvig/pytudes/blob/master/ipynb/Project%20Euler%20Utils.ipynb)<br>*My utility functions for the Project Euler problems, including `Primes` and `Factors`.*|

# Index of Python Files

| **File** | **Description** | **Documentation**|
|:--------|:-------------------|----|
|[SET.py](https://github.com/norvig/pytudes/blob/master/py/SET.py)|Analyze the card game [SET](http://www.setgame.com/set).|[SET.html](http://norvig.com/SET.html)|
|[beal.py](https://github.com/norvig/pytudes/blob/master/py/beal.py)|Search for counterexamples to Beal's Conjecture|[beal.html](http://norvig.com/beal.html)
|[docex.py](https://github.com/norvig/pytudes/blob/master/py/docex.py)|A framework for running unit tests, similar to `doctest`.|
|[ibol.py](https://github.com/norvig/pytudes/blob/master/py/ibol.py)|An Exercise in Species Barcoding|[ibol.html](http://norvig.com/ibol.html)
|[lettercount.py](https://github.com/norvig/pytudes/blob/master/py/lettercount.py)|Convert Google Ngram Counts to Letter Counts|[mayzner.html](http://norvig.com/mayzner.html)
|[lis.py](https://github.com/norvig/pytudes/blob/master/py/lis.py)|Lisp Interpreter written in Python|[lispy.html](http://norvig.com/lispy.html)
|[lispy.py](https://github.com/norvig/pytudes/blob/master/py/lispy.py)|Even Better Lisp Interpreter written in Python|[lispy2.html](http://norvig.com/lispy2.html)
|[lispytest.py](https://github.com/norvig/pytudes/blob/master/py/lispytest.py)|Tests for Lisp Interpreters|
|[pal.py](https://github.com/norvig/pytudes/blob/master/py/pal.py)|Find long palindromes|[palindrome.html](http://norvig.com/palindrome.html)
|[pal2.py](https://github.com/norvig/pytudes/blob/master/py/pal2.py)|Find longer palindromes|[palindrome.html](http://norvig.com/palindrome.html)
|[pal3.py](https://github.com/norvig/pytudes/blob/master/py/pal3.py)|Find even longer palindromes|[palindrome.html](http://norvig.com/palindrome.html)
|[py2html.py](https://github.com/norvig/pytudes/blob/master/py/py2html.py)|Pretty-printer to format Python files as html|
|[spell.py](https://github.com/norvig/pytudes/blob/master/py/spell.py)|Spelling corrector|[spell-correct.html](http://norvig.com/spell-correct.html)
|[sudoku.py](https://github.com/norvig/pytudes/blob/master/py/sudoku.py)|Program to solve sudoku puzzles|[sudoku.html](http://norvig.com/sudoku.html)
|[testaccum.py](https://github.com/norvig/pytudes/blob/master/py/testaccum.py)|Tests for my failed Python `accumulation display` proposal|[pyacc.html](http://norvig.com/pyacc.html)
|[yaptu.py](https://github.com/norvig/pytudes/blob/master/py/yaptu.py)|Yet Another Python Templating Utility|

# Etudes for Programmers

I got the idea for the "etudes" part of the name from this [1978 book by Charles Wetherell](https://books.google.com/books/about/Etudes_for_programmers.html?id=u89WAAAAMAAJ)
that was very influential to me when I was first learning to program.

![](https://images-na.ssl-images-amazon.com/images/I/51ZnZH29dvL._SX394_BO1,204,203,200_.jpg)
