# labstack echo instrumentation example

An HTTP server using labstack echo and instrumentation. The server has a
`/users/:id` endpoint. The server generates span information to
`stdout`.

These instructions expect you have
[docker-compose](https://docs.docker.com/compose/) installed.

Bring up the `echo-server` and `echo-client` services to run the
example:

```sh
docker-compose up --detach echo-server echo-client
```

The `echo-client` service sends just one HTTP request to `echo-server`
and then exits. View the span generated by `echo-server` in the logs:

```sh
docker-compose logs echo-server
```

Shut down the services when you are finished with the example:

```sh
docker-compose down
```
